var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Horizontal Circular motion of mass on table/motion of mass.png"]="data:image/png;base64,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";
__base64Images["./Horizontal Circular motion of mass on table/2016-03-16_0943s.png"]="data:image/png;base64,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";
__base64Images["./Horizontal Circular motion of mass on table/Screenshot 2020-03-06 at 5.00.02 PM (2).png"]="data:image/png;base64,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";
