var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./BallAndBeam/BallAndBeamWCthumb.png"]="data:image/png;base64,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";
