var _isEPub = false;

var __base64Images = [];
__base64Images["./BlockAndSpringOnInclinedPlane/block_2013-12-20_1506.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./BlockAndSpringOnInclinedPlane/newton_law_eqn.gif"]="data:image/gif;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./Android_robot.svg.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAdCAYAAABfeMd1AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTFH80I3AAACl0lEQVRIS+1VvWsTYRgPdXJxEaGDjopjV538Kig6tEMHdbC4qqg4CQ7+AV1cBAU7KSRUkZLSRNO6VHImMY3aGqk1d7WWfuRKcxdz18SYvP5+R1IuaZJLLuAgHry8eZ/n95Hned97z+Np8ggh9meMbyvlculGMwzjzBNHfCtcwxxIe9e02LKivtbwuxfjIEY/xlBl5rqXeeKI79iEBBCHE98fCjU7vzn3Y7Q8s3BPTCdvCs5cM848nituDQ7ppiKF5q+Jp+FjTUfo83Whm0sSK+3IiG1IZz8qY9GzLQ2q5mPRcwJ4mby2jAD05PLrgRfvL1gGceWB1Z5G1TDOPHPEG+CR7/gAdDIqj+yIvkneFoFPVxuaMM589Q+Qh+eEo0mxZD72RfrbalN9deQVS9uPmh1XnqQeJtXsXKzVRjvlyK+czJ6d1uHHUbxMkqwGNbOg+oxCemVxY1y4HSb41KEedMPU92hGSvJGTlntmfhwWazrcVetqlZIvh86XHsjp4VmyGGPnA4Y9hbgDe7KpJ5PfZhMmrUmr7o0qeVT/79J05Yq6j/dLpSXs5+upc2prk5XPR/6P3Hjrk28jA9YwtPJW2JDn+3KhHzqUI+61OeddaBQ1Edx50RK5V/3VzPvUk73U6s8+dShHnSfUH/XhbmVW5CehY+7qoa8rdxXyfGqh/Pgl1Vv0Z+4iHIHa8yex86L8dkhwdleDXHEkwf+gKNJ5ZruA/hOdnt5se7KySN+F5uZt8eJIx6jry0DOyhjpKbsYrjsshDaw9keJ65j8Srhr5hophyqbVdQtypRg7o9rplKyHUlv0uFEX/ikrXJvsgZAbEZflI5+/BBYpx54lybQHAfP6XYaB1VvcX6cOVgHOGaceaJa2XyBwVrB+tcZqhVAAAAAElFTkSuQmCC";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./BlockAndSpringOnInclinedPlane/block_2013-12-20_1506320by180.png"]="data:image/png;base64,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";
__base64Images["./BlockAndSpringOnInclinedPlane/1authorlookangphoto.png"]="data:image/png;base64,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";
__base64Images["./BlockAndSpringOnInclinedPlane/static_friction_eqn.gif"]="data:image/gif;base64,R0lGODlhrAAYAPAAAP///wAAACwAAAAArAAYAAAC/4SPqcvtD6OctNqLs968+w+G4kiW5omWwZq2brsGkQzQ7xMjsX33tcFrBH0O1mFIhOlwydnv2LwFkcCcdMmQ2agUHtIInu4U1qOxeoaqiz0ve7txZ3/aZw2ewNtpevSY3bHztyA39/QlmIYFNMfHt2bHqDYVmWcJeAV5eRi3mIdXOPR1qShpKtTmSQbFJVG4aio2CgtJqUrokVh62gpHpTt7utlXeVtpywvRquJnaNZ5t6tXJ0w7HUvqVHXHHcaN8efdXF0RvvUY61VGplg2aLZcq0XNGY9JS9I7cbbuY/voTsMye+CUucL3At2kbfUycKEnQh/BNLtS9MvBAtg3CxkPCRYU4jFaxSgkS5o8iTKlypUsW7p8aaIAACH/C01hdGhUeXBlMDAx/wUBAAYGRFNNVDYAABNXaW5BbGxCYXNpY0NvZGVQYWdlcwARBVRpbWVzIE5ldyBSb21hbgARA1N5bWJvbAARBUNvdXJpZXIgTmV3ABEETVQgRXh0cmEAEgAIIS9Fj0QvQVD0EA9HX0FQ8h8eQVD0FQ9BAPRF9CX0j0JfQQD0EA9DX0EA9I9F9CpfSPSPQQD0EA9A9I9Bf0j0EA9BKl9EX0X0X0X0X0EPDAEAAQABAgICAgACAAEBAQADAAEABAAACQCgAQACAINmAAMAGwAACQGgAQACAoJtAAIAgmEAAgCCeAAAAQEACQCgAgSGPQA9AgSEvANtAwAbAAAJAaABAFQCAINzAAABAQAJAKACAINOAAIEhj0APQIEhLwDbQMAGwAACQGgAQACAINzAAABAQAJAKACAINtAAIAg2cAAgKCYwACAIJvAAIAgnMAAgSEuANxAAAAIf8LTWF0aFR5cGUwMDP/PCEtLSBNYXRoVHlwZUBUcmFuc2xhdG9yQDVANUBNYXRoTUwyIChDbGlwYm9hcmQpLnRkbEBNYXRoTUwgMi4wIChDbGlwYm9hcmQpQCAtLT48P3htbCB2ZXJzaW9uPSIxLjAiPz48bWF0aCBkaXNwbGF5PSdibG9jaycgeG1sbnM9J2h0dHA6Ly93d3cudzMub3JnLzE5OTgvTWF0aC9NYXRoTUwnPjxtcm93Pjxtc3ViPjxtaT5mPC9taT48bXJvdz48bWk+bWF4PC9taT48L21yb3c+PC9tc3ViPjxtbz49PC9tbz48bXN1Yj48bWk+JiN4MDNCQzs8L21pPjxtpGk+czwvbWk+PC9tc3ViPjxtaT5OPC9taT48bW8+PTwvbW8+PG1zdWI+PG1pPiYjeDAzQkM7PC9taT48bWk+czwvbWk+PC9tc3ViPjxtaT5tPC9taT48bWk+ZzwvbWk+PG1pPmNvczwvbWk+PG1pPiYjeDAzQjg7PC9taT48L21yb3c+PC9tYXRoPjwhLS0gTWF0aFR5cGVARW5kQDVANUAgLS0+ACH/C01hdGhUeXBlMDAyBggAAAAAAAA7";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["./BlockAndSpringOnInclinedPlane/block_on_incline.jpg"]="data:image/jpeg;base64,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";
__base64Images["./BlockAndSpringOnInclinedPlane/01authorwc_icon.png"]="data:image/png;base64,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";
__base64Images["./BlockAndSpringOnInclinedPlane/lookangphoto.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
