/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import java.util.TreeMap;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;

public class UserFunction
implements KnownFunction,
MultiVarFunction,
Cloneable {
    protected static String[] dummyVars = new String[]{"'", "@", "`", "~", "#"};
    protected String name;
    protected String[] paramNames = new String[0];
    protected double[] paramValues = new double[0];
    protected String[] paramDescriptions = new String[0];
    protected String[] functionNames = new String[0];
    protected String expression = "0";
    protected String inputString = "0";
    protected ParsedMultiVarFunction function = null;
    protected String[] vars = new String[]{"x"};
    protected UserFunction[] references = new UserFunction[0];
    protected boolean nameEditable = true;
    protected String description;
    protected KnownPolynomial polynomial;

    public UserFunction(String name) {
        this.setName(name);
        try {
            this.function = new ParsedMultiVarFunction("0", new String[0]);
            this.functionNames = this.function.getFunctionNames();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    public UserFunction(KnownPolynomial poly) {
        this(poly.getName());
        this.polynomial = poly;
        this.setName(poly.getName());
        this.setDescription(poly.getDescription());
        String[] params = new String[poly.getParameterCount()];
        double[] paramValues = new double[poly.getParameterCount()];
        String[] desc = new String[poly.getParameterCount()];
        int i = 0;
        while (i < params.length) {
            params[i] = poly.getParameterName(i);
            paramValues[i] = poly.getParameterValue(i);
            desc[i] = poly.getParameterDescription(i);
            ++i;
        }
        this.setParameters(params, paramValues, desc);
        this.setExpression(poly.getExpression("x"), new String[]{"x"});
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!this.isNameEditable()) {
            return;
        }
        this.name = name;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean editable) {
        this.nameEditable = editable;
    }

    public String getIndependentVariable() {
        return this.vars[0];
    }

    public String[] getIndependentVariables() {
        return this.vars;
    }

    public String getInputString() {
        String s = this.inputString;
        int i = 0;
        while (i < this.vars.length) {
            s = s.replaceAll(dummyVars[i], this.vars[i]);
            ++i;
        }
        return s;
    }

    public String getExpression() {
        String s = this.expression;
        int i = 0;
        while (i < this.vars.length) {
            s = s.replaceAll(dummyVars[i], this.vars[i]);
            ++i;
        }
        return s;
    }

    @Override
    public String getExpression(String indepVarName) {
        this.vars = new String[]{indepVarName};
        return this.getExpression();
    }

    public String getExpression(String[] varNames) {
        this.vars = varNames;
        return this.getExpression();
    }

    public String getFullExpression(String[] varNames) {
        String s = this.getExpression(varNames);
        UserFunction[] userFunctionArray = this.references;
        int n = this.references.length;
        int n2 = 0;
        while (n2 < n) {
            UserFunction f = userFunctionArray[n2];
            s = s.replaceAll(f.getName(), "(" + f.getFullExpression(varNames) + ")");
            ++n2;
        }
        return s;
    }

    public boolean setExpression(String exp, String[] varNames) {
        this.vars = varNames;
        String[] names = new String[this.references.length + this.paramNames.length + this.vars.length];
        int i = 0;
        while (i < this.paramNames.length) {
            names[i + this.vars.length] = this.paramNames[i];
            ++i;
        }
        i = 0;
        while (i < this.references.length) {
            names[i + this.vars.length + this.paramNames.length] = this.references[i].getName();
            ++i;
        }
        ArrayList<String> sorted = new ArrayList<String>();
        sorted.add(this.vars[0]);
        int i2 = 1;
        while (i2 < this.vars.length) {
            int size = sorted.size();
            int j = 0;
            while (j < size) {
                if (this.vars[i2].length() > ((String)sorted.get(j)).toString().length()) {
                    sorted.add(j, this.vars[i2]);
                    break;
                }
                if (j == size - 1) {
                    sorted.add(this.vars[i2]);
                }
                ++j;
            }
            ++i2;
        }
        int k = 0;
        while (k < sorted.size()) {
            String next = ((String)sorted.get(k)).toString();
            int i3 = 0;
            while (i3 < this.vars.length) {
                if (next.equals(this.vars[i3])) {
                    exp = exp.replaceAll(this.vars[i3], dummyVars[i3]);
                    names[i3] = dummyVars[i3];
                    int j = this.vars.length;
                    while (j < names.length) {
                        names[j] = names[j].replaceAll(this.vars[i3], dummyVars[i3]);
                        ++j;
                    }
                    j = 0;
                    while (j < this.functionNames.length) {
                        String modified = this.functionNames[j].replaceAll(this.vars[i3], dummyVars[i3]);
                        if (!modified.equals(this.functionNames[j])) {
                            exp = exp.replaceAll(modified, this.functionNames[j]);
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            ++k;
        }
        i2 = 0;
        while (i2 < this.paramNames.length) {
            exp = exp.replaceAll(names[this.vars.length + i2], this.paramNames[i2]);
            names[this.vars.length + i2] = this.paramNames[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.references.length) {
            exp = exp.replaceAll(names[this.vars.length + this.paramNames.length + i2], this.references[i2].getName());
            names[this.vars.length + this.paramNames.length + i2] = this.references[i2].getName();
            ++i2;
        }
        this.inputString = exp;
        try {
            this.function = new ParsedMultiVarFunction(exp, names);
            if (exp.indexOf("=") == -1) {
                this.expression = exp;
                return true;
            }
        }
        catch (ParserException ex) {
            try {
                this.function = new ParsedMultiVarFunction("0", names);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            this.expression = "0";
        }
        return false;
    }

    @Override
    public int getParameterCount() {
        return this.paramNames.length;
    }

    @Override
    public String getParameterName(int i) {
        return this.paramNames[i];
    }

    @Override
    public double getParameterValue(int i) {
        return this.paramValues[i];
    }

    @Override
    public void setParameterValue(int i, double value) {
        this.paramValues[i] = value;
    }

    public void setParameters(String[] names, double[] values) {
        this.paramNames = names;
        this.paramValues = values;
    }

    @Override
    public void setParameters(String[] names, double[] values, String[] descriptions) {
        this.paramNames = names;
        this.paramValues = values;
        if (descriptions != null) {
            this.paramDescriptions = descriptions;
        }
    }

    public void updateReferenceParameters() {
        UserFunction[] userFunctionArray = this.references;
        int n = this.references.length;
        int n2 = 0;
        while (n2 < n) {
            UserFunction next = userFunctionArray[n2];
            next.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
            next.updateReferenceParameters();
            ++n2;
        }
    }

    public void setReferences(UserFunction[] functions) {
        this.references = functions;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public String getParameterDescription(int i) {
        if (i >= this.paramDescriptions.length) {
            return null;
        }
        return this.paramDescriptions[i];
    }

    @Override
    public double evaluate(double x) {
        if (this.function == null) {
            return Double.NaN;
        }
        double[] supportValues = this.evaluateSupportFunctions(x);
        int n = supportValues.length + this.paramValues.length + 1;
        double[] values = new double[n];
        values[0] = x;
        System.arraycopy(this.paramValues, 0, values, 1, this.paramValues.length);
        System.arraycopy(supportValues, 0, values, 1 + this.paramValues.length, supportValues.length);
        return this.function.evaluate(values);
    }

    @Override
    public double evaluate(double[] x) {
        if (this.function == null) {
            return Double.NaN;
        }
        double[] support = this.evaluateSupportFunctions(x);
        int n = support.length + this.paramValues.length + x.length;
        double[] values = new double[n];
        System.arraycopy(x, 0, values, 0, x.length);
        System.arraycopy(this.paramValues, 0, values, x.length, this.paramValues.length);
        System.arraycopy(support, 0, values, x.length + this.paramValues.length, support.length);
        return this.function.evaluate(values);
    }

    public boolean evaluatedToNaN() {
        return this.function == null ? false : this.function.evaluatedToNaN();
    }

    @Override
    public UserFunction clone() {
        UserFunction f = new UserFunction(this.name);
        f.setDescription(this.description);
        f.setNameEditable(this.nameEditable);
        f.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
        UserFunction[] refs = new UserFunction[this.references.length];
        int i = 0;
        while (i < refs.length) {
            refs[i] = this.references[i].clone();
            ++i;
        }
        f.setReferences(refs);
        f.setExpression(this.inputString, this.vars);
        f.polynomial = this.polynomial == null ? null : this.polynomial.clone();
        return f;
    }

    @Override
    public boolean equals(Object f) {
        if (!(f instanceof UserFunction)) {
            return false;
        }
        UserFunction uf = (UserFunction)f;
        if (!this.getName().equals(uf.getName())) {
            return false;
        }
        if (!this.getInputString().equals(uf.getInputString())) {
            return false;
        }
        int n = this.getParameterCount();
        if (n != uf.getParameterCount()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (!this.getParameterName(i).equals(uf.getParameterName(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean updatePolynomial() {
        if (this.polynomial == null) {
            return false;
        }
        this.polynomial.setName(this.getName());
        this.polynomial.setDescription(this.getDescription());
        this.polynomial.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
        return true;
    }

    protected String replaceParameterNameInExpression(String oldName, String newName) {
        String[] varNames = this.getIndependentVariables();
        String expression = this.getInputString();
        TreeMap<String, String> replacements = new TreeMap<String, String>();
        if ((expression = this.replaceInExpression(oldName, newName, expression, replacements)) == null) {
            return null;
        }
        for (String key : replacements.keySet()) {
            if (key.equals(newName)) continue;
            expression = expression.replaceAll(key, replacements.get(key));
        }
        if (this.setExpression(expression, varNames)) {
            return expression;
        }
        return null;
    }

    private String replaceInExpression(String oldName, String newName, String expression, TreeMap<String, String> replacements) {
        if (replacements.values().contains(oldName)) {
            return expression;
        }
        int i = 0;
        while (i < this.getParameterCount()) {
            String nextParam = this.getParameterName(i);
            if (!oldName.equals(nextParam) && !newName.equals(nextParam) && nextParam.contains(oldName)) {
                int k = 0;
                int j = 0;
                while (j < dummyVars.length) {
                    if (dummyVars[j].equals(newName)) {
                        k = j + 1;
                        break;
                    }
                    ++j;
                }
                if (k >= dummyVars.length) {
                    return null;
                }
                if ((expression = this.replaceInExpression(nextParam, dummyVars[k], expression, replacements)) == null) {
                    return null;
                }
            }
            ++i;
        }
        expression = expression.replaceAll(oldName, newName);
        replacements.put(newName, oldName);
        return expression;
    }

    protected double[] evaluateSupportFunctions(double x) {
        double[] values = new double[this.references.length];
        int i = 0;
        while (i < values.length) {
            values[i] = this.references[i].evaluate(x);
            ++i;
        }
        return values;
    }

    protected double[] evaluateSupportFunctions(double[] x) {
        double[] values = new double[this.references.length];
        int i = 0;
        while (i < values.length) {
            values[i] = this.references[i].evaluate(x);
            ++i;
        }
        return values;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            UserFunction f = (UserFunction)obj;
            control.setValue("name", f.getName());
            control.setValue("description", f.getDescription());
            control.setValue("name_editable", f.isNameEditable());
            control.setValue("parameter_names", f.paramNames);
            control.setValue("parameter_values", f.paramValues);
            control.setValue("parameter_descriptions", f.paramDescriptions);
            control.setValue("variables", f.getIndependentVariables());
            control.setValue("expression", f.getInputString());
            if (f.polynomial != null) {
                control.setValue("polynomial", f.polynomial.getCoefficients());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            return new UserFunction(name);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String[] vars;
            String[] names;
            UserFunction f = (UserFunction)obj;
            f.setName(control.getString("name"));
            f.setDescription(control.getString("description"));
            if (control.getPropertyNames().contains("name_editable")) {
                f.setNameEditable(control.getBoolean("name_editable"));
            }
            if ((names = (String[])control.getObject("parameter_names")) != null) {
                double[] values = (double[])control.getObject("parameter_values");
                String[] desc = (String[])control.getObject("parameter_descriptions");
                f.setParameters(names, values, desc);
            }
            if ((vars = (String[])control.getObject("variables")) == null) {
                String var = control.getString("variable");
                vars = new String[]{var};
            }
            f.setExpression(control.getString("expression"), vars);
            double[] coeff = (double[])control.getObject("polynomial");
            if (coeff != null) {
                f.polynomial = new KnownPolynomial(coeff);
            }
            return obj;
        }
    }
}

