/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.text.DecimalFormatSymbols;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.FunctionEditor;

public class Parameter {
    final String paramName;
    final String expression;
    String description;
    double value = Double.NaN;
    boolean expressionEditable = true;
    boolean nameEditable = true;

    public Parameter(String name, String function) {
        this.paramName = name;
        this.expression = function;
    }

    public Parameter(String name, String function, String desc) {
        this(name, function);
        this.setDescription(desc);
    }

    public String getName() {
        return this.paramName;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isExpressionEditable() {
        return this.expressionEditable;
    }

    public void setExpressionEditable(boolean edit) {
        this.expressionEditable = edit;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean edit) {
        this.nameEditable = edit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            Parameter p = (Parameter)obj;
            return p.getName().equals(this.paramName) && p.getExpression().equals(this.expression) && p.isExpressionEditable() == this.expressionEditable && p.isNameEditable() == this.nameEditable;
        }
        return false;
    }

    protected double evaluate(List<?> parameters) {
        int n = parameters.contains(this) ? parameters.size() - 1 : parameters.size();
        Parameter[] array = new Parameter[n];
        int j = 0;
        int i = 0;
        while (i < parameters.size()) {
            Parameter next = (Parameter)parameters.get(i);
            if (next != this) {
                array[j++] = next;
            }
            ++i;
        }
        return this.evaluate(array);
    }

    public double evaluate(Parameter[] parameters) {
        int n = parameters.length;
        String[] names = new String[n];
        double[] values = new double[n];
        int i = 0;
        while (i < n) {
            names[i] = parameters[i].paramName;
            values[i] = parameters[i].value;
            ++i;
        }
        try {
            String express = this.expression;
            DecimalFormatSymbols symbols = FunctionEditor.sciFormat.getDecimalFormatSymbols();
            char separator = symbols.getDecimalSeparator();
            if (separator != '.' && express.indexOf("if") == -1) {
                int j = express.indexOf(separator);
                while (j > -1) {
                    express = String.valueOf(express.substring(0, j)) + '.' + express.substring(j + 1);
                    j = express.indexOf(separator);
                }
            }
            ParsedMultiVarFunction f = new ParsedMultiVarFunction(express, names);
            this.value = f.evaluate(values);
        }
        catch (ParserException ex) {
            this.value = Double.NaN;
        }
        return this.value;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Parameter p = (Parameter)obj;
            control.setValue("name", p.getName());
            control.setValue("function", p.getExpression());
            control.setValue("editable", p.isExpressionEditable());
            control.setValue("name_editable", p.isNameEditable());
            control.setValue("description", p.getDescription());
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            String f = control.getString("function");
            return new Parameter(name, f);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Parameter p = (Parameter)obj;
            if (control.getPropertyNames().contains("editable")) {
                p.setExpressionEditable(control.getBoolean("editable"));
            }
            if (control.getPropertyNames().contains("name_editable")) {
                p.setNameEditable(control.getBoolean("name_editable"));
            }
            p.setDescription(control.getString("description"));
            return obj;
        }
    }
}

