/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FunctionEditor
extends JPanel
implements PropertyChangeListener {
    public static final String THETA = TeXParser.parseTeX("$\\theta$");
    public static final String OMEGA = TeXParser.parseTeX("$\\omega$");
    public static final String DEGREES = "\ufffd";
    public static final int ADD_EDIT = 0;
    public static final int REMOVE_EDIT = 1;
    public static final int NAME_EDIT = 2;
    public static final int EXPRESSION_EDIT = 3;
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    static final Color MEDIUM_RED = new Color(255, 160, 180);
    static final Color LIGHT_RED = new Color(255, 180, 200);
    static final Color LIGHT_GRAY = UIManager.getColor("Panel.background");
    static final Color DARK_RED = new Color(220, 0, 0);
    static NumberFormat decimalFormat;
    static DecimalFormat sciFormat;
    protected static boolean undoEditsEnabled;
    protected static String[] editTypes;
    static FontRenderContext frc;
    protected ParamEditor paramEditor;
    protected ArrayList<Object> objects = new ArrayList();
    protected String[] names = new String[0];
    protected ArrayList<Object> sortedObjects = new ArrayList();
    protected HashSet<String> forbiddenNames = new HashSet();
    protected boolean removablesAtTop = false;
    protected Collection<Object> circularErrors = new HashSet<Object>();
    protected Collection<Object> errors = new HashSet<Object>();
    protected List<Object> evaluate = new ArrayList<Object>();
    protected Table table;
    protected TableModel tableModel = new TableModel();
    protected CellEditor tableCellEditor = new CellEditor();
    protected CellRenderer tableCellRenderer = new CellRenderer();
    protected JScrollPane tableScroller;
    protected JButton newButton;
    protected JButton cutButton;
    protected JButton copyButton;
    protected JButton pasteButton;
    protected JPanel buttonPanel;
    protected JLabel dragLabel;
    protected TitledBorder titledBorder;
    protected FunctionPanel functionPanel;
    protected AbstractButton[] customButtons;
    protected boolean anglesInDegrees;
    protected boolean usePopupEditor = true;
    protected boolean confirmChanges = true;

    static {
        undoEditsEnabled = true;
        editTypes = new String[]{"add row", "delete row", "edit name", "edit expression"};
        frc = new FontRenderContext(null, false, false);
        decimalFormat = NumberFormat.getInstance();
        decimalFormat.setMaximumFractionDigits(4);
        decimalFormat.setMinimumFractionDigits(0);
        decimalFormat.setMaximumIntegerDigits(3);
        decimalFormat.setMinimumIntegerDigits(1);
        sciFormat = new DecimalFormat("0.0000E0");
    }

    public FunctionEditor() {
        super(new BorderLayout());
        this.createGUI();
        this.refreshGUI();
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.table.getPreferredSize();
        dim.height += this.table.getTableHeader().getHeight();
        dim.height += this.buttonPanel.getPreferredSize().height;
        dim.height = (int)((double)dim.height + (1.25 * (double)this.table.getRowHeight() + 14.0));
        return dim;
    }

    public void setObjects(List<Object> newObjects) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        this.objects.clear();
        this.objects.addAll(newObjects);
        this.evaluateAll();
        this.tableModel.fireTableStructureChanged();
        if (row < this.table.getRowCount()) {
            this.table.rowToSelect = row;
            this.table.columnToSelect = col;
        }
        this.table.requestFocusInWindow();
        this.refreshGUI();
    }

    public List<Object> getObjects() {
        return new ArrayList<Object>(this.objects);
    }

    public String[] getNames() {
        return this.names;
    }

    public String getName(Object obj) {
        return null;
    }

    public String getExpression(Object obj) {
        return null;
    }

    public String getDescription(Object obj) {
        return null;
    }

    public void setDescription(Object obj, String desc) {
        if (obj instanceof Parameter) {
            this.firePropertyChange("param_description", null, null);
        }
        this.firePropertyChange("description", null, null);
    }

    public String getTooltip(Object obj) {
        return null;
    }

    public Object getObject(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        for (Object next : this.objects) {
            if (!name.equals(this.getName(next))) continue;
            return next;
        }
        return null;
    }

    public void setExpression(String name, String expression, boolean postEdit) {
        if (name == null || name.equals("")) {
            return;
        }
        int row = 0;
        while (row < this.objects.size()) {
            Object obj = this.objects.get(row);
            if (name.equals(this.getName(obj)) && !this.getExpression(obj).equals(expression)) {
                String prev = this.getExpression(obj);
                obj = this.createObject(name, expression, obj);
                this.objects.remove(row);
                this.objects.add(row, obj);
                this.evaluateAll();
                this.tableModel.fireTableStructureChanged();
                if (row >= 0) {
                    this.table.changeSelection(row, 1, false, false);
                }
                UndoableEdit edit = null;
                if (postEdit && undoEditsEnabled) {
                    edit = this.getUndoableEdit(3, expression, row, 1, prev, row, 1, this.getName(obj));
                }
                this.firePropertyChange("edit", this.getName(obj), edit);
            }
            ++row;
        }
    }

    public boolean getConfirmChanges() {
        return this.confirmChanges;
    }

    public void setConfirmChanges(boolean confirm) {
        this.confirmChanges = confirm;
    }

    public Object addObject(Object obj, boolean postEdit) {
        if (obj == null) {
            return null;
        }
        int row = this.objects.size();
        if (this.isRemovable(obj)) {
            if (this.removablesAtTop) {
                row = this.getRemovableRowCount();
            }
        } else if (!this.removablesAtTop) {
            row -= this.getRemovableRowCount();
        }
        return this.addObject(obj, row, postEdit, true);
    }

    public Object addObject(Object obj, int row, boolean postEdit, boolean firePropertyChange) {
        if ((obj = this.createUniqueObject(obj, this.getName(obj), this.confirmChanges)) == null) {
            return null;
        }
        int undoRow = this.table.getSelectedRow();
        int undoCol = this.table.getSelectedColumn();
        ArrayList<Object> newObjects = new ArrayList<Object>(this.objects);
        newObjects.add(row, obj);
        this.setObjects(newObjects);
        this.table.columnToSelect = 0;
        this.table.rowToSelect = row;
        this.table.selectOnFocus = true;
        this.table.requestFocusInWindow();
        UndoableEdit edit = null;
        if (postEdit && undoEditsEnabled) {
            edit = this.getUndoableEdit(0, obj, row, 0, obj, undoRow, undoCol, this.getName(obj));
        }
        if (firePropertyChange) {
            this.firePropertyChange("edit", this.getName(obj), edit);
        }
        this.refreshGUI();
        return obj;
    }

    public Object removeObject(Object obj, boolean postEdit) {
        if (obj == null || !this.isRemovable(obj)) {
            return null;
        }
        int undoCol = this.table.getSelectedColumn();
        int undoRow = 0;
        while (undoRow < this.objects.size()) {
            Object next = this.objects.get(undoRow);
            if (next.equals(obj)) {
                int row;
                this.objects.remove(obj);
                this.tableModel.fireTableStructureChanged();
                int n = row = undoRow == this.objects.size() ? undoRow - 1 : undoRow;
                if (row >= 0) {
                    this.table.changeSelection(row, 0, false, false);
                }
                UndoableEdit edit = null;
                if (postEdit) {
                    edit = this.getUndoableEdit(1, obj, row, 0, obj, undoRow, undoCol, this.getName(obj));
                }
                this.evaluateAll();
                this.firePropertyChange("edit", this.getName(obj), edit);
                this.refreshGUI();
            }
            ++undoRow;
        }
        return obj;
    }

    public void refreshStrings() {
        this.refreshGUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("focus") || name.equals("edit")) {
            this.table.clearSelection();
            this.table.rowToSelect = 0;
            this.table.columnToSelect = 0;
            this.table.selectOnFocus = false;
            this.refreshButtons();
        } else if (e.getPropertyName().equals("clipboard")) {
            this.refreshButtons();
        }
    }

    public void setCustomButtons(AbstractButton[] buttons) {
        this.customButtons = buttons;
        if (buttons == null || buttons.length == 0) {
            this.remove(this.buttonPanel);
            return;
        }
        this.buttonPanel.removeAll();
        int i = 0;
        while (i < buttons.length) {
            this.buttonPanel.add(buttons[i]);
            ++i;
        }
        this.add((Component)this.buttonPanel, "North");
    }

    public void setUsePopupEditor(boolean popup) {
        this.usePopupEditor = popup;
    }

    protected UndoableEdit getUndoableEdit(int type, Object redo, int redoRow, int redoCol, Object undo, int undoRow, int undoCol, String name) {
        if (type == 3) {
            ArrayList<AbstractButton> selectedButtons = new ArrayList<AbstractButton>();
            undo = new Object[]{undo, selectedButtons};
            redo = new Object[]{redo, selectedButtons};
            if (this.customButtons != null) {
                AbstractButton[] abstractButtonArray = this.customButtons;
                int n = this.customButtons.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractButton b = abstractButtonArray[n2];
                    if (b.isSelected()) {
                        selectedButtons.add(b);
                    }
                    ++n2;
                }
            }
        }
        return new DefaultEdit(type, redo, redoRow, redoCol, undo, undoRow, undoCol, name);
    }

    public boolean isNameEditable(Object obj) {
        return true;
    }

    public boolean isExpressionEditable(Object obj) {
        return true;
    }

    protected boolean isRemovable(Object obj) {
        return !this.isImportant(obj) && this.isNameEditable(obj) && this.isExpressionEditable(obj);
    }

    protected boolean isImportant(Object obj) {
        return false;
    }

    public void setAnglesInDegrees(boolean degrees) {
        this.anglesInDegrees = degrees;
        this.table.repaint();
    }

    public void evaluateAll() {
        String name;
        if (this.names.length != this.objects.size()) {
            this.names = new String[this.objects.size()];
        }
        int i = 0;
        while (i < this.names.length) {
            this.names[i] = this.getName(this.objects.get(i));
            ++i;
        }
        this.sortedObjects.clear();
        if (this.objects.size() > 0) {
            this.sortedObjects.add(this.objects.get(0));
            i = 1;
            while (i < this.objects.size()) {
                int size = this.sortedObjects.size();
                int j = 0;
                while (j < size) {
                    Object obj = this.objects.get(i);
                    name = this.getName(obj);
                    if (name.length() > this.getName(this.sortedObjects.get(j)).length()) {
                        this.sortedObjects.add(j, obj);
                        break;
                    }
                    if (j == size - 1) {
                        this.sortedObjects.add(obj);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.circularErrors.clear();
        for (Object next : this.objects) {
            String name2 = this.getName(next);
            if (!this.getReferences(name2, null).contains(name2)) continue;
            this.circularErrors.add(next);
        }
        this.errors.clear();
        block4: for (Object next : this.objects) {
            String name3 = this.getName(next);
            Iterator<Object> it2 = this.circularErrors.iterator();
            while (it2.hasNext()) {
                String badName = this.getName(it2.next());
                if (!this.getReferences(name3, null).contains(badName)) continue;
                this.errors.add(next);
                continue block4;
            }
        }
        this.evaluate.clear();
        ArrayList<Object> temp = new ArrayList<Object>(this.objects);
        temp.removeAll(this.errors);
        ArrayList<String> names = new ArrayList<String>();
        while (!temp.isEmpty()) {
            int i2 = 0;
            while (i2 < temp.size()) {
                Object next = temp.get(i2);
                name = this.getName(next);
                Set<String> references = this.getReferences(name, null);
                if (names.containsAll(references)) {
                    this.evaluate.add(next);
                    names.add(name);
                }
                ++i2;
            }
            temp.removeAll(this.evaluate);
        }
    }

    protected Set<String> getReferences(String name, Set<String> references) {
        Object obj;
        if (references == null) {
            references = new HashSet<String>();
        }
        if ((obj = this.getObject(name)) != null) {
            String eqn = this.getExpression(obj);
            ArrayList<Object> directReferences = new ArrayList<Object>();
            for (Object next : this.sortedObjects) {
                if (next == obj || eqn.indexOf(name = this.getName(next)) <= -1) continue;
                eqn = eqn.replaceAll(name, "#");
                directReferences.add(next);
                if (references.contains(name)) continue;
                references.add(name);
                references.addAll(this.getReferences(name, references));
            }
            this.setReferences(obj, directReferences);
        }
        return references;
    }

    protected void setReferences(Object obj, List<Object> referencedObjects) {
    }

    protected void createGUI() {
        this.titledBorder = BorderFactory.createTitledBorder("");
        this.setBorder(this.titledBorder);
        this.table = new Table(this.tableModel);
        this.tableScroller = new JScrollPane(this.table);
        this.tableScroller.createHorizontalScrollBar();
        this.add((Component)this.tableScroller, "Center");
        this.buttonPanel = new JPanel(new FlowLayout());
        this.newButton = new JButton();
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = FunctionEditor.this.getDefaultName();
                Object obj = FunctionEditor.this.createUniqueObject(null, name, false);
                FunctionEditor.this.addObject(obj, true);
            }
        });
        this.cutButton = new JButton();
        this.cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] array = FunctionEditor.this.getSelectedObjects();
                FunctionEditor.this.copy(array);
                int i = array.length;
                while (i > 0) {
                    FunctionEditor.this.removeObject(array[i - 1], true);
                    --i;
                }
                FunctionEditor.this.evaluateAll();
            }
        });
        this.copyButton = new JButton();
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionEditor.this.copy(FunctionEditor.this.getSelectedObjects());
            }
        });
        this.pasteButton = new JButton();
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionEditor.this.paste();
            }
        });
        this.buttonPanel.add(this.newButton);
        this.buttonPanel.add(this.copyButton);
        this.buttonPanel.add(this.cutButton);
        this.buttonPanel.add(this.pasteButton);
        this.add((Component)this.buttonPanel, "North");
        MouseAdapter tableFocuser = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FunctionEditor.this.table.requestFocusInWindow();
                FunctionEditor.this.functionPanel.clearSelection();
            }
        };
        this.table.getTableHeader().addMouseListener(tableFocuser);
        this.tableScroller.addMouseListener(tableFocuser);
        this.buttonPanel.addMouseListener(tableFocuser);
        this.buttonPanel.addMouseListener(tableFocuser);
        this.addMouseListener(tableFocuser);
    }

    protected void refreshGUI() {
        int[] rows = this.table.getSelectedRows();
        int col = this.table.getSelectedColumn();
        this.tableModel.fireTableStructureChanged();
        this.revalidate();
        int i = 0;
        while (i < rows.length) {
            this.table.addRowSelectionInterval(rows[i], rows[i]);
            ++i;
        }
        if (rows.length > 0) {
            this.table.setColumnSelectionInterval(col, col);
            this.table.requestFocusInWindow();
        }
        this.newButton.setText(ToolsRes.getString("FunctionEditor.Button.New"));
        this.newButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.New.Tooltip"));
        this.cutButton.setText(ToolsRes.getString("FunctionEditor.Button.Cut"));
        this.cutButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Cut.Tooltip"));
        this.copyButton.setText(ToolsRes.getString("FunctionEditor.Button.Copy"));
        this.copyButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Copy.Tooltip"));
        this.pasteButton.setText(ToolsRes.getString("FunctionEditor.Button.Paste"));
        this.pasteButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Paste.Tooltip"));
        this.titledBorder.setTitle(ToolsRes.getString("FunctionEditor.Border.Title"));
        this.refreshButtons();
    }

    public void setBorderTitle(String title) {
        this.titledBorder.setTitle(title);
    }

    protected void refreshButtons() {
        boolean b = this.getSelectedObject() != null;
        this.copyButton.setEnabled(b);
        this.cutButton.setEnabled(b && this.isRemovable(this.getSelectedObject()));
        this.pasteButton.setEnabled(this.getClipboardContents() != null);
    }

    protected ParamEditor getParamEditor() {
        return this.paramEditor;
    }

    protected void setParamEditor(ParamEditor editor) {
        if (this.paramEditor == null && editor != null) {
            this.paramEditor = editor;
            this.evaluateAll();
            this.refreshGUI();
        }
    }

    protected String getDefaultName() {
        return ToolsRes.getString("FunctionEditor.New.Name.Default");
    }

    protected String getVariablesString(String separator) {
        StringBuffer vars = new StringBuffer("");
        int init = vars.length();
        boolean firstItem = true;
        String nameToSkip = this.getName(this.getSelectedObject());
        int i = 0;
        while (i < this.names.length) {
            if (!this.names[i].equals(nameToSkip)) {
                if (!firstItem) {
                    vars.append(" ");
                }
                vars.append(this.names[i]);
                firstItem = false;
            }
            ++i;
        }
        if (vars.length() == init) {
            return ToolsRes.getString("FunctionPanel.Instructions.Help");
        }
        return String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + separator + vars.toString();
    }

    private int getRemovableRowCount() {
        int i = 0;
        for (Object obj : this.objects) {
            if (!this.isRemovable(obj)) continue;
            ++i;
        }
        return i;
    }

    protected int getPartlyEditableRowCount() {
        int i = 0;
        for (Object obj : this.objects) {
            if (!this.isNameEditable(obj) && !this.isExpressionEditable(obj)) continue;
            ++i;
        }
        return i;
    }

    protected boolean isInvalidExpression(Object obj) {
        return false;
    }

    public boolean containsInvalidExpressions() {
        Iterator<Object> it = this.objects.iterator();
        while (it.hasNext()) {
            if (!this.isInvalidExpression(it.next())) continue;
            return true;
        }
        return false;
    }

    private void copy(Object[] array) {
        if (array != null && array.length > 0) {
            XMLControlElement control = new XMLControlElement(this);
            control.setValue("selected", array);
            StringSelection ss = new StringSelection(control.toXML());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(ss, ss);
            this.pasteButton.setEnabled(true);
            this.firePropertyChange("clipboard", null, null);
        }
    }

    protected void paste() {
        XMLControl[] controls = this.getClipboardContents();
        if (controls == null) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            Object obj = controls[i].loadObject(null);
            this.addObject(obj, true);
            ++i;
        }
        this.evaluateAll();
    }

    protected XMLControl[] getClipboardContents() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable tran = clipboard.getContents(null);
            String dataString = (String)tran.getTransferData(DataFlavor.stringFlavor);
            if (dataString != null) {
                XMLControlElement control = new XMLControlElement();
                control.readXML(dataString);
                if (control.getObjectClass() == this.getClass()) {
                    List<Object> list = control.getPropertyContent();
                    int i = 0;
                    while (i < list.size()) {
                        XMLProperty prop;
                        Object next = list.get(i);
                        if (next instanceof XMLProperty && (prop = (XMLProperty)next).getPropertyName().equals("selected")) {
                            return prop.getChildControls();
                        }
                        ++i;
                    }
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Object getSelectedObject() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.objects.get(row);
    }

    protected Object[] getSelectedObjects() {
        int[] rows = this.table.getSelectedRows();
        Object[] selected = new Object[rows.length];
        int i = 0;
        while (i < rows.length) {
            selected[i] = this.objects.get(rows[i]);
            ++i;
        }
        return selected;
    }

    protected Object createObject(String name, String expression, Object obj) {
        return null;
    }

    protected boolean isDisallowedName(Object obj, String name) {
        if (this.forbiddenNames.contains(name)) {
            return true;
        }
        for (Object next : this.objects) {
            if (next == obj || !name.equals(this.getName(next))) continue;
            return true;
        }
        if (this.paramEditor != null && this.paramEditor != this) {
            Parameter[] params = this.paramEditor.getParameters();
            int i = 0;
            while (i < params.length) {
                if (params[i] != obj && name.equals(params[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        try {
            Double.parseDouble(name);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String getValidName(String proposedName) {
        if (proposedName == null || proposedName.trim().equals("")) {
            return "";
        }
        String name = proposedName;
        ArrayList<String> invalid = this.getInvalidTokens(name);
        while (!invalid.isEmpty()) {
            for (String next : invalid) {
                int n = name.indexOf(next);
                while (n > -1) {
                    name = n == 0 ? name.substring(next.length()) : String.valueOf(name.substring(0, n)) + name.substring(n + next.length());
                    n = name.indexOf(next);
                }
            }
            Object input = JOptionPane.showInputDialog(this, ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Message"), ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Title"), 2, null, null, name);
            if (input == null) {
                return null;
            }
            if (input.equals(name)) break;
            name = input.toString();
            invalid = this.getInvalidTokens(name);
        }
        try {
            String test = name.substring(0, Math.min(1, name.length()));
            Double.parseDouble(test);
            JOptionPane.showMessageDialog(this, ToolsRes.getString("FunctionEditor.Dialog.InvalidNumberInName.Text"), ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Title"), 2);
            return "";
        }
        catch (NumberFormatException numberFormatException) {
            return name;
        }
    }

    private ArrayList<String> getInvalidTokens(String name) {
        ArrayList<String> invalid = new ArrayList<String>();
        if (name.indexOf(" ") > -1) {
            invalid.add(" ");
        }
        String[] suspects = FunctionTool.parserOperators;
        int i = 0;
        while (i < suspects.length) {
            if (name.indexOf(suspects[i]) > -1) {
                invalid.add(suspects[i]);
            }
            ++i;
        }
        return invalid;
    }

    protected Object createUniqueObject(Object obj, String proposedName, boolean confirmChanges) {
        if ((proposedName = this.getValidName(proposedName)) == null || proposedName.trim().equals("")) {
            return null;
        }
        String name = proposedName;
        while (this.isDisallowedName(obj, proposedName)) {
            int i = 0;
            while (this.isDisallowedName(obj, name)) {
                name = String.valueOf(proposedName) + ++i;
            }
            if (!confirmChanges) break;
            Object input = JOptionPane.showInputDialog(this, "\"" + proposedName + "\" " + ToolsRes.getString("FunctionEditor.Dialog.DuplicateName.Message"), ToolsRes.getString("FunctionEditor.Dialog.DuplicateName.Title"), 2, null, null, name);
            if (input == null) {
                return null;
            }
            if (input.equals("") || input.equals(name)) break;
            name = proposedName = input.toString();
        }
        String expression = obj == null ? "0" : this.getExpression(obj);
        return this.createObject(name, expression, obj);
    }

    public static String format(double value, double zeroLevel) {
        double absVal;
        int rounded;
        if (Math.abs(value) < zeroLevel) {
            value = 0.0;
        }
        if (Math.abs(value - (double)(rounded = (int)Math.round(value))) < zeroLevel) {
            value = rounded;
        }
        boolean scientific = (absVal = Math.abs(value)) < 0.01 && value != 0.0 || absVal >= 1000.0;
        String s = scientific ? sciFormat.format(value) : decimalFormat.format(value);
        int n = s.indexOf("E");
        String tail = n > -1 ? s.substring(n) : "";
        s = n > -1 ? s.substring(0, n) : s;
        if ((n = s.indexOf("0000")) > 1) {
            s = s.substring(0, n + 1);
        }
        if ((n = s.indexOf("9999")) > 1) {
            DecimalFormatSymbols symbols;
            char separator;
            int m = (s = s.substring(0, n)).indexOf(separator = (symbols = sciFormat.getDecimalFormatSymbols()).getDecimalSeparator());
            if (m == s.length() - 1) {
                int i = Integer.parseInt(s.substring(0, m)) + 1;
                s = String.valueOf(Integer.toString(i)) + separator + "0";
            } else {
                int i = Integer.parseInt(s.substring(n - 1)) + 1;
                s = String.valueOf(s.substring(0, n - 1)) + i;
            }
        }
        return String.valueOf(s) + tail;
    }

    public static double round(double value, int sigfigs) {
        if (value == 0.0) {
            return value;
        }
        int multiplier = value < 0.0 ? -1 : 1;
        value = Math.abs(value);
        double limit = Math.pow(10.0, sigfigs - 1);
        int power = 0;
        while (value < limit) {
            value *= 10.0;
            ++power;
        }
        while (value > 10.0 * limit) {
            value /= 10.0;
            --power;
        }
        value = Math.round(value);
        return (double)multiplier * value / Math.pow(10.0, power);
    }

    private class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        boolean keyPressed = false;
        boolean mouseClicked = false;
        JDialog popupEditor;
        JPanel editorPane;
        JPanel dragPane;
        JTextField popupField = new JTextField();
        JTextPane variablesPane;
        JButton revertButton;
        ValueMouseControl valueMouseController;
        int minPopupWidth;
        int varBegin;
        int varEnd;
        Object prevObject;
        String prevName;
        String prevExpression;

        CellEditor() {
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 2));
            this.field.setBorder(null);
            this.field.setEditable(true);
            this.field.setFont(this.field.getFont().deriveFont(18.0f));
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        CellEditor.this.keyPressed = true;
                        CellEditor.this.stopCellEditing();
                    } else {
                        CellEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (((CellEditor)CellEditor.this).FunctionEditor.this.usePopupEditor) {
                        CellEditor.this.stopCellEditing();
                        undoEditsEnabled = true;
                    }
                    CellEditor.this.mouseClicked = false;
                    ((CellEditor)CellEditor.this).FunctionEditor.this.table.clearSelection();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!CellEditor.this.mouseClicked) {
                        CellEditor.this.stopCellEditing();
                    }
                    if (CellEditor.this.keyPressed) {
                        CellEditor.this.keyPressed = false;
                        ((CellEditor)CellEditor.this).FunctionEditor.this.table.requestFocusInWindow();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable atable, Object value, boolean isSelected, int row, int column) {
            FunctionEditor.this.table.rowToSelect = row;
            FunctionEditor.this.table.columnToSelect = column;
            if (FunctionEditor.this.usePopupEditor) {
                undoEditsEnabled = false;
                JDialog popup = this.getPopupEditor();
                if (FunctionEditor.this.functionPanel.functionTool != null) {
                    int level = FunctionEditor.this.functionPanel.functionTool.getFontLevel();
                    FontSizer.setFonts(popup, level);
                }
                FunctionEditor.this.dragLabel.setText(ToolsRes.getString("FunctionEditor.DragLabel.Text"));
                this.popupField.setText(value.toString());
                this.popupField.requestFocusInWindow();
                try {
                    String s = this.popupField.getText();
                    this.setInitialValue(s);
                }
                catch (NumberFormatException s) {
                    // empty catch block
                }
                this.prevObject = FunctionEditor.this.objects.get(row);
                if (this.prevObject != null) {
                    this.prevName = FunctionEditor.this.getName(this.prevObject);
                    this.prevExpression = FunctionEditor.this.getExpression(this.prevObject);
                }
                this.popupField.selectAll();
                if (column == 1) {
                    this.variablesPane.setText(FunctionEditor.this.getVariablesString(":\n"));
                    StyledDocument doc = this.variablesPane.getStyledDocument();
                    Style blue = doc.getStyle("blue");
                    doc.setCharacterAttributes(0, this.variablesPane.getText().length(), blue, false);
                    popup.getContentPane().add((Component)this.variablesPane, "Center");
                } else {
                    popup.getContentPane().remove(this.variablesPane);
                }
                Rectangle cell = FunctionEditor.this.table.getCellRect(row, column, true);
                this.minPopupWidth = cell.width + 2;
                Dimension dim = this.resizePopupEditor();
                Point p = FunctionEditor.this.table.getLocationOnScreen();
                popup.setLocation(p.x + cell.x + cell.width / 2 - dim.width / 2, p.y + cell.y + cell.height / 2 - dim.height / 2);
                popup.setVisible(true);
            } else {
                this.field.setText(value.toString());
                FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, true, column);
                FunctionEditor.this.functionPanel.tableEditorField = this.field;
            }
            return this.panel;
        }

        void setInitialValue(final String stringValue) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    JDialog editor = CellEditor.this.getPopupEditor();
                    try {
                        double value;
                        String val = stringValue.replaceAll(",", ".");
                        if ("".equals(val)) {
                            val = "0";
                        }
                        CellEditor.this.valueMouseController.prevValue = value = Double.parseDouble(val);
                        CellEditor.this.popupField.setToolTipText(ToolsRes.getString("FunctionEditor.PopupField.Tooltip"));
                        CellEditor.this.revertButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Revert.Tooltip"));
                        CellEditor.this.variablesPane.setToolTipText(ToolsRes.getString("FunctionEditor.VariablesPane.Tooltip"));
                        int row = ((CellEditor)CellEditor.this).FunctionEditor.this.table.rowToSelect;
                        String tooltip = ToolsRes.getString("FunctionEditor.DragLabel.Tooltip");
                        ((CellEditor)CellEditor.this).FunctionEditor.this.dragLabel.setToolTipText(tooltip);
                        String name = (String)((CellEditor)CellEditor.this).FunctionEditor.this.table.getValueAt(row, 0);
                        if (!name.equals("t")) {
                            editor.getContentPane().add((Component)CellEditor.this.dragPane, "South");
                        } else {
                            editor.getContentPane().remove(CellEditor.this.dragPane);
                        }
                    }
                    catch (NumberFormatException e) {
                        editor.getContentPane().remove(CellEditor.this.dragPane);
                    }
                    editor.pack();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runner.run();
            } else {
                SwingUtilities.invokeLater(runner);
            }
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                FunctionEditor.this.firePropertyChange("focus", null, null);
                MouseEvent me = (MouseEvent)e;
                if (me.getClickCount() == 2) {
                    this.mouseClicked = true;
                    Runnable runner = new Runnable(){

                        @Override
                        public synchronized void run() {
                            CellEditor.this.field.selectAll();
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                    return true;
                }
            } else if (e == null || e instanceof ActionEvent) {
                return true;
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            if (FunctionEditor.this.usePopupEditor) {
                this.popupField.setBackground(Color.WHITE);
            }
            this.field.setBackground(Color.WHITE);
            Runnable runner = new Runnable(){

                @Override
                public synchronized void run() {
                    ((CellEditor)CellEditor.this).FunctionEditor.this.table.revalidate();
                }
            };
            SwingUtilities.invokeLater(runner);
            return this.field.getText();
        }

        private Dimension resizePopupEditor() {
            String s = this.popupField.getText();
            Font font = this.popupField.getFont();
            Rectangle rect = font.getStringBounds(s, frc).getBounds();
            int h = rect.height;
            int w = Math.max(this.minPopupWidth, rect.width + 32);
            if (FunctionEditor.this.table.columnToSelect == 1) {
                s = this.variablesPane.getText();
                int n = s.indexOf("\n");
                s = s.substring(n + 1);
                font = this.variablesPane.getFont().deriveFont(1);
                rect = font.getStringBounds(s, frc).getBounds();
                w = Math.max(w, rect.width);
            }
            Dimension dim = new Dimension(w, h);
            this.editorPane.setPreferredSize(dim);
            this.popupEditor.pack();
            dim.width = this.popupEditor.getWidth();
            return dim;
        }

        private JDialog getPopupEditor() {
            if (this.popupEditor == null) {
                this.popupField.setEditable(true);
                Font font = this.popupField.getFont().deriveFont(24.0f);
                int level = FunctionEditor.this.functionPanel.functionTool.getFontLevel();
                font = FontSizer.getResizedFont(font, level);
                this.popupField.setFont(font);
                this.popupField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            String text = CellEditor.this.popupField.getText();
                            int row = ((CellEditor)CellEditor.this).FunctionEditor.this.table.rowToSelect;
                            ((CellEditor)CellEditor.this).FunctionEditor.this.objects.remove(row);
                            ((CellEditor)CellEditor.this).FunctionEditor.this.objects.add(row, CellEditor.this.prevObject);
                            if (((CellEditor)CellEditor.this).FunctionEditor.this.table.columnToSelect == 1) {
                                ((CellEditor)CellEditor.this).FunctionEditor.this.table.setValueAt(CellEditor.this.prevExpression, row, 1);
                            }
                            CellEditor.this.field.setText(text);
                            undoEditsEnabled = true;
                            CellEditor.this.keyPressed = true;
                            CellEditor.this.popupEditor.setVisible(false);
                            if (((CellEditor)CellEditor.this).FunctionEditor.this.table.columnToSelect == 1) {
                                ((CellEditor)CellEditor.this).FunctionEditor.this.table.setValueAt(text, row, 1);
                            }
                            CellEditor.this.field.requestFocusInWindow();
                            CellEditor.this.field.selectAll();
                        } else {
                            CellEditor.this.popupField.setBackground(Color.yellow);
                            CellEditor.this.resizePopupEditor();
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            return;
                        }
                        CellEditor.this.setInitialValue(CellEditor.this.popupField.getText());
                    }
                });
                this.variablesPane = new JTextPane(){

                    @Override
                    public void paintComponent(Graphics g) {
                        if (OSPRuntime.antiAliasText.booleanValue()) {
                            Graphics2D g2 = (Graphics2D)g;
                            RenderingHints rh = g2.getRenderingHints();
                            rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        }
                        super.paintComponent(g);
                    }
                };
                this.variablesPane.setEditable(false);
                this.variablesPane.setFocusable(false);
                this.variablesPane.setBorder(this.popupField.getBorder());
                font = this.popupField.getFont().deriveFont(14.0f);
                font = FontSizer.getResizedFont(font, level);
                this.variablesPane.setFont(font);
                StyledDocument doc = this.variablesPane.getStyledDocument();
                Style def = StyleContext.getDefaultStyleContext().getStyle("default");
                StyleConstants.setFontFamily(def, "SansSerif");
                Style blue = doc.addStyle("blue", def);
                StyleConstants.setBold(blue, false);
                StyleConstants.setForeground(blue, Color.blue);
                Style red = doc.addStyle("red", blue);
                StyleConstants.setBold(red, true);
                StyleConstants.setForeground(red, Color.red);
                this.varEnd = 0;
                this.varBegin = 0;
                this.variablesPane.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (CellEditor.this.varEnd == 0) {
                            return;
                        }
                        CellEditor.this.variablesPane.setCaretPosition(CellEditor.this.varBegin);
                        CellEditor.this.variablesPane.moveCaretPosition(CellEditor.this.varEnd);
                        CellEditor.this.popupField.replaceSelection(CellEditor.this.variablesPane.getSelectedText());
                        CellEditor.this.popupField.setBackground(Color.yellow);
                        CellEditor.this.setInitialValue(CellEditor.this.popupField.getText());
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        StyledDocument doc = CellEditor.this.variablesPane.getStyledDocument();
                        Style blue = doc.getStyle("blue");
                        doc.setCharacterAttributes(0, CellEditor.this.variablesPane.getText().length(), blue, false);
                        CellEditor.this.varEnd = 0;
                        CellEditor.this.varBegin = 0;
                    }
                });
                this.variablesPane.addMouseMotionListener(new MouseMotionAdapter(){

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public void mouseMoved(MouseEvent e) {
                        CellEditor.this.varEnd = 0;
                        CellEditor.this.varBegin = 0;
                        text = CellEditor.this.variablesPane.getText();
                        startVars = text.indexOf(":\n");
                        if (startVars == -1) {
                            return;
                        }
                        vars = text.substring(startVars += 2);
                        doc = CellEditor.this.variablesPane.getStyledDocument();
                        blue = doc.getStyle("blue");
                        red = doc.getStyle("red");
                        beginVar = CellEditor.this.variablesPane.viewToModel(e.getPoint()) - startVars;
                        if (beginVar >= 0) ** GOTO lbl17
                        doc.setCharacterAttributes(0, text.length(), blue, false);
                        return;
                        while (!(s = vars.substring(0, beginVar)).endsWith(" ")) {
                            --beginVar;
lbl17:
                            // 2 sources

                            if (beginVar > 0) continue;
                        }
                        CellEditor.this.varBegin = beginVar + startVars;
                        s = vars.substring(beginVar);
                        len = s.indexOf(",");
                        if (len == -1) {
                            len = s.indexOf(" ");
                        }
                        if (len == -1) {
                            len = s.length();
                        }
                        CellEditor.this.varEnd = CellEditor.this.varBegin + len;
                        doc.setCharacterAttributes(0, CellEditor.this.varBegin, blue, false);
                        doc.setCharacterAttributes(CellEditor.this.varBegin, len, red, false);
                        doc.setCharacterAttributes(CellEditor.this.varEnd, text.length() - CellEditor.this.varEnd, blue, false);
                    }
                });
                this.dragPane = new JPanel(new BorderLayout());
                this.dragPane.setBackground(new Color(240, 255, 240));
                FunctionEditor.this.dragLabel = new JLabel();
                FunctionEditor.this.dragLabel.setHorizontalAlignment(0);
                Border line = BorderFactory.createLineBorder(LIGHT_BLUE);
                Border space = BorderFactory.createEmptyBorder(2, 3, 2, 3);
                FunctionEditor.this.dragLabel.setBorder(BorderFactory.createCompoundBorder(line, space));
                font = this.popupField.getFont().deriveFont(12.0f);
                font = FontSizer.getResizedFont(font, level);
                FunctionEditor.this.dragLabel.setFont(font);
                FunctionEditor.this.dragLabel.setForeground(Color.green.darker().darker());
                this.dragPane.add((Component)FunctionEditor.this.dragLabel, "Center");
                this.valueMouseController = new ValueMouseControl(FunctionEditor.this.tableCellEditor);
                FunctionEditor.this.dragLabel.addMouseListener(this.valueMouseController);
                FunctionEditor.this.dragLabel.addMouseMotionListener(this.valueMouseController);
                String imageFile = "/org/opensourcephysics/resources/tools/images/close.gif";
                Icon icon = ResourceLoader.getIcon(imageFile);
                this.revertButton = new JButton(icon);
                line = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
                space = BorderFactory.createEmptyBorder(0, 2, 0, 2);
                this.revertButton.setBorder(BorderFactory.createCompoundBorder(line, space));
                this.revertButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CellEditor.this.prevObject != null) {
                            if (((CellEditor)CellEditor.this).FunctionEditor.this.table.columnToSelect == 1) {
                                ((CellEditor)CellEditor.this).FunctionEditor.this.table.setValueAt(CellEditor.this.prevExpression, ((CellEditor)CellEditor.this).FunctionEditor.this.table.rowToSelect, 1);
                                CellEditor.this.field.setText(CellEditor.this.prevExpression);
                            } else {
                                ((CellEditor)CellEditor.this).FunctionEditor.this.table.setValueAt(CellEditor.this.prevName, ((CellEditor)CellEditor.this).FunctionEditor.this.table.rowToSelect, 0);
                                CellEditor.this.field.setText(CellEditor.this.prevName);
                            }
                            CellEditor.this.stopCellEditing();
                            undoEditsEnabled = true;
                        }
                        CellEditor.this.popupField.setBackground(Color.WHITE);
                        CellEditor.this.popupEditor.setVisible(false);
                    }
                });
                Frame frame = JOptionPane.getFrameForComponent(FunctionEditor.this);
                this.popupEditor = new JDialog(frame, true);
                this.popupEditor.setUndecorated(true);
                this.popupEditor.getRootPane().setWindowDecorationStyle(0);
                JPanel contentPane = new JPanel(new BorderLayout());
                this.popupEditor.setContentPane(contentPane);
                this.editorPane = new JPanel(new BorderLayout());
                this.editorPane.setBackground(Color.WHITE);
                this.editorPane.add((Component)this.popupField, "Center");
                this.editorPane.add((Component)this.revertButton, "East");
                contentPane.add((Component)this.editorPane, "North");
            }
            return this.popupEditor;
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        Font font = new JTextField().getFont();

        public CellRenderer() {
            this.setOpaque(true);
            this.setFont(this.font);
            this.setHorizontalAlignment(2);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String tooltipText;
            String val = value.toString();
            if (col == 0 && FunctionEditor.this instanceof UserFunctionEditor) {
                val = FitBuilder.localize(val);
            }
            this.setText(val);
            Object obj = FunctionEditor.this.objects.get(row);
            String tooltip = FunctionEditor.this.getTooltip(obj);
            String string = col == 0 && tooltip != null ? tooltip : (tooltipText = col == 0 ? ToolsRes.getString("FunctionEditor.Table.Cell.Name.Tooltip") : ToolsRes.getString("FunctionEditor.Table.Cell.Value.Tooltip"));
            if (tooltip == null && col == 0) {
                tooltipText = String.valueOf(tooltipText) + " (" + ToolsRes.getString("FunctionEditor.Tooltip.HowToEdit") + ")";
            }
            this.setToolTipText(tooltipText);
            if (col == 1 && FunctionEditor.this.circularErrors.contains(obj)) {
                this.setToolTipText(ToolsRes.getString("FunctionEditor.Table.Cell.CircularErrors.Tooltip"));
                this.setForeground(DARK_RED);
                if (isSelected) {
                    this.setBackground(MEDIUM_RED);
                } else {
                    this.setBackground(LIGHT_RED);
                }
            } else if (col == 1 && FunctionEditor.this.isInvalidExpression(obj)) {
                this.setToolTipText(ToolsRes.getString("FunctionEditor.Table.Cell.Invalid.Tooltip"));
                this.setForeground(DARK_RED);
                if (isSelected) {
                    this.setBackground(MEDIUM_RED);
                } else {
                    this.setBackground(LIGHT_RED);
                }
            } else if (col == 0 && !FunctionEditor.this.isNameEditable(obj) || col == 1 && !FunctionEditor.this.isExpressionEditable(obj)) {
                this.setForeground(Color.BLACK);
                this.setBackground(LIGHT_GRAY);
            } else if (isSelected) {
                this.setForeground(hasFocus ? Color.BLUE : Color.BLACK);
                this.setBackground(LIGHT_BLUE);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
            this.setFont(col == 0 && FunctionEditor.this.isImportant(obj) ? this.font.deriveFont(1) : this.font);
            FunctionEditor.this.refreshButtons();
            return this;
        }
    }

    protected class DefaultEdit
    extends AbstractUndoableEdit {
        Object redoObj;
        Object undoObj;
        int redoRow;
        int redoCol;
        int undoRow;
        int undoCol;
        int editType;
        String name;

        public DefaultEdit(int type, Object newVal, int newRow, int newCol, Object prevVal, int prevRow, int prevCol, String name) {
            this.editType = type;
            this.redoObj = newVal;
            this.undoObj = prevVal;
            this.redoRow = newRow;
            this.redoCol = newCol;
            this.undoRow = prevRow;
            this.undoCol = prevCol;
            this.name = name;
            OSPLog.finer(String.valueOf(editTypes[type]) + ": \"" + name + "\"" + "\nold value: " + prevVal + "\nnew value: " + newVal);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            undoEditsEnabled = false;
            switch (this.editType) {
                case 0: {
                    FunctionEditor.this.removeObject(this.undoObj, false);
                    break;
                }
                case 1: {
                    FunctionEditor.this.addObject(this.undoObj, this.undoRow, false, true);
                    break;
                }
                case 2: {
                    Object obj = FunctionEditor.this.objects.get(this.undoRow);
                    String expression = FunctionEditor.this.getExpression(obj);
                    this.name = this.undoObj.toString();
                    String prevName = this.redoObj.toString();
                    obj = FunctionEditor.this.createObject(this.name, expression, obj);
                    FunctionEditor.this.objects.remove(this.undoRow);
                    FunctionEditor.this.objects.add(this.undoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, prevName);
                    break;
                }
                case 3: {
                    Object obj = FunctionEditor.this.objects.get(this.undoRow);
                    Object[] undoArray = (Object[])this.undoObj;
                    obj = FunctionEditor.this.createObject(this.name, undoArray[0].toString(), obj);
                    FunctionEditor.this.objects.remove(this.undoRow);
                    FunctionEditor.this.objects.add(this.undoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, null);
                }
            }
            FunctionEditor.this.table.rowToSelect = this.undoRow;
            FunctionEditor.this.table.columnToSelect = this.undoCol;
            FunctionEditor.this.getTable().selectOnFocus = true;
            FunctionEditor.this.getTable().requestFocusInWindow();
            FunctionEditor.this.refreshGUI();
            undoEditsEnabled = true;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            undoEditsEnabled = false;
            switch (this.editType) {
                case 0: {
                    FunctionEditor.this.addObject(this.redoObj, this.redoRow, false, true);
                    break;
                }
                case 1: {
                    FunctionEditor.this.removeObject(this.redoObj, false);
                    break;
                }
                case 2: {
                    Object obj = FunctionEditor.this.objects.get(this.redoRow);
                    String expression = FunctionEditor.this.getExpression(obj);
                    this.name = this.redoObj.toString();
                    String prevName = this.undoObj.toString();
                    obj = FunctionEditor.this.createObject(this.name, expression, obj);
                    FunctionEditor.this.objects.remove(this.redoRow);
                    FunctionEditor.this.objects.add(this.redoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, prevName);
                    break;
                }
                case 3: {
                    Object obj = FunctionEditor.this.objects.get(this.redoRow);
                    Object[] redoArray = (Object[])this.redoObj;
                    ArrayList buttons = (ArrayList)redoArray[1];
                    for (Object next : buttons) {
                        AbstractButton b = (AbstractButton)next;
                        if (b.isSelected()) continue;
                        b.doClick(0);
                    }
                    obj = FunctionEditor.this.createObject(this.name, redoArray[0].toString(), obj);
                    FunctionEditor.this.objects.remove(this.redoRow);
                    FunctionEditor.this.objects.add(this.redoRow, obj);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, null);
                }
            }
            FunctionEditor.this.table.rowToSelect = this.redoRow;
            FunctionEditor.this.table.columnToSelect = this.redoCol;
            FunctionEditor.this.getTable().selectOnFocus = true;
            FunctionEditor.this.getTable().requestFocusInWindow();
            FunctionEditor.this.refreshGUI();
            undoEditsEnabled = true;
        }

        @Override
        public String getPresentationName() {
            if (this.editType == 1) {
                return "Deletion";
            }
            return "Edit";
        }
    }

    public class Table
    extends JTable {
        public boolean selectOnFocus = true;
        int rowToSelect;
        int columnToSelect;

        Table(TableModel model) {
            this.setModel(model);
            this.setSelectionMode(2);
            this.setColumnSelectionAllowed(false);
            this.getTableHeader().setReorderingAllowed(false);
            this.setGridColor(Color.BLACK);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int row = Table.this.rowAtPoint(e.getPoint());
                    int col = Table.this.columnAtPoint(e.getPoint());
                    ((Table)Table.this).FunctionEditor.this.table.rowToSelect = row;
                    ((Table)Table.this).FunctionEditor.this.table.columnToSelect = col;
                    if (!((Table)Table.this).FunctionEditor.this.tableModel.isCellEditable(row, col)) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.clearSelection();
                        Table.this.selectOnFocus = false;
                    } else if (e.getClickCount() == 1) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, col);
                        Table.this.selectOnFocus = ((Table)Table.this).FunctionEditor.this.table.hasFocus();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        int col = Table.this.columnAtPoint(e.getPoint());
                        if (col != 0) {
                            return;
                        }
                        int row = Table.this.rowAtPoint(e.getPoint());
                        if (((Table)Table.this).FunctionEditor.this.tableModel.isCellEditable(row, col)) {
                            String name = (String)((Table)Table.this).FunctionEditor.this.table.getValueAt(row, col);
                            Object obj = FunctionEditor.this.getObject(name);
                            String desc = FunctionEditor.this.getDescription(obj);
                            String message = ToolsRes.getString("FunctionEditor.Dialog.SetDescription.Message");
                            message = String.valueOf(message) + " \"" + name + "\"";
                            Object input = JOptionPane.showInputDialog(FunctionEditor.this, message, ToolsRes.getString("FunctionEditor.Dialog.SetDescription.Title"), -1, null, null, desc);
                            if (input == null || input.equals(desc)) {
                                return;
                            }
                            desc = input.toString();
                            FunctionEditor.this.setDescription(obj, desc);
                        }
                    }
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Table.this.firePropertyChange("focus", null, null);
                    if (Table.this.getRowCount() == 0) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.tabToNext(FunctionEditor.this);
                        return;
                    }
                    if (Table.this.selectOnFocus && Table.this.getRowCount() > 0) {
                        Table.this.selectCell(Table.this.rowToSelect, Table.this.columnToSelect);
                        int col = ((Table)Table.this).FunctionEditor.this.table.getSelectedColumn();
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, col);
                    }
                    Table.this.selectOnFocus = true;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Table.this.rowToSelect = Math.max(0, Table.this.getSelectedRow());
                    Table.this.columnToSelect = Math.max(0, Table.this.getSelectedColumn());
                }
            });
            InputMap im = this.getInputMap(1);
            AbstractAction enterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTable table = (JTable)e.getSource();
                    int row = table.getSelectedRow();
                    int column = table.getSelectedColumn();
                    table.editCellAt(row, column, e);
                    ((Table)Table.this).FunctionEditor.this.tableCellEditor.field.requestFocus();
                    ((Table)Table.this).FunctionEditor.this.tableCellEditor.field.selectAll();
                }
            };
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            this.getActionMap().put(im.get(enter), enterAction);
            KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
            AbstractAction tabAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowCount = ((Table)Table.this).FunctionEditor.this.table.getRowCount();
                    int row = ((Table)Table.this).FunctionEditor.this.table.rowToSelect;
                    int col = ((Table)Table.this).FunctionEditor.this.table.columnToSelect;
                    boolean atEnd = col == 1 && row == rowCount - 1;
                    int n = col = col == 0 ? 1 : 0;
                    int n2 = col == 0 ? (row == Table.this.getRowCount() - 1 ? 0 : row + 1) : (row = row);
                    if (((Table)Table.this).FunctionEditor.this.table.isEditing()) {
                        ((Table)Table.this).FunctionEditor.this.table.rowToSelect = row;
                        ((Table)Table.this).FunctionEditor.this.table.columnToSelect = col;
                        ((Table)Table.this).FunctionEditor.this.tableCellEditor.stopCellEditing();
                    }
                    if (atEnd) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.tabToNext(FunctionEditor.this);
                        ((Table)Table.this).FunctionEditor.this.table.clearSelection();
                    } else {
                        ((Table)Table.this).FunctionEditor.this.table.requestFocusInWindow();
                        Table.this.selectCell(row, col);
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, col);
                    }
                }
            };
            this.getActionMap().put(im.get(tab), tabAction);
        }

        /*
         * Unable to fully structure code
         */
        public void selectCell(int row, int col) {
            if (row == this.getRowCount()) {
                row = this.getRowCount() - 1;
                col = 0;
            }
            if (row != -1) ** GOTO lbl14
            return;
lbl-1000:
            // 1 sources

            {
                if (col == 0) {
                    col = 1;
                } else {
                    col = 0;
                    ++row;
                }
                if (row == this.getRowCount()) {
                    row = 0;
                }
                if (row == this.getSelectedRow() && col == this.getSelectedColumn()) break;
lbl14:
                // 2 sources

                ** while (!this.isCellEditable((int)row, (int)col))
            }
lbl15:
            // 2 sources

            FunctionEditor.this.table.rowToSelect = row;
            FunctionEditor.this.table.columnToSelect = col;
            FunctionEditor.this.table.changeSelection(row, col, false, false);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            return FunctionEditor.this.tableCellEditor;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return FunctionEditor.this.tableCellRenderer;
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            this.getTableHeader().setFont(font);
            FunctionEditor.this.tableCellRenderer.font = font;
            FunctionEditor.this.tableCellEditor.field.setFont(font);
            int size = Math.max(font.getSize(), 24);
            FunctionEditor.this.tableCellEditor.popupField.setFont(font.deriveFont((float)size));
            this.setRowHeight(font.getSize() + 4);
        }
    }

    protected class TableModel
    extends AbstractTableModel {
        boolean settingValue = false;

        protected TableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FunctionEditor.this.objects.size();
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? ToolsRes.getString("FunctionEditor.Table.Column.Name") : ToolsRes.getString("FunctionEditor.Table.Column.Value");
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object obj = FunctionEditor.this.objects.get(row);
            String name = FunctionEditor.this.getName(obj);
            if (col == 0) {
                return name;
            }
            String expression = FunctionEditor.this.getExpression(obj);
            try {
                double value = Double.parseDouble(expression);
                if (FunctionEditor.this.anglesInDegrees && (name.indexOf(THETA) > -1 || name.indexOf(OMEGA) > -1)) {
                    String s = FunctionEditor.format(value * 180.0 / Math.PI, 1.0E-4);
                    if (name.indexOf(THETA) > -1) {
                        s = String.valueOf(s) + FunctionEditor.DEGREES;
                    }
                    return s;
                }
                return FunctionEditor.format(value, 0.0);
            }
            catch (NumberFormatException numberFormatException) {
                return expression;
            }
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.settingValue) {
                return;
            }
            if (value instanceof String) {
                String val = (String)value;
                int n = val.indexOf(FunctionEditor.DEGREES);
                if (n > -1) {
                    val = val.substring(0, n);
                }
                String prev = null;
                int type = 0;
                Object obj = FunctionEditor.this.objects.get(row);
                if (col == 0) {
                    prev = FunctionEditor.this.getName(obj);
                    type = 2;
                    this.settingValue = true;
                    if (!val.equals(prev)) {
                        obj = FunctionEditor.this.createUniqueObject(obj, val, true);
                        val = FunctionEditor.this.getName(obj);
                    }
                    this.settingValue = false;
                    if (obj == null || val.equals(prev)) {
                        FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, 0);
                        return;
                    }
                    FunctionEditor.this.objects.remove(row);
                    FunctionEditor.this.objects.add(row, obj);
                } else {
                    prev = this.getValueAt(row, col).toString();
                    type = 3;
                    if (val.equals(prev)) {
                        FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, 1);
                        return;
                    }
                    if (val.equals("")) {
                        val = "0";
                    }
                    String name = FunctionEditor.this.getName(obj);
                    if (FunctionEditor.this.anglesInDegrees && (name.indexOf(THETA) > -1 || name.indexOf(OMEGA) > -1)) {
                        try {
                            double d = Double.parseDouble(val);
                            val = String.valueOf(d * Math.PI / 180.0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    obj = FunctionEditor.this.createObject(FunctionEditor.this.getName(obj), val, obj);
                    FunctionEditor.this.objects.remove(row);
                    FunctionEditor.this.objects.add(row, obj);
                }
                FunctionEditor.this.evaluateAll();
                FunctionEditor.this.table.repaint();
                UndoableEdit edit = null;
                if (undoEditsEnabled) {
                    edit = FunctionEditor.this.getUndoableEdit(type, val, row, col, prev, row, col, FunctionEditor.this.getName(obj));
                }
                FunctionEditor.this.firePropertyChange("edit", FunctionEditor.this.getName(obj), edit);
                FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, col);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Object obj = FunctionEditor.this.objects.get(row);
            return col == 0 && FunctionEditor.this.isNameEditable(obj) || col == 1 && FunctionEditor.this.isExpressionEditable(obj);
        }
    }

    private class ValueMouseControl
    extends MouseAdapter {
        CellEditor cellEditor;
        double prevValue;
        double newValue;
        Point startingPoint;
        int logDelta;

        private ValueMouseControl(CellEditor editor) {
            this.cellEditor = editor;
        }

        int getLogDelta(String val, double relativeX) {
            int exp;
            int minus;
            if ("".equals(val)) {
                return 0;
            }
            int digits = val.length();
            int powerOfTen = 0;
            int decimal = val.replaceAll(",", ".").indexOf(".");
            if (decimal > -1) {
                --digits;
            }
            if ((minus = val.indexOf("-")) > -1) {
                --digits;
                --decimal;
            }
            if ((exp = val.indexOf("E")) > -1) {
                String exponent = val.substring(exp + 1);
                digits -= exponent.length() + 1;
                powerOfTen = Integer.parseInt(exponent);
            }
            int selectableDigits = exp > -1 ? digits : digits + 1;
            int selectedDigit = (int)Math.floor(relativeX * (double)selectableDigits);
            int integerDigits = decimal > -1 ? decimal : digits;
            return powerOfTen += integerDigits - selectedDigit - 1;
        }

        int getSelectionIndex(String val) {
            int exp;
            int minus;
            int powerOfTen = this.logDelta;
            int digits = val.length();
            int offset = 0;
            int decimal = val.replaceAll(",", ".").indexOf(".");
            if (decimal > -1) {
                --digits;
            }
            if ((minus = val.indexOf("-")) > -1) {
                --digits;
                offset = 1;
                --decimal;
            }
            if ((exp = val.indexOf("E")) > -1) {
                String exponent = val.substring(exp + 1);
                digits -= exponent.length() + 1;
                powerOfTen -= Integer.parseInt(exponent);
            }
            int integerDigits = decimal > -1 ? decimal : digits;
            int selectedDigit = integerDigits - powerOfTen - 1;
            int selectionIndex = selectedDigit + (offset += decimal > -1 && selectedDigit >= decimal ? 1 : 0);
            return selectionIndex;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row = FunctionEditor.this.table.rowToSelect;
            String name = (String)FunctionEditor.this.table.getValueAt(row, 0);
            if (name.equals("t")) {
                this.startingPoint = null;
                return;
            }
            this.startingPoint = e.getPoint();
            this.newValue = this.prevValue;
            double level = 1.0 * (double)this.startingPoint.x / (double)this.cellEditor.dragPane.getWidth();
            this.logDelta = this.getLogDelta(this.cellEditor.popupField.getText(), level);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.startingPoint == null) {
                return;
            }
            this.prevValue = this.newValue;
            this.startingPoint = null;
            String val = this.cellEditor.popupField.getText();
            this.cellEditor.popupField.select(val.length(), val.length());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startingPoint == null || Double.isNaN(this.prevValue)) {
                return;
            }
            int pixelsPerStep = e.isShiftDown() ? 1 : 10;
            int d = (e.getPoint().x - this.startingPoint.x) / pixelsPerStep;
            double delta = Math.pow(10.0, this.logDelta);
            this.newValue = this.prevValue + (double)d * delta;
            String s = FunctionEditor.format(this.newValue, 0.0);
            int row = FunctionEditor.this.table.rowToSelect;
            FunctionEditor.this.table.setValueAt(s, row, 1);
            this.cellEditor.popupField.setText(s);
            this.cellEditor.popupField.setBackground(Color.yellow);
            this.cellEditor.popupField.requestFocusInWindow();
            String val = this.cellEditor.popupField.getText();
            int index = this.getSelectionIndex(val);
            this.cellEditor.popupField.select(index, index + 1);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            double level = 1.0 * (double)e.getPoint().x / (double)this.cellEditor.dragPane.getWidth();
            String val = this.cellEditor.popupField.getText();
            this.logDelta = this.getLogDelta(val, level);
            int index = this.getSelectionIndex(val);
            this.cellEditor.popupField.select(index, index + 1);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.cellEditor.dragPane.setCursor(Cursor.getPredefinedCursor(10));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.cellEditor.dragPane.setCursor(Cursor.getDefaultCursor());
        }
    }
}

