/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.opensourcephysics.analysis.FourierSinCosAnalysis;
import org.opensourcephysics.display.ColorIcon;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.ToolsRes;

public class FourierPanel
extends JPanel {
    protected Dataset sourceData;
    protected PlottingPanel plot;
    protected DataTable table;
    protected DatasetManager fourierManager;
    protected JSplitPane splitPane;
    protected JCheckBox[] buttons;
    protected JPanel plotPanel;

    public FourierPanel() {
        super(new BorderLayout());
        this.createGUI();
    }

    protected void createGUI() {
        this.fourierManager = new DatasetManager();
        this.fourierManager.setXPointsLinked(true);
        this.table = new DataTable();
        this.table.add(this.fourierManager);
        this.plot = new PlottingPanel("", "", "");
        this.plotPanel = new JPanel(new BorderLayout());
        this.plotPanel.add((Component)this.plot, "Center");
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(1.0);
        JScrollPane scroller = new JScrollPane(this.table);
        this.splitPane.setRightComponent(scroller);
        this.splitPane.setLeftComponent(this.plotPanel);
        this.add((Component)this.splitPane, "Center");
    }

    protected void refreshFourierData(Dataset data, String name) {
        JDialog dialog = (JDialog)this.getTopLevelAncestor();
        dialog.setTitle(ToolsRes.getString("DataToolTab.Dialog.Fourier.Title"));
        this.fourierManager.removeDatasets();
        Data fourierData = FourierPanel.createFourierData(data);
        if (fourierData == null) {
            return;
        }
        ArrayList<Dataset> datasets = fourierData.getDatasets();
        this.createButtons(datasets);
        for (Dataset next : datasets) {
            this.fourierManager.addDataset(next);
        }
        this.table.refreshTable();
        name = TeXParser.removeSubscripting(name);
        String x = TeXParser.removeSubscripting(data.getXColumnName());
        String y = TeXParser.removeSubscripting(data.getYColumnName());
        this.plot.setTitle(String.valueOf(name) + " [" + x + ", " + y + "]");
        this.refreshPlot();
    }

    protected void refreshPlot() {
        this.plot.removeDrawables(Dataset.class);
        String s = "";
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].isSelected()) {
                Dataset data = this.fourierManager.getDataset(i);
                this.plot.addDrawable(data);
                this.plot.setXLabel(data.getXColumnName());
                if (s.length() > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + data.getYColumnName();
            }
            ++i;
        }
        this.plot.setYLabel(s);
        this.plot.repaint();
    }

    protected void createButtons(ArrayList<Dataset> datasets) {
        if (this.buttons == null) {
            this.buttons = new JCheckBox[datasets.size()];
            JPanel buttonPanel = new JPanel();
            this.plotPanel.add((Component)buttonPanel, "South");
            int i = 0;
            while (i < this.buttons.length) {
                Dataset next = datasets.get(i);
                this.buttons[i] = new PlotCheckBox(next.getYColumnName(), next.getFillColor());
                buttonPanel.add(this.buttons[i]);
                ++i;
            }
            this.buttons[0].setSelected(true);
        }
    }

    public static Data createFourierData(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        double[] x = dataset.getXPoints();
        double[] y = dataset.getYPoints();
        if (y.length < 2) {
            return null;
        }
        if (y.length % 2 == 1) {
            double[] xnew = new double[y.length - 1];
            double[] ynew = new double[xnew.length];
            System.arraycopy(x, 0, xnew, 0, xnew.length);
            System.arraycopy(y, 0, ynew, 0, ynew.length);
            dataset.clear();
            dataset.append(xnew, ynew);
            x = xnew;
            y = ynew;
        }
        FourierSinCosAnalysis fft = new FourierSinCosAnalysis();
        fft.doAnalysis(x, y, 0);
        return fft;
    }

    class PlotCheckBox
    extends JCheckBox {
        ColorIcon icon;
        Color outlineColor;
        Color fillColor;

        PlotCheckBox(String text, Color color) {
            super(text);
            this.fillColor = Color.WHITE;
            this.outlineColor = color;
            this.icon = new ColorIcon(this.fillColor, this.outlineColor, 13, 13);
            this.setIcon(this.icon);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox checkBox = (JCheckBox)e.getSource();
                    PlotCheckBox.this.setSelected(checkBox.isSelected());
                    FourierPanel.this.refreshPlot();
                }
            });
        }

        @Override
        public void setSelected(boolean select) {
            this.icon.setColor(select ? this.outlineColor : this.fillColor);
            super.setSelected(select);
        }
    }
}

