/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.XuggleRes;

public class DiagnosticsForXuggle {
    public static final String XUGGLE_INSTALLER_URL = "http://www.compadre.org/osp/items/detail.cfm?ID=11606";
    public static final String REQUEST_TRACKER = "Tracker";
    static String newline = System.getProperty("line.separator", "\n");
    static String[] xuggleJarNames = new String[]{"xuggle-xuggler.jar", "logback-core.jar", "logback-classic.jar", "slf4j-api.jar"};
    static int vmBitness;
    static String codeBase;
    static String xuggleHome;
    static String javaExtDirectory;
    static File[] codeBaseJars;
    static File[] xuggleHomeJars;
    static File[] javaExtensionJars;
    static String pathEnvironment;
    static String pathValue;
    static String requester;
    static Component dialogOwner;

    static {
        try {
            String name = "org.opensourcephysics.media.xuggle.XuggleIO";
            Class<?> xuggleClass = Class.forName(name);
            Method method = xuggleClass.getMethod("registerWithVideoIO", new Class[0]);
            method.invoke(null, null);
        }
        catch (Exception name) {
        }
        catch (Error name) {
            // empty catch block
        }
        vmBitness = OSPRuntime.getVMBitness();
        try {
            URL url = DiagnosticsForXuggle.class.getProtectionDomain().getCodeSource().getLocation();
            File myJarFile = new File(url.toURI());
            codeBase = myJarFile.getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        xuggleHome = System.getenv("XUGGLE_HOME");
        xuggleHomeJars = new File[xuggleJarNames.length];
        javaExtensionJars = new File[xuggleJarNames.length];
        codeBaseJars = new File[xuggleJarNames.length];
    }

    private DiagnosticsForXuggle() {
    }

    public static void setDialogOwner(Component owner) {
        dialogOwner = owner;
    }

    public static void aboutXuggle() {
        Object recommended;
        int status = DiagnosticsForXuggle.getStatusCode();
        if (OSPLog.getLevelValue() <= Level.CONFIG.intValue()) {
            OSPLog.config("XUGGLE_HOME = " + xuggleHome);
            OSPLog.config("Code base = " + codeBase);
            String javaHome = System.getProperty("java.home");
            String bitness = "(" + vmBitness + "-bit): ";
            OSPLog.config("Java VM " + bitness + javaHome);
            File[] xuggleJars = DiagnosticsForXuggle.getXuggleJarFiles(String.valueOf(xuggleHome) + "/share/java/jars");
            boolean hasAllHomeJars = xuggleJars[0] != null;
            int i = 1;
            while (i < xuggleJars.length) {
                hasAllHomeJars = hasAllHomeJars && xuggleJars[i] != null;
                ++i;
            }
            SimpleDateFormat sdf = new SimpleDateFormat();
            String[] jarDates = new String[xuggleJarNames.length];
            int i2 = 0;
            while (i2 < jarDates.length) {
                jarDates[i2] = xuggleJars[i2] == null ? "" : " modified " + sdf.format(xuggleJars[i2].lastModified());
                ++i2;
            }
            String[] jarSizes = new String[xuggleJarNames.length];
            int i3 = 0;
            while (i3 < jarSizes.length) {
                jarSizes[i3] = xuggleJars[i3] == null ? "" : " (file size " + xuggleJars[i3].length() / 1024L + "kB) ";
                ++i3;
            }
            String fileData = "Xuggle home files: ";
            int i4 = 0;
            while (i4 < jarSizes.length) {
                if (i4 > 0) {
                    fileData = String.valueOf(fileData) + ", ";
                }
                fileData = String.valueOf(fileData) + xuggleJarNames[i4] + " " + jarSizes[i4] + xuggleJars[i4] + jarDates[i4];
                ++i4;
            }
            OSPLog.config(fileData);
            xuggleJars = DiagnosticsForXuggle.getXuggleJarFiles(codeBase);
            i4 = 0;
            while (i4 < jarDates.length) {
                jarDates[i4] = xuggleJars[i4] == null ? "" : " modified " + sdf.format(xuggleJars[i4].lastModified());
                ++i4;
            }
            i4 = 0;
            while (i4 < jarSizes.length) {
                jarSizes[i4] = xuggleJars[i4] == null ? "" : " (file size " + xuggleJars[i4].length() / 1024L + "kB) ";
                ++i4;
            }
            fileData = "Code base files: ";
            i4 = 0;
            while (i4 < jarSizes.length) {
                if (i4 > 0) {
                    fileData = String.valueOf(fileData) + ", ";
                }
                fileData = String.valueOf(fileData) + xuggleJarNames[i4] + " " + jarSizes[i4] + xuggleJars[i4] + jarDates[i4];
                ++i4;
            }
            OSPLog.config(fileData);
            xuggleJars = DiagnosticsForXuggle.getJavaExtensionJars();
            i4 = 0;
            while (i4 < jarDates.length) {
                jarDates[i4] = xuggleJars[i4] == null ? "" : " modified " + sdf.format(xuggleJars[i4].lastModified());
                ++i4;
            }
            i4 = 0;
            while (i4 < jarSizes.length) {
                jarSizes[i4] = xuggleJars[i4] == null ? "" : " (file size " + xuggleJars[i4].length() / 1024L + "kB) ";
                ++i4;
            }
            fileData = "Java extension files: ";
            i4 = 0;
            while (i4 < jarSizes.length) {
                if (i4 > 0) {
                    fileData = String.valueOf(fileData) + ", ";
                }
                fileData = String.valueOf(fileData) + xuggleJarNames[i4] + " " + jarSizes[i4] + xuggleJars[i4] + jarDates[i4];
                ++i4;
            }
            OSPLog.config(fileData);
            OSPLog.config(String.valueOf(pathEnvironment) + " = " + pathValue);
        }
        if (status == 0) {
            String fileInfo = newline;
            String path = " " + XuggleRes.getString("Xuggle.Dialog.Unknown");
            String className = "com.xuggle.xuggler.IContainer";
            try {
                Class<?> xuggleClass = Class.forName(className);
                URL url = xuggleClass.getProtectionDomain().getCodeSource().getLocation();
                File codeFile = new File(url.toURI());
                path = " " + codeFile.getAbsolutePath();
                DateFormat format = DateFormat.getDateInstance(3);
                Date date = new Date(codeFile.lastModified());
                fileInfo = " (" + format.format(date) + ")";
            }
            catch (Exception xuggleClass) {
                // empty catch block
            }
            String version = DiagnosticsForXuggle.getXuggleVersion();
            String message = String.valueOf(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Version")) + " " + version + fileInfo + newline + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Home") + " " + xuggleHome + newline + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Path") + path;
            if (VideoIO.guessXuggleVersion() == 5.4) {
                recommended = XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message1");
                if (requester.equals(REQUEST_TRACKER)) {
                    recommended = String.valueOf(recommended) + "\n" + XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3");
                }
                message = String.valueOf(message) + "\n\n" + (String)recommended;
            }
            JOptionPane.showMessageDialog(dialogOwner, message, XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Title"), 1);
        } else {
            String[] diagnostic = DiagnosticsForXuggle.getDiagnosticMessage(status, requester);
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            recommended = diagnostic;
            int message = diagnostic.length;
            int version = 0;
            while (version < message) {
                String line = recommended[version];
                box.add(new JLabel(line));
                ++version;
            }
            boolean showPrefsQuestionForTracker = false;
            if (status == 7 && REQUEST_TRACKER.equals(requester) && dialogOwner != null) {
                if (OSPRuntime.isWindows()) {
                    TreeSet<String> jreDirs = ExtensionsManager.getManager().getPublicJREs(32);
                    showPrefsQuestionForTracker = !jreDirs.isEmpty();
                } else if (OSPRuntime.isMac()) {
                    showPrefsQuestionForTracker = true;
                }
            }
            if (showPrefsQuestionForTracker) {
                box.add(new JLabel("  "));
                String question = XuggleRes.getString("Xuggle.Dialog.AboutXuggle.ShowPrefs.Question");
                box.add(new JLabel(question));
                int response = JOptionPane.showConfirmDialog(dialogOwner, box, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 0, 1);
                if (response == 0) {
                    try {
                        Class<?> trackerClass = Class.forName("org.opensourcephysics.cabrillo.tracker.TFrame");
                        if (dialogOwner.getClass().equals(trackerClass)) {
                            Method m = trackerClass.getMethod("showPrefsDialog", String.class);
                            m.invoke((Object)dialogOwner, "runtime");
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                JOptionPane.showMessageDialog(dialogOwner, box, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 2);
            }
        }
    }

    public static void aboutXuggle(String request) {
        requester = request;
        DiagnosticsForXuggle.aboutXuggle();
    }

    public static File[] getXuggleJarFiles(String dir) {
        File[] jarFiles = new File[xuggleJarNames.length];
        int i = 0;
        while (i < jarFiles.length) {
            String next = xuggleJarNames[i];
            File file = new File(dir, next);
            jarFiles[i] = file.exists() ? file : null;
            ++i;
        }
        return jarFiles;
    }

    public static String[] getXuggleJarNames() {
        String[] names = new String[xuggleJarNames.length];
        System.arraycopy(xuggleJarNames, 0, names, 0, xuggleJarNames.length);
        return names;
    }

    public static File[] getJavaExtensionJars() {
        String separator;
        File[] xuggleFiles = new File[xuggleJarNames.length];
        String extFolders = XML.forwardSlash(System.getProperty("java.ext.dirs"));
        int n = extFolders.indexOf(separator = System.getProperty("path.separator"));
        if (n == -1) {
            javaExtDirectory = extFolders;
            xuggleFiles = DiagnosticsForXuggle.getXuggleJarFiles(extFolders);
            if (xuggleFiles[0] != null) {
                return xuggleFiles;
            }
        } else {
            String dir = extFolders;
            javaExtDirectory = null;
            while (xuggleFiles[0] == null && n > -1) {
                dir = extFolders.substring(0, n);
                if (javaExtDirectory == null) {
                    javaExtDirectory = dir;
                }
                extFolders = extFolders.substring(n + 1);
                xuggleFiles = DiagnosticsForXuggle.getXuggleJarFiles(dir);
                if (xuggleFiles[0] != null) {
                    javaExtDirectory = dir;
                    return xuggleFiles;
                }
                n = extFolders.indexOf(separator);
            }
        }
        return xuggleFiles;
    }

    public static int getStatusCode() {
        boolean mismatched;
        codeBaseJars = DiagnosticsForXuggle.getXuggleJarFiles(codeBase);
        javaExtensionJars = DiagnosticsForXuggle.getJavaExtensionJars();
        pathEnvironment = OSPRuntime.isWindows() ? "Path" : (OSPRuntime.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
        pathValue = System.getenv(pathEnvironment);
        if (VideoIO.getVideoType("Xuggle", null) != null) {
            return 0;
        }
        boolean completeExt = javaExtensionJars[0] != null;
        int i = 1;
        while (i < javaExtensionJars.length) {
            completeExt = completeExt && javaExtensionJars[i] != null;
            ++i;
        }
        boolean completeCodeBase = codeBaseJars[0] != null;
        int i2 = 1;
        while (i2 < codeBaseJars.length) {
            completeCodeBase = completeCodeBase && codeBaseJars[i2] != null;
            ++i2;
        }
        if (xuggleHome == null) {
            return completeExt ? 2 : (completeCodeBase ? 2 : 1);
        }
        xuggleHomeJars = DiagnosticsForXuggle.getXuggleJarFiles(String.valueOf(xuggleHome) + "/share/java/jars");
        boolean completeHome = xuggleHomeJars[0] != null;
        int i3 = 1;
        while (i3 < xuggleHomeJars.length) {
            completeHome = completeHome && xuggleHomeJars[i3] != null;
            ++i3;
        }
        if (!completeHome) {
            return 3;
        }
        if (!completeExt && !completeCodeBase) {
            return 5;
        }
        File loadableJar = completeExt ? javaExtensionJars[0] : codeBaseJars[0];
        long homeLength = xuggleHomeJars[0].length();
        boolean bl = mismatched = homeLength != loadableJar.length();
        if (mismatched) {
            return 6;
        }
        if (homeLength < 1000000L) {
            String folder = OSPRuntime.isWindows() ? "/bin" : "/lib";
            String xuggleLib = XML.forwardSlash(String.valueOf(xuggleHome) + folder);
            if (XML.forwardSlash(pathValue).indexOf(xuggleLib) == -1) {
                return 4;
            }
            if (vmBitness == 64 && OSPRuntime.isWindows()) {
                return 7;
            }
        }
        if (vmBitness == 32 && OSPRuntime.isMac()) {
            return 7;
        }
        return -1;
    }

    public static String[] getDiagnosticMessage(int status, String requester) {
        if (status == 0) {
            return null;
        }
        ArrayList<String> message = new ArrayList<String>();
        switch (status) {
            case 1: {
                message.add(XuggleRes.getString("Xuggle.Dialog.NoXuggle.Message1"));
                message.add(" ");
                if (REQUEST_TRACKER.equals(requester)) {
                    message.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    message.add(" ");
                    message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    message.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                message.add(XUGGLE_INSTALLER_URL);
                break;
            }
            case 2: {
                message.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message1"));
                if (REQUEST_TRACKER.equals(requester)) {
                    message.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    message.add(" ");
                    message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    message.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                message.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message2"));
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                message.add(XUGGLE_INSTALLER_URL);
                break;
            }
            case 3: {
                message.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.IncompleteXuggle.Message1"));
                if (REQUEST_TRACKER.equals(requester)) {
                    message.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    message.add(" ");
                    message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    message.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                message.add(XuggleRes.getString("Xuggle.Dialog.IncompleteXuggle.Message2"));
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                message.add(XUGGLE_INSTALLER_URL);
                break;
            }
            case 4: {
                message.add(XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message1"));
                message.add("\"" + pathEnvironment + "\" " + XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message2"));
                break;
            }
            case 5: {
                String missingJars = "";
                int i = 0;
                while (i < xuggleJarNames.length) {
                    if (javaExtensionJars[i] == null) {
                        if (missingJars.length() > 1) {
                            missingJars = String.valueOf(missingJars) + ", ";
                        }
                        missingJars = String.valueOf(missingJars) + xuggleJarNames[i];
                    }
                    ++i;
                }
                String source = String.valueOf(XML.forwardSlash(xuggleHome)) + "/share/java/jars";
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.NotWorking.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.Missing.Message"));
                message.add(" ");
                message.add(missingJars);
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message2"));
                message.add(" ");
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + source);
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.TargetDirectory.Message")) + " " + codeBase);
                break;
            }
            case 6: {
                String missingJars = "";
                int i = 0;
                while (i < xuggleJarNames.length) {
                    if (javaExtensionJars[i] == null) {
                        if (missingJars.length() > 1) {
                            missingJars = String.valueOf(missingJars) + ", ";
                        }
                        missingJars = String.valueOf(missingJars) + xuggleJarNames[i];
                    }
                    ++i;
                }
                String source = String.valueOf(XML.forwardSlash(xuggleHome)) + "/share/java/jars";
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.NotWorking.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.Mismatched.Message"));
                message.add(" ");
                message.add(missingJars);
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message2"));
                message.add(" ");
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + source);
                message.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.TargetDirectory.Message")) + " " + codeBase);
                break;
            }
            case 7: {
                if (OSPRuntime.isMac()) {
                    message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message1"));
                    message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message2"));
                    if (!REQUEST_TRACKER.equals(requester)) break;
                    message.add(" ");
                    message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message3"));
                    message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message4"));
                    break;
                }
                message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMWindows.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.WrongVMWindows.Message2"));
                message.add(" ");
                TreeSet<String> jreDirs = ExtensionsManager.getManager().getPublicJREs(32);
                if (jreDirs.isEmpty()) {
                    if (REQUEST_TRACKER.equals(requester)) {
                        message.add(XuggleRes.getString("Xuggle.Dialog.NoVMTracker.Message1"));
                        message.add(XuggleRes.getString("Xuggle.Dialog.NoVMTracker.Message2"));
                        break;
                    }
                    message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message1"));
                    message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message2"));
                    message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message3"));
                    message.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message4"));
                    break;
                }
                if (!REQUEST_TRACKER.equals(requester)) break;
                message.add(XuggleRes.getString("Xuggle.Dialog.SetVM.Message1"));
                message.add(XuggleRes.getString("Xuggle.Dialog.SetVM.Message2"));
                break;
            }
            default: {
                message.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                message.add(XuggleRes.getString("Xuggle.Dialog.UnknownProblem.Message"));
                if (REQUEST_TRACKER.equals(requester)) {
                    message.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    message.add(" ");
                    message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    message.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                message.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message2"));
                message.add(" ");
                message.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                message.add(XUGGLE_INSTALLER_URL);
            }
        }
        return message.toArray(new String[message.size()]);
    }

    public static String getXuggleVersion() {
        String xuggleVersion = XuggleRes.getString("Xuggle.Dialog.Unknown");
        int status = DiagnosticsForXuggle.getStatusCode();
        if (status == 0) {
            try {
                String name = "com.xuggle.xuggler.Version";
                Class<?> xuggleClass = Class.forName(name);
                Method method = xuggleClass.getMethod("getVersionString", new Class[0]);
                xuggleVersion = (String)method.invoke(null, null);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return xuggleVersion;
    }

    public static void main(String[] args) {
        System.out.println(DiagnosticsForXuggle.getXuggleVersion());
        DiagnosticsForXuggle.aboutXuggle();
    }
}

