/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractSpinnerModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Selectable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolPropsTable;
import org.opensourcephysics.tools.DataToolStatsTable;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FourierPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

public class DataToolTab
extends JPanel
implements Tool,
PropertyChangeListener {
    public static final String SHIFTED = "'";
    protected static NumberFormat correlationFormat = NumberFormat.getInstance();
    private static final Cursor SELECT_CURSOR;
    private static final Cursor SELECT_REMOVE_CURSOR;
    private static final Cursor SELECT_ZOOM_CURSOR;
    protected DataTool dataTool;
    protected int originatorID = 0;
    protected DatasetManager dataManager = new DatasetManager();
    protected JSplitPane[] splitPanes;
    protected DataToolPlotter plot;
    protected DataToolTable dataTable;
    protected DataToolStatsTable statsTable;
    protected DataToolPropsTable propsTable;
    protected JScrollPane dataScroller;
    protected JScrollPane statsScroller;
    protected JScrollPane propsScroller;
    protected JScrollPane tableScroller;
    protected JToolBar toolbar;
    protected JCheckBoxMenuItem statsCheckbox;
    protected JCheckBoxMenuItem fitterCheckbox;
    protected JCheckBoxMenuItem propsCheckbox;
    protected JCheckBoxMenuItem fourierCheckbox;
    protected DatasetCurveFitter curveFitter;
    protected FourierPanel fourierPanel;
    protected JDialog fourierDialog;
    protected JButton measureButton;
    protected JButton analyzeButton;
    protected JButton dataBuilderButton;
    protected JButton newColumnButton;
    protected JButton refreshDataButton;
    protected JCheckBoxMenuItem valueCheckbox;
    protected JCheckBoxMenuItem slopeCheckbox;
    protected JCheckBoxMenuItem areaCheckbox;
    protected Action fitterAction;
    protected Action propsAndStatsAction;
    protected String fileName;
    protected String ownerName;
    protected Map<String, String[]> ownedColumns = new TreeMap<String, String[]>();
    protected JButton helpButton;
    protected int colorIndex = 0;
    protected boolean tabChanged;
    protected boolean userEditable = false;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected FunctionTool dataBuilder;
    protected JobManager jobManager = new JobManager(this);
    protected JLabel statusLabel;
    protected JLabel editableLabel;
    protected CartesianInteractive plotAxes;
    protected boolean positionVisible = false;
    protected boolean slopeVisible = false;
    protected boolean areaVisible = false;
    protected boolean originShiftEnabled = false;
    protected boolean measureFit = false;
    protected JPopupMenu varPopup;
    protected boolean isHorzVarPopup;
    protected Action setVarAction;
    protected boolean isInitialized = false;
    protected Object[][] constantsLoadedFromXML;
    protected boolean replaceColumnsWithMatchingNames = true;
    protected JCheckBoxMenuItem measureFitCheckbox;
    protected JCheckBoxMenuItem originShiftCheckbox;
    protected double prevShiftX;
    protected double prevShiftY;
    protected DatasetCurveFitter.NumberField shiftXField;
    protected DatasetCurveFitter.NumberField shiftYField;
    protected DatasetCurveFitter.NumberField selectedXField;
    protected DatasetCurveFitter.NumberField selectedYField;
    protected JSpinner shiftXSpinner;
    protected JSpinner shiftYSpinner;
    protected ShiftEditListener shiftEditListener;
    protected JLabel shiftXLabel;
    protected JLabel shiftYLabel;
    protected JLabel selectedXLabel;
    protected JLabel selectedYLabel;
    protected int selectedDataIndex = -1;
    protected boolean toggleMeasurement;
    protected boolean freezeMeasurement;

    static {
        if (correlationFormat instanceof DecimalFormat) {
            DecimalFormat format = (DecimalFormat)correlationFormat;
            format.applyPattern("0.000");
        }
        String imageFile = "/org/opensourcephysics/resources/tools/images/selectcursor.gif";
        Image im = ResourceLoader.getImage(imageFile);
        SELECT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(0, 0), "Add points");
        imageFile = "/org/opensourcephysics/resources/tools/images/selectremovecursor.gif";
        im = ResourceLoader.getImage(imageFile);
        SELECT_REMOVE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(0, 0), "Remove points");
        imageFile = "/org/opensourcephysics/resources/tools/images/selectzoomcursor.gif";
        im = ResourceLoader.getImage(imageFile);
        SELECT_ZOOM_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(8, 8), "Zoom");
    }

    public DataToolTab(Data data, DataTool tool) {
        String s;
        this.dataTool = tool;
        this.dataTable = new DataToolTable(this);
        this.createGUI();
        String name = ToolsRes.getString("DataToolTab.DefaultName");
        if (data != null && (s = data.getName()) != null && !s.equals("")) {
            name = s;
        }
        this.setName(name);
        this.loadData(data, false);
        this.tabChanged(false);
    }

    public ArrayList<DataColumn> loadData(Data data, boolean replaceIfSameName) {
        ArrayList<DataColumn> loadedColumns = new ArrayList<DataColumn>();
        if (data == null) {
            return loadedColumns;
        }
        ArrayList<DataColumn> inputColumns = DataTool.getAllDataColumns(data);
        if (inputColumns == null) {
            return loadedColumns;
        }
        boolean updatedColumns = false;
        if (this.dataManager.getDatasets().isEmpty()) {
            this.originatorID = data.getID();
            for (DataColumn next : inputColumns) {
                this.addColumn(next);
                loadedColumns.add(next);
            }
        } else {
            for (Dataset local : this.dataManager.getDatasets()) {
                DataColumn match = this.getIDMatch(local, inputColumns);
                if (match != null) {
                    String localName = local.getYColumnName();
                    String name = match.getYColumnName();
                    local.setXYColumnNames("row", "");
                    name = this.getUniqueYColumnName(match, name, false);
                    local.setXYColumnNames("row", localName);
                    if (!Arrays.equals(local.getYPoints(), match.getYPoints()) || !name.equals(localName)) {
                        local.clear();
                        double[] rows = DataTool.getRowArray(match.getIndex());
                        local.append(rows, match.getYPoints());
                        local.setXYColumnNames("row", name);
                        updatedColumns = true;
                    }
                    inputColumns.remove(match);
                    continue;
                }
                if (!replaceIfSameName || (match = this.getNameMatch(local, inputColumns)) == null) continue;
                if (!Arrays.equals(local.getYPoints(), match.getYPoints())) {
                    local.clear();
                    double[] rows = DataTool.getRowArray(match.getIndex());
                    local.append(rows, match.getYPoints());
                    updatedColumns = true;
                }
                inputColumns.remove(match);
            }
            for (DataColumn next : inputColumns) {
                this.addColumn(next);
                loadedColumns.add(next);
            }
        }
        if (updatedColumns || !loadedColumns.isEmpty()) {
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            this.refreshPlot();
            this.refreshGUI();
            this.tabChanged(true);
            this.varPopup = null;
        }
        return loadedColumns;
    }

    public void addColumns(Data source, boolean deletable, boolean addDuplicates, boolean postEdit) {
        double[] indepVarPts;
        ArrayList<Dataset> datasets = this.dataManager.getDatasets();
        Dataset indepVar = datasets.isEmpty() ? null : datasets.get(0);
        double[] dArray = indepVarPts = indepVar == null ? null : indepVar.getYPoints();
        if (indepVarPts != null) {
            while (indepVarPts.length > 0 && Double.isNaN(indepVarPts[indepVarPts.length - 1])) {
                double[] newVals = new double[indepVarPts.length - 1];
                System.arraycopy(indepVarPts, 0, newVals, 0, newVals.length);
                indepVarPts = newVals;
            }
        }
        indepVar = indepVarPts == null || DataTool.containsDuplicateValues(indepVarPts) ? null : indepVar;
        ArrayList<DataColumn> inputColumns = DataTool.getDataColumns(source);
        DataColumn duplicate = null;
        if (indepVar != null) {
            String indepVarName = indepVar.getYColumnName();
            for (DataColumn next : inputColumns) {
                int index;
                if (duplicate != null || !next.getYColumnName().equals(indepVarName)) continue;
                double[] inputPts = next.getYPoints();
                while (inputPts.length > 0 && Double.isNaN(inputPts[inputPts.length - 1])) {
                    double[] newVals = new double[inputPts.length - 1];
                    System.arraycopy(inputPts, 0, newVals, 0, newVals.length);
                    inputPts = newVals;
                }
                if (DataTool.containsDuplicateValues(inputPts)) continue;
                boolean foundMatchingPoint = false;
                double[] dArray2 = inputPts;
                int n = inputPts.length;
                int n2 = 0;
                while (n2 < n) {
                    double value = dArray2[n2];
                    if (DataTool.getIndex(value, indepVarPts, -1) > -1) {
                        foundMatchingPoint = true;
                        break;
                    }
                    ++n2;
                }
                if (!foundMatchingPoint) continue;
                duplicate = next;
                int trend = 1;
                double prev = -1.7976931348623157E308;
                double[] dArray3 = indepVarPts;
                int n3 = indepVarPts.length;
                int n4 = 0;
                while (n4 < n3) {
                    double d = dArray3[n4];
                    if (!(d > prev)) {
                        trend = -1;
                        break;
                    }
                    prev = d;
                    ++n4;
                }
                if (trend == -1) {
                    prev = Double.MAX_VALUE;
                    dArray3 = indepVarPts;
                    n3 = indepVarPts.length;
                    n4 = 0;
                    while (n4 < n3) {
                        double d = dArray3[n4];
                        if (!(d < prev)) {
                            trend = 0;
                            break;
                        }
                        prev = d;
                        ++n4;
                    }
                }
                double[] newIndepVarPts = new double[indepVarPts.length];
                System.arraycopy(indepVarPts, 0, newIndepVarPts, 0, indepVarPts.length);
                double[] valuesInserted = new double[inputPts.length];
                int len = 0;
                int i = 0;
                while (i < inputPts.length) {
                    int index2 = DataTool.getIndex(inputPts[i], indepVarPts, -1);
                    if (index2 == -1) {
                        valuesInserted[len] = inputPts[i];
                        ++len;
                        newIndepVarPts = DataTool.insert(inputPts[i], newIndepVarPts, trend);
                    }
                    ++i;
                }
                if (len <= 0) continue;
                double[] rowsInserted = new double[len];
                int[] rowsToInsert = new int[len];
                int i2 = 0;
                while (i2 < len) {
                    double val = valuesInserted[i2];
                    index = DataTool.getIndex(val, newIndepVarPts, -1);
                    rowsInserted[i2] = index;
                    rowsToInsert[i2] = index;
                    ++i2;
                }
                Arrays.sort(rowsToInsert);
                double[] valuesToInsert = new double[len];
                int i3 = 0;
                while (i3 < len) {
                    int row = rowsToInsert[i3];
                    index = DataTool.getIndex(row, rowsInserted, -1);
                    valuesToInsert[i3] = valuesInserted[index];
                    ++i3;
                }
                this.dataTable.pasteValues.clear();
                this.dataTable.pasteValues.put(indepVarName, valuesToInsert);
                HashMap<String, double[]> prevState = this.dataTable.insertRows(rowsToInsert, this.dataTable.pasteValues);
                DataToolTable dataToolTable = this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit edit = dataToolTable.new DataToolTable.TableEdit(6, null, rowsToInsert, prevState);
                this.undoSupport.postEdit(edit);
                for (DataColumn d : inputColumns) {
                    if (d == duplicate) continue;
                    double[] prevY = d.getYPoints();
                    double[] rows = DataTool.getRowArray(newIndepVarPts.length);
                    double[] newY = new double[rows.length];
                    Arrays.fill(newY, Double.NaN);
                    int k = Math.min(inputPts.length, prevY.length);
                    int i4 = 0;
                    while (i4 < k) {
                        int index3 = DataTool.getIndex(inputPts[i4], newIndepVarPts, -1);
                        newY[index3] = prevY[i4];
                        ++i4;
                    }
                    d.clear();
                    d.append(rows, newY);
                }
            }
        }
        inputColumns.remove(duplicate);
        this.addColumns(inputColumns, deletable, addDuplicates, postEdit);
    }

    protected void addColumns(ArrayList<DataColumn> columns, boolean deletable, boolean addDuplicates, boolean postEdit) {
        for (DataColumn next : columns) {
            int id = next.getID();
            if (addDuplicates) {
                next.setID(-id);
            }
            ArrayList<DataColumn> loadedColumns = this.loadData(next, false);
            next.setID(id);
            if (loadedColumns.isEmpty()) continue;
            for (DataColumn dc : loadedColumns) {
                dc.deletable = deletable;
            }
            if (postEdit) {
                int col = this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit edit = dataToolTable.new DataToolTable.TableEdit(1, next.getYColumnName(), new Integer(col), next);
                this.undoSupport.postEdit(edit);
            }
            this.refreshDataBuilder();
        }
        this.dataTable.refreshUndoItems();
        this.refreshGUI();
    }

    public void setWorkingColumns(String xColName, String yColName) {
        this.dataTable.setWorkingColumns(xColName, yColName);
    }

    @Override
    public void setName(String name) {
        name = this.replaceSpacesWithUnderscores(name);
        super.setName(name);
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
        }
    }

    public void setUserEditable(boolean editable) {
        if (this.userEditable == editable) {
            return;
        }
        this.userEditable = editable;
        this.refreshGUI();
    }

    public boolean isUserEditable() {
        return this.userEditable && !this.originShiftEnabled;
    }

    public FunctionTool getDataBuilder() {
        if (this.dataTool != null) {
            return this.dataTool.getDataBuilder();
        }
        if (this.dataBuilder == null) {
            this.dataBuilder = new FunctionTool(this){

                @Override
                protected void refreshGUI() {
                    super.refreshGUI();
                    this.dropdown.setToolTipText(ToolsRes.getString("DataTool.DataBuilder.Dropdown.Tooltip"));
                    this.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
                }
            };
            this.dataBuilder.setFontLevel(FontSizer.getLevel());
            this.dataBuilder.setHelpPath("data_builder_help.html");
            this.dataBuilder.addPropertyChangeListener("function", this);
        }
        this.refreshDataBuilder();
        return this.dataBuilder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("function")) {
            String funcName;
            this.tabChanged(true);
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            if (e.getNewValue() instanceof DataFunction) {
                funcName = e.getNewValue().toString();
                this.dataTable.getWorkingData(funcName);
            }
            if (e.getOldValue() instanceof DataFunction) {
                funcName = e.getOldValue().toString();
                this.dataTable.removeWorkingData(funcName);
            }
            if (e.getNewValue() instanceof String) {
                funcName = e.getNewValue().toString();
                if (e.getOldValue() instanceof String) {
                    String prevName = e.getOldValue().toString();
                    this.columnNameChanged(prevName, funcName);
                } else {
                    this.dataTable.getWorkingData(funcName);
                }
            }
            this.refreshPlot();
            this.varPopup = null;
        }
    }

    @Override
    public void send(Job job, Tool replyTo) throws RemoteException {
        XMLControlElement control = new XMLControlElement(job.getXML());
        if (control.failedToRead() || control.getObjectClass() == Object.class) {
            return;
        }
        this.jobManager.log(job, replyTo);
        if (Data.class.isAssignableFrom(control.getObjectClass())) {
            Data data = (Data)control.loadObject(null, true, true);
            this.loadData(data, this.replaceColumnsWithMatchingNames);
            this.jobManager.associate(job, this.dataManager);
            this.refreshGUI();
        } else if (DataToolTab.class.isAssignableFrom(control.getObjectClass())) {
            control.loadObject(this);
            this.refreshGUI();
        }
    }

    public void addFitFunction(KnownFunction f, boolean addToFitBuilder) {
        this.curveFitter.addFitFunction(f, addToFitBuilder);
    }

    public void clearData() {
        ArrayList<String> colNames = new ArrayList<String>();
        for (Dataset next : this.dataManager.getDatasets()) {
            colNames.add(next.getYColumnName());
        }
        this.dataTable.setSelectedColumnNames(colNames);
        this.dataTable.deleteSelectedColumns();
    }

    public void setReplaceColumnsWithMatchingNames(boolean replace) {
        this.replaceColumnsWithMatchingNames = replace;
    }

    public boolean isInterestedIn(Data data) {
        if (data == null) {
            return false;
        }
        if (this.isOwnedBy(data)) {
            return true;
        }
        Collection<Tool> tools2 = this.jobManager.getTools(this.dataManager);
        for (Tool tool : tools2) {
            if (!(tool instanceof DataRefreshTool)) continue;
            DataRefreshTool refresher = (DataRefreshTool)tool;
            if (!refresher.moreData.contains(data)) continue;
            return true;
        }
        return false;
    }

    public boolean setOwnedColumnIDs(String columnOwnerName, Data data) {
        HashSet<String> namesToMatch = new HashSet<String>();
        for (String colName : this.ownedColumns.keySet()) {
            String[] dataNames = this.ownedColumns.get(colName);
            if (dataNames == null || !dataNames[0].equals(columnOwnerName)) continue;
            namesToMatch.add(colName);
        }
        Map<DataColumn, Dataset> matches = this.getColumnMatchesByName(namesToMatch, data);
        for (DataColumn column : matches.keySet()) {
            Dataset match = matches.get(column);
            column.setID(match.getID());
        }
        return !matches.isEmpty();
    }

    public void saveOwnedColumnNames(String columnOwnerName, Data data) {
        Map<DataColumn, Dataset> matches = this.getColumnMatchesByID(data);
        for (DataColumn column : matches.keySet()) {
            Dataset match = matches.get(column);
            this.ownedColumns.put(column.getYColumnName(), new String[]{columnOwnerName, match.getYColumnName()});
        }
    }

    public String getColumnName(int ID2) {
        for (Dataset column : this.dataManager.getDatasets()) {
            if (column.getID() != ID2) continue;
            return column.getYColumnName();
        }
        return null;
    }

    public boolean isOwnedBy(Data data) {
        if (data == null) {
            return false;
        }
        String name = data.getName();
        if (name != null && this.replaceSpacesWithUnderscores(name).equals(this.getName())) {
            return true;
        }
        return data.getID() == this.originatorID;
    }

    public void setOwner(String name, Data data) {
        this.ownerName = name;
        this.originatorID = data.getID();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void refreshData() {
        this.dataManager.setName(this.getName());
        this.jobManager.sendReplies(this.dataManager);
    }

    protected void addColumn(DataColumn column) {
        String yName;
        String name = column.getYColumnName();
        if (!name.equals(yName = this.getUniqueYColumnName(column, name, false))) {
            String xName = column.getXColumnName();
            column.setXYColumnNames(xName, yName);
        }
        if (this.dataManager.getDatasets().isEmpty()) {
            column.setMarkerColor(Color.BLACK);
            column.setLineColor(Color.BLACK);
        }
        this.dataManager.addDataset(column);
        this.dataTable.getWorkingData(yName);
    }

    protected boolean isDeletable(Dataset data) {
        return data != null;
    }

    protected String replaceSpacesWithUnderscores(String name) {
        name.trim();
        int n = name.indexOf(" ");
        while (n > -1) {
            name = String.valueOf(name.substring(0, n)) + "_" + name.substring(n + 1);
            n = name.indexOf(" ");
        }
        return name;
    }

    protected void refreshDataBuilder() {
        if (this.dataTool != null) {
            this.dataTool.refreshDataBuilder();
            return;
        }
        if (this.dataBuilder == null) {
            return;
        }
        if (this.dataBuilder.getPanel(this.getName()) == null) {
            DataFunctionPanel panel = new DataFunctionPanel(this.dataManager);
            this.dataBuilder.addPanel(this.getName(), panel);
        }
        for (String name : this.dataBuilder.panels.keySet()) {
            if (name.equals(this.getName())) continue;
            this.dataBuilder.removePanel(name);
        }
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        this.plot.setFontLevel(level);
        FontSizer.setFonts(this.statsTable, level);
        FontSizer.setFonts(this.propsTable, level);
        this.curveFitter.setFontLevel(level);
        double factor = FontSizer.getFactor(level);
        this.plot.getAxes().resizeFonts(factor, this.plot);
        FontSizer.setFonts(this.plot.getPopupMenu(), level);
        if (this.propsTable.styleDialog != null) {
            FontSizer.setFonts(this.propsTable.styleDialog, level);
            this.propsTable.styleDialog.pack();
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(level);
        }
        this.fitterAction.actionPerformed(null);
        this.propsTable.refreshTable();
        FontSizer.setFonts(this.shiftXLabel, level);
        FontSizer.setFonts(this.shiftYLabel, level);
        FontSizer.setFonts(this.selectedXLabel, level);
        FontSizer.setFonts(this.selectedYLabel, level);
        FontSizer.setFonts(this.shiftXField, level);
        FontSizer.setFonts(this.shiftYField, level);
        FontSizer.setFonts(this.selectedXField, level);
        FontSizer.setFonts(this.selectedYField, level);
        this.shiftXField.refreshPreferredWidth();
        this.shiftYField.refreshPreferredWidth();
        this.selectedXField.refreshPreferredWidth();
        this.selectedYField.refreshPreferredWidth();
        this.toolbar.revalidate();
        this.refreshStatusBar(null);
        this.propsAndStatsAction.actionPerformed(null);
        Timer timer = new Timer(1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab.this.propsAndStatsAction.actionPerformed(null);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    protected void tabChanged(boolean changed) {
        this.tabChanged = changed;
    }

    protected DataToolTable.WorkingDataset getWorkingData() {
        return this.dataTable.workingData;
    }

    protected String getUniqueYColumnName(Dataset d, String proposed, boolean askUser) {
        if (proposed == null) {
            return null;
        }
        proposed = proposed.replaceAll(" ", "");
        boolean containsOperators = this.containsOperators(proposed);
        if (askUser || containsOperators) {
            int tries = 0;
            int maxTries = 3;
            while (tries < maxTries) {
                Object response;
                ++tries;
                if (this.isDuplicateName(d, proposed)) {
                    response = JOptionPane.showInputDialog(this, "\"" + proposed + "\" " + ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2, null, null, proposed);
                    String string = proposed = response == null ? null : response.toString();
                }
                if (proposed == null || proposed.equals("")) {
                    return null;
                }
                if (this.isReservedName(proposed)) {
                    response = JOptionPane.showInputDialog(this, "\"" + proposed + "\" " + ToolsRes.getString("DataToolTab.Dialog.ReservedName.Message"), ToolsRes.getString("DataToolTab.Dialog.ReservedName.Title"), 2, null, null, proposed);
                    String string = proposed = response == null ? null : response.toString();
                }
                if (proposed == null || proposed.equals("")) {
                    return null;
                }
                containsOperators = this.containsOperators(proposed);
                if (containsOperators) {
                    response = JOptionPane.showInputDialog(this, ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Message"), ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Title"), 2, null, null, proposed);
                    String string = proposed = response == null ? null : response.toString();
                }
                if (proposed != null && !proposed.equals("")) continue;
                return null;
            }
        }
        if (containsOperators) {
            return null;
        }
        int i = 0;
        try {
            Double.parseDouble(proposed);
            proposed = ToolsRes.getString("DataToolTab.NewColumn.Name");
        }
        catch (NumberFormatException maxTries) {
            // empty catch block
        }
        boolean subscriptRemoved = false;
        if (this.isDuplicateName(d, proposed)) {
            String subscript = TeXParser.getSubscript(proposed);
            try {
                i = Integer.parseInt(subscript);
                proposed = TeXParser.removeSubscript(proposed);
                subscriptRemoved = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String name = proposed;
        while (subscriptRemoved || this.isDuplicateName(d, name) || this.isReservedName(name)) {
            name = TeXParser.addSubscript(proposed, String.valueOf(++i));
            subscriptRemoved = false;
        }
        return name;
    }

    protected boolean isDuplicateName(Dataset d, String name) {
        if (this.dataManager.getDatasets().isEmpty()) {
            return false;
        }
        if (this.dataManager.getDataset(0).getXColumnName().equals(name)) {
            return true;
        }
        name = TeXParser.removeSubscripting(name);
        for (Dataset next : this.dataManager.getDatasets()) {
            String s;
            if (next == d || !(s = TeXParser.removeSubscripting(next.getYColumnName())).equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean isReservedName(String name) {
        String[] s = FunctionTool.parserNames;
        int i = 0;
        while (i < s.length) {
            if (s[i].equals(name)) {
                return true;
            }
            ++i;
        }
        if (DataTable.rowName.equals(name)) {
            return true;
        }
        s = UserFunction.dummyVars;
        i = 0;
        while (i < s.length) {
            if (s[i].equals(name)) {
                return true;
            }
            ++i;
        }
        try {
            Double.parseDouble(name);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected boolean containsOperators(String name) {
        String[] stringArray = FunctionTool.parserOperators;
        int n = FunctionTool.parserOperators.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (name.indexOf(next) > -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void columnNameChanged(String oldName, String newName) {
        this.tabChanged(true);
        this.varPopup = null;
        String pattern = this.dataTable.getFormatPattern(oldName);
        this.dataTable.removeWorkingData(oldName);
        this.dataTable.getWorkingData(newName);
        this.dataTable.setFormatPattern(newName, pattern);
        if (this.propsTable.styleDialog != null && this.propsTable.styleDialog.isVisible() && this.propsTable.styleDialog.getName().equals(oldName)) {
            this.propsTable.styleDialog.setName(newName);
            String title = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
            String var = TeXParser.removeSubscripting(newName);
            this.propsTable.styleDialog.setTitle(String.valueOf(title) + " \"" + var + "\"");
        }
        this.statsTable.refreshStatistics();
        DataToolTable.WorkingDataset working = this.getWorkingData();
        if (working == null) {
            return;
        }
        this.refreshPlot();
    }

    protected DataColumn createDataColumn() {
        Color markerColor = DisplayColors.getMarkerColor(this.colorIndex);
        Color lineColor = DisplayColors.getLineColor(this.colorIndex);
        if (!this.dataManager.getDatasets().isEmpty()) {
            ++this.colorIndex;
        }
        DataColumn column = new DataColumn();
        column.setMarkerColor(markerColor);
        column.setLineColor(lineColor);
        column.setConnected(false);
        int rowCount = Math.max(1, this.dataTable.getRowCount());
        double[] y = new double[rowCount];
        Arrays.fill(y, Double.NaN);
        column.setPoints(y);
        column.setXColumnVisible(false);
        return column;
    }

    protected String saveTableDataToFile() {
        String tabName = this.getName();
        OSPLog.finest("saving tabe data from " + tabName);
        JFileChooser chooser = OSPRuntime.getChooser();
        chooser.setSelectedFile(new File(String.valueOf(tabName) + ".txt"));
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            fileName = XML.getRelativePath(fileName);
            String data = this.getSelectedTableData();
            return DataTool.write(data, fileName);
        }
        return null;
    }

    protected void copyTableDataToClipboard() {
        OSPLog.finest("copying table data from " + this.getName());
        DataTool.copy(this.getSelectedTableData());
    }

    protected String getSelectedTableData() {
        StringBuffer buf = new StringBuffer();
        if (this.getName() != null) {
            buf.append(String.valueOf(this.getName()) + "\n");
        }
        if (this.dataTable.getColumnCount() == 1 || this.dataTable.getRowCount() == 0) {
            return buf.toString();
        }
        this.dataTable.clearSelectionIfEmptyEndRow();
        int[] rows = this.dataTable.getSelectedRows();
        if (rows.length == 0) {
            this.dataTable.selectAllCells();
            rows = this.dataTable.getSelectedRows();
        }
        int[] columns = this.dataTable.getSelectedColumns();
        int j = 0;
        while (j < columns.length) {
            int col = columns[j];
            int modelCol = this.dataTable.convertColumnIndexToModel(col);
            if (!this.dataTable.isRowNumberVisible() || modelCol != 0) {
                buf.append(this.dataTable.getColumnName(col));
                buf.append("\t");
            }
            ++j;
        }
        buf.setLength(buf.length() - 1);
        buf.append("\n");
        DateFormat df = DateFormat.getInstance();
        int i = 0;
        while (i < rows.length) {
            int j2 = 0;
            while (j2 < columns.length) {
                int col = columns[j2];
                int modelCol = this.dataTable.convertColumnIndexToModel(col);
                if (!this.dataTable.isRowNumberVisible() || modelCol != 0) {
                    Object value = this.dataTable.getValueAt(rows[i], col);
                    if (value != null) {
                        if (value instanceof Date) {
                            value = df.format(value);
                        }
                        buf.append(value);
                    }
                    buf.append("\t");
                }
                ++j2;
            }
            buf.setLength(buf.length() - 1);
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    protected void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DataToolTab.this.refreshGUI();
            }
        });
        this.setLayout(new BorderLayout());
        this.splitPanes = new JSplitPane[3];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(0.7);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[1].setDividerSize(0);
        this.splitPanes[2] = new JSplitPane(0){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = DataToolTab.this.dataTable.getMinimumTableWidth() + 6;
                JScrollBar scrollbar = DataToolTab.this.dataScroller.getVerticalScrollBar();
                if (scrollbar.isVisible()) {
                    dim.width += scrollbar.getWidth();
                }
                dim.height = 1;
                return dim;
            }
        };
        this.splitPanes[2].setDividerSize(0);
        this.splitPanes[2].setEnabled(false);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                OSPLog.getOSPLog();
                if (DataToolTab.this.getSize().width > 0) {
                    DataToolTab.this.init();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DataToolTab.this.fitterAction.actionPerformed(null);
            }
        });
        this.dataTool.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                DataToolTab.this.fitterAction.actionPerformed(null);
            }
        });
        this.dataTable.setRowNumberVisible(true);
        this.dataScroller = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        this.dataTable.addPropertyChangeListener("format", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DataToolTab.this.refreshShiftFields();
            }
        });
        this.dataScroller.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DataToolTab.this.dataTable.clearSelection();
            }
        });
        this.dataScroller.setToolTipText(ToolsRes.getString("DataToolTab.Scroller.Tooltip"));
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                DataToolTable.WorkingDataset prev = DataToolTab.this.dataTable.workingData;
                DataToolTable.WorkingDataset working = DataToolTab.this.getWorkingData();
                if (working != prev && DataToolTab.this.dataTool.fitBuilder != null) {
                    DataToolTab.this.tabChanged(true);
                }
                if (working == null || working == prev) {
                    return;
                }
                DataToolTab.this.plot.selectionBox.setSize(0, 0);
                DataToolTab.this.refreshPlot();
                DataToolTab.this.refreshShiftFields();
            }
        });
        this.fitterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataToolTab.this.fitterCheckbox == null) {
                    return;
                }
                DataToolTab.this.splitPanes[1].remove(DataToolTab.this.curveFitter);
                DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[2].getDividerSize());
                DataToolTab.this.splitPanes[1].setDividerLocation(1.0);
                DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                boolean fitterVis = DataToolTab.this.fitterCheckbox.isSelected();
                DataToolTab.this.splitPanes[1].setEnabled(fitterVis);
                DataToolTab.this.curveFitter.setActive(fitterVis);
                if (fitterVis) {
                    DataToolTab.this.splitPanes[1].setBottomComponent(DataToolTab.this.curveFitter);
                    DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[0].getDividerSize());
                    DataToolTab.this.splitPanes[1].setDividerLocation(-1);
                    DataToolTab.this.plot.addDrawable(DataToolTab.this.curveFitter.getDrawer());
                }
                if (e != null) {
                    DataToolTab.this.refreshPlot();
                }
            }
        };
        this.fitterCheckbox = new JCheckBoxMenuItem();
        this.fitterCheckbox.setSelected(false);
        this.fitterCheckbox.addActionListener(this.fitterAction);
        this.fourierCheckbox = new JCheckBoxMenuItem();
        this.fourierCheckbox.setSelected(false);
        this.fourierCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataToolTab.this.fourierPanel == null && DataToolTab.this.dataTool != null) {
                    DataToolTab.this.fourierPanel = new FourierPanel();
                    DataToolTab.this.fourierDialog = new JDialog(DataToolTab.this.dataTool, false){

                        @Override
                        public void setVisible(boolean vis) {
                            super.setVisible(vis);
                            (this).DataToolTab.this.fourierCheckbox.setSelected(vis);
                        }
                    };
                    DataToolTab.this.fourierDialog.setContentPane(DataToolTab.this.fourierPanel);
                    Dimension dim = new Dimension(640, 400);
                    DataToolTab.this.fourierDialog.setSize(dim);
                    DataToolTab.this.fourierPanel.splitPane.setDividerLocation(dim.width / 2);
                    DataToolTab.this.fourierPanel.refreshFourierData(DataToolTab.this.dataTable.getSelectedData(), DataToolTab.this.getName());
                    DataToolTab.this.fourierDialog.setLocationRelativeTo(DataToolTab.this.dataTool);
                }
                DataToolTab.this.fourierDialog.setVisible(DataToolTab.this.fourierCheckbox.isSelected());
            }
        });
        this.originShiftCheckbox = new JCheckBoxMenuItem();
        this.originShiftCheckbox.setSelected(this.originShiftEnabled);
        this.originShiftCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean previouslyEnabled = DataToolTab.this.originShiftEnabled;
                DataToolTab.this.originShiftEnabled = DataToolTab.this.originShiftCheckbox.isSelected();
                double shiftX = 0.0;
                int i = 1;
                while (i < DataToolTab.this.dataTable.getColumnCount()) {
                    String colName = DataToolTab.this.dataTable.getColumnName(i);
                    Dataset data = DataToolTab.this.dataTable.getDataset(colName);
                    if (data != null && data instanceof DataColumn) {
                        DataColumn dataCol = (DataColumn)data;
                        dataCol.setShifted(DataToolTab.this.originShiftEnabled);
                        if (i == 1) {
                            shiftX = dataCol.getShift();
                        }
                    }
                    ++i;
                }
                if (DataToolTab.this.originShiftEnabled) {
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.shiftXLabel, 2);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.shiftXSpinner, 3);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.shiftYLabel, 4);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.shiftYSpinner, 5);
                    if (!previouslyEnabled) {
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() + shiftX);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() + shiftX);
                        }
                    }
                    ((CrawlerSpinnerModel)DataToolTab.this.shiftXSpinner.getModel()).refreshDelta();
                    ((CrawlerSpinnerModel)DataToolTab.this.shiftYSpinner.getModel()).refreshDelta();
                } else {
                    DataToolTab.this.toolbar.remove(DataToolTab.this.shiftXLabel);
                    DataToolTab.this.toolbar.remove(DataToolTab.this.shiftXSpinner);
                    DataToolTab.this.toolbar.remove(DataToolTab.this.shiftYLabel);
                    DataToolTab.this.toolbar.remove(DataToolTab.this.shiftYSpinner);
                    DataToolTab.this.toolbar.remove(DataToolTab.this.selectedXLabel);
                    DataToolTab.this.toolbar.remove(DataToolTab.this.selectedXField);
                    DataToolTab.this.toolbar.remove(DataToolTab.this.selectedYLabel);
                    DataToolTab.this.toolbar.remove(DataToolTab.this.selectedYField);
                    if (previouslyEnabled) {
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() - shiftX);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() - shiftX);
                        }
                    }
                }
                DataToolTab.this.toolbar.validate();
                DataToolTab.this.refreshAll();
                DataToolTab.this.prevShiftX = -DataToolTab.this.shiftXField.getValue();
                DataToolTab.this.prevShiftY = -DataToolTab.this.shiftYField.getValue();
            }
        });
        this.measureFitCheckbox = new JCheckBoxMenuItem();
        this.measureFitCheckbox.setSelected(false);
        this.measureFitCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab.this.measureFit = DataToolTab.this.measureFitCheckbox.isSelected();
                if (DataToolTab.this.areaVisible) {
                    DataToolTab.this.plot.refreshArea();
                }
                DataToolTab.this.plot.refreshMeasurements();
                DataToolTab.this.plot.repaint();
            }
        });
        this.newColumnButton = DataTool.createButton("");
        this.newColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent e) {
                DataColumn column = DataToolTab.this.createDataColumn();
                String proposed = ToolsRes.getString("DataToolTab.NewColumn.Name");
                proposed = DataToolTab.this.getUniqueYColumnName(column, proposed, false);
                Object input = JOptionPane.showInputDialog(DataToolTab.this, ToolsRes.getString("DataToolTab.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTab.Dialog.NameColumn.Title"), 3, null, null, proposed);
                if (input == null) {
                    return;
                }
                String newName = DataToolTab.this.getUniqueYColumnName(column, input.toString(), true);
                if (newName == null) {
                    return;
                }
                if (newName.equals("")) {
                    String colName = ToolsRes.getString("DataToolTab.NewColumn.Name");
                    newName = DataToolTab.this.getUniqueYColumnName(column, colName, false);
                }
                OSPLog.finer("adding new column \"" + newName + "\"");
                column.setXYColumnNames("row", newName);
                ArrayList<DataColumn> loadedColumns = DataToolTab.this.loadData(column, false);
                if (!loadedColumns.isEmpty()) {
                    for (DataColumn next : loadedColumns) {
                        next.deletable = true;
                    }
                }
                int col = DataToolTab.this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = DataToolTab.this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit edit = dataToolTable.new DataToolTable.TableEdit(1, newName, new Integer(col), column);
                DataToolTab.this.undoSupport.postEdit(edit);
                DataToolTab.this.dataTable.refreshUndoItems();
                Runnable runner = new Runnable(){

                    @Override
                    public synchronized void run() {
                        int col = (this).DataToolTab.this.dataTable.getColumnCount() - 1;
                        (this).DataToolTab.this.dataTable.changeSelection(0, col, false, false);
                        (this).DataToolTab.this.dataTable.editCellAt(0, col, e);
                        (this).DataToolTab.this.dataTable.editor.field.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        });
        this.dataBuilderButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab.this.getDataBuilder().setSelectedPanel(DataToolTab.this.getName());
                DataToolTab.this.getDataBuilder().setVisible(true);
            }
        });
        this.refreshDataButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
        this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
        this.refreshDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab.this.refreshData();
            }
        });
        this.helpButton = DataTool.createButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.showHelp();
            }
        });
        this.valueCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Position"));
        this.valueCheckbox.setSelected(false);
        this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
        this.valueCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab.this.freezeMeasurement = false;
                DataToolTab.this.positionVisible = DataToolTab.this.valueCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
                DataToolTab.this.refreshStatusBar(null);
            }
        });
        this.slopeCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
        this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
        this.slopeCheckbox.setSelected(false);
        this.slopeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab.this.freezeMeasurement = false;
                DataToolTab.this.slopeVisible = DataToolTab.this.slopeCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
                DataToolTab.this.refreshStatusBar(null);
            }
        });
        this.areaCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Area"));
        this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
        this.areaCheckbox.setSelected(false);
        this.areaCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab.this.plot.setAreaVisible(DataToolTab.this.areaCheckbox.isSelected());
            }
        });
        this.measureButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Measure.Label"));
        this.measureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu();
                popup.add(DataToolTab.this.valueCheckbox);
                popup.add(DataToolTab.this.slopeCheckbox);
                popup.add(DataToolTab.this.areaCheckbox);
                popup.addSeparator();
                DataToolTab.this.measureFitCheckbox.setEnabled(DataToolTab.this.fitterCheckbox.isSelected());
                popup.add(DataToolTab.this.measureFitCheckbox);
                popup.add(DataToolTab.this.originShiftCheckbox);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                popup.show(DataToolTab.this.measureButton, 0, DataToolTab.this.measureButton.getHeight());
            }
        });
        this.analyzeButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Analyze.Label"));
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu();
                popup.add(DataToolTab.this.statsCheckbox);
                popup.add(DataToolTab.this.fitterCheckbox);
                popup.add(DataToolTab.this.fourierCheckbox);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                popup.show(DataToolTab.this.analyzeButton, 0, DataToolTab.this.analyzeButton.getHeight());
            }
        });
        this.propsAndStatsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int h;
                boolean statsVis = DataToolTab.this.statsCheckbox.isSelected();
                boolean propsVis = DataToolTab.this.propsCheckbox.isSelected();
                if (statsVis) {
                    DataToolTab.this.statsTable.refreshStatistics();
                }
                DataToolTab.this.refreshStatusBar(null);
                int statsHeight = DataToolTab.this.statsTable.getPreferredSize().height;
                int propsHeight = DataToolTab.this.propsTable.getPreferredSize().height;
                LookAndFeel currentLF = UIManager.getLookAndFeel();
                int n = h = currentLF.getClass().getName().indexOf("Nimbus") > -1 ? 8 : 4;
                if (statsVis && propsVis) {
                    Box box = Box.createVerticalBox();
                    box.add(DataToolTab.this.statsScroller);
                    box.add(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setTopComponent(box);
                    DataToolTab.this.splitPanes[2].setDividerLocation(statsHeight + propsHeight + 2 * h);
                } else if (statsVis) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.statsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(statsHeight + h);
                } else if (propsVis) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(propsHeight + h);
                } else {
                    DataToolTab.this.splitPanes[2].setDividerLocation(0);
                }
            }
        };
        this.statsCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckbox.addActionListener(this.propsAndStatsAction);
        this.propsCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"), true);
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.propsCheckbox.addActionListener(this.propsAndStatsAction);
        FitBuilder fitBuilder = this.dataTool.getFitBuilder();
        this.curveFitter = new DatasetCurveFitter(this.getWorkingData(), fitBuilder);
        this.curveFitter.setDataToolTab(this);
        fitBuilder.curveFitters.add(this.curveFitter);
        fitBuilder.removePropertyChangeListener(this.curveFitter.fitListener);
        fitBuilder.addPropertyChangeListener(this.curveFitter.fitListener);
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("changed")) {
                    DataToolTab.this.tabChanged(true);
                    return;
                }
                if (e.getPropertyName().equals("drawer") && DataToolTab.this.fitterCheckbox != null && DataToolTab.this.fitterCheckbox.isSelected()) {
                    DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                    DataToolTab.this.plot.addDrawable((FunctionDrawer)e.getNewValue());
                }
                DataToolTab.this.plot.repaint();
            }
        });
        this.plot = new DataToolPlotter(this.getWorkingData());
        this.plotAxes = new DataToolAxes(this.plot);
        this.plot.setAxes(this.plotAxes);
        if (this.getWorkingData() != null) {
            this.plot.addDrawable(this.getWorkingData());
            this.plot.setTitle(this.getWorkingData().getName());
        }
        MouseInputAdapter mouseSelector = new MouseInputAdapter(){
            TreeSet<Integer> rowsInside = new TreeSet();
            TreeSet<Integer> recent = new TreeSet();
            boolean boxActive;
            boolean selectionChanged;
            boolean readyToFindHits;
            boolean selectionBoxChanged;
            Interactive ia;
            Timer timerToFindHits;
            boolean removeHits;

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    this.boxActive = false;
                    DataToolTab.this.plot.setMouseCursor(SELECT_ZOOM_CURSOR);
                    return;
                }
                this.ia = DataToolTab.this.plot.getInteractive();
                if (this.ia == DataToolTab.this.plot.origin) {
                    DataToolTab.this.plot.selectionBox.visible = false;
                    DataToolTab.this.plot.origin.mouseDownPt = e.getPoint();
                    DataToolTab.this.plot.lockScale(true);
                    return;
                }
                if (this.ia instanceof HighlightableDataset) {
                    HighlightableDataset data = (HighlightableDataset)this.ia;
                    int index = data.getHitIndex();
                    ListSelectionModel model = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                    int col = DataToolTab.this.dataTable.getXColumn();
                    model.setSelectionInterval(col, col);
                    col = DataToolTab.this.dataTable.getYColumn();
                    model.addSelectionInterval(col, col);
                    TableModel tableModel = DataToolTab.this.dataTable.getModel();
                    int i = 1;
                    while (i < tableModel.getColumnCount()) {
                        if (data.getYColumnName().equals(DataToolTab.this.dataTable.getColumnName(i))) {
                            model.addSelectionInterval(i, i);
                            if (col != i) {
                                data.setHighlightColor(data.getFillColor());
                            }
                            data.setHighlighted(index, true);
                            break;
                        }
                        ++i;
                    }
                    if (!e.isControlDown()) {
                        DataToolTab.this.dataTable.setSelectedModelRows(new int[]{index});
                    } else {
                        int[] rows = DataToolTab.this.dataTable.getSelectedModelRows();
                        boolean needsAdding = true;
                        int[] nArray = rows;
                        int n = rows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int row = nArray[n2];
                            if (row == index) {
                                needsAdding = false;
                            }
                            ++n2;
                        }
                        int[] newRows = new int[needsAdding ? rows.length + 1 : rows.length - 1];
                        if (needsAdding) {
                            System.arraycopy(rows, 0, newRows, 0, rows.length);
                            newRows[rows.length] = index;
                        } else {
                            int j = 0;
                            int[] nArray2 = rows;
                            int n3 = rows.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                int row = nArray2[n4];
                                if (row != index) {
                                    newRows[j] = row;
                                    ++j;
                                }
                                ++n4;
                            }
                        }
                        DataToolTab.this.dataTable.setSelectedModelRows(newRows);
                    }
                    DataToolTab.this.dataTable.getSelectedData();
                    DataToolTab.this.plot.repaint();
                    this.boxActive = false;
                    this.selectionChanged = true;
                    return;
                }
                if (this.ia != null) {
                    this.boxActive = false;
                    return;
                }
                boolean bl = this.boxActive = !OSPRuntime.isPopupTrigger(e);
                if (this.boxActive) {
                    if (this.timerToFindHits == null) {
                        this.timerToFindHits = new Timer(200, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                this.findHits(removeHits);
                            }
                        });
                    }
                    if (!e.isControlDown() && !e.isShiftDown()) {
                        DataToolTab.this.dataTable.clearSelection();
                    }
                    this.rowsInside.clear();
                    int[] nArray = DataToolTab.this.dataTable.getSelectedModelRows();
                    int n = nArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        int row = nArray[n5];
                        this.rowsInside.add(row);
                        ++n5;
                    }
                    this.recent.clear();
                    Point p = e.getPoint();
                    DataToolTab.this.plot.selectionBox.xstart = p.x;
                    DataToolTab.this.plot.selectionBox.ystart = p.y;
                    this.readyToFindHits = true;
                    this.removeHits = e.isShiftDown() && e.isControlDown();
                    this.timerToFindHits.start();
                    DataToolTab.this.plot.setMouseCursor(this.removeHits ? SELECT_REMOVE_CURSOR : SELECT_CURSOR);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.selectionChanged = true;
                if (this.ia == DataToolTab.this.plot.origin) {
                    DataColumn col;
                    Dataset data;
                    DataToolTab.this.plot.selectionBox.visible = false;
                    double deltaX = 0.0;
                    double deltaY = 0.0;
                    int dx = DataToolTab.this.plot.origin.mouseDownPt.x - e.getPoint().x;
                    int dy = DataToolTab.this.plot.origin.mouseDownPt.y - e.getPoint().y;
                    if (e.isShiftDown()) {
                        if (Math.abs(dx) >= Math.abs(dy)) {
                            dy = 0;
                        } else {
                            dx = 0;
                        }
                    }
                    if ((data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.xVar)) != null && data instanceof DataColumn && DataToolTab.this.plot.origin.isVertHit) {
                        deltaX = (double)dx / DataToolTab.this.plot.getXPixPerUnit();
                        double shift = DataToolTab.this.prevShiftX + deltaX;
                        col = (DataColumn)data;
                        double prev = col.getShift();
                        col.setShift(shift);
                        DataToolTab.this.tabChanged(true);
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() + shift - prev);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() + shift - prev);
                        }
                    }
                    if ((data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.yVar)) != null && data instanceof DataColumn && DataToolTab.this.plot.origin.isHorzHit) {
                        deltaY = (double)(-dy) / DataToolTab.this.plot.getYPixPerUnit();
                        double shiftY = DataToolTab.this.prevShiftY + deltaY;
                        col = (DataColumn)data;
                        col.setShift(shiftY);
                        DataToolTab.this.tabChanged(true);
                    }
                    DataToolTab.this.refreshAll();
                    DataToolTab.this.plot.lockedXMin = DataToolTab.this.plot.mouseDownXMin + deltaX;
                    DataToolTab.this.plot.lockedXMax = DataToolTab.this.plot.mouseDownXMax + deltaX;
                    DataToolTab.this.plot.lockedYMin = DataToolTab.this.plot.mouseDownYMin + deltaY;
                    DataToolTab.this.plot.lockedYMax = DataToolTab.this.plot.mouseDownYMax + deltaY;
                    DataToolTab.this.plot.repaint();
                    return;
                }
                if (!this.boxActive) {
                    return;
                }
                DataToolTable.WorkingDataset data = DataToolTab.this.getWorkingData();
                if (data == null) {
                    return;
                }
                Point mouse = e.getPoint();
                DataToolTab.this.plot.selectionBox.visible = true;
                DataToolTab.this.plot.selectionBox.setSize(mouse.x - DataToolTab.this.plot.selectionBox.xstart, mouse.y - DataToolTab.this.plot.selectionBox.ystart);
                this.selectionBoxChanged = true;
                this.removeHits = e.isShiftDown() && e.isControlDown();
                DataToolTab.this.plot.setMouseCursor(this.removeHits ? SELECT_REMOVE_CURSOR : SELECT_CURSOR);
                DataToolTab.this.plot.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.selectionChanged && DataToolTab.this.freezeMeasurement) {
                    DataToolTab.this.freezeMeasurement = false;
                    DataToolTab.this.plot.measurementX = e.getX();
                    DataToolTab.this.plot.measurementIndex = -1;
                    DataToolTab.this.plot.refreshMeasurements();
                }
                this.selectionChanged = false;
                DataToolTab.this.plot.lockScale(false);
                DataToolTab.this.plot.selectionBox.visible = false;
                if (this.ia != null) {
                    if (this.ia == DataToolTab.this.plot.origin) {
                        DataToolTab.this.postShiftEdit();
                        ((CrawlerSpinnerModel)DataToolTab.this.shiftXSpinner.getModel()).refreshDelta();
                        ((CrawlerSpinnerModel)DataToolTab.this.shiftYSpinner.getModel()).refreshDelta();
                    }
                    if (this.ia instanceof Selectable) {
                        DataToolTab.this.plot.setMouseCursor(((Selectable)this.ia).getPreferredCursor());
                    } else {
                        DataToolTab.this.plot.setMouseCursor(Cursor.getPredefinedCursor(12));
                    }
                    if (this.ia instanceof HighlightableDataset) {
                        HighlightableDataset data = (HighlightableDataset)this.ia;
                        TableModel tableModel = DataToolTab.this.dataTable.getModel();
                        int yCol = DataToolTab.this.dataTable.getYColumn();
                        int i = 1;
                        while (i < tableModel.getColumnCount()) {
                            if (data.getYColumnName().equals(DataToolTab.this.dataTable.getColumnName(i)) && yCol != i) {
                                data.clearHighlights();
                                data.setHighlightColor(Color.YELLOW);
                                ListSelectionModel model = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                                model.removeSelectionInterval(i, i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                DataToolTab.this.plot.repaint();
                if (this.timerToFindHits != null) {
                    this.timerToFindHits.stop();
                }
                if (this.selectionBoxChanged) {
                    this.findHits(this.removeHits);
                    this.selectionBoxChanged = false;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!DataToolTab.this.freezeMeasurement) {
                    DataToolTab.this.plot.measurementX = e.getX();
                    DataToolTab.this.plot.measurementIndex = -1;
                }
                DataToolTab.this.plot.refreshMeasurements();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DataToolTab.this.dataTable.dataToolTab.refreshStatusBar(null);
            }

            private void findHits(final boolean subtract) {
                if (!this.readyToFindHits || !this.selectionBoxChanged) {
                    return;
                }
                this.selectionBoxChanged = false;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        DataToolTable.WorkingDataset data = (this).DataToolTab.this.dataTable.workingData;
                        HashMap<Integer, Integer> workingRows = (this).DataToolTab.this.dataTable.workingRows;
                        if (data == null || workingRows == null) {
                            return;
                        }
                        double[][] screenPoints = data.getScreenCoordinates();
                        ListSelectionModel columnSelectionModel = (this).DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                        int i = 0;
                        while (i < screenPoints[0].length) {
                            Integer row = (Integer)workingRows.get(i);
                            if (row == null) {
                                readyToFindHits = true;
                                return;
                            }
                            if (!Double.isNaN(screenPoints[1][i]) && (this).DataToolTab.this.plot.selectionBox.contains(screenPoints[0][i], screenPoints[1][i])) {
                                if (rowsInside.isEmpty()) {
                                    columnSelectionModel.setSelectionInterval(1, 2);
                                }
                                if (subtract) {
                                    rowsInside.remove(row);
                                } else {
                                    rowsInside.add(row);
                                }
                                recent.add(row);
                            } else if (recent.contains(row)) {
                                if (subtract) {
                                    rowsInside.add(row);
                                } else {
                                    rowsInside.remove(row);
                                }
                                recent.remove(row);
                            }
                            ++i;
                        }
                        if (rowsInside.isEmpty()) {
                            columnSelectionModel.removeSelectionInterval(0, (this).DataToolTab.this.dataTable.getColumnCount() - 1);
                            (this).DataToolTab.this.dataTable.getSelectionModel().clearSelection();
                            (this).DataToolTab.this.dataTable.getSelectedData();
                        } else {
                            int[] rows = new int[rowsInside.size()];
                            int i2 = 0;
                            Iterator<Integer> iterator = rowsInside.iterator();
                            while (iterator.hasNext()) {
                                int next;
                                rows[i2] = next = iterator.next().intValue();
                                ++i2;
                            }
                            (this).DataToolTab.this.dataTable.setSelectedModelRows(rows);
                        }
                        (this).DataToolTab.this.plot.repaint();
                        readyToFindHits = true;
                    }
                };
                runner.run();
            }
        };
        this.plot.addMouseListener(mouseSelector);
        this.plot.addMouseMotionListener(mouseSelector);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.toolbar.add(this.measureButton);
        this.toolbar.add(this.analyzeButton);
        this.toolbar.add(Box.createGlue());
        this.toolbar.add(this.newColumnButton);
        this.toolbar.add(this.dataBuilderButton);
        this.toolbar.add(this.refreshDataButton);
        this.toolbar.add(this.helpButton);
        this.statsTable = new DataToolStatsTable(this.dataTable);
        this.statsScroller = new JScrollPane(this.statsTable){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = DataToolTab.this.statsTable.getPreferredSize();
                return dim;
            }
        };
        this.statsScroller.setVerticalScrollBarPolicy(21);
        this.statsScroller.setHorizontalScrollBarPolicy(31);
        this.propsTable = new DataToolPropsTable(this.dataTable);
        this.propsTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("display")) {
                    DataToolTab.this.refreshPlot();
                }
            }
        });
        this.propsScroller = new JScrollPane(this.propsTable){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = DataToolTab.this.propsTable.getPreferredSize();
                return dim;
            }
        };
        this.propsScroller.setVerticalScrollBarPolicy(21);
        this.propsScroller.setHorizontalScrollBarPolicy(31);
        this.statusLabel = new JLabel(" ", 10);
        this.statusLabel.setFont(new JTextField().getFont());
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.editableLabel = new JLabel(" ", 11);
        this.editableLabel.setFont(this.statusLabel.getFont());
        this.editableLabel.setBorder(BorderFactory.createEmptyBorder(1, 12, 1, 2));
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.add((Component)this.statusLabel, "West");
        south.add((Component)this.editableLabel, "East");
        this.add((Component)south, "South");
        this.tableScroller = new JScrollPane(this.splitPanes[2]);
        this.tableScroller.setVerticalScrollBarPolicy(21);
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.tableScroller);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setBottomComponent(this.dataScroller);
        this.curveFitter.splitPane.setDividerLocation(0);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.shiftXLabel = new JLabel();
        this.shiftXLabel.setBorder(BorderFactory.createEmptyBorder(2, 12, 2, 2));
        this.shiftYLabel = new JLabel();
        this.shiftYLabel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 2));
        this.selectedXLabel = new JLabel();
        this.selectedXLabel.setBorder(BorderFactory.createEmptyBorder(2, 12, 2, 2));
        this.selectedYLabel = new JLabel();
        this.selectedYLabel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 2));
        this.shiftEditListener = new ShiftEditListener();
        KeyAdapter numberFieldKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JComponent comp = (JComponent)e.getSource();
                if (e.getKeyCode() == 10) {
                    comp.setBackground(Color.white);
                } else {
                    comp.setBackground(Color.yellow);
                }
            }
        };
        FocusAdapter numberFieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DatasetCurveFitter.NumberField field = (DatasetCurveFitter.NumberField)e.getSource();
                if (field.getBackground() != Color.white) {
                    field.setBackground(Color.white);
                    field.postActionEvent();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                DatasetCurveFitter.NumberField field = (DatasetCurveFitter.NumberField)e.getSource();
                field.selectAll();
            }
        };
        this.shiftXField = new DatasetCurveFitter.NumberField(4){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = this.getPreferredSize();
                dim.height = super.getMaximumSize().height;
                return dim;
            }
        };
        this.shiftXField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dataset data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.xVar);
                if (data != null && data instanceof DataColumn) {
                    DataColumn col = (DataColumn)data;
                    double prevX = col.getShift();
                    double shiftX = -DataToolTab.this.shiftXField.getValue();
                    if (col.setShift(shiftX)) {
                        DataToolTab.this.tabChanged(true);
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() + shiftX - prevX);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() + shiftX - prevX);
                        }
                        DataToolTab.this.refreshAll();
                        ((CrawlerSpinnerModel)DataToolTab.this.shiftXSpinner.getModel()).refreshDelta();
                    }
                }
                DataToolTab.this.shiftXField.selectAll();
            }
        });
        this.shiftXField.addKeyListener(numberFieldKeyListener);
        this.shiftXField.addFocusListener(numberFieldFocusListener);
        CrawlerSpinnerModel spinModel = new CrawlerSpinnerModel();
        this.shiftXSpinner = new JSpinner(spinModel){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.width = this.getPreferredSize().width;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Component[] componentArray = this.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JButton) {
                        dim.width = DataToolTab.this.shiftXField.getPreferredSize().width + c.getWidth() - 2;
                        return dim;
                    }
                    ++n2;
                }
                return dim;
            }
        };
        this.shiftXSpinner.setEditor(this.shiftXField);
        ChangeListener xChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Dataset data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.xVar);
                if (data != null && data instanceof DataColumn) {
                    DataColumn col = (DataColumn)data;
                    double prevX = col.getShift();
                    double shiftX = -((Double)DataToolTab.this.shiftXSpinner.getValue()).doubleValue();
                    if (col.setShift(shiftX)) {
                        DataToolTab.this.tabChanged(true);
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() + shiftX - prevX);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() + shiftX - prevX);
                        }
                        DataToolTab.this.refreshAll();
                    }
                }
            }
        };
        this.shiftXSpinner.addChangeListener(xChangeListener);
        this.shiftXSpinner.addChangeListener(this.shiftEditListener);
        this.shiftYField = new DatasetCurveFitter.NumberField(4){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = this.getPreferredSize();
                dim.height = super.getMaximumSize().height;
                return dim;
            }
        };
        this.shiftYField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataColumn col;
                Dataset data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.yVar);
                if (data != null && data instanceof DataColumn && (col = (DataColumn)data).setShift(-DataToolTab.this.shiftYField.getValue())) {
                    DataToolTab.this.tabChanged(true);
                    DataToolTab.this.refreshAll();
                    ((CrawlerSpinnerModel)DataToolTab.this.shiftYSpinner.getModel()).refreshDelta();
                }
                DataToolTab.this.shiftYField.selectAll();
            }
        });
        this.shiftYField.addKeyListener(numberFieldKeyListener);
        this.shiftYField.addFocusListener(numberFieldFocusListener);
        spinModel = new CrawlerSpinnerModel();
        this.shiftYSpinner = new JSpinner(spinModel){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.width = this.getPreferredSize().width;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Component[] componentArray = this.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JButton) {
                        dim.width = DataToolTab.this.shiftYField.getPreferredSize().width + c.getWidth() - 2;
                        return dim;
                    }
                    ++n2;
                }
                return dim;
            }
        };
        this.shiftYSpinner.setEditor(this.shiftYField);
        ChangeListener yChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double shiftY;
                DataColumn col;
                Dataset data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.yVar);
                if (data != null && data instanceof DataColumn && (col = (DataColumn)data).setShift(shiftY = -((Double)DataToolTab.this.shiftYSpinner.getValue()).doubleValue())) {
                    DataToolTab.this.tabChanged(true);
                    DataToolTab.this.refreshAll();
                }
            }
        };
        this.shiftYSpinner.addChangeListener(yChangeListener);
        this.shiftYSpinner.addChangeListener(this.shiftEditListener);
        this.selectedXField = new DatasetCurveFitter.NumberField(4){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = this.getPreferredSize();
                dim.height = super.getMaximumSize().height;
                return dim;
            }
        };
        this.selectedXField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dataset data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.xVar);
                if (data != null && data instanceof DataColumn) {
                    DataColumn col = (DataColumn)data;
                    double prev = col.getShift();
                    double val = DataToolTab.this.selectedXField.getValue();
                    if (col.setShiftedValue(DataToolTab.this.selectedDataIndex, val)) {
                        DataToolTab.this.tabChanged(true);
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            double shift = col.getShift();
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() + shift - prev);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() + shift - prev);
                        }
                        DataToolTab.this.refreshAll();
                        ((CrawlerSpinnerModel)DataToolTab.this.shiftXSpinner.getModel()).refreshDelta();
                    }
                }
                DataToolTab.this.selectedXField.requestFocusInWindow();
                DataToolTab.this.selectedXField.selectAll();
                DataToolTab.this.shiftEditListener.stateChanged(null);
            }
        });
        this.selectedXField.addKeyListener(numberFieldKeyListener);
        this.selectedXField.addFocusListener(numberFieldFocusListener);
        this.selectedYField = new DatasetCurveFitter.NumberField(4){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = this.getPreferredSize();
                dim.height = super.getMaximumSize().height;
                return dim;
            }
        };
        this.selectedYField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double val;
                DataColumn col;
                Dataset data = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.yVar);
                if (data != null && data instanceof DataColumn && (col = (DataColumn)data).setShiftedValue(DataToolTab.this.selectedDataIndex, val = DataToolTab.this.selectedYField.getValue())) {
                    DataToolTab.this.tabChanged(true);
                    DataToolTab.this.refreshAll();
                    ((CrawlerSpinnerModel)DataToolTab.this.shiftYSpinner.getModel()).refreshDelta();
                }
                DataToolTab.this.selectedYField.requestFocusInWindow();
                DataToolTab.this.selectedYField.selectAll();
                DataToolTab.this.shiftEditListener.stateChanged(null);
            }
        });
        this.selectedYField.addKeyListener(numberFieldKeyListener);
        this.selectedYField.addFocusListener(numberFieldFocusListener);
    }

    protected void refreshGUI() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                boolean changed = DataToolTab.this.tabChanged;
                DataToolTab.this.newColumnButton.setText(ToolsRes.getString("DataToolTab.Button.NewColumn.Text"));
                DataToolTab.this.newColumnButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.NewColumn.Tooltip"));
                DataToolTab.this.dataBuilderButton.setText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
                DataToolTab.this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
                DataToolTab.this.dataBuilderButton.setEnabled(DataToolTab.this.originatorID != 0);
                DataToolTab.this.refreshDataButton.setText(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
                DataToolTab.this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
                DataToolTab.this.measureButton.setText(ToolsRes.getString("DataToolTab.Button.Measure.Label"));
                DataToolTab.this.measureButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Measure.Tooltip"));
                DataToolTab.this.analyzeButton.setText(ToolsRes.getString("DataToolTab.Button.Analyze.Label"));
                DataToolTab.this.analyzeButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Analyze.Tooltip"));
                DataToolTab.this.statsCheckbox.setText(ToolsRes.getString("Checkbox.Statistics.Label"));
                DataToolTab.this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
                DataToolTab.this.fitterCheckbox.setText(ToolsRes.getString("Checkbox.Fits.Label"));
                DataToolTab.this.fitterCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
                DataToolTab.this.fourierCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Fourier.Label"));
                DataToolTab.this.fourierCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Fourier.ToolTip"));
                DataToolTab.this.originShiftCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.DataShift.Label"));
                DataToolTab.this.originShiftCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.DataShift.ToolTip"));
                DataToolTab.this.originShiftCheckbox.setEnabled(!DataToolTab.this.plot.getDrawables(DataToolTable.WorkingDataset.class).isEmpty());
                DataToolTab.this.measureFitCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.MeasureFit.Label"));
                DataToolTab.this.measureFitCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.MeasureFit.ToolTip"));
                DataToolTab.this.propsCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"));
                DataToolTab.this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
                DataToolTab.this.valueCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Position"));
                DataToolTab.this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
                DataToolTab.this.slopeCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
                DataToolTab.this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
                DataToolTab.this.areaCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Area"));
                DataToolTab.this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
                DataToolTab.this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
                DataToolTab.this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
                String label = String.valueOf(ToolsRes.getString("DataToolTab.Origin.Label")) + ":  ";
                DataToolTab.this.shiftXLabel.setText(String.valueOf(label) + DataToolTab.this.plot.xVar);
                DataToolTab.this.shiftYLabel.setText(DataToolTab.this.plot.yVar);
                DataToolTab.this.shiftXLabel.setToolTipText(ToolsRes.getString("DataToolTab.Origin.Tooltip"));
                label = String.valueOf(ToolsRes.getString("DataToolTab.Selection.Label")) + ":  ";
                DataToolTab.this.selectedXLabel.setText(String.valueOf(label) + DataToolTab.this.plot.xVar);
                DataToolTab.this.selectedXLabel.setToolTipText(ToolsRes.getString("DataToolTab.Selection.Tooltip"));
                DataToolTab.this.selectedYLabel.setText(DataToolTab.this.plot.yVar);
                DataToolTab.this.toolbar.remove(DataToolTab.this.newColumnButton);
                if (DataToolTab.this.userEditable) {
                    int n = DataToolTab.this.toolbar.getComponentIndex(DataToolTab.this.helpButton);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.newColumnButton, n);
                    DataToolTab.this.toolbar.validate();
                }
                DataToolTab.this.toolbar.remove(DataToolTab.this.refreshDataButton);
                Collection<Tool> tools2 = DataToolTab.this.jobManager.getTools(DataToolTab.this.dataManager);
                for (Tool tool : tools2) {
                    if (!(tool instanceof DataRefreshTool)) continue;
                    int n = DataToolTab.this.toolbar.getComponentIndex(DataToolTab.this.helpButton);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.refreshDataButton, n);
                    DataToolTab.this.toolbar.validate();
                    break;
                }
                DataToolTab.this.curveFitter.refreshGUI();
                DataToolTab.this.statsTable.refreshGUI();
                DataToolTab.this.propsTable.refreshGUI();
                DataToolTab.this.refreshPlot();
                DataToolTab.this.refreshStatusBar(null);
                DataToolTab.this.tabChanged = changed;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.splitPanes[1].setDividerLocation(1.0);
        this.propsAndStatsAction.actionPerformed(null);
        int i = 0;
        while (i < this.dataTable.getColumnCount()) {
            String colName = this.dataTable.getColumnName(i);
            this.dataTable.getWorkingData(colName);
            ++i;
        }
        this.refreshPlot();
        this.refreshGUI();
        this.isInitialized = true;
    }

    protected void buildVarPopup() {
        if (this.setVarAction == null) {
            this.setVarAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem item = (JMenuItem)e.getSource();
                    String var = item.getActionCommand();
                    String otherVar = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.plot.yVar : DataToolTab.this.plot.xVar;
                    int labelCol = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    int col = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getXColumn() : DataToolTab.this.dataTable.getYColumn();
                    TableModel model = DataToolTab.this.dataTable.getModel();
                    int i = 0;
                    while (i < model.getColumnCount()) {
                        if (var.equals(DataToolTab.this.dataTable.getColumnName(i))) {
                            if (i == col) {
                                return;
                            }
                            DataToolTab.this.dataTable.getColumnModel().moveColumn(i, col);
                            break;
                        }
                        ++i;
                    }
                    if (!var.equals(otherVar)) {
                        col = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getYColumn() : DataToolTab.this.dataTable.getXColumn();
                        i = 0;
                        while (i < model.getColumnCount()) {
                            if (otherVar.equals(DataToolTab.this.dataTable.getColumnName(i))) {
                                DataToolTab.this.dataTable.getColumnModel().moveColumn(i, col);
                                break;
                            }
                            ++i;
                        }
                    }
                    col = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    DataToolTab.this.dataTable.getColumnModel().moveColumn(col, labelCol);
                }
            };
        }
        this.varPopup = new JPopupMenu();
        Font font = new JTextField().getFont();
        for (Dataset next : this.dataManager.getDatasets()) {
            String s = TeXParser.removeSubscripting(next.getYColumnName());
            JMenuItem item = new JMenuItem(s);
            item.setActionCommand(next.getYColumnName());
            item.addActionListener(this.setVarAction);
            item.setFont(font);
            this.varPopup.add(item);
        }
    }

    private DataColumn getIDMatch(Dataset local, ArrayList<DataColumn> columnsToSearch) {
        if (columnsToSearch == null || local == null) {
            return null;
        }
        for (DataColumn next : columnsToSearch) {
            if (local.getID() != next.getID() || local.getColumnID() != next.getColumnID()) continue;
            return next;
        }
        return null;
    }

    private DataColumn getNameMatch(Dataset local, ArrayList<DataColumn> columnsToSearch) {
        if (columnsToSearch == null || local == null) {
            return null;
        }
        for (DataColumn next : columnsToSearch) {
            if (!local.getYColumnName().equals(next.getYColumnName())) continue;
            return next;
        }
        return null;
    }

    protected boolean isDuplicateColumn(String name, double[] data) {
        for (Dataset next : this.dataManager.getDatasets()) {
            double[] y = next.getYPoints();
            if (!name.equals(next.getYColumnName()) || !this.isDuplicate(data, next.getYPoints())) continue;
            if (data.length > y.length) {
                next.clear();
                next.append(data, data);
            }
            return true;
        }
        return false;
    }

    private boolean isDuplicate(double[] data0, double[] data1) {
        int len = Math.min(data0.length, data1.length);
        int i = 0;
        while (i < len) {
            if (!(Double.isNaN(data0[i]) && Double.isNaN(data1[i]) || data0[i] == data1[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Map<DataColumn, Dataset> getColumnMatchesByID(Data data) {
        HashMap<DataColumn, Dataset> matches = new HashMap<DataColumn, Dataset>();
        ArrayList<Dataset> datasets = DataTool.getDatasets(data);
        for (Dataset next : this.dataManager.getDatasets()) {
            DataColumn column;
            Dataset match;
            if (!(next instanceof DataColumn) || (match = this.getMatchByID(column = (DataColumn)next, datasets)) == null) continue;
            matches.put(column, match);
        }
        return matches;
    }

    protected Map<DataColumn, Dataset> getColumnMatchesByName(Set<String> columnNames, Data data) {
        HashMap<DataColumn, Dataset> matches = new HashMap<DataColumn, Dataset>();
        ArrayList<Dataset> datasets = DataTool.getDatasets(data);
        for (Dataset next : this.dataManager.getDatasets()) {
            Dataset match;
            if (!(next instanceof DataColumn)) continue;
            DataColumn column = (DataColumn)next;
            if (columnNames != null && !columnNames.contains(column.getYColumnName()) || (match = this.getMatchByName(column, datasets)) == null) continue;
            matches.put(column, match);
        }
        return matches;
    }

    protected Dataset getMatchByName(DataColumn column, ArrayList<Dataset> datasets) {
        String[] dataNames = this.ownedColumns.get(column.getYColumnName());
        if (dataNames == null) {
            return null;
        }
        String dataName = dataNames[1];
        int i = 0;
        while (i < datasets.size()) {
            Dataset next = datasets.get(i);
            if (next != null) {
                if (i == 0 && dataName.equals(next.getXColumnName())) {
                    return next;
                }
                if (dataName.equals(next.getYColumnName())) {
                    return next;
                }
            }
            ++i;
        }
        return null;
    }

    protected Dataset getMatchByID(DataColumn column, ArrayList<Dataset> datasets) {
        for (Dataset next : datasets) {
            if (next == null || column.getID() != next.getID()) continue;
            return next;
        }
        return null;
    }

    protected void setSelectedData(Dataset selectedData) {
        this.curveFitter.setData(selectedData);
        if (this.fourierPanel != null) {
            this.fourierPanel.refreshFourierData(selectedData, this.getName());
        }
        if (this.originShiftEnabled && selectedData != null) {
            if (selectedData.getIndex() == 1) {
                this.selectedDataIndex = this.dataTable.getSelectedRow();
                this.toolbar.add((Component)this.selectedXLabel, 6);
                this.toolbar.add((Component)this.selectedXField, 7);
                this.toolbar.add((Component)this.selectedYLabel, 8);
                this.toolbar.add((Component)this.selectedYField, 9);
                this.selectedXField.setValue(selectedData.getXPoints()[0]);
                this.selectedXField.refreshPreferredWidth();
                this.selectedYField.setValue(selectedData.getYPoints()[0]);
                this.selectedYField.refreshPreferredWidth();
                this.toolbar.revalidate();
            } else {
                this.toolbar.remove(this.selectedXLabel);
                this.toolbar.remove(this.selectedXField);
                this.toolbar.remove(this.selectedYLabel);
                this.toolbar.remove(this.selectedYField);
                this.toolbar.revalidate();
                this.selectedDataIndex = -1;
            }
        }
        if (this.positionVisible || this.slopeVisible) {
            this.plot.refreshMeasurements();
        }
        if (this.areaVisible) {
            this.plot.refreshArea();
        }
    }

    protected void refreshPlot() {
        this.setSelectedData(this.dataTable.getSelectedData());
        this.plot.removeDrawables(Dataset.class);
        DataToolTable.WorkingDataset workingData = this.getWorkingData();
        this.valueCheckbox.setEnabled(workingData != null && workingData.getIndex() > 0);
        if (!this.valueCheckbox.isEnabled()) {
            this.valueCheckbox.setSelected(false);
            this.positionVisible = false;
        }
        this.slopeCheckbox.setEnabled(workingData != null && workingData.getIndex() > 2);
        if (!this.slopeCheckbox.isEnabled()) {
            this.slopeCheckbox.setSelected(false);
            this.slopeVisible = false;
        }
        this.areaCheckbox.setEnabled(workingData != null && workingData.getIndex() > 1);
        if (!this.areaCheckbox.isEnabled()) {
            this.areaCheckbox.setSelected(false);
            this.areaVisible = false;
        }
        this.plot.dataPresent = false;
        if (workingData != null) {
            this.plot.dataPresent = workingData.getIndex() > 0;
            int labelCol = this.dataTable.convertColumnIndexToView(0);
            String xName = this.dataTable.getColumnName(labelCol == 0 ? 1 : 0);
            HashMap<String, DataToolTable.WorkingDataset> datasets = this.dataTable.workingMap;
            for (DataToolTable.WorkingDataset next : datasets.values()) {
                next.setXSource(workingData.getXSource());
                String colName = next.getYColumnName();
                if (next == workingData || colName.equals(xName) || this.originShiftEnabled && (String.valueOf(colName) + SHIFTED).equals(xName) || !next.isMarkersVisible() && !next.isConnected()) continue;
                next.clearHighlights();
                if (!next.isMarkersVisible()) {
                    next.setMarkerShape(0);
                }
                this.plot.addDrawable(next);
                boolean bl = this.plot.dataPresent = this.plot.dataPresent || next.getIndex() > 0;
            }
            this.plot.addDrawable(workingData);
            workingData.restoreHighlights();
            if (this.fitterCheckbox != null && this.fitterCheckbox.isSelected()) {
                this.plot.removeDrawable(this.curveFitter.getDrawer());
                this.plot.addDrawable(this.curveFitter.getDrawer());
            }
            String xLabel = workingData.getColumnName(0);
            String yLabel = workingData.getColumnName(1);
            this.plot.setAxisLabels(xLabel, yLabel);
            if (this.curveFitter.fit != null) {
                String depVar = TeXParser.removeSubscripting(workingData.getColumnName(1));
                String indepVar = TeXParser.removeSubscripting(workingData.getColumnName(0));
                if (this.originShiftEnabled) {
                    depVar = String.valueOf(depVar) + SHIFTED;
                    indepVar = String.valueOf(indepVar) + SHIFTED;
                }
                if (this.curveFitter.fit instanceof UserFunction) {
                    this.curveFitter.eqnField.setText(String.valueOf(depVar) + " = " + ((UserFunction)this.curveFitter.fit).getFullExpression(new String[]{indepVar}));
                } else {
                    this.curveFitter.eqnField.setText(String.valueOf(depVar) + " = " + this.curveFitter.fit.getExpression(indepVar));
                }
            }
        } else {
            this.plot.setXLabel("");
            this.plot.setYLabel("");
        }
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
        }
        if (this.positionVisible || this.slopeVisible) {
            this.plot.refreshMeasurements();
        }
        if (this.areaVisible) {
            this.plot.refreshArea();
        }
        this.repaint();
    }

    protected void refreshStatusBar(String hint) {
        if (hint != null) {
            this.statusLabel.setText(hint);
        } else if (this.slopeCheckbox.isSelected()) {
            String s = ToolsRes.getString("DataToolTab.Status.Slope");
            if (this.fitterCheckbox.isSelected()) {
                s = String.valueOf(s) + " " + ToolsRes.getString("DataToolTab.Status.MeasureFit");
            }
            this.statusLabel.setText(s);
        } else if (this.areaCheckbox.isSelected()) {
            String s = ToolsRes.getString("DataToolTab.Status.Area");
            if (this.fitterCheckbox.isSelected()) {
                s = String.valueOf(s) + " " + ToolsRes.getString("DataToolTab.Status.MeasureFit");
            }
            this.statusLabel.setText(s);
        } else if (this.valueCheckbox.isSelected()) {
            String s = ToolsRes.getString("DataToolTab.Status.Value");
            if (this.fitterCheckbox.isSelected()) {
                s = String.valueOf(s) + " " + ToolsRes.getString("DataToolTab.Status.MeasureFit");
            }
            this.statusLabel.setText(s);
        } else if (this.originShiftCheckbox.isSelected()) {
            this.statusLabel.setText(ToolsRes.getString("DataToolTab.Status.ShiftOrigin"));
        } else if (this.statsCheckbox.isSelected()) {
            this.statusLabel.setText(this.getCorrelationString());
        } else if (this.dataManager.getDatasets().size() < 2) {
            this.statusLabel.setText(this.userEditable ? ToolsRes.getString("DataToolTab.StatusBar.Text.CreateColumns") : ToolsRes.getString("DataToolTab.StatusBar.Text.PasteColumns"));
        } else {
            this.statusLabel.setText(ToolsRes.getString("DataToolTab.StatusBar.Text.DragColumns"));
        }
        this.editableLabel.setText(this.isUserEditable() ? ToolsRes.getString("DataTool.MenuItem.Editable").toLowerCase() : ToolsRes.getString("DataTool.MenuItem.Noneditable").toLowerCase());
        this.editableLabel.setForeground(this.isUserEditable() ? Color.GREEN.darker() : Color.RED.darker());
    }

    protected String getCorrelationString() {
        String s = ToolsRes.getString("DataToolTab.Status.Correlation");
        s = Double.isNaN(this.curveFitter.correlation) ? String.valueOf(s) + " " + ToolsRes.getString("DataToolTab.Status.Correlation.Undefined") : String.valueOf(s) + " = " + correlationFormat.format(this.curveFitter.correlation);
        return s;
    }

    public void refreshShiftFields() {
        double shift;
        String existing;
        String pattern;
        Dataset data = this.dataTable.getDataset(this.plot.xVar);
        if (data != null && data instanceof DataColumn) {
            pattern = this.dataTable.getFormatPattern(this.plot.xVar);
            if (pattern == null || "".equals(pattern)) {
                pattern = "#0.0#";
            }
            if (!pattern.equals(existing = this.shiftXField.getPattern())) {
                this.shiftXField.applyPattern(pattern);
                this.selectedXField.applyPattern(pattern);
            }
            this.shiftXField.setValue((shift = ((DataColumn)data).getShift()) == 0.0 ? 0.0 : -shift);
            this.shiftXSpinner.setValue(shift == 0.0 ? 0.0 : -shift);
            if (this.selectedDataIndex > -1) {
                this.selectedXField.setValue(data.getYPoints()[this.selectedDataIndex]);
            }
            if (shift != this.prevShiftX || !pattern.equals(existing)) {
                this.shiftXField.refreshPreferredWidth();
                this.selectedXField.refreshPreferredWidth();
                this.toolbar.revalidate();
            }
        }
        if ((data = this.dataTable.getDataset(this.plot.yVar)) != null && data instanceof DataColumn) {
            pattern = this.dataTable.getFormatPattern(this.plot.yVar);
            if (pattern == null || "".equals(pattern)) {
                pattern = "#0.0#";
            }
            if (!pattern.equals(existing = this.shiftYField.getPattern())) {
                this.shiftYField.applyPattern(pattern);
                this.selectedYField.applyPattern(pattern);
            }
            this.shiftYField.setValue((shift = ((DataColumn)data).getShift()) == 0.0 ? 0.0 : -shift);
            this.shiftYSpinner.setValue(shift == 0.0 ? 0.0 : -shift);
            if (this.selectedDataIndex > -1) {
                this.selectedYField.setValue(data.getYPoints()[this.selectedDataIndex]);
            }
            if (shift != this.prevShiftY || !pattern.equals(existing)) {
                this.shiftYField.refreshPreferredWidth();
                this.selectedYField.refreshPreferredWidth();
                this.toolbar.revalidate();
            }
        }
    }

    public void refreshAll() {
        this.refreshShiftFields();
        this.refreshPlot();
        this.curveFitter.fit(this.curveFitter.fit);
        this.plot.refreshArea();
        this.plot.refreshMeasurements();
        this.dataTable.refreshTable();
    }

    protected void refreshUndoItems() {
        if (this.dataTool != null) {
            this.dataTool.undoItem.setEnabled(this.undoManager.canUndo());
            this.dataTool.redoItem.setEnabled(this.undoManager.canRedo());
        }
    }

    protected void postShiftEdit() {
        double shiftX = -this.shiftXField.getValue();
        double shiftY = -this.shiftYField.getValue();
        if (this.prevShiftX == shiftX && this.prevShiftY == shiftY) {
            return;
        }
        double[] newShift = new double[]{shiftX, shiftY};
        double[] prevShift = new double[]{this.prevShiftX, this.prevShiftY};
        String[] colNames = new String[]{this.plot.xVar, this.plot.yVar};
        ShiftEdit edit = new ShiftEdit(colNames, newShift, prevShift);
        this.undoSupport.postEdit(edit);
        this.refreshUndoItems();
        this.prevShiftX = shiftX;
        this.prevShiftY = shiftY;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class CrawlerSpinnerModel
    extends AbstractSpinnerModel {
        double val = 0.0;
        double delta = 1.0;
        double percentDelta = 1.0;

        CrawlerSpinnerModel() {
        }

        @Override
        public Object getValue() {
            return new Double(this.val);
        }

        @Override
        public Object getNextValue() {
            return new Double(this.val + this.delta);
        }

        @Override
        public Object getPreviousValue() {
            return new Double(this.val - this.delta);
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                this.val = (Double)value;
                this.fireStateChanged();
            }
        }

        public void refreshDelta() {
            Dataset dataset;
            if (this.val != 0.0) {
                this.delta = Math.abs(this.val * this.percentDelta / 100.0);
            } else if (DataToolTab.this.shiftXSpinner.getModel() == this) {
                Dataset dataset2 = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.xVar);
                if (dataset2 != null) {
                    double range = dataset2.getYMax() - dataset2.getYMin();
                    this.delta = range * this.percentDelta / 100.0;
                }
            } else if (DataToolTab.this.shiftYSpinner.getModel() == this && (dataset = DataToolTab.this.dataTable.getDataset(DataToolTab.this.plot.yVar)) != null) {
                double range = dataset.getYMax() - dataset.getYMin();
                this.delta = range * this.percentDelta / 100.0;
            }
        }
    }

    protected class DataToolAxes
    extends CartesianInteractive {
        protected DataToolAxes(PlottingPanel panel) {
            super(panel);
        }

        @Override
        protected boolean hasHorzVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        @Override
        protected JPopupMenu getHorzVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = true;
            FontSizer.setFonts(DataToolTab.this.varPopup, FontSizer.getLevel());
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                JMenuItem item = (JMenuItem)c;
                if (this.xLine.getText().equals(item.getActionCommand())) {
                    item.setFont(item.getFont().deriveFont(1));
                } else {
                    item.setFont(item.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }

        @Override
        protected boolean hasVertVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        @Override
        protected JPopupMenu getVertVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = false;
            FontSizer.setFonts(DataToolTab.this.varPopup, FontSizer.getLevel());
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                JMenuItem item = (JMenuItem)c;
                if (this.yLine.getText().equals(item.getActionCommand())) {
                    item.setFont(item.getFont().deriveFont(1));
                } else {
                    item.setFont(item.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }
    }

    protected class DataToolPlotter
    extends PlottingPanel {
        SelectionBox selectionBox;
        Crossbars valueCrossbars;
        SlopeLine slopeLine;
        XYAxes origin;
        LimitLine[] areaLimits;
        Dataset areaDataset;
        double value;
        double slope;
        double area;
        DecimalFormat sciFormat;
        DecimalFormat fixedFormat;
        String xVar;
        String yVar;
        String message;
        boolean scaleLocked;
        boolean dataPresent;
        double lockedXMin;
        double lockedXMax;
        double lockedYMin;
        double lockedYMax;
        double mouseDownXMin;
        double mouseDownXMax;
        double mouseDownYMin;
        double mouseDownYMax;
        int measurementIndex;
        int measurementX;

        protected DataToolPlotter(Dataset dataset) {
            super(dataset == null ? "x" : dataset.getColumnName(0), dataset == null ? "y" : dataset.getColumnName(1), "");
            this.areaLimits = new LimitLine[2];
            this.value = Double.NaN;
            this.slope = Double.NaN;
            this.sciFormat = new DecimalFormat("0.00E0");
            this.fixedFormat = new DecimalFormat("0.00");
            this.measurementIndex = -1;
            this.measurementX = -1;
            this.setAntialiasShapeOn(true);
            this.selectionBox = new SelectionBox();
            this.valueCrossbars = new Crossbars();
            this.slopeLine = new SlopeLine();
            this.origin = new XYAxes();
            this.areaLimits[0] = new LimitLine();
            this.areaLimits[1] = new LimitLine();
            this.addDrawable(this.areaLimits[0]);
            this.addDrawable(this.areaLimits[1]);
            this.addDrawable(this.selectionBox);
            this.addDrawable(this.origin);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getCursor() == SELECT_CURSOR && e.isControlDown() && e.isShiftDown()) {
                        ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setMouseCursor(SELECT_REMOVE_CURSOR);
                    }
                    if (e.getKeyCode() == 17) {
                        if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.toggleMeasurement) {
                            return;
                        }
                        ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.toggleMeasurement = true;
                        DataToolPlotter.this.refreshMeasurements();
                        DataToolPlotter.this.refreshArea();
                        return;
                    }
                    if (e.getKeyCode() == 32) {
                        ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.freezeMeasurement = !((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.freezeMeasurement && e.isShiftDown();
                        if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.freezeMeasurement && DataToolPlotter.this.mouseEvent != null) {
                            ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.measurementX = DataToolPlotter.this.mouseEvent.getX();
                            ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.measurementIndex = -1;
                            ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.refreshMeasurements();
                        }
                        return;
                    }
                    if (e.getKeyCode() == 83 && e.isShiftDown()) {
                        ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTool.slopeExtended = !((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTool.slopeExtended;
                        ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.refreshMeasurements();
                        return;
                    }
                    if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.originShiftEnabled) {
                        return;
                    }
                    double dy = Double.NaN;
                    double dx = Double.NaN;
                    if (e.getKeyCode() == 38) {
                        dy = e.isShiftDown() ? -10.0 / DataToolPlotter.this.getYPixPerUnit() : -1.0 / DataToolPlotter.this.getYPixPerUnit();
                    } else if (e.getKeyCode() == 40) {
                        dy = e.isShiftDown() ? 10.0 / DataToolPlotter.this.getYPixPerUnit() : 1.0 / DataToolPlotter.this.getYPixPerUnit();
                    } else if (e.getKeyCode() == 37) {
                        dx = e.isShiftDown() ? -10.0 / DataToolPlotter.this.getXPixPerUnit() : -1.0 / DataToolPlotter.this.getXPixPerUnit();
                    } else if (e.getKeyCode() == 39) {
                        dx = e.isShiftDown() ? 10.0 / DataToolPlotter.this.getXPixPerUnit() : 1.0 / DataToolPlotter.this.getXPixPerUnit();
                    }
                    if (!Double.isNaN(dx) || !Double.isNaN(dy)) {
                        Dataset data;
                        if (!Double.isNaN(dx)) {
                            Dataset data2 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.getDataset(((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.xVar);
                            if (data2 != null && data2 instanceof DataColumn) {
                                DataColumn col = (DataColumn)data2;
                                col.setShift(col.getShift() - dx);
                                DataToolTab.this.tabChanged(true);
                                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[0].refreshX();
                                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[1].refreshX();
                                } else {
                                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[0].setX(((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[0].getX() - dx);
                                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[1].setX(((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.areaLimits[1].getX() - dx);
                                }
                            }
                        } else if (!Double.isNaN(dy) && (data = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.getDataset(((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.yVar)) != null && data instanceof DataColumn) {
                            DataColumn col = (DataColumn)data;
                            col.setShift(col.getShift() + dy);
                            DataToolTab.this.tabChanged(true);
                        }
                        DataToolTab.this.refreshAll();
                        ((CrawlerSpinnerModel)((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.shiftXSpinner.getModel()).refreshDelta();
                        ((CrawlerSpinnerModel)((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.shiftYSpinner.getModel()).refreshDelta();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!(((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getCursor() != SELECT_REMOVE_CURSOR || e.isControlDown() && e.isShiftDown())) {
                        ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setMouseCursor(SELECT_CURSOR);
                    }
                    if (e.getKeyCode() == 17) {
                        if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.toggleMeasurement) {
                            return;
                        }
                        ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.toggleMeasurement = false;
                        DataToolPlotter.this.refreshMeasurements();
                        DataToolPlotter.this.refreshArea();
                        return;
                    }
                    if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.originShiftEnabled) {
                        return;
                    }
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                        DataToolTab.this.postShiftEdit();
                    }
                }
            });
        }

        protected void lockScale(boolean lock) {
            this.scaleLocked = lock;
            if (lock) {
                this.lockedXMax = this.mouseDownXMax = this.xmax;
                this.lockedXMin = this.mouseDownXMin = this.xmin;
                this.lockedYMax = this.mouseDownYMax = this.ymax;
                this.lockedYMin = this.mouseDownYMin = this.ymin;
            }
        }

        @Override
        protected void scale(ArrayList<Drawable> tempList) {
            if (this.scaleLocked) {
                this.xminPreferred = this.lockedXMin;
                this.xmaxPreferred = this.lockedXMax;
                this.yminPreferred = this.lockedYMin;
                this.ymaxPreferred = this.lockedYMax;
            } else {
                super.scale(tempList);
            }
        }

        @Override
        protected void paintDrawableList(Graphics g, ArrayList<Drawable> tempList) {
            super.paintDrawableList(g, tempList);
            if (tempList.contains(DataToolTab.this.curveFitter.getDrawer())) {
                double[] ylimits = DataToolTab.this.curveFitter.getDrawer().getYRange();
                if (ylimits[0] >= this.getYMax() || ylimits[1] <= this.getYMin()) {
                    String s = ToolsRes.getString("DataToolTab.Plot.Message.FitNotVisible");
                    if (this.message != null && !"".equals(this.message)) {
                        s = String.valueOf(s) + "  " + this.message;
                    }
                    this.setMessage(s);
                } else {
                    this.setMessage(this.message);
                }
            } else {
                this.setMessage(this.message);
            }
            this.slopeLine.draw(g);
            this.valueCrossbars.draw(g);
        }

        protected void setAreaVisible(boolean visible) {
            DataToolTab.this.areaVisible = visible;
            if (this.areaDataset == null) {
                this.areaDataset = new Dataset();
                this.areaDataset.setMarkerShape(5);
                this.areaDataset.setConnected(false);
                this.areaDataset.setMarkerColor(new Color(102, 102, 102, 51));
                DataToolTable.WorkingDataset data = DataToolTab.this.dataTable.workingData;
                if (data != null && data.getIndex() > 1) {
                    this.areaLimits[0].x = data.getXMin();
                    this.areaLimits[1].x = data.getXMax();
                    double[] pts = data.getXPoints();
                    int i = 0;
                    while (i < pts.length) {
                        if (pts[i] == this.areaLimits[0].x) {
                            this.areaLimits[0].pointIndex = i;
                        }
                        if (pts[i] == this.areaLimits[1].x) {
                            this.areaLimits[1].pointIndex = i;
                        }
                        if (this.areaLimits[0].pointIndex > -1 && this.areaLimits[1].pointIndex > -1) break;
                        ++i;
                    }
                }
            }
            DataToolTab.this.refreshPlot();
            this.setMessage(this.createMessage());
        }

        protected void refreshMeasurements() {
            HighlightableDataset data = DataToolTab.this.dataTable.workingData;
            try {
                Interactive ia = DataToolTab.this.plot.getInteractive();
                if (ia instanceof HighlightableDataset) {
                    data = (HighlightableDataset)ia;
                }
            }
            catch (Exception ia) {
                // empty catch block
            }
            DataToolTab.this.plot.value = Double.NaN;
            DataToolTab.this.plot.slope = Double.NaN;
            double[] xpoints = null;
            double[] ypoints = null;
            int j = this.measurementIndex;
            double x = DataToolTab.this.plot.pixToX(this.measurementX);
            if (data != null && (DataToolTab.this.positionVisible || DataToolTab.this.slopeVisible || DataToolTab.this.areaVisible)) {
                if (data.getIndex() > 0 && j < 0) {
                    this.measurementIndex = j = DataToolTab.this.plot.findIndexNearestX(x, data);
                }
                xpoints = data.getXPoints();
                ypoints = data.getYPoints();
                boolean measureData = !DataToolTab.this.fitterCheckbox.isSelected() || DataToolTab.this.measureFit && DataToolTab.this.toggleMeasurement || !DataToolTab.this.measureFit && !DataToolTab.this.toggleMeasurement;
                FunctionDrawer drawer = DataToolTab.this.curveFitter.getDrawer();
                if (DataToolTab.this.positionVisible) {
                    if (measureData && j > -1 && !Double.isNaN(ypoints[j])) {
                        DataToolTab.this.plot.value = ypoints[j];
                        DataToolTab.this.plot.valueCrossbars.x = xpoints[j];
                        DataToolTab.this.plot.valueCrossbars.y = ypoints[j];
                        DataToolTab.this.plot.xVar = data.getXColumnName();
                        DataToolTab.this.plot.yVar = data.getYColumnName();
                    } else if (!measureData) {
                        DataToolTab.this.plot.value = drawer.evaluate(x);
                        DataToolTab.this.plot.valueCrossbars.x = x;
                        DataToolTab.this.plot.valueCrossbars.y = drawer.evaluate(x);
                        DataToolTab.this.plot.xVar = data.getXColumnName();
                        DataToolTab.this.plot.yVar = data.getYColumnName();
                    }
                }
                if (DataToolTab.this.slopeVisible) {
                    if (measureData && j > 0 && j < data.getIndex() - 1 && !Double.isNaN(ypoints[j])) {
                        DataToolTab.this.plot.slopeLine.x = xpoints[j];
                        DataToolTab.this.plot.slopeLine.y = ypoints[j];
                        DataToolTab.this.plot.slope = (ypoints[j + 1] - ypoints[j - 1]) / (xpoints[j + 1] - xpoints[j - 1]);
                    } else if (!measureData) {
                        DataToolTab.this.plot.slopeLine.x = x;
                        DataToolTab.this.plot.slopeLine.y = drawer.evaluate(x);
                        double dx = 1.0 / DataToolTab.this.plot.getXPixPerUnit();
                        DataToolTab.this.plot.slope = (drawer.evaluate(x + dx) - drawer.evaluate(x - dx)) / (2.0 * dx);
                    }
                }
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
            }
            DataToolTab.this.plot.repaint();
        }

        protected void refreshArea() {
            int i;
            double[] ypoints;
            double[] xpoints;
            if (!DataToolTab.this.areaVisible) {
                return;
            }
            this.area = 0.0;
            DataToolTable.WorkingDataset data = DataToolTab.this.dataTable.workingData;
            if (data == null) {
                DataToolTab.this.areaVisible = false;
                this.setMessage(this.createMessage());
                return;
            }
            boolean measureData = !DataToolTab.this.fitterCheckbox.isSelected() || DataToolTab.this.measureFit && DataToolTab.this.toggleMeasurement || !DataToolTab.this.measureFit && !DataToolTab.this.toggleMeasurement;
            FunctionDrawer drawer = DataToolTab.this.curveFitter.getDrawer();
            this.areaLimits[0].refreshX();
            this.areaLimits[1].refreshX();
            double lower = Math.min(this.areaLimits[0].x, this.areaLimits[1].x);
            double upper = Math.max(this.areaLimits[0].x, this.areaLimits[1].x);
            double del = (upper - lower) / 200000.0;
            if (del > 0.0) {
                lower -= del;
                upper += del;
            }
            if (measureData) {
                xpoints = data.getXPoints();
                ypoints = data.getYPoints();
            } else {
                int numpts = DataToolTab.this.plot.xToPix(upper) - DataToolTab.this.plot.xToPix(lower);
                double delta = (upper - lower) / (double)numpts;
                xpoints = new double[numpts];
                ypoints = new double[numpts];
                i = 0;
                while (i < numpts) {
                    xpoints[i] = lower + (double)i * delta;
                    ypoints[i] = drawer.evaluate(xpoints[i]);
                    ++i;
                }
            }
            this.areaDataset.clear();
            ArrayList<Double> x = new ArrayList<Double>();
            ArrayList<Double> y = new ArrayList<Double>();
            int i2 = 0;
            while (i2 < xpoints.length) {
                if (xpoints[i2] >= lower && xpoints[i2] <= upper && !Double.isNaN(ypoints[i2])) {
                    x.add(xpoints[i2]);
                    y.add(ypoints[i2]);
                }
                ++i2;
            }
            if (!x.isEmpty()) {
                xpoints = new double[x.size()];
                ypoints = new double[x.size()];
                i2 = 0;
                while (i2 < xpoints.length) {
                    xpoints[i2] = (Double)x.get(i2);
                    ypoints[i2] = (Double)y.get(i2);
                    ++i2;
                }
                this.areaDataset.append(xpoints[0], 0.0);
                this.areaDataset.append(xpoints, ypoints);
                this.areaDataset.append(xpoints[xpoints.length - 1], 0.0);
                int n = xpoints.length;
                if (n > 1) {
                    DataToolTab.this.plot.addDrawable(this.areaDataset);
                    this.area = ypoints[0] * (xpoints[1] - xpoints[0]);
                    this.area += ypoints[n - 1] * (xpoints[n - 1] - xpoints[n - 2]);
                    i = 1;
                    while (i < n - 1) {
                        this.area += ypoints[i] * (xpoints[i + 1] - xpoints[i - 1]);
                        ++i;
                    }
                    this.area /= 2.0;
                }
            }
            this.areaLimits[0].trueLimit = this.areaDataset.getXMin();
            this.areaLimits[1].trueLimit = this.areaDataset.getXMax();
            this.setMessage(this.createMessage());
        }

        protected int findIndexNearestX(double x, Dataset data) {
            if (data == null) {
                return -1;
            }
            int last = data.getIndex() - 1;
            if (last == -1) {
                return -1;
            }
            x = Math.max(DataToolTab.this.plot.getXMin(), x);
            x = Math.min(DataToolTab.this.plot.getXMax(), x);
            double[] xpoints = data.getXPoints();
            double[] ypoints = data.getYPoints();
            ArrayList<Double> valid = new ArrayList<Double>();
            int i = 0;
            while (i < xpoints.length) {
                if (!Double.isNaN(ypoints[i])) {
                    valid.add(xpoints[i]);
                }
                ++i;
            }
            Object[] sorted = valid.toArray(new Double[valid.size()]);
            Arrays.sort(sorted);
            last = sorted.length - 1;
            if (x < (Double)sorted[0]) {
                return 0;
            }
            if (x >= (Double)sorted[last]) {
                return last;
            }
            int i2 = 1;
            while (i2 < sorted.length) {
                if (x >= (Double)sorted[i2 - 1] && x < (Double)sorted[i2]) {
                    x = (Double)sorted[i2 - 1] < DataToolTab.this.plot.getXMin() ? (Double)sorted[i2] : ((Double)sorted[i2] > DataToolTab.this.plot.getXMax() ? ((Double)sorted[i2 - 1]).doubleValue() : ((Double)(Math.abs(x - (Double)sorted[i2 - 1]) < Math.abs(x - (Double)sorted[i2]) ? sorted[i2 - 1] : sorted[i2])).doubleValue());
                    int j = 0;
                    while (j < xpoints.length) {
                        if (xpoints[j] == x && !Double.isNaN(ypoints[j])) {
                            return j;
                        }
                        ++j;
                    }
                    return -1;
                }
                ++i2;
            }
            return -1;
        }

        protected String createMessage() {
            String xAxis = this.xVar;
            String yAxis = this.yVar;
            if (DataToolTab.this.originShiftEnabled) {
                xAxis = String.valueOf(xAxis) + DataToolTab.SHIFTED;
                yAxis = String.valueOf(yAxis) + DataToolTab.SHIFTED;
            }
            StringBuffer buf = new StringBuffer();
            if (DataToolTab.this.positionVisible && !Double.isNaN(this.value)) {
                buf.append(String.valueOf(TeXParser.removeSubscripting(xAxis)) + "=");
                buf.append(this.format(DataToolTab.this.plot.valueCrossbars.x, this.getXMax() - this.getXMin()));
                buf.append("  ");
                buf.append(String.valueOf(TeXParser.removeSubscripting(yAxis)) + "=");
                buf.append(this.format(DataToolTab.this.plot.valueCrossbars.y, this.getYMax() - this.getYMin()));
            }
            if (DataToolTab.this.slopeVisible && !Double.isNaN(this.slope)) {
                if (buf.length() > 0) {
                    buf.append("  ");
                }
                buf.append(ToolsRes.getString("DataToolPlotter.Message.Slope"));
                buf.append(this.format(DataToolTab.this.plot.slope, 0.0));
            }
            if (DataToolTab.this.areaVisible) {
                if (buf.length() > 0) {
                    buf.append("  ");
                }
                buf.append(ToolsRes.getString("DataToolPlotter.Message.Area"));
                buf.append(this.format(DataToolTab.this.plot.area, 0.0));
            }
            this.message = buf.toString();
            return this.message;
        }

        protected String format(double value, double range) {
            double zero = Math.min(1.0, range) / 1000.0;
            if (Math.abs(value) < zero) {
                value = 0.0;
            }
            if (range < 1.0 && value != 0.0) {
                return this.sciFormat.format(value);
            }
            return Math.abs(value) <= 10.0 ? this.fixedFormat.format(value) : this.sciFormat.format(value);
        }

        protected void setAxisLabels(String xAxis, String yAxis) {
            if (xAxis == null || yAxis == null) {
                return;
            }
            this.xVar = xAxis;
            this.yVar = yAxis;
            xAxis = TeXParser.removeSubscripting(xAxis);
            yAxis = TeXParser.removeSubscripting(yAxis);
            if (DataToolTab.this.originShiftEnabled) {
                xAxis = String.valueOf(xAxis) + DataToolTab.SHIFTED;
                yAxis = String.valueOf(yAxis) + DataToolTab.SHIFTED;
            }
            this.setXLabel(xAxis);
            this.setYLabel(yAxis);
            this.coordinateStrBuilder.setCoordinateLabels(String.valueOf(xAxis) + "=", "  " + yAxis + "=");
            String label = String.valueOf(ToolsRes.getString("DataToolTab.Origin.Label")) + ":  ";
            DataToolTab.this.shiftXLabel.setText(String.valueOf(label) + this.xVar);
            DataToolTab.this.shiftYLabel.setText(this.yVar);
            label = String.valueOf(ToolsRes.getString("DataToolTab.Selection.Label")) + ":  ";
            DataToolTab.this.selectedXLabel.setText(String.valueOf(label) + this.xVar);
            DataToolTab.this.selectedYLabel.setText(this.yVar);
        }

        @Override
        protected void setFontLevel(int level) {
            super.setFontLevel(level);
        }

        protected MouseInputAdapter getMouseController() {
            return this.mouseController;
        }

        protected class Crossbars {
            double x;
            double y;
            Color color = new Color(0, 0, 0);

            protected Crossbars() {
            }

            public void draw(Graphics g) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.positionVisible || Double.isNaN(DataToolPlotter.this.value)) {
                    return;
                }
                Color c = g.getColor();
                g.setColor(this.color);
                g.drawLine(DataToolPlotter.this.getLeftGutter(), DataToolPlotter.this.yToPix(this.y), DataToolPlotter.this.getWidth() - DataToolPlotter.this.getRightGutter() - 1, DataToolPlotter.this.yToPix(this.y));
                g.drawLine(DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getTopGutter(), DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getHeight() - DataToolPlotter.this.getBottomGutter() - 1);
                g.setColor(c);
            }
        }

        protected class LimitLine
        extends Line2D.Double
        implements Selectable {
            int pointIndex = -1;
            double x;
            double trueLimit;
            Stroke stroke = new BasicStroke(1.0f);
            Rectangle hitRect = new Rectangle();
            Color color = new Color(51, 51, 51);
            Color trueLimitColor;
            Cursor move;

            protected LimitLine() {
            }

            @Override
            public void draw(DrawingPanel panel, Graphics g) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible) {
                    return;
                }
                if (this.trueLimitColor == null) {
                    this.trueLimitColor = this.color.brighter().brighter().brighter();
                }
                Color gcolor = g.getColor();
                g.setColor(this.color);
                int y0 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getTopGutter();
                int y1 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBounds().height - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBottomGutter();
                int x1 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.xToPix(this.x);
                this.setLine(x1 + 1, y0, x1 + 1, y1);
                ((Graphics2D)g).fill(this.stroke.createStrokedShape(this));
                x1 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.xToPix(this.trueLimit);
                g.setColor(this.trueLimitColor);
                g.drawLine(x1 + 1, y0, x1 + 1, y1);
                g.setColor(gcolor);
                this.hitRect.setBounds(x1 - 2, y0, 6, y1 - y0 - 20);
            }

            @Override
            public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible && this.hitRect.contains(xpix, ypix)) {
                    return this;
                }
                return null;
            }

            @Override
            public Cursor getPreferredCursor() {
                if (this.move == null) {
                    String imageFile = "/org/opensourcephysics/resources/tools/images/limitcursor.gif";
                    Image im = ResourceLoader.getImage(imageFile);
                    this.move = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(16, 16), "Move Integration Limit");
                }
                return this.move;
            }

            @Override
            public void setXY(double x, double y) {
                this.setX(x);
            }

            @Override
            public void setX(double x) {
                DataToolTable.WorkingDataset data = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                this.pointIndex = -1;
                if (DataToolPlotter.this.mouseEvent != null && DataToolPlotter.this.mouseEvent.isShiftDown()) {
                    this.pointIndex = DataToolPlotter.this.findIndexNearestX(x, data);
                }
                this.x = this.pointIndex == -1 ? x : data.getXPoints()[this.pointIndex];
                DataToolPlotter.this.refreshArea();
                DataToolPlotter.this.createMessage();
                ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setMessage(DataToolPlotter.this.message);
            }

            @Override
            public boolean isMeasured() {
                return ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible;
            }

            @Override
            public double getXMin() {
                DataToolTable.WorkingDataset data = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double dx = 0.0;
                double min = 0.0;
                if (data != null && data.getIndex() > 1) {
                    dx = Math.abs(data.getXMax() - data.getXMin());
                    min = Math.min(data.getXMax(), data.getXMin());
                } else {
                    dx = Math.abs(DataToolPlotter.this.areaLimits[0].x - DataToolPlotter.this.areaLimits[1].x);
                    min = Math.min(DataToolPlotter.this.areaLimits[0].x, DataToolPlotter.this.areaLimits[1].x);
                }
                return min - 0.02 * dx;
            }

            @Override
            public double getXMax() {
                DataToolTable.WorkingDataset data = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double dx = 0.0;
                double max = 0.0;
                if (data != null && data.getIndex() > 1) {
                    dx = Math.abs(data.getXMax() - data.getXMin());
                    max = Math.max(data.getXMax(), data.getXMin());
                } else {
                    dx = Math.abs(DataToolPlotter.this.areaLimits[0].x - DataToolPlotter.this.areaLimits[1].x);
                    max = Math.max(DataToolPlotter.this.areaLimits[0].x, DataToolPlotter.this.areaLimits[1].x);
                }
                return max + 0.02 * dx;
            }

            @Override
            public double getYMin() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            @Override
            public double getYMax() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            public void refreshX() {
                double[] data = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData.getXPoints();
                if (this.pointIndex > -1 && this.pointIndex < data.length && !Double.isNaN(data[this.pointIndex])) {
                    this.x = data[this.pointIndex];
                }
            }

            @Override
            public void setY(double y) {
            }

            @Override
            public double getX() {
                return this.x;
            }

            @Override
            public double getY() {
                return 0.0;
            }

            @Override
            public void setSelected(boolean selectable) {
            }

            @Override
            public boolean isSelected() {
                return false;
            }

            @Override
            public void toggleSelected() {
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void setEnabled(boolean enable) {
            }
        }

        protected class SelectionBox
        extends Rectangle
        implements Drawable {
            boolean visible = true;
            int xstart;
            int ystart;
            Color color = new Color(0, 255, 0, 127);

            protected SelectionBox() {
            }

            @Override
            public void setSize(int w, int h) {
                int xoffset = Math.min(0, w);
                int yoffset = Math.min(0, h);
                w = Math.abs(w);
                h = Math.abs(h);
                super.setLocation(this.xstart + xoffset, this.ystart + yoffset);
                super.setSize(w, h);
            }

            @Override
            public void draw(DrawingPanel drawingPanel, Graphics g) {
                if (this.visible) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setColor(this.color);
                    g2.draw(this);
                }
            }
        }

        protected class SlopeLine
        extends Line2D.Double {
            double x;
            double y;
            Stroke stroke = new BasicStroke(1.5f);
            int length = 30;
            Color color = new Color(102, 102, 102);

            protected SlopeLine() {
            }

            public void draw(Graphics g) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.slopeVisible || Double.isNaN(DataToolPlotter.this.slope)) {
                    return;
                }
                double dxPix = 1.0 * DataToolPlotter.this.getXPixPerUnit();
                double dyPix = DataToolPlotter.this.slope * DataToolPlotter.this.getYPixPerUnit();
                double hyp = Math.sqrt(dxPix * dxPix + dyPix * dyPix);
                double sin = dyPix / hyp;
                double cos = dxPix / hyp;
                int xCenter = DataToolPlotter.this.xToPix(this.x);
                int yCenter = DataToolPlotter.this.yToPix(this.y);
                int len = this.length;
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTool.slopeExtended) {
                    len *= 40;
                    int w = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getWidth() - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getRightGutter() - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getLeftGutter();
                    int h = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getHeight() - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getTopGutter() - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBottomGutter();
                    Rectangle rect = new Rectangle(((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getLeftGutter(), ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getTopGutter(), w, h);
                    g.setClip(rect);
                }
                this.setLine((double)xCenter - (double)len * cos + 1.0, (double)yCenter + (double)len * sin + 1.0, (double)xCenter + (double)len * cos + 1.0, (double)yCenter - (double)len * sin + 1.0);
                Color gcolor = g.getColor();
                g.setColor(this.color);
                ((Graphics2D)g).fill(this.stroke.createStrokedShape(this));
                g.setColor(gcolor);
            }
        }

        protected class XYAxes
        extends TPoint {
            Line2D axisLine = new Line2D.Double();
            Stroke stroke = new BasicStroke(1.0f);
            Color color = Color.green.darker();
            Rectangle hitRectVert = new Rectangle();
            Rectangle hitRectHorz = new Rectangle();
            Ellipse2D hitOrigin = new Ellipse2D.Double();
            Point mouseDownPt;
            double mouseDownShiftX;
            double mouseDownShiftY;
            boolean isHorzHit;
            boolean isVertHit;

            protected XYAxes() {
            }

            @Override
            public void draw(DrawingPanel panel, Graphics g) {
                Color gcolor = g.getColor();
                g.setColor(this.color);
                Graphics2D g2 = (Graphics2D)g;
                int top = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getTopGutter();
                int h = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBounds().height;
                int bottom = h - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBottomGutter();
                int xx = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.xToPix(0.0);
                int left = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getLeftGutter();
                int w = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBounds().width;
                int right = w - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getRightGutter();
                int yy = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.yToPix(0.0);
                g2.drawLine(xx, top, xx, bottom);
                g2.drawLine(left, yy, right, yy);
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.originShiftEnabled) {
                    g2.drawOval(xx - 6, yy - 6, 12, 12);
                }
                g.setColor(gcolor);
                this.hitRectHorz.setBounds(left, yy - 4, w, 8);
                this.hitRectVert.setBounds(xx - 4, top, 8, h);
                this.hitOrigin.setFrameFromCenter(xx, yy, xx + 6, yy + 6);
            }

            @Override
            public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
                this.isHorzHit = false;
                this.isVertHit = false;
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.originShiftEnabled) {
                    this.isHorzHit = this.hitRectHorz.contains(xpix, ypix);
                    this.isVertHit = this.hitRectVert.contains(xpix, ypix);
                    if (this.hitOrigin.contains(xpix, ypix)) {
                        this.isVertHit = true;
                        this.isHorzHit = true;
                    }
                    if (this.isHorzHit || this.isVertHit) {
                        return this;
                    }
                }
                return null;
            }

            @Override
            public boolean isMeasured() {
                return ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.originShiftEnabled;
            }

            @Override
            public void setXY(double x, double y) {
            }

            @Override
            public double getXMin() {
                return this.getX() - this.getXSetback();
            }

            @Override
            public double getXMax() {
                return this.getX() + this.getXSetback();
            }

            @Override
            public double getYMin() {
                return this.getY() - this.getYSetback();
            }

            @Override
            public double getYMax() {
                return this.getY() + this.getYSetback();
            }

            private double getXSetback() {
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.originShiftEnabled && ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.dataPresent) {
                    DataToolTable.WorkingDataset data = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                    double w = Math.abs(data.getXMax() - data.getXMin());
                    w = Math.max(w, Math.abs(this.getX() - data.getXMax()));
                    w = Math.max(w, Math.abs(this.getX() - data.getXMin()));
                    return w / 20.0;
                }
                return 0.0;
            }

            private double getYSetback() {
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.originShiftEnabled && ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.dataPresent) {
                    DataToolTable.WorkingDataset data = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                    double h = Math.abs(data.getYMax() - data.getYMin());
                    h = Math.max(h, Math.abs(this.getY() - data.getYMax()));
                    h = Math.max(h, Math.abs(this.getY() - data.getYMin()));
                    return h / 20.0;
                }
                return 0.0;
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            String fitName;
            FitFunctionPanel panel;
            DataToolTab tab = (DataToolTab)obj;
            control.setValue("name", tab.getName());
            control.setValue("owner_name", tab.getOwnerName());
            if (!tab.ownedColumns.isEmpty()) {
                String[][] columns = new String[tab.ownedColumns.size()][3];
                int i = 0;
                for (String key : tab.ownedColumns.keySet()) {
                    String[] data = tab.ownedColumns.get(key);
                    columns[i] = new String[]{key, data[0], data[1]};
                    ++i;
                }
                control.setValue("owned_columns", columns);
            }
            control.setValue("editable", tab.userEditable);
            DatasetManager data = new DatasetManager();
            ArrayList<Dataset> functions = new ArrayList<Dataset>();
            for (Dataset next : tab.dataManager.getDatasets()) {
                if (next instanceof DataFunction) {
                    functions.add(next);
                    continue;
                }
                data.addDataset(next);
            }
            control.setValue("data", data);
            String[] paramNames = tab.dataManager.getConstantNames();
            if (paramNames.length > 0) {
                Object[][] paramArray = new Object[paramNames.length][4];
                int i = 0;
                String[] stringArray = paramNames;
                int n = paramNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    paramArray[i][0] = name;
                    paramArray[i][1] = tab.dataManager.getConstantValue(name);
                    paramArray[i][2] = tab.dataManager.getConstantExpression(name);
                    paramArray[i][3] = tab.dataManager.getConstantDescription(name);
                    ++i;
                    ++n2;
                }
                control.setValue("constants", paramArray);
            }
            if (!functions.isEmpty()) {
                DataFunction[] f = functions.toArray(new DataFunction[0]);
                control.setValue("data_functions", f);
            }
            if (tab.originShiftEnabled) {
                control.setValue("origin_shifted", tab.originShiftEnabled);
            }
            if (tab.dataTool.fitBuilder != null && tab.curveFitter != null && (panel = (FitFunctionPanel)tab.dataTool.fitBuilder.getPanel(fitName = tab.curveFitter.fit.getName())) != null) {
                ArrayList<FitFunctionPanel> fits = new ArrayList<FitFunctionPanel>();
                fits.add(panel);
                control.setValue("fits", fits);
            }
            control.setValue("selected_fit", tab.curveFitter.fit.getName());
            control.setValue("autofit", tab.curveFitter.autofitCheckBox.isSelected());
            double[] params = new double[tab.curveFitter.paramModel.getRowCount()];
            int i = 0;
            while (i < params.length) {
                Double val = (Double)tab.curveFitter.paramModel.getValueAt(i, 1);
                params[i] = val;
                ++i;
            }
            control.setValue("fit_parameters", params);
            control.setValue("fit_color", tab.curveFitter.color);
            control.setValue("fit_visible", tab.fitterCheckbox.isSelected());
            control.setValue("props_visible", tab.propsCheckbox.isSelected());
            control.setValue("stats_visible", tab.statsCheckbox.isSelected());
            int loc = tab.splitPanes[0].getDividerLocation();
            control.setValue("split_pane", loc);
            loc = tab.curveFitter.splitPane.getDividerLocation();
            control.setValue("fit_split_pane", loc);
            int[] cols = tab.dataTable.getModelColumnOrder();
            control.setValue("column_order", cols);
            String[] hidden = tab.dataTable.getHiddenMarkers();
            control.setValue("hidden_markers", hidden);
            String[] patternColumns = tab.dataTable.getFormattedColumnNames();
            if (patternColumns.length > 0) {
                ArrayList<String[]> patterns = new ArrayList<String[]>();
                int i2 = 0;
                while (i2 < patternColumns.length) {
                    String colName = patternColumns[i2];
                    String pattern = tab.dataTable.getFormatPattern(colName);
                    patterns.add(new String[]{colName, pattern});
                    ++i2;
                }
                control.setValue("format_patterns", patterns);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            DataTool dataTool = (DataTool)control.getObject("datatool");
            DatasetManager data = (DatasetManager)control.getObject("data");
            if (data == null) {
                return new DataToolTab(null, dataTool);
            }
            for (Dataset next : data.getDatasets()) {
                next.setXColumnVisible(false);
            }
            return new DataToolTab(data, dataTool);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String[] names;
            Object[][] constants;
            final DataToolTab tab = (DataToolTab)obj;
            tab.setName(control.getString("name"));
            tab.ownerName = control.getString("owner_name");
            String[][] columns = (String[][])control.getObject("owned_columns");
            if (columns != null) {
                tab.ownedColumns.clear();
                String[][] stringArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] next = stringArray[n2];
                    String[] data = new String[]{next[1], next[2]};
                    tab.ownedColumns.put(next[0], data);
                    ++n2;
                }
            }
            if ((constants = (Object[][])control.getObject("constants")) != null) {
                int i = 0;
                while (i < constants.length) {
                    String string = (String)constants[i][0];
                    double val = (Double)constants[i][1];
                    String expression = (String)constants[i][2];
                    if (constants[i].length >= 4) {
                        String desc = (String)constants[i][3];
                        tab.dataManager.setConstant(string, val, expression, desc);
                    } else {
                        tab.dataManager.setConstant(string, val, expression);
                    }
                    ++i;
                }
            }
            for (XMLProperty xMLProperty : control.getPropertyContent()) {
                if (!xMLProperty.getPropertyName().equals("data_functions")) continue;
                XMLControl[] children = xMLProperty.getChildControls();
                int i = 0;
                while (i < children.length) {
                    DataFunction f = new DataFunction(tab.dataManager);
                    children[i].loadObject(f);
                    f.setXColumnVisible(false);
                    tab.dataManager.addDataset(f);
                    ++i;
                }
                ArrayList<Dataset> datasets = tab.dataManager.getDatasets();
                int i2 = 0;
                while (i2 < datasets.size()) {
                    if (datasets.get(i2) instanceof DataFunction) {
                        ((DataFunction)datasets.get(i2)).refreshFunctionData();
                    }
                    ++i2;
                }
                tab.dataTable.refreshTable();
                break;
            }
            tab.userEditable = control.getBoolean("editable");
            ArrayList arrayList = (ArrayList)control.getObject("fits");
            if (arrayList != null) {
                for (FitFunctionPanel panel : arrayList) {
                    tab.dataTool.fitBuilder.addPanel(panel.getName(), panel);
                }
            }
            String fitName = control.getString("selected_fit");
            tab.curveFitter.fitDropDown.setSelectedItem(fitName);
            tab.curveFitter.selectFit(fitName);
            final double[] params = (double[])control.getObject("fit_parameters");
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    tab.curveFitter.setParameterValue(i, params[i]);
                    ++i;
                }
            }
            boolean autofit = control.getBoolean("autofit");
            tab.curveFitter.autofitCheckBox.setSelected(autofit);
            Color color = (Color)control.getObject("fit_color");
            tab.curveFitter.setColor(color);
            boolean vis = control.getBoolean("fit_visible");
            tab.fitterCheckbox.setSelected(vis);
            vis = control.getBoolean("stats_visible");
            tab.statsCheckbox.setSelected(vis);
            final int loc = control.getInt("split_pane");
            final int fitLoc = control.getInt("fit_split_pane");
            int[] cols = (int[])control.getObject("column_order");
            tab.dataTable.setModelColumnOrder(cols);
            if (cols == null && (names = (String[])control.getObject("working_columns")) != null) {
                tab.dataTable.setWorkingColumns(names[0], names[1]);
            }
            String[] hidden = (String[])control.getObject("hidden_markers");
            tab.dataTable.hideMarkers(hidden);
            ArrayList patterns = (ArrayList)control.getObject("format_patterns");
            if (patterns != null) {
                for (String[] next : patterns) {
                    tab.dataTable.setFormatPattern(next[0], next[1]);
                }
            }
            final boolean origin_shifted = control.getBoolean("origin_shifted");
            Runnable runner = new Runnable(){

                @Override
                public synchronized void run() {
                    tab.fitterAction.actionPerformed(null);
                    tab.propsAndStatsAction.actionPerformed(null);
                    tab.splitPanes[0].setDividerLocation(loc);
                    tab.curveFitter.splitPane.setDividerLocation(fitLoc);
                    if (origin_shifted) {
                        tab.originShiftCheckbox.doClick(0);
                        if (params != null) {
                            int i = 0;
                            while (i < params.length) {
                                tab.curveFitter.setParameterValue(i, params[i]);
                                ++i;
                            }
                        }
                    }
                    tab.dataTable.refreshTable();
                    tab.propsTable.refreshTable();
                    tab.tabChanged(false);
                }
            };
            SwingUtilities.invokeLater(runner);
            return obj;
        }
    }

    protected class ShiftEdit
    extends AbstractUndoableEdit {
        double[] redoShift;
        double[] undoShift;
        String[] columnName;

        public ShiftEdit(String[] colNames, double[] newShifts, double[] prevShifts) {
            this.columnName = colNames;
            this.redoShift = newShifts;
            this.undoShift = prevShifts;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            int i = 0;
            while (i < this.columnName.length) {
                Dataset data = DataToolTab.this.dataTable.getDataset(this.columnName[i]);
                if (data != null && data instanceof DataColumn) {
                    DataColumn dataCol = (DataColumn)data;
                    dataCol.setShift(this.undoShift[i]);
                    if (i == 0) {
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() + this.undoShift[0] - this.redoShift[0]);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() + this.undoShift[0] - this.redoShift[0]);
                        }
                    }
                }
                ++i;
            }
            DataToolTab.this.refreshAll();
            DataToolTab.this.shiftEditListener.valueChanged = false;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            int i = 0;
            while (i < this.columnName.length) {
                Dataset data = DataToolTab.this.dataTable.getDataset(this.columnName[i]);
                if (data != null && data instanceof DataColumn) {
                    DataColumn dataCol = (DataColumn)data;
                    dataCol.setShift(this.redoShift[i]);
                    if (i == 0) {
                        if (DataToolTab.this.plot.areaLimits[0].pointIndex > -1 && DataToolTab.this.plot.areaLimits[1].pointIndex > -1) {
                            DataToolTab.this.plot.areaLimits[0].refreshX();
                            DataToolTab.this.plot.areaLimits[1].refreshX();
                        } else {
                            DataToolTab.this.plot.areaLimits[0].setX(DataToolTab.this.plot.areaLimits[0].getX() + this.redoShift[0] - this.undoShift[0]);
                            DataToolTab.this.plot.areaLimits[1].setX(DataToolTab.this.plot.areaLimits[1].getX() + this.redoShift[0] - this.undoShift[0]);
                        }
                    }
                }
                ++i;
            }
            DataToolTab.this.refreshAll();
            DataToolTab.this.shiftEditListener.valueChanged = false;
        }
    }

    class ShiftEditListener
    implements ChangeListener,
    ActionListener {
        static final int MIN_TIME = 400;
        long lastChange = System.currentTimeMillis();
        boolean valueChanged = false;
        Timer repeatTimer = new Timer(200, this);

        public ShiftEditListener() {
            this.repeatTimer.start();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.valueChanged = true;
            this.lastChange = System.currentTimeMillis();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.valueChanged && System.currentTimeMillis() - this.lastChange > 400L) {
                this.valueChanged = false;
                if (DataToolTab.this.shiftXField.hasFocus() || DataToolTab.this.shiftYField.hasFocus()) {
                    DataToolTab.this.postShiftEdit();
                } else if (DataToolTab.this.selectedXField.hasFocus() || DataToolTab.this.selectedYField.hasFocus()) {
                    DataToolTab.this.postShiftEdit();
                }
            }
        }
    }
}

