/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolStatsTable
extends JTable {
    DataToolTable dataTable;
    StatsTableModel statsModel;
    DataToolTable.LabelRenderer labelRenderer;
    NumberRenderer numberRenderer = new NumberRenderer(3);
    Object[][] statsData;

    public DataToolStatsTable(DataToolTable table) {
        this.dataTable = table;
        this.statsModel = new StatsTableModel();
        this.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int labelCol;
                int col = DataToolStatsTable.this.columnAtPoint(e.getPoint());
                if (col == (labelCol = DataToolStatsTable.this.convertColumnIndexToView(0))) {
                    DataToolStatsTable.this.setToolTipText(null);
                } else {
                    int row = DataToolStatsTable.this.rowAtPoint(e.getPoint());
                    Object val = DataToolStatsTable.this.getValueAt(row, col);
                    Object stat = DataToolStatsTable.this.getValueAt(row, labelCol);
                    String name = DataToolStatsTable.this.dataTable.getColumnName(col);
                    DataToolStatsTable.this.setToolTipText(stat + "_" + name + " = " + val);
                }
            }
        });
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DataToolStatsTable.this.dataTable.dataToolTab.refreshStatusBar(DataToolStatsTable.this.dataTable.dataToolTab.getCorrelationString());
            }
        });
        this.init();
    }

    protected void init() {
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                DataToolStatsTable.this.refreshTable();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                DataToolStatsTable.this.refreshTable();
            }
        });
        this.refreshStatistics();
        this.setModel(this.statsModel);
        this.setGridColor(Color.blue);
        this.setTableHeader(null);
        this.labelRenderer = this.dataTable.labelRenderer;
        this.setAutoResizeMode(0);
        ListSelectionModel selectionModel = this.dataTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() > -1) {
                    DataToolStatsTable.this.refreshStatistics();
                }
            }
        });
        this.refreshCellWidths();
    }

    private String[] getStatLabels() {
        return new String[]{ToolsRes.getString("Table.Entry.Max"), ToolsRes.getString("Table.Entry.Min"), ToolsRes.getString("Table.Entry.Mean"), ToolsRes.getString("Table.Entry.StandardDev"), ToolsRes.getString("Table.Entry.StandardError"), ToolsRes.getString("Table.Entry.Count")};
    }

    private Object[] getStatistics(double[] data) {
        double sd;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        double sum = 0.0;
        double squareSum = 0.0;
        int count = 0;
        int i = 0;
        while (i < data.length) {
            if (!Double.isNaN(data[i])) {
                ++count;
                max = Math.max(max, data[i]);
                min = Math.min(min, data[i]);
                sum += data[i];
                squareSum += data[i] * data[i];
            }
            ++i;
        }
        double mean = sum / (double)count;
        double d = sd = count < 2 ? Double.NaN : Math.sqrt((squareSum - (double)count * mean * mean) / (double)(count - 1));
        if (max == -1.7976931348623157E308) {
            max = Double.NaN;
        }
        if (min == Double.MAX_VALUE) {
            min = Double.NaN;
        }
        return new Object[]{new Double(max), new Double(min), new Double(mean), new Double(sd), new Double(sd / Math.sqrt(count)), new Integer(count)};
    }

    public void refreshTable() {
        Runnable refresh = new Runnable(){

            @Override
            public synchronized void run() {
                DataToolStatsTable.this.tableChanged(new TableModelEvent(DataToolStatsTable.this.statsModel, -1));
                DataToolStatsTable.this.refreshCellWidths();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            refresh.run();
        } else {
            SwingUtilities.invokeLater(refresh);
        }
    }

    public void refreshStatistics() {
        TableModel model = this.dataTable.getModel();
        int[] rows = this.dataTable.getSelectedRows();
        int[] cols = this.dataTable.getSelectedColumns();
        this.statsData = new Object[model.getColumnCount()][0];
        ArrayList<Double> datalist = new ArrayList<Double>();
        this.statsData[0] = this.getStatLabels();
        int j = 1;
        while (j < model.getColumnCount()) {
            datalist.clear();
            int i = 0;
            while (i < model.getRowCount()) {
                Double val = (Double)model.getValueAt(i, j);
                if (val == null) {
                    val = new Double(Double.NaN);
                }
                datalist.add(val);
                ++i;
            }
            double[] x = new double[datalist.size()];
            int i2 = 0;
            while (i2 < x.length) {
                x[i2] = (Double)datalist.get(i2);
                ++i2;
            }
            double[] selected = x;
            if (rows.length > 0) {
                boolean colSelected = false;
                int col = this.dataTable.convertColumnIndexToView(j);
                int k = 0;
                while (k < cols.length) {
                    colSelected = colSelected || col == cols[k];
                    ++k;
                }
                if (colSelected) {
                    selected = new double[rows.length];
                    int i3 = 0;
                    while (i3 < rows.length) {
                        selected[i3] = x[rows[i3]];
                        ++i3;
                    }
                }
            }
            this.statsData[j] = this.getStatistics(selected);
            ++j;
        }
        this.refreshTable();
    }

    public void refreshCellWidths() {
        if (this.getColumnCount() != this.dataTable.getColumnCount()) {
            return;
        }
        int i = 0;
        while (i < this.getColumnCount()) {
            TableColumn propColumn = this.getColumnModel().getColumn(i);
            TableColumn dataColumn = this.dataTable.getColumnModel().getColumn(i);
            propColumn.setMaxWidth(dataColumn.getWidth());
            propColumn.setMinWidth(dataColumn.getWidth());
            propColumn.setWidth(dataColumn.getWidth());
            ++i;
        }
    }

    public void refreshGUI() {
        this.refreshStatistics();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.dataTable.convertColumnIndexToModel(column);
        if (i == 0) {
            return this.labelRenderer;
        }
        return this.numberRenderer;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.numberRenderer != null) {
            this.numberRenderer.font = font;
        }
        this.setRowHeight(font.getSize() + 4);
    }

    class NumberRenderer
    extends JLabel
    implements TableCellRenderer {
        NumberFormat format = NumberFormat.getInstance();
        Font font;

        public NumberRenderer(int sigfigs) {
            sigfigs = Math.min(sigfigs, 6);
            if (this.format instanceof DecimalFormat) {
                String pattern = "0.0";
                int i = 0;
                while (i < sigfigs - 1) {
                    pattern = String.valueOf(pattern) + "0";
                    ++i;
                }
                pattern = String.valueOf(pattern) + "E0";
                ((DecimalFormat)this.format).applyPattern(pattern);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.font == null) {
                this.font = DataToolStatsTable.this.getDefaultRenderer(String.class).getTableCellRendererComponent(DataToolStatsTable.this, "", false, false, 0, 0).getFont();
            }
            this.setFont(this.font);
            this.setHorizontalAlignment(11);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            if (value instanceof Integer) {
                this.setText(String.valueOf(value));
            } else {
                this.setText(this.format.format(value));
            }
            return this;
        }
    }

    class StatsTableModel
    extends AbstractTableModel {
        StatsTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return DataToolStatsTable.this.dataTable.getColumnName(col);
        }

        @Override
        public int getRowCount() {
            return DataToolStatsTable.this.statsData[0].length;
        }

        @Override
        public int getColumnCount() {
            return DataToolStatsTable.this.dataTable.getModel().getColumnCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            int i = DataToolStatsTable.this.dataTable.convertColumnIndexToModel(col);
            return DataToolStatsTable.this.statsData[i][row];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

