/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.DataBuilder;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class DataTool
extends OSPFrame
implements Tool,
PropertyChangeListener {
    public static boolean loadClass = false;
    protected static Dimension dim = new Dimension(800, 540);
    protected static final int defaultButtonHeight = 28;
    protected static int buttonHeight = 28;
    protected static String[] delimiters = new String[]{" ", "\t", ",", ";"};
    protected static TextFrame helpFrame;
    protected static String helpName;
    protected static String helpBase;
    private static ArrayList<Data> processedData;
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControlElement control = new XMLControlElement();
    protected Data addableData = null;
    protected boolean controlContainsData;
    protected JMenuBar emptyMenubar;
    protected JMenu emptyFileMenu;
    protected JMenuItem emptyNewTabItem;
    protected JMenuItem emptyOpenItem;
    protected JMenuItem emptyExitItem;
    protected JMenu emptyEditMenu;
    protected JMenuItem emptyPasteMenu;
    protected JMenuItem emptyPasteTabItem;
    protected JMenuBar menubar;
    protected JMenu fileMenu;
    protected JMenuItem newTabItem;
    protected JMenuItem openItem;
    protected JMenuItem importItem;
    protected JMenuItem exportItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem printItem;
    protected JMenuItem exitItem;
    protected JMenu editMenu;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenu copyMenu;
    protected JMenuItem copyImageItem;
    protected JMenuItem copyTabItem;
    protected JMenuItem copyDataItem;
    protected JMenu pasteMenu;
    protected JMenuItem pasteTabItem;
    protected JMenuItem pasteColumnsItem;
    protected JMenu displayMenu;
    protected JMenu languageMenu;
    protected JMenuItem[] languageItems;
    protected JMenu fontSizeMenu;
    protected JMenuItem defaultFontSizeItem;
    protected ButtonGroup fontSizeGroup;
    protected JMenu helpMenu;
    protected JMenuItem helpItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected DataBuilder dataBuilder;
    protected boolean exitOnClose = false;
    protected boolean saveChangesOnClose = false;
    protected FitBuilder fitBuilder;
    protected boolean isLoading = false;
    protected JButton loadDataFunctionsButton;
    protected JButton saveDataFunctionsButton;
    protected boolean slopeExtended = false;
    static final DataTool DATATOOL;

    static {
        helpName = "datatool/datatool_help.html";
        helpBase = "http://www.compadre.org/osp/online_help/tools/";
        processedData = new ArrayList();
        DATATOOL = new DataTool();
    }

    public static DataTool getTool() {
        return DATATOOL;
    }

    public static void main(String[] args) {
        DataTool.DATATOOL.exitOnClose = true;
        DataTool.DATATOOL.saveChangesOnClose = true;
        if (args != null && args.length > 0 && args[0] != null) {
            DATATOOL.setVisible(true);
            DATATOOL.open(args[0]);
        } else {
            DATATOOL.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (DATATOOL.getTabCount() == 0) {
                        DataToolTab tab = DATATOOL.createTab(null);
                        tab.setUserEditable(true);
                        DATATOOL.addTab(tab);
                    }
                }
            });
            DATATOOL.setVisible(true);
        }
    }

    public DataTool() {
        this(ToolsRes.getString("DataTool.Frame.Title"), "DataTool");
    }

    public DataTool(String fileName) {
        this();
        this.open(fileName);
    }

    public DataTool(XMLControl control) {
        this();
        this.addTabs(control);
    }

    public DataTool(Data data) {
        this();
        ArrayList<DataToolTab> tabs = this.createTabs(data);
        for (DataToolTab tab : tabs) {
            this.addTab(tab);
        }
    }

    public void setSaveChangesOnClose(boolean save) {
        this.saveChangesOnClose = save && !OSPRuntime.appletMode;
    }

    public ArrayList<DataToolTab> addTabs(XMLControl control) {
        if (DataToolTab.class == control.getObjectClass()) {
            control.setValue("datatool", this);
            this.isLoading = true;
            DataToolTab tab = (DataToolTab)control.loadObject(null);
            this.addTab(tab);
            tab.refreshGUI();
            this.isLoading = false;
            ArrayList<DataToolTab> tabs = new ArrayList<DataToolTab>();
            tabs.add(tab);
            return tabs;
        }
        if (control.getObjectClassName().endsWith("FourierToolTab")) {
            XMLControl child = control.getChildControl("source_data");
            Data source = (Data)child.loadObject(null);
            DataToolTab tab = this.createTab(source);
            this.addTab(tab);
            tab.refreshGUI();
            ArrayList<DataToolTab> tabs = new ArrayList<DataToolTab>();
            tabs.add(tab);
            return tabs;
        }
        ArrayList<DataToolTab> tabs = this.loadTabsFromXML(control, this.useChooser);
        for (DataToolTab tab : tabs) {
            this.addTab(tab);
            tab.refreshGUI();
        }
        return tabs;
    }

    public ArrayList<DataToolTab> createTabs(Data source) {
        ArrayList<Data> dataList = DataTool.getSelfContainedData(source);
        ArrayList<DataToolTab> tabList = new ArrayList<DataToolTab>();
        for (Data next : dataList) {
            DataToolTab tab = this.createTab(next);
            if (tab == null) continue;
            tabList.add(tab);
        }
        return tabList;
    }

    protected DataToolTab createTab(Data data) {
        String name;
        this.fitBuilder = this.getFitBuilder();
        DataToolTab tab = new DataToolTab(data, this);
        if (data != null && (name = data.getName()) != null && !name.equals("")) {
            tab.setName(name);
        }
        return tab;
    }

    public DataToolTab removeTab(int index, boolean saveChanges) {
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            if (saveChanges && !this.saveChangesAt(index)) {
                return null;
            }
            DataToolTab tab = this.getTab(index);
            this.fitBuilder.curveFitters.remove(tab.curveFitter);
            this.fitBuilder.removePropertyChangeListener(tab.curveFitter.fitListener);
            String title = this.tabbedPane.getTitleAt(index);
            OSPLog.finer("removing tab " + title);
            this.tabbedPane.removeTabAt(index);
            this.refreshTabTitles();
            this.refreshMenubar();
            this.refreshDataBuilder();
            return tab;
        }
        return null;
    }

    public DataToolTab removeTab(DataToolTab tab) {
        return this.removeTab(this.getTabIndex(tab), true);
    }

    public ArrayList<DataToolTab> loadData(Data data) {
        DataToolTab tab = null;
        ArrayList<DataToolTab> loadedTabs = new ArrayList<DataToolTab>();
        for (Data next : DataTool.getSelfContainedData(data)) {
            tab = this.getTab(next);
            if (tab != null) {
                tab.loadData(next, tab.replaceColumnsWithMatchingNames);
            } else {
                tab = this.createTab(next);
                this.addTab(tab);
            }
            loadedTabs.add(tab);
        }
        if (tab != null) {
            this.setSelectedTab(tab);
        }
        return loadedTabs;
    }

    public DataToolTab loadData(Data ... data) {
        if (data == null) {
            return null;
        }
        ArrayList<Data> selfContained = new ArrayList<Data>();
        Data[] dataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Data next = dataArray[n2];
            selfContained.addAll(DataTool.getSelfContainedData(next));
            ++n2;
        }
        DataToolTab tab = null;
        for (Data next : selfContained) {
            if (tab == null) {
                tab = this.getTab(next);
                if (tab != null) {
                    tab.loadData(next, tab.replaceColumnsWithMatchingNames);
                    continue;
                }
                tab = this.createTab(next);
                this.addTab(tab);
                continue;
            }
            ArrayList<DataColumn> columns = DataTool.getDataColumns(next);
            columns.remove(0);
            tab.addColumns(columns, false, false, false);
        }
        if (tab != null) {
            this.setSelectedTab(tab);
        }
        return tab;
    }

    public DataToolTab getTab(Data data) {
        int i = this.getTabIndex(data);
        return i > -1 ? this.getTab(i) : null;
    }

    public DataToolTab getTab(int index) {
        return index > -1 && index < this.tabbedPane.getTabCount() ? (DataToolTab)this.tabbedPane.getComponentAt(index) : null;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public List<DataToolTab> getTabs() {
        ArrayList<DataToolTab> tabs = new ArrayList<DataToolTab>();
        int i = 0;
        while (i < this.getTabCount()) {
            tabs.add(this.getTab(i));
            ++i;
        }
        return tabs;
    }

    public String open(String fileName) {
        OSPLog.fine("opening " + fileName);
        Resource res = ResourceLoader.getResource(fileName);
        if (res != null) {
            DatasetManager data;
            BufferedReader in = res.openReader();
            String firstLine = this.readFirstLine(in);
            if (firstLine.startsWith("<?xml")) {
                XMLControlElement control = new XMLControlElement(fileName);
                ArrayList<DataToolTab> tabs = this.addTabs(control);
                if (!tabs.isEmpty()) {
                    for (DataToolTab tab : tabs) {
                        this.refreshDataBuilder();
                        if (tabs.size() == 1) {
                            tab.fileName = fileName;
                        }
                        tab.tabChanged(false);
                    }
                    try {
                        ((Reader)in).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return fileName;
                }
            } else if (res.getString() != null && (data = DataTool.parseData(res.getString(), fileName)) != null) {
                DataToolTab tab = this.createTab(data);
                this.addTab(tab);
                this.refreshDataBuilder();
                tab.fileName = fileName;
                tab.tabChanged(false);
                return fileName;
            }
        }
        OSPLog.finest("no data found");
        return null;
    }

    public String importFileIntoTab(DataToolTab tab, String fileName) {
        OSPLog.fine("importing " + fileName);
        Resource res = ResourceLoader.getResource(fileName);
        if (res != null) {
            DatasetManager data;
            BufferedReader in = res.openReader();
            String firstLine = this.readFirstLine(in);
            if (firstLine.startsWith("<?xml")) {
                XMLControlElement control = new XMLControlElement(fileName);
                ArrayList<Data> dataList = DataTool.getSelfContainedData(control, false);
                if (!dataList.isEmpty()) {
                    DatasetManager manager = new DatasetManager();
                    for (Data next : dataList) {
                        for (DataColumn column : DataTool.getDataColumns(next)) {
                            manager.addDataset(column);
                        }
                    }
                    tab.addColumns(manager, true, true, true);
                    return fileName;
                }
            } else if (res.getString() != null && (data = DataTool.parseData(res.getString(), fileName)) != null) {
                tab.addColumns(data, true, true, true);
                return fileName;
            }
        }
        OSPLog.finest("no data found");
        return null;
    }

    @Override
    public void send(Job job, Tool replyTo) throws RemoteException {
        XMLControlElement control = new XMLControlElement(job.getXML());
        if (control.failedToRead() || control.getObjectClass() == Object.class) {
            return;
        }
        if (Data.class.isAssignableFrom(control.getObjectClass())) {
            Data data = (Data)control.loadObject(null, true, true);
            if (DataTool.isSelfContained(data)) {
                DataToolTab tab = this.getTab(data);
                if (tab == null) {
                    tab = this.createTab(null);
                    String name = data.getName();
                    if (name != null && !name.equals("")) {
                        tab.setName(name);
                    }
                    this.addTab(tab);
                } else {
                    this.setSelectedTab(tab);
                }
                tab.send(job, replyTo);
            } else {
                for (Data next : DataTool.getSelfContainedData(data)) {
                    DataToolTab tab = this.getTab(next);
                    if (tab == null) {
                        tab = this.createTab(null);
                        String name = next.getName();
                        if (name != null && !name.equals("")) {
                            tab.setName(name);
                        }
                        this.addTab(tab);
                    }
                    tab.send(new LocalJob(next), replyTo);
                }
            }
        } else {
            this.addTabs(control);
        }
    }

    public void setUseChooser(boolean useChooser) {
        this.useChooser = useChooser;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        DataToolTab tab;
        String name = e.getPropertyName();
        if (name.equals("function") && (tab = this.getSelectedTab()) != null) {
            String funcName;
            tab.tabChanged(true);
            tab.dataTable.refreshTable();
            tab.statsTable.refreshStatistics();
            if (e.getNewValue() instanceof DataFunction) {
                funcName = e.getNewValue().toString();
                tab.dataTable.getWorkingData(funcName);
            }
            if (e.getOldValue() instanceof DataFunction) {
                funcName = e.getOldValue().toString();
                tab.dataTable.removeWorkingData(funcName);
            }
            if (e.getNewValue() instanceof String) {
                funcName = e.getNewValue().toString();
                if (e.getOldValue() instanceof String) {
                    String prevName = e.getOldValue().toString();
                    tab.columnNameChanged(prevName, funcName);
                } else {
                    tab.dataTable.getWorkingData(funcName);
                }
            }
            tab.refreshPlot();
            tab.varPopup = null;
        }
    }

    protected static boolean containsDuplicateValues(double[] values) {
        int i = 0;
        while (i < values.length) {
            if (Double.isNaN(values[i])) {
                return true;
            }
            int n = DataTool.getIndex(values[i], values, i);
            if (n > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static int getIndex(double value, double[] array, int ignoreIndex) {
        int i = 0;
        while (i < array.length) {
            if (i != ignoreIndex && array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static double[] getRowArray(int rowCount) {
        double[] rows = new double[rowCount];
        int i = 0;
        while (i < rowCount) {
            rows[i] = i;
            ++i;
        }
        return rows;
    }

    protected static String[] parseStrings(String text, String delimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (text != null) {
            String next = text;
            int i = text.indexOf(delimiter);
            if (i == -1) {
                tokens.add(DataTool.stripQuotes(next));
                text = null;
            } else {
                next = text.substring(0, i);
                text = text.substring(i + 1);
            }
            while (text != null) {
                tokens.add(DataTool.stripQuotes(next));
                i = text.indexOf(delimiter);
                if (i == -1) {
                    next = text;
                    tokens.add(DataTool.stripQuotes(next));
                    text = null;
                    continue;
                }
                next = text.substring(0, i).trim();
                text = text.substring(i + 1);
            }
        }
        return tokens.toArray(new String[0]);
    }

    private static String stripQuotes(String text) {
        String stripped;
        int n;
        if (text.startsWith("\"") && (n = (stripped = text.substring(1)).indexOf("\"")) == stripped.length() - 1) {
            return stripped.substring(0, n);
        }
        return text;
    }

    protected static double[] parseDoubles(String text, String delimiter) {
        String[] strings = DataTool.parseStrings(text, delimiter);
        return DataTool.parseDoubles(strings);
    }

    protected static double[] parseDoubles(String[] strings) {
        double[] doubles = new double[strings.length];
        int i = 0;
        while (i < strings.length) {
            if (strings[i].indexOf("\t") > -1) {
                doubles[i] = Double.NaN;
            } else {
                try {
                    doubles[i] = Double.parseDouble(strings[i]);
                }
                catch (NumberFormatException e) {
                    doubles[i] = Double.NaN;
                }
            }
            ++i;
        }
        return doubles;
    }

    protected static String[][] parseStrings(String text, String rowDelimiter, String colDelimiter) {
        String[] rows = DataTool.parseStrings(text, rowDelimiter);
        String[][] tokens = new String[rows.length][0];
        int i = 0;
        while (i < rows.length) {
            tokens[i] = DataTool.parseStrings(rows[i], colDelimiter);
            ++i;
        }
        return tokens;
    }

    protected static double[][] parseDoubles(String text, String rowDelimiter, String colDelimiter) {
        String[][] strings = DataTool.parseStrings(text, rowDelimiter, colDelimiter);
        double[][] doubles = new double[strings.length][0];
        int i = 0;
        while (i < strings.length) {
            double[] row = new double[strings[i].length];
            int j = 0;
            while (j < row.length) {
                try {
                    row[j] = Double.parseDouble(strings[i][j]);
                }
                catch (NumberFormatException e) {
                    row[j] = Double.NaN;
                }
                ++j;
            }
            doubles[i] = row;
            ++i;
        }
        return doubles;
    }

    public static DatasetManager parseData(String dataString, String fileName) {
        BufferedReader input = new BufferedReader(new StringReader(dataString));
        String gnuPlotComment = "#";
        try {
            String textLine = input.readLine();
            int i = 0;
            while (i < delimiters.length) {
                ArrayList<double[]> rows = new ArrayList<double[]>();
                int columns = Integer.MAX_VALUE;
                String[] columnNames = null;
                String title = null;
                int lineCount = 0;
                while (textLine != null) {
                    int k;
                    if (textLine.startsWith("//")) {
                        textLine = input.readLine();
                        continue;
                    }
                    if (textLine.contains("#")) {
                        textLine = textLine.trim();
                    }
                    if (textLine.startsWith("#")) {
                        int k2 = textLine.indexOf("name:");
                        if (k2 > -1) {
                            title = textLine.substring(k2 + 5).trim();
                        }
                        if ((k2 = textLine.indexOf("columnNames:")) > -1) {
                            textLine = textLine.substring(k2 + 12).trim();
                        } else {
                            textLine = input.readLine();
                            continue;
                        }
                    }
                    if (textLine.indexOf("Vernier Format") > -1 || textLine.indexOf(".cmbl") > -1) {
                        textLine = input.readLine();
                        continue;
                    }
                    String[] strings = DataTool.parseStrings(textLine, delimiters[i]);
                    double[] rowData = DataTool.parseDoubles(strings);
                    if (rows.isEmpty() && strings.length > 0 && title == null) {
                        String s = "";
                        k = 0;
                        while (k < strings.length) {
                            if (Double.isNaN(rowData[k]) && !strings[k].equals("")) {
                                if (s.equals("")) {
                                    s = strings[k];
                                } else {
                                    s = "";
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (!s.equals("")) {
                            title = s;
                            textLine = input.readLine();
                            continue;
                        }
                    }
                    if (rows.isEmpty() && strings.length > 0 && columnNames == null) {
                        boolean valid = true;
                        k = 0;
                        while (k < strings.length) {
                            if (!Double.isNaN(rowData[k]) || strings[k].equals("")) {
                                valid = false;
                                break;
                            }
                            ++k;
                        }
                        if (valid) {
                            columnNames = strings;
                            textLine = input.readLine();
                            continue;
                        }
                    }
                    if (strings.length > 0) {
                        ++lineCount;
                        boolean validData = true;
                        boolean emptyData = true;
                        int k3 = 0;
                        while (k3 < strings.length) {
                            if (Double.isNaN(rowData[k3]) && !strings[k3].equals("")) {
                                validData = false;
                            }
                            if (!strings[k3].equals("")) {
                                emptyData = false;
                            }
                            ++k3;
                        }
                        if (rows.isEmpty() && emptyData && title == null && (columnNames == null || columnNames.length != 1)) {
                            validData = false;
                        }
                        if (validData) {
                            if (emptyData && columns != Integer.MAX_VALUE && rowData.length != columns) {
                                rowData = new double[columns];
                                int h = 0;
                                while (h < columns) {
                                    rowData[h] = Double.NaN;
                                    ++h;
                                }
                            }
                            rows.add(rowData);
                            columns = Math.min(rowData.length, columns);
                        }
                    }
                    if (rows.isEmpty() && lineCount > 10) break;
                    textLine = input.readLine();
                }
                if (!rows.isEmpty() && columns > 0) {
                    int j;
                    input.close();
                    double[][] dataArray = new double[columns][rows.size()];
                    int row = 0;
                    while (row < rows.size()) {
                        double[] next = (double[])rows.get(row);
                        j = 0;
                        while (j < columns) {
                            dataArray[j][row] = next[j];
                            ++j;
                        }
                        ++row;
                    }
                    DatasetManager data = new DatasetManager();
                    data.setName(title == null ? XML.getName(fileName) : title);
                    double[] rowColumn = DataTool.getRowArray(rows.size());
                    j = 0;
                    while (j < columns) {
                        Dataset dataset = data.getDataset(j);
                        String yColName = columnNames != null && columnNames.length > j ? columnNames[j] : (j == 0 && title != null ? title : "?");
                        dataset.setXYColumnNames("row", yColName);
                        dataset.setXColumnVisible(false);
                        dataset.append(rowColumn, dataArray[j]);
                        ++j;
                    }
                    OSPLog.finest("data found using delimiter \"" + delimiters[i] + "\"");
                    return data;
                }
                input.close();
                input = new BufferedReader(new StringReader(dataString));
                textLine = input.readLine();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected String readFirstLine(Reader in) {
        String openingLine;
        BufferedReader input = null;
        input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        try {
            openingLine = input.readLine();
            while (openingLine == null || openingLine.equals("")) {
                openingLine = input.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return openingLine;
    }

    protected String getUniqueTabName(String proposed) {
        if (proposed == null || proposed.equals("")) {
            proposed = ToolsRes.getString("DataToolTab.DefaultName");
        }
        ArrayList<String> taken = new ArrayList<String>();
        int i = 0;
        while (i < this.getTabCount()) {
            DataToolTab tab = this.getTab(i);
            taken.add(tab.getName());
            ++i;
        }
        if (!taken.contains(proposed)) {
            return proposed;
        }
        String subscript = TeXParser.getSubscript(proposed);
        try {
            Integer.parseInt(subscript);
            proposed = TeXParser.removeSubscript(proposed);
        }
        catch (Exception tab) {
            // empty catch block
        }
        proposed = String.valueOf(proposed) + "_";
        int i2 = 1;
        String name = String.valueOf(proposed) + i2;
        while (taken.contains(name)) {
            name = String.valueOf(proposed) + ++i2;
        }
        return name;
    }

    private static ArrayList<Data> getSelfContainedData(XMLControl control, boolean useChooser) {
        List<XMLProperty> xmlControls;
        ArrayList<Data> dataList = new ArrayList<Data>();
        if (useChooser) {
            XMLTreeChooser chooser = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), null);
            xmlControls = chooser.choose(control, Data.class);
        } else {
            XMLTree tree = new XMLTree(control);
            tree.setHighlightedClass(Data.class);
            tree.selectHighlightedProperties();
            xmlControls = tree.getSelectedProperties();
            if (xmlControls.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
        }
        HashSet<Integer> IDs = new HashSet<Integer>();
        for (XMLProperty prop : xmlControls) {
            XMLControl next = (XMLControl)prop;
            Data data = null;
            if (next instanceof XMLControlElement) {
                XMLControlElement element = (XMLControlElement)next;
                data = (Data)element.loadObject(null, true, true);
            } else {
                data = (Data)next.loadObject(null);
            }
            if (data == null) continue;
            for (Data nextData : DataTool.getSelfContainedData(data)) {
                Integer id = new Integer(nextData.getID());
                if (IDs.contains(id)) continue;
                IDs.add(id);
                dataList.add(nextData);
                if (!(nextData instanceof DatasetManager)) continue;
                for (Dataset dataset : nextData.getDatasets()) {
                    dataList.remove(dataset);
                    id = new Integer(dataset.getID());
                    IDs.add(id);
                }
            }
        }
        return dataList;
    }

    private ArrayList<DataToolTab> loadTabsFromXML(XMLControl control, boolean useChooser) {
        ArrayList<DataToolTab> loadedTabs = new ArrayList<DataToolTab>();
        ArrayList<Data> dataList = DataTool.getSelfContainedData(control, useChooser);
        for (Data next : dataList) {
            loadedTabs.add(this.createTab(next));
        }
        return loadedTabs;
    }

    public static Dataset createDatasetFromYPoints(Dataset xColumn, Dataset yColumn) {
        Dataset dataset = new Dataset();
        dataset.setXYColumnNames(xColumn.getYColumnName(), yColumn.getYColumnName());
        dataset.setLineColor(yColumn.getLineColor());
        dataset.setMarkerShape(yColumn.getMarkerShape());
        dataset.setMarkerColor(yColumn.getFillColor(), yColumn.getEdgeColor());
        double[] xPoints = xColumn.getYPoints();
        double[] yPoints = yColumn.getYPoints();
        if (xPoints.length != yPoints.length) {
            int len = Math.min(xPoints.length, yPoints.length);
            double[] newPoints = new double[len];
            int i = 0;
            while (i < len) {
                newPoints[i] = len < xPoints.length ? xPoints[i] : yPoints[i];
                ++i;
            }
            if (len < xPoints.length) {
                xPoints = newPoints;
            } else {
                yPoints = newPoints;
            }
        }
        dataset.append(xPoints, yPoints);
        return dataset;
    }

    public static ArrayList<Dataset> getDatasets(Data source) {
        int n;
        ArrayList<Dataset> datasets = source.getDatasets();
        if (datasets != null) {
            return datasets;
        }
        datasets = new ArrayList();
        double[][] data2D = source.getData2D();
        if (data2D == null || data2D.length == 0 || data2D[0] == null) {
            return datasets;
        }
        String[] colNames = source.getColumnNames();
        if (colNames == null) {
            colNames = new String[2];
            if (data2D.length == 1) {
                colNames[0] = "n";
            }
        }
        if (colNames.length > (n = Math.max(2, data2D.length))) {
            ++n;
        }
        boolean xPointsAreRowNumbers = (colNames = DataTool.getColumnNames(colNames, n)).length > data2D.length;
        double[] xPoints = xPointsAreRowNumbers ? DataTool.getRowArray(data2D[0].length) : data2D[0];
        int i = 1;
        while (i < colNames.length) {
            double[] yPoints = xPointsAreRowNumbers ? data2D[i - 1] : data2D[i];
            Dataset dataset = DataTool.createDataset(xPoints, yPoints, colNames[0], colNames[i], i, source);
            if (dataset != null) {
                datasets.add(dataset);
            }
            ++i;
        }
        return datasets;
    }

    public static ArrayList<Dataset> getAllDatasets(Data source) {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        for (Data next : DataTool.getSelfContainedData(source)) {
            datasets.addAll(DataTool.getDatasets(next));
        }
        return datasets;
    }

    protected static ArrayList<Data> getSelfContainedData(Data container) {
        processedData.clear();
        ArrayList<Data> list = DataTool.getSelfContainedDataWithTrap(container);
        return list;
    }

    protected static ArrayList<DataColumn> getDataColumns(Data source) {
        if (!DataTool.isSelfContained(source)) {
            return null;
        }
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        ArrayList<Dataset> datasetList = source.getDatasets();
        if (datasetList != null) {
            for (Dataset next : datasetList) {
                ArrayList<DataColumn> newColumns = DataTool.createDataColumns(next);
                for (DataColumn newCol : newColumns) {
                    boolean isDup = false;
                    for (DataColumn existing : columns) {
                        double[] nextPts;
                        double[] exPts;
                        if (!existing.getYColumnName().equals(newCol.getYColumnName()) || (exPts = existing.getYPoints()).length != (nextPts = newCol.getYPoints()).length) continue;
                        isDup = true;
                        int i = 0;
                        while (i < exPts.length) {
                            isDup = exPts[i] == nextPts[i] && isDup;
                            ++i;
                        }
                    }
                    if (isDup) continue;
                    columns.add(newCol);
                }
            }
        } else {
            int n;
            double[][] data2D = source.getData2D();
            if (data2D == null || data2D.length == 0 || data2D[0] == null) {
                return null;
            }
            String[] colNames = source.getColumnNames();
            if (colNames == null) {
                colNames = new String[2];
                if (data2D.length == 1) {
                    colNames[0] = "n";
                }
            }
            if (colNames.length > (n = Math.max(2, data2D.length))) {
                ++n;
            }
            boolean includeRows = (colNames = DataTool.getColumnNames(colNames, n)).length > data2D.length;
            int index = data2D[0].length;
            int i = 0;
            while (i < data2D.length) {
                if (data2D[i] != null) {
                    index = Math.max(index, data2D[i].length);
                }
                ++i;
            }
            i = 0;
            while (i < colNames.length) {
                double[] colData = includeRows ? (i == 0 ? DataTool.getRowArray(index) : data2D[i - 1]) : data2D[i];
                DataColumn dataset = DataTool.createDataColumn(colData, colNames[i], i, source);
                if (dataset != null) {
                    columns.add(dataset);
                }
                ++i;
            }
        }
        return columns;
    }

    protected static ArrayList<DataColumn> getAllDataColumns(Data source) {
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        for (Data next : DataTool.getSelfContainedData(source)) {
            columns.addAll(DataTool.getDataColumns(next));
        }
        return columns;
    }

    private static String[] getColumnNames(String[] proposed, int nameCount) {
        String[] colNames = proposed;
        if (colNames.length != nameCount) {
            colNames = new String[nameCount];
            int len = Math.min(proposed.length, colNames.length);
            System.arraycopy(proposed, 0, colNames, 0, len);
        }
        ArrayList<String> taken = new ArrayList<String>();
        char c = 'A';
        int i = 0;
        while (i < nameCount) {
            String next = colNames[i];
            if (next != null && !taken.contains(next)) {
                taken.add(next);
            } else if (next == null) {
                char c2 = c;
                c = (char)(c2 + 1);
                next = String.valueOf(c2);
                while (taken.contains(next)) {
                    char c3 = c;
                    c = (char)(c3 + '\u0001');
                    next = String.valueOf(c3);
                }
                colNames[i] = next;
                taken.add(next);
            }
            ++i;
        }
        return colNames;
    }

    private static ArrayList<Data> getSelfContainedDataWithTrap(Data source) {
        ArrayList<Data> list = new ArrayList<Data>();
        if (source == null || processedData.contains(source)) {
            return list;
        }
        processedData.add(source);
        if (DataTool.isSelfContained(source)) {
            list.add(source);
        } else {
            for (Data next : source.getDataList()) {
                ArrayList<Data> subList = DataTool.getSelfContainedDataWithTrap(next);
                list.addAll(subList);
            }
        }
        return list;
    }

    private static boolean isSelfContained(Data data) {
        return data.getDataList() == null;
    }

    private static ArrayList<DataColumn> createDataColumns(Dataset source) {
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        if (source instanceof DataColumn) {
            columns.add((DataColumn)source);
            return columns;
        }
        String[] colNames = source.getColumnNames();
        String rowName = "row";
        int i = 0;
        while (i < 2) {
            if ((i != 0 || source.isXColumnVisible()) && (i != 1 || source.isYColumnVisible())) {
                DataColumn column = new DataColumn();
                column.setName(source.getName());
                column.setXYColumnNames(rowName, colNames[i]);
                column.setConnected(source.isConnected());
                column.setLineColor(source.getLineColor());
                column.setMarkerSize(source.getMarkerSize());
                column.setMarkerShape(source.getMarkerShape());
                column.setMarkerColor(source.getFillColor(), source.getLineColor());
                column.setID(source.getID());
                column.setColumnID(i);
                column.setPoints(i == 0 ? source.getXPoints() : source.getYPoints());
                column.setXColumnVisible(false);
                columns.add(column);
            }
            ++i;
        }
        return columns;
    }

    private static DataColumn createDataColumn(double[] data, String columnName, int columnID, Data source) {
        if (data == null) {
            return null;
        }
        DataColumn column = new DataColumn();
        column.setXYColumnNames("row", columnName);
        column.setConnected(true);
        Color[] lineColors = source.getLineColors();
        if (lineColors != null && lineColors[columnID] != null) {
            column.setLineColor(lineColors[columnID]);
        } else {
            column.setLineColor(DisplayColors.getLineColor(columnID));
        }
        column.setMarkerShape(2);
        Color[] fillColors = source.getFillColors();
        if (lineColors != null && lineColors[columnID] != null && fillColors != null && fillColors[columnID] != null) {
            column.setMarkerColor(fillColors[columnID], lineColors[columnID]);
        } else {
            column.setMarkerColor(DisplayColors.getMarkerColor(columnID), DisplayColors.getLineColor(columnID));
        }
        column.setID(source.getID());
        column.setColumnID(columnID);
        column.setPoints(data);
        return column;
    }

    private static Dataset createDataset(double[] xPoints, double[] yPoints, String xName, String yName, int columnID, Data source) {
        if (yPoints == null) {
            return null;
        }
        Dataset dataset = new Dataset();
        dataset.setXYColumnNames(xName, yName);
        dataset.setConnected(true);
        Color[] lineColors = source.getLineColors();
        if (lineColors != null && lineColors[columnID] != null) {
            dataset.setLineColor(lineColors[columnID]);
        } else {
            dataset.setLineColor(DisplayColors.getLineColor(columnID));
        }
        dataset.setMarkerShape(2);
        Color[] fillColors = source.getFillColors();
        if (lineColors != null && lineColors[columnID] != null && fillColors != null && fillColors[columnID] != null) {
            dataset.setMarkerColor(fillColors[columnID], lineColors[columnID]);
        } else {
            dataset.setMarkerColor(DisplayColors.getMarkerColor(columnID), DisplayColors.getLineColor(columnID));
        }
        dataset.setID(source.getID());
        dataset.append(xPoints, yPoints);
        return dataset;
    }

    public static Dataset copyDataset(Dataset source, Dataset target, boolean includeDataAndID) {
        if (target == null) {
            target = new Dataset();
        }
        if (includeDataAndID) {
            target.clear();
            double[] x = source.getXPoints();
            double[] y = source.getYPoints();
            target.append(x, y);
            target.setID(source.getID());
        }
        target.setName(source.getName());
        target.setXYColumnNames(source.getXColumnName(), source.getYColumnName());
        target.setMarkerShape(source.getMarkerShape());
        target.setMarkerSize(source.getMarkerSize());
        Color fill = source.getFillColor();
        Color edge = source.getEdgeColor();
        target.setMarkerColor(fill, edge);
        target.setLineColor(source.getLineColor());
        target.setConnected(source.isConnected());
        target.setXColumnVisible(source.isXColumnVisible());
        target.setYColumnVisible(source.isYColumnVisible());
        return target;
    }

    protected static double[] insert(double input, double[] array, int trend) {
        int n = array.length;
        double[] newArray = new double[n + 1];
        if (trend == 0) {
            System.arraycopy(array, 0, newArray, 0, n);
            newArray[n] = input;
        } else if (trend > 0) {
            int i = 0;
            while (i < n) {
                if (input < array[i]) {
                    System.arraycopy(array, 0, newArray, 0, i);
                    System.arraycopy(array, i, newArray, i + 1, n - i);
                    newArray[i] = input;
                    return newArray;
                }
                ++i;
            }
            System.arraycopy(array, 0, newArray, 0, n);
            newArray[n] = input;
        } else {
            int i = 0;
            while (i < n) {
                if (input > array[i]) {
                    System.arraycopy(array, 0, newArray, 0, i);
                    System.arraycopy(array, i, newArray, i + 1, n - i);
                    newArray[i] = input;
                    return newArray;
                }
                ++i;
            }
            System.arraycopy(array, 0, newArray, 0, n);
            newArray[n] = input;
        }
        return newArray;
    }

    public void addTab(DataToolTab tab) {
        if (this.getTabCount() == 1) {
            DataToolTab prev = this.getTab(0);
            if (prev.originatorID == 0) {
                prev.tabChanged(false);
                this.removeTab(0, false);
            }
        }
        tab.dataTool = this;
        tab.setName(this.getUniqueTabName(tab.getName()));
        OSPLog.finer("adding tab " + tab.getName());
        this.tabbedPane.addTab("", tab);
        tab.setFontLevel(FontSizer.getLevel());
        this.tabbedPane.setSelectedComponent(tab);
        this.refreshTabTitles();
        this.refreshMenubar();
    }

    protected boolean saveChangesAt(int i) {
        if (OSPRuntime.appletMode) {
            return true;
        }
        DataToolTab tab = this.getTab(i);
        if (!tab.tabChanged) {
            return true;
        }
        String name = tab.getName();
        if (ToolsRes.getString("DataToolTab.DefaultName").equals(name) && tab.originatorID == 0) {
            return true;
        }
        int selected = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("DataTool.Dialog.SaveChanges.Message1")) + " \"" + name + "\" " + ToolsRes.getString("DataTool.Dialog.SaveChanges.Message2"), ToolsRes.getString("DataTool.Dialog.SaveChanges.Title"), 1);
        if (selected == 2) {
            return false;
        }
        return selected != 0 || this.save(tab, tab.fileName) != null;
    }

    public DataToolTab getSelectedTab() {
        return (DataToolTab)this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedTab(DataToolTab tab) {
        this.tabbedPane.setSelectedComponent(tab);
    }

    @Override
    public void clearData() {
        this.removeAllTabs();
    }

    @Override
    public void setFontLevel(int level) {
        if (this.getJMenuBar() == null) {
            return;
        }
        super.setFontLevel(level);
        FontSizer.setFonts(this.emptyMenubar, level);
        FontSizer.setFonts(this.fileMenu, level);
        FontSizer.setFonts(this.editMenu, level);
        double factor = FontSizer.getFactor(level);
        buttonHeight = (int)(factor * 28.0);
        if (this.tabbedPane != null) {
            int i = 0;
            while (i < this.getTabCount()) {
                this.getTab(i).setFontLevel(level);
                ++i;
            }
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(level);
        }
        if (this.fontSizeGroup != null) {
            Enumeration<AbstractButton> e = this.fontSizeGroup.getElements();
            while (e.hasMoreElements()) {
                AbstractButton button = e.nextElement();
                int i = Integer.parseInt(button.getActionCommand());
                if (i != FontSizer.getLevel()) continue;
                button.setSelected(true);
            }
        }
        FontSizer.setFonts(OSPLog.getOSPLog(), level);
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.contentPane.getPreferredSize().equals(dim)) {
            double f = 1.0 + 0.2 * (double)FontSizer.getLevel();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int w = Math.min(screen.width - 40, (int)((double)DataTool.dim.width * f));
            int h = Math.min(screen.height - 100, (int)((double)DataTool.dim.height * f));
            this.contentPane.setPreferredSize(new Dimension(w, h + 1));
            this.pack();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.getBounds().width) / 2;
            int y = (dim.height - this.getBounds().height) / 2;
            this.setLocation(x, y);
        }
        super.setVisible(vis);
    }

    public FitBuilder getFitBuilder() {
        if (this.fitBuilder == null) {
            this.fitBuilder = new FitBuilder((Component)this);
            this.fitBuilder.setFontLevel(FontSizer.getLevel());
            this.fitBuilder.setHelpPath("fit_builder_help.html");
        }
        return this.fitBuilder;
    }

    protected static String write(String text, String fileName) {
        File file;
        block7: {
            block8: {
                String dir;
                File file2;
                int n = fileName.lastIndexOf("/");
                if (n < 0) {
                    n = fileName.lastIndexOf("\\");
                }
                if (n > 0 && !(file2 = new File(dir = fileName.substring(0, n + 1))).exists() && !file2.mkdir()) {
                    return null;
                }
                file = new File(fileName);
                if (!file.exists()) break block7;
                if (file.canWrite()) break block8;
                JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
                return null;
            }
            int selected = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1);
            if (selected == 0) break block7;
            return null;
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName("UTF-8");
            DataTool.write(text, new OutputStreamWriter((OutputStream)stream, charset));
            if (file.exists()) {
                return file.getAbsolutePath();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected static void write(String text, Writer out) {
        try {
            BufferedWriter output = new BufferedWriter(out);
            output.write(text);
            ((Writer)output).flush();
            ((Writer)output).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected String open() {
        int result = OSPRuntime.getChooser().showOpenDialog(null);
        if (result == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String fileName = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            fileName = XML.getRelativePath(fileName);
            return this.open(fileName);
        }
        return null;
    }

    protected String importFileIntoTab(DataToolTab tab) {
        int result = OSPRuntime.getChooser().showOpenDialog(tab);
        if (result == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String fileName = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            fileName = XML.getRelativePath(fileName);
            return this.importFileIntoTab(tab, fileName);
        }
        return null;
    }

    protected String save(String fileName) {
        return this.save(this.getSelectedTab(), fileName);
    }

    protected String save(DataToolTab tab, String fileName) {
        if (fileName == null || fileName.equals("")) {
            return this.saveAs();
        }
        XMLControlElement control = new XMLControlElement(tab);
        if (control.write(fileName) == null) {
            return null;
        }
        tab.fileName = fileName;
        tab.tabChanged(false);
        return fileName;
    }

    protected String saveAs() {
        int result = OSPRuntime.getChooser().showSaveDialog(this);
        if (result == 0) {
            int selected;
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            File file = OSPRuntime.getChooser().getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return null;
            }
            String fileName = file.getAbsolutePath();
            if (fileName == null || fileName.trim().equals("")) {
                return null;
            }
            if (XML.getExtension(fileName) == null) {
                fileName = String.valueOf(fileName) + ".xml";
            }
            return this.save(XML.getRelativePath(fileName));
        }
        return null;
    }

    protected int getTabIndex(Data data) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            DataToolTab tab = (DataToolTab)this.tabbedPane.getComponentAt(i);
            if (tab.isOwnedBy(data)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getTabIndex(DataToolTab tab) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            if (tab == this.tabbedPane.getComponentAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected DataTool(String title, String name) {
        super(title);
        this.setName(name);
        this.createGUI();
        Toolbox.addTool(name, this);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DataTool.this.refreshGUI();
            }
        });
    }

    protected boolean removeAllButTab(int index) {
        int i = this.tabbedPane.getTabCount() - 1;
        while (i >= 0) {
            if (i != index) {
                if (!this.saveChangesAt(i)) {
                    return false;
                }
                String title = this.tabbedPane.getTitleAt(i);
                OSPLog.finer("removing tab " + title);
                DataToolTab tab = this.getTab(i);
                this.fitBuilder.curveFitters.remove(tab.curveFitter);
                this.fitBuilder.removePropertyChangeListener(tab.curveFitter.fitListener);
                this.tabbedPane.removeTabAt(i);
            }
            --i;
        }
        this.refreshTabTitles();
        this.refreshDataBuilder();
        return true;
    }

    protected boolean removeAllTabs() {
        int i = this.tabbedPane.getTabCount() - 1;
        while (i >= 0) {
            if (!this.saveChangesAt(i)) {
                return false;
            }
            String title = this.tabbedPane.getTitleAt(i);
            OSPLog.finer("removing tab " + title);
            DataToolTab tab = this.getTab(i);
            this.fitBuilder.curveFitters.remove(tab.curveFitter);
            this.fitBuilder.removePropertyChangeListener(tab.curveFitter.fitListener);
            this.tabbedPane.removeTabAt(i);
            --i;
        }
        this.refreshMenubar();
        this.refreshDataBuilder();
        return true;
    }

    protected void refreshTabTitles() {
        String[] tabTitles = new String[this.tabbedPane.getTabCount()];
        int i = 0;
        while (i < tabTitles.length) {
            String dataName;
            DataToolTab tab = (DataToolTab)this.tabbedPane.getComponentAt(i);
            tabTitles[i] = dataName = tab.getName();
            ++i;
        }
        i = 0;
        while (i < tabTitles.length) {
            this.tabbedPane.setTitleAt(i, tabTitles[i]);
            ++i;
        }
    }

    protected void refreshMenubar() {
        if (this.getTabCount() == 0) {
            this.emptyMenubar.add(this.displayMenu);
            this.emptyMenubar.add(this.helpMenu);
            this.setJMenuBar(this.emptyMenubar);
        } else {
            this.menubar.add(this.displayMenu);
            this.menubar.add(this.helpMenu);
            this.setJMenuBar(this.menubar);
        }
    }

    protected FunctionTool getDataBuilder() {
        if (this.dataBuilder == null) {
            this.dataBuilder = new DataBuilder(this);
            this.dataBuilder.setFontLevel(FontSizer.getLevel());
            this.dataBuilder.addPropertyChangeListener("function", this);
        }
        this.refreshDataBuilder();
        return this.dataBuilder;
    }

    protected void refreshDataBuilder() {
        if (this.dataBuilder != null) {
            this.dataBuilder.refreshPanels();
        }
    }

    protected static void copy(String text) {
        StringSelection data = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
    }

    public static String paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable data = clipboard.getContents(null);
        if (data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String text = (String)data.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected static void showHelp() {
        String fileName = helpName;
        String helpPath = XML.getResolvedPath(fileName, helpBase);
        if (ResourceLoader.getResource(helpPath) != null) {
            OSPDesktop.displayURL(helpPath);
        } else {
            fileName = "data_tool_help.html";
            String classBase = "/org/opensourcephysics/resources/tools/html/";
            helpPath = XML.getResolvedPath(fileName, classBase);
            if (helpFrame == null || !helpPath.equals(helpFrame.getTitle())) {
                helpFrame = new TextFrame(helpPath);
                helpFrame.enableHyperlinks();
                helpFrame.setSize(800, 600);
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int x = (dim.width - DataTool.helpFrame.getBounds().width) / 2;
                int y = (dim.height - DataTool.helpFrame.getBounds().height) / 2;
                helpFrame.setLocation(x, y);
            }
            helpFrame.setVisible(true);
        }
    }

    @Override
    public void setDefaultCloseOperation(int operation) {
        if (operation == 3) {
            this.exitOnClose = true;
            operation = 0;
        }
        if (operation != 0) {
            this.saveChangesOnClose = false;
        }
        super.setDefaultCloseOperation(operation);
    }

    protected void createGUI() {
        double f = 1.0 + 0.25 * (double)FontSizer.getLevel();
        Dimension used = new Dimension((int)((double)DataTool.dim.width * f), (int)((double)DataTool.dim.height * f));
        this.contentPane.setPreferredSize(used);
        this.setContentPane(this.contentPane);
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)centerPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataTool.this.exitItem.doClick(0);
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        centerPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataToolTab tab = DataTool.this.getSelectedTab();
                if (tab != null) {
                    tab.refreshData();
                    tab.dataTable.refreshTable();
                    tab.statsTable.refreshStatistics();
                    tab.propsTable.refreshTable();
                    tab.refreshPlot();
                    DataTool.this.refreshGUI();
                    tab.dataTable.requestFocusInWindow();
                    if (tab.dataTable.workingData != null) {
                        String var = tab.dataTable.workingData.getXColumnName();
                        var = TeXParser.removeSubscripting(var);
                        DataTool.this.fitBuilder.setDefaultVariables(new String[]{var});
                    }
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    final int index = DataTool.this.tabbedPane.getSelectedIndex();
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Name"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataToolTab tab = DataTool.this.getTab(index);
                            String name = tab.getName();
                            Object input = JOptionPane.showInputDialog(DataTool.this, ToolsRes.getString("DataTool.Dialog.Name.Message"), ToolsRes.getString("DataTool.Dialog.Name.Title"), 3, null, null, name);
                            if (input == null) {
                                return;
                            }
                            tab.setName("");
                            tab.setName(DataTool.this.getUniqueTabName(input.toString()));
                            tab.tabChanged(true);
                            DataTool.this.refreshTabTitles();
                            DataTool.this.refreshDataBuilder();
                        }
                    });
                    if (!DataTool.this.getTab((int)index).dataManager.getDatasets().isEmpty()) {
                        popup.addSeparator();
                        item = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.NewTab"));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                (this).DataTool.this.newTabItem.doClick(0);
                            }
                        });
                        popup.add(item);
                        JMenu cloneMenu = new JMenu(ToolsRes.getString("DataTool.Menu.Clone"));
                        popup.add(cloneMenu);
                        final JMenuItem cloneTabItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Editable"));
                        cloneMenu.add(cloneTabItem);
                        cloneTabItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String postfix;
                                String name = DataTool.this.getTab(index).getName();
                                int n = name.indexOf(postfix = "_" + ToolsRes.getString("DataTool.Clone.Subscript"));
                                if (n > -1) {
                                    name = name.substring(0, n);
                                }
                                name = String.valueOf(name) + postfix;
                                name = DataTool.this.getUniqueTabName(name);
                                (this).DataTool.this.copyTabItem.doClick(0);
                                (this).DataTool.this.pasteTabItem.doClick(0);
                                DataTool.this.getTab(DataTool.this.getTabCount() - 1).setName(name);
                                DataTool.this.refreshTabTitles();
                            }
                        });
                        item = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Noneditable"));
                        cloneMenu.add(item);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                cloneTabItem.doClick(0);
                                DataToolTab tab = DataTool.this.getTab(DataTool.this.getTabCount() - 1);
                                tab.setUserEditable(false);
                                for (Dataset next : tab.dataManager.getDatasets()) {
                                    if (!(next instanceof DataColumn)) continue;
                                    ((DataColumn)next).deletable = false;
                                }
                            }
                        });
                    }
                    popup.addSeparator();
                    item = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataTool.this.removeTab(index, true);
                        }
                    });
                    item = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataTool.this.removeAllButTab(index);
                        }
                    });
                    item = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    popup.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataTool.this.removeAllTabs();
                        }
                    });
                    FontSizer.setFonts(popup, FontSizer.getLevel());
                    popup.show(DataTool.this.tabbedPane, e.getX(), e.getY() + 8);
                }
            }
        });
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.menubar.add(this.fileMenu);
        MouseAdapter fileMenuChecker = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                boolean empty;
                boolean bl = empty = DataTool.this.getSelectedTab().originatorID == 0;
                if (!OSPRuntime.appletMode) {
                    DataTool.this.exportItem.setEnabled(!empty);
                    DataTool.this.saveItem.setEnabled(!empty);
                    DataTool.this.saveAsItem.setEnabled(!empty);
                    int[] selectedRows = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                    int endRow = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                    if (selectedRows.length == 0 || selectedRows.length == 1 && selectedRows[0] == endRow && DataTool.this.getSelectedTab().dataTable.isEmptyRow(endRow)) {
                        DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.Export"));
                    } else {
                        DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.ExportSelection"));
                    }
                }
            }
        };
        this.fileMenu.addMouseListener(fileMenuChecker);
        this.newTabItem = new JMenuItem();
        this.newTabItem.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        this.newTabItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab tab = DataTool.this.createTab(null);
                tab.userEditable = true;
                DataTool.this.addTab(tab);
                tab.refreshGUI();
            }
        });
        this.fileMenu.add(this.newTabItem);
        if (!OSPRuntime.appletMode) {
            this.openItem = new JMenuItem();
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
            this.openItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTool.this.open();
                }
            });
            this.fileMenu.add(this.openItem);
        }
        this.fileMenu.addSeparator();
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = DataTool.this.tabbedPane.getSelectedIndex();
                DataTool.this.removeTab(index, true);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.removeAllTabs();
            }
        });
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        if (!OSPRuntime.appletMode) {
            this.importItem = new JMenuItem();
            this.importItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTab tab = DataTool.this.getSelectedTab();
                    DataTool.this.importFileIntoTab(tab);
                }
            });
            this.fileMenu.add(this.importItem);
            this.exportItem = new JMenuItem();
            this.exportItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTool.this.getSelectedTab().saveTableDataToFile();
                }
            });
            this.fileMenu.add(this.exportItem);
            this.fileMenu.addSeparator();
            this.saveItem = new JMenuItem();
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, keyMask));
            this.saveItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolTab tab = DataTool.this.getSelectedTab();
                    DataTool.this.save(tab.fileName);
                }
            });
            this.fileMenu.add(this.saveItem);
            this.saveAsItem = new JMenuItem();
            this.saveAsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataTool.this.saveAs();
                }
            });
            this.fileMenu.add(this.saveAsItem);
            this.fileMenu.addSeparator();
        }
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotTool.getTool().printImage(DataTool.this);
            }
        });
        this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, keyMask));
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DataTool.this.saveChangesOnClose || DataTool.this.removeAllTabs()) {
                    if (DataTool.this.exitOnClose) {
                        System.exit(0);
                    } else {
                        DataTool.this.setVisible(false);
                    }
                }
            }
        });
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu();
        MouseAdapter editMenuChecker = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!DataTool.this.editMenu.isPopupMenuVisible() && !DataTool.this.emptyEditMenu.isPopupMenuVisible()) {
                    return;
                }
                DataToolTab tab = DataTool.this.getSelectedTab();
                if (tab != null) {
                    DataTool.this.undoItem.setEnabled(tab.undoManager.canUndo());
                    DataTool.this.redoItem.setEnabled(tab.undoManager.canRedo());
                }
                boolean enabled = DataTool.this.hasPastableData();
                DataTool.this.emptyPasteMenu.setEnabled(enabled);
                DataTool.this.pasteMenu.setEnabled(enabled);
                DataTool.this.copyMenu.removeAll();
                if (tab != null) {
                    ArrayList<Dataset> list = tab.dataManager.getDatasets();
                    DataTool.this.copyDataItem.setEnabled(!list.isEmpty());
                    if (!list.isEmpty()) {
                        boolean emptySelection;
                        DataTool.this.copyTabItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyTab"));
                        DataTool.this.copyMenu.add(DataTool.this.copyTabItem);
                        DataTool.this.copyMenu.addSeparator();
                        String s = ToolsRes.getString("DataTool.MenuItem.CopyData");
                        int[] selectedRows = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                        int endRow = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                        boolean bl = emptySelection = selectedRows.length == 1 && selectedRows[0] == endRow && DataTool.this.getSelectedTab().dataTable.isEmptyRow(endRow);
                        if (selectedRows.length > 0 && !emptySelection) {
                            s = ToolsRes.getString("DataTool.MenuItem.CopySelectedData");
                        }
                        DataTool.this.copyDataItem.setText(s);
                        DataTool.this.copyMenu.add(DataTool.this.copyDataItem);
                        DataTool.this.copyMenu.addSeparator();
                    }
                }
                DataTool.this.copyMenu.add(DataTool.this.copyImageItem);
                FontSizer.setFonts(DataTool.this.copyMenu, FontSizer.getLevel());
            }
        };
        this.editMenu.addMouseListener(editMenuChecker);
        this.menubar.add(this.editMenu);
        this.undoItem = new JMenuItem();
        this.undoItem.setEnabled(false);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, keyMask));
        this.undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTool.this.getSelectedTab().undoManager.canUndo()) {
                    DataTool.this.getSelectedTab().undoManager.undo();
                }
            }
        });
        this.editMenu.add(this.undoItem);
        this.redoItem = new JMenuItem();
        this.redoItem.setEnabled(false);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, keyMask));
        this.redoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTool.this.getSelectedTab().undoManager.canRedo()) {
                    DataTool.this.getSelectedTab().undoManager.redo();
                }
            }
        });
        this.editMenu.add(this.redoItem);
        this.editMenu.addSeparator();
        this.copyMenu = new JMenu();
        this.editMenu.add(this.copyMenu);
        this.copyTabItem = new JMenuItem();
        this.copyTabItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = DataTool.this.tabbedPane.getSelectedIndex();
                String title = DataTool.this.tabbedPane.getTitleAt(i);
                OSPLog.finest("copying tab " + title);
                XMLControlElement control = new XMLControlElement(DataTool.this.getSelectedTab());
                DataTool.copy(control.toXML());
            }
        });
        this.copyDataItem = new JMenuItem();
        this.copyDataItem.setAccelerator(KeyStroke.getKeyStroke(67, keyMask));
        this.copyDataItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.getSelectedTab().copyTableDataToClipboard();
            }
        });
        this.copyImageItem = new JMenuItem();
        this.copyImageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tabName = DataTool.this.getSelectedTab().getName();
                OSPLog.finest("copying image of " + tabName);
                SnapshotTool.getTool().copyImage(DataTool.this);
            }
        });
        MouseAdapter pasteMenuChecker = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!DataTool.this.pasteMenu.isEnabled() || DataTool.this.pasteMenu.isPopupMenuVisible()) {
                    return;
                }
                if (DataTool.this.hasPastableColumns(DataTool.this.getSelectedTab())) {
                    DataTool.this.pasteMenu.add(DataTool.this.pasteColumnsItem);
                } else {
                    DataTool.this.addableData = null;
                    DataTool.this.pasteMenu.remove(DataTool.this.pasteColumnsItem);
                }
                FontSizer.setFonts(DataTool.this.pasteMenu, FontSizer.getLevel());
            }
        };
        this.pasteMenu = new JMenu();
        this.pasteMenu.addMouseListener(pasteMenuChecker);
        this.editMenu.add(this.pasteMenu);
        this.pasteTabItem = new JMenuItem();
        this.pasteTabItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean failed = false;
                String dataString = DataTool.paste();
                if (dataString != null) {
                    if (!dataString.startsWith("<?xml")) {
                        DatasetManager importedData = DataTool.parseData(dataString, null);
                        if (importedData != null) {
                            if (e.getSource() == DataTool.this.pasteTabItem || e.getSource() == DataTool.this.emptyPasteTabItem) {
                                OSPLog.finest("pasting imported clipboard data into new tab");
                                DataToolTab tab = DataTool.this.createTab(importedData);
                                tab.userEditable = true;
                                DataTool.this.addTab(tab);
                                tab.refreshGUI();
                            }
                            DataTool.this.refreshDataBuilder();
                            return;
                        }
                        failed = true;
                    }
                    if (!failed) {
                        DataTool.this.control = new XMLControlElement();
                        DataTool.this.control.readXML(dataString);
                        if (DataTool.this.control.failedToRead()) {
                            failed = true;
                        }
                    }
                    if (!failed) {
                        OSPLog.finest("pasting clipboard XML into new tabs");
                        if (Data.class.isAssignableFrom(DataTool.this.control.getObjectClass())) {
                            Data data = (Data)DataTool.this.control.loadObject(null, true, true);
                            if (data == null) {
                                failed = true;
                            } else {
                                for (Data next : DataTool.getSelfContainedData(data)) {
                                    DataToolTab tab = DataTool.this.createTab(next);
                                    DataTool.this.addTab(tab);
                                }
                                int i = DataTool.this.getTabCount() - 1;
                                DataTool.this.tabbedPane.setSelectedIndex(i);
                            }
                        } else {
                            ArrayList<DataToolTab> tabs = DataTool.this.addTabs(DataTool.this.control);
                            for (DataToolTab tab : tabs) {
                                tab.setUserEditable(true);
                            }
                            int i = DataTool.this.getTabCount() - 1;
                            DataTool.this.tabbedPane.setSelectedIndex(i);
                        }
                    }
                    if (!failed) {
                        DataTool.this.refreshDataBuilder();
                    }
                }
                if (failed) {
                    JOptionPane.showMessageDialog(DataTool.this, ToolsRes.getString("Tool.Dialog.NoData.Message"), ToolsRes.getString("Tool.Dialog.NoData.Title"), 2);
                }
            }
        });
        this.pasteMenu.add(this.pasteTabItem);
        this.pasteColumnsItem = new JMenuItem();
        this.pasteColumnsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList dataList;
                if (DataTool.this.controlContainsData && !(dataList = DataTool.getSelfContainedData(DataTool.this.control, DataTool.this.useChooser)).isEmpty()) {
                    DatasetManager manager = new DatasetManager();
                    for (Data next : dataList) {
                        for (DataColumn column : DataTool.getDataColumns(next)) {
                            manager.addDataset(column);
                        }
                    }
                    DataTool.this.addableData = manager;
                }
                if (DataTool.this.addableData != null) {
                    DataToolTab tab = DataTool.this.getSelectedTab();
                    OSPLog.finest("pasting columns into " + tab.getName());
                    tab.addColumns(DataTool.this.addableData, true, true, true);
                }
            }
        });
        this.pasteMenu.add(this.pasteColumnsItem);
        this.displayMenu = new JMenu();
        this.menubar.add(this.displayMenu);
        this.languageMenu = new JMenu();
        String imagePath = "/org/opensourcephysics/resources/tools/images/open.gif";
        ResourceLoader.getResource(imagePath);
        final Locale[] locales = OSPRuntime.getInstalledLocales();
        AbstractAction languageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String language = e.getActionCommand();
                OSPLog.finest("setting language to " + language);
                int i = 0;
                while (i < locales.length) {
                    if (language.equals(locales[i].toString())) {
                        ToolsRes.setLocale(locales[i]);
                        return;
                    }
                    ++i;
                }
            }
        };
        ButtonGroup languageGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[locales.length];
        int i = 0;
        while (i < locales.length) {
            this.languageItems[i] = new JRadioButtonMenuItem(OSPRuntime.getDisplayLanguage(locales[i]));
            this.languageItems[i].setActionCommand(locales[i].toString());
            this.languageItems[i].addActionListener(languageAction);
            this.languageMenu.add(this.languageItems[i]);
            languageGroup.add(this.languageItems[i]);
            ++i;
        }
        this.displayMenu.add(this.languageMenu);
        this.fontSizeMenu = new JMenu();
        this.displayMenu.add(this.fontSizeMenu);
        this.fontSizeGroup = new ButtonGroup();
        AbstractAction fontSizeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                FontSizer.setLevel(i);
            }
        };
        int i2 = 0;
        while (i2 < 4) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("+" + i2);
            if (i2 == 0) {
                this.defaultFontSizeItem = item;
                item.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
            }
            item.addActionListener(fontSizeAction);
            item.setActionCommand("" + i2);
            this.fontSizeMenu.add(item);
            this.fontSizeGroup.add(item);
            if (i2 == FontSizer.getLevel()) {
                item.setSelected(true);
            }
            ++i2;
        }
        this.helpMenu = new JMenu();
        this.menubar.add(this.helpMenu);
        this.helpItem = new JMenuItem();
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, keyMask));
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.showHelp();
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, keyMask));
        this.logItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p0 = new Frame().getLocation();
                OSPLog frame = OSPLog.getOSPLog();
                if (frame.getLocation().x == p0.x && frame.getLocation().y == p0.y) {
                    Point p = DataTool.this.getLocation();
                    frame.setLocation(p.x + 28, p.y + 28);
                }
                ((Window)frame).setVisible(true);
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, keyMask));
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(this.menubar);
        this.emptyMenubar = new JMenuBar();
        this.emptyFileMenu = new JMenu();
        this.emptyMenubar.add(this.emptyFileMenu);
        this.emptyNewTabItem = new JMenuItem();
        this.emptyNewTabItem.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        this.emptyNewTabItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTab tab = DataTool.this.createTab(null);
                tab.userEditable = true;
                DataTool.this.addTab(tab);
                tab.refreshGUI();
            }
        });
        this.emptyFileMenu.add(this.emptyNewTabItem);
        this.emptyOpenItem = new JMenuItem();
        this.emptyOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
        this.emptyOpenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTool.this.open();
            }
        });
        this.emptyFileMenu.add(this.emptyOpenItem);
        this.emptyFileMenu.addSeparator();
        this.emptyExitItem = new JMenuItem();
        this.emptyExitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        this.emptyExitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.emptyFileMenu.add(this.emptyExitItem);
        this.emptyEditMenu = new JMenu();
        this.emptyEditMenu.addMouseListener(editMenuChecker);
        this.emptyMenubar.add(this.emptyEditMenu);
        this.emptyPasteMenu = new JMenu();
        this.emptyEditMenu.add(this.emptyPasteMenu);
        this.emptyPasteTabItem = new JMenuItem();
        this.emptyPasteTabItem.addActionListener(this.pasteTabItem.getAction());
        this.emptyPasteMenu.add(this.emptyPasteTabItem);
        this.refreshGUI();
        this.refreshMenubar();
        this.setFontLevel(FontSizer.getLevel());
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    @Override
    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("DataTool.Frame.Title"));
        this.emptyFileMenu.setText(ToolsRes.getString("Menu.File"));
        this.emptyNewTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        this.emptyOpenItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.emptyExitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.emptyEditMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.emptyPasteMenu.setText(ToolsRes.getString("MenuItem.Paste"));
        this.emptyPasteTabItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewTab"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.newTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        if (!OSPRuntime.appletMode) {
            this.openItem.setText(ToolsRes.getString("MenuItem.Open"));
            this.importItem.setText(ToolsRes.getString("DataTool.MenuItem.Import"));
            this.saveItem.setText(ToolsRes.getString("DataTool.MenuItem.Save"));
            this.saveAsItem.setText(ToolsRes.getString("DataTool.MenuItem.SaveAs"));
        }
        this.closeItem.setText(ToolsRes.getString("MenuItem.Close"));
        this.closeAllItem.setText(ToolsRes.getString("MenuItem.CloseAll"));
        this.printItem.setText(ToolsRes.getString("DataTool.MenuItem.Print"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.editMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.undoItem.setText(ToolsRes.getString("DataTool.MenuItem.Undo"));
        this.redoItem.setText(ToolsRes.getString("DataTool.MenuItem.Redo"));
        this.copyMenu.setText(ToolsRes.getString("DataTool.Menu.Copy"));
        this.copyImageItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyImage"));
        this.pasteMenu.setText(ToolsRes.getString("MenuItem.Paste"));
        this.pasteTabItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewTab"));
        this.pasteColumnsItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewColumns"));
        this.displayMenu.setText(ToolsRes.getString("Tool.Menu.Display"));
        this.languageMenu.setText(ToolsRes.getString("Tool.Menu.Language"));
        this.fontSizeMenu.setText(ToolsRes.getString("Tool.Menu.FontSize"));
        this.defaultFontSizeItem.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.helpItem.setText(ToolsRes.getString("DataTool.MenuItem.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        Locale[] locales = OSPRuntime.getInstalledLocales();
        int i = 0;
        while (i < locales.length) {
            if (locales[i].getLanguage().equals(ToolsRes.getLanguage())) {
                this.languageItems[i].setSelected(true);
            }
            ++i;
        }
    }

    protected boolean hasPastableData() {
        boolean hasData;
        this.controlContainsData = false;
        String dataString = DataTool.paste();
        boolean bl = hasData = dataString != null;
        if (hasData) {
            if (!dataString.startsWith("<?xml")) {
                this.addableData = DataTool.parseData(dataString, null);
                hasData = this.addableData != null;
            } else {
                this.control = new XMLControlElement();
                this.control.readXML(dataString);
                Class<?> type = this.control.getObjectClass();
                if (Data.class.isAssignableFrom(type)) {
                    this.addableData = (Data)this.control.loadObject(null);
                } else if (!DataToolTab.class.isAssignableFrom(type)) {
                    XMLTree tree = new XMLTree(this.control);
                    tree.setHighlightedClass(Data.class);
                    tree.selectHighlightedProperties();
                    if (!tree.getSelectedProperties().isEmpty()) {
                        this.controlContainsData = true;
                    }
                }
                hasData = this.addableData != null || DataToolTab.class.isAssignableFrom(type) || this.controlContainsData;
            }
        }
        return hasData;
    }

    protected boolean hasPastableColumns(DataToolTab tab) {
        boolean pastable = false;
        if (this.addableData != null) {
            String dataName = this.addableData.getName();
            if (tab.dataManager.getDatasets().isEmpty() || dataName != null && !dataName.equals(tab.getName())) {
                pastable = true;
            }
        }
        return pastable || this.controlContainsData;
    }

    protected void showAboutDialog() {
        String date = OSPRuntime.getLaunchJarBuildDate();
        if (date == null) {
            date = "";
        }
        String aboutString = String.valueOf(this.getName()) + "   " + date + "\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, aboutString, String.valueOf(ToolsRes.getString("Dialog.About.Title")) + " " + this.getName(), 1);
    }

    protected static JButton createButton(String text) {
        JButton button = new JButton(text){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = buttonHeight;
                return dim;
            }
        };
        return button;
    }
}

