/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class DataRefreshTool
implements Tool {
    private static Map<Data, DataRefreshTool> tools = new HashMap<Data, DataRefreshTool>();
    private Data data;
    protected HashSet<Data> moreData = new HashSet();
    private HashMap<Integer, Dataset> ids = new HashMap();

    public static DataRefreshTool getTool(Data data) {
        DataRefreshTool tool = tools.get(data);
        if (tool == null) {
            tool = new DataRefreshTool(data);
            tools.put(data, tool);
        }
        return tool;
    }

    private DataRefreshTool(Data data) {
        this.data = data;
    }

    @Override
    public void send(Job job, Tool replyTo) throws RemoteException {
        XMLControlElement control = new XMLControlElement(job.getXML());
        if (control.failedToRead() || replyTo == null || !Data.class.isAssignableFrom(control.getObjectClass())) {
            return;
        }
        Data request = (Data)control.loadObject(null, true, true);
        if (request.getID() == this.data.getID()) {
            control = new XMLControlElement(this.data);
            job.setXML(control.toXML());
            replyTo.send(job, this);
            return;
        }
        for (Data next : DataTool.getSelfContainedData(this.data)) {
            if (request.getID() != next.getID()) continue;
            control = new XMLControlElement(next);
            job.setXML(control.toXML());
            replyTo.send(job, this);
            return;
        }
        ArrayList<Dataset> localDatasets = DataTool.getDatasets(this.data);
        for (Dataset next : localDatasets) {
            if (request.getID() != next.getID()) continue;
            control = new XMLControlElement(next);
            job.setXML(control.toXML());
            replyTo.send(job, this);
            return;
        }
        DatasetManager reply = new DatasetManager();
        reply.setName(request.getName());
        this.ids.clear();
        ArrayList<Dataset> requestedDatasets = DataTool.getDatasets(request);
        this.findDatasets(requestedDatasets, localDatasets, reply, false);
        if (!this.moreData.isEmpty()) {
            for (Data more : this.moreData) {
                localDatasets = DataTool.getDatasets(more);
                this.findDatasets(requestedDatasets, localDatasets, reply, true);
            }
            this.padDatasets(reply);
        }
        if (!reply.getDatasets().isEmpty()) {
            control = new XMLControlElement(reply);
            job.setXML(control.toXML());
            replyTo.send(job, this);
        }
    }

    public void addData(Data data) {
        if (data == this.data) {
            return;
        }
        this.moreData.add(data);
    }

    public void removeData(Data data) {
        this.moreData.remove(data);
    }

    private void padDatasets(DatasetManager datasets) {
        TreeSet<Double> tSet = new TreeSet<Double>();
        for (Dataset dataset : datasets.getDatasets()) {
            double[] dArray = dataset.getXPoints();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double t = dArray[n2];
                tSet.add(t);
                ++n2;
            }
        }
        Double[] temp = tSet.toArray(new Double[tSet.size()]);
        double[] array = new double[tSet.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = temp[i];
            ++i;
        }
        for (Dataset dataset : datasets.getDatasets()) {
            this.padDataset(dataset, array);
        }
    }

    private void findDatasets(ArrayList<Dataset> requestedDatasets, ArrayList<Dataset> datasetsToSearch, DatasetManager reply, boolean isMore) {
        for (Dataset next : requestedDatasets) {
            Dataset match;
            if (next == null || (match = this.getMatch(next.getID(), datasetsToSearch)) == null) continue;
            Dataset toSend = this.ids.get(match.getID());
            if (toSend == null) {
                toSend = DataTool.copyDataset(match, null, true);
                if (isMore) {
                    toSend.setXYColumnNames(match.getXColumnName(), next.getYColumnName());
                }
                toSend.setXColumnVisible(toSend.getXColumnName().equals(next.getYColumnName()));
                toSend.setYColumnVisible(toSend.getYColumnName().equals(next.getYColumnName()));
                this.ids.put(match.getID(), toSend);
            } else {
                if (toSend.getXColumnName().equals(next.getYColumnName())) {
                    toSend.setXColumnVisible(true);
                }
                if (toSend.getYColumnName().equals(next.getYColumnName())) {
                    toSend.setYColumnVisible(true);
                }
            }
            reply.addDataset(toSend);
        }
    }

    private Dataset getMatch(int id, ArrayList<Dataset> datasets) {
        for (Dataset next : datasets) {
            if (next == null || id != next.getID()) continue;
            return next;
        }
        return null;
    }

    private void padDataset(Dataset dataset, double[] newXArray) {
        double[] xArray = dataset.getXPoints();
        double[] yArray = dataset.getYPoints();
        HashMap<Double, Double> valueMap = new HashMap<Double, Double>();
        int k = 0;
        while (k < xArray.length) {
            valueMap.put(xArray[k], yArray[k]);
            ++k;
        }
        double[] newYArray = new double[newXArray.length];
        int k2 = 0;
        while (k2 < newXArray.length) {
            double x = newXArray[k2];
            newYArray[k2] = valueMap.keySet().contains(x) ? (Double)valueMap.get(x) : Double.NaN;
            ++k2;
        }
        dataset.clear();
        dataset.append(newXArray, newYArray);
    }
}

