/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataFunctionEditor;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionPanel
extends FunctionPanel {
    public DataFunctionPanel(DatasetManager input) {
        this(new DataFunctionEditor(input));
    }

    public DataFunctionPanel(DataFunctionEditor editor) {
        super(editor);
        String name = editor.getData().getName();
        this.setName(name.equals("") ? "data" : name);
    }

    public DatasetManager getData() {
        return ((DataFunctionEditor)this.functionEditor).getData();
    }

    @Override
    public String getLabel() {
        return ToolsRes.getString("DataFunctionPanel.SpinnerLabel");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("edit")) {
            this.refreshFunctions();
            super.propertyChange(e);
        } else if (e.getPropertyName().equals("function")) {
            if (e.getNewValue() != null) {
                DataFunction f = (DataFunction)e.getNewValue();
                this.getData().addDataset(f);
            } else if (e.getOldValue() != null) {
                DataFunction f = (DataFunction)e.getOldValue();
                int i = this.getData().getDatasetIndex(f.getYColumnName());
                this.getData().removeDataset(i);
            }
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null) {
                this.functionTool.refreshGUI();
                this.functionTool.firePropertyChange("function", e.getOldValue(), e.getNewValue());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void refreshFunctions() {
        void var2_6;
        String[] stringArray = this.getData().getConstantNames();
        int n = stringArray.length;
        boolean n2 = false;
        while (var2_6 < n) {
            String name = stringArray[var2_6];
            this.getData().clearConstant(name);
            ++var2_6;
        }
        for (Parameter parameter : this.paramEditor.getObjects()) {
            String name = parameter.getName();
            double val = parameter.getValue();
            this.getData().setConstant(name, val, parameter.getExpression(), parameter.getDescription());
        }
        this.functionEditor.evaluateAll();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DataFunctionPanel panel = (DataFunctionPanel)obj;
            control.setValue("description", panel.getDescription());
            Parameter[] params = panel.getParamEditor().getParameters();
            control.setValue("user_parameters", params);
            FunctionEditor editor = panel.getFunctionEditor();
            ArrayList<String[]> functions = new ArrayList<String[]>();
            for (Object next : editor.getObjects()) {
                functions.add(new String[]{editor.getName(next), editor.getExpression(next)});
            }
            control.setValue("functions", functions);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Parameter param;
            DataFunctionPanel panel = (DataFunctionPanel)obj;
            panel.setDescription(control.getString("description"));
            Parameter[] params = (Parameter[])control.getObject("user_parameters");
            Parameter[] existing = panel.getParamEditor().getParameters();
            ArrayList<Parameter> allParams = new ArrayList<Parameter>();
            ArrayList<String> names = new ArrayList<String>();
            Parameter[] parameterArray = existing;
            int n = existing.length;
            int n2 = 0;
            while (n2 < n) {
                param = parameterArray[n2];
                allParams.add(param);
                names.add(param.getName());
                ++n2;
            }
            parameterArray = params;
            n = params.length;
            n2 = 0;
            while (n2 < n) {
                param = parameterArray[n2];
                if (!names.contains(param.getName())) {
                    allParams.add(param);
                }
                ++n2;
            }
            params = allParams.toArray(new Parameter[allParams.size()]);
            panel.getParamEditor().setParameters(params);
            ArrayList functionsToImport = (ArrayList)control.getObject("functions");
            FunctionEditor editor = panel.getFunctionEditor();
            List<Object> existingFunctions = editor.getObjects();
            DatasetManager data = panel.getData();
            block2: for (Object next : functionsToImport) {
                String[] function = (String[])next;
                for (Object f : existingFunctions) {
                    DataFunction dataFunction = (DataFunction)f;
                    if (dataFunction.getYColumnName().equals(function[0]) && dataFunction.getExpression().equals(function[1])) continue block2;
                }
                DataFunction newFunction = new DataFunction(data, function[0], function[1]);
                editor.addObject(newFunction, false);
            }
            return obj;
        }
    }
}

