/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionEditor
extends FunctionEditor {
    private DatasetManager data;
    static Color[] markerColors = new Color[]{Color.green.darker(), Color.red, Color.cyan.darker(), Color.yellow.darker(), Color.blue};

    public DataFunctionEditor(DatasetManager data) {
        this.data = data;
        for (Dataset next : data.getDatasets()) {
            if (!(next instanceof DataFunction)) continue;
            this.objects.add(next);
        }
    }

    public DatasetManager getData() {
        return this.data;
    }

    @Override
    public String getName(Object obj) {
        return obj == null ? null : ((DataFunction)obj).getYColumnName();
    }

    @Override
    public String getExpression(Object obj) {
        return obj == null ? null : ((DataFunction)obj).getInputString();
    }

    @Override
    public String getDescription(Object obj) {
        return obj == null ? null : ((DataFunction)obj).getYColumnDescription();
    }

    @Override
    public void setDescription(Object obj, String desc) {
        if (obj != null) {
            if (desc != null && desc.trim().equals("")) {
                desc = null;
            }
            ((DataFunction)obj).setYColumnDescription(desc);
            super.setDescription(obj, desc);
        }
    }

    @Override
    public String getTooltip(Object obj) {
        return obj == null ? null : ((DataFunction)obj).getYColumnDescription();
    }

    @Override
    public boolean isNameEditable(Object obj) {
        return true;
    }

    @Override
    public boolean isExpressionEditable(Object obj) {
        return true;
    }

    @Override
    public void evaluateAll() {
        super.evaluateAll();
        int i = 0;
        while (i < this.evaluate.size()) {
            DataFunction f = (DataFunction)this.evaluate.get(i);
            f.setExpression(f.getInputString());
            ++i;
        }
    }

    @Override
    public Object addObject(Object obj, int row, boolean postEdit, boolean firePropertyChange) {
        if ((obj = super.addObject(obj, row, postEdit, firePropertyChange)) != null) {
            this.firePropertyChange("function", null, obj);
        }
        return obj;
    }

    @Override
    public Object removeObject(Object obj, boolean postEdit) {
        if ((obj = super.removeObject(obj, postEdit)) != null) {
            this.firePropertyChange("function", obj, null);
        }
        return obj;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder) {
            ((TitledBorder)border).setTitle(ToolsRes.getString("DataFunctionEditor.Border.Title"));
        }
    }

    @Override
    protected boolean isDisallowedName(Object obj, String name) {
        ArrayList<Dataset> datasets = this.data.getDatasets();
        int i = 0;
        while (i < datasets.size()) {
            Dataset next = datasets.get(i);
            if (obj != null && next == obj && this.getName(obj).equals(name)) {
                return false;
            }
            if (i == 0 && TeXParser.removeSubscripting(next.getXColumnName()).equals(name)) {
                return true;
            }
            if (TeXParser.removeSubscripting(next.getYColumnName()).equals(name)) {
                return true;
            }
            ++i;
        }
        return super.isDisallowedName(obj, name);
    }

    @Override
    protected String getVariablesString(String separator) {
        StringBuffer vars = new StringBuffer("");
        int init = vars.length();
        boolean firstItem = true;
        if (this.paramEditor != null) {
            Parameter[] parameters = this.paramEditor.getParameters();
            int i = 0;
            while (i < parameters.length) {
                if (!firstItem) {
                    vars.append(" ");
                }
                vars.append(parameters[i].getName());
                firstItem = false;
                ++i;
            }
        }
        String nameToSkip = this.getName(this.getSelectedObject());
        ArrayList<Dataset> datasets = this.data.getDatasets();
        int i = 0;
        while (i < datasets.size()) {
            String name;
            Dataset next = datasets.get(i);
            if (i == 0) {
                name = next.getXColumnName();
                if (!firstItem) {
                    vars.append(" ");
                }
                vars.append(TeXParser.removeSubscripting(name));
                firstItem = false;
            }
            if (!(name = next.getYColumnName()).equals(nameToSkip)) {
                if (!firstItem) {
                    vars.append(" ");
                }
                vars.append(TeXParser.removeSubscripting(name));
                firstItem = false;
            }
            ++i;
        }
        if (vars.length() == init) {
            return ToolsRes.getString("FunctionPanel.Instructions.Help");
        }
        return String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + separator + vars.toString();
    }

    @Override
    protected boolean isInvalidExpression(Object obj) {
        DataFunction f = (DataFunction)obj;
        return !f.getInputString().equals(f.getExpression());
    }

    @Override
    protected Object createObject(String name, String expression, Object obj) {
        DataFunction f = (DataFunction)obj;
        if (f != null && f.getYColumnName().equals(name) && f.getInputString().equals(expression)) {
            return f;
        }
        if (f == null) {
            f = new DataFunction(this.data);
            int i = this.objects.size();
            if (i < markerColors.length) {
                f.setMarkerColor(markerColors[i], markerColors[i].darker());
                f.setLineColor(markerColors[i]);
            }
            f.setYColumnName(name);
            f.setExpression(expression);
        } else if (!f.getYColumnName().equals(name)) {
            f.setYColumnName(name);
        } else {
            f.setExpression(expression);
        }
        return f;
    }

    @Override
    protected void paste() {
        XMLControl[] controls = this.getClipboardContents();
        if (controls == null) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            DataFunction f = new DataFunction(this.data);
            Object obj = controls[i].loadObject(f);
            this.addObject(obj, true);
            ++i;
        }
        this.evaluateAll();
    }
}

