/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.tools.DataTool;

public class DataColumn
extends Dataset {
    boolean deletable = false;
    double shift;
    boolean shifted = false;

    public DataColumn() {
        super.setXColumnVisible(false);
        super.setXYColumnNames("row", this.getYColumnName());
    }

    public void setPoints(double[] yPoints) {
        this.clear();
        double[] rows = DataTool.getRowArray(yPoints.length);
        this.append(rows, yPoints);
    }

    @Override
    public void setXYColumnNames(String xName, String yName) {
        super.setXYColumnNames("row", yName);
    }

    @Override
    public void setXYColumnNames(String xName, String yName, String name) {
        super.setXYColumnNames("row", yName, name);
    }

    @Override
    public void setXColumnVisible(boolean b) {
    }

    @Override
    public double[] getYPoints() {
        double[] temp = new double[this.index];
        int i = 0;
        while (i < this.index) {
            temp[i] = this.isShifted() ? this.ypoints[i] + this.shift : this.ypoints[i];
            ++i;
        }
        return temp;
    }

    public void setShifted(boolean shift) {
        this.shifted = shift;
    }

    public boolean isShifted() {
        return this.shifted;
    }

    public boolean setShift(double shift) {
        if (this.shift == shift) {
            return false;
        }
        this.shift = shift;
        return true;
    }

    public double getShift() {
        return this.shift;
    }

    public boolean setShiftedValue(int i, double value) {
        if (i < 0 || i >= this.getIndex()) {
            return false;
        }
        double d = value - this.ypoints[i];
        if (!Double.isNaN(d)) {
            return this.setShift(d);
        }
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DataColumn column = (DataColumn)obj;
            double shift = column.getShift();
            if (shift != 0.0) {
                control.setValue("shift", shift);
                column.shift = 0.0;
            }
            Dataset.getLoader().saveObject(control, column);
            column.shift = shift;
            if (column.deletable) {
                control.setValue("deletable", true);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DataColumn();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DataColumn column = (DataColumn)obj;
            Dataset.getLoader().loadObject(control, column);
            if (control.getPropertyNames().contains("shift")) {
                column.shift = control.getDouble("shift");
            }
            column.deletable = control.getBoolean("deletable");
            return obj;
        }
    }
}

