/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class DataBuilder
extends FunctionTool {
    private DataTool dataTool;
    private JButton loadButton;
    private JButton saveButton;

    public DataBuilder(DataTool tool) {
        super((Component)tool);
        this.dataTool = tool;
        this.setHelpPath("data_builder_help.html");
        this.createButtons();
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton});
    }

    private void createButtons() {
        String imageFile = "/org/opensourcephysics/resources/tools/images/open.gif";
        Icon openIcon = ResourceLoader.getIcon(imageFile);
        this.loadButton = new JButton(openIcon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = OSPRuntime.createChooser(ToolsRes.getString("DataBuilder.Load.Title"), ToolsRes.getString("FileChooser.Filter.XMLFiles"), new String[]{"xml"});
                int result = chooser.showOpenDialog(DataBuilder.this.dataTool);
                if (result == 0) {
                    OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                    String fileName = chooser.getSelectedFile().getAbsolutePath();
                    XMLControlElement control = new XMLControlElement(fileName);
                    if (control.failedToRead()) {
                        JOptionPane.showMessageDialog(DataBuilder.this.dataTool, ToolsRes.getString("Dialog.Invalid.Message"), ToolsRes.getString("Dialog.Invalid.Title"), 0);
                        return;
                    }
                    Class<?> type = control.getObjectClass();
                    if (DataFunctionPanel.class.isAssignableFrom(type)) {
                        if (DataBuilder.this.chooseDataFunctions(control, "Load", null)) {
                            control.loadObject(DataBuilder.this.getSelectedPanel());
                        }
                    } else {
                        JOptionPane.showMessageDialog(DataBuilder.this.dataTool, ToolsRes.getString("DataBuilder.Dialog.WrongType.Message"), ToolsRes.getString("DataBuilder.Dialog.WrongType.Title"), 0);
                    }
                }
            }
        });
        imageFile = "/org/opensourcephysics/resources/tools/images/save.gif";
        Icon saveIcon = ResourceLoader.getIcon(imageFile);
        this.saveButton = new JButton(saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser;
                int result;
                XMLControlElement control = new XMLControlElement(DataBuilder.this.getSelectedPanel());
                if (DataBuilder.this.chooseDataFunctions(control, "Save", null) && (result = (chooser = OSPRuntime.createChooser(ToolsRes.getString("DataBuilder.Save.Title"), ToolsRes.getString("FileChooser.Filter.XMLFiles"), new String[]{"xml"})).showSaveDialog(DataBuilder.this.dataTool)) == 0) {
                    int selected;
                    OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                    File file = chooser.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    if (!"xml".equals(XML.getExtension(fileName))) {
                        fileName = String.valueOf(XML.stripExtension(fileName)) + ".xml";
                        file = new File(fileName);
                    }
                    if (file.exists() && (selected = JOptionPane.showConfirmDialog(DataBuilder.this.dataTool, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 2)) != 0) {
                        return;
                    }
                    control.write(fileName);
                }
            }
        });
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.dropdown.setToolTipText(ToolsRes.getString("DataTool.DataBuilder.Dropdown.Tooltip"));
        this.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
        if (this.loadButton != null) {
            FunctionPanel panel = this.getSelectedPanel();
            this.loadButton.setEnabled(panel != null);
            this.saveButton.setEnabled(panel != null);
            this.loadButton.setToolTipText(ToolsRes.getString("DataBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(ToolsRes.getString("DataBuilder.Button.Save.Tooltip"));
        }
    }

    protected void refreshPanels() {
        String name;
        ArrayList<String> tabNames = new ArrayList<String>();
        int i = 0;
        while (i < this.dataTool.tabbedPane.getTabCount()) {
            DataToolTab tab = this.dataTool.getTab(i);
            tabNames.add(tab.getName());
            if (this.getPanel(tab.getName()) == null) {
                DataFunctionPanel panel = new DataFunctionPanel(tab.dataManager);
                this.addPanel(tab.getName(), panel);
            }
            ++i;
        }
        ArrayList<String> remove = new ArrayList<String>();
        Iterator<Object> it = this.panels.keySet().iterator();
        while (it.hasNext()) {
            name = ((String)it.next()).toString();
            if (tabNames.contains(name)) continue;
            remove.add(name);
        }
        it = remove.iterator();
        while (it.hasNext()) {
            name = ((String)it.next()).toString();
            this.removePanel(name);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean chooseDataFunctions(XMLControl control, String description, Collection<String[]> selectedFunctions) {
        void var11_12;
        ListChooser listChooser = new ListChooser(ToolsRes.getString("DataBuilder." + description + ".Title"), ToolsRes.getString("DataBuilder." + description + ".Message"), this);
        listChooser.setSeparator(" = ");
        ArrayList<String[]> originals = new ArrayList<String[]>();
        ArrayList<String[]> choices = new ArrayList<String[]>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        ArrayList functions = (ArrayList)control.getObject("functions");
        for (Object next : functions) {
            String[] function = (String[])next;
            originals.add(function);
            choices.add(function);
            names.add(function[0]);
            expressions.add(function[1]);
        }
        boolean[] selected = new boolean[choices.size()];
        boolean bl = false;
        while (var11_12 < selected.length) {
            selected[var11_12] = true;
            ++var11_12;
        }
        if (listChooser.choose(choices, names, expressions, selected)) {
            for (Object e : originals) {
                if (choices.contains(e)) continue;
                functions.remove(e);
            }
            control.setValue("functions", functions);
            return true;
        }
        return false;
    }
}

