/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

public abstract class IntervalData {
    private double mLeft;
    private double mRight;

    protected IntervalData(double left, double right) {
        this.mLeft = left;
        this.mRight = right;
    }

    public final double getLeft() {
        return this.mLeft;
    }

    public final double getRight() {
        return this.mRight;
    }

    public final void setRight(double right) {
        this.mRight = right;
    }

    public abstract double interpolate(double var1, int var3);

    public final double[] interpolate(double time, double[] state) {
        int timeIndex = state.length - 1;
        this.interpolate(time, state, 0, timeIndex);
        state[timeIndex] = time;
        return state;
    }

    public abstract double[] interpolate(double var1, double[] var3, int var4, int var5);

    public String toString() {
        return "[" + this.mLeft + ", " + this.mRight + ")";
    }
}

