/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.text.DecimalFormat;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.numerics.SuryonoParser;

public final class Util {
    public static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    public static final double LOG10 = Math.log(10.0);
    public static final double defaultNumericalPrecision = Math.sqrt(Double.MIN_VALUE);
    private static SuryonoParser parser = new SuryonoParser(0);
    static DecimalFormat format2 = new DecimalFormat("#0.00");
    static DecimalFormat format3 = new DecimalFormat("#0.000");
    static DecimalFormat format4 = new DecimalFormat("#0.0000");
    static DecimalFormat format_E2 = new DecimalFormat("0.00E0");
    static DecimalFormat format_E3 = new DecimalFormat("0.000E0");
    static DecimalFormat format_E4 = new DecimalFormat("0.0000E0");

    private Util() {
    }

    public static String f2(double d) {
        return format2.format(d);
    }

    public static String f3(double d) {
        return format3.format(d);
    }

    public static String f4(double d) {
        return format4.format(d);
    }

    public static double relativePrecision(double epsilon, double result) {
        return result > defaultNumericalPrecision ? epsilon / result : epsilon;
    }

    public static int checkSorting(double[] array) {
        int sign = array[0] <= array[array.length - 1] ? 1 : -1;
        int i = 1;
        int n = array.length;
        while (i < n) {
            switch (sign) {
                case -1: {
                    if (!(array[i - 1] < array[i])) break;
                    return 0;
                }
                case 1: {
                    if (!(array[i - 1] > array[i])) break;
                    return 0;
                }
            }
            ++i;
        }
        return sign;
    }

    public static double[] getRange(Function f, double a, double b, int n) {
        double min = f.evaluate(a);
        double max = f.evaluate(a);
        double x = a;
        double dx = (b - a) / (double)(n - 1);
        int i = 1;
        while (i < n) {
            double y = f.evaluate(x);
            min = Math.min(min, y);
            max = Math.max(max, y);
            x += dx;
            ++i;
        }
        return new double[]{min, max};
    }

    public static double[][] functionFill(Function f, double start, double stop, double[][] data) {
        double dx = 1.0;
        int n = data[0].length;
        if (n > 1) {
            dx = (stop - start) / (double)(n - 1);
        }
        double x = start;
        int i = 0;
        while (i < n) {
            data[0][i] = x;
            data[1][i] = f.evaluate(x);
            x += dx;
            ++i;
        }
        return data;
    }

    public static double[] functionFill(Function f, double start, double stop, double[] data) {
        double dx = 1.0;
        int n = data.length;
        if (n > 1) {
            dx = (stop - start) / (double)(n - 1);
        }
        double x = start;
        int i = 0;
        while (i < n) {
            data[i] = f.evaluate(x);
            x += dx;
            ++i;
        }
        return data;
    }

    public static double computeAverage(double[] array, int start, int num) {
        double sum = 0.0;
        int i = start;
        int stop = start + num;
        while (i < stop) {
            sum += array[i];
            ++i;
        }
        return sum / (double)num;
    }

    public static Function constantFunction(final double c) {
        return new Function(){

            @Override
            public double evaluate(double x) {
                return c;
            }
        };
    }

    public static Function linearFunction(final double m, final double b) {
        return new Function(){

            @Override
            public double evaluate(double x) {
                return m * x + b;
            }
        };
    }

    public static Function gaussian(final double x0, final double sigma) {
        final double s2 = 2.0 * sigma * sigma;
        return new Function(){

            @Override
            public double evaluate(double x) {
                return Math.exp(-(x - x0) * (x - x0) / s2) / sigma / SQRT2PI;
            }
        };
    }

    public static synchronized double evalMath(String str) {
        try {
            parser.parse(str);
            return parser.evaluate();
        }
        catch (ParserException parserException) {
            return Double.NaN;
        }
    }
}

