/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.xuggle.XuggleVideoType;
import org.opensourcephysics.tools.ResourceLoader;

public class XuggleVideoRecorder
extends ScratchVideoRecorder {
    private IContainer outContainer;
    private IStream outStream;
    private IStreamCoder outStreamCoder;
    private IConverter outConverter;
    private Dimension converterDim;

    public XuggleVideoRecorder(XuggleVideoType type) {
        super(type);
    }

    @Override
    public void reset() {
        try {
            this.closeStream();
        }
        catch (IOException iOException) {}
        if (this.outConverter != null) {
            this.outConverter.delete();
            this.outConverter = null;
        }
        this.deleteTempFiles();
        super.reset();
        this.scratchFile = null;
    }

    @Override
    protected void finalize() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean append(Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (this.dim == null || !this.hasContent && (this.dim.width != w || this.dim.height != h)) {
            this.dim = new Dimension(w, h);
        }
        if (this.dim.width != w || this.dim.height != h || !(image instanceof BufferedImage)) {
            BufferedImage img = new BufferedImage(this.dim.width, this.dim.height, 1);
            int x = (this.dim.width - w) / 2;
            int y = (this.dim.height - h) / 2;
            img.getGraphics().drawImage(image, x, y, null);
            image = img;
        }
        BufferedImage source = (BufferedImage)image;
        String fileName = String.valueOf(this.tempFileBasePath) + "_" + this.tempFiles.size() + ".tmp";
        try {
            ImageIO.write((RenderedImage)source, this.tempFileType, new BufferedOutputStream(new FileOutputStream(fileName)));
        }
        catch (Exception exception) {
            return false;
        }
        File imageFile = new File(fileName);
        if (imageFile.exists()) {
            ArrayList arrayList = this.tempFiles;
            synchronized (arrayList) {
                this.tempFiles.add(imageFile);
            }
            imageFile.deleteOnExit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveScratch() throws IOException {
        VideoFileFilter fileFilter = this.videoType.getDefaultFileFilter();
        if (!this.hasContent || !(fileFilter instanceof VideoFileFilter)) {
            return;
        }
        IContainerFormat format = IContainerFormat.make();
        VideoFileFilter xuggleFilter = fileFilter;
        format.setOutputFormat(xuggleFilter.getContainerType(), null, null);
        IPixelFormat.Type pixelType = IPixelFormat.Type.YUV420P;
        this.openStream(format, pixelType);
        long timeStamp = 0L;
        int n = 0;
        ArrayList arrayList = this.tempFiles;
        synchronized (arrayList) {
            for (File imageFile : this.tempFiles) {
                if (!imageFile.exists()) {
                    throw new IOException("temp image file not found");
                }
                BufferedImage image = ResourceLoader.getBufferedImage(imageFile.getAbsolutePath(), 5);
                if (image == null || image.getType() != 5) {
                    throw new IOException("unable to load temp image file");
                }
                this.encodeImage(image, pixelType, timeStamp);
                timeStamp = Math.round((double)(++n) * this.frameDuration * 1000.0);
            }
        }
        this.closeStream();
        this.deleteTempFiles();
        this.hasContent = false;
        this.canRecord = false;
    }

    @Override
    protected boolean startRecording() {
        try {
            this.tempFileBasePath = XML.stripExtension(this.scratchFile.getAbsolutePath());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean openStream(IContainerFormat format, IPixelFormat.Type pixelType) throws IOException {
        this.outContainer = IContainer.make();
        if (this.outContainer.open(this.scratchFile.getAbsolutePath(), IContainer.Type.WRITE, format) < 0) {
            OSPLog.finer("Xuggle could not open output file");
            return false;
        }
        String typicalName = "typical." + this.videoType.getDefaultExtension();
        ICodec codec = ICodec.guessEncodingCodec(format, null, typicalName, null, ICodec.Type.CODEC_TYPE_VIDEO);
        this.outStream = this.outContainer.addNewStream(0);
        this.outStreamCoder = this.outStream.getStreamCoder();
        this.outStreamCoder.setNumPicturesInGroupOfPictures(30);
        this.outStreamCoder.setCodec(codec);
        this.outStreamCoder.setBitRate(25000);
        this.outStreamCoder.setBitRateTolerance(9000);
        this.outStreamCoder.setPixelType(pixelType);
        if (this.dim == null && this.frameImage != null) {
            this.dim = new Dimension(this.frameImage.getWidth(null), this.frameImage.getHeight(null));
        }
        if (this.dim != null) {
            this.outStreamCoder.setHeight(this.dim.height);
            this.outStreamCoder.setWidth(this.dim.width);
        }
        this.outStreamCoder.setFlag(IStreamCoder.Flags.FLAG_QSCALE, true);
        this.outStreamCoder.setGlobalQuality(0);
        IRational frameRate = IRational.make(1000.0 / this.frameDuration);
        if (typicalName.endsWith(".avi") && frameRate.getDenominator() > 65535) {
            double fps = 1000.0 / this.frameDuration;
            int denom = 9000;
            int numer = Math.round(Math.round(fps * (double)denom));
            frameRate = IRational.make(numer, denom);
        }
        this.outStreamCoder.setFrameRate(frameRate);
        this.outStreamCoder.setTimeBase(IRational.make(frameRate.getDenominator(), frameRate.getNumerator()));
        if (this.outStreamCoder.open() < 0) {
            OSPLog.finer("Xuggle could not open stream encoder");
            return false;
        }
        if (this.outContainer.writeHeader() < 0) {
            OSPLog.finer("Xuggle could not write file header");
            return false;
        }
        return true;
    }

    private boolean encodeImage(BufferedImage image, IPixelFormat.Type pixelType, long timeStamp) throws IOException {
        IVideoPicture picture = this.getPicture(image, pixelType, timeStamp);
        if (picture == null) {
            throw new RuntimeException("could not convert to picture");
        }
        IPacket packet = IPacket.make();
        if (this.outStreamCoder.encodeVideo(packet, picture, 0) < 0) {
            throw new RuntimeException("could not encode video");
        }
        if (packet.isComplete()) {
            if (this.outContainer.writePacket(packet) < 0) {
                throw new RuntimeException("could not save packet to container");
            }
            return true;
        }
        return false;
    }

    private void closeStream() throws IOException {
        if (this.outContainer != null) {
            if (this.outContainer.writeTrailer() < 0) {
                throw new RuntimeException("could not write trailer to output file");
            }
            this.outStreamCoder.close();
            this.outStreamCoder.delete();
            this.outStream.delete();
            this.outContainer.close();
            this.outContainer.delete();
            this.outContainer = null;
            this.outStreamCoder = null;
            this.outStream = null;
        }
    }

    private IVideoPicture getPicture(BufferedImage bgrImage, IPixelFormat.Type pixelType, long timeStamp) {
        IVideoPicture picture = null;
        try {
            IConverter converter = this.getConverter(bgrImage, pixelType);
            picture = converter.toPicture(bgrImage, timeStamp);
            picture.setQuality(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error err) {
            err.printStackTrace();
        }
        return picture;
    }

    private IConverter getConverter(BufferedImage bgrImage, IPixelFormat.Type pixelType) {
        int w = bgrImage.getWidth();
        int h = bgrImage.getHeight();
        if (this.converterDim == null) {
            this.converterDim = new Dimension(w, h);
        }
        if (this.outConverter == null || w != this.converterDim.width || h != this.converterDim.height || this.outConverter.getPictureType() != pixelType) {
            try {
                this.outConverter = ConverterFactory.createConverter(bgrImage, pixelType);
                this.converterDim = new Dimension(w, h);
            }
            catch (UnsupportedOperationException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        return this.outConverter;
    }

    public static void getSupportedCodecs(String name) {
        IContainerFormat format = IContainerFormat.make();
        format.setOutputFormat(name, null, null);
        List<ICodec.ID> codecs = format.getOutputCodecsSupported();
        if (codecs.isEmpty()) {
            System.out.println("no supported codecs for " + name);
        } else {
            System.out.println(String.valueOf(name) + " (" + format + ") supports following codecs:");
            for (ICodec.ID id : codecs) {
                ICodec codec;
                if (id == null || (codec = ICodec.findEncodingCodec(id)) == null) continue;
                System.out.println(codec);
            }
        }
    }
}

