/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class XuggleVideo
extends VideoAdapter {
    IContainer container;
    int streamIndex = -1;
    IStreamCoder videoCoder;
    IVideoResampler resampler;
    IPacket packet;
    IVideoPicture picture;
    IStream stream;
    IRational timebase;
    IConverter converter;
    Map<Integer, Long> frameTimeStamps = new HashMap<Integer, Long>();
    Map<Integer, Long> keyTimeStamps = new HashMap<Integer, Long>();
    private double[] startTimes;
    private long systemStartPlayTime;
    private double frameStartPlayTime;
    private boolean playSmoothly = true;
    private int frame;
    private int prevFrame;
    private Timer failDetectTimer;

    public XuggleVideo(final String fileName) throws IOException {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        int n = frames.length;
        while (i < n) {
            if (frames[i].getName().equals("Tracker")) {
                this.addPropertyChangeListener("progress", (PropertyChangeListener)((Object)frames[i]));
                this.addPropertyChangeListener("stalled", (PropertyChangeListener)((Object)frames[i]));
                break;
            }
            ++i;
        }
        this.failDetectTimer = new Timer(6000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XuggleVideo.this.frame == XuggleVideo.this.prevFrame) {
                    XuggleVideo.this.firePropertyChange("stalled", null, fileName);
                    XuggleVideo.this.failDetectTimer.stop();
                }
                XuggleVideo.this.prevFrame = XuggleVideo.this.frame;
            }
        });
        this.failDetectTimer.setRepeats(true);
        this.load(fileName);
    }

    @Override
    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        int n = this.getFrameNumber() + 1;
        this.playing = true;
        this.support.firePropertyChange("playing", null, new Boolean(true));
        this.startPlayingAtFrame(n);
    }

    @Override
    public void stop() {
        this.playing = false;
        this.support.firePropertyChange("playing", null, new Boolean(false));
    }

    @Override
    public void setFrameNumber(int n) {
        if (n == this.getFrameNumber()) {
            return;
        }
        super.setFrameNumber(n);
        BufferedImage bi = this.getImage(this.getFrameNumber());
        if (bi != null) {
            this.rawImage = bi;
            this.isValidImage = false;
            this.isValidFilteredImage = false;
            this.firePropertyChange("framenumber", null, new Integer(this.getFrameNumber()));
            if (this.isPlaying()) {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        XuggleVideo.this.continuePlaying();
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        }
    }

    @Override
    public double getFrameTime(int n) {
        if (n >= this.startTimes.length || n < 0) {
            return -1.0;
        }
        return this.startTimes[n];
    }

    @Override
    public double getTime() {
        return this.getFrameTime(this.getFrameNumber());
    }

    @Override
    public void setTime(double millis) {
        millis = Math.abs(millis);
        int i = 0;
        while (i < this.startTimes.length) {
            double t = this.startTimes[i];
            if (millis < t) {
                this.setFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public double getStartTime() {
        return this.getFrameTime(this.getStartFrameNumber());
    }

    @Override
    public void setStartTime(double millis) {
        millis = Math.abs(millis);
        int i = 0;
        while (i < this.startTimes.length) {
            double t = this.startTimes[i];
            if (millis < t) {
                this.setStartFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public double getEndTime() {
        int n = this.getEndFrameNumber();
        if (n < this.getFrameCount() - 1) {
            return this.getFrameTime(n + 1);
        }
        return this.getDuration();
    }

    @Override
    public void setEndTime(double millis) {
        millis = Math.abs(millis);
        millis = Math.min(this.getDuration(), millis);
        int i = 0;
        while (i < this.startTimes.length) {
            double t = this.startTimes[i];
            if (millis < t) {
                this.setEndFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public double getDuration() {
        int n = this.getFrameCount() - 1;
        if (n == 0) {
            return 100.0;
        }
        double delta = this.getFrameTime(n) - this.getFrameTime(n - 1);
        return this.getFrameTime(n) + delta;
    }

    @Override
    public void setRate(double rate) {
        super.setRate(rate);
        if (this.isPlaying()) {
            this.startPlayingAtFrame(this.getFrameNumber());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.videoCoder != null) {
            this.videoCoder.close();
            this.videoCoder.delete();
            this.videoCoder = null;
        }
        if (this.stream != null) {
            this.stream.delete();
            this.stream = null;
        }
        if (this.picture != null) {
            this.picture.delete();
            this.picture = null;
            this.packet.delete();
            this.packet = null;
        }
        if (this.container != null) {
            this.container.close();
            this.container.delete();
            this.container = null;
        }
    }

    public void setSmoothPlay(boolean smooth) {
        this.playSmoothly = smooth;
    }

    public boolean isSmoothPlay() {
        return this.playSmoothly;
    }

    @Override
    protected void finalize() {
    }

    private void startPlayingAtFrame(int frameNumber) {
        this.systemStartPlayTime = System.currentTimeMillis();
        this.frameStartPlayTime = this.getFrameTime(frameNumber);
        this.setFrameNumber(frameNumber);
    }

    private void continuePlaying() {
        int n = this.getFrameNumber();
        if (n < this.getEndFrameNumber()) {
            long elapsedTime = System.currentTimeMillis() - this.systemStartPlayTime;
            double frameTime = this.frameStartPlayTime + this.getRate() * (double)elapsedTime;
            int frameToPlay = this.getFrameNumberBefore(frameTime);
            while (frameToPlay > -1 && frameToPlay <= n) {
                elapsedTime = System.currentTimeMillis() - this.systemStartPlayTime;
                frameTime = this.frameStartPlayTime + this.getRate() * (double)elapsedTime;
                frameToPlay = this.getFrameNumberBefore(frameTime);
            }
            if (frameToPlay == -1) {
                frameToPlay = this.getEndFrameNumber();
            }
            this.setFrameNumber(frameToPlay);
        } else if (this.looping) {
            this.startPlayingAtFrame(this.getStartFrameNumber());
        } else {
            this.stop();
        }
    }

    private int getFrameNumberBefore(double time) {
        int i = 0;
        while (i < this.startTimes.length) {
            if (time < this.startTimes[i]) {
                return i - 1;
            }
            ++i;
        }
        int n = this.startTimes.length - 1;
        double endTime = 2.0 * this.startTimes[n] - this.startTimes[n - 1];
        if (time < endTime) {
            return n;
        }
        return -1;
    }

    private void load(String fileName) throws IOException {
        Resource res = ResourceLoader.getResource(fileName);
        if (res == null) {
            throw new IOException("unable to create resource for " + fileName);
        }
        URL url = res.getURL();
        boolean isLocal = url.getProtocol().toLowerCase().indexOf("file") > -1;
        String path = isLocal ? res.getAbsolutePath() : url.toExternalForm();
        OSPLog.finest("Xuggle video loading " + path + " local?: " + isLocal);
        this.container = IContainer.make();
        if (isLocal) {
            RandomAccessFile raf = new RandomAccessFile(path, "r");
            if (this.container.open(raf, IContainer.Type.READ, null) < 0) {
                this.dispose();
                throw new IOException("unable to open " + fileName);
            }
        } else if (this.container.open(path, IContainer.Type.READ, null) < 0) {
            this.dispose();
            throw new IOException("unable to open " + fileName);
        }
        int i = 0;
        while (i < this.container.getNumStreams()) {
            IStream nextStream = this.container.getStream(i);
            IStreamCoder coder = nextStream.getStreamCoder();
            if (coder.getCodecType().equals((Object)ICodec.Type.CODEC_TYPE_VIDEO)) {
                this.stream = nextStream;
                this.streamIndex = i;
                this.videoCoder = coder;
                this.timebase = this.stream.getTimeBase().copy();
                break;
            }
            ++i;
        }
        if (this.streamIndex == -1) {
            this.dispose();
            throw new IOException("no video stream found in " + fileName);
        }
        if (this.videoCoder.open() < 0) {
            this.dispose();
            throw new IOException("unable to open video decoder for " + fileName);
        }
        this.setProperty("name", XML.getName(fileName));
        if (fileName.indexOf(":") == -1) {
            this.setProperty("path", XML.forwardSlash(fileName));
            this.setProperty("absolutePath", res.getAbsolutePath());
        } else {
            this.setProperty("path", XML.getRelativePath(fileName));
            this.setProperty("absolutePath", fileName);
        }
        IContainer tempContainer = IContainer.make();
        if (isLocal) {
            RandomAccessFile tempRaf = new RandomAccessFile(path, "r");
            tempContainer.open(tempRaf, IContainer.Type.READ, null);
        } else {
            tempContainer.open(this.container.getURL(), IContainer.Type.READ, null);
        }
        IStream tempStream = tempContainer.getStream(this.streamIndex);
        IStreamCoder tempCoder = tempStream.getStreamCoder();
        tempCoder.open();
        IVideoPicture tempPicture = IVideoPicture.make(tempCoder.getPixelType(), tempCoder.getWidth(), tempCoder.getHeight());
        IPacket tempPacket = IPacket.make();
        long keyTimeStamp = Long.MIN_VALUE;
        long startTimeStamp = Long.MIN_VALUE;
        ArrayList<Double> seconds = new ArrayList<Double>();
        this.firePropertyChange("progress", fileName, 0);
        this.prevFrame = 0;
        this.frame = 0;
        this.failDetectTimer.start();
        block1: while (tempContainer.readNextPacket(tempPacket) >= 0) {
            if (VideoIO.isCanceled()) {
                this.failDetectTimer.stop();
                this.firePropertyChange("progress", fileName, null);
                tempCoder.close();
                tempCoder.delete();
                tempStream.delete();
                tempPicture.delete();
                tempPacket.delete();
                tempContainer.close();
                tempContainer.delete();
                this.dispose();
                throw new IOException("Canceled by user");
            }
            if (!this.isVideoPacket(tempPacket)) continue;
            if (keyTimeStamp == Long.MIN_VALUE || tempPacket.isKeyPacket()) {
                keyTimeStamp = tempPacket.getTimeStamp();
            }
            int offset = 0;
            while (offset < tempPacket.getSize()) {
                int bytesDecoded = tempCoder.decodeVideo(tempPicture, tempPacket, offset);
                if (bytesDecoded < 0) continue block1;
                offset += bytesDecoded;
                if (!tempPicture.isComplete()) continue;
                if (startTimeStamp == Long.MIN_VALUE) {
                    startTimeStamp = tempPacket.getTimeStamp();
                }
                this.frameTimeStamps.put(this.frame, tempPacket.getTimeStamp());
                seconds.add((double)(tempPacket.getTimeStamp() - startTimeStamp) * this.timebase.getValue());
                this.keyTimeStamps.put(this.frame, keyTimeStamp);
                this.firePropertyChange("progress", fileName, this.frame);
                ++this.frame;
            }
        }
        tempCoder.close();
        tempCoder.delete();
        tempStream.delete();
        tempPicture.delete();
        tempPacket.delete();
        tempContainer.close();
        tempContainer.delete();
        if (this.frameTimeStamps.size() == 0) {
            this.firePropertyChange("progress", fileName, null);
            this.failDetectTimer.stop();
            this.dispose();
            throw new IOException("packets loaded but no complete picture");
        }
        this.frameCount = this.frameTimeStamps.size();
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        this.startTimes = new double[this.frameCount];
        this.startTimes[0] = 0.0;
        int i2 = 1;
        while (i2 < this.startTimes.length) {
            this.startTimes[i2] = (Double)seconds.get(i2) * 1000.0;
            ++i2;
        }
        this.picture = IVideoPicture.make(this.videoCoder.getPixelType(), this.videoCoder.getWidth(), this.videoCoder.getHeight());
        this.packet = IPacket.make();
        this.loadNextPacket();
        BufferedImage img = this.getImage(0);
        if (img == null) {
            int i3 = 1;
            while (i3 < this.frameTimeStamps.size()) {
                img = this.getImage(i3);
                if (img != null) break;
                ++i3;
            }
        }
        this.firePropertyChange("progress", fileName, null);
        this.failDetectTimer.stop();
        if (img == null) {
            this.dispose();
            throw new IOException("No images");
        }
        this.setImage(img);
    }

    private void reload() throws IOException {
        String url = this.container.getURL();
        this.container.close();
        this.videoCoder.close();
        this.videoCoder.delete();
        this.stream.delete();
        boolean isLocal = url.toLowerCase().indexOf("file:") > -1;
        String path = isLocal ? ResourceLoader.getNonURIPath(url) : url;
        this.container = IContainer.make();
        if (isLocal) {
            RandomAccessFile raf = new RandomAccessFile(path, "r");
            this.container.open(raf, IContainer.Type.READ, null);
        } else {
            this.container.open(path, IContainer.Type.READ, null);
        }
        this.stream = this.container.getStream(this.streamIndex);
        this.videoCoder = this.stream.getStreamCoder();
        this.videoCoder.open();
    }

    private void setImage(BufferedImage image) {
        this.rawImage = image;
        this.size = new Dimension(image.getWidth(), image.getHeight());
        this.refreshBufferedImage();
        this.coords = new ImageCoordSystem(this.frameCount);
        this.coords.addPropertyChangeListener(this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private boolean isKeyPacket(IPacket packet) {
        return this.isVideoPacket(packet) && packet.isKeyPacket();
    }

    private boolean isVideoPacket(IPacket packet) {
        return packet.getStreamIndex() == this.streamIndex;
    }

    private IPacket getKeyPacket(long timestamp) {
        long delta = timestamp - this.packet.getTimeStamp();
        if (delta == 0L) {
            return this.packet;
        }
        IRational timebase = this.packet.getTimeBase();
        int shortTime = timebase.getDenominator();
        if (delta > 0L && delta < (long)shortTime) {
            while (this.container.readNextPacket(this.packet) >= 0) {
                if (this.isKeyPacket(this.packet) && this.packet.getTimeStamp() == timestamp) {
                    return this.packet;
                }
                if (!this.isVideoPacket(this.packet) || this.packet.getTimeStamp() <= timestamp) continue;
                delta = timestamp - this.packet.getTimeStamp();
                break;
            }
        }
        if (delta > 0L && this.container.seekKeyFrame(this.streamIndex, timestamp, timestamp, timestamp, 0) >= 0) {
            while (this.container.readNextPacket(this.packet) >= 0) {
                if (this.isKeyPacket(this.packet) && this.packet.getTimeStamp() == timestamp) {
                    return this.packet;
                }
                if (!this.isVideoPacket(this.packet) || this.packet.getTimeStamp() <= timestamp) continue;
                delta = timestamp - this.packet.getTimeStamp();
                break;
            }
        }
        if (this.getFrameNumber(timestamp) == 0) {
            this.resetContainer();
            return this.packet;
        }
        if (delta < 0L && this.container.seekKeyFrame(this.streamIndex, timestamp, timestamp, timestamp, IContainer.SEEK_FLAG_BACKWARDS) >= 0) {
            while (this.container.readNextPacket(this.packet) >= 0) {
                if (this.isKeyPacket(this.packet) && this.isVideoPacket(this.packet) && this.packet.getTimeStamp() == timestamp) {
                    return this.packet;
                }
                if (!this.isVideoPacket(this.packet) || this.packet.getTimeStamp() <= timestamp) continue;
                delta = timestamp - this.packet.getTimeStamp();
                break;
            }
        }
        this.resetContainer();
        while (this.container.readNextPacket(this.packet) >= 0) {
            if (this.isKeyPacket(this.packet) && this.packet.getTimeStamp() == timestamp) {
                return this.packet;
            }
            if (this.isVideoPacket(this.packet) && this.packet.getTimeStamp() > timestamp) break;
        }
        return null;
    }

    private IPacket getKeyPacketForFrame(int frameNumber) {
        long keyTimeStamp = this.keyTimeStamps.get(frameNumber);
        return this.getKeyPacket(keyTimeStamp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadPicture(int frameNumber) {
        long currentTS = this.packet.getTimeStamp();
        long targetTS = this.getTimeStamp(frameNumber);
        long keyTS = this.keyTimeStamps.get(frameNumber);
        if (currentTS == targetTS && this.isVideoPacket(this.packet)) {
            return this.picture.isComplete();
        }
        if (currentTS >= keyTS && currentTS < targetTS) {
            if (!this.loadNextPacket()) return false;
            int n = this.getFrameNumber(this.packet);
            while (n > -2 && n < frameNumber) {
                if (!this.loadNextPacket()) return false;
                n = this.getFrameNumber(this.packet);
            }
            return this.picture.isComplete();
        } else {
            if (this.getKeyPacketForFrame(frameNumber) == null) return this.picture.isComplete();
            if (!this.loadPacket(this.packet)) return false;
            int n = this.getFrameNumber(this.packet);
            while (n > -2 && n < frameNumber) {
                if (!this.loadNextPacket()) return false;
                n = this.getFrameNumber(this.packet);
            }
        }
        return this.picture.isComplete();
    }

    private long getTimeStamp(int frameNumber) {
        return this.frameTimeStamps.get(frameNumber);
    }

    private int getFrameNumber(long timeStamp) {
        int i = 0;
        while (i < this.frameTimeStamps.size()) {
            long ts = this.frameTimeStamps.get(i);
            if (ts == timeStamp) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getFrameNumber(IPacket packet) {
        if (packet.getStreamIndex() != this.streamIndex) {
            return -2;
        }
        return this.getFrameNumber(packet.getTimeStamp());
    }

    private BufferedImage getImage(int frameNumber) {
        if (frameNumber < 0 || frameNumber >= this.frameTimeStamps.size()) {
            return null;
        }
        if (this.loadPicture(frameNumber)) {
            return this.getBufferedImage(this.picture);
        }
        return null;
    }

    private BufferedImage getBufferedImage(IVideoPicture picture) {
        if (picture.getPixelType() != IPixelFormat.Type.BGR24) {
            IVideoPicture newPic;
            if (this.resampler == null) {
                this.resampler = IVideoResampler.make(picture.getWidth(), picture.getHeight(), IPixelFormat.Type.BGR24, picture.getWidth(), picture.getHeight(), picture.getPixelType());
                if (this.resampler == null) {
                    OSPLog.warning("Could not create color space resampler");
                    return null;
                }
            }
            if (this.resampler.resample(newPic = IVideoPicture.make(this.resampler.getOutputPixelFormat(), picture.getWidth(), picture.getHeight()), picture) < 0 || newPic.getPixelType() != IPixelFormat.Type.BGR24) {
                OSPLog.warning("Could not encode video as BGR24");
                return null;
            }
            picture = newPic;
        }
        if (this.converter == null) {
            ConverterFactory.Type type = ConverterFactory.findRegisteredConverter("XUGGLER-BGR-24");
            this.converter = ConverterFactory.createConverter(type.getDescriptor(), picture);
        }
        BufferedImage image = this.converter.toImage(picture);
        if (this.playSmoothly) {
            System.gc();
        }
        return image;
    }

    private boolean loadNextPacket() {
        while (this.container.readNextPacket(this.packet) >= 0) {
            if (!this.isVideoPacket(this.packet)) continue;
            return this.loadPacket(this.packet);
        }
        return false;
    }

    private boolean loadPacket(IPacket packet) {
        int bytesDecoded;
        int size = packet.getSize();
        for (int offset = 0; offset < size; offset += bytesDecoded) {
            bytesDecoded = this.videoCoder.decodeVideo(this.picture, packet, offset);
            if (bytesDecoded >= 0) continue;
            return false;
        }
        return true;
    }

    private void resetContainer() {
        if (this.container.seekKeyFrame(-1, Long.MIN_VALUE, 0L, Long.MAX_VALUE, IContainer.SEEK_FLAG_BACKWARDS) >= 0) {
            this.loadNextPacket();
        } else {
            try {
                this.reload();
                this.loadNextPacket();
            }
            catch (IOException iOException) {
                OSPLog.warning("Container could not be reset");
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            XuggleVideo video2 = (XuggleVideo)obj;
            String base = (String)video2.getProperty("base");
            String absPath = (String)video2.getProperty("absolutePath");
            control.setValue("path", XML.getPathRelativeTo(absPath, base));
            if (!video2.getFilterStack().isEmpty()) {
                control.setValue("filters", video2.getFilterStack().getFilters());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            try {
                String path = control.getString("path");
                String ext = XML.getExtension(path);
                XuggleVideo video2 = new XuggleVideo(path);
                VideoType xuggleType = VideoIO.getVideoType("xuggle", ext);
                if (xuggleType != null) {
                    video2.setProperty("video_type", xuggleType);
                }
                return video2;
            }
            catch (IOException ex) {
                OSPLog.fine(ex.getMessage());
                return null;
            }
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            XuggleVideo video2 = (XuggleVideo)obj;
            Collection filters = (Collection)control.getObject("filters");
            if (filters != null) {
                video2.getFilterStack().clear();
                for (Filter filter : filters) {
                    video2.getFilterStack().addFilter(filter);
                }
            }
            return obj;
        }
    }
}

