/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaToolAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ResourceLoader;

public class XuggleThumbnailTool
extends MediaToolAdapter {
    private static final XuggleThumbnailTool THUMBNAIL_TOOL = new XuggleThumbnailTool();
    private static final int TARGET_FRAME_NUMBER = 15;
    private BufferedImage thumbnail;
    private Graphics2D g;
    private boolean finished;
    private int frameNumber;
    private BufferedImage overlay;
    private Dimension dim;

    public static void start() {
    }

    public static synchronized BufferedImage createThumbnailImage(Dimension dim, String pathToVideo) {
        THUMBNAIL_TOOL.initialize(dim);
        String path = pathToVideo.startsWith("http:") ? ResourceLoader.getURIPath(pathToVideo) : pathToVideo;
        IMediaReader mediaReader = ToolFactory.makeReader(path);
        mediaReader.setBufferedImageTypeToGenerate(5);
        mediaReader.addListener(THUMBNAIL_TOOL);
        while (!THUMBNAIL_TOOL.isFinished() && mediaReader.readPacket() == null) {
        }
        mediaReader.close();
        return XuggleThumbnailTool.THUMBNAIL_TOOL.thumbnail;
    }

    public static synchronized File createThumbnailFile(Dimension dim, String pathToVideo, String pathToThumbnail) {
        BufferedImage thumb = XuggleThumbnailTool.createThumbnailImage(dim, pathToVideo);
        return VideoIO.writeImageFile(thumb, pathToThumbnail);
    }

    @Override
    public void onVideoPicture(IVideoPictureEvent event) {
        if (!this.isFinished()) {
            BufferedImage image = event.getImage();
            double widthFactor = this.dim.getWidth() / (double)image.getWidth();
            double heightFactor = this.dim.getHeight() / (double)image.getHeight();
            double factor = Math.min(widthFactor, heightFactor);
            int w = (int)((double)image.getWidth() * factor);
            int h = (int)((double)image.getHeight() * factor);
            this.thumbnail = new BufferedImage(w, h, 5);
            this.g = this.thumbnail.createGraphics();
            AffineTransform transform = AffineTransform.getScaleInstance(factor, factor);
            this.g.setTransform(transform);
            this.g.drawImage((Image)image, 0, 0, null);
            if (this.overlay != null) {
                this.g.scale(1.0 / factor, 1.0 / factor);
                Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, this.overlay.getWidth(), this.overlay.getHeight());
                double ht = ((RectangularShape)bounds).getHeight();
                this.g.translate(0.5 * ht, (double)this.thumbnail.getHeight() - 1.5 * ht);
                this.g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                this.g.drawImage((Image)this.overlay, 0, 0, null);
            }
            ++this.frameNumber;
            this.finished = this.frameNumber >= 15;
        }
        super.onVideoPicture(event);
    }

    private void initialize(Dimension dimension) {
        this.dim = dimension;
        this.finished = false;
        this.frameNumber = 0;
    }

    private boolean isFinished() {
        return this.finished;
    }
}

