/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Timer;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifDecoder;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class GifVideo
extends VideoAdapter {
    protected GifDecoder decoder;
    protected int[] startTimes;
    private Timer timer;
    private HashSet<DrawingPanel> panels = new HashSet();

    public GifVideo(String gifName) throws IOException {
        this.load(gifName);
        this.createTimer();
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        this.panels.add(panel);
        super.draw(panel, g);
    }

    @Override
    protected void finalize() {
    }

    @Override
    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        if (!this.timer.isRunning()) {
            if (this.getFrameNumber() >= this.getEndFrameNumber()) {
                this.setFrameNumber(this.getStartFrameNumber());
            }
            this.timer.restart();
            this.support.firePropertyChange("playing", null, new Boolean(true));
        }
    }

    @Override
    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.support.firePropertyChange("playing", null, new Boolean(false));
        }
    }

    @Override
    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        n = this.getFrameNumber();
        int index = Math.min(n, this.decoder.getFrameCount() - 1);
        this.rawImage = this.decoder.getFrame(index);
        this.isValidImage = false;
        this.isValidFilteredImage = false;
        this.support.firePropertyChange("framenumber", null, new Integer(n));
        for (DrawingPanel panel : this.panels) {
            panel.repaint();
        }
    }

    @Override
    public double getFrameTime(int n) {
        if (n >= this.startTimes.length || n < 0) {
            return -1.0;
        }
        return this.startTimes[n];
    }

    @Override
    public double getTime() {
        return this.getFrameTime(this.getFrameNumber());
    }

    @Override
    public void setTime(double millis) {
        millis = Math.abs(millis);
        int i = 0;
        while (i < this.startTimes.length) {
            int t = this.startTimes[i];
            if (millis < (double)t) {
                this.setFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public double getStartTime() {
        return this.getFrameTime(this.getStartFrameNumber());
    }

    @Override
    public void setStartTime(double millis) {
        millis = Math.abs(millis);
        int i = 0;
        while (i < this.startTimes.length) {
            int t = this.startTimes[i];
            if (millis < (double)t) {
                this.setStartFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public double getEndTime() {
        int n = this.getEndFrameNumber();
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    @Override
    public void setEndTime(double millis) {
        millis = Math.abs(millis);
        millis = Math.min(this.getDuration(), millis);
        int i = 0;
        while (i < this.startTimes.length) {
            int t = this.startTimes[i];
            if (millis < (double)t) {
                this.setEndFrameNumber(i - 1);
                break;
            }
            ++i;
        }
    }

    @Override
    public double getDuration() {
        int n = this.getFrameCount() - 1;
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    protected void load(String gifName) throws IOException {
        this.decoder = new GifDecoder();
        int status = this.decoder.read(gifName);
        if (status == 2) {
            throw new IOException("Gif " + gifName + " not found");
        }
        if (status == 1) {
            throw new IOException("File format error");
        }
        this.setProperty("name", gifName);
        if (gifName.indexOf(":") == -1) {
            this.setProperty("path", XML.forwardSlash(gifName));
            Resource res = ResourceLoader.getResource(gifName);
            if (res != null) {
                this.setProperty("absolutePath", res.getAbsolutePath());
            }
        } else {
            this.setProperty("path", XML.getRelativePath(gifName));
            this.setProperty("absolutePath", gifName);
        }
        this.frameCount = this.decoder.getFrameCount();
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        this.startTimes = new int[this.frameCount];
        this.startTimes[0] = 0;
        int i = 1;
        while (i < this.startTimes.length) {
            this.startTimes[i] = this.startTimes[i - 1] + this.decoder.getDelay(i - 1);
            ++i;
        }
        this.setImage(this.decoder.getFrame(0));
    }

    private void setImage(BufferedImage image) {
        this.rawImage = image;
        this.size = new Dimension(image.getWidth(), image.getHeight());
        this.refreshBufferedImage();
        this.coords = new ImageCoordSystem(this.frameCount);
        this.coords.addPropertyChangeListener(this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private void createTimer() {
        int delay = this.decoder.getDelay(0);
        this.timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GifVideo.this.getFrameNumber() < GifVideo.this.getEndFrameNumber()) {
                    int delay = GifVideo.this.decoder.getDelay(GifVideo.this.getFrameNumber() + 1);
                    GifVideo.this.timer.setDelay((int)((double)delay / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getFrameNumber() + 1);
                } else if (GifVideo.this.looping) {
                    int delay = GifVideo.this.decoder.getDelay(GifVideo.this.getStartFrameNumber());
                    GifVideo.this.timer.setDelay((int)((double)delay / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getStartFrameNumber());
                } else {
                    GifVideo.this.stop();
                }
            }
        });
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            GifVideo video2 = (GifVideo)obj;
            String base = (String)video2.getProperty("base");
            String absPath = (String)video2.getProperty("absolutePath");
            if (base != null && absPath != null) {
                control.setValue("path", XML.getPathRelativeTo(absPath, base));
            } else {
                String path = (String)video2.getProperty("path");
                control.setValue("path", path);
            }
            if (!video2.getFilterStack().isEmpty()) {
                control.setValue("filters", video2.getFilterStack().getFilters());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            try {
                String path = control.getString("path");
                GifVideo video2 = new GifVideo(path);
                VideoType gifType = VideoIO.getVideoType("gif", null);
                if (gifType != null) {
                    video2.setProperty("video_type", gifType);
                }
                return video2;
            }
            catch (IOException ex) {
                OSPLog.fine(ex.getMessage());
                return null;
            }
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            GifVideo video2 = (GifVideo)obj;
            Collection filters = (Collection)control.getObject("filters");
            if (filters != null) {
                video2.getFilterStack().clear();
                for (Filter filter : filters) {
                    video2.getFilterStack().addFilter(filter);
                }
            }
            return obj;
        }
    }
}

