/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoClip {
    public boolean changeEngine;
    private int startFrame = 0;
    private int stepSize = 1;
    private int stepCount;
    private int frameCount = this.stepCount = 10;
    private int maxFrameCount = 300000;
    private int frameShift = 0;
    private double startTime = 0.0;
    protected boolean isDefaultStartTime = true;
    protected Video video = null;
    private int[] stepFrames;
    ClipInspector inspector;
    private PropertyChangeSupport support = new SwingPropertyChangeSupport(this);
    private boolean playAllSteps = false;
    private boolean isDefaultState;
    private boolean isAdjusting = false;
    private int endFrame;
    protected String readoutType;
    protected String videoPath;
    protected double savedStartTime;
    protected boolean startTimeIsSaved = false;
    protected int extraFrames = 0;

    public VideoClip(Video video2) {
        this.video = video2;
        if (video2 != null) {
            video2.setProperty("videoclip", this);
            this.setStartFrameNumber(video2.getStartFrameNumber());
            if (video2.getFrameCount() > 1) {
                this.setStepCount(video2.getEndFrameNumber() - this.startFrame + 1);
            }
        }
        this.updateArray();
        this.isDefaultState = true;
    }

    public Video getVideo() {
        return this.video;
    }

    public String getVideoPath() {
        if (this.video != null) {
            return (String)this.video.getProperty("absolutePath");
        }
        return this.videoPath;
    }

    public boolean setStartFrameNumber(int start) {
        int maxEndFrame = this.getLastFrameNumber();
        return this.setStartFrameNumber(start, maxEndFrame);
    }

    public boolean setStartFrameNumber(int start, int maxStart) {
        int prevStart = this.getStartFrameNumber();
        int prevEnd = this.getEndFrameNumber();
        start = Math.max(start, this.getFirstFrameNumber());
        start = Math.min(start, maxStart);
        if (this.video != null && this.video.getFrameCount() > 1) {
            this.video.setEndFrameNumber(this.video.getFrameCount() - 1);
            int vidStart = Math.max(0, start + this.frameShift);
            this.video.setStartFrameNumber(vidStart);
            this.startFrame = Math.max(0, this.video.getStartFrameNumber() - this.frameShift);
        } else {
            this.startFrame = start;
            this.updateArray();
        }
        start = this.getStartFrameNumber();
        this.setEndFrameNumber(prevEnd);
        if (prevStart != start) {
            this.isDefaultState = false;
            this.support.firePropertyChange("startframe", null, new Integer(start));
        }
        return prevStart != start;
    }

    public int getStartFrameNumber() {
        return this.startFrame;
    }

    public boolean setStepSize(int size) {
        this.isDefaultState = false;
        if (size == 0) {
            return false;
        }
        size = Math.abs(size);
        if (this.video != null && this.video.getFrameCount() > 1) {
            int maxSize = Math.max(this.video.getFrameCount() - this.startFrame - 1 + this.extraFrames, 1);
            size = Math.min(size, maxSize);
        }
        if (this.stepSize == size) {
            return false;
        }
        int endFrame = this.getEndFrameNumber();
        this.stepSize = size;
        this.stepCount = 1 + (endFrame - this.getStartFrameNumber()) / this.stepSize;
        this.updateArray();
        this.support.firePropertyChange("stepsize", null, new Integer(size));
        this.setEndFrameNumber(endFrame);
        this.trimFrameCount();
        return true;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepCount(int count) {
        if (count == 0) {
            return;
        }
        count = Math.abs(count);
        if (this.video != null) {
            int end;
            if (this.video.getFrameCount() > 1) {
                end = this.video.getFrameCount() - 1 - this.frameShift + this.extraFrames;
                int maxCount = 1 + (int)((double)(end - this.startFrame) / (1.0 * (double)this.stepSize));
                count = Math.min(count, maxCount);
            }
            if ((end = this.startFrame + (count - 1) * this.stepSize + this.frameShift) != this.video.getEndFrameNumber()) {
                this.video.setEndFrameNumber(end);
            }
        } else {
            count = Math.min(count, this.frameToStep(this.maxFrameCount - 1) + 1);
        }
        if (this.stepCount == (count = Math.max(count, 1))) {
            this.updateArray();
            return;
        }
        Integer prev = new Integer(this.stepCount);
        this.stepCount = count;
        this.updateArray();
        this.support.firePropertyChange("stepcount", prev, new Integer(this.stepCount));
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public int setFrameShift(int n) {
        int start = this.getStartFrameNumber();
        int steps = this.getStepCount();
        return this.setFrameShift(n, start, steps);
    }

    protected int setFrameShift(int n, int start, int stepCount) {
        if (this.video != null) {
            n = Math.min(n, this.video.getFrameCount() - 1);
        }
        this.frameShift = n;
        this.support.firePropertyChange("frameshift", null, (Object)this.frameShift);
        this.setStartFrameNumber(start);
        this.setStepCount(stepCount);
        return this.frameShift;
    }

    public int getFrameShift() {
        return this.frameShift;
    }

    public void setExtraFrames(int extras) {
        int prev = this.extraFrames;
        this.extraFrames = Math.max(extras, 0);
        if (prev != this.extraFrames) {
            OSPLog.finest("set extra frames to " + this.extraFrames);
        }
    }

    public int getFrameCount() {
        if (this.video != null && this.video.getFrameCount() > 1) {
            int n = this.video.getFrameCount() + this.extraFrames;
            n = Math.min(n, n - this.frameShift);
            n = Math.max(1, n);
            return n;
        }
        int frames = this.getEndFrameNumber() + 1;
        this.frameCount = Math.max(this.frameCount, frames);
        this.frameCount = Math.min(this.frameCount, this.maxFrameCount);
        return this.frameCount;
    }

    public void setStartTime(double t0) {
        this.isDefaultState = false;
        if (this.startTime == t0 || this.isDefaultStartTime && Double.isNaN(t0)) {
            return;
        }
        this.isDefaultStartTime = Double.isNaN(t0);
        this.startTime = Double.isNaN(t0) ? 0.0 : t0;
        this.support.firePropertyChange("starttime", null, new Double(this.startTime));
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getEndFrameNumber() {
        this.endFrame = this.startFrame + this.stepSize * (this.stepCount - 1);
        return this.endFrame;
    }

    public boolean setEndFrameNumber(int end) {
        return this.setEndFrameNumber(end, this.maxFrameCount - 1 - this.frameShift, true);
    }

    public boolean extendEndFrameNumber(int end) {
        if (this.video != null && this.getFrameCount() <= end) {
            this.setExtraFrames(end - this.getFrameCount() + this.extraFrames);
        }
        return this.setEndFrameNumber(end);
    }

    private boolean setEndFrameNumber(int end, int max, boolean onlyIfChanged) {
        int maxStepSize;
        int prev = this.getEndFrameNumber();
        if (prev == end && onlyIfChanged) {
            return false;
        }
        this.isDefaultState = false;
        end = Math.max(end, this.startFrame);
        int rem = (end - this.startFrame) % this.stepSize;
        int count = (end - this.startFrame) / this.stepSize;
        if ((double)rem * 1.0 / (double)this.stepSize > 0.5) {
            ++count;
        }
        while (this.stepToFrame(count) > max) {
            --count;
        }
        this.setStepCount(count + 1);
        end = this.getEndFrameNumber();
        if (end != this.startFrame && (maxStepSize = Math.max(end - this.startFrame, 1)) < this.stepSize) {
            this.stepSize = maxStepSize;
        }
        return prev != end;
    }

    public int stepToFrame(int stepNumber) {
        return this.startFrame + stepNumber * this.stepSize;
    }

    public int frameToStep(int n) {
        return (int)((double)(n - this.startFrame) / (1.0 * (double)this.stepSize));
    }

    public boolean includesFrame(int n) {
        int i = 0;
        while (i < this.stepCount) {
            if (this.stepFrames[i] == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ClipInspector getClipInspector() {
        return this.inspector;
    }

    public ClipInspector getClipInspector(ClipControl control, Frame frame) {
        if (this.inspector == null) {
            this.inspector = new ClipInspector(this, control, frame);
        }
        return this.inspector;
    }

    public void hideClipInspector() {
        if (this.inspector != null) {
            this.inspector.setVisible(false);
        }
    }

    public boolean isDefaultState() {
        return this.isDefaultState && this.inspector == null;
    }

    public void setAdjusting(boolean adjusting) {
        if (this.isAdjusting == adjusting) {
            return;
        }
        this.isAdjusting = adjusting;
        this.support.firePropertyChange("adjusting", null, (Object)adjusting);
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void setPlayAllSteps(boolean all) {
        this.playAllSteps = all;
    }

    public boolean isPlayAllSteps() {
        return this.playAllSteps;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(property, listener);
    }

    protected void trimFrameCount() {
        if (this.video == null || this.video.getFrameCount() == 1) {
            this.frameCount = this.getEndFrameNumber() + 1;
            this.support.firePropertyChange("framecount", null, new Integer(this.frameCount));
        }
    }

    private void updateArray() {
        this.stepFrames = new int[this.stepCount];
        int i = 0;
        while (i < this.stepCount) {
            this.stepFrames[i] = this.stepToFrame(i);
            ++i;
        }
    }

    public int getFirstFrameNumber() {
        if (this.video == null) {
            return 0;
        }
        return Math.max(0, -this.frameShift);
    }

    public int getLastFrameNumber() {
        if (this.video == null) {
            return this.getEndFrameNumber();
        }
        int finalVideoFrame = this.video.getFrameCount() - 1 + this.extraFrames;
        return Math.max(0, finalVideoFrame - this.frameShift);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            VideoClip clip = (VideoClip)obj;
            Video video2 = clip.getVideo();
            if (video2 != null) {
                if (video2 instanceof ImageVideo) {
                    ImageVideo vid = (ImageVideo)video2;
                    if (vid.isFileBased()) {
                        control.setValue("video", video2);
                    }
                } else {
                    control.setValue("video", video2);
                }
                control.setValue("video_framecount", video2.getFrameCount());
            }
            control.setValue("startframe", clip.getStartFrameNumber());
            control.setValue("stepsize", clip.getStepSize());
            control.setValue("stepcount", clip.getStepCount());
            control.setValue("starttime", clip.startTimeIsSaved ? clip.savedStartTime : clip.getStartTime());
            control.setValue("frameshift", clip.getFrameShift());
            control.setValue("readout", clip.readoutType);
            control.setValue("playallsteps", clip.playAllSteps);
        }

        @Override
        public Object createObject(XMLControl control) {
            boolean hasVideo = control.getPropertyNames().contains("video");
            if (!hasVideo) {
                return new VideoClip(null);
            }
            ResourceLoader.addSearchPath(control.getString("basepath"));
            XMLControl child = control.getChildControl("video");
            String path = child.getString("path");
            Video video2 = VideoIO.getVideo(path, null);
            boolean engineChange = false;
            if (video2 == null && path != null && !VideoIO.isCanceled()) {
                if (ResourceLoader.getResource(path) != null) {
                    VideoType qtType;
                    VideoType xuggleType;
                    OSPLog.info("\"" + path + "\" could not be opened");
                    ArrayList<VideoType> otherEngines = new ArrayList<VideoType>();
                    String engine = VideoIO.getEngine();
                    String ext = XML.getExtension(path);
                    if (!engine.equals("Xuggle") && (xuggleType = VideoIO.getVideoType("Xuggle", ext)) != null) {
                        otherEngines.add(xuggleType);
                    }
                    if (!engine.equals("QT") && (qtType = VideoIO.getVideoType("QT", ext)) != null) {
                        otherEngines.add(qtType);
                    }
                    if (otherEngines.isEmpty()) {
                        JOptionPane.showMessageDialog(null, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + "\n\n" + path, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 2);
                    } else {
                        JCheckBox changePreferredEngine = new JCheckBox(MediaRes.getString("VideoIO.Dialog.TryDifferentEngine.Checkbox"));
                        video2 = VideoIO.getVideo(path, otherEngines, changePreferredEngine, null);
                        engineChange = changePreferredEngine.isSelected();
                        if (video2 != null && changePreferredEngine.isSelected()) {
                            String typeName = video2.getClass().getSimpleName();
                            String newEngine = typeName.indexOf("Xuggle") > -1 ? "Xuggle" : (typeName.indexOf("QT") > -1 ? "QT" : "none");
                            VideoIO.setEngine(newEngine);
                        }
                    }
                } else {
                    int response = JOptionPane.showConfirmDialog(null, "\"" + path + "\" " + MediaRes.getString("VideoClip.Dialog.VideoNotFound.Message"), MediaRes.getString("VideoClip.Dialog.VideoNotFound.Title"), 0, 2);
                    if (response == 0) {
                        VideoIO.getChooser().setAccessory(VideoIO.videoEnginePanel);
                        VideoIO.videoEnginePanel.reset();
                        VideoIO.getChooser().setSelectedFile(new File(path));
                        File[] files = VideoIO.getChooserFiles("open video");
                        if (files != null && files.length > 0) {
                            VideoType selectedType = VideoIO.videoEnginePanel.getSelectedVideoType();
                            path = XML.getAbsolutePath(files[0]);
                            video2 = VideoIO.getVideo(path, selectedType);
                        }
                    }
                }
            }
            if (video2 != null) {
                double dt;
                Collection filters = (Collection)child.getObject("filters");
                if (filters != null) {
                    video2.getFilterStack().clear();
                    for (Filter filter : filters) {
                        video2.getFilterStack().addFilter(filter);
                    }
                }
                if (video2 instanceof ImageVideo && !Double.isNaN(dt = child.getDouble("delta_t"))) {
                    ((ImageVideo)video2).setFrameDuration(dt);
                }
            }
            VideoClip clip = new VideoClip(video2);
            clip.changeEngine = engineChange;
            if (path != null) {
                if (!path.startsWith("/") && path.indexOf(":") == -1) {
                    String base = control.getString("basepath");
                    path = XML.getResolvedPath(path, base);
                }
                clip.videoPath = path;
            }
            return clip;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            double t;
            VideoClip clip = (VideoClip)obj;
            int start = control.getInt("startframe");
            int stepSize = control.getInt("stepsize");
            int stepCount = control.getInt("stepcount");
            int frameCount = clip.getFrameCount();
            if (control.getPropertyNames().contains("video_framecount")) {
                frameCount = control.getInt("video_framecount");
            } else if (start != Integer.MIN_VALUE && stepSize != Integer.MIN_VALUE && stepCount != Integer.MIN_VALUE) {
                frameCount = start + stepCount * stepSize;
            }
            clip.setStepCount(frameCount);
            int shift = control.getInt("frameshift");
            if (shift != Integer.MIN_VALUE) {
                clip.setFrameShift(shift);
            }
            if (start != Integer.MIN_VALUE) {
                clip.setStartFrameNumber(start);
            }
            if (stepSize != Integer.MIN_VALUE) {
                clip.setStepSize(stepSize);
            }
            if (stepCount != Integer.MIN_VALUE) {
                clip.setStepCount(stepCount);
            }
            if (!Double.isNaN(t = control.getDouble("starttime"))) {
                clip.startTime = t;
            }
            clip.readoutType = control.getString("readout");
            clip.playAllSteps = true;
            if (control.getPropertyNames().contains("playallsteps")) {
                clip.playAllSteps = control.getBoolean("playallsteps");
            }
            return obj;
        }
    }
}

