/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.CartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.VideoPanel;

public class VidCartesianCoordinateStringBuilder
extends CartesianCoordinateStringBuilder {
    protected VidCartesianCoordinateStringBuilder() {
    }

    protected VidCartesianCoordinateStringBuilder(String xLabel, String yLabel) {
        super(xLabel, yLabel);
    }

    @Override
    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        if (!(panel instanceof VideoPanel)) {
            return super.getCoordinateString(panel, e);
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        Point2D pt = vidPanel.getWorldMousePoint();
        return this.getCoordinateString(pt.getX(), pt.getY());
    }

    public String getCoordinateString(double x, double y) {
        String msg = Math.abs(x) > 100.0 || Math.abs(x) < 0.01 || Math.abs(y) > 100.0 || Math.abs(y) < 0.01 ? String.valueOf(this.xLabel) + this.scientificFormat.format((float)x) + this.yLabel + this.scientificFormat.format((float)y) : String.valueOf(this.xLabel) + this.decimalFormat.format((float)x) + this.yLabel + this.decimalFormat.format((float)y);
        return msg;
    }
}

