/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.VideoClip;

public class StepperClipControl
extends ClipControl {
    private Timer timer;
    private double frameDuration = 100.0;
    private boolean playing = false;
    private boolean readyToStep = true;
    private boolean stepDisplayed = true;
    private int minDelay = 10;
    private int maxDelay = 5000;

    protected StepperClipControl(VideoClip videoClip) {
        super(videoClip);
        videoClip.addPropertyChangeListener(this);
        if (this.video != null) {
            this.video.addPropertyChangeListener(this);
            if (this.video.getFrameCount() > 1 && this.video.getDuration() > 0.0) {
                double ti = this.video.getFrameTime(this.video.getStartFrameNumber());
                double tf = this.video.getFrameTime(this.video.getEndFrameNumber());
                int count = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
                if (count != 0 && tf - ti > 0.0) {
                    this.frameDuration = (int)(tf - ti) / count;
                }
            }
        }
        this.timer = new Timer(this.getTimerDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StepperClipControl.this.readyToStep = true;
                StepperClipControl.this.step();
            }
        });
        this.timer.setRepeats(false);
        this.timer.setCoalesce(false);
    }

    @Override
    public void play() {
        if (this.clip.getStepCount() == 1) {
            return;
        }
        this.playing = true;
        this.readyToStep = true;
        if (this.stepNumber == this.clip.getStepCount() - 1) {
            this.setStepNumber(0);
        } else {
            this.step();
        }
        this.support.firePropertyChange("playing", null, new Boolean(true));
    }

    @Override
    public void stop() {
        this.timer.stop();
        this.readyToStep = true;
        this.stepDisplayed = true;
        this.playing = false;
        this.support.firePropertyChange("playing", null, new Boolean(false));
    }

    @Override
    public void step() {
        if (this.stepNumber >= this.clip.getStepCount() - 1 && !this.looping) {
            this.stop();
        } else if (this.stepDisplayed && (!this.playing || this.readyToStep)) {
            this.stepDisplayed = false;
            if (this.playing) {
                this.readyToStep = false;
                this.timer.restart();
            }
            if (this.stepNumber < this.clip.getStepCount() - 1) {
                this.setStepNumber(this.stepNumber + 1);
            } else if (this.looping) {
                this.setStepNumber(0);
            }
        }
    }

    @Override
    public void back() {
        if (this.stepDisplayed && this.stepNumber > 0) {
            this.stepDisplayed = false;
            this.setStepNumber(this.stepNumber - 1);
        }
    }

    @Override
    public void setStepNumber(int n) {
        n = Math.max(0, n);
        n = Math.min(this.clip.getStepCount() - 1, n);
        if (n == this.stepNumber && this.clip.stepToFrame(n) == this.getFrameNumber()) {
            return;
        }
        if (this.video == null) {
            super.setStepNumber(n);
            this.stepDisplayed = true;
            this.support.firePropertyChange("stepnumber", null, new Integer(n));
        } else {
            int end = this.video.getEndFrameNumber();
            final int m = this.clip.stepToFrame(n) + this.clip.getFrameShift();
            final int stepNum = n;
            if (m > end) {
                super.setStepNumber(n);
                this.video.setVisible(false);
                this.stepDisplayed = true;
                this.support.firePropertyChange("stepnumber", null, new Integer(n));
            } else {
                this.video.setVisible(true);
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        if (StepperClipControl.this.videoFrameNumber == m) {
                            StepperClipControl.this.stepDisplayed = true;
                        } else if (StepperClipControl.this.video.getFrameNumber() == m) {
                            StepperClipControl.super.setStepNumber(stepNum);
                            StepperClipControl.this.stepDisplayed = true;
                            StepperClipControl.this.support.firePropertyChange("stepnumber", null, new Integer(stepNum));
                        } else {
                            StepperClipControl.this.video.setFrameNumber(m);
                        }
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        }
    }

    @Override
    public void setRate(double newRate) {
        if (newRate == 0.0 || newRate == this.rate) {
            return;
        }
        this.rate = Math.abs(newRate);
        this.timer.setInitialDelay(this.getTimerDelay());
        this.support.firePropertyChange("rate", null, new Double(this.rate));
    }

    @Override
    public double getMeanFrameDuration() {
        if (this.video != null && this.video.getDuration() > 0.0) {
            int count = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
            if (count != 0) {
                double ti = this.video.getFrameTime(this.video.getStartFrameNumber());
                double tf = this.video.getFrameTime(this.video.getEndFrameNumber());
                return this.timeStretch * (tf - ti) / (double)count;
            }
            return this.timeStretch * this.video.getDuration() / (double)this.video.getFrameCount();
        }
        return this.frameDuration;
    }

    @Override
    public void setFrameDuration(double duration) {
        if ((duration = Math.abs(duration)) == 0.0 || duration == this.getMeanFrameDuration()) {
            return;
        }
        if (this.video != null && this.video instanceof ImageVideo) {
            ImageVideo iVideo = (ImageVideo)this.video;
            iVideo.setFrameDuration(duration);
            this.frameDuration = duration;
            this.timer.setInitialDelay(this.getTimerDelay());
        } else if (this.video != null && this.video.getDuration() > 0.0) {
            double ti = this.video.getFrameTime(this.video.getStartFrameNumber());
            double tf = this.video.getFrameTime(this.video.getEndFrameNumber());
            int count = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
            if (count != 0) {
                this.timeStretch = duration * (double)count / (tf - ti);
            }
        } else {
            this.frameDuration = duration;
            this.timer.setInitialDelay(this.getTimerDelay());
        }
        this.support.firePropertyChange("frameduration", null, new Double(duration));
    }

    @Override
    public void setLooping(boolean loops) {
        if (loops == this.looping) {
            return;
        }
        this.looping = loops;
        this.support.firePropertyChange("looping", null, new Boolean(loops));
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public double getTime() {
        if (this.video != null && this.video.getDuration() > 0.0) {
            int n = this.video.getFrameNumber();
            double videoTime = this.video.getFrameTime(n);
            int m = this.clip.stepToFrame(this.getStepNumber()) + this.clip.getFrameShift();
            if (m > this.video.getFrameCount() - 1) {
                int extra = m - this.video.getFrameCount() + 1;
                videoTime = this.video.getFrameTime(this.video.getFrameCount() - 1) + (double)extra * this.frameDuration;
            }
            return (videoTime - this.video.getStartTime()) * this.timeStretch;
        }
        return (double)this.stepNumber * this.frameDuration * (double)this.clip.getStepSize();
    }

    @Override
    public double getStepTime(int stepNumber) {
        if (this.video != null && this.video.getDuration() > 0.0) {
            int n = this.clip.stepToFrame(stepNumber) + this.clip.getFrameShift();
            double videoTime = this.video.getFrameTime(n);
            if (n > this.video.getFrameCount() - 1) {
                int extra = n - this.video.getFrameCount() + 1;
                videoTime = this.video.getFrameTime(this.video.getFrameCount() - 1) + (double)extra * this.frameDuration;
            }
            return (videoTime - this.video.getStartTime()) * this.timeStretch;
        }
        return (double)stepNumber * this.frameDuration * (double)this.clip.getStepSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("stepsize")) {
            this.timer.setInitialDelay(this.getTimerDelay());
        } else if (name.equals("framenumber")) {
            int n = (Integer)e.getNewValue();
            this.stepDisplayed = true;
            if (n != this.videoFrameNumber) {
                super.setFrameNumber(n - this.clip.getFrameShift());
                this.support.firePropertyChange("stepnumber", null, new Integer(this.stepNumber));
            }
            if (this.playing) {
                this.step();
            }
        } else {
            super.propertyChange(e);
        }
    }

    private int getTimerDelay() {
        double duration = this.frameDuration;
        if (this.video != null && this.video.getDuration() > 0.0) {
            int count = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
            if (count != 0) {
                double ti = this.video.getFrameTime(this.video.getStartFrameNumber());
                double tf = this.video.getFrameTime(this.video.getEndFrameNumber());
                duration = (tf - ti) / (double)count;
            } else {
                duration = this.video.getDuration() / (double)this.video.getFrameCount();
            }
        }
        int delay = (int)(duration * (double)this.clip.getStepSize() / this.rate);
        delay = Math.min(delay, this.maxDelay);
        delay = Math.max(delay, this.minDelay);
        return delay;
    }

    public static XML.ObjectLoader getLoader() {
        return new ClipControl.Loader();
    }
}

