/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import org.opensourcephysics.media.core.NumberField;

public class ScientificField
extends NumberField {
    private double zeroLimit = 1.0E-10;

    public ScientificField(int columns) {
        this(columns, 4);
    }

    public ScientificField(int columns, int sigfigs) {
        super(columns, sigfigs);
        char d = '.';
        this.fixedPattern = true;
        String s = "";
        int i = 0;
        while (i < this.sigfigs - 1) {
            s = String.valueOf(s) + "0";
            ++i;
        }
        this.format.applyPattern("0" + d + s + "E0");
    }

    @Override
    public void setValue(double value) {
        if (Math.abs(value) < this.zeroLimit) {
            value = 0.0;
        }
        super.setValue(value);
    }

    @Override
    public void setSigFigs(int sigfigs) {
        if (this.sigfigs == sigfigs) {
            return;
        }
        sigfigs = Math.max(sigfigs, 2);
        this.sigfigs = Math.min(sigfigs, 6);
    }

    @Override
    public void setExpectedRange(double lower, double upper) {
    }
}

