/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;

public class ImageVideoType
implements VideoType {
    protected static TreeSet<VideoFileFilter> imageFileFilters = new TreeSet();
    private VideoFileFilter singleTypeFilter;

    public ImageVideoType() {
    }

    public ImageVideoType(VideoFileFilter filter) {
        this();
        if (filter != null) {
            this.singleTypeFilter = filter;
            imageFileFilters.add(filter);
        }
    }

    public Video getVideo(File file) {
        try {
            ImageVideo video2 = new ImageVideo(file.getAbsolutePath(), true);
            video2.setProperty("video_type", this);
            return video2;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Video getVideo(String name) {
        String xmlName = String.valueOf(XML.stripExtension(name)) + ".xml";
        XMLControlElement control = new XMLControlElement(xmlName);
        if (!control.failedToRead() && control.getObjectClass() == ImageVideo.class) {
            return (Video)control.loadObject(null);
        }
        try {
            ImageVideo video2 = new ImageVideo(name, true);
            video2.setProperty("video_type", this);
            return video2;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public VideoRecorder getRecorder() {
        return new ImageVideoRecorder(this);
    }

    @Override
    public boolean canRecord() {
        return true;
    }

    @Override
    public String getDescription() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDescription();
        }
        return MediaRes.getString("ImageVideoType.Description");
    }

    @Override
    public String getDefaultExtension() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDefaultExtension();
        }
        return null;
    }

    @Override
    public VideoFileFilter[] getFileFilters() {
        return imageFileFilters.toArray(new VideoFileFilter[0]);
    }

    @Override
    public VideoFileFilter getDefaultFileFilter() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter;
        }
        return null;
    }

    @Override
    public boolean isType(Video video2) {
        return video2.getClass().equals(ImageVideo.class);
    }
}

