/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

public class DoubleArray {
    private double[] map;
    private int length;

    public DoubleArray(int initialLength, double initialValue) {
        this.length = initialLength;
        this.map = new double[this.length];
        this.fill(initialValue, 0);
    }

    public double get(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return this.map[n];
    }

    public boolean set(int n, double value) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        boolean changed = this.map[n] != value;
        this.map[n] = value;
        return changed;
    }

    public void setLength(int newLength) {
        if (newLength == this.length || newLength < 1) {
            return;
        }
        double[] newMap = new double[newLength];
        System.arraycopy(this.map, 0, newMap, 0, Math.min(newLength, this.length));
        this.map = newMap;
        if (newLength > this.length) {
            double val = this.map[this.length - 1];
            int n = this.length;
            this.length = newLength;
            this.fill(val, n);
        } else {
            this.length = newLength;
        }
    }

    public boolean fill(double value) {
        boolean changed = false;
        int n = this.length - 1;
        while (n >= 0) {
            changed = changed || this.map[n] != value;
            this.map[n] = value;
            --n;
        }
        return changed;
    }

    public boolean fill(double value, int start, int end) {
        boolean changed = false;
        end = Math.min(end, this.length - 1);
        start = Math.max(0, start);
        int n = end;
        while (n >= start) {
            changed = changed || this.map[n] != value;
            this.map[n] = value;
            --n;
        }
        return changed;
    }

    private void fill(double value, int startFrame) {
        int n = startFrame;
        while (n < this.length) {
            this.map[n] = value;
            ++n;
        }
    }
}

