/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;

public class PolarCoordinateStringBuilder
extends CoordinateStringBuilder {
    protected String rLabel = "r=";
    protected String phiLabel = " phi=";
    protected double sin = 0.0;
    protected double cos = 1.0;

    public PolarCoordinateStringBuilder() {
        this("r=", "  phi=");
    }

    public PolarCoordinateStringBuilder(String rLabel, String phiLabel, double phiZero) {
        this(rLabel, phiLabel);
        this.sin = -Math.sin(phiZero);
        this.cos = Math.cos(phiZero);
    }

    public PolarCoordinateStringBuilder(String rLabel, String phiLabel) {
        this.rLabel = rLabel;
        this.phiLabel = phiLabel;
    }

    @Override
    public void setCoordinateLabels(String rLabel, String phiLabel) {
        this.rLabel = rLabel;
        this.phiLabel = phiLabel;
    }

    @Override
    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        double r;
        double x = panel.pixToX(e.getPoint().x);
        double y = panel.pixToY(e.getPoint().y);
        if (panel instanceof InteractivePanel && ((InteractivePanel)panel).getCurrentDraggable() != null) {
            x = ((InteractivePanel)panel).getCurrentDraggable().getX();
            y = ((InteractivePanel)panel).getCurrentDraggable().getY();
        }
        String msg = (r = Math.sqrt(x * x + y * y)) > 100.0 || r < 0.01 ? String.valueOf(this.rLabel) + this.scientificFormat.format((float)r) : String.valueOf(this.rLabel) + this.decimalFormat.format((float)r);
        msg = String.valueOf(msg) + this.phiLabel + this.decimalFormat.format((double)(180.0f * (float)Math.atan2(x * this.sin + y * this.cos, x * this.cos - y * this.sin)) / Math.PI);
        return msg;
    }
}

