/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.AbstractTrail;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.LogMeasurable;

public class Trail
extends AbstractTrail
implements LogMeasurable {
    GeneralPath generalPath = new GeneralPath();
    boolean connected = true;

    @Override
    public synchronized void addPoint(double x, double y) {
        if (this.closed) {
            throw new IllegalStateException("Cannot add points to a closed trail.");
        }
        if (!this.connected || this.numpts == 0) {
            this.generalPath.moveTo((float)x, (float)y);
        }
        this.generalPath.lineTo((float)x, (float)y);
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        if (x > 0.0) {
            this.xminLogscale = Math.min(this.xminLogscale, x);
            this.xmaxLogscale = Math.max(this.xmaxLogscale, x);
        }
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        if (y > 0.0) {
            this.yminLogscale = Math.min(this.yminLogscale, y);
            this.ymaxLogscale = Math.max(this.ymaxLogscale, y);
        }
        ++this.numpts;
    }

    public synchronized void moveToPoint(double x, double y) {
        this.generalPath.moveTo((float)x, (float)y);
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        if (x > 0.0) {
            this.xminLogscale = Math.min(this.xminLogscale, x);
            this.xmaxLogscale = Math.max(this.xmaxLogscale, x);
        }
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        if (y > 0.0) {
            this.yminLogscale = Math.min(this.yminLogscale, y);
            this.ymaxLogscale = Math.max(this.ymaxLogscale, y);
        }
        ++this.numpts;
    }

    @Override
    public void closeTrail() {
        this.closed = true;
        this.generalPath.closePath();
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized void clear() {
        this.closed = false;
        this.numpts = 0;
        this.xmaxLogscale = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
        this.ymaxLogscale = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xminLogscale = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.yminLogscale = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.generalPath.reset();
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (this.numpts == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        Shape s = this.generalPath.createTransformedShape(panel.getPixelTransform());
        if (this.drawingStroke != null) {
            Stroke stroke = g2.getStroke();
            g2.setStroke(this.drawingStroke);
            g2.draw(s);
            g2.setStroke(stroke);
        } else {
            g2.draw(s);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Trail trail = (Trail)obj;
            control.setValue("connected", trail.connected);
            control.setValue("color", trail.color);
            control.setValue("number of pts", trail.numpts);
            control.setValue("general path", trail.generalPath);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Trail();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Trail trail = (Trail)obj;
            trail.connected = control.getBoolean("connected");
            trail.color = (Color)control.getObject("color");
            trail.numpts = control.getInt("number of pts");
            trail.generalPath = (GeneralPath)control.getObject("general path");
            return obj;
        }
    }
}

