/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.desktop.ostermiller.Browser;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TextFrame
extends JFrame {
    HyperlinkListener hyperlinkListener;
    JTextPane textPane = new JTextPane(){

        @Override
        public void paintComponent(Graphics g) {
            if (OSPRuntime.antiAliasText.booleanValue()) {
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints rh = g2.getRenderingHints();
                rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            super.paintComponent(g);
        }
    };
    JScrollPane textScroller;

    public TextFrame() {
        this((String)null, (Class<?>)null);
    }

    public TextFrame(String resourceName) {
        this(resourceName, (Class<?>)null);
    }

    public TextFrame(String resourceName, Class<?> location) {
        this.setSize(300, 300);
        this.textPane.setEditable(false);
        this.textScroller = new JScrollPane(this.textPane);
        this.setContentPane(this.textScroller);
        if (resourceName != null) {
            this.loadResource(resourceName, location);
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void enableHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        TextFrame.this.textPane.setPage(e.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.textPane.addHyperlinkListener(this.hyperlinkListener);
    }

    public void enableDesktopHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (!OSPDesktop.browse(e.getURL().toURI())) {
                            Browser.init();
                            Browser.displayURL(e.getURL().toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.textPane.addHyperlinkListener(this.hyperlinkListener);
    }

    public void disableHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = null;
    }

    public boolean loadResource(String resourceName, Class<?> location) {
        Resource res = null;
        try {
            res = ResourceLoader.getResource(resourceName, location);
        }
        catch (Exception ex) {
            OSPLog.fine("Error getting resource: " + resourceName);
            return false;
        }
        if (res == null) {
            OSPLog.fine("Resource not found: " + resourceName);
            return false;
        }
        try {
            this.textPane.setPage(res.getURL());
        }
        catch (IOException ex) {
            OSPLog.fine("Resource not loadeded: " + resourceName);
            return false;
        }
        this.setTitle(resourceName);
        return true;
    }
}

