/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;

public class OSPLayout
extends BorderLayout {
    public static int macOffset;
    ArrayList<Component> list = new ArrayList();
    public static final String TOP_LEFT_CORNER = "TopLeftCorner";
    public static final String TOP_RIGHT_CORNER = "TopRightCorner";
    public static final String BOTTOM_LEFT_CORNER = "BottomLeftCorner";
    public static final String BOTTOM_RIGHT_CORNER = "BottomRightCorner";
    public static final String CENTERED = "Centered";
    Component topLeftCorner;
    Component topRightCorner;
    Component bottomLeftCorner;
    Component bottomRightCorner;
    Component centeredComp;
    Rectangle layoutRect = new Rectangle(0, 0, 0, 0);
    Component[] components = new Component[0];

    static {
        try {
            macOffset = "Mac OS X".equals(System.getProperty("os.name")) ? 16 : 0;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public OSPLayout() {
        this(0, 0);
    }

    public OSPLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!this.list.contains(comp)) {
            this.list.add(comp);
            this.components = this.list.toArray(new Component[0]);
        }
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints instanceof String && TOP_LEFT_CORNER.equals(constraints)) {
                this.list.remove(this.topLeftCorner);
                this.topLeftCorner = comp;
            } else if (constraints instanceof String && TOP_RIGHT_CORNER.equals(constraints)) {
                this.list.remove(this.topRightCorner);
                this.topRightCorner = comp;
            } else if (constraints instanceof String && BOTTOM_LEFT_CORNER.equals(constraints)) {
                this.list.remove(this.bottomLeftCorner);
                this.bottomLeftCorner = comp;
            } else if (constraints instanceof String && BOTTOM_RIGHT_CORNER.equals(constraints)) {
                this.list.remove(this.bottomRightCorner);
                this.bottomRightCorner = comp;
            } else if (constraints instanceof String && CENTERED.equals(constraints)) {
                this.list.remove(this.centeredComp);
                this.centeredComp = comp;
            } else {
                super.addLayoutComponent(comp, constraints);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.list.contains(comp)) {
            this.list.remove(comp);
            this.components = this.list.toArray(new Component[0]);
        }
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (comp == this.topLeftCorner) {
                this.topLeftCorner = null;
            } else if (comp == this.topRightCorner) {
                this.topRightCorner = null;
            } else if (comp == this.bottomLeftCorner) {
                this.bottomLeftCorner = null;
            } else if (comp == this.bottomRightCorner) {
                this.bottomRightCorner = null;
            } else if (comp == this.centeredComp) {
                this.centeredComp = null;
            } else {
                super.removeLayoutComponent(comp);
            }
        }
    }

    @Override
    public void layoutContainer(Container target) {
        super.layoutContainer(target);
        this.doMyLayout(target);
    }

    public boolean quickLayout(Container target, Component c) {
        if (target == null || c == null) {
            return false;
        }
        Insets insets = target.getInsets();
        int top = insets.top;
        int bottom = target.getHeight() - insets.bottom;
        int left = insets.left;
        int right = target.getWidth() - insets.right;
        if (this.topLeftCorner == c) {
            Dimension d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds(left, top, d.width, d.height);
        } else if (this.topRightCorner == c) {
            Dimension d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds(right - d.width, top, d.width, d.height);
        } else if (this.bottomLeftCorner == c) {
            Dimension d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds(left, bottom - d.height, d.width, d.height);
        } else if (this.bottomRightCorner == c) {
            Dimension d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds(right - d.width - macOffset, bottom - d.height, d.width, d.height);
        } else if (this.centeredComp == c) {
            Dimension d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds((right - left - d.width) / 2, (bottom - top - d.height) / 2, d.width, d.height);
        } else {
            return false;
        }
        return true;
    }

    public void checkLayoutRect(Container c, Rectangle viewRect) {
        if (this.layoutRect.equals(viewRect)) {
            return;
        }
        this.layoutContainer(c);
    }

    public Component[] getComponents() {
        return this.components;
    }

    void doMyLayout(Container target) {
        Dimension d;
        Insets insets = target.getInsets();
        int top = insets.top;
        int bottom = target.getHeight() - insets.bottom;
        int left = insets.left;
        int right = target.getWidth() - insets.right;
        Component c = null;
        if (this.topLeftCorner != null) {
            c = this.topLeftCorner;
            d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds(left, top, d.width, d.height);
        }
        if (this.topRightCorner != null) {
            c = this.topRightCorner;
            d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds(right - d.width, top, d.width, d.height);
        }
        if (this.bottomLeftCorner != null) {
            c = this.bottomLeftCorner;
            d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds(left, bottom - d.height, d.width, d.height);
        }
        if (this.bottomRightCorner != null) {
            c = this.bottomRightCorner;
            d = c.getPreferredSize();
            c.setSize(d.width + macOffset, d.height);
            c.setBounds(right - d.width - macOffset, bottom - d.height, d.width, d.height);
        }
        if (this.centeredComp != null) {
            c = this.centeredComp;
            d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            c.setBounds((right - left - d.width) / 2, (bottom - top - d.height) / 2, d.width, d.height);
        }
    }
}

