/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.False3D;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.dialogs.DrawingPanelInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.display.dialogs.XMLDrawingPanelInspector;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.VideoTool;

public class DrawingPanel
extends JPanel
implements ActionListener,
Renderable {
    protected static final boolean RECORD_PAINT_TIMES = false;
    protected long currentTime = System.currentTimeMillis();
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    protected JPopupMenu popupmenu = new JPopupMenu();
    protected JMenuItem propertiesItem;
    protected JMenuItem autoscaleItem;
    protected JMenuItem scaleItem;
    protected JMenuItem zoomInItem;
    protected JMenuItem zoomOutItem;
    protected JMenuItem snapshotItem;
    protected int leftGutter = 0;
    protected int topGutter = 0;
    protected int rightGutter = 0;
    protected int bottomGutter = 0;
    protected int leftGutterPreferred = 0;
    protected int topGutterPreferred = 0;
    protected int rightGutterPreferred = 0;
    protected int bottomGutterPreferred = 0;
    protected boolean clipAtGutter = true;
    protected boolean adjustableGutter = false;
    protected int width;
    protected int height;
    protected Color bgColor = new Color(239, 239, 255);
    protected boolean antialiasTextOn = false;
    protected boolean antialiasShapeOn = false;
    protected boolean squareAspect = false;
    protected boolean autoscaleX = true;
    protected boolean autoscaleY = true;
    protected boolean autoscaleXMin = true;
    protected boolean autoscaleXMax = true;
    protected boolean autoscaleYMin = true;
    protected boolean autoscaleYMax = true;
    protected double autoscaleMargin = 0.0;
    protected double xminPreferred = -10.0;
    protected double xmaxPreferred = 10.0;
    protected double yminPreferred = -10.0;
    protected double ymaxPreferred = 10.0;
    protected double xfloor = Double.NaN;
    protected double xceil = Double.NaN;
    protected double yfloor = Double.NaN;
    protected double yceil = Double.NaN;
    protected double xmin = this.xminPreferred;
    protected double xmax = this.xmaxPreferred;
    protected double ymin = this.yminPreferred;
    protected double ymax = this.xmaxPreferred;
    protected boolean fixedPixelPerUnit = false;
    protected double xPixPerUnit = 1.0;
    protected double yPixPerUnit = 1.0;
    protected AffineTransform pixelTransform = new AffineTransform();
    protected double[] pixelMatrix = new double[6];
    protected ArrayList<Drawable> drawableList = new ArrayList();
    private volatile boolean validImage = false;
    protected BufferedImage offscreenImage;
    protected BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private boolean buffered = false;
    protected TextPanel trMessageBox = new TextPanel();
    protected TextPanel tlMessageBox = new TextPanel();
    protected TextPanel brMessageBox = new TextPanel();
    protected TextPanel blMessageBox = new TextPanel();
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected MouseInputAdapter mouseController = new CMController();
    protected boolean showCoordinates = false;
    protected MouseInputAdapter optionController = new OptionController();
    protected ZoomBox zoomBox = new ZoomBox();
    protected boolean enableZoom = true;
    protected boolean fixedScale = false;
    protected Window customInspector;
    protected Dimensioned dimensionSetter = null;
    protected Rectangle viewRect = null;
    protected CoordinateStringBuilder coordinateStrBuilder = CoordinateStringBuilder.createCartesian();
    protected GlassPanel glassPanel = new GlassPanel();
    protected OSPLayout glassPanelLayout = new OSPLayout();
    protected int refreshDelay = 100;
    protected Timer refreshTimer = new Timer(this.refreshDelay, this);
    protected VideoTool vidCap;
    protected double imageRatio = 1.0;
    protected double xLeftMarginPercentage = 0.0;
    protected double xRightMarginPercentage = 0.0;
    protected double yTopMarginPercentage = 0.0;
    protected double yBottomMarginPercentage = 0.0;
    protected boolean logScaleX = false;
    protected boolean logScaleY = false;
    protected int zoomDelay = 40;
    protected int zoomCount;
    protected Timer zoomTimer;
    protected double dxmin;
    protected double dxmax;
    protected double dymin;
    protected double dymax;

    public DrawingPanel() {
        this.glassPanel.setLayout(this.glassPanelLayout);
        super.setLayout(new BorderLayout());
        this.glassPanel.add((Component)this.trMessageBox, "TopRightCorner");
        this.glassPanel.add((Component)this.tlMessageBox, "TopLeftCorner");
        this.glassPanel.add((Component)this.brMessageBox, "BottomRightCorner");
        this.glassPanel.add((Component)this.blMessageBox, "BottomLeftCorner");
        this.glassPanel.setOpaque(false);
        super.add((Component)this.glassPanel, "Center");
        this.setBackground(this.bgColor);
        this.setPreferredSize(new Dimension(300, 300));
        this.showCoordinates = true;
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.addOptionController();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DrawingPanel.this.invalidateImage();
            }
        });
        this.buildPopupmenu();
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setFontLevel(FontSizer.getLevel());
        this.zoomTimer = new Timer(this.zoomDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawingPanel.this.zoomBox.xstart = 0;
                DrawingPanel.this.zoomBox.xstop = 0;
                DrawingPanel.this.zoomBox.xlast = 0;
                DrawingPanel.this.zoomBox.ystart = 0;
                DrawingPanel.this.zoomBox.ystop = 0;
                DrawingPanel.this.zoomBox.ylast = 0;
                DrawingPanel.this.zoomBox.dragged = false;
                DrawingPanel.this.zoomBox.visible = false;
                int steps = 4;
                if (DrawingPanel.this.zoomCount < steps) {
                    ++DrawingPanel.this.zoomCount;
                    double xmin = DrawingPanel.this.getXMin() + DrawingPanel.this.dxmin / (double)steps;
                    double xmax = DrawingPanel.this.getXMax() + DrawingPanel.this.dxmax / (double)steps;
                    double ymin = DrawingPanel.this.getYMin() + DrawingPanel.this.dymin / (double)steps;
                    double ymax = DrawingPanel.this.getYMax() + DrawingPanel.this.dymax / (double)steps;
                    DrawingPanel.this.setPreferredMinMax(xmin, xmax, ymin, ymax);
                    DrawingPanel.this.repaint();
                } else {
                    DrawingPanel.this.zoomTimer.stop();
                    DrawingPanel.this.invalidateImage();
                    DrawingPanel.this.repaint();
                }
            }
        });
        this.zoomTimer.setInitialDelay(0);
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int level = (Integer)e.getNewValue();
                DrawingPanel.this.setFontLevel(level);
            }
        });
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DrawingPanel.this.refreshGUI();
            }
        });
    }

    protected void refreshGUI() {
        this.zoomInItem.setText(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"));
        this.zoomOutItem.setText(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"));
        this.scaleItem.setText(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
        this.autoscaleItem.setText(DisplayRes.getString("DrawingFrame.Autoscale_menu_item"));
        this.snapshotItem.setText(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.propertiesItem.setText(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
    }

    protected void setFontLevel(int level) {
        Font font;
        this.trMessageBox.font = font = FontSizer.getResizedFont(this.trMessageBox.font, level);
        this.tlMessageBox.font = font;
        this.brMessageBox.font = font;
        this.blMessageBox.font = font;
        this.invalidateImage();
    }

    public void setFontFactor(double factor) {
        Font font;
        this.trMessageBox.font = font = FontSizer.getResizedFont(this.trMessageBox.font, factor);
        this.tlMessageBox.font = font;
        this.brMessageBox.font = font;
        this.blMessageBox.font = font;
        this.invalidateImage();
        this.repaint();
    }

    protected void buildPopupmenu() {
        this.popupmenu.removeAll();
        this.popupmenu.setEnabled(true);
        PopupmenuListener listener = new PopupmenuListener();
        if (this.isZoom()) {
            this.zoomInItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"));
            this.zoomInItem.addActionListener(listener);
            this.popupmenu.add(this.zoomInItem);
            this.zoomOutItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"));
            this.zoomOutItem.addActionListener(listener);
            this.popupmenu.add(this.zoomOutItem);
        }
        if (!this.isFixedScale()) {
            this.autoscaleItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Autoscale_menu_item"));
            this.autoscaleItem.addActionListener(listener);
            this.popupmenu.add(this.autoscaleItem);
            this.scaleItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
            this.scaleItem.addActionListener(listener);
            this.popupmenu.add(this.scaleItem);
            this.popupmenu.addSeparator();
        }
        this.snapshotItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.snapshotItem.addActionListener(listener);
        this.popupmenu.add(this.snapshotItem);
        this.popupmenu.addSeparator();
        this.propertiesItem = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        this.propertiesItem.addActionListener(listener);
        this.popupmenu.add(this.propertiesItem);
    }

    public void setAutoscaleMargin(double _autoscaleMargin) {
        if (this.autoscaleMargin == _autoscaleMargin) {
            return;
        }
        this.autoscaleMargin = _autoscaleMargin;
        this.invalidateImage();
    }

    public void setXMarginPercentage(double _percentage) {
        if (this.xLeftMarginPercentage == _percentage && this.xRightMarginPercentage == _percentage) {
            return;
        }
        this.xLeftMarginPercentage = this.xRightMarginPercentage = _percentage;
        this.invalidateImage();
    }

    public void setXMarginPercentage(double _leftPercentage, double _rightPercentage) {
        if (this.xLeftMarginPercentage == _leftPercentage && this.xRightMarginPercentage == _rightPercentage) {
            return;
        }
        this.xLeftMarginPercentage = _leftPercentage;
        this.xRightMarginPercentage = _rightPercentage;
        this.invalidateImage();
    }

    public void setXLeftMarginPercentage(double _percentage) {
        if (this.xLeftMarginPercentage == _percentage) {
            return;
        }
        this.xLeftMarginPercentage = _percentage;
        this.invalidateImage();
    }

    public void setXRightMarginPercentage(double _percentage) {
        if (this.xRightMarginPercentage == _percentage) {
            return;
        }
        this.xRightMarginPercentage = _percentage;
        this.invalidateImage();
    }

    public void setYMarginPercentage(double _percentage) {
        if (this.yTopMarginPercentage == _percentage && this.yBottomMarginPercentage == _percentage) {
            return;
        }
        this.yTopMarginPercentage = this.yBottomMarginPercentage = _percentage;
        this.invalidateImage();
    }

    public void setYMarginPercentage(double _bottomPercentage, double _topPercentage) {
        if (this.yBottomMarginPercentage == _bottomPercentage && this.yTopMarginPercentage == _topPercentage) {
            return;
        }
        this.yTopMarginPercentage = _topPercentage;
        this.yBottomMarginPercentage = _bottomPercentage;
        this.invalidateImage();
    }

    public void setYTopMarginPercentage(double _percentage) {
        if (this.yTopMarginPercentage == _percentage) {
            return;
        }
        this.yTopMarginPercentage = _percentage;
        this.invalidateImage();
    }

    public void setYBottomMarginPercentage(double _percentage) {
        if (this.yBottomMarginPercentage == _percentage) {
            return;
        }
        this.yBottomMarginPercentage = _percentage;
        this.invalidateImage();
    }

    public void setClipAtGutter(boolean clip) {
        if (this.clipAtGutter == clip) {
            return;
        }
        this.clipAtGutter = clip;
        this.invalidateImage();
    }

    public boolean isClipAtGutter() {
        return this.clipAtGutter;
    }

    public void setAdjustableGutter(boolean adjustable) {
        if (this.adjustableGutter == adjustable) {
            return;
        }
        this.adjustableGutter = adjustable;
        this.invalidateImage();
    }

    public boolean isAdjustableGutter() {
        return this.adjustableGutter;
    }

    public void setMouseCursor(Cursor cursor) {
        Container c = this.getTopLevelAncestor();
        this.setCursor(cursor);
        if (c != null) {
            c.setCursor(cursor);
        }
    }

    protected boolean checkWorkingImage() {
        Runnable runImageCheck = new Runnable(){

            @Override
            public void run() {
                DrawingPanel.this.workingImage();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            return this.workingImage();
        }
        try {
            SwingUtilities.invokeAndWait(runImageCheck);
            return true;
        }
        catch (Exception ex) {
            OSPLog.finest("Exception in Check Working Image:" + ex.toString());
            return false;
        }
    }

    private boolean workingImage() {
        Rectangle r = this.getBounds();
        int width = (int)r.getWidth();
        int height = (int)r.getHeight();
        if (width <= 2 || height <= 2) {
            return false;
        }
        if (this.workingImage == null || width != this.workingImage.getWidth() || height != this.workingImage.getHeight()) {
            this.workingImage = this.getGraphicsConfiguration().createCompatibleImage(width, height);
            this.invalidateImage();
        }
        if (this.workingImage == null) {
            this.invalidateImage();
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.isValidImage()) {
            this.render();
        }
    }

    public boolean isIconified() {
        Container c = this.getTopLevelAncestor();
        if (c instanceof Frame) {
            return (((Frame)c).getExtendedState() & 1) == 1;
        }
        return false;
    }

    @Override
    public BufferedImage render() {
        if (!this.isShowing() || this.isIconified()) {
            return this.offscreenImage;
        }
        if (this.buffered && this.checkWorkingImage()) {
            this.validImage = true;
            this.render(this.workingImage);
            BufferedImage temp = this.offscreenImage;
            this.offscreenImage = this.workingImage;
            this.workingImage = temp;
        }
        Runnable doNow = new Runnable(){

            @Override
            public void run() {
                DrawingPanel.this.paintImmediately(DrawingPanel.this.getVisibleRect());
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.paintImmediately(this.getVisibleRect());
            } else {
                SwingUtilities.invokeAndWait(doNow);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.vidCap != null) {
            if (this.buffered) {
                this.vidCap.addFrame(this.offscreenImage);
            } else if (this.vidCap.isRecording()) {
                this.vidCap.addFrame(this.render());
            }
        }
        return this.offscreenImage;
    }

    @Override
    public BufferedImage render(BufferedImage image) {
        Graphics osg = image.getGraphics();
        this.imageRatio = (float)this.getWidth() <= 0.0f ? 1.0f : (float)image.getWidth() / (float)this.getWidth();
        if (osg != null) {
            Rectangle viewRect;
            this.paintEverything(osg);
            if (image == this.workingImage) {
                this.zoomBox.paint(osg);
            }
            if ((viewRect = this.viewRect) != null) {
                Rectangle r = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
                this.glassPanel.setBounds(r);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, r);
                this.glassPanel.render(osg);
                this.glassPanel.setBounds(viewRect);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, viewRect);
            } else {
                this.glassPanel.render(osg);
            }
            osg.dispose();
        }
        this.imageRatio = 1.0;
        return image;
    }

    @Override
    public int getWidth() {
        return (int)(this.imageRatio * (double)super.getWidth());
    }

    @Override
    public int getHeight() {
        return (int)(this.imageRatio * (double)super.getHeight());
    }

    public double getImageRatio() {
        return this.imageRatio;
    }

    public void invalidateImage() {
        this.validImage = false;
    }

    public void validateImage() {
        this.validImage = true;
    }

    protected boolean isValidImage() {
        return this.validImage;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        boolean resetBuffered = this.buffered;
        if (g2.getDeviceConfiguration().getDevice().getType() == 1) {
            this.buffered = false;
        }
        super.paint(g);
        this.buffered = resetBuffered;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (OSPRuntime.disableAllDrawing) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        this.viewRect = this.findViewRect();
        if (this.buffered) {
            if (!this.validImage || this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                if (this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    g.drawImage(this.offscreenImage, 0, 0, null);
                }
                this.refreshTimer.start();
            } else {
                g.drawImage(this.offscreenImage, 0, 0, null);
            }
        } else {
            this.validImage = true;
            this.paintEverything(g);
        }
        this.zoomBox.paint(g);
    }

    protected Rectangle getViewRect() {
        return this.viewRect;
    }

    protected Rectangle findViewRect() {
        Rectangle rect = null;
        Container c = this.getParent();
        while (c != null) {
            if (c instanceof JViewport) {
                rect = ((JViewport)c).getViewRect();
                this.glassPanel.setBounds(rect);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, rect);
                break;
            }
            c = c.getParent();
        }
        return rect;
    }

    protected void computeGutters() {
        Dimension interiorDimension;
        if (this.dimensionSetter != null && (interiorDimension = this.dimensionSetter.getInterior(this)) != null) {
            this.squareAspect = false;
            this.leftGutter = this.rightGutter = Math.max(0, this.getWidth() - interiorDimension.width) / 2;
            this.topGutter = this.bottomGutter = Math.max(0, this.getHeight() - interiorDimension.height) / 2;
        }
    }

    protected void paintFirst(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
    }

    protected void paintLast(Graphics g) {
    }

    protected void paintEverything(Graphics g) {
        this.computeGutters();
        ArrayList<Drawable> tempList = this.getDrawables();
        this.scale(tempList);
        this.setPixelScale();
        if (!OSPRuntime.isMac()) {
            if (this.antialiasTextOn) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            if (this.antialiasShapeOn) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        if (!this.validImage) {
            return;
        }
        this.paintFirst(g);
        if (!this.validImage) {
            return;
        }
        this.paintDrawableList(g, tempList);
        if (!this.validImage) {
            return;
        }
        this.paintLast(g);
    }

    public void setAutoscaleX(boolean autoscale) {
        if (this.autoscaleX == autoscale && this.autoscaleXMax == autoscale && this.autoscaleXMin == autoscale) {
            return;
        }
        this.autoscaleXMax = this.autoscaleXMin = autoscale;
        this.autoscaleX = this.autoscaleXMin;
        this.invalidateImage();
    }

    public boolean isAutoscaleX() {
        return this.autoscaleX;
    }

    public boolean isAutoscaleXMax() {
        return this.autoscaleXMax;
    }

    public boolean isAutoscaleXMin() {
        return this.autoscaleXMin;
    }

    public void setAutoscaleY(boolean autoscale) {
        if (this.autoscaleY == autoscale && this.autoscaleYMax == autoscale && this.autoscaleYMin == autoscale) {
            return;
        }
        this.autoscaleYMax = this.autoscaleYMin = autoscale;
        this.autoscaleY = this.autoscaleYMin;
        this.invalidateImage();
    }

    public boolean isAutoscaleY() {
        return this.autoscaleY;
    }

    public boolean isAutoscaleYMax() {
        return this.autoscaleYMax;
    }

    public boolean isAutoscaleYMin() {
        return this.autoscaleYMin;
    }

    public boolean isLogScaleX() {
        return this.logScaleX;
    }

    public boolean isLogScaleY() {
        return this.logScaleY;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.getBounds().x == x && this.getBounds().y == y && this.getBounds().width == width && this.getBounds().height == height) {
            return;
        }
        super.setBounds(x, y, width, height);
        this.invalidateImage();
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.getBounds().equals(r)) {
            return;
        }
        super.setBounds(r);
        this.invalidateImage();
    }

    public void setBuffered(boolean _buffered) {
        if (this.buffered == _buffered) {
            return;
        }
        this.buffered = _buffered;
        if (this.buffered) {
            this.setDoubleBuffered(false);
        } else {
            this.offscreenImage = this.workingImage = new BufferedImage(1, 1, 1);
            this.setDoubleBuffered(true);
        }
        this.invalidateImage();
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.isVisible() == vis) {
            return;
        }
        super.setVisible(vis);
        this.invalidateImage();
    }

    public void limitAutoscaleX(double floor, double ceil) {
        if (ceil - floor < (double)1.4E-45f) {
            floor = 0.9 * floor - (double)1.4E-45f;
            ceil = 1.1 * ceil + (double)1.4E-45f;
        }
        this.xfloor = floor;
        this.xceil = ceil;
    }

    public void limitAutoscaleY(double floor, double ceil) {
        if (ceil - floor < (double)1.4E-45f) {
            floor = 0.9 * floor - (double)1.4E-45f;
            ceil = 1.1 * ceil + (double)1.4E-45f;
        }
        this.yfloor = floor;
        this.yceil = ceil;
    }

    public void setPixelsPerUnit(boolean enable, double xPixPerUnit, double yPixPerUnit) {
        if (this.fixedPixelPerUnit == enable && this.xPixPerUnit == xPixPerUnit && this.yPixPerUnit == yPixPerUnit) {
            return;
        }
        this.fixedPixelPerUnit = enable;
        this.xPixPerUnit = xPixPerUnit;
        this.yPixPerUnit = yPixPerUnit;
        this.invalidateImage();
    }

    public void setPreferredMinMax(double xmin, double xmax, double ymin, double ymax, boolean invalidateImage) {
        this.autoscaleXMax = false;
        this.autoscaleXMin = false;
        this.autoscaleX = false;
        this.autoscaleYMax = false;
        this.autoscaleYMin = false;
        this.autoscaleY = false;
        if (this.xminPreferred == xmin && this.xmaxPreferred == xmax && this.yminPreferred == ymin && this.ymaxPreferred == ymax) {
            return;
        }
        if (Double.isNaN(xmin)) {
            this.autoscaleXMin = true;
            xmin = this.xminPreferred;
        }
        if (Double.isNaN(xmax)) {
            this.autoscaleXMax = true;
            xmax = this.xmaxPreferred;
        }
        boolean bl = this.autoscaleX = this.autoscaleXMin || this.autoscaleXMax;
        if (xmin == xmax) {
            xmin = 0.9 * xmin - 0.5;
            xmax = 1.1 * xmax + 0.5;
        }
        this.xminPreferred = xmin;
        this.xmaxPreferred = xmax;
        if (Double.isNaN(ymin)) {
            this.autoscaleYMin = true;
            ymin = this.yminPreferred;
        }
        if (Double.isNaN(ymax)) {
            this.autoscaleYMax = true;
            ymax = this.ymaxPreferred;
        }
        boolean bl2 = this.autoscaleY = this.autoscaleYMin || this.autoscaleYMax;
        if (ymin == ymax) {
            ymin = 0.9 * ymin - 0.5;
            ymax = 1.1 * ymax + 0.5;
        }
        this.yminPreferred = ymin;
        this.ymaxPreferred = ymax;
        if (invalidateImage) {
            this.invalidateImage();
        }
    }

    public void setPreferredMinMax(double xmin, double xmax, double ymin, double ymax) {
        this.setPreferredMinMax(xmin, xmax, ymin, ymax, false);
    }

    public void setPreferredMinMaxX(double xmin, double xmax) {
        this.autoscaleXMax = false;
        this.autoscaleXMin = false;
        this.autoscaleX = false;
        if (this.xminPreferred == xmin && this.xmaxPreferred == xmax) {
            return;
        }
        if (Double.isNaN(xmin)) {
            this.autoscaleXMin = true;
            xmin = this.xminPreferred;
        }
        if (Double.isNaN(xmax)) {
            this.autoscaleXMax = true;
            xmax = this.xmaxPreferred;
        }
        boolean bl = this.autoscaleX = this.autoscaleXMin || this.autoscaleXMax;
        if (xmin == xmax) {
            xmin = 0.9 * xmin - 0.5;
            xmax = 1.1 * xmax + 0.5;
        }
        this.xminPreferred = xmin;
        this.xmaxPreferred = xmax;
        this.invalidateImage();
    }

    public void setPreferredMinMaxY(double ymin, double ymax) {
        this.autoscaleYMax = false;
        this.autoscaleYMin = false;
        this.autoscaleY = false;
        if (this.yminPreferred == ymin && this.ymaxPreferred == ymax) {
            return;
        }
        if (Double.isNaN(ymin)) {
            this.autoscaleYMin = true;
            ymin = this.yminPreferred;
        }
        if (Double.isNaN(ymax)) {
            this.autoscaleYMax = true;
            ymax = this.ymaxPreferred;
        }
        boolean bl = this.autoscaleY = this.autoscaleYMin || this.autoscaleYMax;
        if (ymin == ymax) {
            ymin = 0.9 * ymin - 0.5;
            ymax = 1.1 * ymax + 0.5;
        }
        this.yminPreferred = ymin;
        this.ymaxPreferred = ymax;
        this.invalidateImage();
    }

    public void setSquareAspect(boolean val) {
        if (this.squareAspect == val) {
            return;
        }
        this.squareAspect = val;
        this.invalidateImage();
        this.repaint();
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    public void setAntialiasTextOn(boolean on) {
        this.antialiasTextOn = on;
    }

    public boolean isAntialiasTextOn() {
        return this.antialiasTextOn;
    }

    public void setAntialiasShapeOn(boolean on) {
        this.antialiasShapeOn = on;
    }

    public boolean isAntialiasShapeOn() {
        return this.antialiasShapeOn;
    }

    public boolean isPointInside(double x, double y) {
        if (this.xmin < this.xmax) {
            if (x < this.xmin) {
                return false;
            }
            if (x > this.xmax) {
                return false;
            }
        } else {
            if (x > this.xmin) {
                return false;
            }
            if (x < this.xmax) {
                return false;
            }
        }
        if (this.ymin < this.ymax) {
            if (y < this.ymin) {
                return false;
            }
            if (y > this.ymax) {
                return false;
            }
        } else {
            if (y > this.ymin) {
                return false;
            }
            if (y < this.ymax) {
                return false;
            }
        }
        return true;
    }

    public boolean isFixedScale() {
        return this.fixedScale;
    }

    public void setFixedScale(boolean fixed) {
        if (this.fixedScale == fixed) {
            return;
        }
        this.fixedScale = fixed;
        this.buildPopupmenu();
    }

    public boolean isZoom() {
        return this.enableZoom && !this.isFixedScale();
    }

    public void setZoom(boolean _enableZoom) {
        if (this.enableZoom == _enableZoom) {
            return;
        }
        this.enableZoom = _enableZoom;
        this.buildPopupmenu();
    }

    protected void zoomOut() {
        int xPix = (this.zoomBox.xstart + this.zoomBox.xstop) / 2;
        int yPix = (this.zoomBox.ystart + this.zoomBox.ystop) / 2;
        double xCenter = this.pixToX(xPix);
        double yCenter = this.pixToY(yPix);
        double dx = Math.abs(this.xmax - this.xmin);
        double dy = Math.abs(this.ymax - this.ymin);
        this.dxmin = xCenter - dx - this.getXMin();
        this.dxmax = xCenter + dx - this.getXMax();
        this.dymin = yCenter - dy - this.getYMin();
        this.dymax = yCenter + dy - this.getYMax();
        this.zoomCount = 0;
        this.zoomTimer.start();
    }

    public ZoomBox getZoomBox() {
        return this.zoomBox;
    }

    protected void zoomIn() {
        this.dxmin = this.pixToX(Math.min(this.zoomBox.xstart, this.zoomBox.xstop)) - this.getXMin();
        this.dxmax = this.pixToX(Math.max(this.zoomBox.xstart, this.zoomBox.xstop)) - this.getXMax();
        this.dymin = this.pixToY(Math.max(this.zoomBox.ystart, this.zoomBox.ystop)) - this.getYMin();
        this.dymax = this.pixToY(Math.min(this.zoomBox.ystart, this.zoomBox.ystop)) - this.getYMax();
        this.zoomCount = 0;
        this.zoomTimer.start();
    }

    public void snapshot() {
        int h;
        int w = this.isVisible() ? this.getWidth() : this.getPreferredSize().width;
        int n = h = this.isVisible() ? this.getHeight() : this.getPreferredSize().height;
        if (w == 0 || h == 0) {
            return;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        this.render(image);
        MeasuredImage mi = new MeasuredImage(image, this.pixToX(0), this.pixToX(w), this.pixToY(h), this.pixToY(0));
        OSPFrame frame = null;
        try {
            Class<?> c = Class.forName("org.opensourcephysics.frames.ImageFrame");
            Constructor<?>[] constructors = c.getConstructors();
            int i = 0;
            while (i < constructors.length) {
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length == 1 && parameters[0] == MeasuredImage.class) {
                    frame = (OSPFrame)constructors[i].newInstance(mi);
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (frame == null) {
            return;
        }
        frame.setTitle(DisplayRes.getString("Snapshot.Title"));
        frame.setDefaultCloseOperation(2);
        frame.setKeepHidden(false);
        FontSizer.setFonts(frame, FontSizer.getLevel());
        frame.pack();
        frame.setVisible(true);
    }

    public boolean hasInspector() {
        return this.popupmenu != null && this.popupmenu.isEnabled();
    }

    public void enableInspector(boolean isEnabled) {
        this.popupmenu.setEnabled(isEnabled);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.popupmenu = menu;
    }

    public void showInspector() {
        if (this.customInspector == null) {
            XMLDrawingPanelInspector.getInspector(this);
        } else {
            this.customInspector.setVisible(true);
        }
    }

    public void hideInspector() {
        if (this.customInspector == null) {
            DrawingPanelInspector.hideInspector();
        } else {
            this.customInspector.setVisible(false);
        }
    }

    public void setCustomInspector(Window w) {
        if (this.customInspector != null) {
            this.customInspector.setVisible(false);
        }
        this.customInspector = w;
    }

    public void setVideoTool(VideoTool videoCap) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoCap;
        if (this.vidCap != null) {
            this.setBuffered(true);
        }
    }

    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    public double getAspectRatio() {
        return this.pixelMatrix[3] == 1.0 ? 1.0 : Math.abs(this.pixelMatrix[0] / this.pixelMatrix[3]);
    }

    public double getXPixPerUnit() {
        return this.pixelMatrix[0];
    }

    public double getYPixPerUnit() {
        return -this.pixelMatrix[3];
    }

    public double getMaxPixPerUnit() {
        return Math.max(Math.abs(this.pixelMatrix[0]), Math.abs(this.pixelMatrix[3]));
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getPreferredXMin() {
        return this.xminPreferred;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getPreferredXMax() {
        return this.xmaxPreferred;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getPreferredYMax() {
        return this.ymaxPreferred;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getPreferredYMin() {
        return this.yminPreferred;
    }

    public CoordinateStringBuilder getCoordinateStringBuilder() {
        return this.coordinateStrBuilder;
    }

    public void setCoordinateStringBuilder(CoordinateStringBuilder builder) {
        this.coordinateStrBuilder = builder;
    }

    public Rectangle2D getScale() {
        this.setPixelScale();
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public Rectangle2D getMeasure() {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        boolean measurableFound = false;
        ArrayList<Drawable> tempList = this.getDrawables();
        for (Drawable obj : tempList) {
            if (!(obj instanceof Measurable) || !((Measurable)obj).isMeasured()) continue;
            Measurable measurable = (Measurable)obj;
            double gxmax = measurable.getXMax();
            double gxmin = measurable.getXMin();
            if (this.logScaleX && measurable instanceof LogMeasurable) {
                gxmax = ((LogMeasurable)measurable).getXMaxLogscale();
                gxmin = ((LogMeasurable)measurable).getXMinLogscale();
            }
            double gymax = measurable.getYMax();
            double gymin = measurable.getYMin();
            if (this.logScaleY && measurable instanceof LogMeasurable) {
                gymax = ((LogMeasurable)measurable).getYMaxLogscale();
                gymin = ((LogMeasurable)measurable).getYMinLogscale();
            }
            if (Double.isNaN(gxmax) || Double.isNaN(gxmin) || Double.isNaN(gymax) || Double.isNaN(gymin)) continue;
            xmin = Math.min(xmin, gxmin);
            xmax = Math.max(xmax, gxmax);
            ymin = Math.min(ymin, gymin);
            ymax = Math.max(ymax, gymax);
            measurableFound = true;
        }
        if (measurableFound) {
            return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public AffineTransform getPixelTransform() {
        return (AffineTransform)this.pixelTransform.clone();
    }

    public double[] getPixelMatrix() {
        return this.pixelMatrix;
    }

    public void setPixelScale() {
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        this.leftGutter = this.leftGutterPreferred;
        this.topGutter = this.topGutterPreferred;
        this.rightGutter = this.rightGutterPreferred;
        this.bottomGutter = this.bottomGutterPreferred;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.fixedPixelPerUnit) {
            this.xmin = (this.xmaxPreferred + this.xminPreferred) / 2.0 - (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.xmax = (this.xmaxPreferred + this.xminPreferred) / 2.0 + (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.ymin = (this.ymaxPreferred + this.yminPreferred) / 2.0 - (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.ymax = (this.ymaxPreferred + this.yminPreferred) / 2.0 + (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
            this.pixelTransform.getMatrix(this.pixelMatrix);
            return;
        }
        this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter, 1) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter, 1) / (this.ymax - this.ymin);
        if (this.squareAspect) {
            double stretch = Math.abs(this.xPixPerUnit / this.yPixPerUnit);
            if (stretch >= 1.0) {
                stretch = Math.min(stretch, (double)this.width);
                this.xmin = this.xminPreferred - (this.xmaxPreferred - this.xminPreferred) * (stretch - 1.0) / 2.0;
                this.xmax = this.xmaxPreferred + (this.xmaxPreferred - this.xminPreferred) * (stretch - 1.0) / 2.0;
                this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter, 1) / (this.xmax - this.xmin);
            } else {
                stretch = Math.max(stretch, 1.0 / (double)this.height);
                this.ymin = this.yminPreferred - (this.ymaxPreferred - this.yminPreferred) * (1.0 / stretch - 1.0) / 2.0;
                this.ymax = this.ymaxPreferred + (this.ymaxPreferred - this.yminPreferred) * (1.0 / stretch - 1.0) / 2.0;
                this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter, 1) / (this.ymax - this.ymin);
            }
        }
        this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        this.pixelTransform.getMatrix(this.pixelMatrix);
    }

    public void recomputeTransform() {
        this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter, 1) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter, 1) / (this.ymax - this.ymin);
        this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        this.pixelTransform.getMatrix(this.pixelMatrix);
    }

    public double[] project(double[] coordinate, double[] pixel) {
        switch (coordinate.length) {
            case 2: 
            case 3: {
                pixel[0] = this.xToGraphics(coordinate[0]);
                pixel[1] = this.yToGraphics(coordinate[1]);
                break;
            }
            case 4: {
                pixel[0] = this.xToGraphics(coordinate[0]);
                pixel[1] = this.yToGraphics(coordinate[1]);
                pixel[2] = this.xPixPerUnit * coordinate[2];
                pixel[3] = this.yPixPerUnit * coordinate[3];
                break;
            }
            case 6: {
                pixel[0] = this.xToGraphics(coordinate[0]);
                pixel[1] = this.yToGraphics(coordinate[1]);
                pixel[2] = this.xPixPerUnit * coordinate[3];
                pixel[3] = this.yPixPerUnit * coordinate[4];
                break;
            }
            default: {
                throw new IllegalArgumentException("Method project not supported for this length.");
            }
        }
        return pixel;
    }

    public double pixToX(int pix) {
        return this.xmin + (double)(pix - this.leftGutter) / this.xPixPerUnit;
    }

    public int xToPix(double x) {
        double pix = this.pixelMatrix[0] * x + this.pixelMatrix[4];
        if (pix > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (pix < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)pix);
    }

    public float xToGraphics(double x) {
        float pix = (float)(this.pixelMatrix[0] * x + this.pixelMatrix[4]);
        if (pix > 2.1474836E9f) {
            return 2.1474836E9f;
        }
        if (pix < -2.1474836E9f) {
            return -2.1474836E9f;
        }
        return pix;
    }

    public double pixToY(int pix) {
        return this.ymax - (double)(pix - this.topGutter) / this.yPixPerUnit;
    }

    public int yToPix(double y) {
        double pix = this.pixelMatrix[3] * y + this.pixelMatrix[5];
        if (pix > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (pix < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)pix);
    }

    public float yToGraphics(double y) {
        float pix = (float)(this.pixelMatrix[3] * y + this.pixelMatrix[5]);
        if (pix > 2.1474836E9f) {
            return 2.1474836E9f;
        }
        if (pix < -2.1474836E9f) {
            return -2.1474836E9f;
        }
        return pix;
    }

    public void scale() {
        ArrayList<Drawable> tempList = this.getDrawables();
        this.scale(tempList);
    }

    protected void scale(ArrayList<Drawable> tempList) {
        if (this.autoscaleX) {
            this.scaleX(tempList);
        }
        if (this.autoscaleY) {
            this.scaleY(tempList);
        }
    }

    public void measure() {
        ArrayList<Drawable> tempList = this.getDrawables();
        this.scaleX(tempList);
        this.scaleY(tempList);
        this.setPixelScale();
        this.invalidateImage();
    }

    protected void scaleX() {
        ArrayList<Drawable> tempList = this.getDrawables();
        this.scaleX(tempList);
    }

    protected void scaleX(ArrayList<Drawable> tempList) {
        double newXMin = Double.MAX_VALUE;
        double newXMax = -1.7976931348623157E308;
        boolean measurableFound = false;
        for (Drawable obj : tempList) {
            Measurable measurable;
            if (!(obj instanceof Measurable) || !(measurable = (Measurable)obj).isMeasured()) continue;
            double xmi = measurable.getXMin();
            double xma = measurable.getXMax();
            if (this.logScaleX && measurable instanceof LogMeasurable) {
                xmi = ((LogMeasurable)measurable).getXMinLogscale();
                xma = ((LogMeasurable)measurable).getXMaxLogscale();
            }
            if (Double.isNaN(xmi) || Double.isNaN(xma)) continue;
            newXMin = Math.min(newXMin, xmi);
            newXMin = Math.min(newXMin, xma);
            newXMax = Math.max(newXMax, xma);
            newXMax = Math.max(newXMax, xmi);
            measurableFound = true;
        }
        if (measurableFound) {
            if (this.logScaleX && (this.xLeftMarginPercentage > 0.0 || this.xRightMarginPercentage > 0.0)) {
                newXMax *= 1.0 + this.xRightMarginPercentage / 100.0;
                newXMin /= 1.0 + this.xLeftMarginPercentage / 100.0;
            } else if (!this.logScaleX && (this.xLeftMarginPercentage > 0.0 || this.xRightMarginPercentage > 0.0)) {
                double xMed = (newXMin + newXMax) / 2.0;
                double xLen = (newXMax - newXMin) / 2.0;
                newXMax = xMed + xLen * (1.0 + this.xRightMarginPercentage / 100.0);
                newXMin = xMed - xLen * (1.0 + this.xLeftMarginPercentage / 100.0);
            }
            if (newXMax - newXMin < (double)1.4E-45f) {
                newXMin = Double.isNaN(this.xfloor) ? 0.9 * newXMin - 0.5 : Math.min(newXMin, this.xfloor);
                newXMax = Double.isNaN(this.xceil) ? 1.1 * newXMax + 0.5 : Math.max(newXMax, this.xceil);
            }
            double range = Math.max(newXMax - newXMin, (double)1.4E-45f);
            while (Math.abs((newXMax + range) / range) > 100000.0) {
                newXMin -= (range *= 2.0);
                newXMax += range;
            }
            if (this.autoscaleXMin) {
                this.xminPreferred = newXMin - this.autoscaleMargin * range;
            }
            if (this.autoscaleXMax) {
                this.xmaxPreferred = newXMax + this.autoscaleMargin * range;
            }
        } else {
            if (!Double.isNaN(this.xfloor) && this.autoscaleXMin) {
                this.xminPreferred = this.xfloor;
            }
            if (!Double.isNaN(this.xceil) && this.autoscaleXMax) {
                this.xmaxPreferred = this.xceil;
            }
        }
        if (!Double.isNaN(this.xfloor)) {
            this.xminPreferred = Math.min(this.xfloor, this.xminPreferred);
        }
        if (!Double.isNaN(this.xceil)) {
            this.xmaxPreferred = Math.max(this.xceil, this.xmaxPreferred);
        }
        if (Math.abs(this.xmaxPreferred - this.xminPreferred) < (double)1.4E-45f) {
            this.xminPreferred = 0.9 * this.xmaxPreferred - (double)1.4E-45f;
            this.xmaxPreferred = 1.1 * this.xmaxPreferred + (double)1.4E-45f;
        }
    }

    protected void scaleY() {
        ArrayList<Drawable> tempList = this.getDrawables();
        this.scaleY(tempList);
    }

    protected void scaleY(ArrayList<Drawable> tempList) {
        double newYMin = Double.MAX_VALUE;
        double newYMax = -1.7976931348623157E308;
        boolean measurableFound = false;
        for (Drawable obj : tempList) {
            Measurable measurable;
            if (!(obj instanceof Measurable) || !(measurable = (Measurable)obj).isMeasured()) continue;
            double ymi = measurable.getYMin();
            double yma = measurable.getYMax();
            if (this.logScaleY && measurable instanceof LogMeasurable) {
                yma = ((LogMeasurable)measurable).getYMaxLogscale();
                ymi = ((LogMeasurable)measurable).getYMinLogscale();
            }
            if (Double.isNaN(ymi) || Double.isNaN(yma)) continue;
            newYMin = Math.min(newYMin, ymi);
            newYMin = Math.min(newYMin, yma);
            newYMax = Math.max(newYMax, yma);
            newYMax = Math.max(newYMax, ymi);
            measurableFound = true;
        }
        if (measurableFound) {
            if (this.logScaleY && (this.yTopMarginPercentage > 0.0 || this.yBottomMarginPercentage > 0.0)) {
                newYMax *= 1.0 + this.yTopMarginPercentage / 100.0;
                newYMin /= 1.0 + this.yBottomMarginPercentage / 100.0;
            } else if (!this.logScaleY && (this.yTopMarginPercentage > 0.0 || this.yBottomMarginPercentage > 0.0)) {
                double yMed = (newYMin + newYMax) / 2.0;
                double yLen = (newYMax - newYMin) / 2.0;
                newYMax = yMed + yLen * (1.0 + this.yTopMarginPercentage / 100.0);
                newYMin = yMed - yLen * (1.0 + this.yBottomMarginPercentage / 100.0);
            }
            if (newYMax - newYMin < (double)1.4E-45f) {
                newYMin = Double.isNaN(this.yfloor) ? 0.9 * newYMin - 0.5 : Math.min(newYMin, this.yfloor);
                newYMax = Double.isNaN(this.yceil) ? 1.1 * newYMax + 0.5 : Math.max(newYMax, this.yceil);
            }
            double range = Math.max(newYMax - newYMin, (double)1.4E-45f);
            while (Math.abs((newYMax + range) / range) > 100000.0) {
                newYMin -= (range *= 2.0);
                newYMax += range;
            }
            if (this.autoscaleYMin) {
                this.yminPreferred = newYMin - this.autoscaleMargin * range;
            }
            if (this.autoscaleYMax) {
                this.ymaxPreferred = newYMax + this.autoscaleMargin * range;
            }
        } else {
            if (!Double.isNaN(this.yfloor) && this.autoscaleYMin) {
                this.yminPreferred = this.yfloor;
            }
            if (!Double.isNaN(this.yceil) && this.autoscaleYMax) {
                this.ymaxPreferred = this.yceil;
            }
        }
        if (!Double.isNaN(this.yfloor)) {
            this.yminPreferred = Math.min(this.yfloor, this.yminPreferred);
        }
        if (!Double.isNaN(this.yceil)) {
            this.ymaxPreferred = Math.max(this.yceil, this.ymaxPreferred);
        }
        if (Math.abs(this.ymaxPreferred - this.yminPreferred) < (double)1.4E-45f) {
            this.yminPreferred = 0.9 * this.ymaxPreferred - (double)1.4E-45f;
            this.ymaxPreferred = 1.1 * this.ymaxPreferred + (double)1.4E-45f;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void paintDrawableList(Graphics g, ArrayList<Drawable> tempList) {
        block4: {
            if (tempList == null) {
                return;
            }
            g2 = (Graphics2D)g;
            it = tempList.iterator();
            clipShape = g2.getClip();
            w = this.getWidth() - this.leftGutter - this.rightGutter;
            h = this.getHeight() - this.bottomGutter - this.topGutter;
            if (w < 0 || h < 0) {
                return;
            }
            if (this.clipAtGutter) {
                g2.clipRect(this.leftGutter, this.topGutter, w, h);
            }
            if (tempList.isEmpty() || !(tempList.get(0) instanceof False3D)) ** GOTO lbl18
            tempList.get(0).draw(this, g2);
            break block4;
            while (this.validImage) {
                drawable = it.next();
                drawable.draw(this, g2);
lbl18:
                // 2 sources

                if (it.hasNext()) continue;
            }
        }
        g2.setClip(clipShape);
    }

    public JPanel getGlassPanel() {
        return this.glassPanel;
    }

    @Override
    public void setIgnoreRepaint(boolean ignoreRepaint) {
        super.setIgnoreRepaint(ignoreRepaint);
        this.glassPanel.setIgnoreRepaint(ignoreRepaint);
    }

    public Dimensioned getDimensionSetter() {
        return this.dimensionSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawable(Drawable drawable) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            if (drawable != null && !this.drawableList.contains(drawable)) {
                this.drawableList.add(drawable);
                this.invalidateImage();
            }
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = (Dimensioned)((Object)drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawables(Collection<Drawable> drawables) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            for (Drawable obj : drawables) {
                if (!(obj instanceof Drawable)) continue;
                this.addDrawable(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawableAtIndex(int index, Drawable drawable) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            if (drawable != null && !this.drawableList.contains(drawable)) {
                this.drawableList.add(index, drawable);
                this.invalidateImage();
            }
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = (Dimensioned)((Object)drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDrawable(Drawable oldDrawable, Drawable newDrawable) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            if (oldDrawable != null && this.drawableList.contains(oldDrawable)) {
                int i = this.drawableList.indexOf(oldDrawable);
                this.drawableList.set(i, newDrawable);
                if (newDrawable instanceof Dimensioned) {
                    this.dimensionSetter = (Dimensioned)((Object)newDrawable);
                }
            } else {
                this.addDrawable(newDrawable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDrawable(Drawable drawable) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            this.drawableList.remove(drawable);
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> void removeObjectsOfClass(Class<T> c) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            Iterator<Drawable> it = this.drawableList.iterator();
            while (it.hasNext()) {
                Drawable element = it.next();
                if (element.getClass() != c) continue;
                it.remove();
                if (!(element instanceof Dimensioned)) continue;
                this.dimensionSetter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> void removeDrawables(Class<T> c) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            Iterator<Drawable> it = this.drawableList.iterator();
            while (it.hasNext()) {
                Drawable element = it.next();
                if (!c.isInstance(element)) continue;
                it.remove();
                if (!(element instanceof Dimensioned)) continue;
                this.dimensionSetter = null;
            }
        }
    }

    public void removeOptionController() {
        this.removeMouseListener(this.optionController);
        this.removeMouseMotionListener(this.optionController);
    }

    public void addOptionController() {
        this.addMouseListener(this.optionController);
        this.addMouseMotionListener(this.optionController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            this.drawableList.clear();
        }
        this.dimensionSetter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            return new ArrayList<Drawable>(this.drawableList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> ArrayList<T> getDrawables(Class<T> type) {
        ArrayList<Drawable> all = null;
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            all = new ArrayList<Drawable>(this.drawableList);
        }
        ArrayList<Drawable> objects = new ArrayList<Drawable>();
        for (Drawable d : all) {
            if (!type.isInstance(d)) continue;
            objects.add((Drawable)type.cast(d));
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> ArrayList<T> getObjectOfClass(Class<T> type) {
        ArrayList<Drawable> all = null;
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            all = new ArrayList<Drawable>(this.drawableList);
        }
        ArrayList<Drawable> objects = new ArrayList<Drawable>();
        for (Drawable d : all) {
            if (d.getClass() != type) continue;
            objects.add((Drawable)type.cast(d));
        }
        return objects;
    }

    public int[] getGutters() {
        return new int[]{this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter};
    }

    public void setGutters(int[] gutters) {
        this.leftGutter = gutters[0];
        this.topGutter = gutters[1];
        this.rightGutter = gutters[2];
        this.bottomGutter = gutters[3];
    }

    public void setGutters(int left, int top, int right, int bottom) {
        this.leftGutter = left;
        this.topGutter = top;
        this.rightGutter = right;
        this.bottomGutter = bottom;
    }

    public void setPreferredGutters(int left, int top, int right, int bottom) {
        this.leftGutterPreferred = this.leftGutter = left;
        this.topGutterPreferred = this.topGutter = top;
        this.rightGutterPreferred = this.rightGutter = right;
        this.bottomGutterPreferred = this.bottomGutter = bottom;
    }

    public void resetGutters() {
        this.leftGutter = this.leftGutterPreferred;
        this.topGutter = this.topGutterPreferred;
        this.rightGutter = this.rightGutterPreferred;
        this.bottomGutter = this.bottomGutterPreferred;
    }

    public int getBottomGutter() {
        return this.bottomGutter;
    }

    public int getTopGutter() {
        return this.topGutter;
    }

    public int getLeftGutter() {
        return this.leftGutter;
    }

    public int getRightGutter() {
        return this.rightGutter;
    }

    public void setMessage(String msg) {
        this.brMessageBox.setText(msg);
    }

    public void setMessage(String msg, int location) {
        switch (location) {
            case 0: {
                this.blMessageBox.setText(msg);
                break;
            }
            case 1: {
                this.brMessageBox.setText(msg);
                break;
            }
            case 2: {
                this.trMessageBox.setText(msg);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(msg);
            }
        }
    }

    public void setShowCoordinates(boolean show) {
        if (this.showCoordinates && !show) {
            this.removeMouseListener(this.mouseController);
            this.removeMouseMotionListener(this.mouseController);
        } else if (!this.showCoordinates && show) {
            this.addMouseListener(this.mouseController);
            this.addMouseMotionListener(this.mouseController);
        }
        this.showCoordinates = show;
    }

    public boolean isZoomEvent(MouseEvent e) {
        return OSPRuntime.isPopupTrigger(e);
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingPanelLoader();
    }

    private class CMController
    extends MouseInputAdapter {
        private CMController() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            String s = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, e);
            DrawingPanel.this.blMessageBox.setText(s);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DrawingPanel.this.blMessageBox.setText(null);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (DrawingPanel.this.showCoordinates) {
                DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            String s = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, e);
            DrawingPanel.this.blMessageBox.setText(s);
        }
    }

    static class DrawingPanelLoader
    implements XML.ObjectLoader {
        DrawingPanelLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DrawingPanel panel = (DrawingPanel)obj;
            control.setValue("preferred x min", panel.getPreferredXMin());
            control.setValue("preferred x max", panel.getPreferredXMax());
            control.setValue("preferred y min", panel.getPreferredYMin());
            control.setValue("preferred y max", panel.getPreferredYMax());
            control.setValue("autoscale x", panel.isAutoscaleX());
            control.setValue("autoscale y", panel.isAutoscaleY());
            control.setValue("square aspect", panel.isSquareAspect());
            control.setValue("drawables", panel.getDrawables());
        }

        @Override
        public Object createObject(XMLControl control) {
            DrawingPanel panel = new DrawingPanel();
            double xmin = control.getDouble("preferred x min");
            double xmax = control.getDouble("preferred x max");
            double ymin = control.getDouble("preferred y min");
            double ymax = control.getDouble("preferred y max");
            panel.setPreferredMinMax(xmin, xmax, ymin, ymax);
            if (control.getBoolean("autoscale x")) {
                panel.setAutoscaleX(true);
            }
            if (control.getBoolean("autoscale y")) {
                panel.setAutoscaleY(true);
            }
            return panel;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Collection drawables;
            DrawingPanel panel = (DrawingPanel)obj;
            double xmin = control.getDouble("preferred x min");
            double xmax = control.getDouble("preferred x max");
            double ymin = control.getDouble("preferred y min");
            double ymax = control.getDouble("preferred y max");
            panel.setPreferredMinMax(xmin, xmax, ymin, ymax);
            panel.squareAspect = control.getBoolean("square aspect");
            if (control.getBoolean("autoscale x")) {
                panel.setAutoscaleX(true);
            }
            if (control.getBoolean("autoscale y")) {
                panel.setAutoscaleY(true);
            }
            if ((drawables = (Collection)Collection.class.cast(control.getObject("drawables"))) != null) {
                panel.clear();
                Iterator it = drawables.iterator();
                while (it.hasNext()) {
                    panel.addDrawable((Drawable)it.next());
                }
            }
            return obj;
        }
    }

    class GlassPanel
    extends JPanel {
        GlassPanel() {
        }

        public void render(Graphics g) {
            try {
                Component[] c = DrawingPanel.this.glassPanelLayout.getComponents();
                int i = 0;
                int n = c.length;
                while (i < n) {
                    if (c[i] != null) {
                        g.translate(c[i].getX(), c[i].getY());
                        c[i].print(g);
                        g.translate(-c[i].getX(), -c[i].getY());
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class OptionController
    extends MouseInputAdapter {
        OptionController() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DrawingPanel.this.isZoomEvent(e)) {
                DrawingPanel.this.zoomBox.startZoom(e.getX(), e.getY());
            } else {
                DrawingPanel.this.zoomBox.visible = false;
                DrawingPanel.this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DrawingPanel.this.zoomBox.drag(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (DrawingPanel.this.isZoomEvent(e) && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                JPopupMenu popup;
                if (DrawingPanel.this.isZoom() && !DrawingPanel.this.zoomBox.isDragged() && DrawingPanel.this.zoomBox.showUndraggedBox) {
                    Dimension dim = DrawingPanel.this.viewRect == null ? DrawingPanel.this.getSize() : DrawingPanel.this.viewRect.getSize();
                    dim.width -= DrawingPanel.this.getLeftGutter() + DrawingPanel.this.getRightGutter();
                    dim.height -= DrawingPanel.this.getTopGutter() + DrawingPanel.this.getBottomGutter();
                    DrawingPanel.this.zoomBox.xstart = e.getX() - dim.width / 4;
                    DrawingPanel.this.zoomBox.xstop = e.getX() + dim.width / 4;
                    DrawingPanel.this.zoomBox.ystart = e.getY() - dim.height / 4;
                    DrawingPanel.this.zoomBox.ystop = e.getY() + dim.height / 4;
                    DrawingPanel.this.zoomBox.visible = true;
                    DrawingPanel.this.repaint();
                }
                if ((popup = DrawingPanel.this.getPopupMenu()) != null) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
                return;
            }
            if (OSPRuntime.isPopupTrigger(e) && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                DrawingPanel.this.customInspector.setVisible(true);
                return;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            KeyboardFocusManager focuser = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focusOwner = focuser.getFocusOwner();
            if (focusOwner != null && !(focusOwner instanceof JTextComponent)) {
                DrawingPanel.this.requestFocusInWindow();
            }
        }
    }

    class PopupmenuListener
    implements ActionListener {
        PopupmenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DrawingPanel.this.zoomBox.visible = false;
            DrawingPanel.this.repaint();
            String cmd = evt.getActionCommand();
            if (cmd.equals(DisplayRes.getString("DrawingFrame.InspectMenuItem"))) {
                DrawingPanel.this.showInspector();
            } else if (cmd.equals(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"))) {
                DrawingPanel.this.snapshot();
            } else if (cmd.equals(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"))) {
                DrawingPanel.this.setAutoscaleX(false);
                DrawingPanel.this.setAutoscaleY(false);
                DrawingPanel.this.zoomIn();
            } else if (cmd.equals(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"))) {
                DrawingPanel.this.setAutoscaleX(false);
                DrawingPanel.this.setAutoscaleY(false);
                DrawingPanel.this.zoomOut();
            } else if (cmd.equals(DisplayRes.getString("DrawingFrame.Autoscale_menu_item"))) {
                double nan = Double.NaN;
                DrawingPanel.this.setPreferredMinMax(nan, nan, nan, nan);
            } else if (cmd.equals(DisplayRes.getString("DrawingFrame.Scale_menu_item"))) {
                ScaleInspector plotInspector = new ScaleInspector(DrawingPanel.this);
                plotInspector.setLocationRelativeTo(DrawingPanel.this);
                plotInspector.updateDisplay();
                FontSizer.setFonts(plotInspector, FontSizer.getLevel());
                plotInspector.pack();
                plotInspector.setVisible(true);
            }
        }
    }

    public class ZoomBox {
        int xstart;
        int ystart;
        int xstop;
        int ystop;
        int xlast;
        int ylast;
        boolean visible = false;
        boolean dragged = false;
        boolean showUndraggedBox = true;

        public void startZoom(int xpix, int ypix) {
            if (!DrawingPanel.this.isZoom()) {
                return;
            }
            this.visible = true;
            this.dragged = false;
            this.xstop = this.xstart = xpix;
            this.xlast = this.xstart;
            this.ystop = this.ystart = ypix;
            this.ylast = this.ystart;
            DrawingPanel.this.repaint();
        }

        public void hide() {
            this.visible = false;
            DrawingPanel.this.repaint();
        }

        public void setShowUndraggedBox(boolean show) {
            this.showUndraggedBox = show;
        }

        public void drag(int xpix, int ypix) {
            if (!this.visible) {
                return;
            }
            this.dragged = true;
            this.xstop = xpix;
            this.ystop = ypix;
            Graphics g = DrawingPanel.this.getGraphics();
            if (g == null) {
                return;
            }
            g.setXORMode(Color.green);
            g.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            this.xlast = this.xstop;
            this.ylast = this.ystop;
            g.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            g.setPaintMode();
            g.dispose();
        }

        void paint(Graphics g) {
            if (!this.visible) {
                return;
            }
            if (this.xstop == this.xstart || this.ystop == this.ystart) {
                return;
            }
            g.setColor(Color.magenta);
            g.drawRect(Math.min(this.xstart, this.xstop), Math.min(this.ystart, this.ystop), Math.abs(this.xstop - this.xstart), Math.abs(this.ystop - this.ystart));
        }

        public boolean isDragged() {
            return this.dragged && this.xstop != this.xstart && this.ystop != this.ystart;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public Rectangle reportZoom() {
            int xmin = Math.min(this.xstart, this.xstop);
            int xmax = Math.max(this.xstart, this.xstop);
            int ymin = Math.min(this.ystart, this.ystop);
            int ymax = Math.max(this.ystart, this.ystop);
            return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        }
    }
}

