/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.Trail;
import org.opensourcephysics.display.axes.XAxis;

public class ComplexDataset
extends AbstractTableModel
implements Drawable,
Measurable,
Data {
    static final double PI2 = Math.PI * 2;
    public static final int AMP_CURVE = 0;
    public static final int RE_IM_CURVE = 1;
    public static final int PHASE_CURVE = 2;
    public static final int PHASE_BAR = 3;
    public static final int PHASE_POST = 4;
    protected boolean visible = true;
    protected boolean measurable = true;
    protected double[] xpoints;
    protected double[] re_points;
    protected double[] im_points;
    protected double[] amp_points;
    protected int index;
    private int markerShape = 2;
    private int markerSize = 5;
    private boolean centered = true;
    private boolean showPhase = true;
    private double xmin;
    private double xmax;
    private double ampmin;
    private double ampmax;
    private double remax;
    private double remin;
    private double immax;
    private double immin;
    private boolean sorted = false;
    private boolean connected = true;
    private int initialSize;
    private Color lineColor = Color.black;
    private GeneralPath ampPath;
    private Trail reTrail = new Trail();
    private Trail imTrail = new Trail();
    private String name = "Complex Data";
    private String xColumnName = "x";
    private String reColumnName = "re";
    private String imColumnName = "im";
    private int stride = 1;
    private AffineTransform flip;
    Dataset reDataset;
    Dataset imDataset;
    int datasetID = this.hashCode();

    public ComplexDataset() {
        this.reTrail.color = Color.RED;
        this.imTrail.color = Color.BLUE;
        this.initialSize = 10;
        this.xColumnName = "x";
        this.reColumnName = "re";
        this.imColumnName = "im";
        this.ampPath = new GeneralPath();
        this.index = 0;
        this.flip = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        this.clear();
    }

    public JFrame showLegend() {
        InteractivePanel panel = new InteractivePanel();
        panel.setPreferredGutters(5, 5, 5, 25);
        DrawingFrame frame = new DrawingFrame(DisplayRes.getString("GUIUtils.PhaseLegend"), panel);
        frame.setDefaultCloseOperation(2);
        frame.setJMenuBar(null);
        panel.addDrawable(new Phase());
        XAxis xaxis = new XAxis(DisplayRes.getString("ComplexDataset.Legend.XAxis"));
        xaxis.setLocationType(2);
        xaxis.setEnabled(true);
        panel.setClipAtGutter(false);
        panel.addDrawable(xaxis);
        panel.setSquareAspect(false);
        panel.setPreferredMinMax(-Math.PI, Math.PI, -1.0, 1.0);
        frame.setSize(300, 120);
        frame.setVisible(true);
        return frame;
    }

    @Override
    public boolean isMeasured() {
        if (this.index < 1) {
            return false;
        }
        return this.measurable;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        if (this.markerShape == 1) {
            return -this.ampmax;
        }
        if (this.centered && (this.markerShape == 3 || this.markerShape == 2)) {
            return -this.ampmax / 2.0;
        }
        return 0.0;
    }

    @Override
    public double getYMax() {
        if (this.markerShape == 1) {
            return this.ampmax;
        }
        if (this.centered && (this.markerShape == 3 || this.markerShape == 2)) {
            return this.ampmax / 2.0;
        }
        if (this.markerShape == 4) {
            return 1.1 * this.ampmax;
        }
        return this.ampmax;
    }

    public double[] getXPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.xpoints, 0, temp, 0, this.index);
        return temp;
    }

    public double[] getRePoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.re_points, 0, temp, 0, this.index);
        return temp;
    }

    public double[] getImPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.im_points, 0, temp, 0, this.index);
        return temp;
    }

    public double[] getYPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.amp_points, 0, temp, 0, this.index);
        return temp;
    }

    public double[][] getPoints() {
        double[][] temp = new double[this.index][3];
        int i = 0;
        while (i < this.index) {
            temp[i] = new double[]{this.xpoints[i], this.re_points[i], this.im_points[i]};
            ++i;
        }
        return temp;
    }

    public void setMarkerShape(int _markerShape) {
        this.markerShape = _markerShape;
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int size) {
        this.markerSize = size;
    }

    public void setSorted(boolean _sorted) {
        this.sorted = _sorted;
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void setStride(int _stride) {
        this.stride = _stride;
        this.stride = Math.max(1, this.stride);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setMeasurable(boolean b) {
        this.measurable = b;
    }

    public boolean getMeasurable() {
        return this.measurable;
    }

    public void setConnected(boolean _connected) {
        this.connected = _connected;
    }

    public void setCentered(boolean _centered) {
        this.centered = _centered;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setLineColor(Color _lineColor) {
        this.reTrail.color = this.lineColor = _lineColor;
        this.imTrail.color = this.lineColor;
    }

    public void setLineColor(Color reColor, Color imColor) {
        this.lineColor = reColor;
        this.reTrail.color = reColor;
        this.imTrail.color = imColor;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{this.lineColor, this.lineColor};
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.lineColor, this.lineColor};
    }

    public Color getFillColor() {
        return this.lineColor;
    }

    public void setXYColumnNames(String _xColumnName, String _reColumnName, String _imColumnName) {
        this.xColumnName = TeXParser.parseTeX(_xColumnName);
        this.reColumnName = TeXParser.parseTeX(_reColumnName);
        this.imColumnName = TeXParser.parseTeX(_imColumnName);
    }

    public void setXYColumnNames(String _xColumnName, String _reColumnName, String _imColumnName, String datasetName) {
        this.setXYColumnNames(_xColumnName, _reColumnName, _imColumnName);
        this.name = TeXParser.parseTeX(datasetName);
    }

    public void append(double x, double re, double im) {
        if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(re) || Double.isInfinite(re) || Double.isNaN(im) || Double.isInfinite(im)) {
            return;
        }
        if (this.index >= this.xpoints.length) {
            this.setCapacity(this.xpoints.length * 2);
        }
        this.xpoints[this.index] = x;
        this.re_points[this.index] = re;
        this.im_points[this.index] = im;
        double amp = Math.sqrt(re * re + im * im);
        if (this.index == 0) {
            this.ampPath.moveTo((float)x, (float)amp);
        } else {
            this.ampPath.lineTo((float)x, (float)amp);
        }
        this.reTrail.addPoint(x, re);
        this.imTrail.addPoint(x, im);
        this.xmax = Math.max(x, this.xmax);
        this.xmin = Math.min(x, this.xmin);
        this.remin = Math.min(re, this.remin);
        this.remax = Math.max(re, this.remax);
        this.immin = Math.min(im, this.immin);
        this.immax = Math.max(im, this.immax);
        this.ampmin = Math.min(amp, this.ampmin);
        this.ampmax = Math.max(amp, this.ampmax);
        ++this.index;
        if (this.sorted && this.index > 1 && x < this.xpoints[this.index - 2]) {
            this.moveDatum(this.index - 1);
            this.recalculatePath();
        }
    }

    public void append(double[] _xpoints, double[] _repoints, double[] _impoints) {
        if (_xpoints == null) {
            return;
        }
        if (_repoints == null || _impoints == null || _xpoints.length != _repoints.length || _xpoints.length != _impoints.length) {
            throw new IllegalArgumentException("Array lenghts must be equal to append data.");
        }
        boolean badData = false;
        int i = 0;
        while (i < _xpoints.length) {
            if (Double.isNaN(_xpoints[i]) || Double.isInfinite(_xpoints[i]) || Double.isNaN(_repoints[i]) || Double.isInfinite(_repoints[i]) || Double.isNaN(_impoints[i]) || Double.isInfinite(_impoints[i])) {
                badData = true;
            } else {
                this.xmax = Math.max(_xpoints[i], this.xmax);
                this.xmin = Math.min(_xpoints[i], this.xmin);
                this.remin = Math.min(_repoints[i], this.remin);
                this.remax = Math.max(_repoints[i], this.remax);
                this.immin = Math.min(_impoints[i], this.immin);
                this.immax = Math.max(_impoints[i], this.immax);
                double amp = Math.sqrt(_repoints[i] * _repoints[i] + _impoints[i] * _impoints[i]);
                this.ampmin = Math.min(amp, this.ampmin);
                this.ampmax = Math.max(amp, this.ampmax);
                if (this.index == 0 && i == 0) {
                    this.ampPath.moveTo((float)_xpoints[i], (float)amp);
                } else {
                    this.ampPath.lineTo((float)_xpoints[i], (float)amp);
                }
                this.reTrail.addPoint(_xpoints[i], _repoints[i]);
                this.imTrail.addPoint(_xpoints[i], _impoints[i]);
            }
            ++i;
        }
        int pointsAdded = _xpoints.length;
        int availableSpots = this.xpoints.length - this.index;
        if (pointsAdded > availableSpots) {
            this.setCapacity(2 * (this.xpoints.length + pointsAdded));
        }
        System.arraycopy(_xpoints, 0, this.xpoints, this.index, pointsAdded);
        System.arraycopy(_repoints, 0, this.re_points, this.index, pointsAdded);
        System.arraycopy(_impoints, 0, this.im_points, this.index, pointsAdded);
        this.index += pointsAdded;
        if (badData) {
            this.cleanBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void append(double[] _xpoints, double[] _zpoints) {
        if (_xpoints == null) {
            return;
        }
        if (_zpoints == null || 2 * _xpoints.length != _zpoints.length) {
            throw new IllegalArgumentException("Length of z array must be twice the length of the x array.");
        }
        boolean badData = false;
        int pointsAdded = _xpoints.length;
        int availableSpots = this.xpoints.length - this.index;
        if (pointsAdded > availableSpots) {
            this.setCapacity(2 * (this.xpoints.length + pointsAdded));
        }
        int i = 0;
        while (i < _xpoints.length) {
            if (Double.isNaN(_xpoints[i]) || Double.isInfinite(_xpoints[i]) || Double.isNaN(_zpoints[2 * i]) || Double.isInfinite(_zpoints[2 * i]) || Double.isNaN(_zpoints[2 * i + 1]) || Double.isInfinite(_zpoints[2 * i + 1])) {
                badData = true;
            } else {
                this.xmax = Math.max(_xpoints[i], this.xmax);
                this.xmin = Math.min(_xpoints[i], this.xmin);
                this.remin = Math.min(_zpoints[2 * i], this.remin);
                this.remax = Math.max(_zpoints[2 * i], this.remax);
                this.immin = Math.min(_zpoints[2 * i + 1], this.immin);
                this.immax = Math.max(_zpoints[2 * i + 1], this.immax);
                double amp = Math.sqrt(_zpoints[2 * i] * _zpoints[2 * i] + _zpoints[2 * i + 1] * _zpoints[2 * i + 1]);
                this.ampmin = Math.min(amp, this.ampmin);
                this.ampmax = Math.max(amp, this.ampmax);
                this.xpoints[this.index + i] = _xpoints[i];
                this.re_points[this.index + i] = _zpoints[2 * i];
                this.im_points[this.index + i] = _zpoints[2 * i + 1];
                if (this.index == 0 && i == 0) {
                    this.ampPath.moveTo((float)_xpoints[i], (float)amp);
                } else {
                    this.ampPath.lineTo((float)_xpoints[i], (float)amp);
                }
                this.reTrail.addPoint(_xpoints[i], _zpoints[2 * i]);
                this.imTrail.addPoint(_xpoints[i], _zpoints[2 * i + 1]);
            }
            ++i;
        }
        this.index += pointsAdded;
        if (badData) {
            this.cleanBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    private void cleanBadData() {
        int i = 0;
        while (i < this.index) {
            if (Double.isNaN(this.xpoints[i]) || Double.isInfinite(this.xpoints[i]) || Double.isNaN(this.re_points[i]) || Double.isInfinite(this.re_points[i]) || Double.isNaN(this.im_points[i]) || Double.isInfinite(this.im_points[i])) {
                if (this.index == 1 || i == this.index - 1) {
                    --this.index;
                    break;
                }
                System.arraycopy(this.xpoints, i + 1, this.xpoints, i, this.index - i - 1);
                System.arraycopy(this.re_points, i + 1, this.re_points, i, this.index - i - 1);
                System.arraycopy(this.im_points, i + 1, this.im_points, i, this.index - i - 1);
                --this.index;
            }
            ++i;
        }
    }

    private void setCapacity(int newCapacity) {
        double[] tempx = this.xpoints;
        this.xpoints = new double[newCapacity];
        System.arraycopy(tempx, 0, this.xpoints, 0, tempx.length);
        double[] tempre = this.re_points;
        this.re_points = new double[newCapacity];
        System.arraycopy(tempre, 0, this.re_points, 0, tempre.length);
        double[] tempim = this.im_points;
        this.im_points = new double[newCapacity];
        System.arraycopy(tempim, 0, this.im_points, 0, tempim.length);
        double[] tempamp = this.amp_points;
        this.amp_points = new double[newCapacity];
        System.arraycopy(tempamp, 0, this.amp_points, 0, tempamp.length);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        switch (this.markerShape) {
            case 0: {
                this.drawLinePlot(drawingPanel, g2);
                break;
            }
            case 1: {
                this.drawReImPlot(drawingPanel, g2);
                break;
            }
            case 2: {
                this.drawPhaseCurve(drawingPanel, g2);
                break;
            }
            case 3: {
                this.drawPhaseBars(drawingPanel, g2);
                break;
            }
            case 4: {
                this.drawPhasePosts(drawingPanel, g2);
            }
        }
    }

    public void clear() {
        this.index = 0;
        this.xpoints = new double[this.initialSize];
        this.re_points = new double[this.initialSize];
        this.im_points = new double[this.initialSize];
        this.amp_points = new double[this.initialSize];
        this.ampPath.reset();
        this.reTrail.clear();
        this.imTrail.clear();
        this.resetXYMinMax();
    }

    public String toString() {
        if (this.index == 0) {
            return "Dataset empty.";
        }
        String s = String.valueOf(this.xpoints[0]) + "\t" + this.re_points[0] + "\t" + this.im_points[0] + "\n";
        StringBuffer b = new StringBuffer(this.index * s.length());
        int i = 0;
        while (i < this.index) {
            b.append(this.xpoints[i]);
            b.append('\t');
            b.append(this.re_points[i]);
            b.append('\t');
            b.append(this.im_points[i]);
            b.append('\n');
            ++i;
        }
        return b.toString();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return (this.index + this.stride - 1) / this.stride;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.xColumnName;
            }
            case 1: {
                return this.reColumnName;
            }
            case 2: {
                return this.imColumnName;
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        rowIndex *= this.stride;
        switch (columnIndex) {
            case 0: {
                return new Double(this.xpoints[rowIndex]);
            }
            case 1: {
                return new Double(this.re_points[rowIndex]);
            }
            case 2: {
                return new Double(this.im_points[rowIndex]);
            }
        }
        return new Double(0.0);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    private void resetXYMinMax() {
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.remax = -1.7976931348623157E308;
        this.remin = Double.MAX_VALUE;
        this.immax = -1.7976931348623157E308;
        this.immin = Double.MAX_VALUE;
        this.ampmax = -1.7976931348623157E308;
        this.ampmin = Double.MAX_VALUE;
        int i = 0;
        while (i < this.index) {
            this.xmin = Math.min(this.xpoints[i], this.xmin);
            this.xmax = Math.max(this.xpoints[i], this.xmax);
            this.remax = Math.max(this.re_points[i], this.remax);
            this.remin = Math.min(this.re_points[i], this.remin);
            this.immax = Math.max(this.im_points[i], this.immax);
            this.immin = Math.min(this.im_points[i], this.immin);
            this.ampmax = Math.max(this.amp_points[i], this.ampmax);
            this.ampmin = Math.min(this.amp_points[i], this.ampmin);
            ++i;
        }
    }

    protected void insertionSort() {
        boolean dataChanged = false;
        if (this.index < 2) {
            return;
        }
        int i = 1;
        while (i < this.index) {
            if (this.xpoints[i] < this.xpoints[i - 1]) {
                dataChanged = true;
                this.moveDatum(i);
            }
            ++i;
        }
        if (dataChanged) {
            this.recalculatePath();
        }
    }

    protected void recalculatePath() {
        this.ampPath.reset();
        if (this.index < 1) {
            return;
        }
        float amp = (float)Math.sqrt(this.re_points[0] * this.re_points[0] + this.im_points[0] * this.im_points[0]);
        this.ampPath.moveTo((float)this.xpoints[0], amp);
        int i = 1;
        while (i < this.index) {
            amp = (float)Math.sqrt(this.re_points[i] * this.re_points[i] + this.im_points[i] * this.im_points[i]);
            this.ampPath.lineTo((float)this.xpoints[i], amp);
            ++i;
        }
    }

    protected void moveDatum(int loc) {
        if (loc < 1) {
            return;
        }
        double x = this.xpoints[loc];
        double re = this.re_points[loc];
        double im = this.im_points[loc];
        int i = 0;
        while (i < this.index) {
            if (this.xpoints[i] > x) {
                System.arraycopy(this.xpoints, i, this.xpoints, i + 1, loc - i);
                this.xpoints[i] = x;
                System.arraycopy(this.re_points, i, this.re_points, i + 1, loc - i);
                this.re_points[i] = re;
                System.arraycopy(this.im_points, i, this.im_points, i + 1, loc - i);
                this.im_points[i] = im;
                return;
            }
            ++i;
        }
    }

    protected void drawLinePlot(DrawingPanel drawingPanel, Graphics2D g2) {
        AffineTransform at = (AffineTransform)drawingPanel.getPixelTransform().clone();
        Shape s = this.ampPath.createTransformedShape(at);
        g2.setColor(this.lineColor);
        g2.draw(s);
        if (this.showPhase) {
            at.concatenate(this.flip);
            s = this.ampPath.createTransformedShape(at);
            g2.draw(s);
        }
    }

    protected void drawReImPlot(DrawingPanel drawingPanel, Graphics2D g2) {
        this.reTrail.draw(drawingPanel, g2);
        this.imTrail.draw(drawingPanel, g2);
    }

    protected void drawPhaseCurve(DrawingPanel drawingPanel, Graphics2D g2) {
        double[] xpoints = this.xpoints;
        double[] re_points = this.re_points;
        double[] im_points = this.im_points;
        int index = this.index;
        if (index < 1) {
            return;
        }
        if (xpoints.length < index || xpoints.length != re_points.length || xpoints.length != im_points.length) {
            return;
        }
        int yorigin = drawingPanel.yToPix(0.0);
        int[] xpix = new int[4];
        int[] ypix = new int[4];
        xpix[2] = drawingPanel.xToPix(xpoints[0]);
        double oldY = Math.sqrt(re_points[0] * re_points[0] + im_points[0] * im_points[0]);
        ypix[3] = drawingPanel.yToPix(-oldY);
        ypix[2] = drawingPanel.yToPix(oldY);
        double oldRe = re_points[0];
        double oldIm = im_points[0];
        int i = 0;
        while (i < index) {
            double re = re_points[i];
            double im = im_points[i];
            double y = Math.sqrt(re * re + im * im);
            if (y > 0.0) {
                g2.setColor(DisplayColors.phaseToColor(Math.atan2((im + oldIm) / 2.0, (oldRe + re) / 2.0)));
            }
            xpix[0] = drawingPanel.xToPix(xpoints[i]);
            if (this.centered) {
                ypix[0] = drawingPanel.yToPix(-y / 2.0);
                ypix[1] = drawingPanel.yToPix(y / 2.0);
            } else {
                ypix[0] = yorigin;
                ypix[1] = drawingPanel.yToPix(y);
            }
            xpix[1] = xpix[0];
            xpix[3] = xpix[2];
            g2.fillPolygon(xpix, ypix, 4);
            xpix[2] = xpix[0];
            ypix[3] = ypix[0];
            ypix[2] = ypix[1];
            oldIm = im;
            oldRe = re;
            oldY = y;
            ++i;
        }
    }

    protected void drawPhaseBars(DrawingPanel drawingPanel, Graphics2D g2) {
        if (this.index < 1) {
            return;
        }
        double[] xpoints = this.xpoints;
        double[] re_points = this.re_points;
        double[] im_points = this.im_points;
        if (xpoints.length < this.index || xpoints.length != re_points.length || xpoints.length != im_points.length) {
            return;
        }
        int barWidth = (int)(0.5 + (double)(drawingPanel.xToPix(this.xmax) - drawingPanel.xToPix(this.xmin)) / (2.0 * (double)(this.index - 1)));
        barWidth = Math.min(this.markerSize, barWidth);
        int yorigin = drawingPanel.yToPix(0.0);
        int i = 0;
        while (i < this.index) {
            double re = re_points[i];
            double im = im_points[i];
            double y = Math.sqrt(re * re + im * im);
            g2.setColor(DisplayColors.phaseToColor(Math.atan2(im, re)));
            int xpix = drawingPanel.xToPix(xpoints[i]);
            int height = Math.abs(yorigin - drawingPanel.yToPix(y));
            if (this.centered) {
                g2.fillRect(xpix - barWidth, yorigin - height / 2, 2 * barWidth + 1, height);
            } else {
                g2.fillRect(xpix - barWidth, yorigin - height, 2 * barWidth + 1, height);
            }
            ++i;
        }
    }

    protected void drawPhasePosts(DrawingPanel drawingPanel, Graphics2D g2) {
        if (this.index < 1) {
            return;
        }
        double[] xpoints = this.xpoints;
        double[] re_points = this.re_points;
        double[] im_points = this.im_points;
        if (xpoints.length < this.index || xpoints.length != re_points.length || xpoints.length != im_points.length) {
            return;
        }
        int postWidth = (int)(0.5 + (double)(drawingPanel.xToPix(this.xmax) - drawingPanel.xToPix(this.xmin)) / (2.0 * (double)(this.index - 1)));
        postWidth = Math.min(this.markerSize, postWidth);
        int i = 0;
        while (i < this.index) {
            double re = re_points[i];
            double im = im_points[i];
            double y = Math.sqrt(re * re + im * im);
            this.drawPost(drawingPanel, g2, xpoints[i], y, postWidth, DisplayColors.phaseToColor(Math.atan2(im, re)));
            ++i;
        }
    }

    private void drawPost(DrawingPanel drawingPanel, Graphics2D g2, double x, double y, int postWidth, Color fillColor) {
        Color edgeColor = Color.BLACK;
        int xp = drawingPanel.xToPix(x);
        int yp = drawingPanel.yToPix(y);
        int size = postWidth * 2 + 1;
        int bottom = Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin()));
        Rectangle2D.Double shape = new Rectangle2D.Double(xp - postWidth, yp - postWidth, size, size);
        g2.setColor(edgeColor);
        g2.drawLine(xp, yp, xp, bottom);
        g2.setColor(fillColor);
        g2.fill(shape);
        g2.setColor(edgeColor);
        g2.draw(shape);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Re", "Im"};
    }

    @Override
    public double[][] getData2D() {
        double[][] data = new double[3][this.index];
        data[0] = this.getXPoints();
        data[1] = this.getRePoints();
        data[2] = this.getImPoints();
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        if (this.reDataset == null || this.imDataset == null) {
            this.reDataset = new Dataset(Color.RED, Color.RED, true);
            this.imDataset = new Dataset(Color.BLUE, Color.BLUE, true);
        }
        this.reDataset.clear();
        this.imDataset.clear();
        this.reDataset.setXYColumnNames(this.xColumnName, this.reColumnName, "Re(" + this.name + ")");
        this.imDataset.setXYColumnNames(this.xColumnName, this.imColumnName, "Im(" + this.name + ")");
        this.reDataset.append(this.getXPoints(), this.getRePoints());
        this.imDataset.append(this.getXPoints(), this.getImPoints());
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        list.add(this.reDataset);
        list.add(this.imDataset);
        return list;
    }

    @Override
    public List<Data> getDataList() {
        if (this.reDataset == null || this.imDataset == null) {
            this.reDataset = new Dataset(Color.RED, Color.RED, true);
            this.imDataset = new Dataset(Color.BLUE, Color.BLUE, true);
        }
        this.reDataset.clear();
        this.imDataset.clear();
        this.reDataset.setXYColumnNames(this.xColumnName, this.reColumnName, "Re(" + this.name + ")");
        this.imDataset.setXYColumnNames(this.xColumnName, this.imColumnName, "Im(" + this.name + ")");
        this.reDataset.append(this.getXPoints(), this.getRePoints());
        this.imDataset.append(this.getXPoints(), this.getImPoints());
        ArrayList<Data> list = new ArrayList<Data>();
        list.add(this.reDataset);
        list.add(this.imDataset);
        return list;
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ComplexDataset data = (ComplexDataset)obj;
            control.setValue("points", data.getPoints());
            control.setValue("marker_shape", data.getMarkerShape());
            control.setValue("marker_size", data.getMarkerSize());
            control.setValue("sorted", data.isSorted());
            control.setValue("connected", data.isConnected());
            control.setValue("name", data.name);
            control.setValue("x_name", data.xColumnName);
            control.setValue("re_name", data.reColumnName);
            control.setValue("im_name", data.imColumnName);
            control.setValue("line_color", data.lineColor);
            control.setValue("index", data.index);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new ComplexDataset();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ComplexDataset data = (ComplexDataset)obj;
            double[][] points = (double[][])control.getObject("points");
            if (points != null && points[0] != null) {
                data.clear();
                int i = 0;
                while (i < points.length) {
                    data.append(points[i][0], points[i][1], points[i][2]);
                    ++i;
                }
            }
            double[] xPoints = (double[])control.getObject("x_points");
            double[] yPoints = (double[])control.getObject("y_points");
            if (xPoints != null && yPoints != null) {
                data.clear();
                data.append(xPoints, yPoints);
            }
            if (control.getPropertyNames().contains("marker_shape")) {
                data.setMarkerShape(control.getInt("marker_shape"));
            }
            if (control.getPropertyNames().contains("marker_size")) {
                data.setMarkerSize(control.getInt("marker_size"));
            }
            data.setSorted(control.getBoolean("sorted"));
            data.setConnected(control.getBoolean("connected"));
            data.name = control.getString("name");
            data.xColumnName = control.getString("x_name");
            data.reColumnName = control.getString("re_name");
            data.imColumnName = control.getString("im_name");
            Color color = (Color)control.getObject("line_color");
            if (color != null) {
                data.lineColor = color;
            }
            data.index = control.getInt("index");
            return obj;
        }
    }

    class Phase
    implements Drawable {
        Phase() {
        }

        @Override
        public void draw(DrawingPanel panel, Graphics g) {
            int w = panel.getWidth() - 5 + 1;
            int h = panel.getHeight() - 25;
            int i = 5;
            while (i < w) {
                double theta = Math.PI * (double)(-1.0f + 2.0f * (float)i / (float)w);
                Color c = DisplayColors.phaseToColor(theta);
                g.setColor(c);
                g.drawLine(i, 5, i, h);
                ++i;
            }
        }
    }
}

