/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private int w;
    private int h;
    private Color color;
    private Color outline;
    private int lineWidth = 1;

    public ColorIcon(Color color, int width, int height) {
        this.w = width;
        this.h = height;
        this.setColor(color);
    }

    public ColorIcon(Color fillColor, Color outlineColor, int width, int height) {
        this.w = width;
        this.h = height;
        this.outline = outlineColor;
        this.setColor(fillColor);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    @Override
    public void paintIcon(Component c, Graphics _g, int x, int y) {
        Graphics2D g = (Graphics2D)_g;
        Rectangle rect = new Rectangle(x, y, this.w, this.h);
        Paint gPaint = g.getPaint();
        if (this.outline != null) {
            g.setPaint(this.outline);
            g.fill(rect);
            rect.setFrame(x + this.lineWidth, y + this.lineWidth, this.w - 2 * this.lineWidth, this.h - 2 * this.lineWidth);
        }
        g.setPaint(this.color);
        g.fill(rect);
        g.setPaint(gPaint);
    }
}

