/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.ArrayTable;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;

public class ArrayPanel
extends JPanel
implements PropertyChangeListener,
Data {
    JTabbedPane tabbedPane = new JTabbedPane();
    ArrayTable[] tables;
    JSpinner spinner;
    JScrollPane scrollpane;
    Object array;
    boolean changed;
    String format = null;
    int firstRowIndex = 0;
    int firstColIndex = 0;
    boolean rowNumberVisible = true;
    boolean editable = true;
    String[] colNames;
    private int ID = this.hashCode();

    public static ArrayPanel getArrayPanel(Object arrayObj) {
        ArrayPanel arrayPanel = new ArrayPanel();
        arrayPanel.setArray(arrayObj);
        return arrayPanel;
    }

    public void setArray(Object arrayObj) {
        if (!ArrayPanel.canDisplay(arrayObj)) {
            return;
        }
        if (arrayObj instanceof double[]) {
            this.setArray((double[])arrayObj);
        } else if (arrayObj instanceof double[][]) {
            this.setArray((double[][])arrayObj);
        } else if (arrayObj instanceof double[][][]) {
            this.setArray((double[][][])arrayObj);
        } else if (arrayObj instanceof int[]) {
            this.setArray((int[])arrayObj);
        } else if (arrayObj instanceof int[][]) {
            this.setArray((int[][])arrayObj);
        } else if (arrayObj instanceof int[][][]) {
            this.setArray((int[][][])arrayObj);
        } else if (arrayObj instanceof String[]) {
            this.setArray((String[])arrayObj);
        } else if (arrayObj instanceof String[][]) {
            this.setArray((String[][])arrayObj);
        } else if (arrayObj instanceof String[][][]) {
            this.setArray((String[][][])arrayObj);
        } else if (arrayObj instanceof boolean[]) {
            this.setArray((boolean[])arrayObj);
        } else if (arrayObj instanceof boolean[][]) {
            this.setArray((boolean[][])arrayObj);
        } else if (arrayObj instanceof boolean[][][]) {
            this.setArray((boolean[][][])arrayObj);
        }
        this.array = arrayObj;
    }

    public static boolean canDisplay(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof double[] || obj instanceof double[][] || obj instanceof double[][][] || obj instanceof int[] || obj instanceof int[][] || obj instanceof int[][][] || obj instanceof boolean[] || obj instanceof boolean[][] || obj instanceof boolean[][][] || obj instanceof String[] || obj instanceof String[][] || obj instanceof String[][][];
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.changed = true;
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public void setNumericFormat(String _format) {
        this.format = _format;
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setNumericFormat(_format);
            ++i;
        }
    }

    public void setNumericFormat(String[] _format) {
        this.format = null;
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setNumericFormat(_format);
            ++i;
        }
    }

    public void setRowNumberVisible(boolean vis) {
        this.rowNumberVisible = vis;
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setRowNumberVisible(vis);
            ++i;
        }
    }

    public void setColumnNames(String[] names) {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setColumnNames(names);
            ++i;
        }
    }

    public void setColumnNames(String[][] names) {
        int n = Math.min(this.tables.length, names.length);
        int i = 0;
        while (i < n) {
            this.tables[i].setColumnNames(names[i]);
            ++i;
        }
    }

    public void setPreferredColumnWidth(int ncol, int nwidth) {
        int table = 0;
        while (table < this.tables.length) {
            TableColumn column = this.tables[table].getColumnModel().getColumn(ncol);
            column.setMinWidth(0);
            column.setMaxWidth(300);
            column.setPreferredWidth(nwidth);
            ++table;
        }
    }

    public void setPreferredColumnWidth(int nwidth) {
        int table = 0;
        while (table < this.tables.length) {
            int col = 0;
            while (col < this.tables[table].getColumnCount()) {
                TableColumn column = this.tables[table].getColumnModel().getColumn(col);
                column.setMinWidth(0);
                column.setMaxWidth(300);
                column.setPreferredWidth(nwidth);
                ++col;
            }
            ++table;
        }
    }

    public void setColumnAlignment(int ncol, int align) {
        int table = 0;
        while (table < this.tables.length) {
            int row = 0;
            while (row < this.tables[table].getRowCount()) {
                TableCellRenderer renderer = this.tables[table].getCellRenderer(row, ncol);
                ((JLabel)((Object)renderer)).setHorizontalAlignment(align);
                ++row;
            }
            ++table;
        }
    }

    public void setColumnAlignment(int align) {
        int table = 0;
        while (table < this.tables.length) {
            int row = 0;
            while (row < this.tables[table].getRowCount()) {
                int col = 0;
                while (col < this.tables[table].getColumnCount()) {
                    TableCellRenderer renderer = this.tables[table].getCellRenderer(row, col);
                    ((JLabel)((Object)renderer)).setHorizontalAlignment(align);
                    ++col;
                }
                ++row;
            }
            ++table;
        }
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int index) {
        this.firstRowIndex = index;
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setFirstRowIndex(index);
            ++i;
        }
    }

    public void setFirstColIndex(int index) {
        this.firstColIndex = index;
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setFirstColIndex(index);
            ++i;
        }
    }

    public void setColumnLock(int columnIndex, boolean locked) {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setColumnLock(columnIndex, locked);
            ++i;
        }
    }

    public void setColumnLocks(boolean[] locked) {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setColumnLocks(locked);
            ++i;
        }
    }

    public void setEditable(boolean _editable) {
        this.editable = _editable;
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setEditable(_editable);
            ++i;
        }
    }

    public void setTransposed(boolean transposed) {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setTransposed(transposed);
            ++i;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.tables != null) {
            int i = 0;
            while (i < this.tables.length) {
                this.tables[i].setFont(font);
                ++i;
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.tables != null) {
            int i = 0;
            while (i < this.tables.length) {
                this.tables[i].setForeground(color);
                ++i;
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.tables != null) {
            int i = 0;
            while (i < this.tables.length) {
                this.tables[i].setBackground(color);
                ++i;
            }
        }
    }

    public void setDataForeground(Color color) {
        if (this.tables != null) {
            int i = 0;
            while (i < this.tables.length) {
                this.tables[i].setDataForeground(color);
                ++i;
            }
        }
        this.refreshTable();
    }

    public void setDataBackground(Color color) {
        if (this.tables != null) {
            int i = 0;
            while (i < this.tables.length) {
                this.tables[i].setDataBackground(color);
                ++i;
            }
        }
        this.refreshTable();
    }

    public void setAutoResizeMode(int mode) {
        if (this.tables != null) {
            int i = 0;
            while (i < this.tables.length) {
                this.tables[i].setAutoResizeMode(mode);
                ++i;
            }
        }
        this.refreshTable();
    }

    public int getNumColumns() {
        return this.tables[0].getColumnCount();
    }

    public void refreshTable() {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].refreshTable();
            ++i;
        }
    }

    public void setRefreshDelay(int delay) {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setRefreshDelay(delay);
            ++i;
        }
    }

    protected void createGUI() {
        this.removeAll();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.scrollpane = new JScrollPane(this.tables[0]);
        if (this.tables.length > 1) {
            SpinnerNumberModel model = new SpinnerNumberModel(0, 0, this.tables.length - 1, 1);
            this.spinner = new JSpinner(model);
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.spinner);
            editor.getTextField().setFont(this.tables[0].indexRenderer.getFont());
            this.spinner.setEditor(editor);
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = (Integer)ArrayPanel.this.spinner.getValue();
                    ArrayPanel.this.scrollpane.setViewportView(ArrayPanel.this.tables[i]);
                }
            });
            Dimension dim = this.spinner.getMinimumSize();
            this.spinner.setMaximumSize(dim);
            this.add((Component)this.scrollpane, "Center");
            JToolBar toolbar = new JToolBar();
            toolbar.setFloatable(false);
            toolbar.add(new JLabel(" index "));
            toolbar.add(this.spinner);
            toolbar.add(Box.createHorizontalGlue());
            this.add((Component)toolbar, "North");
        } else {
            this.scrollpane.createHorizontalScrollBar();
            this.add((Component)this.scrollpane, "Center");
        }
        this.validate();
    }

    private void setArray(int[] array) {
        if (this.array instanceof int[]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(int[][] array) {
        if (this.array instanceof int[][]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(int[][][] array) {
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            this.tables[i].setFont(this.getFont());
            this.tables[i].setForeground(this.getForeground());
            this.tables[i].setBackground(this.getBackground());
            ++i;
        }
        this.createGUI();
    }

    private void setArray(double[] array) {
        if (this.array instanceof double[]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(double[][] array) {
        if (this.array instanceof double[][]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(double[][][] array) {
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            this.tables[i].setFont(this.getFont());
            this.tables[i].setForeground(this.getForeground());
            this.tables[i].setBackground(this.getBackground());
            ++i;
        }
        this.createGUI();
    }

    private void setArray(String[] array) {
        if (this.array instanceof String[]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(String[][] array) {
        if (this.array instanceof String[][]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(String[][][] array) {
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            this.tables[i].setFont(this.getFont());
            this.tables[i].setForeground(this.getForeground());
            this.tables[i].setBackground(this.getBackground());
            ++i;
        }
        this.createGUI();
    }

    private void setArray(boolean[] array) {
        if (this.array instanceof boolean[]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(boolean[][] array) {
        if (this.array instanceof boolean[][]) {
            this.tables[0].tableModel.setArray(array);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.tables[0].setFont(this.getFont());
        this.tables[0].setForeground(this.getForeground());
        this.tables[0].setBackground(this.getBackground());
        this.createGUI();
    }

    private void setArray(boolean[][][] array) {
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            this.tables[i].setFont(this.getFont());
            this.tables[i].setForeground(this.getForeground());
            this.tables[i].setBackground(this.getBackground());
            ++i;
        }
        this.createGUI();
    }

    @Override
    public String[] getColumnNames() {
        String[] modelNames;
        double[][] data = this.getData2D();
        if (data == null) {
            return null;
        }
        int n = data.length;
        if (this.colNames == null || n != this.colNames.length) {
            this.colNames = new String[n];
        }
        int stop = (modelNames = this.tables[0].tableModel.columnNames) == null ? 0 : Math.min(n, modelNames.length - 1);
        int i = 0;
        while (i < stop) {
            this.colNames[i] = modelNames[i + 1];
            ++i;
        }
        i = stop;
        while (i < n) {
            this.colNames[i] = "C" + (i + 1);
            ++i;
        }
        return this.colNames;
    }

    @Override
    public double[][] getData2D() {
        if (this.tables == null || this.tables[0] == null) {
            return null;
        }
        boolean transposed = this.tables[0].tableModel.transposed;
        double[][] data = this.tables[0].tableModel.doubleArray2;
        if (!transposed && data != null) {
            int r = data.length;
            int c = 0;
            int i = 0;
            while (i < r) {
                c = Math.max(c, data[i].length);
                ++i;
            }
            double[][] tdata = new double[c][r];
            int i2 = 0;
            while (i2 < r) {
                int ci = data[i2].length;
                int j = 0;
                while (j < ci) {
                    tdata[j][i2] = data[i2][j];
                    ++j;
                }
                j = ci;
                while (j < c) {
                    tdata[j][i2] = Double.NaN;
                    ++j;
                }
                ++i2;
            }
            return tdata;
        }
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    public Color[] getFillColors() {
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return null;
    }

    @Override
    public int getID() {
        boolean transposed = this.tables[0].tableModel.transposed;
        if (transposed) {
            return this.ID ^ 0xFFFF;
        }
        return this.ID;
    }

    @Override
    public void setID(int id) {
        this.ID = id;
    }
}

