/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;

public class XMLPropertyElement
implements XMLProperty {
    public static boolean defaultWriteNullFinalArrayElements = true;
    protected XMLProperty parent;
    protected String name;
    protected String type;
    protected String className;
    protected List<Object> content;
    protected boolean writeNullFinalElement;

    public XMLPropertyElement(XMLProperty mother) {
        this.content = new ArrayList<Object>();
        this.parent = mother;
    }

    public XMLPropertyElement(XMLProperty mother, String propertyName, String propertyType, Object value) {
        this(mother, propertyName, propertyType, value, defaultWriteNullFinalArrayElements);
    }

    public XMLPropertyElement(XMLProperty mother, String propertyName, String propertyType, Object value, boolean writeNullFinalArrayElement) {
        block11: {
            block15: {
                boolean primitive;
                block14: {
                    block13: {
                        block12: {
                            block10: {
                                this(mother);
                                this.name = propertyName;
                                this.type = propertyType;
                                this.writeNullFinalElement = writeNullFinalArrayElement;
                                if (!this.type.equals("string")) break block10;
                                if (XML.requiresCDATA((String)value)) {
                                    this.content.add("<![CDATA[" + value + "]]>");
                                } else {
                                    this.content.add(value.toString());
                                }
                                break block11;
                            }
                            if ("intdoubleboolean".indexOf(this.type) == -1) break block12;
                            this.content.add(value.toString());
                            break block11;
                        }
                        if (!this.type.equals("object")) break block13;
                        if (value == null) {
                            this.content.add("null");
                        } else {
                            this.className = value.getClass().getName();
                            XMLControlElement control = new XMLControlElement(this);
                            control.saveObject(value);
                            this.content.add(control);
                        }
                        break block11;
                    }
                    if (!this.type.equals("collection")) break block14;
                    this.className = value.getClass().getName();
                    for (Object next : (Collection)value) {
                        String type = XML.getDataType(next);
                        if (type == null) continue;
                        this.content.add(new XMLPropertyElement(this, "item", type, next, this.writeNullFinalElement));
                    }
                    break block11;
                }
                if (!this.type.equals("array")) break block11;
                this.className = value.getClass().getName();
                Class<?> baseType = value.getClass().getComponentType();
                Object array = value;
                int count = Array.getLength(array);
                while (count > 0 && baseType.getComponentType() != null) {
                    baseType = baseType.getComponentType();
                    if ((array = Array.get(array, 0)) == null) break;
                    count *= Array.getLength(array);
                }
                boolean bl = primitive = "intdoubleboolean".indexOf(baseType.getName()) != -1;
                if (!primitive || count <= XMLControlElement.compactArraySize) break block15;
                String s = this.getArrayString(value);
                this.content.add(new XMLPropertyElement(this, "array", "string", s, this.writeNullFinalElement));
                break block11;
            }
            int length = Array.getLength(value);
            int last = this.writeNullFinalElement ? length - 1 : length;
            int j = 0;
            while (j < length) {
                block17: {
                    String type;
                    Object next;
                    block16: {
                        next = Array.get(value, j);
                        type = XML.getDataType(next);
                        if (type != null) break block16;
                        if (j < last) break block17;
                        type = "object";
                    }
                    this.content.add(new XMLPropertyElement(this, "[" + j + "]", type, next, this.writeNullFinalElement));
                }
                ++j;
            }
        }
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public String getPropertyType() {
        return this.type;
    }

    @Override
    public Class<?> getPropertyClass() {
        if (this.type.equals("int")) {
            return Integer.TYPE;
        }
        if (this.type.equals("double")) {
            return Double.TYPE;
        }
        if (this.type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (this.type.equals("string")) {
            return String.class;
        }
        try {
            return Class.forName(this.className);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public XMLProperty getParentProperty() {
        return this.parent;
    }

    @Override
    public int getLevel() {
        return this.parent.getLevel() + 1;
    }

    @Override
    public List<Object> getPropertyContent() {
        return this.content;
    }

    @Override
    public XMLControl getChildControl(String name) {
        XMLControl[] children = this.getChildControls();
        int i = 0;
        while (i < children.length) {
            if (children[i].getPropertyName().equals(name)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public XMLControl[] getChildControls() {
        if (this.type.equals("object") && !this.getPropertyContent().isEmpty()) {
            XMLControl child = (XMLControl)this.getPropertyContent().get(0);
            return new XMLControl[]{child};
        }
        if ("arraycollection".indexOf(this.type) != -1) {
            ArrayList<XMLControl> list = new ArrayList<XMLControl>();
            for (XMLProperty xMLProperty : this.getPropertyContent()) {
                if (!xMLProperty.getPropertyType().equals("object") || xMLProperty.getPropertyContent().isEmpty()) continue;
                list.add((XMLControl)xMLProperty.getPropertyContent().get(0));
            }
            return list.toArray(new XMLControl[0]);
        }
        return new XMLControl[0];
    }

    @Override
    public void setValue(String stringValue) {
        boolean valid = true;
        try {
            if (this.type.equals("int")) {
                Integer.parseInt(stringValue);
            } else if (this.type.equals("double")) {
                Double.parseDouble(stringValue);
            } else if (this.type.equals("boolean")) {
                stringValue = stringValue.equals("true") ? "true" : "false";
            } else if ("objectarraycollection".indexOf(this.type) != -1) {
                valid = false;
            } else if (this.type.equals("string") && XML.requiresCDATA(stringValue)) {
                stringValue = "<![CDATA[" + stringValue + "]]>";
            }
        }
        catch (NumberFormatException ex) {
            valid = false;
        }
        if (valid) {
            this.content.clear();
            this.content.add(stringValue);
        }
    }

    public String toString() {
        List<Object> content;
        StringBuffer xml = new StringBuffer(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()) + "<property name=\"" + this.name + "\" type=\"" + this.type + "\"");
        if ("arraycollection".indexOf(this.type) != -1) {
            xml.append(" class=\"" + this.className + "\"");
        }
        if ((content = this.getPropertyContent()).isEmpty() && "object".equals(this.type)) {
            content.add("null");
        }
        if (content.isEmpty()) {
            xml.append("/>");
            return xml.toString();
        }
        xml.append(">");
        boolean hasChildren = false;
        for (Object next : content) {
            hasChildren = hasChildren || next instanceof XMLProperty;
            xml.append(next);
        }
        if (hasChildren) {
            xml.append(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()));
        }
        xml.append("</property>");
        return xml.toString();
    }

    protected String indent(int level) {
        String space = "";
        int i = 0;
        while (i < 4 * level) {
            space = String.valueOf(space) + " ";
            ++i;
        }
        return space;
    }

    protected String getArrayString(Object array) {
        StringBuffer sb = new StringBuffer("{");
        int length = Array.getLength(array);
        int j = 0;
        while (j < length) {
            Object element;
            if (j > 0) {
                sb.append(',');
            }
            if ((element = Array.get(array, j)) != null && element.getClass().isArray()) {
                sb.append(this.getArrayString(element));
            } else {
                sb.append(element);
            }
            ++j;
        }
        sb.append('}');
        return sb.toString();
    }
}

