/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.IURLProtocolHandler;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInputOutputHandler
implements IURLProtocolHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final boolean CLOSE_STREAM_ON_CLOSE = true;
    private final DataInput mDataInput;
    private final DataOutput mDataOutput;
    private final boolean mCloseStreamOnClose;
    private Object mOpenStream = null;

    public DataInputOutputHandler(DataInput in) {
        this(in, null, true);
    }

    public DataInputOutputHandler(DataOutput out) {
        this(null, out, true);
    }

    public DataInputOutputHandler(RandomAccessFile file) {
        this(file, file, true);
    }

    public DataInputOutputHandler(DataInput in, DataOutput out, boolean closeStreamOnClose) {
        if (in == null && out == null) {
            throw new IllegalArgumentException("must pass one non null stream");
        }
        this.mDataInput = in;
        this.mDataOutput = out;
        this.mCloseStreamOnClose = closeStreamOnClose;
    }

    @Override
    public int close() {
        int retval = 0;
        try {
            if (this.mOpenStream != null && this.mCloseStreamOnClose && this.mOpenStream instanceof Closeable) {
                ((Closeable)this.mOpenStream).close();
            }
        }
        catch (IOException e) {
            this.log.error("could not close stream {}: {}", this.mOpenStream, (Object)e);
            retval = -1;
        }
        this.mOpenStream = null;
        return retval;
    }

    @Override
    public int open(String url, int flags) {
        if (this.mOpenStream != null) {
            this.log.debug("attempting to open already open handler: {}", this.mOpenStream);
            return -1;
        }
        switch (flags) {
            case 2: {
                if (this.mDataInput != null && this.mDataOutput != null && this.mDataInput == this.mDataOutput && this.mDataInput instanceof RandomAccessFile) {
                    this.mOpenStream = this.mDataInput;
                    break;
                }
                this.log.debug("do not support read/write mode for Java IO Handlers");
                return -1;
            }
            case 1: {
                this.mOpenStream = this.mDataOutput;
                if (this.mOpenStream != null) break;
                this.log.error("No OutputStream specified for writing: {}", (Object)url);
                return -1;
            }
            case 0: {
                this.mOpenStream = this.mDataInput;
                if (this.mOpenStream != null) break;
                this.log.error("No InputStream specified for reading: {}", (Object)url);
                return -1;
            }
            default: {
                this.log.error("Invalid flag passed to open: {}", (Object)url);
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int read(byte[] buf, int size) {
        int ret = -1;
        if (this.mOpenStream == null || !(this.mOpenStream instanceof DataInput)) {
            return -1;
        }
        try {
            if (this.mOpenStream instanceof RandomAccessFile) {
                RandomAccessFile file = (RandomAccessFile)this.mOpenStream;
                return file.read(buf, 0, size);
            }
            if (this.mOpenStream instanceof DataInputStream) {
                DataInputStream stream = (DataInputStream)this.mOpenStream;
                return stream.read(buf, 0, size);
            }
            DataInput input = (DataInput)this.mOpenStream;
            try {
                input.readFully(buf, 0, size);
                ret = size;
            }
            catch (EOFException e) {
                ret = -1;
            }
            return ret;
        }
        catch (IOException e) {
            this.log.error("Got IO exception reading from channel: {}; {}", this.mOpenStream, (Object)e);
            return -1;
        }
    }

    @Override
    public long seek(long offset, int whence) {
        if (this.mOpenStream == null) {
            return -1L;
        }
        if (!(this.mOpenStream instanceof RandomAccessFile)) {
            return -1L;
        }
        RandomAccessFile file = (RandomAccessFile)this.mOpenStream;
        try {
            long seek;
            if (whence == 0) {
                seek = offset;
            } else if (whence == 1) {
                seek = file.getFilePointer() + offset;
            } else if (whence == 2) {
                seek = file.length() + offset;
            } else {
                if (whence == 65536) {
                    return (int)file.length();
                }
                this.log.error("invalid seek value \"{}\" for file: {}", whence, (Object)file);
                return -1L;
            }
            file.seek(seek);
            return seek;
        }
        catch (IOException e) {
            this.log.debug("got io exception \"{}\" while seeking in: {}", (Object)e.getMessage(), (Object)file);
            return -1L;
        }
    }

    @Override
    public int write(byte[] buf, int size) {
        if (this.mOpenStream == null || !(this.mOpenStream instanceof DataOutput)) {
            return -1;
        }
        try {
            DataOutput output = (DataOutput)this.mOpenStream;
            output.write(buf, 0, size);
            return size;
        }
        catch (IOException e) {
            this.log.error("Got error writing to file: {}; {}", this.mOpenStream, (Object)e);
            return -1;
        }
    }

    @Override
    public boolean isStreamed(String url, int flags) {
        if (this.mDataInput != null && this.mDataInput instanceof RandomAccessFile) {
            return false;
        }
        return this.mDataOutput == null || !(this.mDataOutput instanceof RandomAccessFile);
    }

    public DataInput getDataInput() {
        return this.mDataInput;
    }

    public DataOutput getDataOutput() {
        return this.mDataOutput;
    }

    public Object getOpen() {
        return this.mOpenStream;
    }

    public boolean isCloseStreamOnClose() {
        return this.mCloseStreamOnClose;
    }
}

