var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./projectile/2015-10-19_1712s.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./projectile/projectile_trail_2014-05-04_2246 small.png"]="data:image/png;base64,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";
__base64Images["./projectile/lookangphoto.jpg"]="data:image/jpeg;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./full_screen.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAPySURBVHjatJZdiFVVFMd/+9w9dz7u3KuJNjIm0tiAgz1NoFn2QYHWgxCUDxoR9dKnD/pURvQSGfQxECXlQ+BXiEjREL1YkTDYkDPWi9aEMTCJd+51mlHvnXvvOWfvtXo4Zyz0OqjkgnXgHNZe/73X+v/XPkZVuZVm5wCMMVQqlWdVdW367YaRjTEBcLpQKHymqhEAIoKIMDEx8YGIxPo/WKlUOgwYEUke5XJpsKtr6aZj52ocGatCxmAw13+GNFS98NAdHWzu7aRarZzJ5Tp7zejo6P39/f1Dh8YusuXz8SQ6lmRhWwDZYP7kTqCWxtsARHntiW52rb+d4eHhrXZBPr8ZYNvRc2A8PSvzbLwzRzYTcHS8yulzNWi5BogIXUuybF29kIZTRoo1ToxVePfHIrvWL2ZBofNRi+oigCiMYLbOF4/1snZ5AYBVv5+CSgMK2eYAdUfJeT58uC95DWM63hiFwKJO8SItgRdxABnnIXa0WnN5/XdbeiCjEMUQN/Ew5Pune/6lZAYQB84BgnqVlKaCcTEYz76TJQ7b87yzsYf9v5ShEQIWTLP6O/aNTvJIz0LeOzZBJfSgHpwiaV6rooCiLoYWYeDbcYiET4eLzEzWIGfBx81L1KLs/WGCwVNTzJRqKTEyIAGiiopiVSXRVOzAeWiz0JphZqoKrQbEg8zDovaAmb9nk9ggSHJ4j6qgKtjkKIqZq2vmP+T3gPfXp4W5WJfsRgVEmQOQBDm6AuBmLBYwIOoRFSySJnRR4g2fQM9G0J5NxNa0w+m4igWqaWzGpCPMoJL0IFCjoAreQS2iI2vAO3a/1E97u4FLjYR2zbwWQSPmkxf7yXUEtGUEwhicQzXJa0UFECRyMF1h8K0HeaB3EdlcgWfWLCP//FfQEMgEV6mYaszIwOPcc1c3z61bRvFCyMoXBqHDIppQNfCiCUviGOoRgpDNdYDUeWXfKFTrSfOuFJnz4GO27z2JNCq0d7bRagOohxC6ZEqrEgAWgagegjpGzkxBHILz/HH2UlqOJip2MYhn7OwMtVjQMOLnP6cgjiBqEHsPBmtnpi/8hoX+FQsYOlVk50dD7Nx9POG0NWCBMLp6dJukyeXiRfJP7QWnEHuoRSxaVmBxvpVfZ2vnTV9f320nhoemK3XHmu1f89dYGYKUNUEAwTx3m0kYjqRKFKV9aYHj729i9YqFvLrj9bvNZKnMnj17ntyx7eUjuTbLePESfh5icm3CYlCWL8mDgUNffvPmxg0b3jaTpTKqyn3r7l05MDCws7u7a5U1GYu58TtZVHVqanp8/8GDHx88cOCnyVJZr9xoG9BJUpibMQVmgdrlKt7q35Z/BgD4LZFsdEtqqgAAAABJRU5ErkJggg==";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./projectile/2013-12-27_1418.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAyoAAAKWCAYAAACmtm19AAAACXBIWXMAAA7DAAAOwwHHb6hkAADf80lEQVR4Xu29D7QlV13ne8eX9QhORiITmah0bnAYX4YVNZLmmSFhOq65as4SHpkxjtGOk6ghK2ZytJXT0x1I20r7yAxB2ktebDMnGjBIOzYz7XAvCUMI90CHaSSR9tJqY1r7SJrQQEMaaKDFhvze/lWdOqeqTv35Ve3atWtXfWutSm7X2Xv/an/3b//51N676h/9xZ9/hHa/+8wCDigABaAAFIACUAAKQAEoAAWgQBMU+JX/57kLC7/whjXCCQ3gA/AB+AB8AD4AH4APwAfgA/CBJvlAaVC5/PLLCSc0gA/AB+AD8AH4AHwAPgAfgA/AB7J8oCz8lAYVNvjge5/ACQ3gA/AB+AB8AD4AH4APwAfgA/CBTB8oAytaoFLGIOJgShE+AB+AD8AH4APwAfgAfAA+AB/I84FEUOGZkvceehonNIAPwAfgA/AB+AB8AD4AH4APwAeM+gCzRxK0JIIKIAWQBh+AD8AH4APwAfgAfAA+AB+AD9TlAwAV0LBRGq7LkWEHjSZ8AD4AH4APwAfgA/CBdvkAQAWgYg1USB3hBgX/hh7wh1kHg/qA+oD6gPoQ+ADaA7QHTW4Pwvf2t585TTpnHDQBKgAVa6DCzsgOGHZK/Bt6wB9mgzPUB9QH1AfUh8AH0B6gPWhyexDc29PPfE19quRltHHjRnrpSzd6//dfUfyyyf9/0Pv/xo3/N73scv7tB+ml3m8vI44LUAGYWAWTpClZPCnCk6ImPymCf8I/4Z+Y2cDMhu8DaA/RHuYtrXvm9Nfp8h98Kd38hpF3/sJvPEo3/+YH6ef5Y/K7PqCufci79nO/qf7+9Q/STbv49zX6+V//ANGzUX2DB9rxWRVspgfM1A4zeFKEJ0VNflIE/4R/wj8xs4GZDd8H0B6iPcyCla99/Rv00o0/6EEJ/y05GVxe8/9+gL6pSKXSGZW0r00mZSAIm0di/HtSullpxsNLbEjDFL1vabplwkl1KZO2VN+8tMN65WmHJzN4MoMn1XhSjSfVeFKNJ/WYqcB4wO3xQLwvf+nGy9VsyZo3A7ewsODPliQcwW//90tV+Df4YYyASt7gNQwfeWGTBrdpA968gXCeLcnvUhvScBKbaWHqsBG2XcZeEVDBkxk8mcKTOTyZw0wFZiowU4GZCowH3B8PBPXYm1F56UvVjMpoOpsSAEl4diUMMBsvv8KbgXn22YIzKjzoDNaFVTVLEqSTNgtSZHCcFTZrwByPl/XvtN+S0peETZoximtbFMzytMyCP6mGafdYRLs0AMOTFLefpKD8UH6YGcPMGGbGMDOGmbHuzYwljeu8PSqKH16z64PEfwdnACb87zCk8L8ZbPwZlW+mzqiEmWS6R4UvBl+FrBJUJINbCbBIBtkcJg4H8Rkeyf0EcdJmHHTgpypQyZoNKQJucZhMuj+JDpIyxJM0PEnDkzT3n6RhZgwzY5gZw8wY+vNu9ufxMaL/1q/L1eb5R723eIXPAFCCpWDBbx6EqBmYrKVfYSYpDCppT/TzBrMBROQ9rS8SLg4maYNu6cBdOhtRJaikzTzEdU7LaxzEioBZUpmF7Wb9nmcnni88iceTeDyJx5N4PInHk3g8ie/ek3j0/+3q/8N9OX9D5QfVa4kZPOLfU4mDSvD7RrVHhcHGGKikDawlT/ilsyJJsCKJWzWopAFOnaAimYFJgpqk2aU0CEmCnTzwLAoqeJKOJ+l4Eo8n8XgSjyfxeBLfzSfxaP/b1f4H9fgTT3+JXrZR7VFRb/Liv4MzvNwr+Dv4jb+lwkvFsvaoaM2oJIFK3sA9DhBpsyZZA+a6QUW6RKzojIYE9IrqUESbvBmcPDCSwluaHTxZadeTFZQnyhMzZZgpw0wZZsowU9b+mbKkcd1fPHXKm1Hhb6jw33yGISV+jf+9UYEKg436jErmHpVgO0rhpV9FQaXIgL/oAF0yg5L15D8+w1B2iVjRPGbNPqXlKet6EftpUCO9rgsqmFnBzAqerLXryRrKE+WJmTLMlGGmrBszZXEGODR+hngpF2+O57/DkML/Dp/Bb/xVeslm+tKgEl9mlDRbEp8xSYsThoisZUlp4dL2beTN8EgH20lLqvLgKM923oxFGVBJ0icJhsrOvKTpkAV28XziyTuevOPJO56848k7nrzjyXv7n7yjv293fx/uyz969PMeqNykvkTPf/PJR/B3/P/828aXvsz7cn3lMyppS3lwfTb4gBbZWuDJK5684skrnrziyWs3nryivUd7j/a+ve19ULb/+xOf8976xZvpGT7475e+9DIPXngvyksv/yH1/5d5f3u/qY9DblR7WnipmHo7cbVLvzAIB5BU4QN40tLuJy0oX5QvZs4wc4aZM8ycYeasfTNnSWPAD/7lZzwQ+YVd7/c+4via3/iQgpAPeXtQGF54idcv/Maa9xufPzcBGv/1xNnfUSm89KuKQSrSAOxgjwr2qOBJK5604klre5+0on6jfqN+t7d+x8fxj378BPHJ0PFN+oa3nIv/9v9P6s1e35j8xf8I/Tm5Hk8v+PB8qbd+ATIAGTo+gCfteNKOJ+140o4n7XjSjift7XvSjv69W/27zlgwLy5A5RBgI89JTP6OJ2140oYnbe190ob6jfqN+o36jT1o3diDZmqsCFABqMxtXDLlbEgXUAwfgA/AB+AD8AH4AHwAPiD1AYAKQAWgAh+AD8AH4APwAfgAfAA+AB9onA8AVOCUjXNKKWUjHJ7IwAfgA/AB+AB8AD4AH2ivD4hBhV8JhhMawAfgA/AB+AB8AD4AH4APwAfgA3X4gBhUXvem+win+xo888wz1IQTTz/a+/QDZdvdsm1C2xK+B/hid30RZd++sm9a+2LyfjDeno23C4EKKn79FZ+d9ZMnv1LJyWmZrFhF0mZfKhIeYZsBmCgHlEOaDzSxTjfxnlCHUIfgA8V9oGt1mcdrro65qx63FgYVVLDiFaysZuykXOBPP/O1Sk6ASn1lV7bMEQ9l5KoPNHEg0cR7crV8cd9om2z6QNfqcgAqNjUvY9vEuBWg0pClUEkOERT45750hqo4ASroaMo0PIgDv5H4QBMHEk28J4mWCIM6Bx+I+kDX6rLroFLFmJXTYB0AKg6AyjOnv05VnAAVdH7o/OADpnygiQOJJt6TKf2RLup2m32ga3XZdVCpYszKaQBUGgwp3OAEMypf/to/UBUnQAUdWZs7MuTNrn83cSDRxHuCn9r1U+jvpv5dq8uug0oVY1ZOA6DiCKh87evfoCpOgIqbDTQ6VpSbCz7QxIFEE+/JhbLEPaLNaZoPdK0uuw4qVYxZOQ2AiiOgcvYb36QqToAKOp+mdT64n/b4ZBMHEk28J/h8e3weZVlfWXatLrsOKlWMWTmN0qBy+eWXE5/hShq/Fv9dWqGDdJJsBGlIwkjtpYWL28i6H11bafGDpV9U0cEFnlV2aWUqKYtw2cTLKSl/8UYnrHc8fNnfTJUL0q2vc4LW7mjNdVrSN+S1uXllntcWh9sxtDPu+E9eueP3bpdlWvvSVr/IApW8NjBpbF52TM5pFRnfmxi3ltpMn9cZFRExbVCaJE7aNROOmpdHEzbjaQYFXiWZlgGVrLyG00ty5rTKER5AJAFSEvgE5S/5rY7ygY1ud5wo//m38tTRbhZ5cIJ2BnUU9bQdPgBQmZWjdIwtDZdXR7LGeXWMWysHlaTZjiKD2TxBJGnlDZjDA+O0gpR0uEl5TZpNSLufPCcKQKXKtX5x2IvnIdBGonM4raLljgFEOzqPvAYOv3ennKUzKmntZla7ndYeJV0PX8tqZ+JPHdP+nfUgBf7dHf9GWdstawmoSNqWvLGddOyTNP5JmslIm5EI32vSuDE+oyK5r7z2MOueJe1v1pg3yIOJcWvloJJXKHGh0gbOabMnkg5LkmbSgDzNydLgQ+KUcWfMg6hwmmlv/UqCi6Rr8bcuBHtUJBoWCZOmZVbeASp2G310utC/ah+QgIqkM8x6mFKk/+CwSe1M2kAFoII6UXWdQHrV+VQeqCQ9UIiPTfIexBYZr0ns5bVXWWPVMKikAUjWeDvtN8m4VTKGTvNtE+NWLVBJGhznCZf3u7QjyxJSIrIuqMThRUK7eXmPF3xQ4Envo86DlaQ4VYNKkTKIh5WuHc96mpn1GzqI6joIaAktJT4QHkiU6RuqaEPj/UccVMJtRtrfQVsVbuPTIEaiC8Kg/sAH9H0gD1RMjMkkD5aTZhnKjmPDfpIGKkXGXUkPZeLwlPegOc9eHeNWLVApQ2Z5g/WyBZw2cE8SOdwRSQsy7SlcHqGnFXKSc6cVeNoXPtPynBa+qaBSFkYAKvqNPzpQaFiVDxSZUcnr3HX7gSBPmLmFf1fl30jHri9JQCXtYUdV7Yk0HUm4vDFgUVDJa1PjIJcHIFIt6xi3tg5U0hqTcCHGiTIpThrAJBV22QLPa/iCGZWnn/kapZ1x58wKG349cVyPpKcReY5dJN/xsBhA2G3083wPv6N8ivpAEVDJa3MlHb2kfUI7Az8u6scI30yfyQOVqtqMtAF6kfFOkXtJ87eioJLXpsbvv2x+8sbGJsatjQeVLKiQOlRSGmkD9TQQiTuB1BHTAEliJyjwT578CmWdgY28cFWDStG8hTXDAKKZnQE6aZRLWR8oAyqSp3ZF2pl4u4x2Bv5c1p8Rr1m+UweoZLU1ZduhsvFM7VEJr0TJa3+DsFlj7bQZlbzxaJFxqxFQKUJqeWGloBIPFy6MJJJMuyYBiHiYJOiRQJSUTP/2M6epirMKUMkrL0m+OQ3pHpWs8s/7DR1NszoalEe7y0MCKlntdNGHP2ltddoDkbz2IuvhVd6DLfh2u30b5Wu/fLP2wOWNybLalirGNFWNAcP3qfvWr7xxb5F7ztMvXD+CB+xVjFk5jdIffESlza60EkiSaBgU+JOf/jJVceLL9PYbW0m5IwzKyUUfiD980MlDlW2ozn0gLuoifKAZPlBl+xIu06ramqrTdP3L9FWMWTkNgIp6sm+qEQrTarwiSG0GoPJXx79IVZwAFXPlLS1ThEMZtNUHqh5IVNWGtlVv5AttSZd8oOr2JQ4WVc+a6rZfroNKFWNWTgOgYhBUqmhAAlA5/MlTVMUJUEHHVoVfIg34UZIPmBxIlPW5Jt5T2bwgHupdl32ga3XZdVCpYszKaQBUHAGVQ+NnqIoToIKOrssdHfJu1v+bOJBo4j3BD836IfRtp75dq8uug0oVY1ZOA6DiCKg88bdfoCpOgEo7G3B0zCjXJvhAEwcSTbynJpQV7gFthms+0LW67DqoVDFm5TQAKo6Ayp8+eZKqOAEq6Jxc65xwv+74bBMHEk28J/i0Oz6NsmpOWXWtLrsOKlWMWTkNgIojoPLhT3yOqjgBKs1pdNEBoiza5gNNHEg08Z7aVu7ID9qyOnyga3XZdVCpYszKaQBUHAGVD/3VZ6mKE6CCDqWODgU2uulnTRxINPGeUD+6WT9Q7nrl3rW67DqoVDFm5TRKgQo7C876NOBCWvuLz1RyAlT0Gkp0NNAPPpDuA00cSDTxnuBDaEfgA8V9oGt1OQAVF8fbVY9bC32Zno3jdFuDpjSQLlY+3HN9gA6t3dS6Ke1LcB/wIzf9COWGckvygaa1LybvB2Pt2VhbDCqEAwpAASgABaAAFIACUAAKQAEoUJMCAJWahIYZKAAFoAAUgAJQAApAASgABeQKAFTkWiEkFIACUAAKQAEoAAWgABSAAjUpAFCpSWiYgQJQAApAASgABaAAFIACUECuAEBFrhVCQgEoAAWgABSAAlAACkABKFCTAgCVmoSGGSgABaAAFIACUAAKQAEoAAXkCgBU5FohJBSAAlAACkABKAAFoAAUgAI1KQBQqUlomIECUAAKQAEoAAWgABSAAlBArgBARa6VOORP//RP04033ogTGsAHWuoDr371q+mnfuqnafPmG3FCA/gAfAA+AB8Q+8CrXvVq8XgSAYkAKga8gCEFBxSAAu1VgOs4Q8qpU4QTGsAH4APwAfiA2Ae478AhVwCgItdKHBKgIpYKAaGAkwoAVABogFT4AHwAPlDGBwAqxbp9gEoxvUShASoimRAICjirAEAFA5QyAxTEgd/AB+ADAJViXT9ApZheotAAFZFMCAQFnFUAoILBBgac8AH4AHygjA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYoZQYoiAO/gQ/ABwAqxbp+gEoxvUShASoimRAICjirAEAFgw0MOOED8AH4QBkfAKgU6/oBKsX0EoUGqIhkQiAo4KwCABUMUMoMUBAHfgMfgA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYbGHDCB+AD8IEyPgBQKdb1A1SK6SUKDVARyYRAUMBZBQAqGKCUGaAgDvwGPgAfAKgU6/oBKsX0EoUGqIhkQiAo4KwCABUMNjDghA/AB+ADZXwAoFKs6weoFNNLFBqgIpIJgaCAswoAVDBAKTNAQRz4DXwAPgBQKdb1A1SK6SUKDVARyYRAUMBZBQAqGGxgwAkfgA/AB8r4AEClWNcPUCmmlyg0QEUkEwJBAWcVAKhggFJmgII48Bv4AHwAoFKs6weoFNNLFBqgIpIJgaCAswoAVDDYwIATPgAfgA+U8QGASrGuH6BSTC9RaICKSCYEggLOKgBQwQClzAAFceA38AH4AEClWNcPUCmmlyg0QEUkEwJBAWcVAKhgsIEBJ3wAPgAfKOMDAJViXT9ApZheotAAFZFMCAQFnFUAoIIBSpkBCuLAb+AD8AGASrGuH6BSTC9RaICKSCYEggLOKgBQwWADA074AHwAPlDGBwAqxbp+gEoxvUShASoimRAICjirAEAFA5QyAxTEgd/AB+ADAJViXT9ApZheotAAFZFMCAQFnFUAoILBBgac8AH4AHygjA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYoZQYoiAO/gQ/ABwAqxbp+gEoxvUShASoimRAICjirAEAFgw0MOOED8AH4QBkfAKgU6/oBKsX0EoUGqIhkQiAo4KwCABUMUMoMUBAHfgMfgA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYbGHDCB+AD8IEyPgBQKdb1A1SK6SUKDVARyYRAUMBZBQAqGKCUGaAgDvwGPgAfAKgU6/oBKsX0EoUGqIhkQiAo4KwCABUMNjDghA/AB+ADZXwAoFKs6weoFNNLFBqgIpIJgaCAswoAVDBAKTNAQRz4DXwAPgBQKdb1A1SK6SUKDVARyYRAUMBZBQAqGGxgwAkfgA/AB8r4AEClWNcPUCmmlyg0QEUkEwJBAWcVAKhggFJmgII48Bv4AHwAoFKs6weoFNNLFBqgIpIJgaCAswoAVDDYwIATPgAfgA+U8QGASrGuH6BSTC9RaICKSCYEggLOKgBQwQClzAAFceA38AH4AEClWNcPUCmmlyg0QEUkEwJBAWcVAKhgsIEBJ3wAPgAfKOMDAJViXT9ApZheotAAFZFMCAQFnFUAoIIBSpkBCuLAb+AD8AGASrGuH6BSTC9RaICKSCYEggLOKgBQwWADA074AHwAPlDGBwAqxbp+gEoxvUShASoimRAICjirAEAFA5QyAxTEgd/AB+ADAJViXT9ApZheotAAFZFMCAQFnFUAoILBBgac8AH4AHygjA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYoZQYoiAO/gQ/ABwAqxbp+gEoxvUShASoimRAICjirAEAFgw0MOOED8AH4QBkfAKgU6/oBKsX0EoUGqIhkQiAo4KwCABUMUMoMUBAHfgMfgA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYbGHDCB+AD8IEyPgBQKdb1A1SK6SUKDVARyYRAUMBZBQAqGKCUGaAgDvwGPgAfAKgU6/oBKsX0EoUGqIhkQiAo4KwCABUMNjDghA/AB+ADZXwAoFKs6weoFNNLFBqgIpIJgaCAswoAVDBAKTNAQRz4DXwAPgBQKdb1A1SK6SUKDVARyYRAUMBZBQAqGGxgwAkfgA/AB8r4AEClWNcPUCmmlyg0QEUkEwJBAWcVAKhggFJmgII48Bv4AHwAoFKs6weoFNNLFBqgIpIJgaCAswoAVDDYwIATPgAfgA+U8QGASrGuH6BSTC9RaICKSCYEggLOKgBQwQClzAAFceA38AH4AEClWNcPUCmmlyg0QEUkEwJBAWcVAKhgsIEBJ3wAPgAfKOMDAJViXT9ApZheotC2QWU0WKCFhQUajNJud0QD9fvCwoBSg4hyikBQoJsKNAFUVvt+Pe+vpg0WRtSf1PPVUxhQlBlQIA78Bj4AH6jaBwAqxcYNAJVieolCWwWV0YB6w7G6TwUjvSHxX/FjNOiRHyQIm5wtzsfOnTtLnTt27CgVr6y9IF5ddvv9Pv3sz/4sDQYDL5933nkn/eqv/ipt3rzZ+79uPiTx68pr/F507YoqUcMDWQeV1QEtLY/p1CkFI0tDWk8AkdV+j5bX1SBjGjZ5wPEzP/Mf6D/9p9fRz/3ca5T/3kive92v0etfv9P4uX37DuM2kvIBu+bLlnW3obMNm7by2k27v6baPPfBCaBSrIMHqBTTSxTaJqiM1MDZnyVJAxV1PZhqyQGVTZs2ifKbFOizn/1s6bg6Eeuwe+jQIdq9e3fkNsN2GVqOHz+ukw1R3DryWnXZMvS04bANKqv9AfmzJGmgoq73R36nngMqV175immRHD16lHbt2lVLEbnovzrCIL866sniQmOZTrqhbOnMD1QAKrql5158gIqBMrMHKmMaDiazKOMh9ZLWfqnrA286hWg87GUsDyMCqCQ7B8+iBMfJkydpZWWF7r///imcnDlzxpthMX3Y6ix07AJUqngaOKbl/mQWZX1ISwGQeOAyOdX1vjfjQrS+3MtYHkYUBhX22QcffJAYxqs6Tqmb2LdvnzfLyHXngQceIK4jOn6kc2+wq6OePK4NnW3YZEVgV+4XOiEBKjrquRsXoGKg7JoAKrxPJXGPyhRUeJ9K9h4VgMq8cxw+fJjuueceD0p40MV/P/744/Tud7+b7r77bg9QeGBWx4Dcxc6xDl0MVOm5JO3OqMxAhfepJO5RmYIK71MJZl+SISkOKqdPn/Z8uYrj4Ycf9uoE1xs+zp4969UXrjvve9/7qjBROA0X603hTIYidCm/XcprFwEJoKLTErgbF6BioOzsgYo/S8IbbBdClDIeDvw9Kd6hZl1685vt19bW5vZVLC4uegOK8Ll//37v6VHeeezYsdwweWmU+d20Xc7/29/+drrtttvoqaeemuYxsPvkk0/SLbfcQm9+85vpiSeeMKqB6bym6a9jl/e3tOGwCyr+LIlXz0OzKevLA39Pyik+FcwszW+2X1lZo23bdkbOF7xgUaW10zu/5Vt20rd926/Rt37rf6AXvegbarbl6955/fVn6Bd+4WuqLfgKLS9/ifbuPUUf/OAX6Nixz6X6+KOPPuotI0vzo1/+5V/2Zm7K1HOdODr+C7v5bX+gkQ2dbdjk/MKu3C906tDWrXdg6VcbOtCCeQCoFBRMEtwmqEjuTxoGMyrzSvEa/le96lXET51vuukqBXebvPN1r3v59O/t26+gf/tvv53uuONfTa8F4ar8f9hmlenmpSW3e+OcgJhRqWLpV7Vp/NAPvYLUc4rp+f73n6Uf//EtaokW0XBIyodJAQopfydaWiK69FKiCy4gBTb+eeGFRFddRXTzzaRmYkgthSQ148hxZkskk9ocBv3t27dLm6PKwuGpe2VSZiZkQ2cbNrs4s2FLZ8yo1FN3m2YFoGKgRAAq7V2zy0u+fviHf9jzmp07L1b/VSM1nIkaMPDED4BKtZBRxcbS+NIvnl3lfVd5h2J1taSLSE0yqpdLEN16K9HVVxOdfz4DzGF67nPv8cCGeYXDnDgRTZEHOzb8wdYgC3bzPEr/d2isr6EkBVs6A1QkpdO+MAAVA2UKUGkvqPAg7vWvf716+sxL5QAqWZAGUGkelCSBTRhUeJN73kyIpMn84z9eoze+cU0t/SK69trZDMzFqsrwzAzP1jzxxOe9jfU8S1nnYWuQBbvmSxkam9fY5gwSQKWe8m2aFYCKgRIBqLQXVHhNPe9Tueuuu+i1r1XrXzCbkqoBQMUtUDly5IiaFblVzXzEpj5KtJEMH/z2sPDBPMKAwjMvl1ziLxt7/vN30X/4Dye85WI8Q1PHgcFsHSrb6QNQtu0tW84ZQKWe8m2aFYCKgRIBqNjppOp40sNvLQqWq2zf/p31g8p4gXrqZQjjNEAa8YsUyi1HGw9V2uqsCr4AKm6AyqWXfr/n00O1IYX9u6ojb/8Jz6j86I9uURv1/eVi555LdM01/r6YClgpNRsYzFZVwtnp2NDZhs06+p00pbuWX4BKPXW3aVYAKgZKBKDSXlBhd+FXt47HYytLv/Jggl9LXSVs6EALQMUNUInvUamqSeRvp/ASybTj3nvvpYMHD3o/Mx8dOODvZ3nxi/3ZFt6gz3tf1KeKKj26NrjrUn67lNcuAhJApdKm0JnEACoGigqg0m5Q4afOW7ZsUW/1+q7E2Qd+/fNAzWzwIJ/BYTrDkTAbwuDhvWaWz9hMifctHJ7lUL8F8OF/Hyc068EzKJP4HCZsOw4ZiXFDNjnuUN1jEC9yb6FZGu968O+J/dFkhiecBkCl26DCTetuRRp79uyJtLJcfxj2l5eXU1tf/t4kfzOVoeWcc/y3jfFKsiqWh2Ewa6DTS0jShs42bHYRGGzpDFCpp+42zQpAxUCJAFTaDSqBy/zqrz4/EVTCQDBQg//eZFAfnw3xBvwhUIjPhnjfu4nBSwQmGHwUpARw4UFR6N9xUInbj4MJ32uwpCx+bxEACi0v8+5ZxfNAJQZiABWACtcV3tfFYM9LwXiJGZ+8H0Y62GFo4ZmWF76Q6Lzz/NcgTyZi5lpvhiD+CGtg52YVmKGIXxIQHFK7VXcNsFu1ovPpQWPzGtsEM4BKPeXbNCsAFQMlAlBpP6jwa4r7/W/LBhU1oOfZjwAAeLAfzDwwRAziUMEAEIKFud8ncYI05pZ5xWY35pZthfevxPeyxP6deG/hWZTJ3wP1f74PhiWGm/BsD0AFoJLVvBYdVPLyMN50f911/iwLf89FMYn3ATg+eAM/AxEvywwfXFf5evB2saJ2q+oiYLcqJdPTgcbmNQao6LfrmzffWE9BtcQKQMVAQQJU2g0qPPDhV7j+2q8tJoJKMGDnATxDhQcqPNsQ3uQegxIPKsLXkjbNx67lgc4cqITiB3ARXuY13dsSWk42XZbGy8uC+w/yMgGxIK04iAFU9Du0Kr6TkpeGqT0qeU2rzqCS962oF+8Rv+6YZ1luu+2senvYltSXAfBMC7/RjP+vYzcvT1WCmY6tcNwu5bdLebUJDLZ0xoxKVa2CW+kAVAyUF0Cl3aDCkMJfpk/7jkqwxIpnG7yZE977MZl1mMJDAqiEZ0iSNs3Hr8VBJbJ3JOWtYBxnFIemyV6a6WxIEkSF05sAD+eJQcwDlYQ3hgFUACp1DNx5luX7vu8BtezxEL3ylaQ28CdbPay+TsnfbbE1yIJdA51tLElobF5jm4AEUKmnfJtmBaBioEQAKu0FFZ5N4TXvfKR+8FEN9HnfRjDw9/apxF8pHNtf4s2mMERMgGBu43scJtS/eQYjPguS98Yvb69JHJomaYU30kcgaHJvkd9De2+CfSrh3xnIACoAlTpAhW3cfvvtat+Lv3+FX3N82WWkvnfkv00sfPDeFQxmDXR6CUna0NmGTZsD967lF6BST91tmhWAioESAai0F1T4dasPP/xwLqiEoYMH/ZE3dQWzE7ElVuH9K/GN7jzwn7s2gZ3gjWHezE3orV1JrxaOvIUsNEsS3kg/XYYWvI0sBFBBmuE8paUJUAGo1AUqd/IrwiYHf4NF7dv3vs3Cbw3jj0wGwMIb+rs2uOtSfruU1y4CEkDFwIDVgSQBKgYKCaDSXlAJvkyfOaOSsuxK55skLsYFqABU6gKVXbt2ze1P4b05agKFLrhgBiy/9EtbACoG+rykJG1Agw2bXQQGWzoDVGqqvA0zA1AxUCD1gcpI7X8YqlfKBsfYe+q+sNBTT9YzMjYeqtfaDtQyo+xj06ZNpdWx1ZCZthv+Mn3q0i+AivIbLP3K28Qu/31E/aUhrauBtx9nTMtLfj1fXs+AofUhLal6vjqNlxzWxc308YaJPxy5d+/exPaK30zMqzW/9Vv3qlccH6D77vtS6XZNJ6Lptint3rpkt0t57SIgAVR0WiB34wJUDJRdXaDiL7mZ4cZ42FNLjFSGGERC18NZ9OL0eqm/h8MCVJKdg/eo8HcgACqhD08mwBlmVKqZUVntqzrbH00ghWh9uUf9VZU2g0joehh8vDhLvdTfw2HbACpcU3n/SfAK4njN5b1l27bxN1yInve8Z709LI88YqDxz0gSg2jzekNj8xrbBCSASj3l2zQrABUDJVILqIwGCjYG6svl42kORurfPraomZYUUPF/VnEzp1z8JAEqyc7Bsyq8eTfty/QuLtMycc8AlQpAZXWgYGNA/eXxFFRW1b/9WRI105ICKh6IcNxQvLQZnLaACtfLu9Q7i/mDjwwmfPD/h8Mh8dKw4KOPTz75OfVdFX/TPX/xXr0MrJYDg2jzMkNj8xoDVPTbdXxHpZifAlSK6SUKXT2oKPCYbGz2AINnTHjJlwKOMI+MBpMlXzkgMp15yckNQCVboGuu+ef0sz+7gW666WL1DYeL6MYbF9X3HF7ive2qjvN1r3t5LXbieZHbvXFOQH7q3YaD6zh3NvLlW5LOTYHHpJ57gMEzJrzkSwGHN4PiwQnRan+y5CsHRKYzL5N4bQeVwK/4NcQ868kb7BlSePYzfASDWf4u5A03+B+P5LeF8SZ8kwcG0SbV9dOGxuY1tqkzZlTqKd+mWQGoGCiR6kElepMMGrMP8YX2mnh7T/L3qMxmXrIzD1CROQd/U+Xpp5+WBa4wlIudMkBFAix+GAaNcD2f7jXx9p7k71GZzbxk22zLjIq0asXrjdreQldc4b8lbPfu+VcaS9PNC+difc3LU9bvNvJrw6bNgXvX8gtQ0amR7sYFqBgoO9Og4t+y2jg/CG+k5xVd/rc4wsu6xsNBbGP9fDxOjV+7y4PI8Lm4uOh9gT187lcfJ+DGMe88duxYbpi8NMr83iW7LuZ1x44dBmpc/UmamVFJAgq1cb4f3kjPMyp+PQ8v61pfHsQ21s/HY/hZWVnz9mqEzw0bLipdz8vU0SBO0/z33nu/RC94wTfpkkvO0r59pypvv5qWX52yk8S1kV8bNlkL2M0fE0h8Ji/M1q13VDyLLX9wVOXsOZZ+FeuzASrF9BKFrgdURLeiFQgzKnL5bDzZsmFT9+khZlTsdIxZnWzXZ1TCtZx14m+w8HIwXhZW5XIwF+urvAWcD2kjvzZs6raJrmlsM7+YUdHxFnfjAlQMlB1ABWuFDbjVXJIudsoAFYBK4MhN9l/eYH/VVf5yMLXNpZKjyfmtJIOxRGzk14ZNmwP3ruUXoGKipjY/TYCKgTICqABUDLgVQKUOUYU26lv6ZR5sMKOSXugMKQwrDC2xPflCT5kF69qg0kZ+bdgEqBSuCqUjAFRKS+d0RICKgeIDqABUDLgVQKUOUYU2ACpCoTKCuTKo5OVf113nv86YPxyp3oJc6nAlv6UylxDJRn5t2ASoVOUx+ekAVPI1amMIgIqBUgWoAFQMuBVApQ5RhTYAKkKhWgAqQRb27SO68EL/DWFlZlcwiNb3mbwUoHGeQtX8bktngEo15edaKgAVAyUGUOkWqPDriZ988kkDnpSdpK3OQscu9qiYX8pV9O00WPolr7qsLW+y59kVfpVxcPCHJfmjkuzf29VufP4gLL8hMXzo1Bv5Hc6H7JLdLuWVS7pr+QWo6LQE7sYFqBgoO4BK+xtQ/go2fwGbByb8cTkenGxRn7t+8MEHDXhUcpIudlIAFYBK4M0u+m94duWCC4iuvpro935vxYOU4Mv3QRh+5Tu3CdxWdHFQaaN8bdhE2dbW5RFApT6tm2QJoGKgNAAq7QYVHnjwE1P+AnZ80HXgwAEPWuo4XOyUASoAlTaACueB96788A8fpec+9271gCK5xo/HY+9BBgazdbSI7e53khR0sQ/Q8QSAio567sYFqBgoO4BKuzsMHnjwACR8hDuMg+pT13XMrLjYSQFUACptARXOB38M9957z9J55/lLwtQq0LnjrrvuopMnT3ZumY6N9smGTUCogUFUSpIAlfq0bpIlgIqB0gCotBdUeD9K0mA73kHeeeedBjwrmqSLnTJABaDSJlDhmVU+eHP9ZZcRXXwx0eOPR+vp4+rCysoKQMV4i9jefidNOhf7AB03AKjoqOduXICKgbIDqLS3w+B15/FNsklP1HarnbaneOetwcPFTgqgAlBpE6iE/fnMGVJ7Uvyv2sc32u/ZswegYrAtbJNPFZHJxT6gSP7iYQEqOuq5GxegYqDsACrtBRVe1vXwww/PeU28w+CBSXx5WNWu5mInBVABqLRpUJnkz/yyL/5I5LXX+mXNsymYUam69UtOz8U2UUeZruUXoKLjLe7GBagYKDuASntBhZd+BZtjw64T7zB4Q338LUBVu5qLnRRABaDSJlDhtoBfTRw/eAvbxo3+UrDXvOZOry1wsb7qtFk28mvDZtKMuo5uReJ2Lb8AlSLe0Z6wABUDZVkHqIyHPVpYWKDeUPWI02NMw95CwvVwkCH1VLyFhQGNcvK+adOm0uq0uQFlCGFgSQMVHrjwBlrTh4saA1SKgcr6sl/Pl5bH3tN5/xzT8pJfz6PXQ2mvD2lpUs9Xp/GSbeM7KuVrKgMIv4I46aEEv5X4mmv20f/5f67QAw+09+FNmno22icbNgEq5etP0ZgAlaKKtSM8QMVAORoHlbGCjQFjBoNJCDhGA/Iu8/XBUP13/hgNeuSxzTRsugAAlWRt+A0+PDgJw0rQQfJvvMHW9GyKq50jQKUAqDBs9EcTMBnQFDhWB9RfnQBLf0jrCSCy2u/R8roKMw2bbhegotcJ8IOJW2+91VsSGuxL41eXs6/vU5+z51cX81vBNm/+mvqmip6tMrG7NHjvUl5d7QPK+HAQB6Cio567cQEqBsrOOKiEIGOkXo85mxkZ0cB7ijqBkYy8jYcDH1gyDoBKujg8OOFXk/JHH/mtPu9+97u9JWH8ti/Tm+iDu3KxUwaoFACVEGSs9kOgcmpE/Uk992AkAVSCa+vLAx9YMsIAVKrpBB555BEPTrgNYEAJtwOHDhG96EXfoCuu8L+/UufhYjtRVp8u5RWgUqAtzWj/stpGU79t3nxjWRfvZDyAioFirx5UAgCZLPVSoOIv+VLXe7OZk+lsyXTGJTlzo0F8yVhyOIBKvnMcPXrUG5TEByb5MfVDuNgpA1SyOtcAQCZLuhSo+Eu71PWl2czJdLZkOuOSnOZqP2NpWKjjBqjo10VJCk8++Tm1FIzowguJ1Ds5ajtcbCfKitOlvAJUACpl64lr8QAqBkqselCJ32TSXpTQMrApyMxnjiHFXx6WfwBU8jUKQtjoIG3Y1O0cASpFOtekvSh8bTK7MgWZ+TQZUvzlYfknQEVez3VCcn3lpV9qIpbOPZe8fSt1HC62E2V16VJeddvishrbtIulXzql5m5cgIqBsjMOKgpEeCPtQmg2xctGcD20UT66xGs2MzMXN0EHgIrcOWx0kDZs6nZSAJV8cJjChQIRr56HZlO834Lrqp4H+1aiS7xmMzNzcRPABaAir+c6IcP1lfetMKyo93IY37fiYjtRVucu5VW3LS6rsU27ABWdUnM3LkDFQNkZBxUD98wfMuRBZPhcXFz09mGET/7YIXcGeeexY8dyw+SlUeb3Ltl1Ma87duww4L31J8l1nNcZS2YsmhRmZWWNtm3bGTk3bLiodD0vU0eDOC76b5X5feihZ+gFL/gm9Xp/T8eOfc5Ye9klnbuUV/bFruV369Y7nGtzk9p/7FEp1mcDVIrpJQrtIqgkZQwzKqLi9gLZeJJnw6ZuXjGjUmBGJWH2wwT0YEZFXs91QibVV/7eyqWXEl12mblN9i62E2V17lJeddvishrbtIsZFZ1SczcuQMVA2QFU7AzcbTagNjpIGzZ1NQaoAFSCJtdF/9XpLtLyy59kCjbZq7caV350Secu5VW3LdZxNFs6A1R0Ss3duAAVA2UHUAGoGHCruSRtdRY6dgEqABWAynzrwJvs1adYvO+tqLccV3ro1FedG7Fh14bNLgKDLZ0BKjo10t24ABUDZQdQAagYcCuASh2iCm24ukclaekYln4JC10zmGRwd9ddROecQ95HIqs6JHarshVOx4ZdGzYBKia8JzlNgEp9WjfJEkDFQGkAVAAqBtwKoFKHqEIbABWhUBnBMKhMFmfvXh9WGFqqOLqkc5fy2kVAAqhU0SK4lwZAxUCZAVQAKgbcCqBSh6hCGwAVoVAAlakCRQbR6iWM3jKwLVv0X19cxK5+qc5SsGHXhs0uAoMtnQEqVdZQd9ICqBgoK4AKQMWAWwFU6hBVaAOgIhQKoFIKVDjSoUP+V+yvu04PVmwNKm3YtWEToKLfFkhTAKhIlWpXOICKgfIEqABUDLgVQKUOUYU2ACpCoQAqpUGFIx45QnTJJURLS0T8drAyR5cG713KaxcBCaBSpgVwPw5AxUAZAlQAKgbcCqBSh6hCGwAVoVAAFS1Q4cgnTviwctVV87AyVh9iOX78eGZhdGnw3qW8AlSa9wZF6Xeu8MHHYv0HQKWYXqLQAJVugcop1Tod4nUaNR8udsp4PXHzOle89aueiqtTX3kAxKDCwPKJT5wirkd8PvDAA7R79266/fbbad++fYkZ0bGro4wNuzZsdhEYbOmMGRWdGuluXICKgbIDqLQfVM6qDx/cc8893mCBBwr8fx4sPFjle0VzfNNWZ6FjF6ACUAncWsePdJptV+3y0q+Xvew4Pf/5WzxYiR8PP/ywelPY/KvCXM1vmTLuUl67CEgAlTK1wv04ABUDZQhQaTeonDlzRr2NZ4taP64WkE+OoIM8ePAgbd++3YBXzSfpYqcMUAGoAFTKNw/9/hb6t//2DL34xf7+lfjBsypr/Mqw0OFiO1FWoS7lFaDSvLYUS7/K1tzseAAVA7oCVNoNKjzY5rXhaYMBhpU9e/YY8Kxoki52ygCV5nWuWPplvKp6BnTr64EDB2iv+sgKf8We3wTGbwRLgpU777wToFJPkc49qKrZrLZPlb1fXV8uaxczKmWVczseQMVA+ZkAlfGwRwuD0fzdjgbUGwaD5hENFhZowTt7NL0ciTULk5RcOOimTZtKq2OrITNt97Raf5E02I7brWNAbjqvaYWvY7cOXUo7bYGIpjbTry+ret4f0dyTudUBLS2PJ9dH1A/V8+X1JPiZhemvZsMRQKVAwWsE1ak3bJaXmh49etS7gyxYidcxXbtls2zDrg2bVUCoSxrbzC9ApaynuB0PoGKg/KoFFR8ser0ezYOF/1vi9TQKGQ9p6PGOiptDKgCVeefgZRX79++f+yHeQfK+Fd5kb/JwsVMGqKRBgw8WS0s9mgcL/7fE60lQo9zu1PqQlj1AUXHTwnA4dQJUTNbSWdq69XU4HEbe8JUGK4PBIJIhXbtl1bFh14ZNmwP3ruUXoFK2NrodD6BioPyqBRX/BkeD+RkSvsadUnzmZKSuJcy9THPqzc4sZIfhwACVeefgZV28aTV+xDsMXvoVXx5Wtau52EkBVLJnN1b7PYrPkPC1fn+QcH1AqxPYSFob7c3OqHqeFQagUnWtTE9Pt77ymwWTHpLw1+vDy8B4/1z40LVbViEbdm3YBKiU9ZDi8QAqxTVrQwyAioFS1AOV2dKs2ZKuMQ17UbBg2ODf56BEzZgMktd8RXMaWTKWLAJAZV4XXvp1991354IKb6jnTfcmDxc7ZYBKACqzpVmzJV1jWl6KggXDBv++qkAlAhxqxqQ/XQqWAT+RJWPJ4TCjYrKWztLWra/8pkGGEP5//Ahg5e1vX5t7TbGu3bLq2LBrwyZApayHFI8HUCmuWRtiAFQMlKIeqCTdUHyZFoNLsBdF/T+0hGs8nJ9hmaWo4g2GNFYXGHSwR6Vc4TOEMLCkPbXkD7AlvSa0nLX0WC52ygCVrBmV+DItBpdQPQ8t4Vpfnp9hmc2qqHj9Ia2fImLQwR6VaB1ysd4EOeA3DaY9BLn++kN03nl3zm2wdzm/RdvMLuW1i4AEUClaI9oRHqBioBwrB5W0WZK56zMQSYITvuYv+1KDn54PLFkHZlSS1Tl58iTdeuutEVgJOkj+7eabbzY+m+JqJwVQyQCVtFmSueszEEmCE77mL/tS9XzJB5as12ZiRsVAJ5CQZFWDaF5SyjMrPLPLy1D5lcT8pq97792T+DawquwWVcmGXRs2XW2Li5Zn2oM5nXSKxgWoFFWsHeEBKgbKsXJQMXCP8SR5k3jwtePg/4uLi94emPDJa6S5M8g7jx07lhsmL40yv9dll59s3nbbbbRr1y5697vf7X3o8fWvf72nVV33UJedeDno2N2xY0cN3mzehKm3fknfw1823MrKGm3btjNybthwUel6XqaOBnF0/Ah2P0sf+chHvD0rH/zgB6dt7dNPf5Ze9aq/pxe84Jv02GOf9653Secu5bVrZcv53br1jsyHLmXbxbrjbd58o/lOqkUWACoGCtNFUEmSATMq+c7BTzdXVlY8WIkvB8uPrRfCxaeHmFHBd1QCr3fRf3VqbF35Dd4GdsklRCdO6H+/pWye68pvE57028hrF2dyMKNStja6HQ+gYqD8ACrd6hxtdRgudo4AFYAKQMVApxNLMgwrhw+fNG8wwYKN9smGTVvtfxftAlSsVGXrRgEqBooAoAJQMeBWc0m62CkDVAAqAJU6WgdSM7xEV11F9C/+xTe8v+s+bLRPNmx2ERhs6QxQqbsWN8MeQMVAOQBUACoG3AqgUoeoQhuu7lFJWouNzfTCQtcMZmNwx4DyQz/0Dx6w1A0rNvJrwyZARbNiFIgOUCkgVouCAlQMFCZABaBiwK0AKnWIKrQBUBEKlREMg0p9DSUpHDv2OeL9KktLpL7BIolRTRgb5WvDJkClGn+RpAJQkajUvjAAFQNlClABqBhwK4BKHaIKbQBUhEIBVKYK2BxE86Z6hpXrrqsPVmzk14ZNgIp+WyBNAaAiVapd4QAqBsoToAJQMeBWAJU6RBXaAKgIhQKoNAJU+CaOHiW68EJS34DSLztJCjagwYZNgIrEG6oJA1CpRkfXUgGoGCgxgApAxYBbAVTqEFVoA6AiFAqg0hhQ4RtRn39SX68n9YFI/fLLS8EGNNiwCVDJ84TqfgeoVKelSykBVAyUFkAFoGLArQAqdYgqtAFQEQoFUGkUqPDNHDjgw8o99+iXYVYKNqDBhk2Ailk/CqcOUKlP6yZZAqgYKA2ACkDFgFsBVOoQVWgDoCIUCqDSOFDhG9q3j+jcc/3/mzpsQIMNmwAVUx40ny5ApT6tm2QJoGKgNAAqABUDbgVQqUNUoQ2AilAogEojQYVvas8eH1Z4hsXEYQMabNgEqJjwnuQ0ASr1ad0kSwAVA6UBUAGoGHArgEodogptAFSEQgFUGgsqfGO8V+X88/29K1UfNqDBhk2AStWek54eQKU+rZtkCaBioDQAKgAVA24FUKlDVKENgIpQKIBKo0GFb+6mm4guvpiIX2Fc5WEDGmzYBKhU6TXZaQFU6tO6SZYAKgZKwwSojIc9WhiMQnc7pmFvgRYWejQchy6PBuoaXx9QOPQsxIgG3u8LFEkuQYdNmzaVVgcdRmnpxBFd1Hjnzp3i/DU5oClQWV9W9bw/otkX5Me0vOTX8+V1ml1fndXz1VOh69O/R9Sf1PP+atLvs2v4Mn09ntbU+sofgeSPQW7cWO3X623k14ZNgEo99YetAFTq07pJlgAqBkqjWlDxwaLX60XAgsHFA43xkHpT4phBSC9CL2G+GdLQIxgVNodUACpy57DRQdqwqdspA1TSoMEHi6WlHoXBgsHF+/f6kJamADODkKXlcQhqQmmr8MseoKiwEfCZtw9QkddznZBNrq+nTxNdeinRK19Z3QchbeTXhk3dNrGtPqWTr7S4ABUTqjY/TYCKgTKqFlT8GxwNojMno0EwYxICjim0qGu9IY1T8ubNzqTOuMwiAVTkzmGjg7RhU7dTBqhkz26s9qMzJ6v9AfkzJiHgmEKLurY0pHXv9/nTm51R9Tx5xgUzKvLaXU3IptdXXvrFH4S8/XZ389t0jatRdpZK1/ILUKnag9xID6BioJz0QCVpVoSXeUWXck3BRS31ms6eqL/9SRIVfpAOKhPymcVL0QCgIncOGx2GDZsAFd8n9Jd+Jc2K8DKvKFhMwUUt9ZrOnqi//VkXFb6fDioevITjpQANZlTk9VwnpAv19dAh/xsru3fr5NSPayO/NmzaymsX7QJU9OuliykAVAyUmh6oJN1QwjItnj3x1qCHZloCaIksBwunNwOY6dKxjPwDVOTOYaODtGFTt3PEjErWjErCMi2ePZnU8+kelQA+IsvBwunOAGa6dCwFUhhmACryeq4T0pX6urLiv7aY/69z2MivDZu6baJrGtvML0BFx1vcjQtQMVB2lYOKAo9BbM/JaOBviI/uRQlmY8LLxKKzK/6yLxU3Y2lYIAlARe4cNjpIGzZ1OymASgaoKPDox/acrPb9eh7dixLMxoSXiUVnV/xlXypuxtKwYLkYQEVez3VCulRfeUaFZ1Z4hqXsYSO/Nmzqtoll9e2iXYCKjre4GxegYqDsKgcVA/cYT3JtbY14EBk+FxcX1YZ7tZwsdO7fv9+b0s87jx07lhsmL40yv3fJrot53bFjRw3ebN6E/tKv7L0qSXtOqri2srJG27btjJwbNlxUup6XqaNBHBf9t0v5vfHGr9F3fdc36c///ATde++9no/80i/9Et1222300EMP5bbvNsrXhk32CdjNHxPo1J0g7tatdyS/PETNDFfRPtaVxubNN5rvpFpkAaBioDBdBJUkGTCjku8chw8fpgcffJCWl5fV00eNx4/5puZCuPj0EDMqzetQMaNSovKViOJafeXXFr/85UfpO79zCz3xxOFpjs+qH/bu3es91OK/0w4b+bVhs4szG7Z0xoxKiYanBVEAKgYKEaBiZyNlnR3GeDymLVu2eB320aNH6YMf/CA98MAD3lPHkydPGvCq+SRtdRY6dgEqAJXAk3X8SKeCwa5MvTNnztBrXnM7/V//11m64Yb5ONwGZtVnGzrbsFlnvxMvha7lF6Aiq7ttCwVQMVCiAJV2g8rx48c9IAk/TQw6jNPqgwS3q/d78v9NHy52UgAVgApAxXTLEE2/bDtx9913E8PIkSNE559PtGvX/H0Ph0P1uwqQcJS1q6OODZsAFZ0SKxYXoFJMr7aEBqgYKEmASrtBhSGFnzaGj3AHyTMqu5J69Yp9zcVOGaACUAGoVNwQ5CRXtp24+eabpyk//HDym8D4oQ3DCkDls/UW6sRa2bLVvVlbdgEquiXnZnyAioFyA6i0F1T4CSM/aYwf8Ya7jgG5rc5Cx24duhio0nNJurqZPmmzKPao1OEx7rWJ8boavAksPoFy5513AlTUhnobh05brHO/tuwCVHRKzd24ABUDZQdQca9TlroBvx3tYX68GDviDfeePXvoBH/q2eBhq7PQsQtQwYwKZlQMNgoJSZetr0l19aabiC65xPdhPnhG5a677gKoAFRqcWqASi0yN84IQMVAkQBU2gsq/Javffv25YIKz7pwJ27yKDsA0b0nHbsAFYAKQEW3BhaLX7a+7lZTKPE2jFe8btxIdM01pPbokbfsi9vEpKOs3WK5i4a2YZPvAHZ1Sk0eF6Ai16pNIQEqBkoToNLuhjtpqUO8o+IN9aYPFztHgApABaBiumWoZvDO+/C4HYu/gpifv1x4Ianfxpl78Wy0TzZsAlTq82eASn1aN8kSQMVAaQBU2g0q99xzz9ybbsIdJC8PS5p1qdrVXOyUASoAFYBK1S1Bdno67QS/ep1fwx6eNWFw2bFjL33Lt+ykd74z+lKR8J3o2C2rkA2bAJWypVU8HkCluGZtiAFQMVCKAJV2gwp31Pzmr4MHD069J+ggV1ZWannjl6udI0AFoAJQMdDpZCSpO3jn9o6/EXXrrbd6303hNxpy26ee19B555GCmGTjunbLqGTDpqttcRl9bdddgIpOqbkbF6BioOwAKu0GlcBl+Iv0vDSCoYVP7sQZVOo6XOyUASoAFduDHRfrjU6bYjK/web6pM9GmbSbpocNmwAVHe8sFhegUkyvtoQGqBgoSYBKN0Al7Do2OkgbNnU7ZYAKQAWgYqDTMTijknW3vLn+ssuIrr12PpSN9smGTd02UccbupZfgIqOt7gbF6BioOwAKgAVA241l6SLnRRABaACUKmjdZjZMN1OqE9LeV+uj7+l2LTdJBVt2ASo1OfPAJX6tG6SJYCKgdKoGlTGwx4tLCzQwmA0f7ejAfWGqqcIDvVvL+zCgBJCR8JF4iXosGnTptLqoMMoLZ04oosaA1TSQWV9eVLP+yPvOxWRc3VAS8vj2TX176Cer8bDhv8dj5cQFh98FFc5rYAu1ldphvnTUuecQ/TII/UBEkClew8EASrSGtmucAAVA+VZLaiMaNAbEqPISO2DiMKH+k1BSZhf5sMkZXA+XlIogIrcOWwMQmzYZEV07AJU0kBlRP2lIa0rkFjtDygKH+o3Vc/7q7O482GS0p2Phy/T6/mvvEWYD6lTb1ywq7boea8tDr5zayO/NmzqtokulG38Hm3pDFDR8RZ34wJUDJRdtaAS3OCYhgMfWIJjNOh5m7hnEyo+gKTOvkwizsdLFgGgIncOGw23DZu6nTJAJW/p15iW+z6wBFCx2u9RX8HL8npwzQcQr54nzb5M4s7HS7aNGRV5PdcJ6WJ9LZJf/gAkfwjyqqv8j0HayK8Nm7ptYhGNmwIMtnQGqOh4i7txASoGyk4PVGawMVuaxdd6ISAh4uVg/HvyDIqCml7y0q/seFExACpy57DRcNuwqdspA1TmYWO2pIsBpBcCEiJeDsa/J8+gKKhZis+++Olnx4sCC0BFXs91QrpYX4vm9+RJohe+kGj7doBKUe3KhO+CT4V1AaiU8RL34wBUDJShHqjEb4ghJQ4dDCKTJ6qhvSvjYTC7MlsuFk0tOV6aBAAVuXPY6DBs2ASo+D7BdXzz5hvn95JMZjOSllhlX2NIiUMHg0ionk9mT9aXg9mV2XKxaNrJ8dLsA1Tk9VwnpIv1tUx++fNSvF/lbW/7YpnoWnG6onEgUtfyC1DRqh7ORgaoGCi6SkFlujl+Ibppnu97PKRBeCO9+nfPWxISnn2ZXzI2Fy9FA4CK3DlsdBg2bAJUDIHKdHP8QnTTPIPP+pD64Y306t9Lk3o+Ww42v2RsLl4KRAFU5PVcJ6SL9bVsfnfvJnre854lfiNYnUeXNNZti3XKxZbOABWdUnM3LkDFQNlVCioG7i8pybW1Ne+DheFzcXFx+jHD4KOG+/fv99Ye553Hjh3LDZOXRpnfu2TXxbzu2LGjJo82a6b6GZW8vSvV/L6yskbbtu2MnBs2XFS6npepo0EcF/0X+c1v+wONfvRHv6q+sXKWnn5aHkdHX44Ln6pHa1s6b916R4Wz2NW0qcVnz8mbjcchVwCgItdKHNJFUEnKHGZUxEWOjaNCqbBHxV7niKVfvpPaehrcNbtPPvk5uvhioi1bhI1DBcG6pnHX8osZlQoqiYNJAFQMFBpABYMBA241l6SLnRRABaASOLKL/qtTr7uY38cf9/erqIn4Wo4ualyLsDEjtnQGqNgobfs2ASoGygCgAlAx4FYAlTpEFdpwdekXvqOCtkno4trBgsEs71fhL9cfP66dZG4CtgbQsJtbNJUEAKhUIqNziQBUDBQZQAWDAQNuBVCpQ1ShDYCKUKiMYBjc6WsoSaEJOoe/ryK557JhmpDXsvdeJl7X8gtQKeMl7scBqBgoQ4AKQMWAWwFU6hBVaAOgIhQKoDJVoGuDynB+g++r3Hmnvt9kpdBljc0qG03dls4AlTpLuTm2ACoGygKgAlAx4FYAlTpEFdoAqAiFAqgAVCYKqBdL0rnnEj3yiL7vpKVgawANu+bKNJwyQKUenZtmBaBioEQAKgAVA24FUKlDVKENgIpQKIAKQCXkAzyjwl+u5xkWEweAwYSq82na0hmgUk/5Ns0KQMVAiQBUACoG3AqgUoeoQhsAFaFQABWASsgHzp4luuoqomuv1fefpBRsDaBh10x5xlMFqNSjc9OsAFQMlAhABaBiwK0AKnWIKrQBUBEKBVABqMR8gL9Wz28Bu+cefR+KpwBgqF7TJgEhQKWe8m2aFYCKgRIBqABUDLgVQKUOUYU2ACpCoQAqAJUEH9i719+vcviwvh+FUwCoVKtnWmq2dAao1FO+TbMCUDFQIgAVgIoBtwKo1CGq0AZARSgUQAWgkuIDN9xAdNllRGfO6PtSkIKtATTsVleGWSkBVOrRuWlWACoGSgSgAlAx4FYAlTpEFdoAqAiFAqgAVFJ84PRpoosvJtqyRd+XACrVaShJyRaYAVQkpdO+MAAVA2UKUAGoGHArgEodogptAFSEQgFUACoZPnDwINE551T3ymJbA2jY1W8PJCkAVCQqtS8MQMVAmVYNKuNhjxYWFmhhMArd7ZiGPXVtoUfDcTwTIxr0hjR3eRJsNOB48fTmhdi0aVNpddBwl5ZOHNFFjXfu3CnOX5MDmgCV9eVJPe+P6NQpmpxjWl7y6/nyenAt+P+I+ktDWp+Gjf6+2p/U80h68TSIrrzyFVakdtF/dYRCfpPV4yahqlcWQ2MdD5XHtaUzQEVeRm0KCVAxUJrVgsoMOkaDAQWowvDicct4SL0IwBB5IBK7NsumSi/1t6gYABW5c9houG3YZEV07AJU5kHBh5IZdKz2B7Q6gQ+Gl/6q+n19SEsx4PBAJBVCVHo5gBLAEEBFXs91QurUmzbb5VcWX3EF0XXX6eTSjwuN9TWUpGBLZ4CKpHTaFwagYqBMqwWV4AbVDMpgNksyg5YYeIwGClwGNJifZvETUr97synqzOMVgIrcOWw03DZs6g4GACppoBKaQenPZklm0BIDj9WBApcB9ZfHodmXUNrq96Cee6AzAZ+k/wNU5PVcJ6SL9bWu/B49SnTeeUQPPqhjEaCip548ti1fBqjIy6hNIQEqBkpTD1QUeExAojeFDb4WXeI1Gkz+zWAShOPZFV7ypa7lQUjSTExcCoCK3DlsNNw2bAJUfJ/QX/qlwGNSz5emsMHXoku8VvuTfzOYBOF4doWXfKlreRCSNBMThxWAirye64R0sb7Wmd89e/zvq3ziE2fokUceobvuuov4wQb/fZanXQQHNBaIVEEQWzoDVCooPAeTAKgYKDQ9UInfEEPKbMnX9FeGEm+gMwOY6V4W73pCHLVrZTorEwacFA0AKnLnsNFw27AJUKkKVBL2m6g6Gyz5msIEQ8mkngd7VKZ7WSb1fC7OKbWvJZiVCQPOqeSZFYCKvJ7rhHSxvtad35e//AB993ffTgcOHFCvLT6jZgJP0cMPP0y33347jflLkTkHNM5TqJrfbekMUKmm/FxLBaBioMQqBZXQUq3ZDMtkH4oaqISv+VmJLhGL/3sKMxmb7QNJACpy57DRcNuwCVAxBCqhpVqzGRaiYEN8+JoPMSEYSfj3FGYyNttjj4q8flcR0sX6qpPvovk9dOgQve51d9EFFxDdfXfUMs+oDNSSZgaXrKOoTZ38hePCblVKZqcDUKlH56ZZAagYKJFKQcXA/SUluba25k2zh8/FxUWvcwif+/fv9zYs5p3Hjh3LDZOXRpnf67b7kY98hO6//35605veRPx3mXsuG6fuvAb3qWN3x44dNXm0WTP6S7/y9qqY+X1lZY22bdsZOTdsuKh0PS/ruxxPx49gN78NrqK+1qnzLbfc4rWf99//RXrOc56lxx77fKQ9ffLJJz0/zbon+JTcL+osWx1b4bhbt96Rud8uay9ek37bvPlGsx1Uy1IHqBgoUBdBJUkGzKikOwcvQ9iivlT2oNr9efjwYXr00UdpOBx6HenJkycNeNV8ki4+xcNmejMAotMJY+lXLdUVb6TKkJlnU7j9DA7+av3GjaT2pkQj5bUfLraJOt7XtfxiRkXHW9yNC1AxUHYAlXa/feX48eMepPAa6uAIOgxemnDrrbfSaf7ssuHDxU4qb6BhWLLKknd1RgVv/Wp325Tk4C60EzxT//jjj09vn/2Uv60S/+zSHrXj/sSJE6n12IW8VtYIqYS6ll+ASpXe405aABUDZQVQaXcDyrMmYUhhFwp3GDyjsmvXLgOeFU3SxU4KoIIZlTjcG68oMQMu1hsdjVzIL8+oMKyEj5UV/6v16qfpceedd2bOWLuQV52yjMftWn4BKlV6jztpAVQMlBVApb2gwrMpd8d3eiY82apjQO5iJ1WHLgaq9FySmFHRV9lF/9XJNfKbrh5vlmcIiR9qcpouu2y2BIzf/pV1QGMdD5XHtaUzQEVeRm0KCVAxUJoAlfaCCr90gF+XmfdkK2+JQhVuZ6uz0LELUMGMSuD7On6kU39gV0c9edyiOnObyTMr4YNX0F58MdH27fwxyAfp4MGDAJWQAkU1lpdedkhbdgEqVZWgW+kAVAyUF0ClvaCStESBXSjecO/evVv03n8d97PVWejYBagAVAAqOrW+eFyd+lrc2ixGGbvcPqzwmq/QoZ4N0bd8yx76T/9JfREy5yhjMy9Nye+wK1FJPwxARV9DF1MAqBgoNYBKe0ElbYlCvKPizfamDxc7R4AKQAWgYrpliKbvWjvBM9bcfm5X0yjB6/Kvv/4QXXIJqb2BzXzS75rGuh5oK78AFd2SczM+QMVAuQFU2gsq7C48W3LkyJGI54Qbbl4etnfvXgOe5fYAhO8eoAJQAagYbxpS26Y6LVc5mA0vAcvKQ5U2i2gFu0XUKh8WoFJeO5djAlQMlB5Apd2gwrMqvKkz/DrNoKPip4FJm0INuJmTr6YEqABUAComWoP0NNsyiOYlYPG3gMVz3Za8Sj2ka/kFqEg9o13hACoGyhOg0m5QCVyGP1DGSxQYTPiVxTwI37dvnwGPSk7SxU4KoAJQAajU1kR4hlxsJ9IU4pd+hd8CBlD5bL3ONLFmy6cAKlaK27pRgIqBIgCotKtzzHMR/qaKjYbbhk3dgQ9ABaACUMlrUar93cV2Ik0BXgKW9CFI+FS1PpOXmi2fAqjklUw7fweoGChXgEq3QEV38F7WBW11Fjp2ASoAFQwqy9b4cvF06ms5i34sU3aTPgQJn9IpqeJxTZVt3p0AVPIUaufvABUD5QpQMddJ5RWXrQbUhl0bNnUHIAAVgAoGlXmtWLW/u9hO5Clw001EV1wx+xAkfCpPsWp/t+VTAJVqy9GV1AAqBkqqalAZDRZoYUGdg9H83Y4G1BuOp9czw05CScJw0E2bNpVWx1ZD1iW7LuYVoJIOKqv9ST3vj+jUqVi41QEtLY+n1zPDTuJKwrCdK698Rel6rhPRRf9FfuUKmCxf9tsLLyS6++7o/Zi0mZVz2JX7hU5IgIqOeu7GBagYKLtqQWVMw6EPKCO1YTuKKiMaKICZ8UtW2Cml+NCz0KMQ3ySqAFCRO4eNjsqGTVZExy5AJQ1UxrS87APKan9AqxFQGVFf1dn+ahA3K+wkjAKboJ4vr2fP4gBU5PVcJ6ROvYHdeQX4vSXnnkt09OjsN2is4ynyuLZ0BqjIy6hNIQEqBkqzWlBRNzgeUi8CJP5NjwY9721TEeBICRtkczxUcZh2YjMxSTIAVOTOYaPhtmEToOL7BNfxzZtvnJ/5iABGwWVe60NaigCJH3+136O+gpcIcKSEDWZi1pdVHAab2EzM3EyNSh+gIq/nOiFdrK9Nz+911xFdfTVARaecysS15csAlTKl5X4cgIqBMtQDFX+WhJ+Ghpd0KbKgQW9I48n9MnDw7/OzLB7CRMKGszgNr4BmkDOlAlCRO4eNhtuGTYBKVaDiz5JwPQ8v6Tp1Sl1fGtL6BHgYOPj3+VkWhpho2DCETMMroOmHlowBVPRmBOUtwnxIF+tr0/N7/DjR+eeTWnXg3yk01ikxeVxbOgNU5GXUppAAFQOlqQcq0RsaDyczJjxTMl3jpZZ49Sbr2UN7V5LDRtPjWRjmk+nMSkb+ASpy57DRcNuwqTsYwNKv5FmW9eXJjAnPlEz3qKglXkuhej65nhw2mi7PwvAMzHRmZQI+ABUMZuWtml7IutonhhSGlRMnULZ6JSaPXVfZxu8IoCIvozaFBKgYKM0qQSVY9pW4pyQ+KzJZ9hUNq6BmMJuJ4SVf3tr10OxMmgQAFblz2Gi4bdgEqFQ1oxIDlslSLq67c3tK4rMiiWEV1PRnMzG85Mur56HZmSRIwWZ6eR3XDelifdXJc5355eVfvAysTpthbWBXx1PkcQEqcq3aFBKgYqA0KwUVA/eXlOTa2pr3ZfXwubi46O2BCZ/79+/3OoO889ixY7lh8tIo83uX7LqY1x07dtTk0WbNGNmjkjHrkQYZRa+vrKzRtm07I+eGDReVrudl6mgQx0X/RX7z234b5fvYY5+n5zznWbr//s+g3xH0zzp+zHFt1d2tW++odl9gDW1uUhvN+xtxyBUAqMi1Eod0EVSSMocZFXGRW3mS5+JTPCz9KrjBvoaOFJvp5fVcJ6SL9dWl/O7aRfRd3/VN4q/X132gbOtRHDMq9ejcNCsAFQMlAlDBFLwBt5pL0sXOEaACUAkc2UX/1anXyK+Oevlxz54luuSSs7RlS37YqkOgbKtWNDk9gEo9OjfNCkDFQIkAVAAqBtwKoFKHqEIbri79wmZ6tE1CF9cOZmPw/tBDz9A55xAdPKh9+4USsJFXvsGu2QWoFHLL1gQGqBgoSoBK9xpQGx2GDZu6nSNmVDCjghkVA51ORpIuthNlFeK83nor0WWXEfEMS11HlzTW7QN0ygSgoqOeu3EBKgbKDqACUDHgVphRqUNUoQ3MqAiFwgB6qgAGs/o+k5cCa8yzhhdeSLR7d17o6n5H2VanZVZKAJV6dG6aFYCKgRIBqABUDLgVQKUOUYU2ACpCoQAqABV9VxGnEADD3r1E551HxB+ErOMAqNShMhFApR6dm2YFoGKgRAAqABUDbgVQqUNUoQ2AilAogApARd9VxCmEgeGaa4iuvVYcVSsgQEVLPnFkgIpYqlYFBKgYKE6ACkDFgFsBVOoQVWgDoCIUCqACUNF3FXEKYWA4epTo3HOJ1Ke/jB8AFeMSewYAKvXo3DQrABUDJQJQAagYcCuASh2iCm0AVIRCAVQAKvquIk4hDgz8bZWLLybj31YBqIiLSCsgQEVLPmcjA1QMFB1ABaBiwK0AKnWIKrQBUBEKBVABqOi7ijiFODCcOcPfViHavl2cRKmAAJVSshWOBFApLFkrIgBUDBQjQAWgYsCtACp1iCq0AVARCgVQAajou4o4hSRgeOQR8r6tcuSIOJnCAQEqhSUrFQGgUko25yMBVAwUIUAFoGLArQAqdYgqtAFQEQoFUAGo6LuKOIU0YLj+eqKrrhInUzggQKWwZKUiAFRKyeZ8JICKgSIEqABUDLgVQKUOUYU2ACpCoQAqABV9VxGnkAYMJ04QnX8+0YMPipMqFBCgUkiu0oEBKqWlczoiQMVA8VUNKqPBAi0sqHMwCt3tmIY9vt6j4Xh2eTzsJYQNRRsN/N/57A0pFHVOiU2bNpVWBw13aenEEV3UGF+mT/8y/Wp/Ui/7I++jdf45puUlv54vr8/iri9P6nkkbCjt1VA9XxrS+jS9eftXXvkKsc9VGdBF/9XJP/Kro54sbpbG/AFI/hAk16uqD5Rt1YompwdQqUfnplkBqBgokWpBRQHJ0AeU0WBAAaowkHjcMh5SbwowIxpM4CMcNjGLClgi3JMQCKAidw4bHZUNm6yIjl2AShqoKCBZ9gFltT+g1QlYMJD0V1Wc9SEtTaFkRP0JfITDzuAmCixefIDKtDLr+K+8RZgPCbs66sniZml89izRZZcR3X67LK0ioVC2RdQqHxagUl47l2MCVAyUXrWgMoERNQMSBosZiCg4mSMOBTeDrNmSpDjzQgBU5M5ho6OyYROg4vuEkaVfDCOqnofBYgYiCk7mZk8U3PSzZkuS4mBGxcV6I2+Jug1IeWV78KC/sf7xx3UU7bbGun2AjvIAFR313I0LUDFQdnqgoiBisjSrF17TpeZSgtkSvuXRYLLkS82MzIWLLQeLZ3E8HESWi6VJAFCRO0deBylPSR7Shk3dTgozKgEoKIiY1POl5XFoxmM2W+LPrkyWfKmlXHPhYsvB4rMm68uDyHKxtFkVLP2S1zmdkC7WV9fyK9H45puJrrhCJ2cAFYnO1SrspwZQMaFq89MEqBgoIz1Qid7QFCoiS7xUGP63N9AJ71FhyJktD0vOWt5syywWQEXuHDYabhs2ASq+T1Q9ozKFisgSr8mSr0k9n+1RYciZLQ9LBpC82ZbZzApARV7PdUK6WF9dy69E45Mn/Y31Dzygk7toXInd6qzNUuqaXYCKCS9qfpoAFQNlVCWoJAMJz6j4G28jsymhjfKz6zEwUYAziMzUpAsAUJE7h40Ow4ZNgIoZUPH2oMwBCc+o+PU8MpsS2ig/ux4DE5VePzJTk75PBaAir+c6IV2sr67lV6rxPfdUu7FealdHz6S4XbMLUKnag9xID6BioJwqBRUD95eU5NraGvGynPC5uLio9r+oTfehc//+/d5m6rzz2LFjuWHy0ijze5fsupjXHTt21OTRZs1UPaOStdm9yt9WVtZo27adkXPDhotK1/MydTSI46L/Ir/5bb/N8pX61NNPf1Z9sf4s3XLLVyvpp6R2dfwnKW7X7G7dekfmi0GqbCtNprV5841mO6iWpQ5QMVCgLoJKkgyYUZE7h40nWzZsYkbF0IzKqew3c5nsNDGjIq/nOiFdrK+u5beIxgcO+BvrDx/WyaUft4hdfWuzFLpmFzMqVXqPO2kBVAyUFUAFDbcBt5pL0sVOCpvp7QEJNtNjUFlHuxTYsNE+FbV5ww1EV1+tr0pRu/oWu+nLAJWqPMetdAAqBsoLoAJQMeBWAJU6RBXacHXpVxKsYEZFWOiawTCY1RRQEL2oxsePE513HqlXf++dLnu+9dZb1Ub7BwTWujuzUVTnQmJmBAaoVKWkW+kAVAyUF0AFoGLArQAqdYgqtAFQEQqVEczWYAd29ctOkoINnYvaPHHiBF155RZ6wQsO0pkzs1wdOnSItmzZQvy75ChqV5KmJEzX7AJUJF7RvjAAFQNlClDpBqisrKxMn8LddtttXsd2kL8oVtPhYieFpV9Y+hVUDxf9V6dqI7866sniFtWYXxRz8uRpevGLie68M2rjrPqUPbfpkqOoXUmakjBdswtQkXhF+8IAVAyUKUCl/aByp+rVGFTig64HH3yQ7r77bgNeNZ+ki50UQAWgAlCppXmYa5vqtWqnDyjSJvIbLPltl3xwU37uuerzZOOoSo+rT9jv3bs3V7oidnMTKxCga3YBKgWco0VBASoGChOgYqeT4qKso+Hes2cPcQcWPsJ2uQMMQ4wBF/OSrCOvSfeuYxegAlABqJhqEZLT1amvOndqw24RmzybEj6uuYbouuvmcyxps4rY1dE0HrdrdgEqVXqPO2kBVAyUFUDFzUG0xBXOqIXMPJuS12EkhZGkXySMi52UpNMvooGtsNijoq+8i/6rk2vkV0c9WdwiGsfb6CNH/NcVTyZZpgYlbXkRu7KcyEJ1zS5AReYXbQsFUDFQogCV9oLKAfXy/X379uWCCi//On36tAHvmiXpYicFUMGMCmZUjDYLuW1TXdZttE9FbO7atYt4H0r44EmWSy8ldX12ld8ClncUsZuXVpHfu2YXoFLEO9oTFqBioCwBKu0GlUceeSR3MDAcDtV657EB7wKoGBVVmDhmVIRCZQTr2iAL+dX3mbwUimjM+1N4mW744Nd3X3ABkVrd6x3c1ic9mIrfRxG7eXko8nvX7AJUinhHe8ICVAyUJUClvaBySvVku3fvzgWV7du3Y0YloW5hRgUzKoFbdG2Qhfwa6GxjSRbVmJd1nTx5MpIKQwrDyqc+dZri+1jSclDUblVKdM0uQKUqz3ErHYCKgfICqLQXVNhd+JWV8SUD4Q6DYYZBxfThYicFUAGoAFRMtwzR9F1sJ8oqVDSvvDyXYYVnVnj/IR+nT5+h7/meh+llLxsQt+WSo6hdSZqSMF2zC1CReEX7wgBUDJQpQKXdoHJE7bqMD7iDDiN49378KZ0BN8Nbv0yIKkwTS7+EQmUE69ogC/nV95m8FMpqzHsP+QEUt+t33XWXmjVf8zbWHz2aZ9H/vaxdWerpobpmF6Ci6zFuxgeoGCg3M6AyokFP7XuI3+9oQL1h9Op42KOFwSglZ2Ma9hZoYWFhLl48wqZNm0qr0/YGNPhyMa9h5qduDC/8VI47O9N7U4JCcVFjzKjkzaiMqL80pPVTsXCrA1paHitfm11fX1b1vD+KXJv9PqblJb+ex+OF0+C/r7zyFaXruU5EF/0X+ZUrYKN8q7TJryp+5Stl+a3SrsxiNwEJoFLEO9oTFqBioCxNgMpooAYdc/Ch4EUNRGaX/X/3er3QtVgGFdj44RWwDBLAJxQcoJLtHDx7Enyd/o1vfOPct1UMuFYkSRc7R4BKNqis9lU9n4MPBS+qXvdXg7j+v5eWeqFr82Djh1fA0k8AnxDwAFRM19RuDipttE9V2uTZFP4IZMK7U+Ycpkq7Rbyxa3YBKkW8oz1hASoGyrJyUOFZE/XexEFs5mQ0UECirscuE1+PX5tl04eZhYWsMH5ogIrcOWx0GDZssiI6dgEqGaDCsyb9AfVjMyerfQUk6vryejQuX49fm82W+DDD9Tw9jJ8eQEVez3VC6tQb2JUpULXGSa8rTrqTqu3KcqvXFkttNCm/ABWdUnM3LkDFQNnpgUoAEpOlWeOhmiFRMx/TmRD/hnl5Fy/5GqmWNLrIi5d2xa+FMCWAGE43dXkYQKWoW9joqGzYBKj4nqG/RyUAicnSrPWhmiFRMx8KVmYzJ0S8vIuXbq0qUFlVUBFd2hW/Nvt9CjGcburyMIBK0XquE97F+upafqvWOHhdsXrbfOZRtV2p7l2zC1CReka7wgFUDJSnHqhEb8jbb+I9GeUzAJDZPhPvegQ4FOhk7k+ZpJGwtyUuBWZU5M5ho8OwYROgUhWoRGdHvP0moXruQ8lsn4n3WwQ4FOhk7k+ZQEzC3hbsUfmsvGJXGNLF+qqTfRv5NWGTX1d84YV+fU07TNiVaN81uwAViVe0LwxAxUCZVgkq/u2l7CdRsyLx5WBqqiV2LRZXAUoUetIFAKjIncNGh2HDJkDFDKj48JCyn0TNisSXg52auxaLqwAlqOfRmZj5pWdY+iWv5zohXayvruXXhMb8lfpLLiH1GmOASqCACZ0lvgZQkajUvjAAFQNlWj2oGLjJWJL8lV7ePxA+FxcXvT0w4ZPfbMWNVN557Nix3DB5aZT5vUt2Xczrjh07zDtzDRb0l37lvf3LzO8rK2u0bdvOyLlhw0Wl63mZOhrEcdF/kd/8tt9m+ZryqXe844v0nOc8S4cOnUzs10zZzfO3rtnduvWOlLccmmkv47PPVf178+Yba+il2mMCoGKgLF0ElSQZMKMidw4bT5hs2MSMiskZFTudLWZU5PVcJ6SL9dW1/JrUeGmJ6IYbkhUxaTerDLpmFzMqOjXS3bgAFQNlB1Dp3ttIbHQYNmwCVAAqVTWZLvqvTt6RXx31ZHFNanzoEHkfgXz88fl7MWkXoDJTAKAiqwdtCwVQMVCiABWAigG3mkvSxc4Rrye2M2uStWQBMyp11Fa0iXWobLpNvOkmoquvBqiY1jnNVwAqddSi5tkAqBgoE4AKOmUDbgVQqUNUoQ1X96gkAQtARVjomsFsDe66ZNd0Xk+c8D8CqbZqRg7TdtNcr2t2ASqajZCj0QEqBgoOoAJQMeBWAJU6RBXaAKgIhcoI1rVBFvKr7zN5KdShsXrnDL34xUT8NrDgqMNuUt67ZhegklcD2vk7QMVAuQJUACoG3AqgUoeoQhsAFaFQABUMZvVdRZxCHQP306f976rw91UAKuKiqSQgQKUSGZ1LBKBioMgAKgAVA24FUKlDVKENgIpQKIAKBrP6riJOoQ5Q4ZuJfwSyLrtxIbpmF6AirgqtCghQMVCcABWAigG3AqjUIarQBkBFKBRABaCi7yriFOoauAcfgeRlYHzUZReg8jp8R0VcG9oTEKBioCwBKmi4DbgVQKUOUYU2ACpCoQAqABV9VxGnUCcw8IZ63ljPG+zrtBsWo2t2MaMirgqtCghQMVCcABU03AbcCqBSh6hCGwAVoVAAFYCKvquIU6h74M6vKr75ZvR34gLSDAhQ0RTQ0egAFQMFB1BBw23ArQAqdYgqtAFQEQoFUAGo6LuKOIW6QeXAAf8jkI899nnxPVYZsO78Bvduyy5ApUrvcSctgIqBsgKoAFQMuBVApQ5RhTYAKkKhACoAFX1XEadgYwB97bVEvd7fi++xyoA28sv3b8suQKVK73EnLYCKgbICqNhryGw1oDbs2rCp20nhy/T4Mr3tp7Iu1hudbqpL+bWR16NH/VkVnl2p+7CRX90+QEcjgIqOeu7GBagYKDszoDKiQW9I4+n9jmnYW6CFhR4NZxeJRgN1TV0fjFJylhIvIfSmTZtKq9O1BtRGfm3Y1O2kACp5oDKi/tKQ1k8F4ca0vOTX8+X1UNzVST3vj1LegpMSb5ruLC18mb50M1cooov1tVAGY4Ft5NeGTc72jTd+ja66SketcnFt5deWXYBKOT9xPRZAxUAJlgKVNX/gMVhLvqHRIAof42GPPBYZD6k3hZIZzIwGMYCZJJscL9kmQEXuHDYabhs2ASq+T5Re+rXi1/P+SjKwrPZVPQ/Bx/pyj/qrKuz6kJam12cws9qPAcwERJLjJdsEqMjruU5IF+ura/m1pfHhwye9N4Dxm8DqPGzl15ZdgEqd3tUcWwAVA2VRClQm97HGQMIzIt45II9b1CxJbzCgQWjqZKT+7c+ZKDgJQEWFm/2ZDCqJ8VI0AKjIncNGw23DJkBFE1QmILHCQBKq5yt8Xc2SLPUH1F8eT2dJVtW/V704Ck4CUFHhPHhR19NAJTHexDbHC58AFXk91wnpYn11Lb82NeZvqlx6KRF/Y6Wuw2Z+68pj2A5AxYbq9m0CVAyUgQ6oeOAxGcD0hnvptdPBzMvop0KruaYzJgwxE4AZDweTZWC8vCsAmWgGk+KlSQBQkTuHjQ7Dhk2ASjWg4oHHpG4vLe+l20P1/N9NICQCIgwxE4BZXx5MloHx8q4AZKLwMQWYULw4oAT/BqjI67lOSBfrq2v5takx16fzzyd64AEd1YrFtZnfYndaTWiASjU6upYKQMVAiemASnxGZa9a4jV78vpTk1kUddO85Msb3MxmTqagwvtU0vaoJMQDqOg7gY0Ow4ZNgEo1oBKfUfk9tcQrXM/9WZTJkq9JPQ/2qExBhfeppO1R4aVisXgAFb/sXKw3Oi1Ul/JrO6+7dxNdfDHRmTM6JSaPazu/8jutJiRApRodXUsFoGKgxEqBSuYeFTVDMghvpOfVYP7SkWA2xcvGFELCsynRuInxUjTAjIrcOWx0GDZs6g70Or+ZPnOPipoh6Yc30vPSLr+eB7MpUXgJz6ZE4ybGC+An9n/MqMjruU5IF+ura/m1rTEDygtfSMTAUsdhO7915DFsA6BSt+LNsAdQMVAOpUDFwH0USXJtbY14EBk+FxcX1f4Xte8ldO5XuwW5ccw7jx07lhsmL40yv3fJrot53bFjRxG3bGzY0pvpU2Ahbbaj6usrK2u0bdvOyLlhw0Wl63mZOhrEcdF/kd/8tt9m+TbBp5aXv0TPf/436cknP2e8D2xCfnXqRNG4W7fekfKWw7y3KTbr982bb2xs39bEGwOoGCgVF0ElSQbMqMidw8aTLRs2MaPi+4SroJIEPphRkddznZAu1lfX8tsEjXkz/SWXkHrop6OeLG4T8iu702pCYUalGh1dSwWgYqDEACpYB27AreaSdLGT6vzSL8szKgAVtE11tE26DzTK3mNT2kR+TfF55xGdOFE2J7J4Tcmv7G71QwFU9DV0MQWAioFSA6hgMGDArQAqdYgqtIEZFaFQGcG6NshCfvV9Ji+FJmm8cSPRli15d6z3e5Pyq5cTWWyAikyntoUCqBgoUYAKQMWAWwFU6hBVaAOgIhQKoDJVoGuDShv5tWEzbfZIbfv0PgI5HuvXlbQUmpRfc7mcpQxQqUPl5tkAqBgoE4AKQMWAWwFU6hBVaAOgIhQKoAJQ0XcVcQpNG7hffTXRTTeJb79wwKblt3AGCkYAqBQUrCXBASoGChKgAlAx4FYAlTpEFdoAqAiFAqgAVPRdRZxC0wbuBw8SnXMO0dGj4iwUCti0/Ba6+RKBASolRGtBFICKgUIEqABUDLgVQKUOUYU2ACpCoQAqABV9VxGn0MSB+7XXEl13nTgLhQI2Mb+FMlAwMECloGAtCQ5QMVCQABWAigG3AqjUIarQBkBFKBRABaCi7yriFJo4cD90iNRHW4n4/1UfTcxv1XkMpwdQMaluc9MGqBgoG4AKQMWAWwFU6hBVaAOgIhQKoAJQ0XcVcQpNHbjfcAMRz6xUfTQ1v1XnM0gPoGJK2WanC1AxUD4AFYCKAbcCqNQhqtAGQEUoFEAFoKLvKuIUmjpw5z0qvFflwAFxVkQBm5pf0c2XCARQKSFaC6IAVAwUIkAFoGLArQAqdYgqtAFQEQoFUAGo6LuKOIUmD9z57V/8FrAqjybnt8p8BmkBVEyo2vw0ASoGygigAlAx4FYAlTpEFdoAqAiFAqgAVPRdRZxCkwfuPKvC31Xh76tUdTQ5v1XlMZwOQMWEqs1PE6BioIwAKgAVA24FUKlDVKENgIpQKIAKQEXfVcQpNH3gzl+qr3JWpen5FRecMCBARShUy4IBVAwUaOWgMhqot4YsqHNAo+n9jmjgXVugwewijYc971pvOE7J2ZiGPY7Xo9Qgk5ibNm0qrU7XGlAb+bVhkx1Cx+7OnTtL+1STIhoBldVZPV89RXTKO0fUn9Tz/mpwjWh92a/nS8vjSbjZb368MS0v+fV8eT3+W/TfV175CivS6viRzg3Dro568rg2dLZhs0ibeOIE0XOeM6bNm3cSt4WDwYBuv/12OsgfXClxND2/JbKUGQWgUrWibqQHUDFQTlWDykg1ZiEW8e94PKShd1EBS0Aq6lrP+5thJCGOF63ng800bLoAABW5c9joMGzYLNIpJ6kHUEmHhtX+gGaAMgm3PqRlD1AUsPRHPpSoa0ve3wwjCXFUGAYZD2ymYdPtAlTk9VwnpIv11bX8Nl3jBx98kF7xirvpB37gbERavn7XXXcVlrvp+S2coZwIAJWqFXUjPYCKgXKqFlRmMycL4amTCXREZlnUzEsQJBFuGGum0BMCnBQNACrZznHkyBGvc+HB9y233EJ33nknHT9+3IBHJSfpYicFUEkDhtnMyUIAJAwlE+jgej6FGDXzEsyuJMKNijO7HgKcSXr+jMvsBKjUU2VdrK86ytjIrw2b0oc3h9SHVPbs2UM8q8J7Vfbvj6rLsyoMLEWOJue3SD6kYQEqUqXaFQ6gYqA89UBlBibR5VspsyQKTqbhpn+rNHpDNa8yf4wGkyVf4XgAlcJeMBwOPUg5c+aMF5c7jFNq9Mewsj/eAxVOXRbBxU4KoDK/pCu6fCtllkTByTTc9G8FIUtDWk8AkNX+ZMlXOB5AZVpXZTWs2lAu1lcdBWzk14ZNKajwMq/g2L6d6LLL5tUNh5Fo3+T8Su6/aBiASlHF2hEeoGKgHPVAJXpD4+FgspckDB8KWgY+iEyXcnnRgv0nGXtUeMmXt+Yde1TKFv3KysocjIQ7jHvuuUd9hfhQ2eTF8VzspAAqyTMq68uDyV6SMHwoaOn7IDJdyuXBRrD/JGOPCi/5mtRz7FGJVikX6424UUgI2KX8Njmv/BArOHhG8/zz52dV9u3bR4cPHxYXd5PzK85EgYAAlQJitSgoQMVAYVYJKt5ekgSwCDbNL4RnToJN95HZlBnUcFZHA38Dfvpm+5kgWPqV7BxJT73iHcZ2fmRm+HCxkwKopCz9SgGLYNP8QnjmJNh0H5lNmUEND4JW+349T99sj6VfhqvnXPIu1lcdjWzk14ZN1khil2fhwwe/VyQ+q8LLv4rMyEvs6pRhWlxbdgEqJkqz+WkCVAyUUaWgYuD+kpJcUy9350Fk+FxcXPTeShI+uRHlRirvPHbsWG6YvDTK/G7a7vve9z56y1veMpe3uF0GlaefftqoBqbzmqa/jt0dO3bU5NFmzRh565cCjPj+kar/vbKyRtu27YycGzZcVLqel6mjQRwdP4Ld/Da4izo32ae4Hw377ZNPfo6e97xn6f77vzi9zn0L9zFS/25yfqV5KBJu69Y7jLeRVbe5Selt3nyj2Q6qZakDVAwUqIugkiQDZlTmVWGg4zN+xJ8wPfDAAzQejw141yxJW0+1dOxiRsU8jBTtaLGZ3mg1nSauU2907rBLdpucV176dfr06blZlRe/mOjs5CVgW/hDKwWOJue3QDbEQTGjIpaqVQEBKgaKE6Aimwo3IL1oCl7HLr/VKz6Fz+nFOwzulE6ePKljKjeui50UQAWgEji2i/6bWykzAiC/OurJ4jZZY+4P4kuCg70q6rmW168U/Z5Kk/MrK7FioQAqxfRqS2iAioGSBKi0F1TYXZKeeoU7jLPq8VjRt7eUcUMXOymACkAFoFKmtpeP42I7UTa3Tc8rv2SF+w8GkuCNkb/4i4fp+c+/k/7kT1YKZ7vp+S2coZwIAJWqFXUjPYCKgXICqLQbVHjpFy/tCh/hDoNfW8zfWDF9uNhJAVQAKgAV0y1DNH0X24myCrmQV36Qxd9L4dkVbg/f9rZ9aq/KKdWnFM+1C/ktnqv0GACVKtV0Jy2AioGyAqi0G1TYZfbu3Uu7du2aLu/iDoOXhfGSr4cfftiAV80n6WInBVABqABUamkepkZcbCfKKuRqXvkNYOG9KtL8u5pfaf7i4QAqZZVzOx5AxUD5AVTaDyrsNgwmDCv8ZIyXevEaY/7oY12Hi50UQAWgAlCpq4Xw7bjYTpRVyNW8hveqFMm7q/ktksdwWIBKWeXcjgdQMVB+AJVudY62BgMudlIAFYAKQMVAp5ORpIvtRFmFXM5rmVkVl/NbpowBKmVUcz8OQMVAGQJUACoG3GouSRc7KYAKQAWgUkfrMLPhYjtRViGX81pmVsXl/JYpY4BKGdXcjwNQMVCGABWAigG3AqjUIarQhqsffEz6xgq+oyIsdM1gXRtU2sivDZtVzqgXnVVxPb9FqxRApahi7QgPUDFQjgAVgIoBtwKo1CGq0AZARSgUliRNFejaoNJGfm3YrBJUis6quJ7foq0IQKWoYu0ID1AxUI4AFYCKAbcCqNQhqtAGQEUoFEAFoKLvKuIU2jBw51mVyy6TZbkN+ZXl1A8FUCmiVnvCAlQMlCVABaBiwK0AKnWIKrQBUBEKBVABqOi7ijiFNgzcg1mV/fvzs92G/ObnchYCoFJErfaEBagYKEuACkDFgFsBVOoQVWgDoCIUCqACUNF3FXEKbRm4S2dV2pJfaQEDVKRKtSscQMVAeVYOKqMBLSwsqHNAo+n9jmnY42sL1BuOZ1eHvblr8SyOBn68wSyxRBU2bdpUWp2uNaA28mvDJjuEjl289SvjrV+rs3q+eioIN6blJb++Li2P1Xd6/Ovry349D1+Lb5Rf7fvx+qvZbxrDZvrSzVyhiDr1ppChWOAu2W1LXqWzKm3Jr9S/ASpSpdoVDqBioDyrBpWR+pjgHFMoePFBQwHLYKj+y38OqeddZIhJiMNhVDwfbEY06E3ipWgAUJE7h40Ow4ZNgIrvEyZmVFb7A5oBygQuFLz4oKGApT+kdQaV9SEt9Uf+taWEOBxGxfMhZkT9pUm8KfxEwQWgIq/nOiFdrK+u5bdNGqvvCOfuVWlTfiW+BlCRqNS+MAAVA2VaLagooPBmU9QZmQIJrvdoOqEyhRfmkWRQmV0HqFRZ9DY6DBs2ASqmQEUBRVDPPQgJYCK43qPl9Ti8ECXCjYo7uw5QiddzF+uNTlvVpfy2Ka8nThCdey5R1l6VNuVX4uMAFYlK7QsDUDFQpnqgMgOT8JKu+CzJaDABlOksimS2JGn2JV0AzKjIncNGh2HDJkClKlCZgUl0+VZ0lmS1PwGU6SyKZLYkafYlffkXZlTk9VwnpIv11bX8tk3jLVuyZ1Xalt88fwOo5CnUzt8BKgbKVQ9Uojc0Hg4mMybhGZDQ0q7pUi6Ol7xvZZbiDFR4nwr2qFRX+DY6DBs2ASpVgUoUHNaXB5MZk/AMSAhapku5JsvAEvatzGZhZqDC+1SwRyVaz12sNzotVZfy27a8BrMqa2vJHtC2/Ob5OUAlT6F2/g5QMVCuVYKKt+/EWxISWuLF95y0wT64Ftl7EppFYZSZbLaPLiMjWlMtIW90Dp+Li4s0UEvIwud+NQ/NjWPeeezYsdwweWmU+b1Ldl3M644dOwzUuPqTrHyPCs+YTOr5dInXKX/2JHiRxnT/SnAtsvckNIui4gWb7Rciy8iIVlbWaNu2nZFzw4aLStfzMnU0iOOi/yK/+W2/zfJto0/dcstX6corv57Yn7Yxv1l1bOvWO0LLYrNfEhJ/uUiT/r158431d1oOWwSoGCi8SkHFwP1Jk8TSL6lSem/Ckltx/8kw3vrVvM4VS7/K1sBi8br29NtGfm3Y1J1lzvOirFmVNuY3Sw/MqOR5Szt/B6gYKFeAip2Bu+kOI8tVbHQYNmzqagxQAagE9chF/9XpLpBfHfVkcduq8U03EV199bwGbc1vWmkDVGT1oG2hACoGShSgAlAx4FZzSbrYSQFUACoAlTpah5kNF9uJsgq1Na9HjxKdcw7RoUPuz6qXLVuOB1DRUc/duAAVA2UHUAGoGHArgEodogptVL5H5ZQ9gMHSL2GhawZr6yA6TRYb+bVhU3eWWepWPKty7bUAlSbtNSl7L9ijIvV6PxxApZheotAAFYCKyFE0A7nYKWNGxR6QpHWqABXNiiiM7mJ9FWYtMZiN/NqwWReoHD5M6sUa0VmVNuc3yakwo6JTI92NC1AxUHYAFYCKAbfCjEodogptYEZFKFRGsK4NspBffZ/JS6HtGvOMyvXXz1Roe37j5Q1QyasB7fwdoGKgXAEqABUDbgVQqUNUoQ2AilAogMpUga4NKm3k14bNumZU2A7vUeG9KrxnpU678WpsS2eAin6762IKABUDpQZQAagYcCuASh2iCm0AVIRCAVQAKvquIk7B1gC6TrvXXEPE+1UAKs1bRivds4I9KuIq7QUEqBTTSxQaoAJQETmKZqA6O8fwrerYxR6V5nWu2KOiWRGF0XXqjdBEYrAu2e1CXvkr9Tyrwt9X6UJ+w06NGRWdlsDduAAVA2UHUOleA2qjw7BhU/cpHkAFoBI0uS76r053gfzqqCeL2xWN+ZsqW7Z0r58FqMjqQdtCAVQMlChApXsNqI0O0oZNgIrfYGDpl37D6aL/6uQa+dVRTxa3KxqvrBCdey7RkSMnZcJUHMqWzgCVigvSkeQAKgYKCqACUDHgVnNJ2uosdOxiRgUzKphRqaN1mNnQqa86d2rDrg2bug9vymp82WVEg8FXykbXimdLZ4CKVrE5GxmgYqDoACoAFQNuBVCpQ1ShDcyoCIXKCGZrsAO7+mUnScGGzjZs2gKVffuInve8Z4k3cNd92NIZoFJ3STfDHkDFQDkAVAAqBtwKoFKHqEIbABWhUACVqQK2BnddstulvJ49S/SiF32Ddu/Wr4tFU7ClM0ClaEm1IzxAxUA5Vg4qo4H6Iu2COgc0mt7viAbetQUazC7SeNjzw/aGNE7N25iGvWi8pKCbNm0qrY6thqxLdl3MK5Z+ZSz9Wp3V81X1lNR/1eWI+pN63l+dxV1fntTzpSGtT8PG0x7T8tICheMlvT4Tb/0q3cwViuhifS2UwVhgG/m1YZOzbcvuW97yZbrwQqIzZ3RKqnhcW/kFqBQvqzbEAKgYKMVqQWUGJL1hCD3GQxp6gKJ+n5LK7O/xcEDh4DO+4cFQj3q9MPQkiwBQkTuHjYbbhk3dThmgkgYqMyBZWh5PIEWFXR/Ssgco6vf+aAYvk7/Xlwe0vJ6Qpgc9PVpaGtAMepJtA1Tk9VwnpIv11bX8dk3jp576nAcqe/bolFTxuLZ0BqgUL6s2xACoGCjFSkFFAUnPAxEFIbFZEn/2JAoco4E/yxKBmrk8zqeVJANARe4cNhpuGzYBKr5PVL70SwHJkgcfCkhisyT+7EkUOFb7fj2PQM2pOIjMp4UZFXtPv12sr/IWcD6kjfzasKnbJupqzEu/XvxiIl4KVtdhS2eASl0l3Cw7ABUD5aEHKrEZFLXsy58wUcu1BgnLudTvUyiZ/s1LuzJmTKbwk515gIrcOWw03DZs6nbKmFGZX9LlwYaaAfGXaKnlWv2E5Vzq9ymUTP/mpV0ZMyZT+Ml+0xhmVOT1XCeki/XVtfx2UWN++HD++US8ub6uw5bOAJW6SrhZdgAqBspDD1RiNxTARwQuZtDCsyrByq/Z3zkzJlP4AahUVfw2Gm4bNgEqvsdUPqMSwEcELmbQwrMqwV6T2d85MyZT+AGohOu5i/VGp53qUn67lNdwW7xzJxG/rriuw5bOAJW6SrhZdgAqBsqjUlDhJV/eZtpeZM9J8qb5pA328zMxSftX1tbWiJ92h8/FxUW1/0XN6ITO/fv3exsH885jx47lhslLo8zvXbLrYl537NhhoMbVn2TloDLdNN+L7DlJ3jSftMF+fiYmaf/Kysoabdu2M3Ju2HBR6Xpepo4GcVz0X+Q3v+23Wb5d9anDh0/Sc57zLO3de6qWfteWzlu33jHbv6dmkpKWsrpwbfPmG+vvtBy2CFAxUHjVgoqBGxQmiaVfQqFUMBtPmGzYxIyKoRkVi50uln7J67lOSBfrq2v57bLGW7YQXX21TonJ49rSGTMq8jJqU0iAioHSBKjYGbjrDqJ1XMFGw23Dpq7G2KPSvKeAABWdmi+P62J9leduPqSN/NqwqdsmVqXx0aNE55xDdOiQToqyuLZ0BqjIyqdtoQAqBkoUoAJQMeBWc0na6ix07AJUACqBI+v4kU79gl0d9eRxbehsw2ZTQIXv4/rria69Vl5GZUPa0hmgUrbE3I4HUDFQfgAVgIoBtwKo1CGq0Eb1e1TsAQxmVISFrhnM1uCuS3a7lNckQOLZFJ5V4dkVk4ctnQEqJku1uWkDVAyUDUAFoGLArQAqdYgqtAFQEQqVEczWYAd29ctOkoINnW3YbNKMCt/L0hLRrbdKSqh8GFs6A1TKl5nLMQEqBkoPoAJQMeBWAJU6RBXaAKgIhQKoTBWwNbjrkt0u5TUNkNQLPOncc4lOnNCvo2kp2NIZoGKuTJucMkDFQOkAVAAqBtwKoFKHqEIbABWhUAAVgIq+q4hTsDWAbppd/qbKnXeKZSsc0FZ+ASqFi6oVEQAqBooRoAJQMeBWAJU6RBXaAKgIhQKoAFT0XUWcgq0BdNPs8lfq+Wv1p0+LpSsU0FZ+ASqFiqk1gQEqBooSoAJQMeBWAJU6RBXaAKgIhQKoAFT0XUWcgq0BdNPsnj1L9OIXE+3eLZauUEBb+QWoFCqm1gQGqBgoSoAKQMWAWwFU6hBVaAOgIhQKoAJQ0XcVcQq2BtBNtMuQcvHFRAwtVR+28gtQqbok3UgPoGKgnAAqABUDbgVQqUNUoQ2AilAogApARd9VxCnYGkA30e6ZM0QXXED04INi+cQBbeUXoCIuolYFBKgYKE6ACkDFgFsBVOoQVWgDoCIUCqACUNF3FXEKtgbQTbW7cycRb6w/q6ZVDqmPrBw/flysZVZAW/kFqFRSfM4lAlAxUGQAFYCKAbcCqNQhqtAGQEUoFEAFoKLvKuIUbA2gm2r3Yx87rj4AuZ1uumkX7d27l+6++266/fbb6ZFHHhFrmhTQVn4BKlrF5mxkgIqBogOoAFQMuBVApQ5RhTYAKkKhACoAFX1XEadgawDdRLs8g3Knekfxa15zhq65JirhPvVasD179oh1jQe0lV+ASukiczoiQMVA8VUOKqMBLSwsqHNAo+n9jmnY42sL1BuOJ1dHNPDC8dmj6eVIHmfxBrPEElXYtGlTaXVsNWR12uWOYKeaW+fzlltuoS1bttB4HJRFaenEEevMa/imdOyyVm04jIDK6qyer54iOuWdY1pe8uv00vJ4cm1E/VA9X14Pwob/P4vXX036fXbtyitfYaVIdPxI54ZhV0c9eVwbOtuwyYo0zS4v9eL+iI+jR0m1H6SWfkXLjkGF+7Ayh638AlTKlJb7cQAqBsqwWlCZwccMSNRNK3jxQUOBx2Co/hs+VJw0ClHx/HQywkySAqikO8du9UqV8BMpbri5c+Cp9QceeMCAV80naauz0LELUEmDhhl8zIBEhVXw4oOGAo/+kNanAMPXVJz+aAIvsXRVPD+djDCTtAAqtVTXxg1mTedap50oe282bDYRVHjG5ODBg1MZr72W1PKveVXLtse2dAaolK0ZbscDqBgov0pBZTykngcdCix6YSAJAGZ+5mQ0CM+8pGRQpTtInnKZRgCoJGvHncDa2lrkx3DD/aB6zUq4kzDgYl6StjoLHbtlO0ZTGpZNt/IZlfUhLXnQocBiKQwkAcD0KD5zstof0GzmJQWAVLr96UxMchiASlkvKBZPp94UsxQN3SW7XcprVh/AS77O8Gu/JseBA6T2qhCdOBH1jbLtsS2dASo6LYG7cQEqBspOD1RiMygpMyejwQRQpiAzyYgAQHg2ZiECPckiAFTmdeFZk+3bt8/9EG+4k8JU7Wq2Ogsdu2U7xqq1001PH1RiMygpMyer/QmgTEFmAhsCAOHZmIUI9ABUXAV8HX/Vqa+u2e1SXrN8+a677oqACoe94gpSfVe0RIPlYUXL2ZbOAJWiJdWO8AAVA+WoByqxGwqWakWAhPeZTGZNpku5/Hjj4SBlb8okXYaUvM0pk6AAlXnn4JkSnjGJH/GGO6mjqNrVbHUWOnYBKikzH8FSrQiQ8D6TyazJdCmXH399eTA3w+LvaZmcDClpy8LC4dTfmFGpumYmp6dTb3TusEt2u5TXLFBZWVmZm9VXCwHo/POJTp+eeRNAJXv/XqRNjbWbOr9t3nyjTpXuXFyAioEirxRUeMlX0ub4tA32c/tVontYRoPkzfa8lCnYGB78f3FxUe11UXthQuf+/fu9JUd557Fjx3LD5KVR5nfTdjn/SRrE7S4vL9MTTzxhVAPTeU3TX8fujh07DNS4+pPUn1GJd5ApS7zSNtjP7VeJ7mFZ7c/qeXjJ2MrKGm3btjNybthwUel6XqaOBnF0/Ah289vgLuoMn/L94qmnnqLbbrst0v88/fRn6UUv+gbt2nXau37vvffSQw89VKqPsqXz1q13JO/JqxAidABEGhegUqzPBqgU00sUulpQEZk0EggzKvOynjx5ku65557cGRVe+nWKWy2Dh4tPDzGjYucJXlYHihkVg5U0lLSL9VVHGRv5tWEza2ZDRz9J3Kz88uw/z+zzcuXgUO+AoRe/mOj971/zXvxS9rClM5Z+lS0xt+MBVAyUH0DFzY3eUlfgGab4EW64eRMjb2Y0fdjqLHTsAlQAKkG90PEjnboFuzrqyePa0NmGzaaCCt/XkSNHvNcUM5TwRx7/v/9vSOeeu51e+1q1DkzjsKUzQEWj0ByOClAxUHgAlXaDCr97Pj6rEm64eTB+/PhxA54VTdJWZ6FjF6ACUAGoGG8aIgZ06qvOndqwa8Nmk0ElKD/+vhcv7+Z+iZ+z8cZ6ncOWzgAVnVJzNy5AxUDZAVTaDSrsMg8//LA3a3L48GHPg55++ml6/PHHvbX+/P86DludhY5dgApABaBSR+sws6FTX3Xu1IZdGzZdAJVwOfIzNH5VcegzK4WL2ZbOAJXCRdWKCAAVA8UIUGk/qLDb8B4U/ugjwwnvSeFN9uF31xtwLeeflAJUACoAFdMtQzR9W4NKG3Zt2HQNVPh+b7iB6LrryvuhLZ0BKuXLzOWYABUDpQdQ6QaohF3HRsNtw6ZupwxQAagAVAx0OhlJuthOlFWoS3nVaYvV6mVvVkWtCCt12NIZoFKquJyPBFAxUIQAFYCKAbeaS9JWZ6FjF6ACUAGo1NE6zGzo1FedO7Vh14ZNHWDQ0VfX7tVXk9poX+4ObOkMUClXXq7HAqgYKEGACkDFgFsBVOoQVWij+u+o2AMYvJ5YWOiawWwN7rpkt0t51QUVtVLZ+wBkmbfo29IZoKLZCDkaHaBioOAAKgAVA24FUKlDVKENgIpQqIxgtgY7sKtfdpIUbOhsw6YuMEi0TAujm1/+pgp/W6XooWu3qL0gPEClrHJuxwOoGCg/gApAxYBbAVTqEFVoA6AiFAqgMlXA1uCuS3a7lNcqAIm/XXzxxaQ+ClmsPtvSGaBSrJzaEhqgYqAkASoAFQNuBVCpQ1ShDYCKUCiACkBF31XEKdgaQLtq9/Rpf/nXvoLff7SVX4CKuCq0KiBAxUBxAlQAKgbcCqBSh6hCGwAVoVAAFYCKvquIU7A1gHbZbpkPQNrKL0BFXBVaFRCgYqA4ASoAFQNuBVCpQ1ShDYCKUCiACkBF31XEKdgaQLtsN/gAZJHvFNvKL0BFXBVaFRCgYqA4ASoAFQNuBVCpQ1ShDYCKUCiACkBF31XEKdgaQLtulz/+eP31YpnJVn4BKvIyalNIgIqB0qwWVEY0WFigBe/s0XAc3PDs+mAUysRoMAk7oPDlWYiUeAk6bNq0qbQ6thqyLtl1Ma/4jkraa4hH1A/V8+X1INzsen81FHd1Vs9XTyWlmRIvISxeT1y6mSsU0cX6WiiDscA28mvDJmfbdbsHD/ofgDxxQlbitvILUJGVT9tCAVQMlGi1oBICkzCRjIc09EhEgcf0+gxCejOiieYwMV6yCAAVuXPYaLht2NTtlAEqed9LUYDRH3nfNvDO9SEte4ASvj6DkKXl8SxsGEIS4yXbBqjI67lOSBfrq2v5hcblS2zjRqLt22XxbekMUJGVT9tCAVQMlKgJUBmpHW/xGZLxsKdmT0LXFYT0PGhRwNIb0jglb3PxUsIBVOTOYaPhtmEToOL7hKmlX6v9AcVnSNaX/Xo+va4gZMmDGQUsS0NaDwNK6O+5eCnhACryeq4T0sX66lp+oXH5Etu7l+iCC4jOnMlPw5bOAJX8smljCICKgVLVA5WEWREFIIO0GRK11Gs6e6L+9idXxjQcpIOKl+VwPICKthfYaLht2ASoVAUqCbMiCkD6aTMkaqnXdPZE/e0vAxvTcj8dVLwZmXA8gIpXeC7WG50Gqkv57VJeq/Zl/pbKhRcS7dmT7222dAao5JdNG0MAVAyUqh6ozN/QeDgI7U2JggjPjsxWfk2gZTqzEk9rBjCReAAVbS+w0XDbsKnbOWLpV/rSr/XlAc32pkRBhGdHpntUAviYzqzE05wBTCQeQAWgot3SyROw0T7ZsKnbJsoVnQ9ZdX7vuovo0kvz76hqu/kW/RAAFalS7QoHUDFQntWCSvLsiL98S22wjyzxCmZjwpvuo/GT4xGtra0RDyLD5+Liotr/omZpQuf+/fu9J5J557Fjx3LD5KVR5vcu2XUxrzt27DBQ4+pPsvqlX8mzI/7yLVXPI0u8gtmYXghsovGT4xGtrKzRtm07I+eGDReVrudl6mgQx0X/RX7z236b5QufkpdPki8fOXKSnvOcZ9UHIE9l9t+2dN669Y7kPXkpD2Gme/0a9vvmzTfW32k5bBGgYqDwqgUVAzcoTBJ7VIRCqWA2njDZsKn79BAzKnmb6ev/HXtU5PVcJ6SL9dW1/EJjnRLz4958M9ErX5mdji2dMaOiX74upgBQMVBqABU7A3fdQbSOK9houG3Y1NUYoFI/iOQ9VQSo6NR8eVwX66s8d/MhbeTXhk3dNrFpGh8+TGoWl+jo0fQ7s6UzQEXHW9yNC1AxUHYAFYCKAbeaS9JWZ6FjF6ACUAkcWcePdOoX7OqoJ49rQ2cbNtsGKpyfpSWiLVsAKnkPecr+jqVf8naEQwJUiuklCg1QAaiIHEUzkIudMkAFoAJQ0az4BaO72E4UzOI0eJfyahKQ1FZUOv98otOnk0vCls6YUSlbM9yOB1AxUH4AFYCKAbfCjEodogptVL+Z3h7AYOmXsNA1g9ka3HXJbpfyahJU+FXFF19MdM89AJWysyZZ8TCjUqwxBagU00sUGqACUBE5imYgFztlzKjYA5K0jhOgolkRhdFdrK/CrCUGs5FfGzZNAkOe/ibze/fdRC9+MUAFoJLnheZ/B6gY0BigAlAx4FaYUalDVKENzKgIhcoIZnKQlXV3sKtfdpIUbOhsw2ZbQYUH6Oeey680ny9tWzpj6Zek5rUvDEDFQJkCVAAqBtwKoFKHqEIbABWhUACVqQK2BnddstulvNYBSLffTnTNNQCVqmdVsPSrWP8BUCmmlyg0QAWgInIUzUAudspY+oWlX4Hbu+i/OlUW+dVRTxYXGst0koY6csR/VTH/P3zY0hkzKtKSa1c4gIqB8gSoAFQMuBVmVOoQVWgDMypCoTCjghkVfVcRp2BrAN1muzyjwjMrAJXqHjJhRkVcpb2AAJVieolCA1QAKiJH0QzkYueIGZXqOruqliNgM71mRRRGd7G+CrOWGMxGfm3Y5My32W7Sq4pt5RczKjo10t24ABUDZQdQaXfDneQyNhpuGzZ1O2WACkAlqD8u+q9Od4H86qgniwuNZToVCZX0qmJbOgNUipRce8ICVAyUJUAFoGLAreaStNVZ6NgFqABUACp1tA4zGzr1VedObdi1YVP34Y0LGvOrii+5xL5PAVR0vMXduAAVA2UHUAGoGHArgEodogptYI+KUKiMYBhU6msoSaFLOncpr3UCUvCq4ocf9j3Ols4AFUmNb18YgIqBMq0WVEY0UK/dWPDOHg3HwQ2Padjzr/dmF4lGg0nYAY2y8qbCReIlhN20aVNpdWw1ZF2y62JeMaOSNqMyon6oni+vB+HGtLzk1/Ol5TFN96Wszur56qmMWRoVLhIvISz2qJRu5gpFdLG+FspgLLCN/NqwaXPgXmd+b72V6JWvBKhUsTcQm+mLtSwAlWJ6iUJXCyqBSQUsgxB6KNDw/6mAZTBU//WP0SAHUPxQHvyEk0vKGEBFVNxeoDo7jOCubNjUzStAJW/plwKW/igCJP1VjqOApT+k9QlorPYHlAkoXjgffvz46SdARV7PdUK6WF9dyy801imx7LiHD/uvKh6rwYYtnTGjYq58m5wyQMVA6ZgAlXkACWZawrMsodmXDAoZDXoKegah2ZlkEQAqcuew0XDbsAlQ8X3C1NKveQAJZlp6NJtlCc2+hKEmBiOr/Z6CnkEoXjKsAFTk9VwnpIv11bX8QmOdEsuPe9VVpMYOABXdWRXMqOT7WjgEQKWYXqLQeqAyg43p0qzxkAbh5V3qLhg2vEvqt94clPCysOSZlfGw5y35ksy8AFRExe0FstFB2rCpm1fMqASwMION6dKs9SH1w8u7FHgwbHiAon5bmoMSXhaWPLOyvtzzlnxJZl4AKvJ6rhPSxfrqWn6hsU6J5cfdt4/o/POJnnrqc/mBDYTAjIoBUR1IEqBioJD0QGX+hsbD+OxHCERCe01m4RTs9GbLwWYpzva1eHtectZ+AVTkzmGjg7RhE6Di+4SJGZX15fjsRwhEQntNZuEU7CzNloPNnvLN9rV49Txj1oXjAFTk9VwnpIv11bX8QmOdEsuPy68qvvBCore85cv5gQ2EAKgYENWBJAEqBgqpWlCJ7kGZ3m7SpnmeXUnadB/aw+LFT5ihWVtbI37aHT4XFxe9JWLhc7/6+hN3BnnnsWPHcsPkpVHm9y7ZdTGvO3bsMFDj6k+yelCJ7kHJ3DTPsyuTeh7ZdB/aw+LFT5ihWVlZo23bdkbODRsuKl3Py9TRII6L/ov85rf9NssXPiUvn7K+vH37V+glL/m6lf5969Y7Mvfb6S7Jqis+ln4V67MBKsX0EoWuFlREJo0EwoyKXFYbT/Js2MSMirkZlbo6ybgdzKjI67lOSBfrq2v5hcY6JSaLe+IE0TnnEB08KAtfZSjMqFSppjtpAVQMlBVAxc6eDd1BtI4r2OggbdjU1Rh7VPLe+lX/7wAVnZovj+tifZXnbj6kjfzasKnbJrqmMd/vtdeeoeuv17nzcnEBKuV0cz0WQMVACQJUACoG3GouSRc7ZYBK/SCSN1MDUKmjtqJNrENlF9tEHV1s5fehh56hc88l4tmVOg+ASp1qN8cWQMVAWQBU0CkbcCuASh2iCm1Uv0fFHsAAVISFrhnM1qCyS3a7lFfbMzmXXUa0a5dmpSgYHaBSULCWBAeoGChIgApAxYBbAVTqEFVoA6AiFCojGAaV+hpKUuiSzl3Kq21Q2bOH6IUvJOI3gdV1AFTqUrpZdgAqBsoDoAJQMeBWAJU6RBXaAKgIhQKoTBXAIFrfZ/JSgMZ5ClXzO+t85oz/TRX+tkpdB0ClLqWbZQegYqA8ACoAFQNuBVCpQ1ShDYCKUCiACkBF31XEKQBUxFJpBQx03rKFaGlJK6lCkQEqheRqTWCAioGiBKgAVAy4FUClDlGFNgAqQqEAKgAVfVcRpwBQEUulFTDQ+cgRIvVJJ+L/13EAVOpQuXk2ACoGygSgAlAx4FYAlTpEFdoAqAiFAqgAVPRdRZwCQEUslVbAsM7XXEN0++1ayYkjA1TEUrUqIEDFQHECVAAqBtwKoFKHqEIbABWhUAAVgIq+q4hTAKiIpdIKGNZ5/35/rwrvWTF9AFRMK9zM9AEqBsoFoAJQMeBWAJU6RBXaAKgIhQKoAFT0XUWcAkBFLJVWwLDO/NYvfvsXvwXM9AFQMa1wM9MHqBgoF4AKQMWAWwFU6hBVaAOgIhQKoAJQ0XcVcQoAFbFUWgHjOvP3VDZu1EpSFBmgIpKpdYEAKgaKFKACUDHgVgCVOkQV2gCoCIUCqABU9F1FnAJARSyVVsC4zvyF+nPOITp4UCvZ3MgAlVyJWhkAoGKgWAEqABUDbgVQqUNUoQ2AilAogApARd9VxCkAVMRSaQVM0vm664huukkr2dzIAJVciVoZAKBioFirBpXxsKdeAbhAC70hjaf3O6IBX1PnYBTPhPotEjYhk6MB9Yaz1JJk2LRpU2l10GGUlk4c0UWNd+7cKc5fkwOaAJX15Uk9XxrS+imiU945ov6knvdXg2uh3yJh47+rf68OaGl5PEkr4Xdl48orX2FFahf9V0co5FdHPVlcaCzTSTdUks5ra0Tnnkt08qRu6unxASrmtG1yygAVA6VTLago6JiQyHg4oClbjIc09ABl9nuQldFAAcw8vYRy6kNOZhAVGqAidw4bHaQNm6yIjl2ASjIseEDSH3lAsb48oOX1Sbj1IS17gDL73QcYotW+queTOMG16P99yJkHnOg9AFTk9VwnpE69gV2ZAtBYppNuqDSdL7mE6O67dVMHqJhT0M2UASoGyq1aUFEowuChBhzxGRB/pmWgUCXMIGqmZDCgQcZsyWjQU/ATgp4UDQAqcuew0UHasAlQ8X3CxIyKBx6qnsdnQPyZlgGtTgDFgxGeKekPqJ8xW7La7yn4CUFPOH7ob4CKvJ7rhHSxvrqWX2isU2LyuGk6v/GNp+iCC+4mfiB15513qu+r3E4HDhyQJ5wTEjMqlUnpVEIAFQPFpQcqsyVdHphMl2iNadiLQQnfe3gJl5pl6fGSL3UtbbaE4YbTHSlQmVsxFtMCoCJ3DhsdpA2bAJWqQGW2pMsDk+kSrTEtL8WgJACTAErULMsSL/lScdJmSxhuON1VBSoRwEmAFYCKvJ7rhHSxvrqWX2isU2LyuEk6H1Q76fnByHOec5IefniW1r59+zxwOcvvMdY8ACqaAjoaHaBioOD0QCV6QwwWPnSE950oaBn4+1Vmv/t/e3tZvDMJRBh2gt/zlodh6ZfUNY4fP04f+chHKmmIpTZ1gaGInXhYncEAln4lL/1isPChQwHMdN+Jgpa+v19l9rv/d7iez4MIw06onmcuD8MeFZ26UCSuTr0pYqfK+uqaXWisU2LyuHGdT6qNKUHbfvPNRLyxPnwcOXKE7rnnHrmBlJAAFW0JnUwAoGKg2KoEFQ9QEjbNJ2+w58zMIMbPWvzfHt3MLQ1bUzvhuKEJn4uLi94SsfC5X32GlhupvPPYsWO5YfLSKPN7XXaffvppev3rX0+/8iu/Qm95y1vo13/91+m2226jN77xjbXlu668xstBx+6OHTsM1Lj6k6x+6VfypvnkDfYMNDOI8felxP+trqmZl/jSsJWVNdq2bWfk3LDhotL1vEwdDeLo+BHs5rfBXdQZPiX3iyrrEPeDgfbve98z3quKDx06GekLub9kYNGxu3XrHZkvBkneq5e2L9De9c2bb6y/03LYIkDFQOFVCyoGblCYJJZ+JQt15swZb+3teDyeBgieMB06dMgb9NVxuPj0EDMq9jrHtE4cS7/qqK16L6HQuUMX24my+e1SXlmjpuT31ltvjRQZf/wx/oLHxx9/nFZWVsoWrRcPMypa8jkbGaBioOgAKs1pQA0UL+1Sn+Hl5V7hI9xhMKzs2bPHhOlUm8aNhQzodI4AFYBK4Eo6fqTj77Cro548rg2dbdhsEjDIS0cvZFzneLvO3d8LX0hqOfTMDi8Pu1vzlWAAFb1yczU2QMVAyQFU2gsq3NgyqMSPvIbbgJs15mlakbwBVAAqAJUiNUY/bJcG713Ka5MAKd6uq0UHdP75pGZQZv7Lb//au3evlkMDVLTkczYyQMVA0QFU2gsqvJcnafo63kHyxkGGGpOHi50yQAWgAlAx2SrMp+1iO1FWoS7ltUmgctddd831d2p1NF1zzawkue3X7RMBKmVrhtvxACoGyg+g0l5QSVtnmwQq4T0sBtwMMyomRBWmWf1mensAgz0qwkLXDIZBtKaAgujQWCBSBUHiOp8+fdrbmxl+BfHhw6TeTqje3TMm71sqDz74oLZlgIq2hE4mAFAxUGwAlfaCCm+k56dH8SPecG/ZssX464pd7JQxo2IPSLCZ3q+1LtYbnW6qS/ntUl6b5stHjx4l7vf4YV5wbNx4in7kR+6p5NXEnCZARaclcDcuQMVA2QFU2j0Y4C/unuJRX+gId5A8k6K7aVDili52ygAVgErg2y76r6RepoVBfnXUk8WFxjKddEOl6cwzKg888IAHLNzW//RP76bv+I6jkU31OrYBKjrquRsXoGKg7AAq7QYVhhR+PXEYVoKGm98Gxr9V8RXePNd0sVMGqABUACp5Nbva311sJ8oq0KW8Nm1GJanMeFP9BRcQqY/TV3IAVCqR0blEACoGigyg0m5QYZdhSOGZFX4DGG+uf9vb3ub9zScvD6vjcLFTBqgAVAAqdbQOMxsuthNlFepSXl0AFb5H/qxYeFN92bLleAAVHfXcjQtQMVB2AJX2g0rgNvwWE34T2KOPPlrLLErYXV3slAEqABWAioFOJyNJF9uJsgp1Ka+ugIr6GL23qZ7/r3sAVHQVdDM+QMVAuQFUugMqNgddLnbKABWAis0648rgrspuycV2omz+u5RXl3z56qv9mRXdA6Ciq6Cb8QEqBsoNoAJQMeBWc0m62CkDVAAqAJU6WoeZDRfbibIKdSmvLoEKf+eR96rorooGqJStGW7HA6gYKD+ACkDFgFsBVOoQVWgD31ERCpURDINKfQ0lKXRJ5y7l1SVQCTbVa36YHntUJBW+hWEAKgYKFaACUDHgVgCVOkQV2gCoCIUCqEwVwCBa32fyUoDGeQpV83sZnXnpFy8B0zkwo6KjnrtxASoGyq5qUBkPe2oz2gIt9IY0nt7vmIY9dU1d7w1nV0cD/9rCYJSaM0kYjrxp06bS6pRpyEobC0Xskl0X84qlX+lLv9aXJ/V8aUjrp4JwY1pe8uv00vJYvW3Ov77an9Tz/mh6Lf5BR0kYjoMv01fR8uSn4WJ9zc9Veggb+bVhkxWA3XxPqWJTPUAlX+c2hgCoGCjVakFlpDah+dAxHg5oyiSjAfmXFbAMAoBRfw/9sCP1+CIZVWbp5WUdoJKn0Ox3Gx2VDZu6nTJAJQ1URtSfQMf68oCW1yfhVgfUX+W/FbD0A4BRfy/7gLLaH9DqFGrCac/SS/sifXAdoCKv5zohXayvruUXGuuUmDxuWZ11N9UDVORl1KaQABUDpVktqDB0zM+cqKs04JmThd4MXnyaoZ66njqhogDHm3HJCjPRBKAid46yDbfcwnxIGzYBKn45mFj6FcyAhGdOTp1SwDGp51N4YTBZH9KSuu5DTMKpACeo56lhJvEAKjq1UB7Xxfoqz10z2idorFNi8rhlddbdVA9QkZdRm0ICVAyUph6oBAAyWdKlwMJf2sVLvWazJKPBBFAYTOaoRKURWSaWkMnEeNFwABW5c5RtuOUWmjEQAKhUBSoBgEyWdCmw8AGFl3rNZklW+z1/doXBZG6Zl0ojskwsAVgS40XDAVR0aqE8ro02Qre+ynPXjPYJGuuUmDxuWZ11v1QPUJGXUZtCAlQMlKYeqERviPen+BwSho8QtExBJrQ0LBVCQsvEQvHSJACoyJ2jbMMtt9CMgYDuwAdLv5JnQHh/ij/zEYaPELRMQYZoujQsFUJCy8RC8dKWgAFUdGqhPK6NNkK3vspz14z2CRrrlJg8ro7OOl+qB6jIy6hNIQEqBkqzSlCZLfGKLeeaLuEK7UWZLPuKLgcL72FhmEnamE/e19V5EBk+FxcX1f4YtRcmdO7fv9/bOJh3Hjt2LDdMXhplfu+SXRfzumPHDgM1rv4kq1/6NZthiSzVmi7hCu1FmSz74no+Ww4W3sPCMJO0MZ9oZWWNtm3bGTk3bLiodD0vU0eDOC76L/Kb3/bbLF/4lLx8bPnyBz/4Be9L9U888fnCY4StW+9IfXlI3l68Jv2+efON9XdaDlsEqBgovGpBxcANCpPEjIpQKBVM5wmT3Eo0pA2buk9oMaOCDz4GXuyi/5atq7r1BnZlCsCnZDrphtLV+YoriLZvL34XmFEprlkbYgBUDJQiQMXOwL1rgwHdzqKs6+vYBagAVAAqZWteuXg69bWcRT+WDbs2bNrKq8t2H3iA6MILic6eLeZhAJVierUlNEDFQEkCVOx0Ui433GXc0MVOGaACUAGolKnt5eO42E6UzW2X8upyf8eb6s8/n2jfvmIlDVAppldbQgNUDJQkQAWgYsCt5pJ0sVMGqABUACp1tA4zGy62E2UV6lJeXQYVvvfbbyd65SuLlTRApZhebQkNUDFQkgAVgIoBtwKo1CGq0Eb1m+ntAQze+iUsdM1gGERrCiiIDo0FIlUQpAqdDx8mOuccouPH5TcEUJFr1aaQABUDpQlQAagYcCuASh2iCm0AVIRCZQSrYrBT5i5gt4xqxePY0NmGTddnNoqXbHX9+8aNpN40Kr8DgIpcqzaFBKgYKE2ASnUNWdHi6VJH5WJesfTL3swJvqPityYu1pui7WA4fJfy26W8tsGX9+wheuEL5d4NUJFr1aaQABUDpQlQwWDAgFthRqUOUYU2MKMiFAozKlMFMIjW95m8FKBxnkLV/F6VzqdPE513HtHDD8vuC6Ai06ltoQAqBkoUoAJQMeBWAJU6RBXaAKgIhQKoAFT0XUWcQlUDaLHBSUDYLarYLPxNNxFdd50sPkBFplPbQgFUDJQoQAWgYsCtACp1iCq0AVARCgVQAajou4o4BQCDWCqtgFXqfPCgv6n+5Mn8WwKo5GvUxhAAFQOlClABqBhwK4BKHaIKbQBUhEIBVAAq+q4iTqHKAbTYqAoIu0XUmg976aVEd9+dnwZAJV+jNoYAqBgoVYAKGm4DbgVQqUNUoQ2AilAogApARd9VxCkAGMRSaQWsWmeGlEsuyb8lgEq+Rm0MAVAxUKoAFYCKAbcCqNQhqtAGQEUoFEAFoKLvKuIUqh5ASw3DrlSp5HC87Ovcc4kOHMhOB6Cip7OrsQEqBkoOoAJQMeBWAJU6RBXaAKgIhQKoAFT0XUWcAoBBLJVWQBM684Z63lifdQBUtIrN2cgAFQNFVzWojIc9WlhYoN5wHLrbEQ3UNb4+GM0uB2EXwhdjeRwN/HhZYTjKpk2bSqtjoiGT3EyX7LqYV3xHJf07KuvLfj1fWh7T7JsnI+pP6nl/dRY3CLvQH4XCRtNe7U/qeUYYtoMv00taFv0wLtZXnVzbyK8Nm6wR7Op4ih+XX1HMsyr8yuK0A6Cir7OLKQBUDJRapaAyHlLPg44xDXsDmjKJuj70/qGAZQol6u/eUIVUVwehsOE8jgY+pCz0KMI9CToAVOTOYaOjsmFTt1MGqKSAyvqQljygGNPy0oBWFUB4sKKuL3uAooBlChzq76UhravfV/uhsEEc/v/qrJ4vr2d/ZBKgIq/nOiFdrK+u5Rca65SYPK4pnfnjj/wRSICKvCy6EBKgYqCUKwUVBRYBh8Thw589SQISBTUDH1jiB8fx0lPpRmdo5sMCVOTOYarhzroDGzYBKn6JVL70S4FFMGMShw9/9iQJSBTU9H1giX91nuN46al0ozM082EBKvJ6rhPSxfrqWn6hsU6JyeOa0nnnTqKNGwEq8pLoRkiAioFy1gOV2ZIuDySmQDGbLYnc8hxwcPz02ZIp7KgZmUHOlApARe4cphpugIq8DOoMqQ8qsyVdHkhMgWI2WxKBjzng4Pg9SpstmcKOmpHpR5aSAVRs1FVdwNfx7S7lt0t5baNPHT9O6qEM0eHDyR6PpV86LYG7cQEqBspOD1TiN8RLvvy15rMZkNmMyXSGxIvGkJKy5GuS7GjgQ0w0XrIIABW5c9joIG3Y1O0csfQrbRkWL/ny6/lsBmQ2YzKdITk1WQaWOMMyS3u170NMNF6ybcyoyOu5TkgX66tr+YXGOiUmj2tS52uuIdqyBaAiL432hwSoGCjjSkEl2FMy2XsS3O5003z4+nT/STLU+CwzWbseS29tbY14EBk+FxcX1f4XtfQsdO7fv9/bOJh3Hjt2LDdMXhplfu+SXRfzumPHDgM1rv4k9WdUYtAQ7CmZ7D0JZlOmm+bD16f7T5Khxoubkt7Kyhpt27Yzcm7YcFHpel6mjgZxXPRf5De/7bdZvvApefk01Zfvu+9L9Pznf5Oeeupzc2OIrVvvSH15SHz5a5P/vXnzjfV3Wg5bBKgYKLxKQcXA/UmTxIyKVCk7b30x+VQrK+c6djGjkr2x3UbnihkVeT3XCalTb2BXpgA0lumkG8qkzmfOEF1wAdG+ffN3iaVfuiXnZnyAioFyA6jYGbhzUZpsQANXWV5epkcffZQ+8pGP0KFDh+jjH/+4d/LfBw8epPe///30pje9yYBnRZOsI69JmdCxC1ABqAQ+peNHOpULdnXUk8e1obMNm3X1O1W3xfKSnA9pWufbbyfiJWDxA6CiU2ruxgWoGCg7gEo9wFB3w/0t3/It9I//8T+mI0eO0Kc//Wn6whe+QF/60pfUe99Peyf/zdeefvpp+uu//mu65ZZb6J3vfKcBD/OTNN1ZpN24jl2ACkAFoGKsSUhMWKe+6typDbs2bLraFje5bNUzPzrnHCLeXB8+ACo6peZuXICKgbIDqLg5iE5zhZ/4iZ+g5z73ufTt3/7t9E//6T+lz3/+8/T3f//39Oyzz85F4Wtnz56lr371q/Q7v/M7dPToUXrsscfoD//wDyv3NBc7ZYAKQAWgUnlTkJmgi+1EWYW6lNe2AxK/pnjXLoBK2brQpngAFQOlCVBpD6jwW5j+yT/5Jx6gMKh88pOfpK997Wve7Ml4PCbex8OzKN/85jfpU5/6FH3/93//5IOaCx7cfO5zn/Ou/9mf/Rn9xm/8RqXe5mKnDFABqABUKm0GchNzsZ3IzVRKgC7lte2gcs89RBdfDFApWxfaFA+gYqA0ASrtABWGlOc973kepLzoRS9KnEFh9zmjdv9x2KSTl4udPHmSPvOZz3h7WH7913+9Mo9zsVMGqABUACqVNQGihFxsJ0QZSwjUpby2HVT4xSLnnkukXkg6PbD0q2zNcDseQMVA+QFU3AcVXu4VzKR87/d+b66XpIFKcP3LX/4ynThxgj760Y/SO97xjtz0JAFc7JQBKgAVgIqkdlcXxsV2omzuu5TXtoMK5+/664luuAGgUrY+tCUeQMVASQJU3AcVXrbFMyk8oyI5vvu7vzt1VoVh5R/9o39EX/nKV7ylY6PRSJJkbhgXO2WACkAFoJJbtSsN4GI7UVaALuW1C6DyyCP+rIp6V413YEalbM1wOx5AxUD5AVTcBpW9e/cSfziM96IcOHBA5CFvfvObM0GFYeU//+f/TB/4wAfoL//yL+n3fu/3ROlmBXKxUwaoAFQAKtpVv1ACLrYThTIYCtylvHYBVDiPL3wh0Z49AJWydaIN8QAqBkoRoOI2qDz++OPTDfK74q8dSfEXBpus5V8/93M/570pjGdVPvGJT1Cv19P2PBc7ZYAKQAWgol31CyXgYjtRKIMAlbJylY5Xp0/t3El0xRUAldKF1YKIABUDhQhQIdq/f78BZfOT1LX727/92/Tkk096syl8/PAP/3C+URXit37rt7zlXWmw8vWvf90DFU6X3xL23ve+l8477zxR2mmBdPNa1riOXYBK80Dl0ku/r6wraMXT8SMdw7Cro548rg2dbdhkRWBX7hdFQ6qXa6p+leinfuq/0stf/qPEm+xdPzdvvrGoDJ0OD1AxUPwAFaLBYGBA2fwkde0+ohbF8uuE+VsofNx///25Rn/yJ3+Sfu3Xfm0ajr+z8iM/8iNTaOGnT//wD/8wBRXeWM8wdA5/0Urj0M1rWdM6dgEqzetkN2y4qKwraMXT8SMdw7Cro548rg2dbdhkRWBX7hdFQvIbM6+5ZkD/x//xBdWfnqWLLtrkPKQwZAFUingBEUClmF6i0AAVdxvuD3/4w97rhPm7KHzwd1CSPuwYOMLLX/5y78+kATjH4xkahp7wjAp/xZ431fNX7nUOFztHgApAJfB5F/23a/XVtfzCp3RKTB63Lp3/zb8ZKEA57c2o8AlQkZdRm0ICVAyUJkDFXVDh/SnPPPPMFE74C/OLi4t08OBB7yOP4ePaa6+d/jMNVDgOL/diUOHvrXB6DCqf/vSn6Q1veIOW99XVWcRvUscuQAWgAlDRqvaFI+vU18LGQhFs2LVhk7MMuzqekhz33nv3qo8mH5xCCkCleo1dSRGgYqCkACruNtwf+9jH6Itf/KI3o8IzIrw8K77vhL9Q/4pXvCLiOUkDcE7jG9/4Bh0/fny67CsMKmvhL1mV8EMXO0eACkAFoFKismtEcbGdKJvdLuW17YD08pffHIEUgErZWuF+PICKgTJsC6hwPvjctGlT4ZNnIcrE042ja/df/at/5UEI3wf//+KLL048X/KSl0Tyl2X3X/7Lf0n/+l//68h51VVXqTeZXKGlkW5ey2qta1cX0AxU2cJJcr3gdcaub+rk+/++7/sB9VG1G5W/s8/Xd1500WKt9oK8wW49ZWxDZxs22a9gt3qf+hf/4ge8pV7h8wUvWKSVlTXn213sUSnW5QJUiuklCt0WUBFlNiWQrSfnXbLbpbzq+KKJuG0ClW3bdlrp+GG3ntm1LuncpbzyQwbkt546VPUDKYBKsV4ZoFJML1FogEry5nKReJqBujR471JeNd2i8ugAFf0BAgZZ+hpKBlBd0rlLeQWo1FN/JHWsaBiASrEuGaBSTC9RaIAKQEXkKJqBACqaAmpEB6joDxIwqNTXUDJA6pLOXcorQKWe+iOpY0XDAFSKdb4AlWJ6iUIDVAAqIkfRDARQ0RRQIzpARX+QgEGlvoaSAVKXdO5SXgEq9dQfSR0rGgagUqzzBagU00sUGqBCZGvDdJfsdimvoopXY6A2gYqtzamwW89Aq0s6dymvPDhGfuupQ0VBJC88QKVYZw1QKaaXKDRARSQTAkEBZxVoE6jkdar43c3BEMoN5QYfaKYPAFSKdf0AlWJ6iUIDVEQyIRAUcFYBgEozBwAYmKFc4APwgab7AEClWNcPUCmmlyg0QCVFptHA/3jiYJQSYEzDnvpdhekNxyKtRYFy7U5SUeG07ArsjAZ+/lIlEGUoGkia5mjQo2plzcnLeEg9Lu+Fau2WkKjyKG0EldW+X5791bSBzoj6XnkOaFUtO6lsMLA+pKXcNJXtpSGtV2XXs5mdl/Xlnt9eVWl3cv+r/R4trydrOLXbH1Wn8eqk7c3QOSj/hcrsBv7itwFp+T11akzLS1l+V9zXJGVXfX79fGTmNfC7yn0qWUNPh9TynJVPep3P037ebq7/Tn1Rp26l+UxeO1G9r5VpBwEqxbpkgEoxvUShASpJMo1o0BsS40fqgFkN9P0BvAKWgR9W/xDY9YyocFoAIbAzBaFZWO38SdP0IGqgclnRIbA7GkzsKWAZVElIFWVBJ5nWgYoaPCwtj9XAOL2jnw6up2HzBjH5v3uDxaUeLeUMjr1wlQ2gicJ5SR6kKR0m9taXBxmD7Pw8zg1kvIFaGuzN9F/tVweEuWlNB49ZQFEirx6YzbRM1kKV/1J1eQ3bSy+7jHsqCcM8QPd8iWEk0Vd5kOzncxq2pK2Ijl7ZxTX0IWRJ1a1UCFH3uew9lCipRZrdCYRJfK4UICXa9X0zs53IiFcGNnTiAFSK9b4AlWJ6iUIDVBJkmkJIBqhMYKHSJ/Aiu/49DdTAuvR4WmBnOnDnfE6gTeRQGYFkabI9BYGVwR/rFUBPRl6CGaaK8qqrVZXx2wYqs0FFGqiEBjMVgorX2eelx7+rQXvfA6myg+W02Yt0CAmeuPsAV5Vd1lflpZ83O6QGtblhpPcUmtlIgb3pwDmvLErokDtgzYDjsrrnll3oqX6pwXKCDpE6lKhztA5VZdfXKLneZs3ccTx/9kMHEtPaizz/LQlHU90T7IraibwZF2md0gsHUCnWGwNUiuklCg1Q4QmKYKmBv+xnPAwggJd3JT/Zn8608JKhsmujStgdD3vekq/Z4FtUzJFA+fkLzRLp5C9qdTbzlJom681loICirKZzckjyMgMY1rcy08WLxkiMdoFKaFCR9jRYXQ9AodKnwXlPl/l++AmtGoRUO7Dzn76mQsh0wD57Cl520DyLx2nxjEXeII3BwsTMRnpepoPsUDnr59efXcgFzNQZiJKDwSJlV6Ht/BnH8GxZxeWbmA+h7+rAaaLdfP/VnqWM25W2ExWWt079AKgU65YBKsX0EoUGqMzLNB3IM0gkjlpDAKO7VyRkXmbXX5ufvX8mu+hFdiYzGrynpJqB+wwYUtOc7hOpcm+M0O4kk1XvjRFVQsOB2goqPHhPBILpgJMHITpPYOcHn1lP3Kfr3SveG5Oaz8kT2xmMVfgEdrovJmsvUPX6zgaF+cv6qodQwbK5iiE0v+xCYK4zSI/PqkzLV7D/qOo9KokaZgHxTAOtMp+zK/HfvNkWAaDG7IrbiYp9rSysAFSKddAAlWJ6iUIDVBJkmg6Yw7Mpsb0o09mQCvdSJNlN2jOhu49CYIdnFnRgKMn5EtNMyMtsxkfkwrmBkuzGbQSb/NNfnpBrprEB2gUqwRKQ6D6Q6FPPYKNwtZuevY3UsSVO809bKxjYRAaVoaVQ0wFj3EYVG40ly81idkNLkipbcpY4gE6xW+kAOqHcEmZYtJ+ux4GBl0FNHjxNoTtmV7LZvuggNHG5WcRucF8Vz6Z4s5IJQDindbQ8qtBgzm6S/8bvQzLLNlem0bqU7DMxf6vF1wRQlZAXgEqxrh2gUkwvUWiAikgmBIICzirQNlApOihD+HIDFOgG3eAD8AGASrGuH6BSTC9RaICKSCYEggLOKgBQwWADA074AHwAPlDGBwAqxbp+gEoxvUShASoimRAICjirAEAFA5QyAxTEgd/AB+ADAJViXT9ApZheotAAFZFMCAQFnFUAoILBBgac8AH4AHygjA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYoZQYoiAO/gQ/ABwAqxbp+gEoxvUShASoimRAICjirAEAFgw0MOOED8AH4QBkfAKgU6/oBKsX0EoUGqIhkQiAo4KwCABUMUMoMUBAHfgMfgA8AVIp1/QCVYnqJQgNURDIhEBRwVgGACgYbGHDCB+AD8IEyPgBQKdb1A1SK6SUKDVARyYRAUMBZBQAqGKCUGaB0Jw5/IHRAq6fgJ90pc5S1tKwBKsW6foBKMb1EoQEqIpkQCAo4qwBABYMS6aCkk+H4C+WVfuUe/tZJP2op6AJUinX9AJVieolCA1REMjkfaDzsUW84nuRjRIOFhdC/nc8eMpChAEAFA0cMHFN8YH1IS6otXOCzPyLohLoCH4j6AECl2PACoFJML1FogIpIphYEYjgZ0EjlZDRQnfKA/8LRBQUAKhh8YfCV7gOr/QXqr8JH4CPwgSQfAKgUGyUAVIrpJQoNUBHJ1IpA3qxKr0cLvSEFcyutyBgykakAQAUDEAxC03yA96f0aHkdPgIfgQ8AVPQHEwAVfQ3nUgCoGBC1qUmOh9Rb6NF0BVhT7xP3VakCABUMQDAITfOBEfXVTDM20qOOoI4k+wBmVIp1xwCVYnqJQgNURDK1INCYhj1/LfZsr0oLsoUs5CoAUMEgDIOwjD0q2EiPvTmn0EaktREAldwuNhIAoFJML1FogIpIJucDTfel8KwKln45X55FMgBQwSAEoJLiA/zGL2yiB6gAVFJ9AKBSpLclAqgU00sUGqAiksnpQB6khOCE/41ZFaeLtNDNA1QAKgCVDFDBG78AKgAVgEqhXjU9MEClIiHDyQBUDIiKJKFAgxQAqABUACrwAfgAfKCMD2BGpVhnDlApppcoNEBFJBMCQQFnFQCoYIBSZoCCOPAb+AB8AKBSrOsHqBTTSxQaoCKSCYGggLMKAFQw2MCAEz4AH4APlPEBgEqxrh+gUkwvUWiAikgmBIICzioAUMEApcwABXHgN/AB+ABApVjXD1ApppcoNEBFJBMCQQFnFQCoYLCBASd8AD4AHyjjAwCVYl0/QKWYXqLQABWRTAgEBZxVAKCCAUqZAQriwG/gA/ABgEqxrh+gUkwvUWiAikgmBIICzioAUMFgAwNO+AB8AD5QxgcAKsW6foBKMb1EoQEqIpkQCAo4qwBABQOUMgMUxIHfwAfgAwCVYl0/QKWYXqLQABWRTAgEBZxVAKCCwQYGnPAB+AB8oIwPAFSKdf0AlWJ6iUIDVEQyIRAUcFYBgAoGKGUGKIgDv4EPwAcAKsW6foBKMb1EoQEqIpkQCAo4qwBABYMNDDjhA/AB+EAZHwCoFOv6ASrF9BKFBqiIZEIgKOCsAgAVDFDKDFAQB34DH4APAFSKdf0AlWJ6iUIDVEQyIRAUcFYBgAoGGxhwwgfgA/CBMj4AUCnW9QNUiuklCg1QEcmEQFDAWQUAKhiglBmgIA78Bj4AHwCoFOv6ASrF9BKFBqiIZEIgKOCsAgAVDDYw4IQPwAfgA2V8AKBSrOsHqBTTSxQaoCKSCYGggLMKAFQwQCkzQEEc+A18AD4AUCnW9QNUiuklCg1QEcmEQFDAWQUAKhhsYMAJH4APwAfK+ABApVjXD1ApppcoNEBFJBMCQQFnFQCoYIBSZoCCOPAb+AB8AKBSrOsHqBTTSxQaoCKSCYGggLMKAFQw2MCAEz4AH4APlPEBgEqxrh+gUkwvUehrrrmGeCCDExrAB9rpA69+9avpx37sGuIOByc0gA/AB+AD8AGpD7zqVa8WjSURyFcAoAJPgAJQAApAASgABaAAFIACUKBxCgBUGlckuCEoAAWgABSAAlAACkABKAAFACrwASgABaAAFIACUAAKQAEoAAUap0BloLJp0yZaWFjACQ3gA/AB+AB8AD4AH4APwAfgA/CBTB9gdsg7KgMVhhQcUAAKQAEoAAWgABSAAlAACkCBPAUk7FA5qGBmBbNKmFmDD8AH4APwAfgAfAA+AB+ADyT5QDCTYgVUJEbzCAu/QwEoAAWgABSAAlAACkABKNA+BQJWkDBD5TMqEqPtkxw5ggJQAApAASgABaAAFIACUCBPAYBKnkL4HQpAASgABaAAFIACUAAKQIHaFWgFqPDefJtn7aUGg04pcOLECTpy5AgdPnzYysm2+R7Ch8n6Mlc4/O6Mpp5OeRJutm4Fmlh3G1OX4oVhslHRTbtux4E9pxRoZj23PLDVrXPh+JreAFCpwBeCMqiyXJGWXfisSn/2jQAUzpw5Q2fPnq31ZJtBIwxQSQCmaeVtMEw1FfLafl8NrbsAlRKdNjrpdnSoVXXMsUF0E/toq0/fq9YZoGK//qENtF8GVderqtJj3+CZFAaGZ5991srJtvkeACoAlcYMcl2AnIbW3caUoYszKlU17EinPZ1+Y+t5CSBvql8CVOzXF4CK/TJocv1kSOCZFAaVug+2ybYBKikzJphRae6yPNswMxnANK3uAlRKDODQSaOTThskNLael/DzJg+ENAY/WPpVgS+gDUQbmNEGepDQtMGOyfZsrj2yPeDMsg9QAaik+UdjBzANWaaIGRV0fCY7krrSbmw9r2BwWpeGeXY0IIWjAlQq8AWACtprgMrMBwAqDRlINhkQXbi3xg5gqvWv8UKPegvj4sAKUEHHlzdAdeH3xtbzCganMf176t9jG2UCULHfVmSBysaNh+hnfuZd9NrX3ks7d76JfvmX76Prrns3veQln2jVXikbvu+CTfYNyYzKeNjznhp452A0rdajQfKXakNBVNgRDdRgY6jGGvEDS79yBnUZMyqHVN19l6q796q6+yZVd+9Tdffdqu5+QtXdxiy/cWHA7+o9Cuuu50KjAS30hhSpguOhAoBQ/c38fb7+ptXdan1vTENuO8qUUUtA5dDGjaqe/4yq569V9Xynque/rOr5daqev8T+4MKFTs71exTW87Q+OmkMHgkbr/exCOn1vFpQYUDh9kg68Azarnj4UbhNk6YJUBHrLi2fwuGSQOXbvu3L9BM/sUJ/8Ad/RI8//jh98pOfpM9//vN07Ngxeuyxx+itb30H/diPfaCwrQJ+hrTlddKYViJQ4UHOwkDhhjfiUdChGpQk6uCfvcHPbFAzAxmASqkBXAKofFnV3RVVd/8ope6+Q9XdD6i6W8pemQEh4tjRWjSA8eur94AhNiDhwcrsgYICgl64Xvvxgt/9gU3QBvhOWQ+ocHuiAKuMjzkOKl/+tm9T9fwnVD3/g8Q++h1vfauq5z9mf4CBTt9sGUjqeZE+OhLWr/fhh4/Sh4lVD0qGyo/4lKTrtU2T8HG44TQYVoJ0+PfcdAEq6brfrx5vje8P/f5aHugRXSMrK0l5emGSQIUh5aGHHqKjR4/Sn/7pn9J73/te+pM/+RN65JFH6GMf+xg9+eSTtHfvu2hpaSS2I/QxpFdx+eroLgEVDzZCUyTeoCXlKUw8rO971c6orKkU71f1Jji8OsR1Z3JE6lSC1nNtUsogiBu76JITfrrLCU5gLBRvPqyyUmZwFY+TACoMKXl1912q7o5U3a3kHqrIB9KoviwkA5jAf5JmVGIVwavX03oeq7PeAwhdUJmkqdIJZmf9+hX/96zuzC/7moX108jw8QKgMoW5CdTxv7mjig9y/HpuoAFP6KQZUvLr+V5Vz5dEgzt0vAbKzYQvxNMU1PMifXR8djVa7+dH7GVmVIJ6Eq5XPGMS/3fYJ+PLvuJ1MoAP7oPDdTCAljT/zvs9Mkiez77oSqv3qFzDgy3VTgdg8lo1AksdZF3jBU09XptRB+NtIC/34pmUv/mbv/FmT1ZXVyPne97zHvroRz/qwcob3/gHtLj4FNo4R9u4vHaUfSNv6Ze4EYzNpsyctXpQIVVXvLwF9SL2b0l9mN5f6iB6MpM0/d0frJEaXPmNJQ+yeFAVDMCS4YQHW9Nlc8HT7en/c2AiBiq83ItnUiR19w9U3X1K1V3ASkXQ2DTYEtTdqY/ngsp8HfVnQ304SRrMFJ9RCWZ3Ap8Plp6F/63sTXWOL/uKPyDg9KoBlXgHFwyEkgZFaU9neSCWXs9zOpBYJ83LvXgmRVbP36jq+SJgJa+zc/V3QT0X99Gen03qofdQwp9RiS7Vjg4zy4IK14UwXMT/HTwM4LrHdScMH/F6F6QTwEtSfU17gIAZFRFrZbcfanxF96vBFteh8N9V1qk4qPCeFF7u9fGPf9ybQUk6H330UQ9U+Lc3v/l36N57/xinoxq84Q2r9KM/eiQRNuOgElm7OlnCFV/2kTajkjybEjSM1S39iteTvH8nPKCK1tzUAehk+cvkdx84goERQ0ywJCX8d8WD4hio8J6UInX3d1Td/WPltzjd1GBV1d0jqu4mwmZsAJNUd/NBZbL0gwfZ8VlShpvBYPoUND6YKQcq4f0mccCP/zu+7MsHG8VPMviO9885nWr8CW4AJDzA4oEUN6Dhvyt9ehfrpHlPSrF6/mZVx+/F6agGq294g6rnP5o8WBTUc2kfHbgZ99UDVbd9sI7OlMarTVlQCYNDfCYy/u/4si/+tzdLoXmK0xGO5dOCtXpGhctgOotiaNkX24iDCm+c5z0p3BAeOHAg9VxfX/dg5nd/93e9GRacbmrw4Q9/mO67790iUEmriHOb5pMGNakNXvUzKgHcJwF+HvDP5TFj4DODk/jT3dmgytiyr1DdDQaqvHEeddfNelim/eS6+25VdyWgktnX5s6o8H770BLP+Oyot649+rDBNKgkv+0ruvQrE1oKgIq37y40KArWv3OjGfxtbNlXQifNG+dRz7tWz+8TgUrpPnoSMf6g0av3GRvq6wCVpLd9xR8cFIWWYFN98JAhMz5AJQcKJ4ByvxpdZa6tr3DpF7/dizfO/9mf/ZkHK2knLwniqef77ruPnn76aZyOavB3f/d3ar/RH9O3fuvX5+pqfEZFUl+5YYtupo9vxI2n4i6o+PtReDnK/KZef+Ay9N9olgs7actCii394rd7oe52py3iuvvHqu5+XdXdOViJPWnVBZXIACay4ZZTjm6u5ytmQUXytq/40szYTEsBUAkvSwnDCf8dXm+ftSm3yqVf/HYv1POu1fO9qp5/6/yAsUg9n/j8fB89qwxzKx/m6nq04pgGlfiyrySgEO0zCT1oKAQp4QcFkgFQQpjWz6gET4Q571nr6nVmwOIzKvwKYn6711//9V97MyZp59/+7d/SoUOH6Pd///fpyJEjOB3VgF+O8PDD76fzz09sA3P3qITrZdLbf7zNeZnTx0mgErxtZK3wl+njMyZ5/y6/9IsHPsF+lKRvOQRPd3NgQ7pUJSnctPL6gzB+BTHqbnfaIq6771d1l1TdrRpURmrpB69S94/Yw4bJq4tne+vDdTy77qbvicpb6hX+nf8O71fh/A9iL7fIeSNYAVCJr2PngUcYSoK9J0Wf6orDxzppfgUx6nnX6vnDqp4nd9J5+0gz++hYXY734elLtv1UTYMKQ0V4v0rwoCA8E1LkjWCFIQWg4hd0HmTw8q/p5mD9ZXmJT83D98HfSeFN9J/+9Ke9fShJJ8+kfPaznyXeWP+Od7yDPvShD+F0VIMPf/hx9faYr5Zf+uWBSPIrTvNeV5y+ZMwVUPEHSN6ylzmQiO5hMbJpPQYq/J0U1N3utEWPq7r7VVV3yy/9Cr2eeFKHg9nQ6J6WhFeUhut9ZNlXHaDCdS7+ACCel5zvqxQAlfhsSHjpVzBwig+mcjv2vI4//HsMVPg7KajnXarnH1b1/KHyS7+y+uj4Qwfla5F+2cB3VPL2pIR/53oVbJYP6lQAG8G4o8ib9uJLxoI0MpeAxduKgv/uxIwKv6Z4TS0BK9KuFQkbawO9jznyd1IYRj7zmc/Q8ePH6amnnpqen/rUpzxI4ZmW3/7tt9Hb336S3vlOwumoBrt3E73whaltYKEZlYL1Nze42x98DJaFMcwYOmOgwh9z5O+kSOru21TdPanqLim/xemoBqrukqq75UEltwqWDlB86Ze8jvhPWeXh0/SJZK5IpxkLywOl+GCq0g471knzxxz5Oymyev7bqp6/HR20y4OUnE66yIxK6QqdErHMjEqRulHFpvki9lKf2GoI135Qmew9MbXsK2kzPV/jjznyd1J4NuWZZ57x1sPy+YUvfIFOnTrlQcpb3/pOuuKKJ7R9QKN/gG0DM2zxB3ncCJ45c8ab4rVxsm2+h/Bh0mfm2qOSA6LoW8A0B1Vp9xADFR6Q8ccc+TspWXX3naruPqHqrjGAKqkZ7qdCP1FJNbHu6pdx0rKvErrFK3rJRiWYbTHaGcWfJqp75Y85vmvv3px6/lZVz68w95SzpGZGteraPTW2nusPTpKWfVnxHQ1I4aitBxXTy77SQIWv88cc+Tsp/ApiBhN+esN7Uni512tf+zZAin49tFLnirTjXMl4/9GJEyc8WDl79mytJ9tk23wPboFKDcu+Et76FQwC+WOO/J2UpLr7NlV3ASklBrauwVdD664+qFRUdhWBStGNvKUa/QRQ4XT4Y45/8MY3ptTz1wJSinR2roZtbD1v0QAJoGL/YUdKG+i1pxdf/JQ3u3LTTXvpttt+n264YR9dffVj9B3fcbJUe+tqW9DV+2bfCECBn87aOANQcgtUKhpM5Q2OE2ZUgoHgU6ru8uzKXlV3f1/V3X2q7j6m6u5JVXcbM1jMyx9+L19WDa27jfG9ikCllo4wo5Pmjzny7Mrem25S9fw2Vc9vUPX8alXPv8P+4KKrHWed+W5sPQeozKqt/1QxmFnJ4p5feMMa8Xn55ZfTg+99wvt7IeliHjwVmcbJS8u/ebtnFqjYvjfYb4ZvSPy4zjAm/WIuH00eLGeASmMGhE3Wr833VmeFLGKrKZq3BFSsDyBMNsZIO38AUKTu1Rm2TWWnqVsRZmgsqGhqUFn0NvkV8pLfvkk0qsy5kJBZBZoy+MN9lJ8BqVo7sx6H1G0oIGm0Eaaazs8VHW34IWwWUgCgUkiu7MCu1EvcZ33tcIXuhaRMKlD1IBfpNQc4ypaFSX9D2nYUQOdXX+fnitZ2PBFWCygAUCkgVl5QV+ol7rO+tjrPZ/B7QxQoO5hFPPeBJO+NcA1xUdxGBQqg86uv83NF6wrcCkmYVcAqqGzatGn2oTvl1NOP3uFvaAEfgA/AB+AD8AH4AHwAPgAf6LQPMCvwYWUzvVkGQ+pQAApAASgABaAAFIACUAAKuK5AraCCmRTMHmH2DD4AH4APwAfgA/AB+AB8AD4g8YFgZiULuCp765frVIf7hwJQAApAASgABaAAFIACUKA5CgBUmlMWuBMoAAWgABSAAlAACkABKAAFJgoAVOAKUAAKQAEoAAWgABSAAlAACjROAYBK44oENwQFoAAUgAJQAAq0XYHjx4/ToUOH6MCBA7S2tmbk5LTZBtvKO3A/eQrhdxsKAFRsqA6bUAAKQAEoAAWgQGcV+MQnPkHr6+t04sQJ+upXv0pf//rXjZycNttgW2wz7cD9ZOvTWUdtQMYBKg0oBNwCFIACUAAKQAEo0A0FPvnJT3qzHF/4whfos5/9LD311FP0d3/3d0ZOTpttsC22ybbjB+4nW59ueGVzcwlQaW7Z4M6gABSAAlAACkCBlinw+OOPe0uxeKbjb//2b+lv/uZvjJ5sg22xTbYdP3A/2fq0zP2cyw5Axbkiww1DASgABaAAFIACrirw/ve/35vhYID467/+a3ryySe9/5s4g7TZFttk2/GjLfdz+eW3FNZQoo+rftaW+waotKUkkQ8oAAWgABSAAiUU4KftR44cocOHD7fi5Lxwnpp6PPTQQ/TMM894g2q+V8nJg3BJuLQwbIttsu34UeZ+dO6F41Z9P7fcch/paJR1P031o67cF0ClBSXNm/B4feuf/dmf0Qc+8AGchjXgafLxeExnz5414j3Hjh2jgwcP0gc/+EHRyWE5Do5kBaBnvZ4BvevVuwprwcD+zJkzXrvm8sl5CMCrCm1MpPGe97yHPv/5z9Nf/dVf0V/8xV+ITh6E82BcGj4ejm2xTbYdP6T3w/cQnEH6/O8y91TF/YTv4b77nvDurcy9cJys+zHhA0hTrgBARa5VI0OePHnSe5vHpz/9afrKV75Cf//3f4/TsAasM+vNun/xi1+s3C/4dZKnT58m7nAlJ4flODiSFYCe9XoG9K5X7yqs8UwKtzXPPvtsK07OC+epqcfKyoq3wZ0HyNJZLB6EB4NxaZxwOLbFNtl2/JDeT3APfB98cPoBQBW9pyruJ2xfRxtOJ+t+mupHXbkvgIrDJc2NMc+iMKx85jOf8d7mwU/6cZrVgHVmvVl3fovKP/zDP1TqRY888gh9+ctf9mbJ+Ol0/Lz33nvpla98Jf3Kr/yKF4bDchwcyQrk6RnWF3rqexH01tew7hR4oMazKAwqrh+cB85Lk0Hlf/7P/+nN+nz84x+nP//zPxedASQES5yk8YJwbIttsu34Ib2f8D1wGpx2GKCK3FNV98N68BmASnjWJ/hbcl9Z9+N6nXD9/gEqDpcgPwHgQRa/ycPkZjwTG/xcT5P1Zt2DQW6VbvTwww97mx75vfbxdcAf+9jH6N//+3/vgQovQeMwHJbj4EhWIEvPuL7QU9+LoLe+hnWnAFCpV/H9+/fTpz71Ke9BF7fpkjMMCQGsSOIFYdgW22Tb8UN6P3FQ4bTjACW9J937CWZy4qAS/Dv8fw6bd19Z91Ovd8BaXAGAisM+8d73vtd7QsKD/r/8y79s1DkYDOif//N/Tv/rf/2v3Pu67rrraGFhgZ773OfSm9/85tzwRfP63/7bf6Pv/u7vrjxt1p31//CHP1ypF62urnpLy3jwwE95wudv//Zve5Byxx13eG+M4TAcluPgSFYgS8+4vtBT34ugt76GdacAUKlX8f/+3/+79+0UXhHBD5wkZxxUAliRxOUwbIttsu34Ib2fOKhwukkAJbmnqu5HMqMi0Srrfur1DlgDqLTIB/7kT/7EGyhzJ8P7JZp0/uqv/ip9z/d8j/eGkaz7etOb3kTf9V3fRe985zu9cPx//jdfryo/JtLke2PdWX8uhyoPnobn5WX8BIgbz+BkIApmUz7ykY941zkMh02azq/ynoqmNR72aGEwKhrNSPg0PcPaBn83Vc88YaB3nkLV/V6f1iMaLPRoOK7u3tNSSgaVHPujgXrAJLm/tHTGNOwteA+p+KyquXBh6de73vUub4k2D+j/9E//lD760Y96/886k0AlGIBnxQvSDl4Cw7bjh/R+4qDCdtMAKu2eqryfwH546VeSj4eXp8XvS3I/5msgLGQpgBkVh/3jf/yP/+EtP+Ipy6RBl81rW7Zs8UDl3e9+d+a9ScPp5OUP/uAPPPi56667KtWJdWf9uRyqPDg9/gDYW97yFvov/+W/eLMl/Gavu+++ezqbwrNKfI0bXQ5b9T3o5mc0UIOPqkYemjcT6MlasWZZZ1P1zJMAeucpVN3v9WltD1S8PHoAkQIi4yH1sn6fyJ2VThT4qsurC6Dyx3/8x96MuKRNCtqrNCAIPFvStrFNth0/pPcTBxW2mTSjIrknzrvu/cS14XvhI65FGFSSfg/60rT7qa71QEplFAColFGtIXH27dvn7ZHgJwIPPPAAfed3fif95m/+ptf4Jf3727/926dPr/hvDsNn+Pov/dIvReJff/313pKsIHzWkxuOGzwd4/+/6EUv8tbDBvcTt8P3ymkHcS6//PLIfXN6nMZLXvKS6dKwIH9paQb3F88X2wnHTcvHrl27PBhIOvm3cDzWnfXncqjy4PT4VYm/9Vu/5d0HL6PjDco/+ZM/6f2bG9UPfehD3vnYY495YefvIfy0ckD+3AYPBnjwEfx7dtfeoGHyZHP2+yyNgDmSw0VzPxucVPuktKzGgZ6sVaBb2v/T9MzThwh6B+VThd5BWlHdA/jtgtbR2YakOlu2PiTFKzajEkCFFC6Swvn5602ni/x/V/FsoxyoBG1jAGjxNjOpLYvFKXDzf/RHf+Qt2f7f//t/e204z5bz/7POLCDIihekzbbYJtuOH9L7iYMK243vUQnSTrunKu8nbCPYOM/247bjoBL+XXI/VdY1pFVcAYBKcc0aEyPcuAyHQw9UfuM3fsOrpOF/88Dh4osvple96lXTCry0tOQNbsPXOS6nwXH5PP/8873fOVxeI8pxOXxg/z/+x/84jZtlJxwuft/8Gw+e+f/8G9//D/7gD3p/Z6UZ/y2uTVZenn76aS/vcVDha/xbuFPJavh1nGTv3r3esjd+WcK/+3f/zrsXXkoX7E3h2SX+kjCf/N0cDstx5o/5zn80yFiq4T0ljf7OA8Vp/8u/94ZqSO4fY6VJ8uKuySCrQMeto1de3EBP1irQLe3/mXrm6TOBlXC2obfvp+X1Dg1eI0uNuuDb+SAwB3LThw3FZjTloBLWPf/+/LqZDiqzuhIHl7xanf57cVCZtz1SD4eChw9TmPLqfwAw8TZO/Xswaxvz7p7bJH7AJHl4EjxUSQOCvIcv8YdaSX2F9H7ioMJpxyGA8y65p+ChkM79xO0EMypJ14O3gqXdX9b95JUnfjerAEDFrL5GU//DP/xDb+M5V8rf/d3fpQsvvJB27txJo9Eo8m9uCBg4LrvsMu+34OSwHIfj8rUg3C/+4i/OpReOl/T3j//4j0fS5zTYJqeZZSccLn7f8d+kacbtxbXJywsv5wrDCv/N14J4/CFG/pt1Z/25HKo83vGOd9ATTzzh2fiv//W/RqCJn/7wW5WCk19WwGE5TuLBg7spXKgBQwg0ksJHl7XEOt9guUcugDQLVAI9Wauwdkl/5+mZqY83JoPeVeod+OhsQB4C6dZrLQUB/dZHCipR/5feX1I4fzYiCvXhGZbyeSoLKnNLVSNg4j2amc36JDy0KHLHXEf4QVTQl+T1Sfx7EhBI4oX7LbaZ1FdI7ycOKsF9BYDgNYGhMUbW35x33ftJSj/pHuLaJcXLup8iZYuw1SsAUKle09pS5L0X/H5wfgrM39Zg6Ljzzju9p5dJ/+YZj2B5zw/8wA+od4/fElmqFfzG1+Px855Ec3p8BuE4jcXFRa9RzLITDhe/7/hvRdLkvHIekrTIywv/zm9HCWaW+O+kOKw768/lUOXx9re/3VsSwHtTeB9MMKvCb/piUOF9P8HJYTgsx0k+Qp2rGtjlMkb4qXVS+Ona9Kwnts0ClbCeYe2S/s7VM0+f8GAGekd8tYzeAaB4T7XnBodt920pCOi3PjJQiS9Hk26Eb/qMije0nSyLneSJG0qvrs/yGNn07/02v4RWWhIPPvigNxO+trbm9d+SM7y0ie1I4oTDsC22ybbjh/R+wq8EDu4hDClF7kn3fgI9JP8PXjqQpVvW/UjLFeHMKABQMaNrLanyPgx+mv6+972P3vrWt9I/+2f/zHttLb+2OP5vvhac/Nvznvc8uvnmm73/87/Dv+fFj4flf19zzTX0/d///dN0OO2LLrqI3va2t2XaCYeL243/Jk2TNWAtgnxlaZGUl+Aaf/yPz7QwrDvrz+VQ5fF7v/d73lMp3t/Db037xje+4SXPH5jkjeHhk8NwWI6TdniDvZ6CFHXmv4crgAy1/C9rKcOkE08Gn2aBSljPuH7F9czXB3rP/FdL7/hgMGXpXXt9Ox9U6l/6FW5l8u/PD+3CHpV4vhYmoJLSZs7NthTrAfjhCT+EevTRR739h/wgjP+fdYaBIC9s+PcgbbbFNpMeahW5n3BOAzt8TXpPVd1PGJqSvp0S/45K2j1K7qdY6SJ01QoAVKpWtMb0eFlVsBSIB2MMBj//8z/vPYn/sR/7MTr33HNp27ZttHv3bvq+7/s+bzDLv/H/v/d7v9f7P8fhsHydz1e/+tXTODzY5/jBb1n/Z7sMPWyLw7E9TpttZNnheEE4jsfxA7vx38L/zrt3vpdAC/5/oIUkL9IwvHSI9U96L72OG/DTLV6CJG34OWzSU7LZPUyeFuZOp0xipEGI6pyHIdLhZSCzzbDhHDcLVCrXMxPSgoFZgT0C0DvZf2Ovv/UH5fE9Vm327fnlUTrtSlZc2YxKPIV5APHLKD64Twaa5rz1K74kltuvnsrs/N6V8XAweV203h6V8ENGbr+lJ5eANGw8XNaDtbL3U/ZeOJ7u/UhmUsKzUHn3aurBo6k626V0ASoOl3YAKVwB+VsRN91003SqeuPGjfSCF7zAe2MUf+fj0ksvjUxj/8iP/Ih3nV95y4P6YFp7w4YNdN9993nXw/E5bN4ZtsF/B2ll2eF7jocL7MZ/SwqbdO9sL6wFp180L3l5Zb2DPQ/89q8qD36rF89E7dmzR3RyWI6Tdcw6WMmdciec8CQxvOyLl0RkgE/4Sa+UjyR3ViZM9Xqm6BO6Oehdhf9Glxr1VFvmvxI3urehzVrP6pFkNrRM7fDjxEEl/ua+2T63sI18UMlLJ/x7Ve1E8T0qPHkSXeI1ewATWxIW2eNX/q1fv//7v++9rZNn63nWnB968f9NnEHabIttsu344er9SD0+S1eJPlI7CGdGAYCKGV1rSfWLX/yit5GbGyCeBeBlQPx0H6dZDVhn1pt1549JfvWrX62lvMsbyd9EXz5txJxXAHrX5xXQugqt8WX6KlSUp8H7H/kBCg+g3/Oe99Rysi22ybbjB+7nPV5ZpOkjL1mENKEAQMWEqjWm+YlPfMLbzM2DZx44S5cLFQ3XU1PhSRsL+RpvmuflNUXTdDU868x6s+68h6XpR+QVw02/2RbcH/SurxChdTVaM6icOXOGeDaiDSfnhfPU1IPf5sgrIviBF79kYmVlJffFE3kvAkn7PUibbbFNth0/cD/v9soiTZ+m+lFX7gug0oKSPnXqlAcJ/Bpe3jiO06wGvJ73wIEDdPr06UZ7z3TZSFVrKhqdW/s3B73rKwNoXa3WR44coRMnTniwcvbsWadPzgPnhfPU1IOXWvFbphgi8pYZV/U722KbaUu/cD/p+jTVj7pyXwCVrpQ08gkFoAAUgAJQIEGBYGDPsxBtOAPwamphM3zwDAgv++I345lers022BbbZNvxA/eTrU9T/agr9wVQ6UpJI59QAApAASgABaCAdQWC72/xvgie6WCQeNe73mXk5LTZBtsKvr0WFwD3k62PdYfp+A0AVDruAMg+FIACUAAKQAEoUK8CvNSKv1/Csyn85il+Pa6Jk9NmG2yLbaYduJ9sfer1DlgLKwBQgT9AASgABaAAFIACUKBmBfgDjDyTwq+iX15eNnJy2myDbeUduJ88hfC7DQUAKjZUh00oAAWgABSAAlAACkABKAAFMhUAqMBBoAAUgAJQAApAASgABaAAFGicAgCVxhUJbggKQAEoAAWgABSAAlAACkABgAp8AApAASgABaAAFIACUAAKQIHGKQBQaVyR4IagABSAAlAACkABKAAFoAAUAKjAB6AAFIACUAAKQAEoAAWgABRonAIAlcYVCW4ICkABKAAFoAAUgAJQAApAAYAKfAAKQAEoAAWgABSAAlAACkCBxikAUGlckeCGoAAUgAJQAApAASgABaAAFACowAegABSAAlAACkABKAAFoAAUaJwCAJXGFQluCApAASgABaAAFIACUAAKQAGACnwACkABKAAFoAAUgAJQAApAgcYpAFBpXJHghqAAFIACUAAKQAEoAAWgABQAqMAHoAAUgAJQAApAASgABaAAFGicAgCVxhUJbggKQAEoAAWgABSAAlAACkABgAp8AApAASgABaAAFIACUAAKQIHGKQBQaVyR4IagABSAAlAACkABKAAFoAAUAKjAB6AAFIACUAAKQAEoAAWgABRonAKZoMI/PvjeJ4j/jwMKQAEoAAWgABSAAlAACkABKFCXAgGohJlkIXwx+LuuG4IdKAAFoAAUgAJQAApAASgABaBAEpMAVOAXUAAKQAEoAAWgABSAAlAAClhVAKBiVX4YhwJQAApAASgABaAAFIACUCBJAYAK/AIKQAEoAAWgABSAAlAACkCBxikAUGlckeCGoAAUgAJQAApAASgABaAAFACowAegABSAAlAACkABKAAFoAAUaJwCAJXGFQluCApAASgABaAAFIACUAAKQAGACnwACkABKAAFoAAUgAJQAApAgcYpIAaVpIC4tuZ9DBMnNIAPwAfgA/AB+AB8AD4AH4APmPeBxO+oQHjzwkNjaAwfgA/AB+AD8AH4AHwAPgAfSPeB0qBy+eWXE05oAB+AD8AH4APwAfgAfAA+AB+AD2T5QFkYKw0qbPDB9z6BExrAB+AD8AH4AHwAPgAfgA/AB+ADmT5QBlYW/uLPP4J9F9h7Ah+AD8AH4APwAfgAfAA+AB+ADzTGB5hR/n/Xl/wp7hRq3QAAAABJRU5ErkJggg==";
__base64Images["./projectile/2016-03-03_1334s.png"]="data:image/png;base64,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";
__base64Images["./projectile/2013-12-27_1418small.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAIAAABqhmJGAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAAAlwSFlzAAAOwgAADsIBFShKgAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTFH80I3AABBS0lEQVR4Xu19aXBj2XXeU2TLozhOnImjUpXtqKK4Ev9JJVVJOSm7KqmkIpetbJYsKSN5NNJoZqSRNPJs3bP3vq/slU02933f9x1cAJAgQQAksRAkAWLfQYIEiJVAvofHRrNBbEQDTbL73nrDef1w7nbe+e6597x7z/nSu1dZTk+IepT8bvtvbdsj/yQ3hAOEA4eHA7/9u38Q+NLvR9rzj176EvXG2ZE3z408aBPnd0hxPeyUlvTKyEU4QDhwCDlQ3CNjcArAArYALw3gt86zegW6I3QNiPQDAt2gUN8v0OFmTGLqmdHiGpea+mZ1uEbmDXg+PGdg/onnOwQSU/+sDrkGwyWMio29fC0uEDA3rAUjng+J6JJBiefdj0rGP1EUygQByqdL5tMEyIXCx8R0xgGhnr7QJLERD5mSQRbVJKZkEKBw3DBNQqXIiAZENQmNpDsbadKezj7RpF2dBVuQke5suEkop+dRZ/voG7ouurNzhkhnI2zcaVK4s+EmobM7XEIhO00i/N8rEhnlf9eMBqis6xq9lNt86UHLpQf034u5zRypEc8BWxrAr5/qe+PMAP7dMaX8+bsf36vqahwV458fnryCm+K2cfz94sr9O+XtF++V9c5qb5W24p/3q7trBgW1Q8IWtryyh9fKWWpgLVT3zZy9VVTSNl7aPlE7KDh3uzi/YRA0Je3j7ZMrKKqFvdjNV4OMKf9mcRPu8Ry/ltBZhB1TCvyzeVwGgk8v3L72sBa1l3Vxq/v5F+9XnLiSezW/Bj8BwJDyjil1K0fFAAk3nVNq3HdNa9on1Z08DR528TR4DqHE8zauCs8ZbOCmbZImxk8gABnukR3Pu6eRUYt7PAcl5Bg3HWHi7mk6IyoN39Ml08SzOjzExcAVN61cukm4DzeJJkD5UU3qnaFLZpqEdiIvU8jjJoVLRl2RJu10NjwW0E161IyoJjGdZUp73NndTWI6G24S3XE+ff+4s7GahI5HOss0ieks4T8EIKv8ZwB8v7CyiyUure1d1ZpLaro+OFsuVNjwHLAFeKkfvl9+7EoD/t3GXf5ff/N9ABiQa+Mu/ej1t8/kFL7x6w8/u3jn8oOq13/5/ocnL/fMas/mFL776TkAGD8BTt/5f6++9/mFXx87+dHZGz/8yc/ffv/T83dKj5+5/j//79+++c6xvLr+7/zg7z67dPfXx0/+8sMvOqdXu6ZXH9T2ojqUf62g7mxO0UdnrqOcN39z/Pt/9/o7H536+FzOT3/xLt2+X3944V4Z8Hz8zDUU8ssPPkfhn128/RjAk+qWMIAhTLiBPOGGRgs3DLPwPZ4/BjD3kUxz1QAPgxYQhOWYFkdkxD0jmniOG9DQJYfBQL8tbhhmfBrAeB5Gexgt3F0A3tUkDATISKOFy4wp9H2kSYA6njMKHDeRMeVRk8IARpOmHzeJVub8cJOYzoabFO4sPUw87uzuJnF3xhSms5FmME2im7erswAqg3ymSfE6i47TXCL8zzL/GQBfu1/WO6Uprev61WcPB7ny907eZwD86vHq9y5U0wA+fo0GcAdPCZAAwIXNI4AcAImbc7eKPzmfc6u05U5Fx7HTVwFgqOKTVx8AwJ9fvlfZy4MihZ4EAj+/dPdXx06cup4PWH5x+d4v3vv0RlFjbk3PsVNXobGvF9afv10S1vMKIBw3wG0rW55fP3CjsKGiZwo00PDQyRgs8BcEKL9+ZA5qGSPIO8dPoWRc1wvqCYAJgF+QAZQB8Plbxece9Fy6VVLZMnDs1PUf//pCBMAfXKp5DOCjtQbGuo6Z9GLpyMw28VKZZSpzDwL8xT2zwIOygsLBDZ7jIfIiI6NsmQkto4ugeUAAbQb1Qq+xw6Xhn8yakLkfEupBxkxi8Ry10LN3Pp0RD3HRTeLTxCCjmxS+x0SULjncJHppGp5aM03CspluEkpGk8IlM7N3ZGd0ON3Z8KQ30iSms0zzHnWWzsg8DDeJnio/2SSagGkS0/HdnR0Q0J1FLTtNinRW9Kize5tE+J9t/mPFJ9A1sha68ZaxvsMFCZxScxfNjAZ+DODuGfXRujp4qs5pNS7cdM3Qf3GhC+HnO0/wHPeR57sIMC/dybib4MmMNAFTYColM214qiaFS4hq8+MmPers0zQpfmdjcik2GyNNeqrOEv4nl1Ka/wlQ+RjAx67UFTQOdY4Jns3VMjJb3sYa4kmirurOUZXWqNabkl6zct3Cip5cCTjAX9QlZSNDsKQ2ziwSfsYVJ4FcJ1UaUmRmArK+senmkdn9Qqw1Hli6xv7uWOWOBgaAm4em7c8qKXWWAY5o3eWNusZnxDabLZVWLKrNqZC9yDSps0hvsqn01heZV4n7nin+DLNnljSW/fJZqbf2xwLLBF8SDeBr166h9KtXr1ZXV4vFYoVCsby8rNfrNRrNrVu3Hjx4gCe9vb0VFRVzc3NLS0srKyv4CQQ6nQ4/Wa1WDoeTl5dXXl4+PT2NvKBBgbhBMplMUqkUxHgCAI/y5v2B7aiLJ5LezMlRKpXvv//+7OxsQUFBZWWl0WhExpycHPxzZGSktbUVBJDO+fn5gYEB1IiEG/yzv7+/q6tLq9Xul0fPJX195yAYMhROeBF4BXw+f2FhATd4Wc3NzWNjY6urq2VlZeLFZQC4s7MTbARve3p6kEUgEOCfU1NTzyVz9tUpAPjc5ZsQYOQCxyCNuMcN5B/6Bn8ZluIh/qrVahDgOR6ChhF7lUoFxvaPTgLAeJ6fnw9KPGf4D6FFIXhHwBESCPCwqakJWKPBoreyYoFlek4WDeBXXnkF7+w73/nOz3/+88HBwR//+Mdnzpypqqp64403Xn/99dra2ocPH/7qV7+6c+fOuXPnfvGLX7z11lsXLlw4e/bs22+//Zvf/AYVt7e3f/755zdv3qyrqwPk3nzzTdzjBmUiy5UrVz788EMGwNDAa05vSXnVd7/7t9/5zndv3r5r23CPTS+cPnPms88+++ijj1AOsv/oRz/64osvUPXPfvaz733ve/X19SdPnkTzRHINWtjX1wdBBMjBJtSIm+HhYQw9+3o9zyvx3cIqvBq8IHAeHEPCP8+fP3/69Omf/OQnJ06cwNvEzWuvvSaclwDAly5dwruenJwEaMFJJHCG+fuCJwD4ez/6icFgAB8KCwsBAfDq3XffhTBfv34dig2SCfnncrl4CI7hHs+PHTuGm8uXLx8/fvzVV1/FmNjWO9LeP8bwH89PnTr105/+FPzHWAkFCTThTUH5QeYh/B988EFpaSkDYGhggKWssoYBy42cO1bH1gRfHA1gZEMG/C0pKQGSgTcUB/2GJ6gVowheP550dHRghAAya2pqMHKgP9CK6BLyQkMCY3StSiX0OeghJbm5uQAwtDowhtGdAXDH6KzS7MTV1jda3dTF3PexRUKhEF0CDboNBYKqURcqQvloT1tbG8qHIIqWNFDyIABikXCDf2L4QEvQzhdc4JjuVzR2gl3Qq5CDGzdugIfAJ+ZHmGFBgG7fvj0+Pg724snUjBAAbmxsBG/lcjnYCJ0AcYQMjI6OEmYCwB9+ehL6EEjDgHjv3j2INOaDQB3EG5AGgIuKisBhyDyQiYdANaT0nXfegfSCGBoImqapa3B8eg65wHawGiiDmgVGoIqRESUDIPfv38f0E1WAAJBhANz+CCzAf1VjBwOWfs7cs1gDm83mvTMxALhxcGZOtRZ1tbJmyRo4U4CJuQbGMgeYBHR38zlTa7xMtfywlZOAP1DLEO+ZmZmoNoPPbDYb+gw3kZ/SXgPHBEv7qOAJADcNTltt9mdzrWgt1b08zqI56qrrnyYAzpT4EiNWpjiZqQEOAJarLfuFmEIXGyz1AzOPAfzR1QaOQDq9sPLMLlQ3I1ZEXXi4tbXlTiGZ15xGO7mScCAFRtIkm84tnZUwMy4H9Dbn+qYrRWYmIFOodOnhKyZYuALpq8erdj4jfXy9MUQS4QDhwJHiwGsf1WQdwFgD4wMPSUk5wONNz83Nk+v544DRaMrSsPAsAMxisbLU+uepWL/ff+rUhbW1ELmePw4MD2cLAgTAh2UQIAB+/nAb6REB8GGBWfbaQQBMAJyGdBENnAbTspKFAJgAOA3BIgBOg2lZyUIATACchmARAKfBtKxkIQAmAE5DsAiA02BaVrIQABMApyFYBMBpMC0rWQiACYDTECwC4DSYlpUsBMAEwGkIFgFwGkzLShYCYALgNASLADgNpmUlCwEwAXAagkUAnAbTspKFAJgAOA3BOlQADqbRgecmy34AHHyOZf257Nrzv5XSt7nW31M8MLEKQM5NsoqqWxlkwusa4xAvkmQyWdSTvf9MTAPXRPDIB/ducMSToKj0KkLJ6Y0pKQJYPbeYX1rOF2+s2d099V1lzeOMxLe39w0PT8zOLkily1GXRLI0Nsbl8QTz87K9v+5+IhbLFxbkiWnm5xdRYGKaubkkFSF7UppD1Rg0mMMRpj24PP8A9jjtXV1NOuvmxpZ7fnqIy1tcX18HuuBbaHFxEV4pvY/SxsZG5D7eTQIanG0sKyvq6srp6LhcVPTB/HytRNIQ8xKJauL9FHm+m0ah4KM98MuVVQAr5+U17YNq5ZrO7Opu6+DxrXK5cXZ2GQ7qKivhV4nb0LBdWxuoqfG3tnpHR9Ee68DAtF5vgesytC0x6+BKweVyJabZ3Nz0eDyJaZ7yHTGFp9gYnJ5/Bo1BFWNjUwTA+5ZteM+LyoP3mrSUBDQOh6O4+LpO99uhEJXgspkpb4AmcKxT6+4nKNdslMcfI+/MzDE0DL6RkjYvJkGKGjieDBUVlYpEIqfTyRQeDIY2N0Nabai7W9nQYG5qCtXXh86c4bS0BJTKUCAQu41og8/nS9x+oHd7ezsxzVO+I6bwQ9UYtGd8nEcAvG/ZzjiAw2+iVaulAcwaofp7KTGfkuio8X6qvY2aWqb6m6npeaqzidKvUA3N1PXzlM5Jw3VkgrJpqSkZNcmldItUUxfVPEyNTlH8CWpimuLOUgcL4NbW9njjAjwewtEkVgRwQex2h7jcUF1dqKYm1NoaEouBkyA8dcMjMRK0GQFwPBklAN43epEh4wDGXKijo1Sn+wow2VRNNTdQReXU9iaVU0AJh6nWCaqtm/JuUO191HA5xVugztymAmFdzW6kmliU00UTNNynbt2nblRQPBZV30jdvUPZ3YcUwBGmB4NB4HP3O3C5QgJB6No1WW6uBaheW/PBfzABMAFwNAcSe+QIeDenRWKHaaVneDKwTRuip8b7tKadqWDGAYzZXW9vtV5PA9huobZc1KaLxqfFQCnVVCBAQ3TbT//1bVEyObW2vjNb9rnouXQwSLlcVMBDicXUlo/ybNDZrWGabGtgo0oxNmOen5npGZFhLmcxrDfWD5seefCIp4ETAJj5CYYGOHyRy0O1tb5PPuFM4iUknCCTKXQaE+nn04jl9zimuDM9Nfcf1I9KWI1XCppcm5u+YEg2PWZ2b2M5hxgT8EiOQBVwDgrNwCQYUSL38W4S0ywtLXA4J2dmPpdKL8hkF+NdCwvnEvzK/LSbRirtR3uyYcTSLKpYY6Jb5z5vYhnq824VNk7qdM61tWB3zxiESam0SyS6wsISMCpxx+P9Cj/4EokExkKn0zUzs1VU5Kup2dbrAzHZi/eCWUziV/D07wjlY76A0TZxRc+sMWgGMWLFnpsEg9sBREiC0dHj2w74oYIDftrGAhsG3h/81uMvJAYzQCbBTBq5j3eTlAZmmKQ0SQliNiZ7RiybNWBfCxn0G2Zr0Gr1A7pWawB/zWavwbBVV9cIRoFp8XiCLoMgMesgpgyrNzeDnZ3BoqKgUBiMKhK4CgQCictJj3VRZUYak6CuZ9YYtIGsgQ/FGhiNwFvHNxXE+IKwJmhTeqbU7AE48cwt7Sn0bg5EGX4xl56aChUXh0ZGPDLZEixhjKGLWKH3O4t+PqfQqQA642tgLOF4PB5EENM8RPHCyBqvGQTAEc7U1fEKC/1wLupwbCJkJAEwAfBj1Jg1cpFM5dk0j7Gn/GEjlmSSrbVly4gFBYLgacAt8AkkQ+ccDQDbt2c40/PyDaVUPjSxiLm0zewc7GBrrDtuaLOhgSOcgUdrq9W2sLB98aK6tlaKJU/iwTe9sS+qTPIdOBUNd5B7oRkjVld7RXMHa4k3eLuw0e3DGjjIGahVmB1M6zOugVGmxWLBR1FMoWEbOxJTaBixRkdnCouLOnrF3bUNDyuHrLZto8rQ1tKmND0LAGO8QwivcCxc++SkLy8vuLiYSLoIgKNU9PM8hV5dkVmd3q1108Ki1u3a8G17BZPT625flrZSpr4lM739gNmwQtPSYPOxuVKzPShfWJ6XObTaDaPGOsxasK2FmK2Uubn5MCODaQn2FSbtUYq7F10uT3e3/+FDv8EQu7akFSFbUpoUG0O2UmY9tMrTRGbIhgZmdEfUroa9CiU9NfI8GbFiKtnId+CNjVB5ObZq4ntBNGF6rCNT6FTmzFE0BzmFTqW5WQIwswbOxkLuxQEwwz2ZLHT3Lr5Fh/BtGHZBfGHCw6S8TYWGrIFTAciLCGAsgPE5BFv/8fdIrIFTsXlm1Yi1m0t7d2LBkH/jhuT6dYVarcNpSlgWCICf8zVwMOBVr2q0C7zGQY5n01pXXbvhsJTklq57aPMmp628iyPPkhELp5GwuZ+ZQgsEggRbf9OTwsxqYJN2XbJoYtdVdQnsStlSaWWvakF2L6/NbMOq2FV4NYcrczOycoAABjOnpqY0GloVz8+7gOH0WEem0Kmo3EMxhQ5ue/Vag9NhUOs2DEvTJU29ro01ld7s87i33FvjfR0LakuWjFhQIPj8q1AosHkQYvc0Jp+YlpjMGrHM+o3FZfu8cMVg9k/0dVZ1CtQSxZI+oFM5tCpLU32bTBd89kasveeBtVotRsO5OcmtW6LaWq/d/lRntsl54NSR/CJOocEd7PWDKiZr4GwoPcxvbt70JfxCR1ebVEuTNXAqMH5BAUys0DGFI1OYsdvdeXmhxL5JCIBTwWdSGgLguCxKKmEx1Uhm18CpmK8Owxo4ionhUxOhnh7ac0C8rW5J2Zup0SRpRalMB0BDDjNEQ8WqlHAWlp02VT9ryrVuyr9f5gzv0ZPxx8QrxiwZsSKNODrfgbdFo2Ns6YZUKOplLWrm5nIe9ljprR1bgx39UoX3cAKY4TPzkQlfjPempLgiAE6qfkFwMBo44Nuc4kzbTaszwpVldvu1wsZVCfvew9b1LbfX5xlrqxkQKgmAgUztkobFkc8Mc6QaT2tx3sPaia627praEb1hS6+1V9zPm1LS5woP3Aq9VwNHnsDUcPt2aGUlWhoJgFPBZ1KagwEw06zgts8fCHq3HOubW9t+j9W6jpPB/sC2zWr2+LezZIWGhdNkMonFYsx1sSn6kFuhGXCazbRNSLNqNpi3zboNlcZtMXltNr982YpTDYfBCh3FxqhtknB0efmyoqIChn8JjNXM5keylTIpOFMhOEgAp9K+jO/Egv0ZB+KYZQ9zrjBeM5KqCLIGTp11XO4klsRwjulwbADGqSw7yRQ6FYC8cADGzg3oXuAW3li4XC6z9S9mIgCOyZb0fGJhygOfmN3dhk8+mYVCJgBOBZyp0BwkgAM+97qT9pMIRy5wrLNmWwswp+uxzyPsVQcp4xoYZWLLLpxLQA9AGyfg0eEBsEG3oTfR3nNMZi+OJSmUG5g54592mw/udQ75GjjCYfATg6ZSGcSSGGatpOwlGvjwAhhGLB5nWimZbWwbdVjV5WVV6xbtlXO37D4at4LBxhHBzi7lbACY4cuRsEKHjViysbbeTpZcIhCVlncvTbDP3mo040C/ydny4P7k6vZRAXBEHE0m+LINGY1JDpMQAB9eANNaNhic6e+dUxqs6oX6HpZVI+8b4DkxLNNbKZtnV0zZM2IxFpekRpSkBM9gK2VYzXoay5qlqi3+2EhDv0TImR4YWdSoHHqdtaaqSab2Hn4j1l5LocPhvXDBs7JC+9CLl8h54EMN4FQal6Up9BHSwEd3I0fS94szS/hEvLwcl5Bo4KQ8BMFBroFTad8LPoV+jgEcdoIbevCADu8SMxEApwIQAuC4XEpqZUHOvTRkK2VMtuzlMsM6fMUrLAyFv+tFJwLgww5gnXx+gCu06+Xt/eNen5/NGXf76a+yM6Md00s6pvVEA6+tbbOHJkZ4KtEUr61vDlbojt4JuMJas3saKmrmVw/1VsoEIhgZ+4DhsjJEdSQATgWw0TQHo4GZrZTjbQ2dw8LFsYbzuXVa+cxnp2/bXS4YsRqKbnXx5LBy4Wtte3s7/u723pyeYozq91FxqUNboSfmy67njots9blX8+onRztazt9uVuM8sFJ389q1ccmW3R602babm9uiGLW3y0kN7wel9IDhGzfUzc10CEUc1WZe90E1Jh6MyGGG/Q0wOK+Ld1lQUADHN9j8mLo3yaQWZviFhlMO7MeCu+MjsZUy8UoY7BEKFXl5D8GoZ+OVMuMBvm022+yssKQkwOF44dDDarXivaRohc54Y+KJBImNtD8AZ2kKDRHHMI/Cj4RLnefbiBURCKhcjKdms+X+fXtl5Qzj54ho4FQAczBT6FRaliUAo1jIClwoQ/1CFaeySNsXDTFigV1pLHOAYShek8laULDN2KUJgFOByUEC2GXXybVmtHJj0+H3uhdksnBkldCaSalE3NtsGrH2Rrvey6w0pBCFZAPAcrBGRTuvU6kdZp2FK9QymlksFK/ofEduJxbD6njsxfoX35bgl4cA+PACmDFirS6JWttGTKuiqzdz19YtjWU16+GtlHV5Fzq49CwX6QW3QsOINTIhnRrub+tf5A713nrQrFhUlBV1YCulUa7IuXppaOFQeKWMErX0xr5IIZhB37mDI8T+BD5DGeL0TlakN1gTI1Y031ZEPHjecNr1PJHUYVKx2CIPYjq7vdOcEZ3dSbZSMqrVbvWyukelq+5lsXScr5fMiFiTKnilNBvW27vGddYjcB44plko8U5VRBG/fNmnUNAnhxMknEshoVVIaJXYU5X01Eg2ptCpmLIO1i90ZjUwU5rDEbhwwR/THU+kOqKBD3INnMoU/wWfQqcC3edsDRyRCqyBrVbf1ash506o2RjyQgBMABx3GCEaOCZrnhlmGCMWAj7cvEnvuDzYxqB2sgaOfgUayUR994Rldb6+c9ixZmmub3eEz/ELOT1D/J1TKkQDr60FB5tqejiqmfHx+o4ZxfxSVdMojFhrFndjVfXkous51sCMEQsRrOBlOiaGn9loQgD8BHoZK7SQM9Q9NLsy1X69sNmskuQ+aIQNC0Ys+cKcOxDEu8EGnerqanweZMLeMQleHSL38W4yQpNeIZldA9NW6NG53samAbahpfB2SevsVE9/Wf0UjFhWm3uCs0h7rtRuKhS2iooqMAoWnXg8gUJL2iPwPEEJTMlwYwJcJX4FSStK5T3CdhVpzMREoK4uuLdSzJKeTWNQ9dgYL/UVzXMe3CyV1S+ECXHuampqAOPdApER4UhFgNKrKLMATkVidDr4qbFXVFSDUYnhl7RHwAzYnhicADDGgmcMYFTX1rbd2GjAHti1tbVI7QTAL+IaGA6xmPCiK3u9Fe8aWsga+GCXnVEbOYRCUW6ubX4+qFQq1Wo1+Q7McOCFA/DRCi+aigZ+7tfAjKTCB7DPF4RBa2XFicGXAPgQADgY0OtN2D1pNOp9fv/iykogvJdSsyRY0liY9mXciIVNlIgAiuNN8HKK6e7ug4pRCufwaGC71SlbdMCaJZHqrSbPtGiVBq3dz2FNLGuet62Uuz8j7d6JhdeBUyiIyv7JJyvr6ztOS4kR62A0MGPEGmoqvFTcqpofOX7y6obT1tLQGXYrG+iqyO9m076/swFgplgsF81meht2gnQYAEwbscZED698WtC53FNfdjanVru8XNvAAYD1S8qyvKIhvv0F0cCRN6XV0rFawkeGyVbKA51Ce92b9rVNBFUxIVbXtn/N4QwH+PYu8KdN61tkK+Wj+XNQrbAiwLfVuL686l6zOlc1flihLWZXf8+M0f58bqVMfB54etpXVub3eLxkK+XBaODEqm/3rxmfQkcKT+qe4jBoYLIGjicqbW3YWUE08IFq4FRgTACcIoafv73QiY8TYgqdm4vwpZ4E0a0YAUtvIN4rnGQnViqAjaYhACYAjic3bncIpx0cDiYeT9xEAJwO8HbnYbFYTxThc02yB+rr2uUSfmXHqEE2XdrUY9YsVpZVaTbprXNjXRXDPLKVMmRSm1qb2qtqWezhzsYhFXtwoLyRLeTOFJW3aq0hk1LfUFM9Idx40YxYu2VJrfbl5MD5IQHw++UfX298WqTGyb8XwNzxrnu3H5bn36loZauE/bkV3YYlYXXz8MYWvFJ6q+6eEyis+GCLjRZwaod9F5l1andUQqsAwNjtnHOr8sqpCz2Tuu6K/JoeCXeQ1dAxQ4dWWVVfOX9Lrt8GewSClQcP8sGoI+rULuaJ3xSd2o2Pe2prAxl3Tri3QOLUbt/jAz7Swq0s/mbcrWwqS6P0pl7Pfisl3Mriamlpi2JUFLtT8SJ0qLzYpN6Y6uqQQECm0M9MA+8HyGQNTNbACeSF2cgRdisdivddP72BmBixHnMgegpNAByLA1A4p05dSBGue8leNCs0w8LITiybjQ5ZGjNaOwHwfgAXizYegDcMSo5g2b1pHBmZdG3YR0c5nvBWSrmIs6ixMSURDQysingCnsi6PCcbHJetylf7hucRWsVu2RrpHV3S+l9kI9burZR8vjcnRwGHwbCY7BZDAuDMA5jZSjnV11LWOGTRrpTVtaikE1dvFts83kBgu+7Bxf5sWqElEgnsPXAKjZedoG/pvfjMroHDWynnmkqK67sl81P8gpqRntbGh0VderNPt7hy9+at8TknATDzEsH52lofYixhl7tOtxNbKxVjR4o05DtwNFjsBo1lfcu9aVPqrR7n2qrBFvD7EOVMs7rkDQSztJXSYrEwEVXgFREHXHBENp4B85AE+F6zb4sFCr15W7GoXlJvKZe0yxqPUb+FrZSiBQ3QexQDfCcNf5N6aJWIV0oul7ux4b54MSAQLOP7RQZj8TBFESt0Opo8G1NoRGZQqVTMkeBDroFTXxK/4GtgvEccXcKUSihcOnHCgMjDkZTeTIoYsQ61EQsvFRo+8YiS3ovP7BSaADjxO4p5nJDDCTU1EQCnoy9j54lrhQ4G/QFsoqF9HT36S5cQ3Ma54J39cdnQwEwrj9BhBrstYLPhY++21ba9Zg/Sf8M+321Wvz18g4to4IjwQXYePgwplTsP0huIiQZOpIG3/VvSBZlkpO16abdpmfv56TvKJf7DBzUWL6Y+26yeqrZePpP/BQewYdU8I1Q15N0t75SOtdZeuN08PMQqL+4wrIUMCkNDQ2nPiIEAeC/YoBEuXNhxKE0A/LS6eK8GDgYDjvUNMW+cN7uslwlbB7lm9fz9ipawV0rXUE+rXGfJkhErddvGYTBiWc0e9ap9oGNgRmSZGBjtGpZO9neUdQi0KodGaaxrbFXQWymNs7PLubn5WAG+gFsp44VWkUp9+fn+VKxlKdIQI1Y6A8ELroHJGjiNNXAkS2traHKSHCdMB3dP5CE7sVJhIdmJFcWl1PdCx2Mvs8VSp9tKyv9UptnkO3BSNsYgIBo4RSVMjFgxxctoxBZL7yOTaFwJJABOBM54GniVP1zSNOpa13Z2jW46rN3t3XYvfbJzfnJsUbOzG44AGG7MO8pL2kfVi7NzHf0ihWSpoZ1ttNGhVboaupZNxAqd8DRwKNTf7+/vT6I8CID3B2BmK2Vna11X/5RBIc4tq8NWylOnblpxHNjjW5VOr5rd8Fem0WhKSkqwMw5BQ/CZnkmwLUXu492kQoPyE5eTSiF7aeCzNp2ZRogOSL/3MAO2UrJGZ8pLyruGVnjDI7nVrMGWmqu36tTaTTgC7Okex1/EVRGLNQUFRWBU4k4l7TIMQkysgwSJ2buWDdZFlZliY/ApOHFjHI6NnJyAVkuHSnsagSFGrGjB9ns9Xl9g2+/b8njx7XfL5Q7CucI2/qPdy+LjMN5Nc3Mz/kK4mcOuSAjtEbmPd5MKDSQ1cTmpFLKXJhsbObBx0moPmk1ukyVgNXsNJp/NGsAXYKs1gAm2xeI3mTwNDU1MVJR4nQJnk3YZ8g1wJmYLE70lG6yLKjODjcFX9OvXsd0gbqtTeddkDZyOZiJTaLIGTiA3qTt2Z7NDnZ1kDZwOBkPECp0K24gVOuNWaKZAZn0Li/Tdu4gBEvtVkDXw/tbADLXf49TorYGAV6vT+bw4Z6P0hEMzbNiN604PQ5MNDYyJFCLc6fX6BHFVIi8+Mfb2vvhsTKG1q5ZlpcusX5ct2Y1qu2heb7XDdhVclqmNVmLESmLEirwjiUT3ySdyiUSGw6RRzmgJgPcHYMaI1d9aUVDRrZNOXM4pW99Y627vc/vpl8Hndo8JV7MEYLw5YAyHCmHywbGkBO1O5aVmG8C0EWtMUHTvVlWLeKSl8fbDbr1CXdc8aQOALc66hga+ZItspUxlkMXSHYfP4Au+uzuEE/8Icbg7VyrvmqyBo/ksn+UKF7XW1cX+CcGWa9NidzChVfq6mwx2V5a2UsKgPTc3x+yem5qaOgLngW3eofbBuWXn9DhviKPUyPUaaxChVYxaU0Vtn95KzgO7E7ikjGyTBIAxXstk8lOntMPDMwiOtTtXKttmiRU6lZVgNE02ptA47Y04dzjWDyV8yDVwihYschopxfcITavVOmGRjtraQTTw/qbQqUM5GwBmaj9CxwlTgTHZiRVPqPaCc3AwNDz8BDkBMAHwDgeyYcQiAI4nXql/RtpdAvx1XL0a2tx8/IwAOB0AG5fm2nomnHZVZVXnukl54fRth482Ys0OtXEXNFkyYkUaenQ08PZk30DXiEI6xats5kk57LPX6y04xG9z1RVVza14iRErFSNWFI3BQH9ViiQC4P0BmLFCa+QL2nWPYWmusL5VI5+6X9DucGEv5dZgU8WoWJ0lI9bROg9MW6E5i5MTQqM1wBkcLmlmD3R0VdVPILSKVmUpzSuYWQ2Q88CpGLH20tTV+SYn6QPD5DxwkiUt2ciRypqfbOSI4tLTHydkCoynXT2e0MWL2IKeiGZ3k8hnpFTEOJqGGLFSWQATK3QC2UowPYZf8LIyAuBkwCQaOBmH6N+JBn7GGpiprqgIx7lS8tpBNHC0GJsV0slZmdezyZ8VBPzemcnZrfBWylDAY3U4iRHrke7dnhmdmhQY9UrNOE+xZnL0D4lxipD2SmlcV+rpA0lEA6engZELzoVhkSZGrHSMWOtm9ZxcqxGN5pa06FVLxYXVDj/8y2435Z5vY4sJgAHLsBFLLp5dkCxvDja3FVYOiljswpohWKFNGuPVYx9OKEhspFT3QseTUcSf7+hwJ50lEQ0czSIHjukHQxsm1cS0dNOm406JPfRWSg/AbFqnHa8vLy8/fPgQzhaNRmPq1uMUjYpJd88lJYhZUWYP9Ie1a1CxYsPp37lpEYdvWJwVs6d18Epptnj5fLnBQrxSprSVMrGl+tIln8mUmISEVkk6xMUiIEYsYsRKIDjpbeTYW6BU6i4sTCKgRAOng2ACYALgZwBgrIFLS0NLS4lElACYADgRB4gV+kCs0EylALDXG7p8GRHS4r4jAuDdrKHjH0knO/PqehFd9H5ujdfraelo2wqfBzZKuGMiJTFi0brXHrTZ/A1FufWDixLOeG7FGJwdFNf2IsA3fp1srZ9cIVbopzViMQDGXxZru7ZWrVAowsG6ohMB8GOOBHzOmUn+SG/TwBBPtyJu7BvSrohu3a1YC2+lbCi+zZZkcSsloj/jOCFOh+62je21YBwGI5ZuWTs6JqivqhocVXJZnKZ+/lhvX35pvxpbKZXqG1fvzam9ZCtlelspo84DY2/82Nj46dNOo9GJUMPw4BlVLDkPfCim0DjBLxQKcR4Ugy5ODsUcayPTqqQtzrZHjhQXwOQ7cII3lco3XtBAEiAPWm0oLw+L4WWz2RxVJtHASeEQgyDjRiwsNXk8Ht4WhlgOhxPlG2l3C1J88VGNJscJIzPSxO87KXuzvRd677vGjEwqlV26tMRma8kU+jEHDttWSkyWlpaWpFIp5khPP3ITAO/lYVJwpgLyZw9gpiM4J3zlSmhvNBaigaNftN2g5IoWPS7bOGfS5XKMTrC92/RWSu2yUKK2ECPWo/lzUDglmJw3ry4uD45LtSurPaPicFzvbS5rXKYm54EzZsSKCOjQULTLDvxEALzbiEWfBx7oqWloHlieGblb1GA2ahuqmzZ8cJ7v728q75umHX9iDG5tbcXf3aEAkoYXYNa3SaM3JKVJShCzosxOobGVcoQ1W1Ve2NQx11ffnF8+sChZrijtMtu2TRpzWX7e6PyWzRZAcIamphYwig5sET8l7RGj9JJGZkhcS6b4j8YkDROROBgF05Gkvd5LAx5cuxaKCgFCABytga2qJaXB5naYRRKVZ9M6L1b4vB7ERpIuCNe36BhIcDpXVFQEH3TwApvZ2EjMLshsBPjJwlbKbQF7Vqn3y8WYmawpJQqB2KbXbFjMLtaEBKcalpctc3Or+fkFYJTD4YjXKXQ5aWwkyDqCjCRmCwpJGo4oKW9TiXGFlU7SxsAkmaXGCASBysonwikRK/ShMGJFGnF0XOrsuG5PbJEmTu3iiVfaC3L43NltiiYamAA4EQfITqwo7hyUESvSDMRhuX//sTWLAJgAmAD4MQeSKsYDBzDaWl4Ov/k7bSYAfvzygoiHpNZxxvvaO0Y27cobOSWONXNpfuU6fR44VHv/RPmQiFihMWc26xxSiRoGqo6eeWylvFnQr5iXPSjsMiOqqNpw9pMPeuec5EB/Ys2QdKRI8E0LOywvXaIDoxEr9BNMZgA80lHezZUaVsQdLLZFLaus7fcgwLTbO9hRK9FYsnceGKYRvFSUj5sEu/AOw1ZKGsBS3YM7d6bEdmyl7BoTT/UMtQyIEVrFsGqoqmla1JHzwBk4D5zgXff0+AcHaXs4MWId/BS6vr7+rbfegrUWrgI0Gk1NTc3Q0JBarY7ZsvRG7sx+RiJbKRMLTabOAyd419jsg30d+Eum0AcJYHy6vHDhwhtvvIEvUvjuhxf/8ssvUxT1ta99rbS0FOHO9u6pJACO+cKeAWaYeg/DGphpCZ8famkhAE4HvzHiA6tUqqQl7aXRarWICSwQCJi8BoPhvffe+4u/+Is/+qM/GhwclEgkfX19UcWmV9FBaeD6+qbEbMEIhUlHYhrMJO12e2IasC7xFlRkT491UfXigzNiCCZtDAaUxDRP3xifz//aa6bbt7tTnxBFUQ4Ps5IKbXoEr31U88GlGuqH75d/fL0xvSKS5nqavdBNTU1Qj4jsGkmVlZW7/xnzfi/N8PAwn8//5S9/eerUqbt373Z1ddXW1iLv6Ogogoyy2ey9WdKrqBvxZ9NKT/kZ6c6de0KhKMHF589WV9ckpsGCoqenJzFNY2Pj5ORkYhqwLjEBfk1Kg1cGZiYup6mpmcPhZrsx771X/dJL/B//uMRuR2j4lD7LEwDvgACbKKPsTJCeJN7HvN54NBitkZAdf4HbxOWkVxFwmBZ+n9Yv9ODglNnsTXAZDFvDw9OJacRirVC4kphmYkKkUq0nphkYmExMgF+T0sB6NzuLY32JOsVmzyuV9mw3Bv7ucIHD6aEXuV5cDbwXDJjm4aHX7XKH3XcEt/0bmztOpCPEDI17y4m91cxD3x5crdksLk/YgUow6HRu7j19gkLcro1wJXTCNuGYjdlybjCV+D1bLnd8jyzJYP2UGlijduh0m+FDDiGTwWWybEdJG7SHVuMwGX3Mc5vVb9ujT4AErWrNYAq7qrUH1BonU+DuS6dzWa1+q5X2BGK3+dW6rb1irdE4tJpNq43WVxbzltawc+JiN6VKaVOtOmx2pjE+izW6wWazz6DfVGtdTC6DbsO0h0avdxn1m0Zz2C2JfVv7iHh3RRrNBlM+Wmuy7DRbo9n5/MZQgsZqdlvtIdRottLNNpvcq+onug8ai9mNBmPzuS3cNTgMBbBTQTUB8GPxN2tXJLJl1shQZ/8Ynqrnhk9dLozygKJaEiuWpB2dfWMzC6AxrC7UNnY+gaBgkDva19Q5gIcmmbCyqUFvo52q7E4eh3VkuHpwgl5yG1eElQ0jMQCsWWnvqRNIrXBnPVBXWtI2mgyncX9/SgDLpgT5pQ1LKs+azdFW2VrfL9orWLJpVkkL/dxqXM8rKF3S7IB5N+XMYE99D02zKOSf+PyGwrp3xhgYaGrrHV8FzapUnp/fiY/SUXVZDPbzn10Rq2hsV+devVvL3dsYk9pUkN9itNHAay6rmZLARhFdDm+k/8K1Uh1orJt3Lp9jzT+BOoa+s76qrlOAm1nWdE1V/aJ+T4N3yrdxGmq7+CZ6LFCqLl+vNFl2zYet7oJbRcsWf1dV8/A0zCUhpURSWDvKuC7auUyOe7fKtSZXRWkJf5HumpAzUdNGV530IgB+LPfb2wGf28nu7ZWZNxzrGxqpoGtsNgoWgYDft2Ee6BrUrjvWnZ5l4UjnxNyTNEH+cJ9AaVp3bFhWZT0T7HBg0yeS17nW09NqdbrXN7bkPFY/R7AXfJtmTddQP5rh9Hp47MFZeXIDWzwEPyWAl4SSpj6OTr1uNG+2N3aJF2PIuk5hUWicOs26RqErKe5YNe44hd8lf4HOmlrBkkOt2lyaW2hoYjMhIJ64rFttVY1TYrNa5eT1jfZylveKr355tbGJA+Ws1bkHOrunFmjYRF1GlW1pdVOv2zBbgnLpqiHGSAGE8LrwltQOo9rS1jqwqNvb4FBzcT57zq5SOxT8mXtlI09A7lGlTPmLizpMLtSqDensQssAn1H+kWtuYXXNslFZ2KzQulRaj0Ku1+7hD2isOktZceuiwqbSBUwrqzJdcvSiCgLgtBXbkcn4lABOqgQIwQFygAD4yOAw7Ya+aABWr9hjqPcUpqMHiMO0qyYAThsXMTJu+zbYI+zWzo6tvfPmTNazv7JeKADbzeuffHZBbdrxiZs2MI5KRgLg/YEhMbVrXffg8ie9whiOyzJZzT7LeqEAbFNJcytmjwr8nr6dBMD7RENCcofduOnBR5Rov6GZrGP/Zb1QALabnTMLxqcHxlEpgQB4/4A4ajleKAAfFeBlqp0EwEcNjvtvLwFwptByCMshAN4/II5aDgLgQwi8TDWJAPiowXH/7SUAzhRaDmE5RxvAYrF4nqRkHMChq/LySj5/nlzPHwfEYsn+h/SUcsQ+TohDfDjJRRLhAOHAIeQA4BkBd2wAX7ly5eLFiziQSRLhAOHAoeIAgAl4JgHwpUuXdqM8Qv2Hfxh6+eUk12uvhaqrQ6+8cngvi8UOj3Y4LZggIcSByWRCx7/+9bj91elCIZzef3k/lzgUeuXwXt42HL41J+YMfrVarbS/oS9S6/i/D4vPqVPJRSciW//hP4TY7MMrQK+84hAKcXgqqQjBewn8N4X+x//YR9+jAFZfHzWTBjABzzQB/NWvhigqyfXd74Y++YSm+b3fc/7Jn6j/+I+Nv/VbgaS5niWB2Wyj2UqfJQ7wuSMIpKZbEfX3941yZnx+n3pZEw6xFoKY4u9XvhK3v7SDmtZQiNrPNUUTB74cMPyxQf0naufvOfeXfV917Z/YfcUNRzaMcATcG8t6K/7HGxuZnEOoKr+YxxZIaAeACGqBmCah92N2PLhEiZxU8HG/vhEu7tix5KITEYJ/9a9CNTWg9770kvab39T+y3/p/Z3f2Uf27AuTfWDgkRO14OIcjydRMOfOHWZV7wgbx9AZHsIlEC1pf/ZnMRs/R1ERYGxR1EK42csUNURRm5EuVFZmHsB//leh//SvQz99I/Rl1Pjbof/8X0Lf+lbov//X0D8MY5sB8H/8j8qurvGxsTH4rMnJ4Xzzm6ZvfMN2sNfXv+740pfoFgLAfpedx+MvsMry+mVXLt9wh0Jr2rmCqu41s/zayTxP+GjhbgD/iz8Nvf9O6P1PQ//3B6Hv/Ned17EbwD1UrYPSDVNVvdTcBNW5Rm1DghUUv5/q76eGjJR3R6CnQq7fdXFvcsEWMGe8e1z2X2S2b9gO9rL/C7v/d/xoIQPgFalQuqLT8AfOVQ5se3H8cPne3VydfuXGxXuXz9/GseknAbxVQ5U1UaU1VHc91eWirG0Ua45qqaW6+JSR7vWTAOZR1BmKGqCoaYrqCItpkKJmKao/fHkYwQ0D2PyNb0xUV4NRSOyyMtW//bcHLEDf+Mb6H/7h9pe/jBYCwAGPa07Al88OXanorS28J7O4IDN1D25WlNxtFuz4Od0NYHSzgqLqKaqFouooyk1RXRQ1SlFtYei2UpSAojgUtUZRAHZPVgH81T8I3asP/Z9/F5bjOAD+9NNpeJCDhzck2FcHBgZFIri2OshreHjqq1+lhzwAeNsPRwrr7k17ZeGtD87edm8Y7t0rdwWCXpfp3qnbpo0tvnDaYKJDnDIa+E//LPT6/wq991Hom18PnT4eA8AqinWaytFRrkrqQik1zMA1JoAVf6KYE8wxnBEKhQMDA3MieP06yEskEKn+RhUBsGvTselyb6zOnsir27CvSWXz9/JuSoQT1+/W3T57ZUkl5y/rd2ngzTKqXk2xhqnlNqqURbXLKZ+MGs6jrtVQC3sBfCMsuIDuubD4JgCw6G/+BpZ7hlHwXjZIM+pABUgk4nM46//m3zAA3g74HY71LZezu6n0g49PqvXqecnq3ZsXWD3l+T3CvRp4m6JKKWqFolgUVUxR4xRlDI9c98LDWURFsynqLkXpswrgr/zj0JlP485oGA38p3+qbWublctX5uZkZ85M/9VfbXz721sHe/35n3sZDWwyWREdD962/O4NiWwJjnW2IKeOLTxxrpvgodJoh5cWhGun18AMgL/yUuif/G7on74c+u3fCv2zl2MAOEQFzNRakArUUQ/tuyeQUfPYqZDnJc/syVnZnGxlaWW2bXb1f69ufXvrgK+/3gq+TE96PVc9WNqBD0gWrUoilTo2nUuL9HF4uEhQK5c0BjtGPbXRugvA2w5qw0+5XJRvk7KNURyU46RMMmrZRQX2AtgeniU6Kaokom/3znjDGtj+9a/PFBQsyWS4pu/fN//1Xx+wAH37257/9t9CL71EA3hwkIlsCucSS0ty26bb59602NZp+VlccfvogLhIMCjsnkI7KMpHUa6wmp0ITz1wI3+SD0C1LHsAPns2dOJEkguLF2YN/JWv+L72NfPv//76l76Eph6iJYzH40dMBohg4sT4Kz19Om5/HY5QSBoKndjPhc+BVCj4peD6P123fM3i+4rvUK2Bg7foaLrJGONkIu6GelLr+I2wNurtTS46Edm6eZNZAwe+/GXrP//ntj/4g+1/8A8OkQBR1DaPl4oI7UTAzMvbR9+jACbcUeaRlXBKRqzz58+fO3cuP930zjv53/rW4b3y8tLt2NPny8nP/9Yhvo4/fQ8zVMIXXxxeAYJwX76coX7uuxgAE/CM4Dn2d2B4AF8iiXDgCHJALpfL4qfFxUUQMN1KTIkydlMiY4JiI5TPhmG7HfQ/C8fuUXZw8k/CgSxxAB9mEYdBET8plUrE6GBi6yAmFv4ZjxY/gQCew/G5CFkSU6LSyOe3LHUtXrGHAsDYx4+NE/hs82wSXvPeSEgMg7C6g+k/kpLGGUnjbUEmUOzuKtL2BZ9K7bvrQqVYuaWSK4M0qDTpzpB4BLCo7avBq6urCFsnlUphiUSqq+tlsXjMPZOYn2DC1Ov1wCTzz8FBdkvLyNAQRySa302JIHiwQkEkoHsjZfb0jJ09WxlVJihTCeCSQa4mmUJno6Z4ZYKb6D8GQvxNJWFfG05HMJTT09MIOIiPDTEzghKM3vsT6sKbjtkevAYkTIRaWloqKiqQPR7Uo7MHg97UYjLAuo3aI3MtCBy2he2X4V5fqh7k0QVUwVSHeuN1PEEDEteFzTD+wB6XvLuKYz6n+70+xnW+z+th9skgBXw++j647dzc8MUqBMzf1xiKPi4sLMw+Sjk5VR99VHPzZi0+REUe4gZjKGah4Azz8PbtqqIidl5e88mTdU1NfRFKiBm2UmEEwQdR5mF9fc9Pf3r7rbdyX3/96ttv5zQ27hCDEkze70vMCP3Ba2AwCDgsKCjAF9G8cMrJySkpKbl8+TLiBt68efP+/ftcLhc0HA7nxo0b3//+9xsaGq5fv46fvve97925c+fkyZPYXAZ67Du/d+/etWvXent7QYBf8QQZkRCf6fbt27du3UL4H/wTYVNisg+Lmbq6OrTh448/nggnyJDTstLcNqQTT0s0DkjbRHfjhGB1gTe4qjMM9vXNLtC+oA3Sobc+OWnfivIwH6MSzMfQAKZwJER4oZWkVlZW0uGwq4RCXndjjd5qYbNmAAv9iqC6ZnDNIOGIFgVT40ODU7CMBzzrb7/7hkSRkk8vhH1CYuri8XhQJmiTZp7d0tbayxV11NeZLAYOew440izyahtYdo2IK1ZMc0ZHWDNeAG/L+tbfv7GoMsaTNvFg3eUr9bS9PhiUCKfGkXgCJmgGkwBg74bx1icX9O6QSSG8+OYx8Rr9q9+9/vDjk0vO0MpkfWl7V3FJ9J5B0EQBWCOb6ensFYuEAx2d7MkFs1bc1tohWnncNuhJRk6YXl+9Wnr8eO31683T0wLmCfMTAIxhGrGymH9ev1768OH4/fsNn35a39Q0hhIYSsAeiho2eYhfpMyyspYTJ8ogJ83NfT/72T2MAgwlFskZAeR+Czl4AINBABUCf8Ie9+qrrx4/fvyjjz76y7/8S/z99a9/jSdtbW3ANhIIPvzwwzfffPPYsWOvvPLKr371q+9+97uI8fvDH/7wBz/4AcD59ttvf+tb38Kv7777Lihff/11RDBj8qIKKFUE5sINwhHiSUxOQZn39/djUGhubu4MJ0YDdzUVljcNMFrPa1ecvnl7dl6+ta6pKi6u7KGjMaxr+WcLalLhPkQHVTCFI2GsQcRTiH9LWU5d35jd5VMtsO4XlS0bmXgxwfL8yy0DbJdnq7e1Kb+keN0DrHk/PP15KnXRLe/q2l0XdkTgIbe7ra2z+rOz1cuzfbklNasWJipFsOD+hfZBrte31dHYUFBRvulFXe4PT+NDWdykE471DuBjGg1g3lhfK1I/y+l9PJAxGrgvt1jvDtRW5N754Hi3UGU3WxFCaiK/GADmt+RwNY6CvHt764gCsGCit6W1seTUp9cLqiurKkuv3lW6fC4X9tHtJGwZwv42vGIm3bxZOjAwg2Er8oS5wQIY82eMaMw/i4rqurpmamo6ZmbmsesrQoyxCKMt5BNTOebh1avF77xz6+///s5779395S9zHjxoZQoBJZRwim8ks2QHD2CsADGGQekhbiDUJhTp6dOnHz58eOLECehYqNzi4mLoWCSoVtB88cUXCGx39uxZxPvFEyhM5MJNWVnZgwcPcI/sUOAMJSbYwH9U6ujowHQoJh+xFGfsk0zCa4bBA+GX5CLOnOKxEzzd0qIzEPJumAZ7+ufCmjDgcfT1dqaigbGmwnQrUgVm+Ey0zqBvc1mB4xHBDbuqb3g60jzPhlWFPcnb3ln26MgUPxztKTg7OZKiBsacOVIXukbHL0E8Gsl0//BgV3uv3qDoZwkidbnsJq15Pbz/mTU6I/SHJ7jT7MEEGtjntA32TSSI8Inhybth6GxumlnUgJcm2aLdExRxZxxbawPtTROiJe+WgzXcuaSy0qx+MmEvxO4p9Kp0pm+gX2/UswcGOAKpw6bp7+qWah6HIMVrRZhYjFmRhPFx9z+ZewAYbMc4vven3U8wzsKOBesU5nHM85aW9t7eYebq66ODJzLPQcmMjM8+HTyAw2N3EKYOLA6fTQJKmcMMKaaAe30htflqigUmIgtuLy4tenZNQTNQZpwiMDBJ5fJI/LcsVQRup23EQt6ksYh3NxsjIwZrTAL2jtrME/wEhENnYF6AcTwxJWYuGO+AdowCiSlRchrGhYww/FAAOCM9IYUQDoADgBywhKlTzIQpMYymDKMwN8ZyJh4ldG/EAI5BhPmSFDOhujTMkJl6WQTAmeIkKYdw4AA4QAB8AEwnVRIOZIoDBMCZ4iQph3DgADhAAHwATCdVEg5kigM7AH79VN/714czVSgph3CAcODZcOCts4O/uTJIvXF25BcX6A0JJBEOEA4cIQ4AtgAvDeC3zrO4c0ZyEQ4QDhwhDgC2NIDfvUr/L3K99mnTLz4vJBfhAOHAIeTAOxdad6MV4P3/jRal1HLyTF4AAAAASUVORK5CYII=";
__base64Images["./projectile/2014-05-05 13.32.15.jpg"]="data:image/jpeg;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["./projectile/240px-Soccer_ball.svg.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAPAAAADwCAYAAAA+VemSAAAgAElEQVR4nOy9eXxU1d0//p59yUwmmWwkBLIRQpCQQNhkdykSacUqoCKuuCu29elTtdYVty62Wh/b/mzdqIqC1S8oOyirQJBAAmEJISEJgezL7Pv8/qDneObm3tkyWUjyfr3ua+beuTP3nDvnfT/r+RxgCEMYwhCGMIQhDGEIQxjCEIYwhCEMYQhD6OcQ9XUDhtA9rFmzRmez2QpdLleSw+EY6fV65R6PR+JwOIaz58nl8nqxWOwWiUQOuVxeK5VKG5VK5eElS5Z09lXbh9B9DBG4H2PVqlVzjEbjTzo6Oia1tLRkms3mOKvVqna73VKPxyN2u91iAFCr1VAqlVAoFJDJZJBKpZBIJBCJLv29Ho8HHo8HLpcLDocDdrsdVqsVFosFHo8HUqnUIxaLPRKJxKVWqy06na5Zr9dXxcTElGi12m133nnnrj69EUMQxBCB+wE++eSTgpaWlnsbGhpmtra2phkMhmibzSaNjo5GQkICEhISEBcXB71eD7lcDgAQi8U+v8HdDwSPxwOv1wsA8Hq99L3FYkFbWxtaW1vR0tKCxsZGdHZ2IioqyqXT6QxJSUnnkpKS9sTFxb23bNmyYxHo/hC6gSEC9zLWrFkjb29vf+j8+fNLL168OKatrU0rl8vFI0eOxIgRIzB8+HDIZDJKSO4r971IJKKSlj3GB0JSdp8lr8fjoZ+R9+yr2WzG+fPnUVdXh9raWrjdbo9erzeNGDHi5PDhwz+Ni4t7Z8mSJe6wbswQwsIQgXsB77333p2VlZW/rKurG2MymVQpKSkYNWoUMjMzIZVKIRKJIBaLu5CVkJPd2OMEoUpfwJeswCUy80llsvER2uPxwGKx4OzZs6isrERjYyOioqJsWVlZJ7Ozs99cvnz5qpAbNoSQMETgHsDq1atT6uvr/3D27Nl5LS0tcTExMeLc3FxkZ2d3IapYLOYlqpAEFiIx+xl3n5W8XClMjrGSWIiwQoQmm9frhd1ux8mTJ3Hq1CkYDAZPQkJC25gxY7akpqb+z9KlSxvDvadD4McQgSOEDRs2DCsvL//r6dOn57e3t2uzs7Mxfvx46HQ6HwnLJS15zxLVn+Qlr0JkFVKfCViSco9zP3O73T6f8RGXPU5e3W43/byhoQHHjh1DZWUlEhISDHl5eZvS09NXLFmypDm8Oz0EFkME7gZKS0ujiouLdx44cCC/ra1NdsUVV2DChAlQKpVdyMruA+jyGTkmpC4LkTdY4rIQkshcEnMJy9rKXFKzBPZ6vXC73fQBQEjd3t6OkpISVFRUID4+3jxz5szdeXl5N0+fPt0awm0fAoMhAoeBJUuWfLpnz55btVqtaNasWZg2bRpiY2MRFRXFK2mF9gFhiRtIAvO9hgquxOXzSnMlLB+p+aQw2dxuN++x+vp6HDhwAHV1dcjNzbVnZ2e/8ctf/vKZsDoyiDFE4CBRVFQUXVFRUXvu3Dmd2+2GWCxGYWEhHnjgAeh0Osjlcmi1WkpOiUQCAJBIJIIqMyt92WNk358kJsdYBEtkPvWZ+8rnzOISlt1YogLoQlguuV0uF0wmE2w2G4qLi/Hvf/8bI0eOxIoVK46NHj16ylVXXWUL/t8ZvBgicAAsWLCgcPfu3fuMRqOCHCNEysjIwP/+7/8iMTERCoUC0dHRNIGCT+KyJOU6rFii8jmsgK7hI773oUBIlSYk9OeR5jvGVaPZ84hKzZLabDbDbrejpaUF77zzDuRyOXJyctDW1oY5c+ZUZWZmTh9yfPmHtK8b0F8xbdq0J0tKSl7dsGEDZQ2XfAaDAR6PBxKJBDKZjL7ySVk+KcwlayiOKyH1OVgnFneffZVIJIJSORCJudKYvIrFYkilUh+J7HQ6IRKJoFKpEBUVBZfLhdmzZ0On0+GHH37I3L1798UVK1acmzx58m133nnnwVD+v8GCIQJzMH369MeLi4vfPHDggAgAr6QkGxmAcrm8C4H5SMz9DQBd9kOxfQkiIYHZfT7SsvvkPdcTTTapVMpr+5J9iUQCj8dDs8rUajU0Gg2ampogkUgglUoxY8YMzJkzR1RaWprx8ccfH7j//vsvzJkz58Zly5YdCquzAxRDBP4vZs6ceW9xcfE/v//+ezEAQdJyCexyuSAWi2kOshCBg/k9PmkbiuMqXBuYPRbIscXd54aaCFElEgmvJGY3heKSVaJUKqFWq6mklsvllMiFhYXIz8/H8ePHUz7++OPiRx99tObKK6/82VAa5yUMegLPmTPnygMHDuzZu3evBBAmrpCkNBqNkEqlkMvlPgTmk7pA4DhvsJI3XALzkZd7PBQSE2nKp1qLxWJeu5hsRKWWSqV0AgZ5EJJ7SX6noKAA48aNQ2lpadpHH31U9otf/KJy2rRpc2677bYLATs9gDFoCVxUVKQ4ePBg865du7QAP3EDkU0qlcJgMNDBR6QGX4ZVqMQVImt3SexP+gq9D2QPEzteiMisF5olsVQqhdfrpaR1uVyQyWRUAisUChCPP+v5z8/Px4EDB0a9995751955ZWvn3nmmYV+Oz2AMSgJPGbMmO83bdp0Jdn3Z6f6I5xEIoHT6aQOGiJBglWXg5W4/mzecO1fAiHysvtCNjB7jCtxxWKxoCQm72UyGQBQDYbcL1YKEwlP7jNRs2fOnIlp06aJNm3adMMNN9zgmD9//vOPPPLIa926GZchBhWBZ86cecf+/ftXnTp1CsCPIZtgpC4fqcRiMex2O5W+RAKHInnJa1+QlyAQiYWksj/nFvtKyMx1aMnlckpksq9QKHxUaAA+Upj4HMixBQsWoLm5Wfb111+/escdd/y6qKhoxtKlS09F5MZcBhg0BE5MTGzdu3evHvBNmggkdcn5fGqtSCSCw+GgA45IjGAleCAb1x95+fbDgdfr7fI7/tRo8j4YScxKYY/HQ+8zS2xWyspkMrqxBCaJMYS0LpcLEomEkjkpKQn33HMPSktL9R9++OGJ11577Yunn356SbdvzmWA0OehXWaYNm3aSpFI5G1qatIDPw4GvlehyQZ8hAQuEYhPArP77Obvmuw++xAIlJbZ3c1fn4XaJ9QPbj+594WE2tiHHUl8IV5puVxOHYKsJCavxEbme504cSIefvhh0alTpxYvWrTI/P7778/p08HXCxjQEliv1xsPHDigAbqqy/7isuT8QGqs1+uFw+Gg3yMD15/U9ffbgdTjYCRuoHOEvNDcfvEd434eyMnFjREDoOovkcDk/rvdbkpQ8hBQKBQ08YN8j+8hw1Wrb7rpJlRUVKg//vjjnStXrtz47LPPLgh44y5TDEgJfM011ywSi8XetrY2DQBe6eDPU8w9DvCr0STlkCUun/Ti27jXC2SHBytxAyFYqezvGJ82wLdxtRG+40TNtlgsiIqK8qnrxSbHkH1iJ7PqNtlnJfKYMWOwYsUKVFRUXH/bbbd1fvrpp2N6Yqz1NQYcgTMyMk7u2LFjLbG5uIMnEKn8SU4+kKc/ey1/6rEQiQMRlSASanMwD4BAxA6W0HymA/d+uN1uWK1WaDQaqFQqSCQSGkpiPdJctZrduOo0eX/zzTdj7Nix0R988MGJt95669WeG3l9gwGjQhcVFUXv2LGjvbq6WgzAL1HIe3IeEPoUPaIWulwuqg6KRCKYTCZ6HdaWJbOTiATiXpeLYKRpT0DoukQF5pKcPc73nqje7CubUikSiWhpHq1WS4nH3j/yMCYebO7/SrLBuA8P8nDNz89HZmamaM2aNU8//vjjS2bOnJkzUGp3DQgJPHPmzHs3b97c6XA4xMFIXX/SDvBPHm5YhXyPDZOQxAWXywWn0wmHwwGbzQabzQar1Qqj0YjOzk4YDAaYTCZYrVY4nU46UPuKvP4gJK2DlejkvjidTroRAjudThgMBsTExFApzXr0WceXP+cWN4uLdYZptVrcddddcLlcWatXrzZ9/PHHY/vqXkYSl70Ezs3N3b13795ZgK+jyh9ZybnBkhbgD604nU76SiQvGXTca7DtYR8uhOh2u51+h+upJb/X38DeM5fLRR9c7Ku/kBN58DmdTrS3tyM5ObmLN5+VwEIbcW6RV9I2ct/Y8TBv3jyUl5crV61adfzvf//7Lx9++OG/9vJtiyguawLr9XrjyZMnqaMqkH0ZKmkB4ZgoeX/q1CmsXLmSpv4BgEwmg1KpRHR0NGJjY6HX6xEfH4/o6GgoFApERUVBqVRCpVLRNrKZXITUBOQ4kTB9CZIaSZIq2NI57DmsF5qdB8xN6ACApqYmOJ1ODB8+nBKYqMqAb5orq+Ww/ycbZwbg0y72d8RiMfLy8pCSkiL6/PPP33rppZeuf+655+b31v2LNPqfrhYEioqKFDt27LAQlZlL2mA8tgSBbD72PTf3NyYmBklJSdBqtXA4HFQiW61W2O12mEwmmEwmGAwG+r2YmBgkJiYiMTERSUlJSE1NRUZGBrKzs6HT6Wh1D7FY7KMSsg8d1lnT0yB2Ppl5xSUrSyh2A0CdU3a7na4IYTQa0d7ejo6ODnpvqqqqsGvXLvz9739HXl4ejQeTLC3yUOOSn63uwbaBHGMfMOSBQ/pB3n/22WdISkqqmj179ujL0S6+7Ah8ww035HzzzTen2CdusJIXCOyk8pd5JJPJ4HK5MG7cOMybNw+zZ8+GRqOhBCMDhdh1xP4lVSdaW1vR0NCAuro6NDY2oqmpCU1NTWhtbYVSqUR6ejoyMjKQk5ODgoICpKWlIT4+Hkql0kcCs6ohCatESs32R1jyGSEMebVarTCbzTCbzejo6MDZs2dRVVWFhoYGdHR0oKmpCZ2dnTAajbDZbPQ/ImEikehSRtuoUaPwyCOPYNq0aVCpVFCr1QBAvdLcyRBCJCb7fJoC2y+y1MzWrVvR0dFhuOmmmzKWLFnSFpEb2Uu4rAg8Z86cB3bt2vX/Afz2biDJSxAseckrIejVV1+Nn/70pxgzZgzi4uLoACQeZqGcYK5K6fF4YLPZYLFYYLFYYDAYUFZWhvLyclRXV6O6uhpNTU1ISUlBXl4epkyZgmnTpiEpKQk6nY5KYOKtBX5U28NRsclkATK4SR9YIjidTipRDQYDOjs7cfr0aRw/fhxVVVWora1FY2MjjEYjJSdbdYNVgwH+aZVE21i8eDGWLl2K5ORk2ieRSASlUilIYtbu9kdi9pXt84EDB3D8+HHHokWLJt1zzz2XzVzjy4bAkyZN+r8ffvjhUSA4e5cNFfkjr7/kfWKLzZo1C7fffjuuuOIKupAYIU+oHmOWyIQsrPQwGAwwGAyor6/H3r17UVpaiuPHj8PpdGLs2LGYNGkSrr/+eqSnp0Oj0fhMAAAuPWyIxPYHj8dD1X7W3mYHNqlb1d7ejtraWhQXF6O8vByVlZW4cOECzV8mHvRgwP5f7D67yeVyjB49Gv/zP/+D8ePHQ6VSUf+CQqGgNi+f55+1t/lUaK4kJlLY5XKhvLwc3333nWfp0qVFy5cv3xrSH9tHuCwIPGHChI+OHDlyJ9CVvP7CQkBwKjNXXSbe0cLCQixbtgwTJ06EVquFSqXyWVxMoVDQAcV+n7zyzY9lBxkX7GAjBDIajWhpacGhQ4fw/fff48CBAzCZTJg0aRKuvfZazJ49m0oqQlziyVapVD5EJqmfZMASEFWfDObW1lZUV1dj3759OH78OE6cOIGWlhbI5XL6sOku2P9LiMQ6nQ5PPPEErr76aprkAYBqPqQdXBILqdKExFxpzPa9uroa33zzjXfZsmVL7r333i+63dEeRr8n8Lhx474+fvz4TwFh8gaTvcTC32wbqVQKvV6PBx98EHPnzkVsbCwUCgVUKhW1g4mTpbvgOn+45GBjyS6XCzabDRcvXsR3332HnTt34ocffoBOp8O1116LxYsXIzs7G2q1mj5YAFB1mwxQ0k+y73A4YLFY0NTUhNLSUuzduxeHDx9GTU0NtfkjQVghcP8/9j1Rqe+55x4sXbqU1t4m/SIVPchD0h+ByTGWvOzGSuT6+np8+eWX3sWLFz/w4IMP/qvHOh8B9GsCjxkzZt+pU6emA/zkDRQmAvglL184SCy+lJNbVFSEe+65BxkZGVSqkWQCojr3JFgPKlc1dTqdsNvtcLlcMBgMOHfuHNatW4dNmzbBYrHgJz/5CZYsWYKxY8dCq9V2aS+xvZ1OJ2w2GxobG/HDDz9gx44d2L9/P60uQiZo9CZYnwbgu3KFVCrF9ddfjxUrViApKQkajYZqGWQuMblPfLFovo1LZNYedrlcaGxsxGeffea9+eabf/Poo4/+qddvSJDotwTOzc3dffLkyVmA7xRArtTl2rr+VGahOa1SqRQJCQl46KGHMHfuXERHR0Oj0VAPKWuD9TbY7CWi9rKqsM1mQ11dHb766it88803aG5uxrx583D33XcjNzeXkpioyc3NzSgtLcXWrVuxd+9etLS00Moi/QFC/69MJsP06dPx5JNPYsSIET4klsvlAcNMfFKYK4nJPSavLS0t+Pjjj7Fo0aInHn300b/09b3hQ78kMKs2c1MihRxWgPDEg0Ax3WuvvRYPP/ww0tLSqLoMACqVCkqlMmRHVU+B2GsOh4NKHKJa22w2XLhwARs2bMBnn30Gs9mMW265Bbfeeivi4+NRX1+PjRs3YsuWLTh16hSkUmm/IS0f2P+c7MvlcowbNw6/+93vMHr0aLqUDUmiEUoW4caJWXOF9bL7IbH3tttuu++BBx54v49vSxf0j5HJYMKECauPHDlyK9BV8gbjaQ5FZZZIJFi+fDkWL14MvV6PqKgomhEVFRVFw0P9EUSdJiR0u9001/rcuXP46KOPsG7dOiQnJyMtLQ3FxcWwWCw0vfFyAJ99rFAokJ6ejhdffBF5eXlUEpO6WkKSmCUvCW9x1WohEjc0NODzzz/33nbbbbfdf//9n/f1fWHRr0bopEmT/lJSUnIf4J+87D4QGnm93kuFx2NjY/H000/jxhtvRGxsLKKjoyESiaBWq+mTvT+DqI5sggPZ1+l0mDp1KqZMmYL9+/fjwIEDsNvtPeqM6ilwowTEM//DDz8gLy8PsbGxPrFvNmsN8J1s4i86wec3Ia9qtRrDhw8XrVmz5ubf/e53P6xfv/5MD3U3ZPQbAs+dO/fW77///k+Ab3WLQKEiPscVIFwlQiqVIjc3Fy+++CJmzJgBrVYLtVoNkUgErVbb406qSIPNxgIu9ZN4oRMTE+FwOLBv377LkrwsCAGBSyS2WCwoKSnB+PHjfUhM7GK+MSH0oGcJzj2XQKvVIi4uTvTVV1/d+uyzz36xbt26frG+cb8g8A033JCzZcuWnYCv7cNWuQgU5+UDm1EEXJJac+fOxTPPPIPs7Gw6/5RMN+vPKnMgEEcPCf2IxZfmw1osFnzxRb8PZwYFVhp7PB4YjUYcOXIEBQUFiImJoSRmbWc+Scs3ZoQkMTtzSqfTQaFQiLZs2fLAq6+++s7atWv7fF3jPh+xRUVFik2bNjWwNZKCifUS+JO8rOolFovx85//HL/4xS+QkpKC6OhoiMViKJXKy0JlDhbknrGx4//85z/92mEVLjweDwwGA44ePYqCggI6EcTj8XSZAELgj8iBTDGxWIyEhARYrVbJ3r17H33xxRf/sHbt2j51KPQ5gWtqapxut1tEVJ9gsqwI+DKgyHtuRYi77roL999/P509JBaLERUVBZVK1W+8zJECCTORiQZbtmxBe3t7XzcromAlcUdHB06fPo0pU6YgKioKcrkcbre7S+WTQFKYfCb0nlwzNTUVdXV18sbGxtsOHjz4do90MEj0KYH1er3BbDYrCEH9Oa1CJS+bz/zII49g2bJliIuLQ1RUFEQiES2gNhAhEolgs9noZPn9+/ejtrb2svE+Bws2TbWlpQUXL15EYWEhLXJHSOzP9uWDkARm719mZib27t0bd/vtt0/57rvvPo1gt0JCnxE4Nzd3d11dXTbrVearh8wX5+Ujr1Co6Fe/+hWWLFkCvV4PtVoNsVhMbd+BCpFIRNMm3W43SkpKcOrUqS5zeQcSPB4PampqYLVakZ+fT/0BXBIDwdcb86dii0QiXHHFFVi7dm32b37zm/YNGzb0yfrFfULgmTNn3ltSUrIC6JqowSWuvyQNIfJ6vV4qeZcsWYLY2Fha/UKr1fZ5VYveAJnpRDK1du3addl7ov2B/O8nT56kCR8kl5pEH/yFiri/5W+fPZaWlobPP/98/nPPPbe2LzzTve65KSoqit67d+97gP+ZRYGemP7IKxaL8cADD+DWW2+FTqeDUqmERCK57D3NoYD0UyqVYvTo0T6zjwYqSKbaP/7xD2zYsAEWi8Un55lrkvGNP74VNUikgq+4XmJiIubMmSP68ssvD69Zs6bXB1evX7C2ttbCdVpxVWe++G6gcBFL3nvuuQd33HEHYmNjoVarBx15AVD7l3iiv/jiiwHpieaCPNAPHz6MvLw8JCUl0WQXbsFBvlfynpv4wZeOS85NSEjAhQsXpBcvXlxaXFzcq06tXpXAGRkZp7h1rPwlZgSTpMEl77Jly3DnnXf62LwajWbAhImCBekvSQtNSkrq4xb1HshsrZUrV6Kqqgpms5l65lli8k2cECpEz13nibvWU1FRESoqKka99dZbL/dmX3ttVF9zzTWLqqurc4DAqrM/Nz8Bl7wSiQTXX3897r33XsTFxfk4rAaT5CUgfZZIJFCr1UhNTR1w4TJ/cDgcOHfuHH7/+9+jqakJVuulnAu2fK9Q3gFLXKIpchdk41OpFy9ejC+++OK3H3zwQXZv9bPXRnZNTU05kZJC8V5uuChYySuVSjFp0iQ8+eSTSExMpHFeUnBuMILriT548CDOnDkzoD3RXLjdbho+y8/Pp4XegR8fcEJZWf5Cbnz+F4AWGRAdPHjwrhMnTrwe0c4IoFcksF6vN7JVJLlhomClLtA1SUMsFiMlJQW/+c1vkJycTCs2DGbyErAPy9TU1L5uTp/A5XLhww8/xJYtW+hsLLZ6KOBfGvOtc8UnjclWWFgIr9cb/dJLL23ojf71OIGnTZu2kl0lMJDK7E/6sk9F8kCIiYnBs88+i6ysLDoFUK1WD3ryAj9KGbFYjIyMjEHhxOKD2+3GH//4Rxw7dgxmsxnAj2E2dvyxY5O7mqW/jZCZ1OpetGgRNm/efP177703s6f71uMqdH19/bcA//TAYFRnrirDxjLlcjmeeeYZzJo1CxqNhpZWVSqVPd2tywJs+VSbzYbPPvusr5vUJyAOrOrqasycOZNWKfF4flxgLVjtL5gkIpLpt3PnzltPnz7doysi9qgETkhIaCMd4ou9hRIu4stvXrFiBa655hqo1WqaeUOqaQzB15FFVn0YrHA6nTh06BDee+89WmDe6/X6xIf5JDHXqcVVpblSmJwzfvx4yGQy9auvvrq6J/vVYwQuKiq6t7m5ORYITnXmg79w0c9+9jPceOONdJ0hqVRK7d8hXAIJJYnFYqhUqkEVSuKD2+3Ghx9+iM2bN8NqtfrUyuLLuw9kF7NqtFgs7rJK4s9//nNs3Ljxlp70SveYCl1TU1NCFqjyly4ZSPryeZxzcnLw1FNPYdiwYdTuHYyx3kAQcSY17Nu3DzU1NQNuUkOoOHr0KGbMmIHY2FgfVRrwP1MJEE6zJJMq2AkWYrEYXq9XdOzYsaVlZWV/6Im+9MiInzVr1hmypIaQ6gwIV5HkOqzIMeBSobknnngCqampPjOLhsjbFex9VyqVSE5OHvTOPY/Hg7a2Nrz55ptoa2uDzWYDALoEDNB1zWN/nmkhRxfxSk+bNg0NDQ1x77zzzq97oj8RH/W/+tWvVMXFxaOAH0uEssXQSVI5S1h2QWY26YIrfUUiER5//HEUFBRQ0qpUqkE/KP2BHWwjRozo6+b0CzidTnz77bf46quvYLFY6NxpbmhJyB7my9riEpd9X1RUhK+++qpHnFkRH/mbN282kJIuOp0OSUlJGD58OBITE6HX6xETE0NJR3JULRYLzGYzDAYDXcGvoaEBLS0t1D6x2+1YsmQJrr/+ekRFRVFbY8jj7B/sgBsxYsSgDSVx4fF48Pbbb6OgoACFhYWQSqW0PjTwo9+Gu+7wf9VinwxAVm0mr2TVCKlUivT0dMTHx8tefvnl//e73/3uxkj2I6IEfuWVV676v//7P+n8+fPJIsrQarV0YWsigdnZHeyTjGTA2Gw22O12GAwGnDx5Ejt37sTBgwexcOFCaDQaulrCkNMqMMjAE4lEQxKYgdfrhdlsxp/+9Ce8+eab8HovFQMkY5Etv8s1BVkTj9i6ZBwTArMklkgkmD9/Pt59990b1qxZk7BkyZKITTuMKIEvXLiw6ZZbbkF+fj6Nx5IKiUSNZrNWiJpBOg/4FhLzeDzIycmB2+3GgQMH6O+IRKIui4oNgR+s5NBoNNBoNDAajX3cqv4Bp9OJ4uJivPPOO1iyZAkSExPp8q3sGCXhJuDHECYhMktcMmbJwmtut5s+ELRaLfLy8kT79u3bDSA3Un2ImA28bdu2BTU1NYrCwkJoNBparpWQmCWzSqWiqx6QY6Q0KiG6SqWiExE0Gg0sFgt9sgHBV1UY7GBjwSqVCnFxcX3cov4Fj8eDzz77DIsXL8b999+P559/HuvWrUNlZSVaWlpgMBhgMpmoncyu5kAytrjxYm7smDwIrr32Whw8eHDMBx98MCZS7Y+YBN64ceOns2bN8pG8ZKU8kmLGnQzNjaOxqrTNZqPlUTUaDdxuN0wmU5fslyH4BzcWnJycjHPnzvVto/oRJBIJXnnlFVgsFpSWlqK8vBxff/01YmJiMH78eBQWFmLmzJlISkqCSqXy0RrZxdD5PNWE8GSMu91uTJ06FYcPH94CIC0S7Y8IgVetWjX1m2++iZ49ezZdCIwlLdfFHiidUiwWU6cCAERFRcHr9cJoNA4ROESQe0okcGJiIl2Ue7BDJpPh+uuvx3XXXYeoqCjccsst6CD1MPcAACAASURBVOzsRH19PXbv3o3S0lL885//xAcffIAJEyZgxowZmDJlCuLj4wVVbEJUlsSsNJ4xYwb+8pe/jFy3bt3shQsX7u5uHyJC4IMHD345e/ZsHxuXVR2EyBooQ4uco9VqaSFvgiECBw9yf6VSKZKSkoZi5rj0YNNoNLjvvvvoapQejwfR0dEYNmwYxo8fD6PRiIsXL2LXrl0oLi7GX/7yF+j1esyYMQPXXHMN0tPTaSIRIStJzeSq0UQSi8ViTJkyBdu2bdsEoNte2G4TeNWqVVPXr1+fUlRUxEtYocA3l7h8+8TOlUgurT43JIHDA3tvU1JSBtWcYCGIxWIsX74cOTk5tPgD0fyUSiU8Hg+ioqKg1+uRnZ2NRYsWoa6uDps3b8b333+PDRs2ID8/H0VFRRg/fjx0Op2P1GVVa6lUSh1aIpEIkydPxhtvvKFeu3btPYsXL/6gO/3oNoEPHz782cyZM31ugD912V8qJdB1OqFEcqmomFqthsFgoE6sIQIHD4nk0vq/YrEYaWlpg6LAnT+Q9bFuuukmmpNA8hLY+cJisZguW6pWqxEXF4fc3Fzcdttt2L9/P7Zt24ZXXnkFubm5uOaaazB16lTExMRQbUckEtHxyvoinE4nMjMz8frrr/8LQLcI3C1davXq1Snnz59Py8rKCkr6Ctm+fIQmbnpyMzQaDdra2gDA5wk3hMBgB09ycvKgLDHExcMPP0wdUyKRCHK5nPoK5HI5jZIQQaRUKqHVahETE4O0tDTcdNNNeOWVV/D8889Do9Hgb3/7G1566SVs27YNra2tsFgsPumZwCWh5HK56BKwR44cES9fvvya7vSjWxK4vLz8PxMnThTxuc6DmcDgb2YSuy+Xy6HRaNDR0eETQB9CcGAJrFQqER0dPeCWWgkWMpkMP/3pTzFz5kxaK5zkFnAhFotptiCZWw2ALskjl8tx9dVXY9KkSTh69Ci++uorvP3228jNzcVPf/pTjBs3ji4QTwSS0+nE999/j6NHj8Lj8WDHjh1b0A0ehi2B16xZIz958uSUvLw8SlziXg9F+goRma0mIZPJoNVqYTab4XQ6hyRwiOASODY2to9b1DcQiS5VcLnvvvug1WqhUCjo+AoEIpmVSiUlvFqtRnR0NOLi4jBjxgz89re/xZNPPgm324033ngD7777LqqqqmCxWOhi7GfOnMH69evpA6OmpkZy9913h50PHDbzz507tyo9PV1M7AeuBA4kfYO1gckNjoqKgtFoHCJwGOASODExEVVVVX3cqt6HSCTCQw89hOzsbDqTLZj1oEl2IIFMJvOJAxNpLJPJMHfuXFxxxRXYvn071q1bh9LSUixYsAAzZsyA1WrFmjVrqCQnv7t79+4LAPTh9ClsApeWlt6waNEiXokrZNsGo0aTjrGvRIWura2Fw+GgbSAxtiH4B3v/FQoFjWMOJmeWTCbDlClT8LOf/czHcRWKP4Ado0SwSCQSWqqWFJaQyWS4+eabUVhYiC+++AKrV69GWVkZoqOjUVtb61NAwOv1orq6OmyVKKzR/+GHHy4Qi8Uq8iQiUpdVf0MhLnuDfBrHPBhiY2NhNBrhcDhoGGRICgcPci/lcjn0ev2gc2TJ5XI89thjSEhIoI6rUFanZMcmtzYWIS0hNFGts7Ky8MADD+Cxxx5Dc3Mzdu7c6UNe8hterxeTJ09+LZx+hUXgo0eP/nXKlCm8dq5QzJebwBFI+gK+8cuEhAS0t7fDbrcPObLCABtXHzZs2KB6+EmlUtx5552YMGECdVyFu7SsULIRGe9kRhMx++Lj43HVVVfhscceg1ar5f0eAJSVlf1vOO0JmcBr1qyR19bWZqSlpQk6rfjIypKWvRHsjenSOPGPU+GSk5PR0dEBq9VKiTtE4ODB/g/Dhg0bNKmUUqkU2dnZuP3226mtShyuoYJPCrPjmdxjtjgFmZgzatQoTJw4kTrAuILLbrdLioqKokNtU8gErqmp+WdaWlqX0FEgW5jPgUU6zid9ga4EdrlcaGpqGiJwGGBtt+HDhw8qCfzYY48hOTkZarUaALq9sHugUCgZ43K5nL4qlUrMnDmTmn98JC4rKzsWaltCJvDJkycXTpo0KeiEjFBsXi7YQafX66FQKNDQ0DCkQncDIpGIFnMb6JDJZLjppptAJtmQUFB3HJ98YzaQWk1s5OzsbKSlpfFyBAAuXrw4MtT2hNSTNWvWJHR2duqio6N9GigUGgqGzFxS+zRO/OMKewqFArGxsWhoaPApXTKEwHA6ndRT6vF4aFx9IIOYCvfff79PzDdSDy6uIBLaiMqsUqkQGxuLqVOn+tSFY8e/x+PBDTfckBNSP0M5ubq6+m9jxowRVJ2BrjWg/UlloRtCG8eo0EqlEvHx8VQCDxE4ONjtdphMJng8HphMJphMJuzevZveOzKwBxpEoksFEDMzM6FWq4PyOgdrVgRLXjLuSZRGLpfjyiuv5CUw+c3i4uJdofQzJEv+9OnT1xUVFQVUn0OJ9/pTo7nVJBISEtDY2Air1UpXIByCMKxWK2w2GyVva2srPvjgA/zzn/9EUVERZs2ahZMnT+LMmTM4ffo0mpqa6P92OTu5yDzfefPm+cRmeyN0xufYkkgkcLlcUCgUSE5ORn5+Pg4dOtQlpOT1etHY2BhS9f2gCfzpp58mrV27VksKyvGRly9xo7u2MPlNtVqNxMRElJeXw2q1wu12QyaT0WlaQ/gRpGCb0+mEy+WCyWTChQsX8Oabb2L9+vW45557cP/99yM2NhYLFy6ExWJBZ2cnmpubUVpairKyMhw/fhzV1dW08iKbQNOfIRaLERcXh4ceegjR0dFhxXyDARmz3AXSyGd89rBcLkdUVBSmT5+O4uJiXj54vV4sXLgwb926dUE5tIImcH19/Z+zs7MFbd9AMd5ADishsL89fPhw7Ny5k9bHAuBTVX8IoNLW7XbD4XDAbDbj9OnTePXVV1FaWoqnnnoKixYtgk6ng0ajgdfrhVarhV6vx8iRI5Gfnw+n04mOjg60tLSgpKSEkrqqqopKiv46p5ioziRdEkDYpYdD8dQHUqVJpQ6ZTIbc3FzExcWhubm5y7lerxeHDh3aDGB4MNcNmsCVlZXz2Hm/AAQlbijOq0DEJuqHWCzGyJEj0dLSQm06YMgTzYLUDfN4PLDZbDCbzTh48CBefvllGAwGvPrqq/jJT34CjUZDJRO7rg8ASk6tVouUlBTk5ubilltuQXt7Oy5evIj9+/fj8OHDKC0tRWtrK2QyWb+RzjKZDPPmzUNRURFNlyRlnXoqbMYnidnj5BgReHK5HHFxccjPz8euXbtgt9v51OjkYK8fNIFbWlr0xPvMNkjI5uWL9YYjiVlPdEZGBrxeL2prazFu3DgA6LeSoLfhdDphNpvh8XhgsVhgMpmwdetWvPbaa9Dr9fjzn/8MUjGUOK40Go1PCVRS2FwkEtFEB0JojUaD5ORkjB8/HlarFS0tLaioqMCePXtw8OBBVFZWQiqVwul09kmMWSS6NNPooYceQmxsbLczrvjA7RchHCEvW0eaT6UmGVpyuRzTp0/Ht99+y8sNt9sdNEmCIvC7775778GDB8VcwgZr87Id5nvvD+y0Qp1Oh4SEBFRUVOC6664jnQ22rwMWNpsNVquV2r4dHR1Ys2YN3nzzTUycOBHPPPMMVSmJM4ddDI78j1wpTNYWFovFPoTWaDTQ6XRIS0vD3Llz0dbWhpqaGlqA//jx4/Q3ektDEolEePTRRzFmzBi6xKy/2uE98ZAJpEaTV4VCgfT0dAwfPhznz5/ndWbl5+d/XFpauizQNYMi8NmzZx/Pzc3tVvIG92lE3gcC64nWaDQYPnw4qqurfWrzDmaQuaZEfW5ubsa7776LVatW4cYbb8Qvf/lLJCcnU2lLcnT93TcigUl9KFJ1kRBaJBJRsrtcLmg0GgwbNgyFhYXo6OjAxYsXsWPHDuzduxelpaX0vJ6SzDKZDFdffTVuuOEGqFQqnyU+ewP+1Gh2I7WxZDIZ9Ho9CgoK0NDQ0CU7y+v1orKycjGAyBC4rq4u58orrwxIWL5Gc4+FClZlJwSur6+HyWSCTqfzKd05mMD1NJvNZtTW1uJPf/oTtm3bhocffhh33XUX4uLioNFoIBJdiqWHswA6ISxZQJ1UXyRkZgvBqdVqJCQkIDc3F3fccQfq6uoomY8dOwaRKLIhKrFYjNjYWDz22GPdUp3DebiwqjN3hpIQD4g2I5PJMG3aNGzcuJFXqFkslqAyTgISeM2aNfJPPvlE6S/WK0Rs0iA+2yEUEJLKZDKkp6fjhx9+oJ5WALQA2WCB1+uFyWSiJDIajTh58iRefvllnD59Gs8++ywWLlxIy6UCoEX2IwESEiHlZkg7iLrNVnWMi4vDuHHjcNddd6GqqgqbNm3Cd999h5qaGmozdxePP/44xowZ45OwwY6x3rTJ/anQ7EJpMpkMqampyMjIwJkzZ7oIOK/Xi6KiIsWmTZvs/q4XkMBtbW0PJicnU4KS9WAC2b3BSOVgQTzREokEOTk5aGxsRFtbmw+BgymLMhDAhomIp3n//v146aWXYLfb8frrr2Pu3LnQaDR0QGs0mh5TJ1npDFxSlR0OByUzW9UxPj4eBQUFuO+++1BaWorNmzdj165d1PkWqr0sk8lw3XXXYcGCBVCr1RFVnUMlvUj0YwVK7tjms4WVSiViYmJwxRVXoKamBjabrYsdXFtb+wWAn/m7bsCe1tXVLRs1ahRtSDB2L9tw1hsdLlhHVnZ2NlQqFUpLS5Gfnw8Ag6ayBBsmslqtMJlM2L59O1auXInExES8/vrrmDBhApW2rKe5t0BsZ+BHMjscDrrkjsvlglqtRnJyMubMmYMLFy5gx44d2Lx5M8rKymgJ3EAQi8WIj4/HI4884qM6BxPzjbREJoQL1hZmcykKCwvx9ddfdznnvwS+NtC1AxK4oaEhZ+LEiT7qMrdRfI3kI3O4IANCKpVCp9MhIyMD5eXlg8qRRTKqCHkNBgPWrVuH119/HePGjcPzzz+PUaNGUWlLSvH25b0h7VCr1XA6nTReLJVKoVKpEBUVBa1Wi4yMDNx00004ceIE1q9fj2+//Zb2VUgqi0Qi/PKXv8To0aPpNMGeXCs6nKQO8p4bXiIapUwmw/Dhw5GcnIzz5893+R2z2RywQwEJ3N7ermUn7gvZv/7UY9KJcKUxiTlLpVLExMQgIyMDZ8+ehcFgoCsYDmRHFsmoAkDDRKtXr8Zbb72FuXPn4sknn8SIESPovZDL5VR97i8g6q1araZSmajfrIo9ZcoU1NfXY+vWrfjmm29w6tQpOuDZ31qwYAHmz5/vs1h8uAkbkfoO3zF/Ulgul0On02Hs2LFobGz0CScBwSUp+R3xn3zySaFUKhVzL0y/zCON/dnB3E6FAjKvUi6XIycnBzU1NTAYDNQOHqhqtN1upzai0WhES0sL3n33Xfz5z3/GjTfeiOeeew4jR45EdHQ0LUAeKEzUlyBOJrLwOymerlQqodPpoNfrkZOTgwcffBDvvfce3nrrLcycOZMmQIhEIgwbNgyPPPIIdDodXexdyEHXFw4s8l7oONmIN3rChAm8E/0BYNasWbf6u6ZfCdzU1HTXyJEj/arPgZxTkRpIpIqiRCLBhAkT8MYbb6CqqgoZGRkALmUiDbRJ6uxsIqPRiKamJvz1r3/F2rVrcd999+G+++6DXq+nSRmR9DT3BsgsM5VKBYfDQdMKyRInSqUSw4YNw+zZs3Hq1Cn85z//wddff42ioiJkZmbSdFDyGgyCIXR3Sc/axFxecAWhXC5HZmYmYmNj0dLS0uW36urqXgDwmdC1/BK4sbFxZmpqqk9D+MjMNlyo0UDXan6hgNjBEokEI0aMwPDhw3HgwAHMnTvXp2r+QAE3QaO+vh6vv/46tm/fjieeeAJLly5FTEwMDRNFRUVd1g8wEpZyu92w2+1wOBw+BNfpdEhNTUVtbS0tlk76TtBT0jbc3+Xawew+4ZFcLkdMTAxGjx6N9vb2LiVnm5ubM/xdw68K3dramjZ8+PAuFw1XTY6UI0uv12Ps2LE4duwYDAYDXC4XzecdCDCZTLDb7XC5XDAajaisrMTTTz+NPXv24LnnnsMdd9yB2NhYqiprtdrLmrwsCGlZ9Zqo3MOGDcOkSZNw5MgRNDU1UaeY0MO7N6RtoN/zJ+BIUodCoUBOTg4vP6xWq98/1i+BDQZDNHFg8bm5AxGa+9TpDoj3jmQDFRQU4NSpU2hpaaFhh8t5EjrwY4IG8dgaDAaUlZXh17/+NSoqKvDKK6/gpptuQkxMDF2XVqvV9lrKYG9CJBLRdZxI/XGZTIarrroKBoMBxcXF9P/ube3LH+kDCS6uKg1cEkpjx471OR6sI8svgS0Wi9Sf3cs9ziVspMhLQOoLSaVSTJs2DRaLBaWlpTTP9nImMJsaSWYWHThwAL/+9a/R2dmJ3//+95g3bx6dpC4Wi6nXeaCDaBdSqRQjR47EuHHjsHfvXthsNlroPxjtq7cksj9HFtchTMZzXFwcUlJSQr6WIIFXrVp1tU6n421QIFuXq/tHCkTSyGQyJCcnIzs7G/v376d/Yk8mzPckuJLXaDRiz549ePrppyGXy/GnP/0Js2bNomqlVCoFmdo50MD3/5EaUnK5HLGxsZg4cSKOHDmC5uZmKn25BI4UWUM5R0jScsH1J8lkMkRHRyM7O7tLvSwAuPLKK38tdG3BEdDZ2XltQkKC30n6/lRkfx0Il2SkczKZDHFxcZg4cSJKSkp87KGOjg4YDAYfJ1B/JjWb1+xwOGjRuWeeeQZ6vR5//OMfMXHiRGg0GrqAVl8naPQmyH9H1jGSSqW4+uqr0dTUhKNHjwa0g/sCQnYwS0oCYgdLpVLk5OTwjtXGxsbbha4lSOD29vaJ8fHxPg3gNiIU0kYCRN0gtvDVV1+N2tpalJeXw+FwwGaz0WlvdrsdFosFBoOBl9T9ASx57XY7jEYjdu7ciWeeeQZJSUl47bXXkJubC61WS+OgA5m8/h60JNdaLpcjIyMDo0aNwr59++hsrEDaV29KZAKuJBX6jIzr7Oxsn0IZBJ2dnZlC1xD0frS3t2fk5OQIho2EyMsH4vDiHgtnIJIZLDKZDKNHj0ZWVhY2b96MrKwsxMTE+Dg9CNklEkmXOk7kprFbb4IreQl5n3vuOaSmpuLll19GTk4OdVYpFAqaMjhYwJKFNZ/i4uIwfvx4lJWVobW1laaPut3uHi2fE6iNwZzDJSfryIqOjkZSUhJqa2vpZ//1jUQJ/bbgqDUajXFkIWghG1gohZJrE0RSYhBHFcmBlsvlWLduHXbs2IGRI0ciKysLWVlZGDduHNLT06HVamlhb0JmQliu44tL6J6SdF6vF0ajkcY8jUYjduzYgRdeeAFpaWl4+eWXkZ2dTScihDuP93JCICKQBy5wicTTp0/Hl19+idraWqSkpEClUsHlcgX9IO7tEJMQcVkCq9VqjBgxAvX19T7CxuFwCHoqBXtrs9mi2dhiIIkbyKEVCSlstVqpumk2m7F69WqcOnUKwKXY6YkTJ1BRUQGxWAyHwwGVSoURI0Zg1KhRyMzMRH5+PjIzM6mkZsnMzqChN+e/xyNZ3YElr81mo7WrXnjhBYwaNQovv/wyMjMzBxV5gwXJxpPJZBg/fjz0ej327t2LSZMm+a2U2VcOLX+50dx9ksOempraRTD6u67gqHQ4HFLuBAQhnZ5vP9JqjMvlgs1mg9vthsViwb59+/Cvf/2ry5/GEtBqtaKiogJVVVUQi8VwOp3QaDTIzs5Gbm4uCgoKkJeXh5iYGMTExNAV5YiNzV6XVbnDLRJO1GZW8hLyjhkzBi+++CIyMzOph3mwkDfYiQGsBI6Pj8e4ceNw9OhRGAwG6hsIprhDT6rY3LHPJ3XJe64mKxaLMWrUqJA86oIEdrvdIqEqe9zj3PdC4JO4wUphi8VCY6W1tbX4/e9/H7TnkT3PaDSipKQEx48fx+rVqyGVSpGeno7c3FyMGzcOEydORFJSEvR6PQ3ZENISldtqtVJvOPksmJCO2Wz2sXk3b96MF198EVdccQVeeuklqvIPJvIGCyJMiNak0WgwYcIEvP/++2htbUVCQgLkcjlcLpdPVlq4ZI2ERBaJRDQ1knucDxKJBMOGDYNSqYTJZAqqnYIE5qYmCnmi+Rrtr5HhgEhem80Gg8GAv//976ipqelW6ICEHxwOByoqKlBdXY0NGzbA4/EgJSUF+fn5mDBhAqZMmYLExETo9XofdZoQmp3jyq7SzgWbpGEymbBjxw689NJLGD9+PLV9yaQElUrVo3Nb+xOClb4EpEC6RCLBrFmz8Pbbb+Pw4cPIysoCEF6d8N5QsYlk5osZk4c/sYPj4uJgMpmC4hAvgXfv3p38xhtvdLkQu8/XEO45fAhVChPiktfdu3fjyy+/jHjcj3VmnT9/Hg0NDdiyZQsAICsrC/n5+Zg8eTLy8/MRFxdHC+qRKY7AJUlvtVpp2h8hO8kYIuTdu3cvVq5ciVGjRuH5559HWloalbxD5PV/TCqVwuFw0GSeUaNG4fDhw/j5z38eVHGHvsiPZuEvJEs0r4SEBNTV1VHp7fV68cILL8S88MILHdzf4yWw0WhcQEIWbAiJ24hgpG2whBUiMVGdrVYr6uvr8fbbb/dKmIB9QJw+fRrV1dX44osvoFQqMXbsWIwfPx7Tp09HdnY24uPjoVQqKWnJJHWypCf5PZPJhJKSErz44otISEjAypUrkZ6ePiglb7ggcVKZTIaYmBjk5ubi5MmTaG9vp6mlREL3JFm789vsOGfPIZP84+LiuhQxsFgscwH8P+5v8RLYarWO41t2Mhg7N5JwOBzUZrRYLPj0009x9uzZPknEIKqyxWLB4cOHUVZWhg8++AAJCQkoLCzE9OnTMWXKFCQkJNBYNNlEIhHMZjMqKyvx7LPPQi6XU68z8TYPNvKGI32BHwUKcTROmDABGzduRHNzM5KTk6FUKgUXvOsrsgbiDOvMEovFSExM7HKO3W4fw/ddXgJ7PB4dd2J4IE8zaYTQnxCqFCZSl7weOXIE//73v/tFyhxr+zY1NWHbtm3YunUr5HI5CgoKMGnSJMyZMwepqanQ6/WQSCRoaGjAq6++CoPBgDfeeAPjx4/3CRUNJvJ2F2yB9MLCQojFYhw+fBhjx46l4aS+dF7xIRhTk3AoOTm5i5Byu90j+H6Xl8Ber1cRbkZLqDYxz7UhEolgt9vpIl3t7e34xz/+0W8W0eKCPFSsVisOHjyIH374AX/729+QlZWFyZMn48orr8TevXtRUlKClStXYvLkyTR7SKFQDDpvc7jSlxwj0lUqlSI+Ph7Z2dk4cuQIbr31Vrq2E1dAhOosC+WcSH5PSAK73W7eecG8BLbZbIkk5haOytwdKUyOk1IyNpsNe/bswZ49ey6LlQjZSooVFRU4d+4cPvnkE2g0Gjz++OOYP3++Tw3jwZweGe4xbpHDMWPG4OjRo2hra6PmSzipun1tD5N9MjZYbdPhcKTyfV8weCmUqODvxrKfdeePstlslMTNzc14//33e9X2jiSI1mAymVBQUAC5XA6lUgmRSETXrx0siKTzkc2imzhxIqqrq32KO7AqaLjSlw897UAViUQ0K4uFRCLh5SrvQZvNFtcDbQsKROqSsNGWLVtw7NixfjODKFxIJBJUVlb67F+uD6VIItwHPatG5+XlQSwWo6yszGe1jp5oW099jx0LZK0pFk6nU8/3PUEJzCdV/TUwUsdI6MVms+HChQv48MMPhZp4WUEqleL06dM0QeZyMAciiUhKQcCXwHq9HhkZGTh27Bgt9k/ub3fGZU9+T+gc4mHn+kW8Xi/v056XwEqlsq0nVQWhG0G8uySGumnTJhrQvtzhdDpx7tw5WCwWaif3Rjy7PyCUfgZLEuKxlUgk0Ol0yMrKQmVlJS1y6PV6uzVuelr6+rOJyfRRFkqlspPvfF4Cu91uCVFB2PSvSDaUD8T2tVqtaGpqwn/+85/LXnUm8Hg8qKqqojORgMGxOLnQ/99djY3ETWUyGRQKBcaOHYuqqip0dHQIltkJ5RrBoCe/x334CM2G4yWwXC5vJs6AUFVpPgTzXSJ9vd5LEwZ2796Ns2fPDigp1dDQQCUE0L/KwPQEukveQGAXf584cSI6OjpQVVVFiRuuBO5NFZsrIMl7boFGpVJ5ge/7/J4tsdhJbFGWwIEaGKq0Zo87nU7qeW5ra8PatWt5v3M5w+VyobKyclBI4FDIG8pvsMdYOzg5ORnDhg1DaWkpTeTgExLdaU93vudPEHLP4RsXcoHC37wEFolEJi6BhRrSnRASe5xIX4fDgcOHD+PIkSMDboDL5XKcOHGC2sADrX8EoZI3XHWanQyv1WqRlpaG6upqWhQ/UjOTukPyYAjLnkMmxNhsNp9ztVpt13VXIEzgYySRgnUG9IQzAgCt60sav379+gFZ79jlcuHcuXM0y2wgErinyMsHMhFeIpFAo9Fg5MiRqK2tpUUTAo3dSErfUIkq9Jnb7UZzczNaW1sxduxYmitgNptL+H6bl8BarXY9mQXkzxFAXkN50vF1giQ72O121NfXY/fu3Zd1kXYhuN1unD17dsA6siJB3lB+2+v1+iyWPWrUKNTV1cFgMPgQN9Jhz+60198rEWIHDx5EQkIC7rjjDvz2t79FSkoKpk+fzmtT8hJ4wYIFNURC8KnQfOoyX4ODITZxWnk8HjidTmzbtq2L+jCQUFtbC4PB0GfLgvQUIkXeUEnESuG8vDx0dnairq6O3tdIhyC76+Di+pTYfafTiba2NpSXlyM3Nxd6vR5JSUlISEjA9ddfb+D7Xb91YFgVOhhnlVBDhc4BQGN2DocD7e3t2Lp164AZ1Hyw2+0+jqyB0NdwHTrd+R1yLlvNIikpCfHx8SgvHs0/bgAAIABJREFUL6fE7U4oqbvSN9jvs57nkydPorm5GZMnT6a58v5mqvnNxGLjaSxp2fIgbGOFnnb+bg65BiltU1ZWFvaNuxwgk8lQVlY2YBxZ/sjYXRVZ6DifJ1oikSA6Ohqpqamoqqqixd4jKYGDIXk4qjMAOuf90KFDyMjIQGpqKmQyGcxmMyQSiWAnBAlMnFhs1hDfxm2IkIrNB/KQ8Hg8cLlc+Pbbb2k1yIEKt9uNM2fOwGq1Uufd5frACkeShhOh8HeMnQyvVquRnJyMhoYGmvEW7vW7859wpzH6MznJ/+9wONDQ0IDy8nLk5+cjOjoaUqkUBoMBarVa0CEkSGC32+01Go3g2sJCTxwh3V6oI9zGd3R0oLi42KcMzUAEIbDBYLisHVl9QV4hkKmFCoUCKSkpaGhogNlspgSORF50qMeCuQ+sFup0OvH9999DIpFg0qRJVLPo6OhAQkKCWei3/KnQnosXL/pktXA9e6xk5mt0IHuYzUiqr6/HiRMnBDs9kFBfX4+Ojo7L0pEVjP8j1M+CPVeIMGwh9IyMDErg7mZkhQshicunvQKXbN/W1lYcOnQI+fn5SExMpKmT7e3tSEhIaBK6lj8Cu86fPw+73e5jD/ORNhh7h4/ExIHlcrmwZ8+eQTO9zuPxoLy8/LJzZIVD0FAJH87DgYwbUhjdYrHgwoUL9P4KtaE3jvkDaZfD4cCxY8dw8eJFzJgxgy4w4PF40NbWBr1eXyX0G4IEjoqK6iDzcMn0LK69FszTxV/Die1rMplQXFx8WaqS4UAmk+H48eP0nvb3fgf6T/taIrPrCyUkJECn0/kUP+wNCczXRjZ6I2RqkiVl9+3bh5ycHKSnp/tU1GxtbYVOpzskdF1BAsfFxW0/d+4cOjs7aZyWqzqzDRGyeYVuHit9Ojo6cOrUqQExbTAYOBwOVFZW0owh1jzpbwhEwkiSN1yJzEpglUqFxMREusJfOJGRcNskBD6ukP/cbrejqqoK5eXlmDp1KqKioqgj1+v1orm5GTExMRuEfluQwGvWrFlmMplw/vx5mqdMVD0uackr11vtr8MsgS9cuIDm5uaQbsrlDK/XS+eu9ldHVrhSN9zPuiORSSyYFEbX6/VobW31ETyBrhUpxxV5mHAdZ3y8IKnD27ZtQ2JiIiZMmECdV6TdVqsV99xzT+gSGLik6u3fv5+uLEBSvfjUZT4bl9t49hg7cEtKSnp9fd6+RlNTE5qbm/vl1MJg/RmhfBaOtA6WQKwEJgRua2sDm8/fm+DjArvPkrO6uhqHDx/GzJkzERcXB7lcTs9ra2tDbGys34Hhl8AqlQqHDx/GhQsXfKQwn83LVQ/4OsO+d7vdcDqdsNlsKC8v7/Wb3NeQSCQoLS31ceT1NYKRur1lC4eqThMvtFwu70Jg9rs9JX3Zfb5jXO3U6XTCbrdj+/bt0Gq1uPLKK6kQI+c3NDRg5MiRvCmUBH4JHBMT43W5XNi1axfsdjstd8NmZglJY6EgOnuex+OB0WjEmTNn+sUA7k2IxWKUl5fTGk59qUIHIiY5J5zv95Y6zS7TmZSUhPb2dlrhxV8be0pwBLqezWbD+fPnceDAAVx55ZWIj4/3ITAAXLx4ESNGjBD0QAMBCJySktLqdrtRXFyM+vp6Og2OLHlCsqiEbhJfAJ08fYBL6rPZbEZDQ0OA2zHw4HA4cOLECXR2dtIHYm8/xIIlbn+whQORj10CNzk5uYsE7u6Mue5IZO60XIfDQSuuSqVSzJ49my5RS87zeDyor69HUlLSbn9t9UvgtLS054FLT4vNmzfDbDbTuDBZKtNms8Fms8FqtcJut9N98t5qtcJqtcJiscBiscBqtfoQuKOjA0aj0V8zBiyqq6sD1nCKNPicKf7O687noX6vOxKZndyfmJgIp9OJjo4Ov/c00kQlr0KaKfBj2eTq6mrs3r0bc+fORXJyMshKKOwDp66uDrGxse/567dfAq9evfpvZGX7/fv3o6ysjK4sT8hIpDFxcLHvua9E77darXRO7NmzZwdNAgcXdrsdJ0+e7JWMrGBIG+x5/UGd5h5nx1BsbCyASzFUIdu3J1Rnf79JpLDD4YDZbMbXX38NtVqNq666iq4pzfqQLBYLpFKp99577/WbnhjQ9SuTyWh+8pdffonW1laMHDkSqamp0Gg00Gg0UKvVUCgUUCqVtGI+mWhN7BJiO9tsNlgsFnR0dKCyshJbt26la74ONsjlchw9ehQLFiygD7lIIhxbsjvn9KU6TUA80Wq1Gh0dHT7fIc6u7jrOgr0PfJLYZrOhoqIC33//PW6++WYkJSVBLpfTfABC4JqaGowaNcp49OhRv9cKSODo6GhXc3Oz1OVy4fz589i4cSMsFgtkMhni4+MRFxeH2NhYujymUqlEVFQUoqKiKFmJWm2z2dDS0oILFy6goaEBHo8HGo1mQFbfCAYOhwOnTp2CyWSiKxV6PJ4uy7oGi3CkSrDf6QnyRvI77FrVcrkcGo0GnZ2dPqRwOByQSCRUqAT63e5IaT7HLtE8169fj8TERMyaNQtSqbTL9FyPx4Nz585h9OjRxwNdJyCBR40aVdzc3Dyd/PiDDz4InU6HxsZGNDU1ob29HWazmdq2xC622+10HSC5XA6FQgGZTIYRI0Zg2rRpyMzMRHp6OsxmM+67775BaQd7vV5UVFSgo6MD8fHxkMvlcLlcXdbF8ff97lw7EueF+3mkJTKbZESmFra0tMBqtUIkEtFxCFzyNZAyPP4kcrBt8Hg8XUjIEpdonw6HAwcPHkRxcTEefPBBxMXFQaFQ+DiDyWtVVRWmTJnyQaD2BCRwTk7Ogv3797fTL0ilyMzMRG5urk/hOe5CxmzhbblcDqlUSotwS6VSevMsFgvmzZuH9evXD0pJ3Nraivr6eqSnpwNAFwJH0lbrTZW6N9Vpdk45SVNtbm7GRx99hObmZtx4443Iy8ujoRqlUgmpVEqJR0y9QNfzd4z9jE+FtlqtaGhowNq1a1FQUICpU6fSlEmWvGTr6OhAYmJi9wn84YcfdshkMlq32el0QiQSQaVSUeOb3Yj9S1QVQlaysZ8RLFq0COvWrQvUlAEJmUyGI0eOYNq0aXQw9hVpgz2/P9nCrKPUbDajrKwMzz33HOx2O9xuNzZv3owNGzYgPz8fP/vZz3D11VcjOTkZCoWCbiQOz0fkYNrNSnE+CUwct9988w2amprwwAMPQKvVUo2Llbwejwdnz55FSkqKfcmSJQHDEkEZW/Hx8R7SGDY9jTgFyDKPRNqSG0PUFrlcTslOziUxL4VCgdzcXMyYMWPQpVMCl+5peXk5HXCRqNDBF74I9jvdOSeYz0P9nr/jROp6PB6YzWbU1NRg5cqVaGxspCo1yYcuLS3FK6+8gltuuQWvvvoqjhw5gubmZnR0dMBisVAnEndxNH/gEpVPdSZhoxMnTmDjxo2YP38+srOzfcJGrO3r8XhQUVGBgoKCYwEbgCAJXFBQsI00ip09QxYjlkqllKSEyOxGSK1SqagtLJfLqcMhOjoaixYt6rczcnoSLpcLp06dCjsezOfpDOe7wZwX6Jxwvt8dwpPMQIvFgsbGRrz22msoKyvjNcWIHdrY2IhPP/0Ut956K5544gls3LgRdXV16OzshMlkopomN+PQX9u4JGbfm81mNDc3Y9WqVUhMTERRURHlCkta9r+oqKhAdnb27wVvDIOgCLxp06b5RDqyq+uxF+dLGif2BV+nAVAPnEKhwPTp0zF9+vRBKYXr6urQ0tLid2IDH1HDldTBfjdSUjmSn7HkBQCz2Yy2tja8++672L59e1ChOJKPsGvXLqxYsQLLly/HP/7xD5w+fRrt7e0wGAw+acP+JDJf/SvCBbvdDovFgnXr1uHMmTO4/fbbkZiYCIVC0YW4ZN9oNMLhcHjvv//+LwJ2BEESGACio6MhEomoqsc3P5jd/BXCI38OIatSqURsbCzuvvvuiNp/lwu8Xi+OHDni42eIBFG514gkccl54X7eHVuY3B+LxQKDwYD3338fH330UciZbOR3Tp48iTfffBO33HILXn75ZZSUlKClpQWdnZ00n5pon1wpS165E3jIVMGSkhJ89dVXuOGGGzBhwgTIZDJqM3MFocfjwYkTJ5CXlxf03NqgCZyRkWERiUQwmUw+UpdVqbkqgRCJ2c6TDimVSkyePBk/+clPBnxlSi7YmUmRWvw7nAdApAgeSGXuzmdEMlqtVhgMBqxZswZ/+9vfupUEQwjX1taGzz//HEuXLsWTTz6J3bt3o6GhAR0dHbBarV20Tm6b2fttsVhQU1OD9957D1lZWViwYAGUSiVkMhkvR1gCjx07VnACPxdBE7igoGAeABgMBtphbqkdIbWA+8dwpTDJntFqtbj77rvDTmS4XOFwOFBeXk7tYHJ/Q0F3JHakVeqe+IxoJsQpZDKZsH79erz++usRzSEneQxbt27F8uXL8dhjj2HdunWora1FZ2cnzGazT9yWbzObzWhpacG//vUvdHR04O6776YxXz4tleVRbW0tMjMznwy2vUGvIHbkyJG6qKioF6Kjo1FYWAilUknjvOzyFtwUSrZiIOA7a4QFcYpFR0ejubkZp0+fHlROLaPRiIULF9KEDuKx50OkVOpIntuTxGbJa7fbYTKZsGXLFjz//PN0ck2kQch18eJFbN68mRa2IJPuydhk1WGv91K8t7OzE59++im2b9+Ohx56CIWFhVCpVD5aKzuNlMwhKC0thVgsNrz00kvPBtvOkERdVlaWo6mpCU6ns0vuJled5lMRAH6VgxBfLpcjKioKy5cvR1JS0qCSxC6XC2VlZT6OLH/+g3DQEyp1d9Rp8nmgtrLkNRqN2LlzJ55//nnB4u2RBPkfTp48iddeew133XUX3n77bZpB91+nE4BLs/aMRiO2b9+OtWvX4uabb8asWbOgUqm6TBXkU5/LysowadKkkBIiQmJIYWHhfKPR6OPI4pKWPcZVFbhqByuFiUc6KioK6enpWLFixaCapSSVSlFSUuIzoysSCIf4kSAuOSec77MPeKKukuqNu3btwtNPP+2zAmFvgIzr8+fP45///CeWLVuGP/zhDzh69ChaW1vR0dEBk8mEnTt34p133sGcOXNw4403IioqikpsruOKVZ+dTidqamqQlZW1IpR2hbQI75EjR86lpqa+kJ6eTtPS2LRIf+pzIDWaK22Tk5NRU1ODc+fODQpV2u12QyQS4brrroNWq/XJagsF4UroSKrUkVCnWT8LS96nnnoq4DzfngI7th0OB86cOYMNGzagpqYGUVFRqKqqwltvvYUxY8bg0UcfpXYvK9i4G3lgHz58GDKZrPPFF198MaQ2hdqJqVOnNhw7doyqNXzSlvt08eeVZklMVGmlUgmdTodHHnmEhq8GAyorK9He3h50obtIqNc9oVKH+332M2KmEfLu3r0bTz31FK1g0hfgCiOn0wmHw4Fdu3bhiSeewB/+8AeMHDkSK1asQEJCApRKZRepyyUzeX/48GFMnjx5dahtCpnAWVlZVzQ0NHRpALvPzWLhbnzZJ4TMJKwUFRWF0aNH4/HHH/eZNDGQ4XA4cPz4cZ+KJUL38HK0hYP5rtfr9SndZDAYsGvXLjz55JM+2Wq9DVb6sguqAT+maxKP8/Dhw6FSqXinCfJtbW1taG5u9qanpz8WcrtC/cILL7zQNnHiRDvxEvPZwMHEhIGuAXByo4hqrlarsXDhQixatGhQxIaJHcw+ECPlYQ2XtL3pxCIOK0Jig8GA7du34ze/+Y2PZtIXYEkrZA4OHz4cKSkp1KTk4wTXJ+RyuXDo0CFcddVVZ4KZvMBFWG7eWbNmvVRSUtJFFQhm4z6NAHQhOHFoqVQqxMbG4pFHHkFubu6AJzFb6I4MZLPZTN+HgnCldbDnd1ed5n7u9f6YpGGz2dDZ+f+39+1RTV15209uQGICJFzCTUSiSKjIfRQRBdQqWrxWrLYdK15WO2qt05utbXVmrU7ftrO6Zlqn62vna9fUVr8iVEurxdpReGEKWqBSRUTqhYuigKJAuCYk3x/MPu4cTi6EBNDyrJV1ck6Sk7P32c/5Xfdvt+Lo0aOMzTuS5OWSvlzTZ4nkJYUZ2AKMS2vV6/UoKyvDtGnTnrHp2mz50Zo1a/4iFosNd+7cMak+m3KXc62vRNRn+jiZ7CCRSBAQEIBXXnkFEonkgbeHq6urcfPmTaYgIF2GiNTmZmOo6vVgfucIqUxCRAZDfxz17t27OHToEHbt2sUsPzOSMJXTANyTwEKhED4+PnB2dmakryXVWa/Xo6KiAj4+Pt2bNm06acu12Wxcbt++/dHTp097q1QqZq4v7Ynm8kKz9+kOYIN812Dor7Dg4eEBd3d3FBQUPLBeaeLdvHr1KiQSCdzc3Jj4IZ/PZ8INer3tZXcIbCG5I75DCvwD/RMT7ty5g4MHD+LNN99kJPJIgoxnriQl9mv+/PmYMmUKEzYiITC2x5l417VaLXJycjB37twvTpw4YdOEeJtHQVxcXHRDQ4NZJxbthDGV4GHKI63X65kwCknwSEtLw/r16x+4GUski23ChAnIyMhAT08Ptm/fjueeew7fffcdbty4gdbWVnR2djLVPUkZo8Golo5WqQd7HtIWvV6PtrY2NDU14aOPPsJf/vKXUUFeU0KHfEYfMxgMmDJlilHCBpfqTF5kTbBbt24ZVCrVRluv0WYJ/PHHH+szMjIyqqur3QIDA42eTuynFGCshpAOMNUZ9OcCgQB9fX1MvFmtVuPGjRu4fPnyiN/goYKoXv7+/ti0aRN27tyJRYsWITk5GSqVCuXl5fjss89w7tw58Pl8yGQyCIVCJmbM4/EYEgD3+pjAVgfYYAk+2O8YDMa59BqNBg0NDfjrX/+Kzz//fMRVZgK6iowl6evl5YXly5czYU+umC9bEh87dgwzZ8788dlnnzVb+9nsNQ6lgc8///x3OTk526Kjo5mG0Kq0Naoz2yXPJjg5p16vZ3KEp06diqqqKqay5f0GQlylUomMjAy8+uqrSE5OhpeXFyQSCaRSKUJDQ5GUlASVSoWKigrs27cPxcXFaG1thUKhYEqRAjBSr+ljg4WjiUuOEemq0+nQ3t6OS5cuYffu3Th+/PioIS89bs0RGAAzJpOTkyEWiwGAU22m1ee7d+/i6NGjWL16dVRWVlaXrdc5JAIfOHDg9ooVK7a3tLSIfXx8jEjItoXZnWJqUoMpkvP5fPT19UEkEsHFxQVhYWEoKioa9pS6oUIoFMLT0xPr1q3Drl27MG/ePHh5eUEqlTJ1tUnFEolEwhA5Ojoa169fx1dffYXvvvsODQ0NcHd3N6rsQPqWDBy9Xm/U/1wYTluYxHaBe3nDP//8M3bu3MlMpxwtYNdvY5OXHtNCoRAzZ85EXFwcY/+ak75arRY//PADQkNDL7/44otWVd4weZ1DbejLL79c/tVXXz0RExPDSEsuJxZdMIxLBTFlY7C/bzAYIBKJIJPJEBISgh9//JGZqzlaQW6yh4cHnnzySbz++ut4+OGH4e3tDVdXV6OZXcSLCYDZl0gkCAoKwpw5czB79mz09PTghx9+wIEDB1BRUYGuri6mrjTxO5BzkKc+IRWx0QaDwcSOTYFW9TUaDdra2nDs2DG8/PLLaGhoGFUVSbmIa0p9Bvrb/fjjj8PHx4cxccxJ387OTmRmZmLVqlVJOTk5TUO5VrvEZJ5++ukWHx8f+bRp05h6P3QxO5KYQb/Y1SwtqSnsAanVaqHRaFBcXIyXXnoJTU1No+oJDtyzSf38/LBy5UqkpaUhICAALi4uEIvFjDOO1BRj26+knYQYZL2pnp4eXL9+HXl5eTh58iRKSkrg6+uLWbNmYfHixZg0aRI8PDyMapKxtSA6cmAK9iAuAKPyNB0dHbh9+zb279+PvXv3MprCaAEthOhxyRVGIlulUol3330XSqWSITC5d/Srt7cXvb29yM3NhZOTU/3HH38cONTrtUuO4iuvvFKck5OzPioqymiAmAsh0ceAgVKZgEgT2hlGjhE7Uq1Wo6ioaNRIYtJ2lUqFzZs346WXXsLcuXMZVZlMLxMKhUyRPy5TgkxoIJqHQCCAi4sLnJ2d4e7ujoiICCQlJSEpKQlarRaFhYXYt28fTp8+jbq6Ori4uDB9R7y95Nz0nFRCQHNk5oIl4hKVmWRYaTQa1NbW4u2338bnn39u9xK69sBgHFdA/8M3NjYWc+bMMcp9Nid9s7OzkZ6enjhU6QvYSQIDwNNPP13r5eUVGBUVZSSF6aqVbAlMtrRE4HriEdC2HHmqjyZJTIqFT506FatXr0ZSUhKz9g0pJk6+RwohDAYkdkgcPYQgZO3mxsZGlJWV4eTJkygtLcWtW7cQHh6OGTNmYO7cufD394dCoRhQOZTdx+wHMBvWkI4MWqC/EGJHRwdKS0vx1ltvoaqqatRpS8DgVWegn/B/+MMfsGDBAojFYuYeEQlMFv8j0vfo0aOQSqVXPvzwQ5U9rtluAdX4+Pi0ffv2/RIeHs40WqfTGTlWCCmJc4VsyXsabFuN/X0nJyf09vZCJBJBKpUiPj4e77zzzoiQWCQSoa+vD7GxsVi9ejXi4+Ph7e0NkUjESFsAjIOK/WCiYY4cfD6fmZ5GJChZj0qn00EikWD8+PFYsGABmpqa8NNPPyE/Px/Z2dn45z//iZCQEERERGDWrFkICwuDp6cnJBIJc11kSyQIYKxSkmswB/JQJZJIo9Hgzp07OHz4MP72t78xsezRBlNeZ3MOV6A/Y/Chhx5ixidXqiTZtra2orS0FC+++OJCu123vU4EANu2bfvVyclpUkJCgpEEpl9kkLClMHnis+0PLmcWeQ8MlMSlpaV47bXXUFNT43DHCGlPSkoKVqxYgcjISMjlckbNJddP2jxYFdUa0KowYGw79/b2oqurC42NjThz5gyKiopw9uxZXL58GT4+PggPD0dMTAzi4uKgVCohl8uNivCTLfu6aelMP4xolZyUVK2trcX777+Pb775xqY0z+GCJa+zKekbExOD559/Hm5ubuDxeJy2L7kX2dnZ8PPzu/D3v/89zF7XbdcRdeDAAeWnn356Y/PmzTy2Gk1etApNE5nuOLoz6YHCtocJiH2n0+mg0WhQVVWFPXv2MBUu7AlyjQqFAosWLcKyZcugUqkglUrh7OzMOIyIjT5cEzAMBoNR+IgcI+obGUS3b99GTU0NCgoKUF5ejsrKSnR3d2PixImYMmUKIiMjERcXBy8vL7i5ucHZ2dlo2Rxyv0xBr+9fJaGjowM//vgj3n33XVy5cmVUSl0CrlRgayQwj8fDM888w6k+kz4n/V5XV4fPPvvM8NprrynT09OtLhtrCXYXCX/+85+P1NbWLqYr0HORmB4QXCSmX1z2GLsz6YXENRoN6uvr8fbbb+P777+3S3IA8S6q1WqkpaVhwYIF8Pf3Z5aRIV5kQlzifBoOcGU6kb6gP6Olg06nQ2trK27fvo1z586hpKQEFy9eRHV1NbRaLVQqFUPqqKgoBAQEwM3NbUC1EJrcROI3NDTg888/x7/+9S/mOkYrTNm9XF5nwHjcjRs3Du+99x78/f0hFAqN+pe2fbVaLT755BPMnj370Ouvv77SntfvkBG2ePHi3rS0NJG3tzfjvCI1cWkHjqnQEq1Ks+0SwDhLiwY7Pa+xsRH/+Mc/sH//fiY3dbBwcnKCwWBAQkICVqxYwUgnQloiYclAYOdp24PEQ1E7CZmJLUZAzA46LHf37l20tLSgvLwc5eXluHLlCq5cuYJbt27B09MTwcHBCA4ORkhICMLCwuDt7Q2pVApXV1eIRCL09vbip59+wnvvvYfz58+PauICA0NG9DgzpzoD/fc7Pj4ezz77LGQymZHpwpbCZ86cQWFhobawsNC6dWMHAYfMCkhNTX396NGj//P73/+ecWSRDBygv+PoAtfEwUU+I44usg/cmzNsirzAvcJ4Op0OMpkMPB4PO3bsgFKpxN69e9Hb22uVNCY3UKFQYP78+ViyZAlCQ0Ph6urKEJeokZZqV420zUc0AnItdH8TpxjQb0vLZDL4+PggJCQEK1asQHt7O1pbW3Ht2jX8/PPPqK6uxi+//IJvv/0WHR0d8PT0xPjx4+Hv748JEyagq6sLX375JSN9RjMIebmcV5bIS2z5GTNmGC0Rys64Ittjx44hIyPjhcLCQvu3w+5n/C/Wrl17W6VSKchyEuzFztjhJFuSO0x5c+mpXJ2dndBoNMjLy8Obb74JUhaXC2S5x5iYGKSmpiIpKQl+fn5Gi5ST/6djtKMZlubl0l5SGvQgpMu6trW1oa2tDXV1dbhw4QKuXLmC+vp6XLt2DTdv3nR0c+wGeoyxbV/AeGxx3WN/f3/86U9/Yoo7mkrcyM3NhV6vb963b5+3I9rhsHl58+fPTzhw4EBleHg4j01E8nRmp1bS77k6jd2p5EnIln5EPddqtRg3bhwEAgEWLFiA8ePH46233sLp06eNkv55vP6C8vPmzcOSJUugVquhUCiMFiQn/0mk7WBjuMOBwUp78iAi2gQ93Q2AkbOKqOLu7u7Q6XSYPHkykpOTGZ9DXV0dNmzYgJaWFvs1yEGgTTW2rWvJ10J+P336dLi5uTHpq3SyBtlvaGhAWVmZYceOHTP27dvnmLY45KwAcnJybm3cuPGh//znPw+FhIRwSlBgICnZ3zHXqbR6Te+T92QWE7G75XI5Zs6cib6+PpSXlwMAIiIisG7dOuzcuRNLly5FcHAw3N3dIZVKGY8yn89ntAdzMVz29TkCjlDJ6f6jbXlaQgH3HowkMUUsFhttz549i9ra2hE3G8zBlKPUGtUZ6O8roVCI9evXQy6XM9KXPVFfq9Vi//79WL58+YGhTBe02B5HnRgATpw4kRUSEvKik5OTk0KhMOoYazqMHKMHmDVPSPq7RIrweDyKr5nPAAAaC0lEQVTGfg0JCUFpaSkiIiLw7rvvIjExEd7e3pDJZJBIJEzMlhD/flCVBwtrSEbfKy6Vk3yHLFZ98+ZNFBUVjYp0Vi7QzipTk27YwoMGSWeNjY1FSkoKXFxcjJJqaIdgQUEBenp6Oj788MNYh7bJkScHgEWLFi0+fvw445njml7FVdGDq4IHV3E8dn0t+j3Zp8M6YrEYrq6u8PT0RG9vL6RSKfOiiUtU5weFuPaomQUYq910oodQKER8fPyoNC2AgeS1pD5zkRfoNzNSUlIY7Yw9hnU6HRobG5GXl4dly5Y97PB2OfoPMjIy/jc5OTn3m2++GfCUMkVoOhxE22TmqlwScMVEaTuZz+8v0SOVSpmFnAmIg41IbfagH82qIQ17XLe1vyX9KhKJ4OPjA7VabdM1OxJc5LU2VZJ9HrVajeDgYPB4PM5xq9PpcOjQIaxZs+abjIyMIoe3zdF/AAC7d+9epNPp2khskCTkc0lhdhEwrgqXXPvmSExAq4Pu7u7QaDQDZulYAhc5Rorc9r6OoZyD+BhiYmLg5GT3cKfNYMd42VIX4HaiEtB9otfrkZyczDhG2WNZp9PhxIkT8PLyan3jjTeWDkv7huNPAGDhwoWxhYWFBo1GwznNiiYx8XiyX6ZITB8jMEdiAPD09MSdO3eYVQDM/cZamCO3I172gC3nY/+GdvQlJiaOmsn5XAkabBueVvlNqc1EgwsMDDSauEBClWQcX7p0CaWlpYbU1NToYWvjcP3R+vXrf01LS3s7Ozt7AHlNSWKu0iRcpGU/JU0NSvrmTZgwAS0tLWhvbzeannc/qcq2wNaHgLnfkIEvFAqhUqmgVCrtdr22whJ52Y44S9qXwWBAUlISk0rKFjw9PT04dOgQ1q1b9+eMjIwrw9FGYBgJDADPPffcKxMmTLh08uTJAS53LqnMNS3LGhLTT06uFEpSwtVgMKCuro5zUI60emwP2NMWNgfaDvbw8EBkZOSIlv61lJJrTRSDHkM8Xn9VldjYWAgEAkZDpP05mZmZSEhIqNqxY8ee4WgjwbC7DGfPnh1648aN7srKSk5JzHZu0ZKYLZW57GCuwcre5/P7S7TK5XJm+VJLA3W02L1cGGlbmAxyoVAIsViMqKgom/97qKDDQ6ZsX4B7aioBTV7ymj9/Ptzd3SEQCIzGqE6nQ35+Pvr6+rpmzZo1dXhbOwIETk9P71u2bFlMYWGhoaWlxagj6PdEMpuyhdkvtmTmIjG5UQKBABKJBEqlEteuXRuS6uxIe3W4bOGhqtWAcdx9xowZQ76mwYIOb5lzXNHXSt7TYJOXx+Nh/PjxiI6OZnL06fF64cIFnDp1yrBq1apoWxYnGypGJGiXkZFRuWzZsucOHjxoVH6Ey6HFZSuziUw6m3aCmRuQAoEAMpkMAQEBqK+vZ9bfcaREtZaMwyHdh/I/ln5H6pQFBwfb41KtAk1ets3LnsVmjrwE7P6ZN28eU7Cd1hqbmppw+PBhbNiw4Q/r16+vGrYGUxixqPvWrVvfT0hI+C4rK4uZdsVFXFPkNUVitrrNHmzkBovFYgQHB6Ourg7t7e1Mfjb7AfAgwF52sLnfEmI4OTlBLpcjMjJyWMJJ1jiryPfIddJbGux+4vP5mDhxIiIjI8Hn9xeUoIXM/v37sWLFim+3bdv2fxzeUBMY0bSZPXv2LPb39//13//+t1HhL64pWdZ4rGkSc72AeyEBHo+HsLAw3Lx50+zas6PZ9mXDUeq7NaDNE5FIhN/97ncOn1JoSmVmJ2nYQl4yjhYtWgSpVMpMwiHj9IsvvkBMTEz17t27lzi0kRYw4nlvs2bNUre0tGh++uknow6iy+SYIi2b2OwED3pL3pPcaqFQyKwkd/78eaNsL2swEurvcNrCQ/mNUChEZGQkXFxchnxNXOCyd81NSLCUbcXVlwKBANHR0VCr1cyMI+KXOXLkCFxdXVs++OCDKQ5p4CAw4gROT0/vW7169YSKigptZWUlMxmcLktiKuGDK5HcFInZUprP58Pd3R2TJ09GRUUFc157kc8Wm3e4Hwr2sIVp0OEkuVyO0NBQu10r/R9cExHMzSoCrLN36X0ej4eHH36YWTWDmHh5eXmoqanRLV++fLLdG2cDRpzAAJCent6Snp4eWVBQoK+pqeHMmbZEYq6kDy7yAvemhLm7uyMkJATV1dW4c+cOk0Fka/md0Y7hsIWBfgns5uaGqVOn2s0ONid1LRV+GIzKTN5PnDgRnp6eRqHNU6dOobi4WL9hw4aI9PT0UTHxeVQQGOj3TK9evXpJbm6uoaGhwYi87NpN1pDYVLyYDD4ytzUqKgpXr17F3bt3mYws9tN4tNu+XBgpWxi4Z5tGR0fbJa2SPZ3RVLUWwHxBCLpNZMvVvmnTpqG6uhpHjhxBa2sr2tvbUV5ejhMnTmD79u2pGRkZlUNulJ3g0PnAg8WRI0d+3blzZ9WhQ4dWBgUF8chSjeybwzWgyHH6+2zQvzEY+sNOAoEAhw8fhkqlQmhoKFMjypZpccM59dCRdrY9fqfT6SAQCJCdnW0zidlS15K05XJWWZOkQUwqJycnPPbYY1i8eDH4fD4ph4Pu7m7k5uZi9+7dm5544oksmxrjIIwqAgPAkSNHzr/44ovXMzMz0yZNmsQjjhBzN4WA6zg5Ruwaep9I5bKyMrS2tiIxMZGpg2zqfA8i7EVawLjUkVarRVFR0aBrZbFTIAejMpuSwOyHN5u8fn5+2LhxI6Kjo+Hs7Aw/Pz90dXXh+++/x9WrV/HOO++8u2rVqiEtBeoIjDoCA8DRo0d/fuGFF9oyMzMXTJo0CVwkpreA6cFkCoTQAHDt2jUUFxdj7ty5TIlUaxwg9yuGIr2t+S3dt+fPn8fFixcZ88QSaHWZi8iWCGvK3qXf055mgUCAefPmYe3atQgMDGRKCen1/etOVVVVYfPmzSe3bdv2pFUNGGaMSgIDQG5u7qnnn39ek5WVNX/ChAk8iUTC+T3yxLd040xBp9NBJBIhKysL06ZNQ1BQEJydnZknszWq+WiGvcJLg/0+8dySdYAtncOSlLVF6nK1gR4rarUaGRkZSEhIgEwmYyZgaLVaVFVV4bvvvsObb765f8eOHcsG1QHDiFFLYADIzc0tfumll65nZWWl+fr68mQyGYB7N8EUsejP2McJaDuax+OhpKQEGo0G8fHxzLpG7LmipmzvkYajQkxD/Q2RullZWSaTOtgqsikSD1bq0tdD32eDwQAvLy+kp6dj2bJl8PX1ZUoDESdpeXk5vv32W7z66quvPfHEEzsG3RHDiFFNYKBfnd61a9f5zMzMVR4eHjxXV1cmrc1apxWX44Lsk4Fw/fp1FBUVYfbs2YwabQm2ktcaSTHcsKdaTfsZent7UVBQgOZm4+WAuGxbSxLYFrWZvsf+/v5YsmQJ1qxZg9DQUGa1EGKvk1DR8ePHDX/84x8ff/LJJz+0uVOGCaOewADw7bffVr766qvFhw8fflwsFvM8PT2NPmcPoMFISR6vv7aRVCrF4cOH4evri9DQUKO1jiydazRI4cFiqA8Ka35PJN4vv/yCS5cuGdmd5hxUdGKGJdKai/GS1T8mTpyIlStXYtWqVQgLC4NYLGbuLx2ezMvLQ0FBgX7r1q0LNmzY8M2QOmiYcF8QGACOHDlyec+ePYePHz++oaurS+Dv7w/A2KZhOyto0Pu0OkyOi0QiVFVVoba2FjNnzoSLi4vZVfjoAXQ/2MgjYQvzeDz09vaioaEBRUX99d3MOaeGmg4J3Av/yWQyTJ8+HWvWrMGSJUsQEhICiUTCJJbQuQS9vb04cuQILl++rH3mmWfCN27c+NNQ+mk4MXJlE2zA+vXrzx08eNA3Kyvram5uruuCBQuYxcdIAXcuNZn+jFRUoAeLQCCAWCxGYmIi9u7di19//RVubm6MGk2rYeyYI8FoIPJos4V5vP5J/tHR/SWi6HKu5iSrqZChqX6lC/iHhoZi+vTpiIqKYtbsJVKenXZLXl988QXGjRvXunXr1oD09HTNoBs8ghi9IsMMDh48KMjPz//1+vXrE9esWTNgzWF6ZQF2Bg/X2ks8Hg/d3d1oaGjAyy+/jNDQULzwwgvw8PBgysySwWPN3FLaM24vMg+XbWzPmDAAdHV1oaamBk888QRu3rw5oN/MJV+YUpPJvdNqtYzJExYWBrVaDTc3N6MVNWg1mT3DrampCfv370dMTMyvH3zwQYhNDR9h3FcSmOC/lQ+C9+zZc+yjjz5asGLFCiiVSkYaE2lL57ayaz3r9foB5VcUCgWSkpLw9ddf4+rVqxCLxUxogXyPLkFLv8yFskZaMpuDI2LCdF8IBAK4ublBrVbj1q1bA7QZwHx8nzyItVothEIhfHx8EBgYiKCgIERERDBLnNLJN3w+32gGGz2zja6kcejQIaxcufLbkZ4SOBTclwQm2LNnz8K9e/c+m5WV9bdZs2bxpk2bZkRe+j15CYVChrxsVZrP52POnDnIzc3FsWPHEBwczKxKSMeFaZvbmhgkYH4dp+GCI+1gmrRsc8LFxQWTJ09GYWHhgLxlslgceTj29fVBJBLBzc0NCoUCSqUS48ePx6RJkxAYGAixWGy0/A1tznDNI2cf02q1yM/Px6lTpwybNm36w0hOxrcH7msCA/2VPT799NN/Z2dnl12/ft0lOTmZWQOJlrSEuGQfMC7GRrbe3t5ITExEXl4eHn74YYSGhhqRnmu2C1tdtiSVuZxu9ia0PVVurnOx20aTlmz1+v6F1m/evIkLFy4wKYsSiQRSqRQymYwhpFwuh1KphJ+fHxQKBZydnQcsog6ACSHy+fwB9dDYpGWTuaenB5mZmdBqtd3bt2+PGqkyOPbE6NPpbMTBgwcFhYWFdWVlZX7Lly9n7FcS6yPrHXHZwnQ1h+7ubtTW1mL37t2Ijo7Gli1b4O7uDrFYzHyHfvKbc8SYUw253g8m/OVom5jLo8++HlNef2I2tLe3o7GxEe+99x5OnTqFHTt2MCs3sP0UbNA2Mu2YZBc1ZE8h5SIwKbp+6NAhJCQkVM2aNWvqSBSgcwQeGAITbNu27Xx2dnaYWq1GYmIi5HI5pFIpE0Ig0whpxxexgQEwT/bMzEzk5ORg165diIuLY37PrnZoTahjMGTm2gccK62BgZVILF2DqTAdIZpGo0FzczM++OAD5Ofn47nnnsOCBQuY8ByXuk37J9imDz0t1NT8by7ikuVOSktLDevWrfvzcNdtdjQeOAIDwKZNmzZ9+eWXH2s0Gnh4eMDf3x+enp7w9fWFp6cnFAoF3N3djQis0+nQ3t6O5uZmNDc348aNG/jll1/g5+eHp556CpGRkcyDgF4n2ByZAe5QiK0kHgxxzUlzS9LblMrMtc/e9vX1MWrzxx9/jBMnTmDLli1IS0vDuHHjmDgsVwlgLuKaKh9Ml1UyRd7GxkYcOnQIXl5erampqdHDuWLCcOGBJDBBeHh4b0VFhQgA4ywhdbF4PB6TjUMGEI/HY8hJ28t8Ph8pKSlYvnw5JkyYwCxoTWxna6UxF5nprbn35o6Zw2BVbUvkZROWPq7VatHR0YFLly5h7969qKysxIYNG5CWlgapVMo4A82R1hyBuSSvTqeDwWBcLVKn06GwsBB5eXlYs2ZNzhtvvDFqJyMMFQ80gQFg3bp172ZmZr7Q3d0N4F6YgfY8W0M+kUgEmUyGlStXIjk5GQqFAi4uLkYq4WCyiLg817YS2VFpkaaIy6X2dnV1obOzE+Xl5Xj//ffR0dGBrVu3YsaMGZBIJFaTl6sUkqXSSTSZGxoakJOTA1dX146lS5cu3LBhw3+G1DmjHA88gQnUanXbhQsXZGTfFIlNlWehP588eTLS0tIQExMDd3d3ODs7QywWD0gFNHUOLhKbksZcnmx7q9emjrPJSo7R+1qtFp2dnWhra0N+fj4++eQTeHl5YcuWLXjooYcYJyJbZeaSuNYSl35PrxD4/fffo6yszLB27dovXnnlld9b3SH3MX4zBAaAxx9//NGsrKwssqg3TViu8iymvMpE4qrVaqSlpSEqKgqurq5wdnZmqhhyhZtsJbE1EtgW1dqSFGeTlUvq9vT0oKamBl988QXy8/ORkJCAjIwMBAQEMGaGqRK/pqqHchGXi8hEbT579iyOHTuGqVOnNiclJc14EG1dU/hNEZggIiLi9NmzZ39Hh0fMEZl8h00+kigSGRmJRx55BGFhYUwOtVgsHqBaA6ZTB+3h6LKGxKacUVzHuLYGQ/8Uwe7ubmg0GuTn52P//v3QarV47LHHkJKSAldXV+ZBNhjiWkNg2nl17do1HDt2DF1dXdo1a9Y8t2XLllE//c/e+E0SmMDb2/t2U1OTguwPlcihoaFISUlBTEwMvL29IRKJ4OzsbOTtNqVO0+cm7+mtqWNc+9bAHJFNSd3e3l709PSgq6sL1dXVyM7ORnFxMaZPn461a9ciODgYzs7ORpNAuIjLJi07NGTKaUWI29raih9++AEXL140PProo1+/8cYbKwbdAQ8IftMEBoClS5eGHzt27ExPTw+TTWBNiIhLDSbfVSqVSEpKwuzZs6FUKiEWixkyWyIyF6m5tuzPbYUlDzMhLiHvlStX8PXXX6OgoADe3t5YunQpEhMTGROCpKhyqc2mPMzmCEwTt7u7GydOnEBZWRnmzZtXmZCQkDha6jOPFH7zBCZISkp6tKioKLO3t5eZJ2jKwWXOtgXuOcgkEgmio6ORkJCAkJAQyOVyJkXQnFSmz0lfC72lYSuJzanP9BI3XV1djLqal5cHsViMhQsXIiUlhcl4I6mrXC9r4rvm4rzd3d3Iy8tDaWkpZs+efSUuLm7h+vXrf7Wp0Q8YxgjMQnx8fEZpaen/1Wq1TN9YI4lNkU8kEqGvrw8+Pj6Ii4vDzJkzERAQADc3NwiFQohEIibV05Rjy5QUtkRc8rm5MBP9GXEMkSVt7t69i8rKSpw8eRJnzpyBs7MzkpOTsXDhQvj4+EAgEDCxdOBeNheXjcsVIuLKriKk1ev1aGtrQ0FBAUpKSjBnzpy6GTNmPLJ+/fpzVt3I3wjGCGwCs2bN2lxSUvIhrVqzbWJrCExvSTglODgYarUasbGxCAgIgEKhYEhMtnRRPXNeaXNOLlOgVWW9Xm+08oVGo8GtW7dQXFyM06dP49KlS1CpVIiPj8fMmTMZ256kpdLnsTY5g+ybsncbGhrw448/oqqqCsnJyZdiY2Mfe+qpp8oGfxcffIwR2AKWLl0afvLkyZ/a29uNltqzJfuKVrGFQiF0Oh28vLwQFhaGqVOnQq1WQyaTMSVOaTKz5yUTDEalJsRhpx+2t7ejqakJJSUlqKioQHV1NQAgMjISSUlJmDJlitE1ETt3MFlVbElME5pI3IqKChQXF+PWrVuGRx55pDgyMnJZenp6M2djxgBgjMBWIzU11fnMmTO1jY2NSlrttEWtZm/pcj++vr5QqVRQqVRQq9Vwd3fHuHHjmIwvQmYez7iuFBdpicpKCEII29HRgba2NtTX1+PChQu4ePEiLl++DGdnZ4SEhCA8PByRkZFQKpWMvU7+0xJxTR1jk5ZcT0tLC0pKSvDzzz9DqVT2JCcnZ6pUqowHZbaQozFGYBsQFxf31tmzZ1+k1WvAPJnpz7ne0+cghAYADw8P+Pn5QalUIiAgAEFBQfDw8IBYLGYcYjSRaWIRB1BXVxc6Ojpw+fJlVFdX49q1a6ivr0dnZyc8PT0RHByMiIgIPPTQQ5DL5UwMlxCXrXIDAycjmEvWYL9I7eWysjI0NzcbkpOTfw0PD9+yefPmfzv41j1wGCPwEJCamup69uzZihs3bownA5vAEomtcUxx2c99fX1wcXGBh4cHFAoF3NzcIJfL4enpCU9PT0ilUty+fRs3btxAY2Mjmpub0dLSgtu3b4PP58PX1xfjx49HUFAQQkND4eHhAVdXV6M5uuyCfYSU9Hs2cblIzJa2586dw9mzZ1FTU4OwsLDWuLi4/xcUFLR1TNrajjEC2wlLliyZcvr06f9tamoyUrEBbtJao1qbOkZ/RqQvkbhAv52sUCjg4eEBDw8PeHl5ISAgAIGBgXB1dYVUKmW8x3TBPwI6hZJNXvK5pfiuwdA/ob+yshKVlZWoq6tDWFhYW2xsbI5KpdqWnp7eOsQuHwPGCOwQLF26NLykpCS3qanJT6fTDejjwYaJBuO04vF4SE9PZ2pbk8J8xHNOE5YrcYPWJMzFdcl32U4qoqZXV1ejt7fXMG3atGa1Wn00ODj45TGHlP0xRuBhQHR09MdVVVVPdXV1ibhiskMhMHtfJBIhJSUFjz/+uFHmF1stBowlLTvfGTCO67K3er0enZ2dqK2tRU1NDa5cuYK7d+/Cz8+vOyoq6tykSZPe2bRpU7bVnTQGmzBG4GFGamqqc01NTfa1a9fmaTQaF3NJFpZUaS5pLBAIEBcXh40bN0Imkw2oN8X+P7btziYrIXRLSwtu3ryJGzdu4Pr166ivr4dQKDRMmjSpPSQk5Kyvr+/++73C4/2IMQKPAiQmJj5WX1+/p7m5eWJXV5cTm1TmwEXi0NBQbNmyBXK5nIkfs8GWvCS0dPfuXdy5c4dxfDU3N6OzsxNyuVw3YcKE9sDAwEve3t6Fcrn8k4yMjEobmjsGO2KMwKMY8fHxLzQ3N6+5c+eOqqOjQ9rb2yugVVxTGDduHGbOnIlx48Yxy46QGDCZmEDCS/9dzcLg5OSkd3Z27lMqlRovL69GhUJxxdXVtdTNze14RkZG0TA1eQyDxBiB73OkpqZ69fX1/UGn00WIRCKVTqfzDAoKaomKitKJRKK2vr6+ju7u7tsCgaAaAAQCQatQKGwWiUT1MpmsLD09vWuk2zCGMYxhDGMYwxjGMIYxjGEMYxjDGMYwhjGM4QHG/we3Lkn+LweLFAAAAABJRU5ErkJggg==";
__base64Images["./projectile/projectileprimarys.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
__base64Images["./projectile/2014-05-05 13.33.48.jpg"]="data:image/jpeg;base64,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";
