var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./prob1_03/20180205.png"]="data:image/png;base64,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";
__base64Images["./prob1_03/green_truck.gif"]="data:image/gif;base64,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";
__base64Images["./prob1_03/prob1_03.png"]="data:image/png;base64,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";
