var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Momentum1D/2013-12-26_1701.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Momentum1D/lookangphoto.jpg"]="data:image/jpeg;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./Android_robot.svg.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAdCAYAAABfeMd1AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTFH80I3AAACl0lEQVRIS+1VvWsTYRgPdXJxEaGDjopjV538Kig6tEMHdbC4qqg4CQ7+AV1cBAU7KSRUkZLSRNO6VHImMY3aGqk1d7WWfuRKcxdz18SYvP5+R1IuaZJLLuAgHry8eZ/n95Hned97z+Np8ggh9meMbyvlculGMwzjzBNHfCtcwxxIe9e02LKivtbwuxfjIEY/xlBl5rqXeeKI79iEBBCHE98fCjU7vzn3Y7Q8s3BPTCdvCs5cM848nituDQ7ppiKF5q+Jp+FjTUfo83Whm0sSK+3IiG1IZz8qY9GzLQ2q5mPRcwJ4mby2jAD05PLrgRfvL1gGceWB1Z5G1TDOPHPEG+CR7/gAdDIqj+yIvkneFoFPVxuaMM589Q+Qh+eEo0mxZD72RfrbalN9deQVS9uPmh1XnqQeJtXsXKzVRjvlyK+czJ6d1uHHUbxMkqwGNbOg+oxCemVxY1y4HSb41KEedMPU92hGSvJGTlntmfhwWazrcVetqlZIvh86XHsjp4VmyGGPnA4Y9hbgDe7KpJ5PfZhMmrUmr7o0qeVT/79J05Yq6j/dLpSXs5+upc2prk5XPR/6P3Hjrk28jA9YwtPJW2JDn+3KhHzqUI+61OeddaBQ1Edx50RK5V/3VzPvUk73U6s8+dShHnSfUH/XhbmVW5CehY+7qoa8rdxXyfGqh/Pgl1Vv0Z+4iHIHa8yex86L8dkhwdleDXHEkwf+gKNJ5ZruA/hOdnt5se7KySN+F5uZt8eJIx6jry0DOyhjpKbsYrjsshDaw9keJ65j8Srhr5hophyqbVdQtypRg7o9rplKyHUlv0uFEX/ikrXJvsgZAbEZflI5+/BBYpx54lybQHAfP6XYaB1VvcX6cOVgHOGaceaJa2XyBwVrB+tcZqhVAAAAAElFTkSuQmCC";
__base64Images["./Momentum1D/cart_large.gif"]="data:image/gif;base64,R0lGODlhPAAPAKL/AP///8zM/8zMzJmZmWZmZjMzMwAAAP///yH/C0FET0JFOklSMS4wAt7tACH5BAEAAAcALAAAAAA8AA8AAAN9eLbc/jDKyY6iOGs5+jBAKI5kaZ6oaHidQbyEEcx0bd94rtMuHPsGgXBILBqPyOSwBzMUnoWgckqtCpzQaFZq7XqvWS10xSqbz+g0Gjveft9V9lPOhduNcvH8zi/m6WqBgoMtYXR9iGBjG4yNGBaQFgtABpGWl5iZF02VlwkAOw==";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Momentum1D/collisionJSmodel_2013-09-19_1128.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAV4AAAC0CAIAAABT4dMdAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTFH80I3AAAuf0lEQVR4Xu19CXAb55Xmgy0fzCTOJM4ksT3xzFTOWdvJelNba3vXu1HtbDKOk1R2ajybzGZiu3wlE1WciTOO4ySON7FlyZYtWbcs2TpJ8RAPieINECAJgrgPgrhIguAFEBdxEBdx9r4GKImmaAmA2WaDfn/9BTaar193f3jv6/f///v/FljHp4Bn5brrNn365j+//rpNAoHgCpe2uJj0ePwf/dinMnBdJsfw7CYq7HKuEcBHrr9mE/4prmQZJp5isgT7ZXClUslwaP6WW26+4cYbrowli/l111x7zZXNvLjfAyCTyQbCkVhikXl/P0o6k/H5vD6fD5iKLbFYzGi0zc3FgkGGKiHAEwTQIA0GWzQaq1DHSiaTdrtdqVRuAGqI88Qm6DIIAUTgAjXEK5caRkdHu7q6Kpoa4vmogaiBgiYeIYAGmY8aKpgarFZrS0sLUQOPrIqeuhsAgQ1ADRsgaij0NVDUQOzGIwQ2QINibGxMIpFQ1MAjq9oAz0y6hQ0QNYyPj/f19RE1EDUQAmuJwAagBooa1tIg6GlJCBQQ2ADUgH0NPT09FDUQQRACa4nABqCGiYkJtVpN1LCWZkFPTkJgA1DD9PQ0sgNRA1EDIbCWCGwManA4HEQNa2kW9MwkBIga1j8NNBajbEjiNd4hQNTAB2qg6VW8cwyKGjbA9Crsa6j0BgVRA1ED7xAgauBD1EANCt45BkUN1KAgaiC3JARWQYCogaiBHIMQIGpYfx5Y5QpohIKidx4iQFHD+rPFhQXgaFI2Pb15hMAGmJS9AUYoqBuSRy7Bwwf4ulwSRQ18iBqIGogaeIcAUQNRA++Mcl0eknTSFQgQNRA1EDUQAjRCsf48QCMU5IeVgQBFDevPFjR4ScE8DxEgaiBqqIyHGA+dZ2NfElEDH6iBplcRPfEOAZpeRdTAO6Pc2E/jSrk7ogaiBqIGQmDVEYqKfx3uBsiGpAYFOSfvEKCogaIG3hllpYTcG/s6iRr4QA2UKE30xDsEaISCqIF3Rrmxn8aVcndEDUQNRA2EACVKrz8PUKI0+WFlIEBRw/qzBSVKV0qM/aG6TqIGoobKeIh9qNySDzdL1EDUQNRACFBfw/rzAPU1kB9WBgIUNaw/W1BfAx/iZ7oGWuVp/blgxRUQNZBb8hABihrWnykuLDYf46F90CV9aBGgRGmihspo+n5oXXS9bpyogaiBqIEQoEnZ688Dq45Q0KRsck7eIUBRw/qzBfU1rFfMTOe9AgJEDXygBpqUzbtnJrEGjVAQNZBbEgKUDbn+PEDZkOSHlYEARQ3rzxaU8kTROw8RIGogaqiMhxgPnWdjXxJRA1EDUQMhQH0N688D1NdAflgZCFDUsP5sQX0NGzsyr9C7I2ogarjKQywQzAUCWf98xudPYZ0PZHFPhZo7Dy47D6Y/7Uck59O4HeQrmEQNfKAGniZKIwuMu7wNlo5njS88bHrih9Yf/7Pl4SdGtrxi3CWxq2e90UCAOKLI1kHO501MjplHBg8Zhb+wCB+1in5sFj5mFP3apGhwTs3Oz2d4QFvvuhfKhiRqWN24ffOpwcnhRy1P3eK/7frk9ddmrr0mcy1+bkpv+kj8I3fM3LXVvHNszksRRDEu7ZkLWVWnHN33xPo/mpZtysiuLdT04HVhyc3W7n8cN0n9vsViVH1gMkQNRA2rU4Ntzv1L4/OfCv0F5ACYlfWa9DVfmbuj2tLi8tAyE1cJHHy+pN0kdfTcvyi9npFDoeYubOB2tP/jpp5HnZMTvIrCiBqIGlaxbIwF1K7RvzM/cEPsxiVeyACEAGIA2SWa+Gz01m2GNx1zgQ/sOVahJ/J6YqPaZrfoi+lBQYEXYlJw9EBicIkmktLrJoX3TZjlfl+aP/dI1EDUsDo1qFy2b5j/1/XxG1hqwMAhAjACMA6QvEgNt2zV7yRquKoz56mh6SI1JGUw0gFnTsOsCLJDLDskpZumhf/FbpL5fKmravvABIgaiBpWo4ZALk8Nf7dEDRgy+ADGAEYBonmmYOAzUaSGNxxz8x+YsVboiZZTA7YjIgOgbQNxMwy3LwUOF6hhkKhhDb0xmUxOT087HA5YQ6UfsCoe5jVgg0Llsn7DcoEaFgGmAGbydQ4gxVLDZ1lqoKjh6iMUy6khJYPZXrB0guws6Nsh0M8GDsnBTdMiHkYNcYPBFo3GP2B3WKvTETVc3TTLeNjmqcH2DcuFBgVygRvAnieIeQAMIogagsUiv5wa0jLwSlhq6G0CaxeEC9SADQqihrWihAt6iBqKNdCSCGIlNWB3QxogALCwxAtEDcXjuaKvodANibyAn4VeSYoa1poWWH1EDR8UNWCkEMxTw6URCmpQFAX+5dQQl4KtC/BziRooauCAG4gairLO4h9xBclVogaihqJbECvQvjo1UF8DUcOqCPC1G3JZXwM2KIgaiBo4cGDuVFLUwGXUcHHw8j2pgQYvr47/1aOGpbwGvg1e0ggFd8RVnGY+Rg2FvIaLIxSrUUM+r4EGL9eCGrBBwaY8ETUU5zDFSVHUcHXTLLWjYfW+BhyhoG7IstoUV48aqK+hOG8vSWpjUAPvJmXjPB825eliojRFDWWRQoGUVx28xBGKdw1eUqJ0SX5fhDBRA3dRA1LDhWzIQl7Du6MGSpQuMhy7OjUsDV7yrUERy2dDxopwQz6KEDVwQw1LUcNVqYH6Gq6Of1HUwMe+BqKG9aY8Hr7zMt+gwG7IK1FDfg4FjVCsBTXwtK+BqIGo4bKG9NL0quV9DdQNWW53w9WjhqURCpqUvZauSA2Kqz+1imwSLxdbihqor6FcOlgO5tWpgad5DRQ1rCVVlaOLj3kNKyZlr9YNSZOyi+RcGrwsxyve9zEbI2qIG402XNu7SFP7AMRWn3lJeQ1lBRFFRQ00Kft9c8EKBUQN3DQoLl+vAVdwKazX4Kf1GkrDfMV6DR4xOyO7txksXRCipVzWmhEu6iNqKM1Mi4w4VkYNuMrTdH6Jp1la5alkwFes8jQjYklh8By7DNzSKk80KZsDgiBqKNlSi2GHldSAwxOXrQ1JfQ3FILkiG5JdG1J62dqQPB28pOlVHDBWSSr52g25bHoVrhOLq8XiitLYpqAVpUvscVh9RelacPZeWFGaqKEkhylOmKIGrqKGle+hwMABV4VEglj2HopX9Ltosfmrxg6rvodivHv5Kk/591BYFDx7DwVFDcWREHdSPIwa0NwLb6/6i9CnBTnB6m+vct1RYznr8vBoYOWqXrouAhfeXvXflr+96tJrrIYg0sfPt1cRNXDn9MVp5ic1FN55+Yj1qc+6b702tQkJYqlmBTfEb7xj+qsvmV8fnfPw6l1s6+L5xZzUMxe0KE5M9twX6ftIduianFxQqBnZNfOiT46J/ml8ZMDn5ds7L4kainNg7qT4SQ1o8f75jM3lbrZ3vziy/cmRLf935NF/GXns58Znd5oPiifVM94I8UIxvFCQwTdlT42NWJXHR8TPj/Q8MdL96EjPT42SP47pz85OTs/7efRKu8IFY6INvYeCO68vSvOF6VU8jczR/33+lNu/OOdPuP0Jjz/pn0/TC7KLJ4Vlkrn5+YwfAfQl8nXR708FAtmyVHHSx7T8Si682I5eUVOUF3MixNuogZ8mS1f1wSBAUQMn3l6SUqKGD8bW6SwlIUDUUJIXcyLMw/UaSrIhEt6QCNCbsjnx9pKUUtSwIV2r0m+KooaSvJgTYYoaKt2LNuT1U9TAibeXpJSihg3pWpV+UxQ1lOTFnAgTNVS6F23I6ydq4MTbS1JK1LAhXavSb4qooSQv5kSYqKHSvWhDXj9RAyfeXpJSooYN6VqVflNEDSV5MSfCRA2V7kUb8vqJGjjx9pKUEjVsSNeq9JsiaijJizkRJmqodC/akNdP1MCJt5eklKhhQ7pWpd8UUUNJXsyJMM8nZVe6idP1l4cATcrmxNtLUkpRQ3m2S0dxigBFDSV5MSfCRA2cmjgpLw8BogZOvL0kpTS9qjzbpaM4RYCmV5XkxZwIU9TAqYmT8vIQoKiBE28vSSlFDeXZLh3FKQIUNZTkxZwIU9TAqYmT8vIQoKiBE28vSSlRQ3m2S0dxigBRQ0lezIkwUQOnJk7Ky0OAqIETby9JKVFDebZLR3GKAFFDSV7MiTBRA6cmTsrLQ4CogRNvL0kpUUN5tktHcYoAUUNJXsyJMFEDpyZOystDgKiBE28vSSlRQ3m2S0dxigBRQ0lezIkwUQOnJk7Ky0OAqIETby9JKU3KLs926ShOEaBJ2SV5MSfCFDVwauKkvDwEKGrgxNtLUkrUUJ7t0lGcIkDUUJIXcyJM06s4NXFSXh4CNL2KE28vSSlFDeXZLh3FKQIUNZTkxZwIU9TAqYmT8vIQoKiBE28vSSlFDeXZLh3FKQIUNZTkxZwIEzVwauKkvDwEiBo48faSlBI1lGe7dBSnCBA1lOTFnAgTNXBq4qS8PASIGjjx9pKUEjWUZ7t0FKcIEDWU5MWcCBM1cGripLw8BIgaOPH2kpQSNZRnu3QUpwgQNZTkxZwIEzVwauKkvDwEiBo48faSlBI1lGe7dBSnCBA1lOTFnAjTpGxOTZyUl4cATcrmxNtLUkpRQ3m2S0dxigBFDSV5MSfCRA2cmjgpLw8BogZOvL0kpTS9qjzbpaM4RYCmV5XkxZwIU9TAqYmT8vIQoKiBE28vSSlFDeXZLh3FKQIUNZTkxZwIU9TAqYmT8vIQoKiBE28vSSlRQ3m2S0dxigBRQ0lezIkwNSg4NXFSXh4CRA2ceHtJSiORoFzeODJyYHR0/4et2mz7rdbqqakpvz9TngXTURwhQNRQkhdzIhyJuNTqZ7zeWyKRqlC4KnyhLixUBearAsEq3AiFqubnq9yuKq+/KhCo8nqqpqaqgqEqPCS8wH6GglXz/iqfvyoYYCVZJaF8XWC3USAarYqgwgBbUXLcVjUxxZ4uFKiyW6pMI1VON3uiKCoMVflRQ/5AlMRT4yEzM1Wu2Sq3t8o1lz8FnijEntTjWTojqmKvM8gKLxROV7gq/Jrf7/cv3RoK+PD6Z1hJn7dqwnGnydTp8SQ4MnFSWx4CRA2ceHtJSpEa9PpfRCKfiMRBZYBhNRjNbLWbYVAOA0pwzIJMDhoDDErBbANpP3Seh4Yu8IcgHgWrGWYdYLPAqAFGx0A5CLIB9nA9fspBbwOLHRKLkE6Ca4JV2C8HoxGOHwOtGRZTEA2BTAhdjaA0QDQO0TDo1aBQsSc16UA+yG6Pm0E0BAO9YB0HhQbMOhAKwWAE1yQYLKDRglwBag1MWWFABBIRe2GZDIR8oFSCSgdzHrAN51XhVRnYe5GJoFEEBj109Ah6pF/U6tuIGspzYO6OImooyYs5Eb5IDaEgdLRCSwOcaQKZBtrOs7zQ1smSQmcv6/aSXtAOQks3dDWz/4rEIBICaRf09oJ5FETdIO2EN3fAWwehE739NJxrgGONMOyAZBpQubALBlTQ1g5yOevqgQXIZVkHlnSBWApzfkglwe0AYTvYbDA5Ce31oB6EMw3Q2wFaE4jxLDqQaEAogtZm9pIUPaDUwdkeUGnhbCMoeqF/CM61gdsPi1Gwq2FABmPjMD4Cxw7C7h1wrB06umF4BAY7YdgGyn442yyoPvtFuYqogeHOycvTTNTAibeXpBSpQadjo4bFGEyYwGxh/dA/D/YR6OsD7TB4XDDhhvkAjE+Dc4YlAmEPTLkhlYFkAmbGYWwGgmGYngbPLAxJ2LBicgZsIzA6CnIDhKOQy0EqAQ4T9PWzbjwzAe4Qe3gmBS47tHaCVAmBMPuoXwiAegiGNDA7x9IQBiCWcTCPgc8Djkk2THC5Qa8CySCY7GCfAK8XVCroGwLrBEyNgtcPjjGIxyGbhsAcDMlAoYdpB/SJoLMDhu1gmQR/AEZM7L2YNNArEvSpv6gztLnd1KDgFzu4XDGDwRaNxkoyZv4IJ5PJ6elph8MB/LmmUq8kEvHIZC/q9V81mf7qw1aNxr+WK/6rWHxaq7UOD09Q5Q8C+IvI5ZpIJFqqPfNEfiU14PeJiQlLRRWz2aTXq3Q6qU438CGsWu2gVqvRs8VAlVcIGAwGs9lcUc5kGRsbi0ajuVxuJTX4/f6jR4++8sore/bsOUCFECAEPjQI7Nu37/XXX8fbtdlsqVRqdWo4duyY0+lM8LKEE2FzwtyaaG1INJRa2xPtE4kJY8KoTWgrpZpjZl/YFyq9BINBPMgX80kSksZE43th1ZxolifkgURglV87Fk4EjQn3uYSroeTq6UiEHezhAW2FVF0saAmHfAXcyiixiDfhFSXmGt8Tq7mWxLwyEQvy0rESgUBAIpFgTDA8PPye1HDixIn5+XmetHlWXEaACexmdn+O+dwmZtMqNbdpE9ZV/8Vs+lvmb48xx77NfPtO5s67cnfdlb0LP3Gbt/VrzNf+OfPP+pAeYzy0p3icNarFxUV2G5NAY7HlG/jvWCyKIgUBPAR/bGva+gDzwJ8xf8bCklkFnE8yn3yMeWyamV7l5077Gdd2Rnsbo9i0oubkm9KyTZmhlfsviRn+A+M7zlgfZAx35gx3ZfV34Sdu87cO350efTToMbwH1Cz0lzBnoY4thxoJJR0xM+bNjLIKwUFk8HMlbupPMY4tTNLJT8+Kx+ODg4O7d++uYGrYxey6hbkFcgBJgACAF8APEAZYALDltzMAzCr1S8yXDjAHvpL7yidin/i66+vftH/z/qn7bw/efn36+lXl130nctw9mXtUYdXiYsznnrKaJuOxJMPk4pHgsFKpUuinZpxGtUql0Dpm58asepVKbp+cS6YyaHzpdDocDiM1fIv51g3MDRAF0AHM5YHC6s7DlYWbmJseZR59T2pwvsJoPsMMQXoAgt3g6YRAF8x3g/ssKN4B9QlYEENODszlVf8lxnMgq/tKVHqzS/yf7cJvTvf+t1D/5zJD160ivKqGD3in4oaMcXPYo0nEox6nY9Q6E4+nmFw2Fp43KJQqpWHG6RxWIea6KafbZtaqVXLHjCe1DOoMUoPpvzOK66Ji0B8HVzuEemFBCO52CPZCZggY1Z8zjp8yyVmiBk4QwKhhiRpSAGMArQCNAF0AwjwvtAFY85SB7IBuMADQC6AHiLNMgdRwMHfw/sj9W0a2nJGe6ZH0tPW17VHt+b71+/fN3Hev816e1Htc93zd/fXbFm6rylbdm7lXtaBKxMPjZnlzjdjvDefSCe+UqfZkm6ipua216+iRJmlXV1OLsLb6uEI5cL6tYz4QWE4N32S+yVJDEOAcQHsejQ4AEYAUIAIfYz72CPPIlakhMwCz9XDudTi7Ddp3Q8ducDSCqRoat4KzHdJS8LaC9BAI94GiGqL9eabQfynnPhhWfcMo+oVU3CgR9/SJz6t6d9l6vjsrvs8puZcn1SW5x933nyLSW7KKP0vnqSEWDVp00tYz0nl/JJOMO8cM9ac7u+sbuzq7jx5pkZxvP9cmrj5xTCXv7ewWBYKhi1CzUUOeGkI9cH4bnNsJmlPQvRPEe6H1CATERA2cEMIlpZeoYRFgNO/8/QCavK0jNSBBFIggDTCZd4b6vEBkiRoOZQ99b/57b2vfVqgVarVao9EoNcpOWafEJBmwDfCnnree/9fJf/1M8jMsNYRVycXIzIShpbp70uGcmbFPjxuba9qETeeEwr66E2cHOrvauqQtzaeHhiRd3eJgMLxK1IDU0ALQADAEcAagD6AbIFRU1JDph9k6EB4G2QGQnoD2XaB+G+q2Qf8xCElYaphphHOvQu1W6DoMYckSNWTm3vIq/kE3eFytWoJao1bIBjpMeoltZIBHVX9uSvZ4UvHZAjUk4gsOq6a1Xjw1PTc5Oe6w6lrqOrvPtEgk/bUnzorPt3f2yhrP1MhlQpFYGgovrEoNZ7fCyVdg4Ag0bAPpfji1FzxCooYPhBpuZW4VZAWCiEDgFwh8AkFQIHALBF6BQC8QWAWChEDACAS5ZRW/MoJC1HBf9L4nbU92mjpHxkYUFsXB4YNPTj75sP/hR4KP8Kf+IPSDuxN3fyz3MWxQKMPKaCQ8NT6iUesmnXOOKYd/3j85arVYxr3zgRn7qMU86pkPzrkmLeYRlyeIUW42m8UeZuxLKzQobmRuFKTy+GA1CQRnBILDAoFYIIgKrtag2MZoPpuTCeK9Ak+3YL5L4BcKnK2CqQaB4qjAUCsIigXZIQEjF+SG2A38xG225qOGiPp+a9/PRnTdY7YRy8iQcXDv1NCT89qHg/pH+FNDuv+zqP5qTnkTUkPIrY4uhCZGhzUaw5TLbZ90BOZ9DpvVYrX75gNTYzaLZcwbCM45J8wWk9sbSqUvQX0harg+JRV42wX+DoG5VtD2suDw84LmQ4KQRMCosUHxr9Sg4IohFpiFM8yZf2T+cTOzudT6L8y/VDPV2Nfw0cWPftn/ZWxE3D1396ejn74+e/21zLV8q8hl2NdwX/Y+fUK/sLCAHQclFTwEu8pmsjPPMs9im+ISVpnNmxc2bw5u3pzYvDm3+UHmwe3Mdg/jWeUHy4QZfw0z+g9s71qpdfxHjO9kTv+VxcGP+fq+Mt17n1vyH6PSv8jKr2cU1/KuIpcpbsia/mc8MFwe1NiHl01MMZNPM5a/u4hVdmRzRLU5oNgc02/OmjYztu8yczuZtI8r33h/eiu7GzKH/UJMNs2kF5nF4muSSaaYVKFio/oF5oUnmCfYmsvXwjb/6uPM408xT21jts3l5jAFpbTC5DJMplDx9q+MFeKJwK5mV7g7w+SSTHaxhJpbZA/BumhnZn7HTDyBNWdna2Gbr/UnjOuNXMpTGs55aewYZg3zqlixyGDXJnYSr4r2+/Ps9310BVMDWvkEM3GEObKD2VF83cfsEzNiB+MYZUYtjMXEmHSMTsNo+FwNjGEyPemKuObCc56wJxQOFR8vRLCkItqc9iBzsBiUcCS4k+nEWGwV08rGmYiCcR9gXDtKqJ63mNgwywtxMxPTMTEN/2suNrwYdS6EveFSoC78KDjYmU2FmFA3495TFEqeg0xUw2QT79uX11hBBVMDPvrQiL/MfHll2sIVcxk+w3wGx+1xfA7HO7HJzWmtylUV6vs8y9/k/mZPYs9sZDadTmUybGv2QsFvhR0XN5Zt5fdiI8IZc+7N7r2duX31vI/Upk3pSwkOJec1yNkR+1UG7S/mPug+zzi3Mqb/wahuYpQ3vp+aU1QV6vtRUsyxGd0dYZdwMRFbDvQK1PNfV+KPHTpsRkPMwUw8xahvXjUBJCl9dwKI9nOMezeTZkeReFUqmxo6mI7PM59n0w1wbDKWH4nAwXkTgGJpDAIH6tn9uBOHJHCQIgc3Mzfj4Bz2MqAPcJSngP2dVcmqO9x3/MD8gyeNTz4w/sCtoVs3ZTeVfbpbc7fuSuxyLkx5p8f7OnqnPSGM+FOJqN0w1NXe0y/XW7SyzvYeyaBuwm7q6u4Qifq9wUg2x6DxYmYOUsPu7G7sqWVTPxLsMAQ7com5DJjagMjgCA4O6+JOhChT1AhFbghS/ZAcgHgvm9EgfBNad4Crix2rzwwCDuOHeyGCQxWy/NiE7q+Y2T8xI/di673sFAZMGQr2/eWY8MHhnictPf/kFv9tSnZjju3gXC2H4n3vzGi+EHZ2p1IJbB1kkovT49bOviFvOIJxfzwS1gz2tfd0acxWq3aQhV2ms+rluCGWDftDEYzo8tTwOKP6eE4GcTGERBAUQlgE8T4I94DuBHg62J0IURazG7S3MHO7iBrWkhYxaliiBuSFGYBmgE4AQz6RoSdv/UgZaO5IE5jdgKOYLtb0l1NDVbrqbt/df+/8+wedD65h/c70dx4xPXJccby7v1soFrZJ215RvfKQ/aEHZ0s7y7ed377Xc+/HFz9+W/Y2lhqizoDT2V9/bmzGn8wyQa9fVNekVKlPHWio33dcptY3HasTn69ukwyI2mpGJl2JNNvufRc1IBdg8sIxgN357A8cxzXnh3vlAPsBqtn0sGLyGhZFYDsEyndA+irYW8DeAG3bYPw8pAYh1Al9+6H1dRC9xY7PsaZ/gRpyihsXZZ/wDNznHPi2U/pg8XV24MFx8T+pRK9J+9rFYmG/pFsheccs/PF0/3eKV1KMpGvgW/6Br6WHqvLU0BVdmJ+empiacU1OOurPd836A0i1bo+zrqVRpex9u7Gr/vAphVpTc7D+zMGTAwr9+bqOiVlvIHSRGm6KdEP/y+wg7qFfQ8t2OP8aDB8F5TEYfAP2PAcNb7K5T0QNa0kKBV2XqAFDg1mAk3mjRyJQAdTlyQIpA+MIDCIG8zsxLTJ7iRqQI/4y8ZfbbdtFRpHUKF3DKtFJOqWdmB+h0+uwaLQaiUzSq+odGB4o6Sx9w31HzEe+uvDV2zO3s9QQmfFMjp07eqpfZZyctKqGTZJzmHjTU1fX2dNYj8PrjQ3tSmnXmfPnzzefsTv9KeyhXRE1IDUgDhKAJgBjngswQ8yeJ1Pcg6D54Kbc1bMhUxIYexuatkPNc9B/CI69CM1vwkwnpDFkEILuOEgPg/oUBHrfRQ1ZxUdDQ183K48adX1GvbT4atD2K4dE8qF+nFGKeCKomBAh7e/Sq0vTc/UzaoVj8j8l5LcWooY4Zj76fT6vf9xsfKe6VjNinjBpjebRlqbGzu5zzaIBYUtDZ6ewrrZd1NLY1tHb0iKe9WDS06WoIdoNmp1gqAHRq2A7DS0vQPer4GgB/dtw7jVofRPmRZCjqGHNuaFADV9gvsDmLCQFgjmBwCUQhAUCj0AwJRAsCNhMB8xlyAgE6XzFbUbwKeZTFxsU2AvwteTXHog/8L3499awfjf63YfcD71sebnD0iG1SussdVvGtnw/+P3vxUo7y4PxB+9ZvOem7E235dioYSromPe6Rm02fJD5/R4PJjN4PZP2SbfHj4PtU3aHa84XCgZmpidmZl2RaAznTmBzETvGCg2K25jbWEBi+eyPUD7XA+HS5YGKCgQz+UyQ9FXzGjBR+rPMkGCxj01ncLcJAt2CyWbB5Fk2oyGTT2RIDy7VpaQG3V8vNSiUN2aVf76ouy9u+E58+HvF15jhuwH1/x4beNqiabAapRZ9u2Xw/3kUD0X13y1eSVGShgdS2rswuilQQzQSyk+UiPpcszbb6PSsy+eemw8EPW6XfXLKhzNS/N5Ju2OugP+EwznnC4cXcLZRKooNiiewQZHFBBCRINEviOCnROBsFphqBRGxYKFHMHtO4O8RpGUCRntrBTcocOal2+3G2Ve8KvFU3JAy/CH1hy2pLcXXZ1PPHkgdeCL1xCdTnwTMreamXrN4zcfDH/+i54t3uu/8nO9zN8ZuRPIq+1y3pW4rdEOyww24GEjRpSCP0yhFKdHzqedXopTcsmVxyxb8XAbgM6lnjqeOe1PeVX7rxWDK35GaeC41tqWE6vh9yl2TMtyfGsTkHyivJqWCaH+VT3y7W3ynR/yFsOSmxYFrylNVzFFJ9ZfiXnFkIXQR7WJgL6CNZTHmSc2dTNl/tQKl5OgWrCuhm3g+NS9MLYZ45Vx4MZjQ0dfX957Tq7xe7969e1988cXjx4/X86/U1teerD95ov5E8RXlD9Uferj+4Tvr7/x8/ecrot5df/ev6n+F91j2L3C6/nSRQKFYdX11XX3daufC3TUs5LUnSqh1J+ur99bv+1b9G1+qf/3zlVF331N/6vX6+tpyAUegqosFCvGpO13uiTg8rqamZteuXdu3bzcajatMyna5XH/605/+7d/+7ZlnnvnVBirP/Arvp8JqhcOP9lNxtcIhf9+Xj47/29/+dvVJ2T6fD5d5eeGFF5BCzlKpHARaWlqam5sbGxvPXLE0NTWhJN4W1/KVgxxd6RICaDjYmnj11VdXjxoKC8DhUi64UUbGKB2yXghg7g32h3k8HuwkukLBBiP2U+JSDgX5Kwvjf1Eem6AFeTSJ5fJzS+VdOgrymBi0XjjQectGAPuwpVJppS7lgrddMFNcyIiHBS8MLy+fVF9yKcyVLKMgDoWcPHy93fj4OC77icVqtanVBiOOvI2OFvYUCgqgGBoBdrdflEdhrdZoMJhQHnvml8vb7XZccRzlkRcuyqNKlOzrU0mlaovFukJ+ZmYGr+fy+7/42y2/RySRkpGiA7hBoIKzIdGMcJYxPqRmZ2fR/lYUtODJyUk0X9y4+C/cLpTC/lX/tXwnHljQc/nOi6pW/GvFZeCjlM2cTadL/fnQYdBdsbs7hq8uiOHPxK71hn9i+I39Wlh87OLGkgR+x6c0nhHjBWQBDAWxoYhFJlMeONC4f39rW1ufRqMr7MSCAiiGIx7L5aVS5b59LadP97711tm6uh65XG0wXJJHz8erwvvCA0dGRnCV5P5++YEDLb/7XfUf/3j8rbewHSNUKjUF5SiA7INsdfntY88W/nYFuAoYYscWRi4smWYzsYXghMOBCyiFF6KYCL4qs7wHpAUqzqUWY7OTExazBcnN6ZnH6dLF/ATp1KJ7dspmNZutNse0MxwK4ihwFhNLr1RyycWE2zmNVhIMh3EG/HtJZ9KphUAAnxflPCuKufo1lalUasDfHz0D17rVarVDQ0MKhQIXV1cqlXJc61+jwT2Y+LNt27bq6up+tFy5HFNlUAaXwcQWFDaw9+/f397ejpJY0IhNJhN+DgwMdHd3YxCFh6NaXNkFN8RiMS6t29XVhevkoYaC8t7e3tOnT+POtrY2/IoFT42egHrwE2VQEveg2+Ae9A2kMIwCCj9cLpddTERxKdJEMlUw4gup+GhTl2wGPSccCvhdkwqpTKMbjcST2XTSP2uX9Q/ph8ecU3Y57tfb3G6nVjWoUKoDCzE0SYQFD0RqQDfDK8FbUOWLWDywc2ftb35T89vf4khTFwJW2I8FvRfZBF39orxQOLBjR9Px46KXXqp57rkTe/c29vfLCsKoEJdLR3mkYzwQv+KNdnaKX3755LPPHn/hhWOvvnr6xRePHTrUIpXKC0vj4NrqSGqXGy3yBSKDShB5BArPjr8mckQiFpkdG66vPS3Fu1Iqe7uUXu98MBBYiETRA8MLCyFcmiYYGh02O5wenJuOa1gtROPJVHIhHMIMJdeUZXh8aiGejIc9ip7q/TUtAwqVZWxqIRJhD1yILOIKWahkIYoru2EaSCSWYNUuUUAmFglqFdKuxiM1LZ39fUM2k250fDYUCOYJN4wz4VEen0mpxXgoFIwnktlcdiHgFbe3dAgHVGqFZACznvwhTJZeCOPCnHhtgWA4Ho3gtQX8vslRY82hg/qR0VBscflvvaYevWbKKpga8NdCdz148CD2kj733HNvvvkmfj777LM4pPLrX/8aB1x/8pOfYCcKbuNOXC8fxV5++eWnnnrq+eef37JlC3a97ty5E+mjo6NDJpMha5w8efKPf/zjL3/5S/zE/Sj2u9/97ve///1Pf/rTHTt2oJKf/exnqBz3/OY3v/nxj3+M4zq4jXvwLO+88w7yBepBJmpoaMB/IfsUCAVZBpvcF0Ll3ELIJ2pvONNcL1QaFtAuEzG7bUSpkKs02hlfKJVZYgf0cK9zRivq7u5VtNa0TMz5Az6/rKVlQKmre7u+9XR9l0TVfKymX9LedL5toPWUZtwVTbHHFqgBXRc9E2kO+Q4LJu3t2HFq69Yz1dUimUw9OCgr7EcBvDzsbkB5dOOCfFubcPv2+qNHe155pebgwTaRSC6TyS/KIwWjPPpwQR7vVyjsra8/v3t3bW1tZ11d29atx994o7GvD4+S4e2j26ORXW6wuLNAx0i+CB3ij3yKZBFwz0jwxjpk3lAsk05jlpGsr0csEp5vamprbd59qOZMXU2HSLrn1TfrO8WDkvZTJ4+9dfKsok/cIxnobO9oOfXGnvrzk76FZHTeKK3ddujYuc4Ok316aEAsEYlam840nTm99+gZsUw1IO7pH5CIh9Q9bY1vHzl4uqnDMx9mU8sX/Bb5WZHahPSql7R3C/vO1x45Vnfm8OEjuMBe49muKftYT2vD4cMHmrukwVBwalT36q6DoxNTc7P29rbm7t7eQ/sPd0kHDbqh2trTO17bVXfi8Kmahs7zzXW1jfteerG+rq6xUxEI8f01VhVMDfgoxof8Sy+9hGM0jz/++C9+8Qt0V/z893//d3Tv1157DTeQDh599NGf//znhfFX3Ikb6PlPP/008sgPf/hDdH4MIjo7O8+dO4ejuEgZTzzxBHo70spDDz2EhyAjPPzwwyiPB/7oRz/Co7A89thjeC5khCfzpUANra2tqAcLcg128mLYgtt4hegeGK5foIaszz15fP9eHDuQqEeQGqILwSFJZ23NqfrGZsMETnxYCi7Qw30up7G/t0c4dO70WYvdjiGurPVsv0x95mRzT3MLUkZL9Zkhmailva2vtcbgcMfzgWqBGrDFhOcVCoU9+dLW1nHyZLNQiMw1KBKJCjuxoACGVCiPro6eXJDv6OhuauoWiTDyEkokUrFYclEPHovREMrjC84K8qh5//7qZ57Zu2XL7p//fM/TT+/9wx/eaWjoFApF+F/0eWQojO9WpQZkpfzp2IJYYYIN+0KUsN+sEh6vrjfaJubmkLDkp44c6JXK2huqT508/vLOmqaaUycaRCcOHO+RKpprqxsaG3a+drj15MmeQYNlxKgU1tb1qT3hRDLiNwzUv9XYYbZPYoul6dRRVNLZVIP5ezsOnTWOWM6dbdGYrIYRc3NdTffAoN5sw58D47bFiH9Y2twlN7ics8r2uvqm8y2n9x5sOnfg8J6mns7dh9/Sa5X1dQ0SmcI4OhFPxH1O+6m33uwQS/XD2mMnDnf19u3beUg5bBoSd5+sbdr7p5eP7X/j0IlGaX/H4f1HDm57pbuz7fDhetecf82e79woqlRqQDQwTEXbwh5U9FV8qmNSFkYBhcf1oUOH8Ovhw4dxbOWNN95ARsA9KIM+jP6PG7i6PophQIGNBdSAe1AMk7sKBf0cgxGUQXn8RAEUxjhi69ateArciZ9YME7Bf6Ek6kcxDBZwCHB5QYJAasBQufD+n8IviK1Z15RNrdFOzHiTbAP4PRsUGO4GfS6TTm+yTGDDwT4z43FND6v1tvFpr8c5okNjnpqf99sshuERcygSS2fwKZtGWDCMxf4RfBpjewcZ6mLBNtTyr7iNAvjcfi/5FcL4FTUg46A89kcW9CMhnj2LXRjdHR2ifBUis6DiwrHo89jawtu/3HqRK7FnodCVUygYuWAvBra80sn43NSoXKHQGoy4pB02EjQq9bDJYrOMDAypVUq5xmi1mUwao8k8rJYPyYYGh8btDp1WPWw0z06OaYdH/OFoLBIyaRVDSo0/HENYgp4ZLSoZMY9aRhRKoz8Ycs9O4PwW68SMa8ahU2utk7OJJHYJ5RajYYteozJY/PPzE2ajVjeiw/BLqZAOiOU4d2NI7nT7Zh1jWvwFXb5kGpsUmXDAZ9SpZEND+JPMuWaUCrV9yuWcGlcMDfZ1tp7et/XlV/d0SWT2iXH1oAwvQz6knQ+zDUA+lwqmhsLLtgpDdNhhjhslFQzyMWLENja+uQ8fVmjr+LUMPVc4KboQxt54kWUMUqDnoEddzL0taQN/VLw79Hl0zisM02OghK6OT3VUjhhi0+Cq8ujq2GtT6IbEJkCeF96zoH6MBbBBsWpfA5+9Yg2vLZNKBrxzcx5fMlVyV/QaXkYZqiqYGsq424o7pLxBabxNZBYkJmQ9qxWXk129YLcftjsKEU3hGY78eGX5wshlYdwRaRS7Bq4sj+MOBfmKQ54u+HJqKAxXL70pu5DyhAV/46In9ZAgIUAIVDwC6PvYVbQ85QmDawwVL1HD22+/jR372K7GZjkVQoAQ+JAggN1n2ImGN4vRZSGxEDNZsIW4RA34Hfui8X+4lwohQAh8qBBAx8c2ZqHJiVSA2zg+9f8BFTK6FdeDUZMAAAAASUVORK5CYII=";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
