/*
 * Decompiled with CFR 0.152.
 */
package users.sgeducation.lookang.Gyroscopewee_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.ode_solvers.EjsS_ODE;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;
import org.opensourcephysics.numerics.ode_solvers.rk.CashKarp45;
import org.opensourcephysics.numerics.ode_solvers.symplectic.VelocityVerletSavvy;
import org.opensourcephysics.tools.ResourceLoader;
import users.sgeducation.lookang.Gyroscopewee_pkg.GyroscopeweeSimulation;
import users.sgeducation.lookang.Gyroscopewee_pkg.GyroscopeweeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gyroscopewee
extends Model {
    public GyroscopeweeSimulation _simulation = null;
    public GyroscopeweeView _view = null;
    public Gyroscopewee _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EjsS_ODE> _privateOdesList = new Hashtable();
    public double[] q;
    public double[] qDot;
    public double t = 0.0;
    public double dt = 0.1;
    public double tol = 1.0E-8;
    public boolean useJava3D;
    public boolean showBodyTrail = true;
    public boolean showSpace = true;
    public boolean showVectors;
    public boolean showOmega;
    public boolean showRotor = true;
    public double boundingBox = 2.0;
    public double size = 2.0;
    public double m = 1.0;
    public double g = 1.0;
    public double z0 = this.size / 2.0;
    public double R = this.size / 3.0;
    public double a = 2.0 * this.R;
    public double b = 2.0 * this.R;
    public double c = this.R / 5.0;
    public double I1 = this.m * (this.b * this.b + this.c * this.c) / 20.0 + this.m * this.z0 * this.z0;
    public double I2 = this.m * (this.a * this.a + this.c * this.c) / 20.0 + this.m * this.z0 * this.z0;
    public double I3 = this.m * (this.b * this.b + this.a * this.a) / 20.0;
    public boolean showElevationPlot;
    public double axisElevation;
    public double momentumElevation;
    public double arrowScale = this.size / 4.0;
    public double tilt = 1.0471975511965976;
    public double omegaOne = 0.5;
    public double omegaThree = 20.0;
    public double[] omega;
    public double[] angularMomentum;
    public double[] torque;
    public double[] shaftTip;
    public String mode = "_";
    public double pi = Math.PI;
    public double k = 0.1;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return Gyroscopewee._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/sgeducation/lookang/Gyroscopewee.xml";
    }

    public static String _getModelDirectory() {
        return "users/sgeducation/lookang/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(896, 565);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/sgeducation/lookang/Gyroscope/Gyroscope.html");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/RigidBodyDynamics.html");
        hashSet.add("/users/sgeducation/lookang/TEXTURES/wood_planks.jpg");
        hashSet.add("/users/sgeducation/lookang/TEXTURES/metal.jpg");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/Euler_eqn.gif");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/Gyroscope.html");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/gyroscope.jpg");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/momerntum_rate_eqn.gif");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/RigidBodyDynamics.html");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/torque_body_frame.gif");
        hashSet.add("/users/sgeducation/lookang/Gyroscope/torque_eqn.gif");
        hashSet.add("/users/sgeducation/lookang/TEXTURES/metal.jpg");
        hashSet.add("/users/sgeducation/lookang/TEXTURES/wood_planks.jpg");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/sgeducation/lookang/");
        n = 0;
        boolean bl2 = false;
        try {
            if ("true".equals(System.getProperty("org.osp.launcher"))) {
                OSPRuntime.setLauncherMode(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("G:/Dropbox/Public/EJS_5.0_beta_140506/EJS_5.0 beta/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("G:/Dropbox/Public/EJS_5.0_beta_140506/EJS_5.0 beta/bin/config/");
        }
        Gyroscopewee._addHtmlPageInfo("Gyroscope", "_default_", "Gyroscope", "/users/sgeducation/lookang/Gyroscope/Gyroscope.html");
        Gyroscopewee._addHtmlPageInfo("Rigid Body Dynamics", "_default_", "Rigid Body Dynamics", "/users/sgeducation/lookang/Gyroscope/RigidBodyDynamics.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!Gyroscopewee._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        Gyroscopewee gyroscopewee = new Gyroscopewee(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!Gyroscopewee._common_initialization(stringArray)) {
            return null;
        }
        Gyroscopewee gyroscopewee = new Gyroscopewee("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)gyroscopewee._getView().getComponent("mainFrame");
    }

    public Gyroscopewee() {
        this(null, null, null, null, null, false);
    }

    public Gyroscopewee(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Gyroscopewee(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        ControlWindow.setKeepHidden(true);
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new GyroscopeweeSimulation(this, string, frame, uRL, bl);
        this._simulation.processArguments(stringArray);
        ControlWindow.setKeepHidden(false);
    }

    @Override
    public String _getClassEjsModel() {
        return Gyroscopewee._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return Gyroscopewee._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return Gyroscopewee._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.q = new double[]{1.0, 0.0, 0.0, 0.0};
        this.qDot = new double[4];
        this.t = 0.0;
        this.dt = 0.1;
        this.tol = 1.0E-8;
        this.showBodyTrail = true;
        this.showSpace = true;
        this.showRotor = true;
        this.boundingBox = 2.0;
        this.size = 2.0;
        this.m = 1.0;
        this.g = 1.0;
        this.z0 = this.size / 2.0;
        this.R = this.size / 3.0;
        this.a = 2.0 * this.R;
        this.b = 2.0 * this.R;
        this.c = this.R / 5.0;
        this.I1 = this.m * (this.b * this.b + this.c * this.c) / 20.0 + this.m * this.z0 * this.z0;
        this.I2 = this.m * (this.a * this.a + this.c * this.c) / 20.0 + this.m * this.z0 * this.z0;
        this.I3 = this.m * (this.b * this.b + this.a * this.a) / 20.0;
        this.arrowScale = this.size / 4.0;
        this.tilt = 1.0471975511965976;
        this.omegaOne = 0.5;
        this.omegaThree = 20.0;
        this.omega = new double[3];
        this.angularMomentum = new double[3];
        this.torque = new double[3];
        this.shaftTip = new double[3];
        this.mode = "_";
        this.pi = Math.PI;
        this.k = 0.1;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EjsS_ODE ejsS_ODE : this._privateOdesList.values()) {
            ejsS_ODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_initialization1;
        boolean bl2 = this._isEnabled_initialization2;
        if (bl) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution1.automaticResetSolver();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_evolution1;
        if (bl) {
            this._ODEi_evolution1.step();
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_constraints1;
        if (bl) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _freeMemory() {
        this.getSimulation().setEnded();
        this.q = null;
        this.qDot = null;
        this.omega = null;
        this.angularMomentum = null;
        this.torque = null;
        this.shaftTip = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EjsS_ODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("menulookang".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Initialize Vectors".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._automaticResetSolvers();
        }
        if ("Compute space and body frame vectors".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        if (!this.mode.equals("_")) {
            if (this.mode.equals("rotate in vertical position (no precession)")) {
                this.tilt = 0.0;
                this.omegaOne = 0.0;
            } else if (this.mode.equals("regular prescession")) {
                this.omegaOne = 0.0;
                this.omegaThree = 200.0;
                this.z0 = 1.0;
                this.tilt = this.pi / 4.0;
                this.R = 1.0;
            }
        }
    }

    public void _initialization2() {
        this.t = 0.0;
        this.I1 = this.m * (this.b * this.b + this.c * this.c) / 20.0 + this.m * this.z0 * this.z0;
        this.I2 = this.m * (this.a * this.a + this.c * this.c) / 20.0 + this.m * this.z0 * this.z0;
        this.I3 = this.m * (this.b * this.b + this.a * this.a) / 20.0;
        this.q[0] = Math.cos(this.tilt / 2.0);
        this.q[1] = Math.sin(this.tilt / 2.0);
        this.q[2] = 0.0;
        this.q[3] = 0.0;
        this.omega[0] = this.omegaOne;
        this.omega[1] = 0.0;
        this.omega[2] = this.omegaThree;
        this.qDot[0] = 0.5 * (-this.q[1] * this.omega[0] - this.q[2] * this.omega[1] - this.q[3] * this.omega[2]);
        this.qDot[1] = 0.5 * (this.q[0] * this.omega[0] - this.q[3] * this.omega[1] + this.q[2] * this.omega[2]);
        this.qDot[2] = 0.5 * (this.q[3] * this.omega[0] + this.q[0] * this.omega[1] - this.q[1] * this.omega[2]);
        this.qDot[3] = 0.5 * (-this.q[2] * this.omega[0] + this.q[1] * this.omega[1] + this.q[0] * this.omega[2]);
        this._view.gravityCheck.setSelected(this.g == 1.0);
    }

    public void _constraints1() {
        double d = 1.0 / Math.sqrt(this.q[0] * this.q[0] + this.q[1] * this.q[1] + this.q[2] * this.q[2] + this.q[3] * this.q[3]);
        this.q[0] = this.q[0] * d;
        this.q[1] = this.q[1] * d;
        this.q[2] = this.q[2] * d;
        this.q[3] = this.q[3] * d;
        this.omega[0] = 2.0 * (-this.q[1] * this.qDot[0] + this.q[0] * this.qDot[1] + this.q[3] * this.qDot[2] - this.q[2] * this.qDot[3]);
        this.omega[1] = 2.0 * (-this.q[2] * this.qDot[0] - this.q[3] * this.qDot[1] + this.q[0] * this.qDot[2] + this.q[1] * this.qDot[3]);
        this.omega[2] = 2.0 * (-this.q[3] * this.qDot[0] + this.q[2] * this.qDot[1] - this.q[1] * this.qDot[2] + this.q[0] * this.qDot[3]);
        double[] dArray = new double[]{this.omega[0] * this.I1, this.omega[1] * this.I2, this.omega[2] * this.I3};
        this.angularMomentum[0] = dArray[0] * this.arrowScale;
        this.angularMomentum[1] = dArray[1] * this.arrowScale;
        this.angularMomentum[2] = dArray[2] * this.arrowScale;
        this._view.quaternion3D.setCoordinates(this.q[0], this.q[1], this.q[2], this.q[3]);
        double[] dArray2 = this._view.rotorGroup.toSpaceFrame(new double[]{0.0, 0.0, 1.0});
        this.shaftTip[0] = dArray2[0] * this.size;
        this.shaftTip[1] = dArray2[1] * this.size;
        this.shaftTip[2] = dArray2[2] * this.size;
        double[] dArray3 = this._view.rotorGroup.toBodyFrame(new double[]{0.0, 0.0, 1.0});
        this.torque[0] = this.m * this.g * dArray3[1] * this.z0;
        this.torque[1] = -this.m * this.g * dArray3[0] * this.z0;
        this.torque[2] = 0.0;
        this.axisElevation = Math.acos(dArray2[2]);
        double d2 = dArray[0] * dArray3[0] + dArray[1] * dArray3[1] + dArray[2] * dArray3[2];
        this.momentumElevation = Math.acos(d2 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]));
    }

    public double _method_for_spaceViewDrawingPanel3D_minimumX() {
        return -this.boundingBox;
    }

    public double _method_for_spaceViewDrawingPanel3D_minimumY() {
        return -this.boundingBox;
    }

    public double _method_for_spaceViewDrawingPanel3D_minimumZ() {
        return -this.boundingBox;
    }

    public int _method_for_spaceViewDrawingPanel3D_implementation() {
        return this.useJava3D ? 1 : 0;
    }

    public double _method_for_shaft_z() {
        return 0.75 * this.size / 2.0;
    }

    public double _method_for_shaft_sizeX() {
        return this.size / 40.0;
    }

    public double _method_for_shaft_sizeY() {
        return this.size / 40.0;
    }

    public double _method_for_shaft_sizeZ() {
        return 0.75 * this.size;
    }

    public double _method_for_angularMomentumText_x() {
        return this.angularMomentum[0] * 1.1;
    }

    public double _method_for_angularMomentumText_y() {
        return this.angularMomentum[1] * 1.1;
    }

    public double _method_for_angularMomentumText_z() {
        return this.angularMomentum[2] * 1.1;
    }

    public double _method_for_trail3D_inputX() {
        return this.angularMomentum[0];
    }

    public double _method_for_trail3D_inputY() {
        return this.angularMomentum[1];
    }

    public double _method_for_trail3D_inputZ() {
        return this.angularMomentum[2];
    }

    public boolean _method_for_torqueVector_visible() {
        return this.g != 0.0;
    }

    public double _method_for_torqueText_x() {
        return this.angularMomentum[0] * 1.1 + this.torque[0];
    }

    public double _method_for_torqueText_y() {
        return this.angularMomentum[1] * 1.1 + this.torque[1];
    }

    public double _method_for_torqueText_z() {
        return this.angularMomentum[2] * 1.1;
    }

    public boolean _method_for_torqueText_visible() {
        return this.g != 0.0;
    }

    public double _method_for_omegaVector_sizeX() {
        return this.omega[0] / 10.0;
    }

    public double _method_for_omegaVector_sizeY() {
        return this.omega[1] / 10.0;
    }

    public double _method_for_omegaVector_sizeZ() {
        return this.omega[2] / 10.0;
    }

    public double _method_for_omegaText_x() {
        return this.omega[0] / 10.0 * 1.1;
    }

    public double _method_for_omegaText_y() {
        return this.omega[1] / 10.0 * 1.1;
    }

    public double _method_for_omegaText_z() {
        return this.omega[2] / 10.0 * 1.1;
    }

    public double _method_for_baseCylinder_z() {
        return -this.size / 2.0;
    }

    public double _method_for_baseCylinder_sizeX() {
        return 0.75 * this.size;
    }

    public double _method_for_baseCylinder_sizeY() {
        return 0.75 * this.size;
    }

    public double _method_for_postCylinder_z() {
        return -this.size / 4.0;
    }

    public double _method_for_postCylinder_sizeX() {
        return this.size / 20.0;
    }

    public double _method_for_postCylinder_sizeY() {
        return this.size / 20.0;
    }

    public double _method_for_postCylinder_sizeZ() {
        return this.size / 2.0;
    }

    public double _method_for_shaftTrail_inputX() {
        return this.shaftTip[0];
    }

    public double _method_for_shaftTrail_inputY() {
        return this.shaftTip[1];
    }

    public double _method_for_shaftTrail_inputZ() {
        return this.shaftTip[2];
    }

    public double _method_for_xArrow3D2_y() {
        return -this.size;
    }

    public double _method_for_xArrow3D2_sizeX() {
        return this.size / 3.0;
    }

    public double _method_for_yArrow3D2_y() {
        return -this.size;
    }

    public double _method_for_yArrow3D2_sizeY() {
        return this.size / 3.0;
    }

    public double _method_for_zArrow3D2_y() {
        return -this.size;
    }

    public double _method_for_zArrow3D2_sizeZ() {
        return this.size / 3.0;
    }

    public double _method_for_xText2_x() {
        return this.size / 2.0;
    }

    public double _method_for_xText2_y() {
        return -this.size;
    }

    public double _method_for_yText2_y() {
        return -this.size / 2.0;
    }

    public double _method_for_zText2_y() {
        return -this.size;
    }

    public double _method_for_zText2_z() {
        return this.size / 2.0;
    }

    public void _method_for_ComboBox_action() {
        this._initialize();
    }

    public boolean _method_for_j3dCheck_enabled() {
        return this._isPaused();
    }

    public void _method_for_radiusField_action() {
        this.R = Math.max(0.1, this.R);
        this.R = Math.min(this.size, this.R);
        this.a = this.b = 2.0 * this.R;
        this.c = this.R / 5.0;
        this._initialize();
    }

    public void _method_for_slider_pressaction() {
        this.R = Math.max(0.1, this.R);
        this.R = Math.min(this.size, this.R);
        this.a = this.b = 2.0 * this.R;
        this.c = this.R / 5.0;
        this._initialize();
    }

    public void _method_for_slider_dragaction() {
        this.R = Math.max(0.1, this.R);
        this.R = Math.min(this.size, this.R);
        this.a = this.b = 2.0 * this.R;
        this.c = this.R / 5.0;
        this._initialize();
    }

    public void _method_for_z0Field_action() {
        this.z0 = Math.max(0.0, this.z0);
        this.z0 = Math.min(0.75 * this.size, this.z0);
        this._initialize();
    }

    public void _method_for_slider2_pressaction() {
        this.z0 = Math.max(0.0, this.z0);
        this.z0 = Math.min(0.75 * this.size, this.z0);
        this._initialize();
    }

    public void _method_for_slider2_dragaction() {
        this.z0 = Math.max(0.0, this.z0);
        this.z0 = Math.min(0.75 * this.size, this.z0);
        this._initialize();
    }

    public void _method_for_tiltField_action() {
        this._initialize();
    }

    public void _method_for_slider3_pressaction() {
        this._initialize();
    }

    public void _method_for_slider3_dragaction() {
        this._initialize();
    }

    public void _method_for_omegaOneField_action() {
        this.omegaOne = Math.max(0.0, this.omegaOne);
        this.omegaOne = Math.min(200.0, this.omegaOne);
        this._initialize();
    }

    public void _method_for_slider4_pressaction() {
        this.omegaOne = Math.max(0.0, this.omegaOne);
        this.omegaOne = Math.min(200.0, this.omegaOne);
        this._initialize();
    }

    public void _method_for_slider4_dragaction() {
        this.omegaOne = Math.max(0.0, this.omegaOne);
        this.omegaOne = Math.min(200.0, this.omegaOne);
        this._initialize();
    }

    public void _method_for_omegaThreeField_action() {
        this.omegaThree = Math.max(0.0, this.omegaThree);
        this.omegaThree = Math.min(200.0, this.omegaThree);
        this._initialize();
    }

    public void _method_for_slider5_pressaction() {
        this.omegaThree = Math.max(0.0, this.omegaThree);
        this.omegaThree = Math.min(200.0, this.omegaThree);
        this._initialize();
    }

    public void _method_for_slider5_dragaction() {
        this.omegaThree = Math.max(0.0, this.omegaThree);
        this.omegaThree = Math.min(200.0, this.omegaThree);
        this._initialize();
    }

    public void _method_for_dtField_action() {
        this.dt = Math.max(this.dt, 0.01);
        this.dt = Math.min(this.dt, 1.0);
        this._initialize();
    }

    public void _method_for_slider6_pressaction() {
        this.dt = Math.max(this.dt, 0.01);
        this.dt = Math.min(this.dt, 1.0);
        this._initialize();
    }

    public void _method_for_slider6_dragaction() {
        this.dt = Math.max(this.dt, 0.01);
        this.dt = Math.min(this.dt, 1.0);
        this._initialize();
    }

    public void _method_for_gravityCheck_actionon() {
        this.g = 1.0;
    }

    public void _method_for_gravityCheck_actionoff() {
        this.g = 0.0;
    }

    public void _method_for_startButton_actionOn() {
        this._play();
    }

    public void _method_for_startButton_actionOff() {
        this._pause();
    }

    public void _method_for_stepButton_action() {
        this._step();
    }

    public void _method_for_resetTimeButton_action() {
        this._initialize();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements EjsS_ODE,
    VelocityVerletSavvy {
        private SolverEngine __solver = null;
        private InterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;
        private double[] _q;
        private double[] _qDot;

        _ODE_evolution1() {
            this.__instantiateSolver();
            Gyroscopewee.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public InterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.ode_solvers.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[1 + Gyroscopewee.this.q.length + Gyroscopewee.this.qDot.length];
            this._q = new double[Gyroscopewee.this.q.length];
            this._qDot = new double[Gyroscopewee.this.qDot.length];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (SolverEngine)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new InterpolatorEventSolver(this.__solver, this);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            if (this.__arraysChanged()) {
                this.__instantiateSolver();
                this.initializeSolver();
                return;
            }
            this.__pushState();
            this.__eventSolver.initialize(Gyroscopewee.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(Gyroscopewee.this.tol, Gyroscopewee.this.tol);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n;
            int n2 = 0;
            if (!this.__mustReinitialize) {
                int n3 = n2;
                for (n = 0; n < Gyroscopewee.this.q.length; ++n) {
                    if (this.__state[n3++] == Gyroscopewee.this.q[n] && this.__state[n3++] == Gyroscopewee.this.qDot[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            for (n = 0; n < Gyroscopewee.this.q.length; ++n) {
                this.__state[n2++] = Gyroscopewee.this.q[n];
                this.__state[n2++] = Gyroscopewee.this.qDot[n];
            }
            if (this.__state[n2] != Gyroscopewee.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n2++] = Gyroscopewee.this.t;
        }

        private boolean __arraysChanged() {
            if (Gyroscopewee.this.q.length != this._q.length) {
                return true;
            }
            return Gyroscopewee.this.qDot.length != this._qDot.length;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(Gyroscopewee.this._view.getComponent(Gyroscopewee.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                Gyroscopewee.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (Gyroscopewee.this.dt == 0.0) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            if (this.__arraysChanged()) {
                this.__instantiateSolver();
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(Gyroscopewee.this.dt);
            this.__eventSolver.setInternalStepSize(Gyroscopewee.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(Gyroscopewee.this.tol, Gyroscopewee.this.tol);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            for (int i = 0; i < Gyroscopewee.this.q.length; ++i) {
                Gyroscopewee.this.q[i] = this.__state[n++];
                Gyroscopewee.this.qDot[i] = this.__state[n++];
            }
            Gyroscopewee.this.t = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            dArray2[dArray2.length - 1] = 0.0;
            int n2 = -1;
            int n3 = 0;
            double[] dArray3 = this._q;
            double[] dArray4 = this._qDot;
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = dArray[n3++];
                dArray4[i] = dArray[n3++];
            }
            double d = dArray[n3++];
            double[] dArray5 = new Quaternion(dArray3[0], dArray3[1], dArray3[2], dArray3[3]).inverse(new double[]{0.0, 0.0, -Gyroscopewee.this.m * Gyroscopewee.this.g});
            double d2 = -dArray5[1] * Gyroscopewee.this.z0;
            double d3 = dArray5[0] * Gyroscopewee.this.z0;
            double d4 = 0.0;
            double d5 = 2.0 * (-dArray3[1] * dArray4[0] + dArray3[0] * dArray4[1] + dArray3[3] * dArray4[2] - dArray3[2] * dArray4[3]);
            double d6 = 2.0 * (-dArray3[2] * dArray4[0] - dArray3[3] * dArray4[1] + dArray3[0] * dArray4[2] + dArray3[1] * dArray4[3]);
            double d7 = 2.0 * (-dArray3[3] * dArray4[0] + dArray3[2] * dArray4[1] - dArray3[1] * dArray4[2] + dArray3[0] * dArray4[3]);
            double d8 = (d2 + (Gyroscopewee.this.I2 - Gyroscopewee.this.I3) * d7 * d6) / Gyroscopewee.this.I1;
            double d9 = (d3 + (Gyroscopewee.this.I3 - Gyroscopewee.this.I1) * d5 * d7) / Gyroscopewee.this.I2;
            double d10 = (d4 + (Gyroscopewee.this.I1 - Gyroscopewee.this.I2) * d6 * d5) / Gyroscopewee.this.I3;
            double[] dArray6 = new double[4];
            double d11 = 0.0;
            for (n = 0; n < 4; ++n) {
                d11 += dArray4[n] * dArray4[n];
            }
            d11 = -2.0 * d11;
            dArray6[0] = 0.5 * (-dArray3[1] * d8 - dArray3[2] * d9 - dArray3[3] * d10 + dArray3[0] * d11);
            dArray6[1] = 0.5 * (dArray3[0] * d8 - dArray3[3] * d9 + dArray3[2] * d10 + dArray3[1] * d11);
            dArray6[2] = 0.5 * (dArray3[3] * d8 + dArray3[0] * d9 - dArray3[1] * d10 + dArray3[2] * d11);
            dArray6[3] = 0.5 * (-dArray3[2] * d8 + dArray3[1] * d9 + dArray3[0] * d10 + dArray3[3] * d11);
            n = 0;
            for (int i = 0; i < dArray3.length; ++i) {
                dArray2[n++] = dArray4[i];
                dArray2[n++] = dArray6[i];
            }
            dArray2[n++] = 1.0;
        }
    }
}

