/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.ElementSegment;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class Decoration {
    private static final int AXIS_DIVISIONS = 10;
    private DrawingPanel3D panel;
    private List<Element> list = new ArrayList<Element>();
    private ElementArrow xAxis;
    private ElementArrow yAxis;
    private ElementArrow zAxis;
    private ElementText xText;
    private ElementText yText;
    private ElementText zText;
    private Element[] boxSides = new Element[12];
    private int trackersVisible;
    private ElementSegment[] trackerLines = new ElementSegment[9];

    public Decoration(DrawingPanel3D _panel) {
        this.panel = _panel;
        Resolution axesRes = new Resolution(10, 1, 1);
        int i = 0;
        int n = this.boxSides.length;
        while (i < n) {
            ElementSegment segment = new ElementSegment();
            segment.getStyle().setResolution(axesRes);
            this.list.add(segment);
            this.boxSides[i] = segment;
            ++i;
        }
        String[] axesLabels = this.panel.getVisualizationHints().getAxesLabels();
        this.xAxis = new ElementArrow();
        this.xAxis.getStyle().setResolution(axesRes);
        this.list.add(this.xAxis);
        this.xText = new ElementText();
        this.xText.setText(axesLabels[0]);
        this.xText.getStyle().setRelativePosition(0);
        this.list.add(this.xText);
        this.yAxis = new ElementArrow();
        this.yAxis.getStyle().setResolution(axesRes);
        this.list.add(this.yAxis);
        this.yText = new ElementText();
        this.yText.setText(axesLabels[1]);
        this.yText.getStyle().setRelativePosition(0);
        this.list.add(this.yText);
        this.zAxis = new ElementArrow();
        this.zAxis.getStyle().setResolution(axesRes);
        this.list.add(this.zAxis);
        this.zText = new ElementText();
        this.zText.setText(axesLabels[2]);
        this.zText.getStyle().setRelativePosition(0);
        this.list.add(this.zText);
        int i2 = 0;
        while (i2 < this.trackerLines.length) {
            this.trackerLines[i2] = new ElementSegment();
            this.trackerLines[i2].setVisible(false);
            this.list.add(this.trackerLines[i2]);
            ++i2;
        }
        this.setCursorMode();
        this.adjustColors();
        this.adjustFont();
        this.updateType();
        this.reset();
    }

    public void adjustColors() {
        Color zAxisColor;
        Color yAxisColor;
        Color xAxisColor;
        Color linesColor = this.panel.getVisualizationHints().getForegroundColor();
        if (this.isDarkBackground()) {
            xAxisColor = Color.ORANGE;
            yAxisColor = Color.YELLOW;
            zAxisColor = Color.CYAN;
        } else {
            xAxisColor = new Color(128, 0, 0);
            yAxisColor = new Color(0, 128, 0);
            zAxisColor = new Color(0, 0, 255);
        }
        Element[] elementArray = this.boxSides;
        int n = this.boxSides.length;
        int n2 = 0;
        while (n2 < n) {
            Element el = elementArray[n2];
            el.getStyle().setLineColor(linesColor);
            ++n2;
        }
        this.boxSides[0].getStyle().setLineColor(xAxisColor);
        this.boxSides[3].getStyle().setLineColor(yAxisColor);
        this.boxSides[8].getStyle().setLineColor(zAxisColor);
        this.xAxis.getStyle().setLineColor(linesColor);
        this.yAxis.getStyle().setLineColor(linesColor);
        this.zAxis.getStyle().setLineColor(linesColor);
        this.xAxis.getStyle().setFillColor(xAxisColor);
        this.yAxis.getStyle().setFillColor(yAxisColor);
        this.zAxis.getStyle().setFillColor(zAxisColor);
        this.xText.getStyle().setLineColor(linesColor);
        this.yText.getStyle().setLineColor(linesColor);
        this.zText.getStyle().setLineColor(linesColor);
    }

    public void adjustFont() {
        Font font = this.panel.getVisualizationHints().getFont();
        this.xText.setFont(font);
        this.yText.setFont(font);
        this.zText.setFont(font);
    }

    public List<Element> getElementList() {
        return this.list;
    }

    public void updateAxesLabels() {
        String[] labels = this.panel.getVisualizationHints().getAxesLabels();
        this.xText.setText(labels[0]);
        this.yText.setText(labels[1]);
        this.zText.setText(labels[2]);
    }

    public void updateType() {
        switch (this.panel.getVisualizationHints().getDecorationType()) {
            case 0: {
                int i = 0;
                int n = this.boxSides.length;
                while (i < n) {
                    this.boxSides[i].setVisible(false);
                    ++i;
                }
                this.xAxis.setVisible(false);
                this.yAxis.setVisible(false);
                this.zAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yText.setVisible(false);
                this.zText.setVisible(false);
                break;
            }
            case 1: 
            case 3: {
                int i = 0;
                int n = this.boxSides.length;
                while (i < n) {
                    this.boxSides[i].setVisible(false);
                    ++i;
                }
                this.xAxis.setVisible(true);
                this.yAxis.setVisible(true);
                this.zAxis.setVisible(true);
                this.xText.setVisible(true);
                this.yText.setVisible(true);
                this.zText.setVisible(true);
                break;
            }
            default: {
                int i = 0;
                int n = this.boxSides.length;
                while (i < n) {
                    this.boxSides[i].setVisible(true);
                    ++i;
                }
                this.xAxis.setVisible(false);
                this.yAxis.setVisible(false);
                this.zAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yText.setVisible(false);
                this.zText.setVisible(false);
            }
        }
    }

    public void reset() {
        double xmin = this.panel.getPreferredMinX();
        double xmax = this.panel.getPreferredMaxX();
        double ymin = this.panel.getPreferredMinY();
        double ymax = this.panel.getPreferredMaxY();
        double zmin = this.panel.getPreferredMinZ();
        double zmax = this.panel.getPreferredMaxZ();
        double dx = xmax - xmin;
        double dy = ymax - ymin;
        double dz = zmax - zmin;
        this.boxSides[0].setXYZ(xmin, ymin, zmin);
        this.boxSides[0].setSizeXYZ(dx, 0.0, 0.0);
        this.boxSides[1].setXYZ(xmax, ymin, zmin);
        this.boxSides[1].setSizeXYZ(0.0, dy, 0.0);
        this.boxSides[2].setXYZ(xmin, ymax, zmin);
        this.boxSides[2].setSizeXYZ(dx, 0.0, 0.0);
        this.boxSides[3].setXYZ(xmin, ymin, zmin);
        this.boxSides[3].setSizeXYZ(0.0, dy, 0.0);
        this.boxSides[4].setXYZ(xmin, ymin, zmax);
        this.boxSides[4].setSizeXYZ(dx, 0.0, 0.0);
        this.boxSides[5].setXYZ(xmax, ymin, zmax);
        this.boxSides[5].setSizeXYZ(0.0, dy, 0.0);
        this.boxSides[6].setXYZ(xmin, ymax, zmax);
        this.boxSides[6].setSizeXYZ(dx, 0.0, 0.0);
        this.boxSides[7].setXYZ(xmin, ymin, zmax);
        this.boxSides[7].setSizeXYZ(0.0, dy, 0.0);
        this.boxSides[8].setXYZ(xmin, ymin, zmin);
        this.boxSides[8].setSizeXYZ(0.0, 0.0, dz);
        this.boxSides[9].setXYZ(xmax, ymin, zmin);
        this.boxSides[9].setSizeXYZ(0.0, 0.0, dz);
        this.boxSides[10].setXYZ(xmax, ymax, zmin);
        this.boxSides[10].setSizeXYZ(0.0, 0.0, dz);
        this.boxSides[11].setXYZ(xmin, ymax, zmin);
        this.boxSides[11].setSizeXYZ(0.0, 0.0, dz);
        switch (this.panel.getVisualizationHints().getDecorationType()) {
            default: {
                this.xAxis.setXYZ(xmin, ymin, zmin);
                this.xAxis.setSizeXYZ(dx, 0.0, 0.0);
                this.xText.setXYZ(xmax + dx * 0.04, ymin, zmin);
                this.yAxis.setXYZ(xmin, ymin, zmin);
                this.yAxis.setSizeXYZ(0.0, dy, 0.0);
                this.yText.setXYZ(xmin, ymax + dy * 0.04, zmin);
                this.zAxis.setXYZ(xmin, ymin, zmin);
                this.zAxis.setSizeXYZ(0.0, 0.0, dz);
                this.zText.setXYZ(xmin, ymin, zmax + dz * 0.05);
                break;
            }
            case 3: {
                double cx = (xmin + xmax) / 2.0;
                double cy = (ymin + ymax) / 2.0;
                double cz = (zmin + zmax) / 2.0;
                this.xAxis.setXYZ(cx, cy, cz);
                this.xAxis.setSizeXYZ(dx / 2.0, 0.0, 0.0);
                this.xText.setXYZ(xmax + dx * 0.04, cy, cz);
                this.yAxis.setXYZ(cx, cy, cz);
                this.yAxis.setSizeXYZ(0.0, dy / 2.0, 0.0);
                this.yText.setXYZ(cx, ymax + dy * 0.04, cz);
                this.zAxis.setXYZ(cx, cy, cz);
                this.zAxis.setSizeXYZ(0.0, 0.0, dz / 2.0);
                this.zText.setXYZ(cx, cy, zmax + dz * 0.05);
            }
        }
    }

    private boolean isDarkBackground() {
        if (this.panel.getVisualizationHints().getBackgroundImage() != null) {
            return false;
        }
        Color bkgd = this.panel.getVisualizationHints().getBackgroundColor();
        return bkgd.getRed() < 128 && bkgd.getGreen() < 128 && bkgd.getBlue() < 128;
    }

    public void setCursorMode() {
        switch (this.panel.getVisualizationHints().getCursorType()) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
                break;
            }
            case 3: {
                this.trackersVisible = 3;
            }
        }
    }

    public void positionTrackers(double[] _point) {
        boolean visibles = _point != null;
        int i = 0;
        int n = this.trackerLines.length;
        while (i < n) {
            if (i < this.trackersVisible) {
                this.trackerLines[i].setVisible(visibles);
            } else {
                this.trackerLines[i].setVisible(false);
            }
            ++i;
        }
        if (!visibles) {
            return;
        }
        double xmin = this.panel.getPreferredMinX();
        double xmax = this.panel.getPreferredMaxX();
        double ymin = this.panel.getPreferredMinY();
        double ymax = this.panel.getPreferredMaxY();
        double zmin = this.panel.getPreferredMinZ();
        double zmax = this.panel.getPreferredMaxZ();
        switch (this.panel.getVisualizationHints().getCursorType()) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(_point[0], ymin, zmin);
                this.trackerLines[0].setSizeXYZ(0.0, _point[1] - ymin, 0.0);
                this.trackerLines[1].setXYZ(xmin, _point[1], zmin);
                this.trackerLines[1].setSizeXYZ(_point[0] - xmin, 0.0, 0.0);
                this.trackerLines[2].setXYZ(_point[0], _point[1], zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, _point[2] - zmin);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(xmin, _point[1], _point[2]);
                this.trackerLines[0].setSizeXYZ(_point[0] - xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(_point[0], ymin, _point[2]);
                this.trackerLines[1].setSizeXYZ(0.0, _point[1] - ymin, 0.0);
                this.trackerLines[2].setXYZ(_point[0], _point[1], zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, _point[2] - zmin);
                this.trackerLines[3].setXYZ(_point[0], ymin, zmin);
                this.trackerLines[3].setSizeXYZ(0.0, _point[1] - ymin, 0.0);
                this.trackerLines[4].setXYZ(xmin, _point[1], zmin);
                this.trackerLines[4].setSizeXYZ(_point[0] - xmin, 0.0, 0.0);
                this.trackerLines[5].setXYZ(_point[0], ymin, zmin);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, _point[2] - zmin);
                this.trackerLines[6].setXYZ(xmin, ymin, _point[2]);
                this.trackerLines[6].setSizeXYZ(_point[0] - xmin, 0.0, 0.0);
                this.trackerLines[7].setXYZ(xmin, _point[1], zmin);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, _point[2] - zmin);
                this.trackerLines[8].setXYZ(xmin, ymin, _point[2]);
                this.trackerLines[8].setSizeXYZ(0.0, _point[1] - ymin, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(xmin, _point[1], _point[2]);
                this.trackerLines[0].setSizeXYZ(xmax - xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(_point[0], ymin, _point[2]);
                this.trackerLines[1].setSizeXYZ(0.0, ymax - ymin, 0.0);
                this.trackerLines[2].setXYZ(_point[0], _point[1], zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, zmax - zmin);
            }
        }
    }

    public ElementArrow getXAxis() {
        return this.xAxis;
    }

    public ElementArrow getYAxis() {
        return this.yAxis;
    }

    public ElementArrow getZAxis() {
        return this.zAxis;
    }
}

