/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d.utils;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.utils.ControlTransformation3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.utils.transformations.QuaternionRotation;
import org.opensourcephysics.numerics.Transformation;

public class ControlQuaternionTransformation
extends ControlTransformation3D {
    private static final int QUATERNION_ADDED = 6;
    protected QuaternionRotation quaternion;
    protected double[] origin;
    private double q0;
    private double q1;
    private double q2;
    private double q3;
    private static List<String> infoList = null;

    @Override
    protected Transformation createTransformation() {
        this.origin = new double[]{0.0, 0.0, 0.0};
        this.q0 = 1.0;
        this.q3 = 0.0;
        this.q2 = 0.0;
        this.q1 = 0.0;
        this.quaternion = new QuaternionRotation(this.q0, this.q1, this.q2, this.q3);
        return this.quaternion;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.utils.transformations.QuaternionRotation";
    }

    @Override
    protected void setAffectedElement(Element element) {
        this.quaternion.setElement(element);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("origin");
            infoList.add("q");
            infoList.add("q0");
            infoList.add("q1");
            infoList.add("q2");
            infoList.add("q3");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("origin")) {
            return "double[]";
        }
        if (_property.equals("q")) {
            return "double[]";
        }
        if (_property.equals("q0")) {
            return "double";
        }
        if (_property.equals("q1")) {
            return "double";
        }
        if (_property.equals("q2")) {
            return "double";
        }
        if (_property.equals("q3")) {
            return "double";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                double[] newOrigin = null;
                if (_value.getObject() instanceof double[]) {
                    newOrigin = (double[])_value.getObject();
                } else if (_value.getObject() instanceof int[]) {
                    int[] newOriginInt = (int[])_value.getObject();
                    newOrigin = new double[]{newOriginInt[0], newOriginInt[1], newOriginInt[2]};
                }
                if (newOrigin == null || newOrigin.equals(this.origin)) break;
                System.arraycopy(newOrigin, 0, this.origin, 0, 3);
                this.quaternion.setOrigin(newOrigin);
                break;
            }
            case 1: {
                boolean changed = false;
                if (_value.getObject() instanceof double[]) {
                    double[] q = (double[])_value.getObject();
                    if (this.q0 != q[0]) {
                        this.q0 = q[0];
                        changed = true;
                    }
                    if (this.q1 != q[1]) {
                        this.q1 = q[1];
                        changed = true;
                    }
                    if (this.q2 != q[2]) {
                        this.q2 = q[2];
                        changed = true;
                    }
                    if (this.q3 != q[3]) {
                        this.q3 = q[3];
                        changed = true;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] q = (int[])_value.getObject();
                    if (this.q0 != (double)q[0]) {
                        this.q0 = q[0];
                        changed = true;
                    }
                    if (this.q1 != (double)q[1]) {
                        this.q1 = q[1];
                        changed = true;
                    }
                    if (this.q2 != (double)q[2]) {
                        this.q2 = q[2];
                        changed = true;
                    }
                    if (this.q3 != (double)q[3]) {
                        this.q3 = q[3];
                        changed = true;
                    }
                }
                if (!changed) break;
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 2: {
                if (_value.getDouble() == this.q0) break;
                this.q0 = _value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 3: {
                if (_value.getDouble() == this.q1) break;
                this.q1 = _value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 4: {
                if (_value.getDouble() == this.q2) break;
                this.q2 = _value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 5: {
                if (_value.getDouble() == this.q3) break;
                this.q3 = _value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            default: {
                super.setValue(_index - 6, _value);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.origin = new double[]{0.0, 0.0, 0.0};
                this.quaternion.setOrigin(this.origin);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.q0 = 1.0;
                this.quaternion.setCoordinates(1.0, this.q1, this.q2, this.q3);
                break;
            }
            case 3: {
                this.q1 = 0.0;
                this.quaternion.setCoordinates(this.q0, 0.0, this.q2, this.q3);
                break;
            }
            case 4: {
                this.q2 = 0.0;
                this.quaternion.setCoordinates(this.q0, this.q1, 0.0, this.q3);
                break;
            }
            case 5: {
                this.q3 = 0.0;
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, 0.0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 6);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "new double[]{0,0,0}";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "1";
            }
            case 3: {
                return "0";
            }
            case 4: {
                return "0";
            }
            case 5: {
                return "0";
            }
        }
        return super.getDefaultValueString(_index - 6);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(_index - 6);
    }

    @Override
    public Object clone() {
        ControlQuaternionTransformation ct = new ControlQuaternionTransformation();
        ct.enabled = this.enabled;
        ct.transformation = (Transformation)this.transformation.clone();
        ct.myParent = null;
        ct.quaternion = (QuaternionRotation)ct.transformation;
        ct.origin = (double[])this.origin.clone();
        ct.q0 = this.q0;
        ct.q1 = this.q1;
        ct.q2 = this.q2;
        ct.q3 = this.q3;
        return ct;
    }
}

