/*
 * Decompiled with CFR 0.152.
 */
package users.swarthmore.abug.UnitVectors_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.tools.ResourceLoader;
import users.swarthmore.abug.UnitVectors_pkg.UnitVectorsSimulation;
import users.swarthmore.abug.UnitVectors_pkg.UnitVectorsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitVectors
extends AbstractModel {
    public UnitVectorsSimulation _simulation = null;
    public UnitVectorsView _view = null;
    public UnitVectors _model = this;
    public double t = 0.0;
    public double dt = 0.01;
    public double theta = 0.0;
    public double omega = 2.0;
    public double r = 0.5;
    public double theta2 = 0.0;
    public double omega2 = 2.0;
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/swarthmore/abug/UnitVectors.xml";
    }

    public static String _getModelDirectory() {
        return "users/swarthmore/abug/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/swarthmore/abug/ladybug.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/rHat1.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/thetaHat1.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/rHat2.gif");
        hashSet.add("users/swarthmore/abug/Answer2.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/rHat.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/jHat.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/thetaHat2.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/iHat.gif");
        hashSet.add("users/swarthmore/abug/Answer1.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/r.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/thetaHat.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/swarthmore/abug/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
        }
        UnitVectors unitVectors = new UnitVectors(stringArray);
    }

    public UnitVectors() {
        this(null, null, null, null, null, false);
    }

    public UnitVectors(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public UnitVectors(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new UnitVectorsSimulation(this, string, frame, uRL, bl);
        this._view = (UnitVectorsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _constraints1() {
        if (this.theta > 2.5943951023931953) {
            this._pause();
        }
        if (this.theta2 > 0.42) {
            this.omega2 = 0.0;
        }
    }

    public double _method_for_rHat_x() {
        return this.r * Math.cos(this.theta);
    }

    public double _method_for_rHat_y() {
        return this.r * Math.sin(this.theta);
    }

    public double _method_for_rHat_sizex() {
        return 0.3 * Math.cos(this.theta);
    }

    public double _method_for_rHat_sizey() {
        return 0.3 * Math.sin(this.theta);
    }

    public double _method_for_rHatLabel2_x() {
        return (0.3 + this.r) * Math.cos(this.theta) - 0.1;
    }

    public double _method_for_rHatLabel2_y() {
        return (0.3 + this.r) * Math.sin(this.theta);
    }

    public double _method_for_jHatLabel2_x() {
        return this.r * Math.cos(this.theta);
    }

    public double _method_for_jHatLabel2_y() {
        return this.r * Math.sin(this.theta) + 0.38;
    }

    public double _method_for_jHat_x() {
        return this.r * Math.cos(this.theta);
    }

    public double _method_for_jHat_y() {
        return this.r * Math.sin(this.theta);
    }

    public double _method_for_thetaHat_x() {
        return this.r * Math.cos(this.theta);
    }

    public double _method_for_thetaHat_y() {
        return this.r * Math.sin(this.theta);
    }

    public double _method_for_thetaHat_sizex() {
        return -0.3 * Math.sin(this.theta);
    }

    public double _method_for_thetaHat_sizey() {
        return 0.3 * Math.cos(this.theta);
    }

    public double _method_for_thetaHatLabel2_x() {
        return -0.3 * Math.sin(this.theta) - 0.1 + this.r * Math.cos(this.theta);
    }

    public double _method_for_thetaHatLabel2_y() {
        return 0.3 * Math.cos(this.theta) + this.r * Math.sin(this.theta) + 0.05;
    }

    public double _method_for_iHatLabel2_x() {
        return this.r * Math.cos(this.theta) + 0.38;
    }

    public double _method_for_iHatLabel2_y() {
        return this.r * Math.sin(this.theta);
    }

    public double _method_for_iHat_x() {
        return this.r * Math.cos(this.theta);
    }

    public double _method_for_iHat_y() {
        return this.r * Math.sin(this.theta);
    }

    public double _method_for_arrow_sizex() {
        return this.r * Math.cos(this.theta);
    }

    public double _method_for_arrow_sizey() {
        return this.r * Math.sin(this.theta);
    }

    public double _method_for_particle_x() {
        return this.r * Math.cos(this.theta);
    }

    public double _method_for_particle_y() {
        return this.r * Math.sin(this.theta);
    }

    public double _method_for_rHat2_x() {
        return this.r * Math.cos(this.theta2);
    }

    public double _method_for_rHat2_y() {
        return this.r * Math.sin(this.theta2);
    }

    public double _method_for_rHat2_sizex() {
        return 0.3 * Math.cos(this.theta2);
    }

    public double _method_for_rHat2_sizey() {
        return 0.3 * Math.sin(this.theta2);
    }

    public double _method_for_rHatLabel1_x() {
        return (0.3 + this.r) * Math.cos(this.theta2) + 0.1;
    }

    public double _method_for_rHatLabel1_y() {
        return (0.3 + this.r) * Math.sin(this.theta2);
    }

    public double _method_for_jHatLabel1_x() {
        return this.r * Math.cos(this.theta2);
    }

    public double _method_for_jHatLabel1_y() {
        return this.r * Math.sin(this.theta2) + 0.4;
    }

    public double _method_for_jHat2_x() {
        return this.r * Math.cos(this.theta2);
    }

    public double _method_for_jHat2_y() {
        return this.r * Math.sin(this.theta2);
    }

    public double _method_for_thetaHat2_x() {
        return this.r * Math.cos(this.theta2);
    }

    public double _method_for_thetaHat2_y() {
        return this.r * Math.sin(this.theta2);
    }

    public double _method_for_thetaHat2_sizex() {
        return -0.3 * Math.sin(this.theta2);
    }

    public double _method_for_thetaHat2_sizey() {
        return 0.3 * Math.cos(this.theta2);
    }

    public double _method_for_thetaHatLabel1_x() {
        return -0.3 * Math.sin(this.theta2) - 0.1 + this.r * Math.cos(this.theta2);
    }

    public double _method_for_thetaHatLabel1_y() {
        return 0.3 * Math.cos(this.theta2) + this.r * Math.sin(this.theta2);
    }

    public double _method_for_iHatLabel1_x() {
        return this.r * Math.cos(this.theta2) + 0.4;
    }

    public double _method_for_iHatLabel1_y() {
        return this.r * Math.sin(this.theta2);
    }

    public double _method_for_iHat2_x() {
        return this.r * Math.cos(this.theta2);
    }

    public double _method_for_iHat2_y() {
        return this.r * Math.sin(this.theta2);
    }

    public double _method_for_arrow2_sizex() {
        return this.r * Math.cos(this.theta2);
    }

    public double _method_for_arrow2_sizey() {
        return this.r * Math.sin(this.theta2);
    }

    public double _method_for_particle2_x() {
        return this.r * Math.cos(this.theta2);
    }

    public double _method_for_particle2_y() {
        return this.r * Math.sin(this.theta2);
    }

    public double _method_for_thetaTrace_x() {
        return 0.2 * Math.cos(this.theta);
    }

    public double _method_for_thetaTrace_y() {
        return 0.2 * Math.sin(this.theta);
    }

    public boolean _method_for_theta_visible() {
        return this._isPaused();
    }

    public boolean _method_for_theta1Label_visible() {
        return this._isPaused();
    }

    public void _method_for_twoStateButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_twoStateButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_rHat3_sizex() {
        return 0.3 * Math.cos(this.theta);
    }

    public double _method_for_rHat3_sizey() {
        return 0.3 * Math.sin(this.theta);
    }

    public double _method_for_rHat_Label_x() {
        return 0.3 * Math.cos(this.theta) - 0.1;
    }

    public double _method_for_rHat_Label_y() {
        return 0.3 * Math.sin(this.theta);
    }

    public double _method_for_thetaHat3_sizex() {
        return -0.3 * Math.sin(this.theta);
    }

    public double _method_for_thetaHat3_sizey() {
        return 0.3 * Math.cos(this.theta);
    }

    public double _method_for_thetaHat_Label_x() {
        return -0.3 * Math.sin(this.theta) - 0.1;
    }

    public double _method_for_thetaHat_Label_y() {
        return 0.3 * Math.cos(this.theta);
    }

    public boolean _method_for_iHat_Label_visible() {
        return this._isPaused();
    }

    public double _method_for_rHat22_sizex() {
        return 0.3 * Math.cos(this.theta2);
    }

    public double _method_for_rHat22_sizey() {
        return 0.3 * Math.sin(this.theta2);
    }

    public double _method_for_rHat2_Label_x() {
        return 0.3 * Math.cos(this.theta2) + 0.1;
    }

    public double _method_for_rHat2_Label_y() {
        return 0.3 * Math.sin(this.theta2) + 0.05;
    }

    public double _method_for_thetaHat22_sizex() {
        return -0.3 * Math.sin(this.theta2);
    }

    public double _method_for_thetaHat22_sizey() {
        return 0.3 * Math.cos(this.theta2);
    }

    public double _method_for_thetaHat2_Label_x() {
        return -0.3 * Math.sin(this.theta2) - 0.1;
    }

    public double _method_for_thetaHat2_Label_y() {
        return 0.3 * Math.cos(this.theta2);
    }

    public boolean _method_for_thetaHat2_Label_visible() {
        return this._isPaused();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.dt = 0.01;
        this.theta = 0.0;
        this.omega = 2.0;
        this.r = 0.5;
        this.theta2 = 0.0;
        this.omega2 = 2.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private EulerRichardson __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = UnitVectors.this.theta;
            this.__state[n++] = UnitVectors.this.theta2;
            this.__state[n++] = UnitVectors.this.t;
            this.__solver = new EulerRichardson(this);
            this.__solver.initialize(UnitVectors.this.dt);
        }

        void step() {
            if (UnitVectors.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(UnitVectors.this.dt);
            }
            int n = 0;
            this.__state[n++] = UnitVectors.this.theta;
            this.__state[n++] = UnitVectors.this.theta2;
            this.__state[n++] = UnitVectors.this.t;
            this.__solver.step();
            n = 0;
            UnitVectors.this.theta = this.__state[n++];
            UnitVectors.this.theta2 = this.__state[n++];
            UnitVectors.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            n = 0;
            dArray2[n++] = UnitVectors.this.omega;
            dArray2[n++] = UnitVectors.this.omega2;
            dArray2[n++] = 1.0;
        }
    }
}

