/*
 * Decompiled with CFR 0.152.
 */
package users.swarthmore.abug.RocketInSpace_pkg;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlImage;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveImage;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing2d.PlottingPanel2D;
import users.swarthmore.abug.RocketInSpace_pkg.RocketInSpace;
import users.swarthmore.abug.RocketInSpace_pkg.RocketInSpaceSimulation;

class RocketInSpaceView
extends EjsControl
implements View {
    private RocketInSpaceSimulation _simulation = null;
    private RocketInSpace _model = null;
    public Component Rocket_Equation;
    public DrawingPanel2D drawingPanel;
    public InteractiveImage background;
    public InteractiveImage flame;
    public InteractiveTrace trace;
    public InteractiveImage rocket;
    public JPanel settings;
    public JPanel fuelPanel;
    public JLabel fuelLabel;
    public JTextField Fuel_Mass;
    public JPanel buttons;
    public JButton Reset;
    public JButton twoStateButton;
    public JButton Step;
    public Component Position_Velocity_vs__Time;
    public PlottingPanel2D velocityTime;
    public InteractiveTrace position;
    public InteractiveTrace velocity;

    public RocketInSpaceView(RocketInSpaceSimulation rocketInSpaceSimulation, String string, Frame frame) {
        super(rocketInSpaceSimulation, string, frame);
        this._simulation = rocketInSpaceSimulation;
        this._model = (RocketInSpace)rocketInSpaceSimulation.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        if (SwingUtilities.isEventDispatchThread()) {
            this.createControl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        RocketInSpaceView.this.createControl();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("M", "apply(\"M\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("Mo", "apply(\"Mo\")");
        this.addListener("u", "apply(\"u\")");
        this.addListener("b", "apply(\"b\")");
        this.addListener("bActual", "apply(\"bActual\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("M".equals(string)) {
            this._model.M = this.getDouble("M");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("Mo".equals(string)) {
            this._model.Mo = this.getDouble("Mo");
        }
        if ("u".equals(string)) {
            this._model.u = this.getDouble("u");
        }
        if ("b".equals(string)) {
            this._model.b = this.getDouble("b");
        }
        if ("bActual".equals(string)) {
            this._model.bActual = this.getDouble("bActual");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("dt", this._model.dt);
        this.setValue("x", this._model.x);
        this.setValue("M", this._model.M);
        this.setValue("v", this._model.v);
        this.setValue("Mo", this._model.Mo);
        this.setValue("u", this._model.u);
        this.setValue("b", this._model.b);
        this.setValue("bActual", this._model.bActual);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Rocket_Equation = (Component)this.addElement(new ControlFrame(), "Rocket_Equation").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Rocket_Equation.title", "\"Rocket Equation\"")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "64,432").setProperty("size", this._simulation.translateString("View.Rocket_Equation.size", "\"529,379\"")).getObject();
        this.drawingPanel = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "drawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Rocket_Equation").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("maximumX", "3").setProperty("minimumY", "-1").setProperty("maximumY", "1").setProperty("square", "true").getObject();
        this.background = (InteractiveImage)this.addElement(new ControlImage(), "background").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("trueSize", "true").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.background.image", "./stars_ss_dx_org.jpg")).getObject();
        this.flame = (InteractiveImage)this.addElement(new ControlImage(), "flame").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_flame_x()%").setProperty("y", ".2").setProperty("sizex", "%_model._method_for_flame_sizex()%").setProperty("sizey", "1").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.flame.image", "./oval yellow flame copy.gif")).getObject();
        this.trace = (InteractiveTrace)this.addElement(new ControlTrace(), "trace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_trace_x()%").setProperty("y", "0.1").setProperty("skippoints", "3").setProperty("norepeat", "true").setProperty("connected", "false").setProperty("color", "YELLOW").setProperty("stroke", "1").setProperty("style", "ELLIPSE").setProperty("markersize", ".5").getObject();
        this.rocket = (InteractiveImage)this.addElement(new ControlImage(), "rocket").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_rocket_x()%").setProperty("y", "0").setProperty("sizex", ".5").setProperty("sizey", "1").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.rocket.image", "./rocket-ship-pepper-mill.gif")).getObject();
        this.settings = (JPanel)this.addElement(new ControlPanel(), "settings").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Rocket_Equation").setProperty("layout", "border").getObject();
        this.fuelPanel = (JPanel)this.addElement(new ControlPanel(), "fuelPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "settings").setProperty("layout", "FLOW:left,0,0").getObject();
        this.fuelLabel = (JLabel)this.addElement(new ControlLabel(), "fuelLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "fuelPanel").setProperty("text", this._simulation.translateString("View.fuelLabel.text", "\"Fuel Mass (kg) =\"")).getObject();
        this.Fuel_Mass = (JTextField)this.addElement(new ControlParsedNumberField(), "Fuel_Mass").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "fuelPanel").setProperty("variable", "%_model._method_for_Fuel_Mass_variable()%").setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Fuel_Mass.tooltip", "\"Fuel Mass\"")).getObject();
        this.buttons = (JPanel)this.addElement(new ControlPanel(), "buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "settings").setProperty("layout", "FLOW:left,0,0").getObject();
        this.Reset = (JButton)this.addElement(new ControlButton(), "Reset").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "buttons").setProperty("text", this._simulation.translateString("View.Reset.text", "Reset")).setProperty("action", "_model._method_for_Reset_action()").getObject();
        this.twoStateButton = (JButton)this.addElement(new ControlTwoStateButton(), "twoStateButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "buttons").setProperty("variable", "_isPaused").setProperty("textOn", this._simulation.translateString("View.twoStateButton.textOn", "Play")).setProperty("actionOn", "_model._method_for_twoStateButton_actionOn()").setProperty("textOff", this._simulation.translateString("View.twoStateButton.textOff", "Pause")).setProperty("actionOff", "_model._method_for_twoStateButton_actionOff()").getObject();
        this.Step = (JButton)this.addElement(new ControlButton(), "Step").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "buttons").setProperty("text", this._simulation.translateString("View.Step.text", "\"Step\"")).setProperty("action", "_model._method_for_Step_action()").getObject();
        this.Position_Velocity_vs__Time = (Component)this.addElement(new ControlFrame(), "Position_Velocity_vs__Time").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Position_Velocity_vs__Time.title", "\"X and V vs Time\"")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "47,26").setProperty("size", this._simulation.translateString("View.Position_Velocity_vs__Time.size", "\"362,371\"")).getObject();
        this.velocityTime = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "velocityTime").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Position_Velocity_vs__Time").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("x", "t").setProperty("y", "v").setProperty("title", this._simulation.translateString("View.velocityTime.title", "\"pos'n and veloc vs time\"")).setProperty("titleX", this._simulation.translateString("View.velocityTime.titleX", "\"Time\"")).setProperty("BLmessage", "Position / 10^1 km").setProperty("BRmessage", "Velocity in km/s").getObject();
        this.position = (InteractiveTrace)this.addElement(new ControlTrace(), "position").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "velocityTime").setProperty("x", "t").setProperty("y", "%_model._method_for_position_y()%").setProperty("active", "%_model._method_for_position_active()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("pressaction", "_model._method_for_position_pressaction()").setProperty("action", "_model._method_for_position_action()").setProperty("color", "GREEN").setProperty("stroke", "4").getObject();
        this.velocity = (InteractiveTrace)this.addElement(new ControlTrace(), "velocity").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "velocityTime").setProperty("x", "t").setProperty("y", "v").setProperty("active", "%_model._method_for_velocity_active()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("pressaction", "_model._method_for_velocity_pressaction()").setProperty("action", "_model._method_for_velocity_action()").setProperty("color", "RED").setProperty("stroke", "4").getObject();
    }

    public void reset() {
        this.getElement("Rocket_Equation").setProperty("title", this._simulation.translateString("View.Rocket_Equation.title", "\"Rocket Equation\"")).setProperty("visible", "true");
        this.getElement("drawingPanel").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("maximumX", "3").setProperty("minimumY", "-1").setProperty("maximumY", "1").setProperty("square", "true");
        this.getElement("background").setProperty("trueSize", "true").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.background.image", "./stars_ss_dx_org.jpg"));
        this.getElement("flame").setProperty("y", ".2").setProperty("sizey", "1").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.flame.image", "./oval yellow flame copy.gif"));
        this.getElement("trace").setProperty("y", "0.1").setProperty("skippoints", "3").setProperty("norepeat", "true").setProperty("connected", "false").setProperty("color", "YELLOW").setProperty("stroke", "1").setProperty("style", "ELLIPSE").setProperty("markersize", ".5");
        this.getElement("rocket").setProperty("y", "0").setProperty("sizex", ".5").setProperty("sizey", "1").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.rocket.image", "./rocket-ship-pepper-mill.gif"));
        this.getElement("settings");
        this.getElement("fuelPanel");
        this.getElement("fuelLabel").setProperty("text", this._simulation.translateString("View.fuelLabel.text", "\"Fuel Mass (kg) =\""));
        this.getElement("Fuel_Mass").setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Fuel_Mass.tooltip", "\"Fuel Mass\""));
        this.getElement("buttons");
        this.getElement("Reset").setProperty("text", this._simulation.translateString("View.Reset.text", "Reset"));
        this.getElement("twoStateButton").setProperty("textOn", this._simulation.translateString("View.twoStateButton.textOn", "Play")).setProperty("textOff", this._simulation.translateString("View.twoStateButton.textOff", "Pause"));
        this.getElement("Step").setProperty("text", this._simulation.translateString("View.Step.text", "\"Step\""));
        this.getElement("Position_Velocity_vs__Time").setProperty("title", this._simulation.translateString("View.Position_Velocity_vs__Time.title", "\"X and V vs Time\"")).setProperty("visible", "true");
        this.getElement("velocityTime").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("title", this._simulation.translateString("View.velocityTime.title", "\"pos'n and veloc vs time\"")).setProperty("titleX", this._simulation.translateString("View.velocityTime.titleX", "\"Time\"")).setProperty("BLmessage", "Position / 10^1 km").setProperty("BRmessage", "Velocity in km/s");
        this.getElement("position").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "GREEN").setProperty("stroke", "4");
        this.getElement("velocity").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "RED").setProperty("stroke", "4");
        super.reset();
    }
}

