/*
 * Decompiled with CFR 0.152.
 */
package users.swarthmore.abug.RocketInSpace_pkg;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.TranslatorUtilClass;
import org.colos.ejs.library.utils.VideoUtilClass;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.swarthmore.abug.RocketInSpace_pkg.RocketInSpace;
import users.swarthmore.abug.RocketInSpace_pkg.RocketInSpaceView;

class RocketInSpaceSimulation
extends Simulation {
    public RocketInSpaceSimulation(RocketInSpace rocketInSpace, String string, Frame frame, URL uRL, boolean bl) {
        this.translatorUtil = new TranslatorUtilClass(this);
        this.videoUtil = new VideoUtilClass();
        try {
            this.setUnderEjs("true".equals(System.getProperty("osp_ejs")));
        }
        catch (Exception exception) {
            this.setUnderEjs(false);
        }
        this.setCodebase(uRL);
        this.setModel(rocketInSpace);
        rocketInSpace._simulation = this;
        rocketInSpace._view = new RocketInSpaceView(this, string, frame);
        this.setView(rocketInSpace._view);
        if (rocketInSpace._isApplet()) {
            rocketInSpace._getApplet().captureWindow(rocketInSpace, "Rocket_Equation");
        }
        this.setFPS(20);
        this.setStepsPerDisplay(rocketInSpace._getStepsPerDisplay());
        if (bl) {
            this.setAutoplay(false);
            this.reset();
        } else {
            this.reset();
            this.setAutoplay(false);
        }
        this.addDescriptionPage("Intro Page", "RocketInSpace_Intro 1.html", 558, 345);
    }

    public ArrayList getWindowsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Rocket_Equation");
        arrayList.add("Position_Velocity_vs__Time");
        return arrayList;
    }

    public String getMainWindow() {
        return "Rocket_Equation";
    }

    protected void setViewLocale() {
        this.getView().getElement("Rocket_Equation").setProperty("title", this.translateString("View.Rocket_Equation.title", "\"Rocket Equation\"")).setProperty("size", this.translateString("View.Rocket_Equation.size", "\"529,379\""));
        this.getView().getElement("drawingPanel");
        this.getView().getElement("background").setProperty("image", this.translateString("View.background.image", "./stars_ss_dx_org.jpg"));
        this.getView().getElement("flame").setProperty("image", this.translateString("View.flame.image", "./oval yellow flame copy.gif"));
        this.getView().getElement("trace");
        this.getView().getElement("rocket").setProperty("image", this.translateString("View.rocket.image", "./rocket-ship-pepper-mill.gif"));
        this.getView().getElement("settings");
        this.getView().getElement("fuelPanel");
        this.getView().getElement("fuelLabel").setProperty("text", this.translateString("View.fuelLabel.text", "\"Fuel Mass (kg) =\""));
        this.getView().getElement("Fuel_Mass").setProperty("tooltip", this.translateString("View.Fuel_Mass.tooltip", "\"Fuel Mass\""));
        this.getView().getElement("buttons");
        this.getView().getElement("Reset").setProperty("text", this.translateString("View.Reset.text", "Reset"));
        this.getView().getElement("twoStateButton").setProperty("textOn", this.translateString("View.twoStateButton.textOn", "Play")).setProperty("textOff", this.translateString("View.twoStateButton.textOff", "Pause"));
        this.getView().getElement("Step").setProperty("text", this.translateString("View.Step.text", "\"Step\""));
        this.getView().getElement("Position_Velocity_vs__Time").setProperty("title", this.translateString("View.Position_Velocity_vs__Time.title", "\"X and V vs Time\"")).setProperty("size", this.translateString("View.Position_Velocity_vs__Time.size", "\"362,371\""));
        this.getView().getElement("velocityTime").setProperty("title", this.translateString("View.velocityTime.title", "\"pos'n and veloc vs time\"")).setProperty("titleX", this.translateString("View.velocityTime.titleX", "\"Time\""));
        this.getView().getElement("position");
        this.getView().getElement("velocity");
        super.setViewLocale();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }
}

