/*
 * Decompiled with CFR 0.152.
 */
package users.swarthmore.abug.RocketInSpace_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.tools.ResourceLoader;
import users.swarthmore.abug.RocketInSpace_pkg.RocketInSpaceSimulation;
import users.swarthmore.abug.RocketInSpace_pkg.RocketInSpaceView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RocketInSpace
extends AbstractModel {
    public RocketInSpaceSimulation _simulation = null;
    public RocketInSpaceView _view = null;
    public RocketInSpace _model = this;
    public double t = 0.0;
    public double dt = 0.1;
    public double x = 0.0;
    public double M = 1000.0;
    public double v = 0.0;
    public double Mo = 10000.0;
    public double u = 3.0;
    public double b = 100.0;
    public double bActual;
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/swarthmore/abug/RocketInSpace.xml";
    }

    public static String _getModelDirectory() {
        return "users/swarthmore/abug/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/swarthmore/abug/rocket-ship-pepper-mill.gif");
        hashSet.add("users/swarthmore/abug/stars_ss_dx_org.jpg");
        hashSet.add("users/swarthmore/abug/oval yellow flame copy.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/swarthmore/abug/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
        }
        RocketInSpace rocketInSpace = new RocketInSpace(stringArray);
    }

    public RocketInSpace() {
        this(null, null, null, null, null, false);
    }

    public RocketInSpace(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public RocketInSpace(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new RocketInSpaceSimulation(this, string, frame, uRL, bl);
        this._view = (RocketInSpaceView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _constraints1() {
        this.bActual = this.M < 0.0 ? 0.0 : this.b;
    }

    public double _method_for_flame_x() {
        return this.x - 4.15;
    }

    public double _method_for_flame_sizex() {
        return this.v * 0.002;
    }

    public double _method_for_trace_x() {
        return this.x - 4.0;
    }

    public double _method_for_rocket_x() {
        return this.x - 4.0;
    }

    public double _method_for_Fuel_Mass_variable() {
        return Math.max(this.M, 0.0);
    }

    public void _method_for_Reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_twoStateButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_twoStateButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Step_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public double _method_for_position_y() {
        return this.x / 10.0;
    }

    public boolean _method_for_position_active() {
        return this._isPlaying();
    }

    public void _method_for_position_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_position_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public boolean _method_for_velocity_active() {
        return this._isPlaying();
    }

    public void _method_for_velocity_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_velocity_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.dt = 0.1;
        this.x = 0.0;
        this.M = 1000.0;
        this.v = 0.0;
        this.Mo = 10000.0;
        this.u = 3.0;
        this.b = 100.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private EulerRichardson __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = RocketInSpace.this.v;
            this.__state[n++] = RocketInSpace.this.x;
            this.__state[n++] = RocketInSpace.this.M;
            this.__state[n++] = RocketInSpace.this.t;
            this.__solver = new EulerRichardson(this);
            this.__solver.initialize(RocketInSpace.this.dt);
        }

        void step() {
            if (RocketInSpace.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(RocketInSpace.this.dt);
            }
            int n = 0;
            this.__state[n++] = RocketInSpace.this.v;
            this.__state[n++] = RocketInSpace.this.x;
            this.__state[n++] = RocketInSpace.this.M;
            this.__state[n++] = RocketInSpace.this.t;
            this.__solver.step();
            n = 0;
            RocketInSpace.this.v = this.__state[n++];
            RocketInSpace.this.x = this.__state[n++];
            RocketInSpace.this.M = this.__state[n++];
            RocketInSpace.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            n = 0;
            dArray2[n++] = RocketInSpace.this.u * RocketInSpace.this.bActual / (d3 + RocketInSpace.this.Mo);
            dArray2[n++] = d;
            dArray2[n++] = -RocketInSpace.this.bActual;
            dArray2[n++] = 1.0;
        }
    }
}

