/*
 * Decompiled with CFR 0.152.
 */
package users.swarthmore.abug.Polars4_RCCorTang_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.tools.ResourceLoader;
import users.swarthmore.abug.Polars4_RCCorTang_pkg.Polars4_RCCorTangSimulation;
import users.swarthmore.abug.Polars4_RCCorTang_pkg.Polars4_RCCorTangView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polars4_RCCorTang
extends AbstractModel {
    public Polars4_RCCorTangSimulation _simulation = null;
    public Polars4_RCCorTangView _view = null;
    public Polars4_RCCorTang _model = this;
    public double t = 0.0;
    public double dt = 0.01;
    public double x;
    public double y;
    public double r = 0.0;
    public double rDot = 0.0;
    public double rDDot = 0.0;
    public double theta;
    public double omega = 0.0;
    public double alpha = 0.0;
    public double arad = 0.0;
    public double acent = 0.0;
    public double atan = 0.0;
    public double acor = 0.0;
    public double radAccX = 0.0;
    public double radAccY = 0.0;
    public double cenAccX = 0.0;
    public double cenAccY = 0.0;
    public double tanAccX = 0.0;
    public double tanAccY = 0.0;
    public double corAccX = 0.0;
    public double corAccY = 0.0;
    public boolean tooBig;
    public boolean useR;
    public boolean useTheta;
    public boolean yesRadial = false;
    public boolean yesCentripetal = false;
    public boolean yesTangential = false;
    public boolean yesCoriolis = false;
    public boolean yesCentTangCori = false;
    public boolean yesAllFour = false;
    public boolean yesJustCentripetal = false;
    public boolean yesRadiCentCori = false;
    public boolean yesJustRadial = false;
    public boolean yesCentCori = false;
    public boolean yesCentTang = false;
    public boolean checkCentripetal = false;
    public boolean checkCoriolis = false;
    public boolean checkRadial = false;
    public boolean checkTangential = false;
    public boolean errorCondition = false;
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 3;
    }

    public static String _getEjsModel() {
        return "users/swarthmore/abug/Polars4_RCCorTang.xml";
    }

    public static String _getModelDirectory() {
        return "users/swarthmore/abug/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/mathCharacters/thetaHat.gif");
        hashSet.add("users/jentrinh/Chapter_1/mathCharacters/rDDot.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/theta.gif");
        hashSet.add("users/mathCharacters/rHat.gif");
        hashSet.add("users/jentrinh/Chapter_1/mathCharacters/thetaDot.gif");
        hashSet.add("users/jentrinh/Chapter_1/mathCharacters/rDot.gif");
        hashSet.add("users/jentrinh/Chapter_1/mathCharacters/theta.gif");
        hashSet.add("users/jentrinh/Chapter_1/mathCharacters/thetaDDot.gif");
        hashSet.add("users/swarthmore/abug/mathCharacters/r.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/swarthmore/abug/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
        }
        Polars4_RCCorTang polars4_RCCorTang = new Polars4_RCCorTang(stringArray);
    }

    public Polars4_RCCorTang() {
        this(null, null, null, null, null, false);
    }

    public Polars4_RCCorTang(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Polars4_RCCorTang(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new Polars4_RCCorTangSimulation(this, string, frame, uRL, bl);
        this._view = (Polars4_RCCorTangView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.errorCondition = false;
    }

    public void _constraints1() {
        this.x = this.r * Math.cos(this.theta);
        this.y = this.r * Math.sin(this.theta);
        this.arad = this.rDDot;
        this.acent = -this.r * this.omega * this.omega;
        this.atan = this.r * this.alpha;
        this.acor = 2.0 * this.rDot * this.omega;
        this.radAccX = this.arad * Math.cos(this.theta);
        this.radAccY = this.arad * Math.sin(this.theta);
        this.cenAccX = this.acent * Math.cos(this.theta);
        this.cenAccY = this.acent * Math.sin(this.theta);
        this.tanAccX = -this.atan * Math.sin(this.theta);
        this.tanAccY = this.atan * Math.cos(this.theta);
        this.corAccX = -this.acor * Math.sin(this.theta);
        this.corAccY = this.acor * Math.cos(this.theta);
    }

    public void _constraints2() {
        boolean bl = this.tooBig = this.r > 20.0;
        if (this.tooBig) {
            this._pause();
        }
        this.useR = false;
        this.useTheta = false;
        this.errorCondition = true;
        if (this.checkRadial && !this.checkCentripetal && !this.checkCoriolis && !this.checkTangential) {
            this.useTheta = true;
            this.radial();
            this.errorCondition = false;
        }
        if (!this.checkRadial && this.checkCentripetal && !this.checkCoriolis && !this.checkTangential) {
            this.useR = true;
            this.centripetal();
            this.errorCondition = false;
        }
        if (!this.checkRadial && this.checkCentripetal && this.checkCoriolis && !this.checkTangential) {
            this.centCori();
            this.errorCondition = false;
        }
        if (this.checkRadial && this.checkCentripetal && this.checkCoriolis && !this.checkTangential) {
            this.radiCentCori();
            this.errorCondition = false;
        }
        if (!this.checkRadial && this.checkCentripetal && !this.checkCoriolis && this.checkTangential) {
            this.centTang();
            this.errorCondition = false;
        }
        if (!this.checkRadial && this.checkCentripetal && this.checkCoriolis && this.checkTangential) {
            this.centTangCori();
            this.errorCondition = false;
        }
        if (this.checkRadial && this.checkCentripetal && this.checkCoriolis && this.checkTangential) {
            this.allFour();
            this.errorCondition = false;
        }
        if (!(this.checkRadial || this.checkCentripetal || this.checkCoriolis || this.checkTangential)) {
            this.errorCondition = false;
        }
        if (this.errorCondition) {
            this.zeroUsOut();
            this.errorMessage();
            this._pause();
        }
    }

    public void restart() {
        this.r = 0.2;
        this.theta = 0.0;
        this._reset();
    }

    public void zeroUsOut() {
        this.rDot = 0.0;
        this.rDDot = 0.0;
        this.alpha = 0.0;
        this.omega = 0.0;
    }

    public void errorMessage() {
        this.errorCondition = true;
    }

    public void allFour() {
        this.rDDot = 0.4;
        this.alpha = 0.4;
    }

    public void centTang() {
        this.alpha = 0.4;
        this.rDDot = 0.0;
        this.rDot = 0.0;
    }

    public void centCori() {
        this.rDot = 0.4;
        this.omega = 0.4;
        this.alpha = 0.0;
        this.rDDot = 0.0;
    }

    public void centTangCori() {
        this.rDot = 0.4;
        this.rDDot = 0.0;
        this.alpha = 0.4;
    }

    public void radial() {
        this.rDDot = 0.4;
        this.alpha = 0.0;
        this.omega = 0.0;
    }

    public void radiCentCori() {
        this.rDDot = 0.4;
        this.omega = 0.4;
        this.alpha = 0.0;
    }

    public void centripetal() {
        this.omega = 0.4;
        this.rDDot = 0.0;
        this.alpha = 0.0;
        this.rDot = 0.0;
    }

    public void _method_for_twoStateButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_twoStateButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Reset_action() {
        this._simulation.disableLoop();
        this._pause();
        this.restart();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_radialAcceleration_actionon() {
        this._simulation.disableLoop();
        this.checkRadial = true;
        this._simulation.enableLoop();
    }

    public void _method_for_radialAcceleration_actionoff() {
        this._simulation.disableLoop();
        this.checkRadial = false;
        this._simulation.enableLoop();
    }

    public void _method_for_centripetalAcceleration_actionon() {
        this._simulation.disableLoop();
        this.checkCentripetal = true;
        this._simulation.enableLoop();
    }

    public void _method_for_centripetalAcceleration_actionoff() {
        this._simulation.disableLoop();
        this.checkCentripetal = false;
        this._simulation.enableLoop();
    }

    public void _method_for_tangentialAcceleration_actionon() {
        this._simulation.disableLoop();
        this.checkTangential = true;
        this._simulation.enableLoop();
    }

    public void _method_for_tangentialAcceleration_actionoff() {
        this._simulation.disableLoop();
        this.checkTangential = false;
        this._simulation.enableLoop();
    }

    public boolean _method_for_CoriolisAcceleration_variable() {
        return this.checkCoriolis;
    }

    public void _method_for_CoriolisAcceleration_actionon() {
        this._simulation.disableLoop();
        this.checkCoriolis = true;
        this._simulation.enableLoop();
    }

    public void _method_for_CoriolisAcceleration_actionoff() {
        this._simulation.disableLoop();
        this.checkCoriolis = false;
        this._simulation.enableLoop();
    }

    public double _method_for_theta_maximum() {
        return Math.PI * 2;
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.dt = 0.01;
        this.r = 0.0;
        this.rDot = 0.0;
        this.rDDot = 0.0;
        this.omega = 0.0;
        this.alpha = 0.0;
        this.arad = 0.0;
        this.acent = 0.0;
        this.atan = 0.0;
        this.acor = 0.0;
        this.radAccX = 0.0;
        this.radAccY = 0.0;
        this.cenAccX = 0.0;
        this.cenAccY = 0.0;
        this.tanAccX = 0.0;
        this.tanAccY = 0.0;
        this.corAccX = 0.0;
        this.corAccY = 0.0;
        this.yesRadial = false;
        this.yesCentripetal = false;
        this.yesTangential = false;
        this.yesCoriolis = false;
        this.yesCentTangCori = false;
        this.yesAllFour = false;
        this.yesJustCentripetal = false;
        this.yesRadiCentCori = false;
        this.yesJustRadial = false;
        this.yesCentCori = false;
        this.yesCentTang = false;
        this.checkCentripetal = false;
        this.checkCoriolis = false;
        this.checkRadial = false;
        this.checkTangential = false;
        this.errorCondition = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private EulerRichardson __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Polars4_RCCorTang.this.theta;
            this.__state[n++] = Polars4_RCCorTang.this.omega;
            this.__state[n++] = Polars4_RCCorTang.this.r;
            this.__state[n++] = Polars4_RCCorTang.this.rDot;
            this.__state[n++] = Polars4_RCCorTang.this.t;
            this.__solver = new EulerRichardson(this);
            this.__solver.initialize(Polars4_RCCorTang.this.dt);
        }

        void step() {
            if (Polars4_RCCorTang.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Polars4_RCCorTang.this.dt);
            }
            int n = 0;
            this.__state[n++] = Polars4_RCCorTang.this.theta;
            this.__state[n++] = Polars4_RCCorTang.this.omega;
            this.__state[n++] = Polars4_RCCorTang.this.r;
            this.__state[n++] = Polars4_RCCorTang.this.rDot;
            this.__state[n++] = Polars4_RCCorTang.this.t;
            this.__solver.step();
            n = 0;
            Polars4_RCCorTang.this.theta = this.__state[n++];
            Polars4_RCCorTang.this.omega = this.__state[n++];
            Polars4_RCCorTang.this.r = this.__state[n++];
            Polars4_RCCorTang.this.rDot = this.__state[n++];
            Polars4_RCCorTang.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            n = 0;
            dArray2[n++] = d2;
            dArray2[n++] = Polars4_RCCorTang.this.alpha;
            dArray2[n++] = d4;
            dArray2[n++] = Polars4_RCCorTang.this.rDDot;
            dArray2[n++] = 1.0;
        }
    }
}

