/*
 * Decompiled with CFR 0.152.
 */
package users.swarthmore.abug.FreightCar_pkg;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlImage;
import org.colos.ejs.library.control.displayejs.ControlImageSet;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlRadioButton;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveImage;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing2d.PlottingPanel2D;
import users.swarthmore.abug.FreightCar_pkg.FreightCar;
import users.swarthmore.abug.FreightCar_pkg.FreightCarSimulation;

class FreightCarView
extends EjsControl
implements View {
    private FreightCarSimulation _simulation = null;
    private FreightCar _model = null;
    public Component frame;
    public DrawingPanel2D drawingPanel;
    public InteractiveImage background;
    public ElementSet sand;
    public InteractiveImage sandOnCar;
    public InteractiveImage pusher;
    public InteractiveParticle car;
    public InteractiveParticle wheelR;
    public InteractiveParticle wheelL;
    public InteractiveArrow velocity;
    public JPanel controlPanel;
    public JButton twoStateButton;
    public JButton reset;
    public JButton step;
    public JRadioButton BrainTeaser;
    public Component graph;
    public PlottingPanel2D timeVersusVelocity;
    public InteractiveTrace trace;
    public InteractiveTrace WrongAnalyticalSolution;
    public InteractiveTrace AnalyticalSolution;

    public FreightCarView(FreightCarSimulation freightCarSimulation, String string, Frame frame) {
        super(freightCarSimulation, string, frame);
        this._simulation = freightCarSimulation;
        this._model = (FreightCar)freightCarSimulation.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        if (SwingUtilities.isEventDispatchThread()) {
            this.createControl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FreightCarView.this.createControl();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("m", "apply(\"m\")");
        this.addListener("TM", "apply(\"TM\")");
        this.addListener("omega", "apply(\"omega\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("M", "apply(\"M\")");
        this.addListener("b", "apply(\"b\")");
        this.addListener("F", "apply(\"F\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("bt", "apply(\"bt\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("m".equals(string)) {
            this._model.m = this.getDouble("m");
        }
        if ("TM".equals(string)) {
            this._model.TM = this.getDouble("TM");
        }
        if ("omega".equals(string)) {
            this._model.omega = this.getDouble("omega");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("M".equals(string)) {
            this._model.M = this.getDouble("M");
        }
        if ("b".equals(string)) {
            this._model.b = this.getDouble("b");
        }
        if ("F".equals(string)) {
            this._model.F = this.getDouble("F");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("bt".equals(string)) {
            this._model.bt = this.getBoolean("bt");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("dt", this._model.dt);
        this.setValue("m", this._model.m);
        this.setValue("TM", this._model.TM);
        this.setValue("omega", this._model.omega);
        this.setValue("v", this._model.v);
        this.setValue("M", this._model.M);
        this.setValue("b", this._model.b);
        this.setValue("F", this._model.F);
        this.setValue("x", this._model.x);
        this.setValue("bt", this._model.bt);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.frame = (Component)this.addElement(new ControlFrame(), "frame").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.frame.title", "\"Freight Car (3.10)\"")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "16,257").setProperty("size", this._simulation.translateString("View.frame.size", "\"949,476\"")).getObject();
        this.drawingPanel = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "drawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "frame").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-.5").setProperty("maximumX", "5").setProperty("minimumY", "1").setProperty("maximumY", "1").setProperty("square", "true").setProperty("BRmessage", "%_model._method_for_drawingPanel_BRmessage()%").getObject();
        this.background = (InteractiveImage)this.addElement(new ControlImage(), "background").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", ".3").setProperty("y", ".4").setProperty("sizex", "10").setProperty("sizey", "6").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.background.image", "./happyLand.jpeg")).getObject();
        this.sand = (ElementSet)this.addElement(new ControlImageSet(), "sand").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "x").setProperty("y", "1.2").setProperty("sizex", ".4").setProperty("sizey", "2.5").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.sand.image", "./fallingSand.gif")).getObject();
        this.sandOnCar = (InteractiveImage)this.addElement(new ControlImage(), "sandOnCar").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "x").setProperty("y", "0.1").setProperty("sizex", ".45").setProperty("sizey", "%_model._method_for_sandOnCar_sizey()%").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.sandOnCar.image", "./sandPile.gif")).getObject();
        this.pusher = (InteractiveImage)this.addElement(new ControlImage(), "pusher").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_pusher_x()%").setProperty("y", "0").setProperty("sizex", ".4").setProperty("sizey", ".5").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.pusher.image", "./push2.gif")).getObject();
        this.car = (InteractiveParticle)this.addElement(new ControlParticle(), "car").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "x").setProperty("y", "0").setProperty("sizex", ".5").setProperty("sizey", ".2").setProperty("enabled", "true").setProperty("style", "ROUND_RECTANGLE").setProperty("secondaryColor", "64,64,0").setProperty("color", "64,64,0").getObject();
        this.wheelR = (InteractiveParticle)this.addElement(new ControlParticle(), "wheelR").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_wheelR_x()%").setProperty("y", "-.1").setProperty("enabled", "true").setProperty("style", "WHEEL").setProperty("angle", "%_model._method_for_wheelR_angle()%").setProperty("color", "NO_FILL").getObject();
        this.wheelL = (InteractiveParticle)this.addElement(new ControlParticle(), "wheelL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_wheelL_x()%").setProperty("y", "-.1").setProperty("enabled", "true").setProperty("style", "WHEEL").setProperty("angle", "%_model._method_for_wheelL_angle()%").setProperty("color", "NO_FILL").getObject();
        this.velocity = (InteractiveArrow)this.addElement(new ControlArrow(), "velocity").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_velocity_x()%").setProperty("y", ".1").setProperty("sizex", "%_model._method_for_velocity_sizex()%").setProperty("sizey", "0").setProperty("enabled", "true").setProperty("color", "RED").setProperty("secondaryColor", "RED").setProperty("stroke", "1.3").getObject();
        this.controlPanel = (JPanel)this.addElement(new ControlPanel(), "controlPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "frame").setProperty("layout", "GRID:1,3,0,0").getObject();
        this.twoStateButton = (JButton)this.addElement(new ControlTwoStateButton(), "twoStateButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "controlPanel").setProperty("variable", "_isPaused").setProperty("textOn", this._simulation.translateString("View.twoStateButton.textOn", "Play")).setProperty("actionOn", "_model._method_for_twoStateButton_actionOn()").setProperty("textOff", this._simulation.translateString("View.twoStateButton.textOff", "Pause")).setProperty("actionOff", "_model._method_for_twoStateButton_actionOff()").getObject();
        this.reset = (JButton)this.addElement(new ControlButton(), "reset").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "controlPanel").setProperty("text", this._simulation.translateString("View.reset.text", "\"Reset\"")).setProperty("action", "_model._method_for_reset_action()").getObject();
        this.step = (JButton)this.addElement(new ControlButton(), "step").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "controlPanel").setProperty("text", this._simulation.translateString("View.step.text", "\"Step\"")).setProperty("action", "_model._method_for_step_action()").getObject();
        this.BrainTeaser = (JRadioButton)this.addElement(new ControlRadioButton(), "BrainTeaser").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controlPanel").setProperty("text", this._simulation.translateString("View.BrainTeaser.text", "\"Brain Teaser\"")).setProperty("actionon", "_model._method_for_BrainTeaser_actionon()").setProperty("actionoff", "_model._method_for_BrainTeaser_actionoff()").getObject();
        this.graph = (Component)this.addElement(new ControlFrame(), "graph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.graph.title", "\"Velocity as a Function of Time\"")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "-1,22").setProperty("size", this._simulation.translateString("View.graph.size", "300,300")).getObject();
        this.timeVersusVelocity = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "timeVersusVelocity").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "graph").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "0").setProperty("minimumY", "0").setProperty("x", "t").setProperty("y", "v").setProperty("title", this._simulation.translateString("View.timeVersusVelocity.title", "\"V(t)\"")).setProperty("titleX", this._simulation.translateString("View.timeVersusVelocity.titleX", "\"Time\"")).setProperty("titleY", this._simulation.translateString("View.timeVersusVelocity.titleY", "\"Velocity\"")).getObject();
        this.trace = (InteractiveTrace)this.addElement(new ControlTrace(), "trace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "timeVersusVelocity").setProperty("x", "t").setProperty("y", "v").setProperty("skippoints", "8").setProperty("norepeat", "true").setProperty("connected", "false").setProperty("color", "BLACK").setProperty("stroke", "2").setProperty("style", "ELLIPSE").setProperty("markersize", "2").getObject();
        this.WrongAnalyticalSolution = (InteractiveTrace)this.addElement(new ControlTrace(), "WrongAnalyticalSolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "timeVersusVelocity").setProperty("x", "t").setProperty("y", "%_model._method_for_WrongAnalyticalSolution_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "bt").setProperty("color", "RED").getObject();
        this.AnalyticalSolution = (InteractiveTrace)this.addElement(new ControlTrace(), "AnalyticalSolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "timeVersusVelocity").setProperty("x", "t").setProperty("y", "%_model._method_for_AnalyticalSolution_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "Blue").setProperty("stroke", "1").getObject();
    }

    public void reset() {
        this.getElement("frame").setProperty("title", this._simulation.translateString("View.frame.title", "\"Freight Car (3.10)\"")).setProperty("visible", "true");
        this.getElement("drawingPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-.5").setProperty("maximumX", "5").setProperty("minimumY", "1").setProperty("maximumY", "1").setProperty("square", "true");
        this.getElement("background").setProperty("x", ".3").setProperty("y", ".4").setProperty("sizex", "10").setProperty("sizey", "6").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.background.image", "./happyLand.jpeg"));
        this.getElement("sand").setProperty("y", "1.2").setProperty("sizex", ".4").setProperty("sizey", "2.5").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.sand.image", "./fallingSand.gif"));
        this.getElement("sandOnCar").setProperty("y", "0.1").setProperty("sizex", ".45").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.sandOnCar.image", "./sandPile.gif"));
        this.getElement("pusher").setProperty("y", "0").setProperty("sizex", ".4").setProperty("sizey", ".5").setProperty("enabled", "true").setProperty("image", this._simulation.translateString("View.pusher.image", "./push2.gif"));
        this.getElement("car").setProperty("y", "0").setProperty("sizex", ".5").setProperty("sizey", ".2").setProperty("enabled", "true").setProperty("style", "ROUND_RECTANGLE").setProperty("secondaryColor", "64,64,0").setProperty("color", "64,64,0");
        this.getElement("wheelR").setProperty("y", "-.1").setProperty("enabled", "true").setProperty("style", "WHEEL");
        this.getElement("wheelL").setProperty("y", "-.1").setProperty("enabled", "true").setProperty("style", "WHEEL");
        this.getElement("velocity").setProperty("y", ".1").setProperty("sizey", "0").setProperty("enabled", "true").setProperty("color", "RED").setProperty("secondaryColor", "RED").setProperty("stroke", "1.3");
        this.getElement("controlPanel");
        this.getElement("twoStateButton").setProperty("textOn", this._simulation.translateString("View.twoStateButton.textOn", "Play")).setProperty("textOff", this._simulation.translateString("View.twoStateButton.textOff", "Pause"));
        this.getElement("reset").setProperty("text", this._simulation.translateString("View.reset.text", "\"Reset\""));
        this.getElement("step").setProperty("text", this._simulation.translateString("View.step.text", "\"Step\""));
        this.getElement("BrainTeaser").setProperty("text", this._simulation.translateString("View.BrainTeaser.text", "\"Brain Teaser\""));
        this.getElement("graph").setProperty("title", this._simulation.translateString("View.graph.title", "\"Velocity as a Function of Time\"")).setProperty("visible", "true");
        this.getElement("timeVersusVelocity").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "0").setProperty("minimumY", "0").setProperty("title", this._simulation.translateString("View.timeVersusVelocity.title", "\"V(t)\"")).setProperty("titleX", this._simulation.translateString("View.timeVersusVelocity.titleX", "\"Time\"")).setProperty("titleY", this._simulation.translateString("View.timeVersusVelocity.titleY", "\"Velocity\""));
        this.getElement("trace").setProperty("skippoints", "8").setProperty("norepeat", "true").setProperty("connected", "false").setProperty("color", "BLACK").setProperty("stroke", "2").setProperty("style", "ELLIPSE").setProperty("markersize", "2");
        this.getElement("WrongAnalyticalSolution").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "RED");
        this.getElement("AnalyticalSolution").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "Blue").setProperty("stroke", "1");
        super.reset();
    }
}

